from __future__ import print_function
from pySecDec.integral_interface import IntegralLibrary
import sympy as sp

if __name__ == "__main__":

    # load c++ library
    triangle2L = IntegralLibrary('triangle2L/triangle2L_pylink.so')

    # choose integrator
    triangle2L.use_Vegas(flags=2) # ``flags=2``: verbose --> see Cuba manual

    # integrate
    str_integral_without_prefactor, str_prefactor, str_integral_with_prefactor = triangle2L(real_parameters=[9.0],complex_parameters=[1.0])

    # convert complex numbers from c++ to sympy notation
    str_integral_with_prefactor = str_integral_with_prefactor.replace(',','+I*')
    str_prefactor = str_prefactor.replace(',','+I*')
    str_integral_without_prefactor = str_integral_without_prefactor.replace(',','+I*')

    # convert result to sympy expressions
    integral_with_prefactor = sp.sympify(str_integral_with_prefactor.replace('+/-','*value+error*'))
    integral_with_prefactor_err = sp.sympify(str_integral_with_prefactor.replace('+/-','*value+error*'))
    prefactor = sp.sympify(str_prefactor)
    integral_without_prefactor = sp.sympify(str_integral_without_prefactor.replace('+/-','*value+error*'))
    integral_without_prefactor_err = sp.sympify(str_integral_without_prefactor.replace('+/-','*value+error*'))

    # examples how to access individual orders
    print('Numerical Result')
    print('eps^-2:', integral_with_prefactor.coeff('eps',-2).coeff('value'), '+/- (', integral_with_prefactor_err.coeff('eps',-2).coeff('error'), ')')
    print('eps^-1:', integral_with_prefactor.coeff('eps',-1).coeff('value'), '+/- (', integral_with_prefactor_err.coeff('eps',-1).coeff('error'), ')')
    print('eps^0 :', integral_with_prefactor.coeff('eps',0).coeff('value'), '+/- (', integral_with_prefactor_err.coeff('eps',0).coeff('error'), ')')

    # result from pySecDec paper Table 1 arXiv:1703.09692v2
    print('Result from pySecDec paper:')
    print('eps^-2: -0.0379735-I*0.0747738 +- (0.000375449+I*0.000695892)')
    print('eps^-1: 0.2812615+I*0.1738216) +- (0.003117778+I*0.002358655)')
    print('eps^0 : -1.03936733+I*0.2414135) +- (0.011940978+I*0.004604699)')
