#include color.h

symbol d, Nf, SumQf, SumQf2, Nt, SumQt, SumQt2, Na, Nc, Ca, Cf, Tf, Xi, I, BID;
symbol FAIL;

auto symbol m, g, sqr, DEN;

auto symbol tmpx;

auto index lor = d;
auto index fun = Nc;
auto index adj = Na;
auto index spn = FAIL;
auto index flv = FAIL;
auto vector p, q, l, tmpvec;

cFunction delta, momentum, sp, colorf, colorT, den, deltaf, deltaft, chargeQ, chargeQt, gamma, slash, gammachain, gammatrace, B;

unitTrace 4;

* Preprocess the input, if needed. Call this first.
#procedure input
    id I = i_;
#endprocedure

* Postprocess the output, if needed. Call this last, just before saving.
#procedure output
    id d_(lor1?, lor2?) = delta(lor1, lor2);
    id i_ = I;
    id p1?.p2? = sp(p1, p2);
*    bracket EX,B;
    .sort:output;
#endprocedure

* Save a given expression to a Mathematica file.
#procedure saveto(expr, file)
    format Mathematica;
    format nospaces;
    format 78;
    #write <`file'> "(\n      %E\n)" `expr';
    #close <`file'>
#endprocedure

#procedure applydeltas
    id delta(lor1?, lor2?) = d_(lor1, lor2);
    .sort:applydeltas;
#endprocedure

#procedure colorsum
    id colorT(?adj, lor1?, lor2?) = T(lor1, lor2, ?adj);
    id colorf(?adj) = f(?adj);
    #call docolor
    id cA = Ca;
    id cR = Cf;
    id I2R = Tf;
    id NA = Na;
    id NR = Nc;
    id d33(cOlpR1?, cOlpR2?) = d33;
    id d44(cOlpR1?, cOlpR2?) = d44;
    id T(fun1?, fun2?, ?adj) = colorT(?adj, fun1, fun2);
    id f(adj1?, adj2?, adj3?) = colorf(adj1, adj2, adj3);
    .sort:colorsum;
#endprocedure

#procedure flavorsum
    repeat id deltaf(flv1?, flv?)*deltaf(flv?, flv2?) = deltaf(flv1, flv2)*replace_(flv, flv1);
    id deltaf(flv?, flv?)*chargeQ(flv?)^2 = SumQf2;
    id deltaf(flv?, flv?)*chargeQ(flv?) = SumQf;
    id deltaf(flv?, flv?) = Nf;

    repeat id deltaft(flv1?, flv?)*deltaft(flv?, flv2?) = deltaft(flv1, flv2)*replace_(flv, flv1);
    id deltaft(flv?, flv?)*chargeQt(flv?)^2 = SumQt2;
    id deltaft(flv?, flv?)*chargeQt(flv?) = SumQt;
    id deltaft(flv?, flv?) = Nt;

    if (match(deltaf(tmpx1?, tmpx2?)) || match(deltaft(tmpx1?, tmpx2?)) || match(chargeQ(?x)) || match(chargeQt(?x)));
      exit "ERROR: flavor sum: leftover flavors?";
    endif;

    .sort:flavorsum;
#endprocedure

#define MaxGammaTracesPerTerm "5"

#procedure diracsum
    repeat id gammachain(?x1, spn1?, spn?)*gammachain(?x2, spn?, spn2?) = gammachain(?x1, ?x2, spn1, spn2);
    id gammachain(?x, spn?, spn?) = gammatrace(?x);

    argument gammatrace;
        argToExtraSymbol tonumber slash,1;
    endargument;

    .sort:diracsum-after-extrasymbols;

    #write "*** unique slashed momenta combinations: `EXTRASYMBOLS_'"
    #write "%X"

    argument gammatrace;
        #do i=1,`EXTRASYMBOLS_'
            id slash(`i') = tmpvec`i';
        #enddo
        id gamma(lor?) = lor;
    endargument;

    #do i = 1, `MaxGammaTracesPerTerm'
        id once gammatrace(?x) = g_(`i', ?x);
    #enddo

    #do i = 1, `MaxGammaTracesPerTerm'
        traceN `i';
    #enddo

    if (match(gammatrace(?x)));
      exit "ERROR: diractrace: leftover gammatrace() at the end; is MaxGammaTracesPerTerm too small?";
    endif;

    id p1?.p2? = sp(p1, p2);
    id p1?(lor1?) = momentum(p1, lor1);
    id momentum(p1?, p2?) = sp(p1, p2);
    argument momentum, sp;
        #do i=1,`EXTRASYMBOLS_'
            id tmpvec`i' = extrasymbol_(`i');
        #enddo
    endargument;
    print;

    .sort:diracsum-after-traceN;

    delete extrasymbols;
#endprocedure

#procedure contractmomenta
    repeat;
        id momentum(p1?, lor?)*momentum(p2?, lor?) = sp(p1, p2);
        id momentum(p1?, lor?)^2 = sp(p1, p1);
        id momentum(p1?, p2?) = sp(p1, p2);
    endrepeat;
#endprocedure

#procedure toB(toBIDandDEN, ndens)
    id sp(p1?, p2?) = p1.p2;
    #call `toBIDandDEN'
    id BID^tmpx0? * <DEN1^tmpx1?> * ... * <DEN`ndens'^tmpx`ndens'?> = B(tmpx0, <tmpx1>, ..., <tmpx`ndens'>);
#endprocedure
