(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    162433,       4042]
NotebookOptionsPosition[    151626,       3902]
NotebookOutlinePosition[    151960,       3917]
CellTagsIndexPosition[    151917,       3914]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.826545372243967*^9, 3.826545382473713*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"54174ed4-f1de-4b4e-a331-cc1144982f82"],

Cell[CellGroupData[{

Cell["General parameters. Because we can.", "Subsection",
 CellChangeTimes->{{3.826545466299275*^9, 
  3.8265454700815783`*^9}},ExpressionUUID->"009f4cd3-e083-405f-bd88-\
1478667f836a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NLOOPS", "=", "2"}], ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.8265454160667763`*^9}, {
  3.826545463365596*^9, 3.826545472649817*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"95cb26d1-c426-4396-a78f-df1eb164dd30"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generate the diagrams and load them", "Subsection",
 CellChangeTimes->{
  3.8265454794591503`*^9},ExpressionUUID->"0d1a1bb6-89bd-42fa-90e6-\
7277b430c476"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Run", "[", 
   RowBox[{"\"\<./mkdia.py dia-A-A-\>\"", "<>", 
    RowBox[{"ToString", "[", "NLOOPS", "]"}], "<>", "\"\<.m\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545428428645*^9}, {
  3.826545477626767*^9, 3.826545483402382*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"3ad51630-27a0-445d-b8f0-d13fb57956ad"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diagrams", "=", 
   RowBox[{"Get", "[", 
    RowBox[{"\"\<dia-A-A-\>\"", "<>", 
     RowBox[{"ToString", "[", "NLOOPS", "]"}], "<>", "\"\<.m\>\""}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Loaded \>\"", ",", 
    RowBox[{"diagrams", "//", "Length"}], ",", "\"\< diagrams\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545433925036*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"2f99be14-130f-4e33-a0fd-4dae74609a6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Insert Feynman Rules", "Subsection",
 CellChangeTimes->{{3.826545453385418*^9, 
  3.826545458169383*^9}},ExpressionUUID->"c77bcd28-d250-4925-946d-\
97bf66b9e05b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Shortcut", " ", "for", " ", "index", " ", 
    RowBox[{"deltas", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"deltaflv", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"deltaf", "[", 
     RowBox[{
      RowBox[{"flv", "[", "a", "]"}], ",", 
      RowBox[{"flv", "[", "b", "]"}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"deltaflvt", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"deltaft", "[", 
     RowBox[{
      RowBox[{"flvt", "[", "a", "]"}], ",", 
      RowBox[{"flvt", "[", "b", "]"}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"deltafun", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"fun", "[", "a", "]"}], ",", 
      RowBox[{"fun", "[", "b", "]"}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"deltaadj", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"adj", "[", "a", "]"}], ",", 
      RowBox[{"adj", "[", "b", "]"}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"deltalor", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"lor", "[", "a", "]"}], ",", 
      RowBox[{"lor", "[", "b", "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, 
   3.8265454993227777`*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"1abc6e4b-770c-4101-9ea8-eeb5ab0afb5e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "Amplitude", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"Diagram", "[", 
     RowBox[{
     "id_", ",", "factor_", ",", "ifields_List", ",", "ofields_List", ",", 
      "propagators_List", ",", "vertices_List"}], "]"}], "]"}], ":=", 
   RowBox[{"Times", "[", 
    RowBox[{"factor", ",", 
     RowBox[{
      RowBox[{"propagators", "//", 
       RowBox[{"Map", "[", "Amplitude", "]"}]}], "//", 
      RowBox[{"Apply", "[", "Times", "]"}]}], ",", 
     RowBox[{
      RowBox[{"vertices", "//", 
       RowBox[{"Map", "[", "Amplitude", "]"}]}], "//", 
      RowBox[{"Apply", "[", "Times", "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"(", "Light", ")"}], " ", "quark", " ", "propagator"}], 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"P", "[", 
     RowBox[{
     "\"\<q\>\"", ",", "fi1_", ",", "fi2_", ",", "_", ",", "_", ",", "p_"}], 
     "]"}], "]"}], ":=", 
   RowBox[{"I", " ", 
    RowBox[{"deltaflv", "[", 
     RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
    RowBox[{"deltafun", "[", 
     RowBox[{"fi2", ",", "fi1"}], "]"}], " ", 
    RowBox[{"gammachain", "[", 
     RowBox[{
      RowBox[{"slash", "[", "p", "]"}], ",", 
      RowBox[{"spn", "[", "fi2", "]"}], ",", 
      RowBox[{"spn", "[", "fi1", "]"}]}], "]"}], " ", 
    RowBox[{"den", "[", "p", "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Heavy", " ", "quark", " ", "propagator"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"P", "[", 
     RowBox[{
     "\"\<t\>\"", ",", "fi1_", ",", "fi2_", ",", "_", ",", "_", ",", "p_"}], 
     "]"}], "]"}], ":=", 
   RowBox[{"I", " ", 
    RowBox[{"deltaflvt", "[", 
     RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
    RowBox[{"deltafun", "[", 
     RowBox[{"fi2", ",", "fi1"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"gammachain", "[", 
       RowBox[{
        RowBox[{"slash", "[", "p", "]"}], ",", 
        RowBox[{"spn", "[", "fi2", "]"}], ",", 
        RowBox[{"spn", "[", "fi1", "]"}]}], "]"}], "+", 
      RowBox[{"mt1", " ", 
       RowBox[{"gammachain", "[", 
        RowBox[{
         RowBox[{"spn", "[", "fi2", "]"}], ",", 
         RowBox[{"spn", "[", "fi1", "]"}]}], "]"}]}]}], ")"}], " ", 
    RowBox[{"den", "[", 
     RowBox[{"p", ",", "mt2"}], "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Gluon", " ", "propagator"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"P", "[", 
     RowBox[{
     "\"\<g\>\"", ",", "fi1_", ",", "fi2_", ",", "_", ",", "_", ",", "p_"}], 
     "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "I"}], " ", 
    RowBox[{"deltaadj", "[", 
     RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"deltalor", "[", 
        RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
       RowBox[{"den", "[", "p", "]"}]}], "-", 
      RowBox[{"Xi", " ", 
       RowBox[{"momentum", "[", 
        RowBox[{"p", ",", 
         RowBox[{"lor", "[", "fi1", "]"}]}], "]"}], " ", 
       RowBox[{"momentum", "[", 
        RowBox[{"p", ",", 
         RowBox[{"lor", "[", "fi2", "]"}]}], "]"}], " ", 
       RowBox[{
        RowBox[{"den", "[", "p", "]"}], "^", "2"}]}]}], ")"}]}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Ghost", " ", "propagator"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"P", "[", 
     RowBox[{
     "\"\<c\>\"", ",", "fi1_", ",", "fi2_", ",", "_", ",", "_", ",", "p_"}], 
     "]"}], "]"}], ":=", 
   RowBox[{"I", " ", 
    RowBox[{"deltaadj", "[", 
     RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
    RowBox[{"den", "[", "p", "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Light", "-", "quark", "-", 
    RowBox[{"gluon", " ", "vertex"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "_", ",", "\"\<Qqg\>\"", ",", "fi1_", ",", "p1_", ",", "fi2_", ",", 
      "p2_", ",", "fi3_", ",", "p3_"}], "]"}], "]"}], ":=", 
   RowBox[{"I", " ", "gs", " ", 
    RowBox[{"deltaflv", "[", 
     RowBox[{"fi2", ",", "fi1"}], "]"}], " ", 
    RowBox[{"gammachain", "[", 
     RowBox[{
      RowBox[{"gamma", "[", 
       RowBox[{"lor", "[", "fi3", "]"}], "]"}], ",", 
      RowBox[{"spn", "[", "fi1", "]"}], ",", 
      RowBox[{"spn", "[", "fi2", "]"}]}], "]"}], " ", 
    RowBox[{"colorT", "[", 
     RowBox[{
      RowBox[{"adj", "[", "fi3", "]"}], ",", 
      RowBox[{"fun", "[", "fi1", "]"}], ",", 
      RowBox[{"fun", "[", "fi2", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Heavy", "-", "quark", "-", 
    RowBox[{"gluon", " ", "vertex"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "_", ",", "\"\<Ttg\>\"", ",", "fi1_", ",", "p1_", ",", "fi2_", ",", 
      "p2_", ",", "fi3_", ",", "p3_"}], "]"}], "]"}], ":=", 
   RowBox[{"I", " ", "gs", " ", 
    RowBox[{"deltaflvt", "[", 
     RowBox[{"fi2", ",", "fi1"}], "]"}], " ", 
    RowBox[{"gammachain", "[", 
     RowBox[{
      RowBox[{"gamma", "[", 
       RowBox[{"lor", "[", "fi3", "]"}], "]"}], ",", 
      RowBox[{"spn", "[", "fi1", "]"}], ",", 
      RowBox[{"spn", "[", "fi2", "]"}]}], "]"}], " ", 
    RowBox[{"colorT", "[", 
     RowBox[{
      RowBox[{"adj", "[", "fi3", "]"}], ",", 
      RowBox[{"fun", "[", "fi1", "]"}], ",", 
      RowBox[{"fun", "[", "fi2", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Ghost", "-", 
    RowBox[{"gluon", " ", "vertex"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "_", ",", "\"\<Ccg\>\"", ",", "fi1_", ",", "p1_", ",", "fi2_", ",", 
      "p2_", ",", "fi3_", ",", "p3_"}], "]"}], "]"}], ":=", 
   RowBox[{"gs", " ", 
    RowBox[{"colorf", "[", 
     RowBox[{
      RowBox[{"adj", "[", "fi3", "]"}], ",", 
      RowBox[{"adj", "[", "fi2", "]"}], ",", 
      RowBox[{"adj", "[", "fi1", "]"}]}], "]"}], " ", 
    RowBox[{"momentum", "[", 
     RowBox[{"p1", ",", 
      RowBox[{"lor", "[", "fi3", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Quark", "-", 
    RowBox[{"photon", " ", "vertex"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "_", ",", "\"\<QqA\>\"", ",", "fi1_", ",", "p1_", ",", "fi2_", ",", 
      "p2_", ",", "fi3_", ",", "p3_"}], "]"}], "]"}], ":=", 
   RowBox[{"(*", "ge", "*)"}], 
   RowBox[{"I", " ", 
    RowBox[{"deltaflv", "[", 
     RowBox[{"fi2", ",", "fi1"}], "]"}], " ", 
    RowBox[{"deltafun", "[", 
     RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
    RowBox[{"chargeQ", "[", 
     RowBox[{"flv", "[", "fi1", "]"}], "]"}], " ", 
    RowBox[{"gammachain", "[", 
     RowBox[{
      RowBox[{"gamma", "[", 
       RowBox[{"lor", "[", "fi3", "]"}], "]"}], ",", 
      RowBox[{"spn", "[", "fi1", "]"}], ",", 
      RowBox[{"spn", "[", "fi2", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Heavy", " ", "quark"}], "-", 
    RowBox[{"photon", " ", "vertex"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "_", ",", "\"\<TtA\>\"", ",", "fi1_", ",", "p1_", ",", "fi2_", ",", 
      "p2_", ",", "fi3_", ",", "p3_"}], "]"}], "]"}], ":=", 
   RowBox[{"(*", "ge", "*)"}], 
   RowBox[{"I", " ", 
    RowBox[{"deltaflvt", "[", 
     RowBox[{"fi2", ",", "fi1"}], "]"}], " ", 
    RowBox[{"deltafun", "[", 
     RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
    RowBox[{"chargeQt", "[", 
     RowBox[{"flvt", "[", "fi1", "]"}], "]"}], " ", 
    RowBox[{"gammachain", "[", 
     RowBox[{
      RowBox[{"gamma", "[", 
       RowBox[{"lor", "[", "fi3", "]"}], "]"}], ",", 
      RowBox[{"spn", "[", "fi1", "]"}], ",", 
      RowBox[{"spn", "[", "fi2", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"3", "-", 
    RowBox[{"gluon", " ", "vertex"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "_", ",", "\"\<ggg\>\"", ",", "fi1_", ",", "p1_", ",", "fi2_", ",", 
      "p2_", ",", "fi3_", ",", "p3_"}], "]"}], "]"}], ":=", 
   RowBox[{"gs", " ", 
    RowBox[{"colorf", "[", 
     RowBox[{
      RowBox[{"adj", "[", "fi1", "]"}], ",", 
      RowBox[{"adj", "[", "fi2", "]"}], ",", 
      RowBox[{"adj", "[", "fi3", "]"}]}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"deltalor", "[", 
        RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
       RowBox[{"momentum", "[", 
        RowBox[{
         RowBox[{"p1", "-", "p2"}], ",", 
         RowBox[{"lor", "[", "fi3", "]"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"deltalor", "[", 
        RowBox[{"fi2", ",", "fi3"}], "]"}], " ", 
       RowBox[{"momentum", "[", 
        RowBox[{
         RowBox[{"p2", "-", "p3"}], ",", 
         RowBox[{"lor", "[", "fi1", "]"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"deltalor", "[", 
        RowBox[{"fi3", ",", "fi1"}], "]"}], " ", 
       RowBox[{"momentum", "[", 
        RowBox[{
         RowBox[{"p3", "-", "p1"}], ",", 
         RowBox[{"lor", "[", "fi2", "]"}]}], "]"}]}]}], ")"}]}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"4", "-", 
    RowBox[{"gluon", " ", "vertex"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "vi_", ",", "\"\<gggg\>\"", ",", "fi1_", ",", "p1_", ",", "fi2_", ",", 
      "p2_", ",", "fi3_", ",", "p3_", ",", "fi4_", ",", "p4_"}], "]"}], "]"}],
    ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"adjX", "=", 
       RowBox[{"adj", "[", 
        RowBox[{"1000", "+", "vi"}], "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "I"}], " ", 
      RowBox[{"gs", "^", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"colorf", "[", 
          RowBox[{"adjX", ",", 
           RowBox[{"adj", "[", "fi1", "]"}], ",", 
           RowBox[{"adj", "[", "fi2", "]"}]}], "]"}], " ", 
         RowBox[{"colorf", "[", 
          RowBox[{"adjX", ",", 
           RowBox[{"adj", "[", "fi3", "]"}], ",", 
           RowBox[{"adj", "[", "fi4", "]"}]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"deltalor", "[", 
             RowBox[{"fi1", ",", "fi3"}], "]"}], " ", 
            RowBox[{"deltalor", "[", 
             RowBox[{"fi2", ",", "fi4"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"deltalor", "[", 
             RowBox[{"fi1", ",", "fi4"}], "]"}], " ", 
            RowBox[{"deltalor", "[", 
             RowBox[{"fi2", ",", "fi3"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"colorf", "[", 
          RowBox[{"adjX", ",", 
           RowBox[{"adj", "[", "fi1", "]"}], ",", 
           RowBox[{"adj", "[", "fi3", "]"}]}], "]"}], " ", 
         RowBox[{"colorf", "[", 
          RowBox[{"adjX", ",", 
           RowBox[{"adj", "[", "fi4", "]"}], ",", 
           RowBox[{"adj", "[", "fi2", "]"}]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"deltalor", "[", 
             RowBox[{"fi1", ",", "fi4"}], "]"}], " ", 
            RowBox[{"deltalor", "[", 
             RowBox[{"fi2", ",", "fi3"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"deltalor", "[", 
             RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
            RowBox[{"deltalor", "[", 
             RowBox[{"fi3", ",", "fi4"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"colorf", "[", 
          RowBox[{"adjX", ",", 
           RowBox[{"adj", "[", "fi1", "]"}], ",", 
           RowBox[{"adj", "[", "fi4", "]"}]}], "]"}], " ", 
         RowBox[{"colorf", "[", 
          RowBox[{"adjX", ",", 
           RowBox[{"adj", "[", "fi2", "]"}], ",", 
           RowBox[{"adj", "[", "fi3", "]"}]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"deltalor", "[", 
             RowBox[{"fi1", ",", "fi2"}], "]"}], " ", 
            RowBox[{"deltalor", "[", 
             RowBox[{"fi3", ",", "fi4"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"deltalor", "[", 
             RowBox[{"fi1", ",", "fi3"}], "]"}], " ", 
            RowBox[{"deltalor", "[", 
             RowBox[{"fi2", ",", "fi4"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Default", " ", "case"}], ",", 
    RowBox[{"just", " ", "to", " ", "be", " ", "safe"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Amplitude", "[", "x__", "]"}], ":=", 
   RowBox[{"Error", "[", 
    RowBox[{"\"\<Don't know an amplitude for: \>\"", ",", "x"}], "]"}]}], 
  "\n", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Print", " ", "a", " ", "message", " ", "and", " ", "fail"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Error", "[", "msg__", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<ERROR: \>\"", ",", "msg"}], "]"}], ";", 
    RowBox[{"Throw", "[", "$Failed", "]"}], ";"}], ")"}]}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545514290285*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"f4e2bb20-d365-49ec-b9f8-71542fc3980d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Apply Feynman rules to get amplitudes from the diagrams", "Subsection",ExpressionUUID->"44b089ba-2ffc-46e4-9455-19c3f898ce0e"],

Cell[BoxData[
 RowBox[{"projector", "=", 
  RowBox[{
   RowBox[{"deltalor", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}]}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{"d", "-", "1"}], ")"}]}]}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"a1675b5b-94b6-4894-8509-6faac39a7694"],

Cell[BoxData[
 RowBox[{
  RowBox[{"amplitudes", "=", 
   RowBox[{"diagrams", "//", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Amplitude", "[", "#", "]"}], "*", "projector"}], "&"}], 
     "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"0994fa37-fb59-4576-97ba-0341092557f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Note", " ", "the", " ", 
    RowBox[{"den", "[", "0", "]"}], " ", "and", " ", 
    RowBox[{"momentum", "[", 
     RowBox[{"0", ",", "..."}], "]"}], " ", "in", " ", "the", " ", "last", 
    " ", 
    RowBox[{"amplitude", ":"}]}], "*)"}], "\n", 
  RowBox[{
   RowBox[{"amplitudes", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Look", " ", "at", " ", 
     RowBox[{"diagrams", ".", "nb"}], " ", "to", " ", "figure", " ", "out", 
     " ", "the", " ", 
     RowBox[{"source", "."}]}], "*)"}]}]}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"7808f610-2ea5-418e-9bbf-e4c47d71fd5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cleanup scaleless integrals", "Subsection",
 CellChangeTimes->{
  3.8265455638590393`*^9},ExpressionUUID->"b6555248-188b-454d-a8f1-\
3593bb2510bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"amplitudes", "=", 
   RowBox[{
    RowBox[{"amplitudes", "/.", 
     RowBox[{
      RowBox[{"den", "[", "0", "]"}], "\[Rule]", "0"}]}], "/.", 
    RowBox[{
     RowBox[{"momentum", "[", 
      RowBox[{"0", ",", "_"}], "]"}], "\[Rule]", "0"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Non-zero amplitudes: \>\"", ",", 
    RowBox[{"amplitudes", "//", 
     RowBox[{"Count", "[", 
      RowBox[{"Except", "[", "0", "]"}], "]"}]}], ",", "\"\< of \>\"", ",", 
    RowBox[{"amplitudes", "//", "Length"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545568548645*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"dd37ce3b-d135-48eb-ae60-900cdd463aa4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tensor summation through FORM", "Subsection",
 CellChangeTimes->{
  3.8265455811875887`*^9},ExpressionUUID->"9aaa2912-2f03-4426-ba09-\
3f00719a4182"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Flatten", ",", "join", ",", 
    RowBox[{
    "and", " ", "convert", " ", "the", " ", "arguments", " ", "to", " ", "a", 
     " ", 
     RowBox[{"string", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MkString", "[", "args__", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"args", "//", "List"}], "//", "Flatten"}], "//", 
     RowBox[{"Map", "[", "ToString", "]"}]}], "//", 
    "StringJoin"}]}]}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"cb1b7a35-36c3-4a0a-97ed-b6957a073520"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Return", " ", "a", " ", "name", " ", "of", " ", "a", " ", "non"}], "-", 
    RowBox[{"existing", " ", "temporary", " ", 
     RowBox[{"file", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MkTemp", "[", 
    RowBox[{"prefix_", ",", "suffix_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "fn", ",", "alphabet"}], "}"}], ",", 
     RowBox[{
      RowBox[{"alphabet", "=", 
       RowBox[{
       "Characters", "[", "\"\<abcdefghijklmnopqrstuvwxyz0123456789\>\"", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{"True", ",", 
        RowBox[{
         RowBox[{"i", "=", 
          RowBox[{"RandomSample", "[", 
           RowBox[{"alphabet", ",", "8"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"fn", "=", 
          RowBox[{"FileNameJoin", "[", 
           RowBox[{"{", 
            RowBox[{"$TemporaryDirectory", ",", 
             RowBox[{"MkString", "[", 
              RowBox[{"prefix", ",", "\"\<.\>\"", ",", 
               RowBox[{"Environment", "[", "\"\<USER\>\"", "]"}], ",", 
               "\"\<.\>\"", ",", "$ProcessID", ",", "\"\<.\>\"", ",", "i", 
               ",", "suffix"}], "]"}]}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Not", "[", 
            RowBox[{"FileExistsQ", "[", "fn", "]"}], "]"}], ",", 
           RowBox[{"Return", "[", "fn", "]"}]}], "]"}], ";"}]}], "]"}]}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"e1fae73e-658e-44c2-8938-197cb2ec8592"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Convert", " ", "the", " ", "arguments", " ", "to", " ", "string", " ", 
    "and", " ", "write", " ", "it", " ", "into", " ", "the", " ", "specified",
     " ", 
    RowBox[{"file", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MkFile", "[", 
    RowBox[{"filename_", ",", "arguments__"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "f", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"OpenWrite", "[", 
        RowBox[{"filename", ",", 
         RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"f", "===", "$Failed"}], ",", 
        RowBox[{"Error", "[", 
         RowBox[{
         "\"\<MkFile: failed to open \>\"", ",", "filename", ",", 
          "\"\< for writing\>\""}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"f", ",", 
        RowBox[{"MkString", "[", "arguments", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "f", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"70e53632-8282-409f-b376-709c3c7bc8ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "all", " ", "unique", " ", "occurrences", " ", "of", " ", 
    "pat", " ", "in", " ", 
    RowBox[{"ex", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CaseUnion", "[", 
     RowBox[{"ex_", ",", "pat_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Cases", "[", 
      RowBox[{"ex", ",", "pat", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], "//", "Union"}]}], 
   "\n", 
   RowBox[{
    RowBox[{"CaseUnion", "[", "pat_", "]"}], ":=", 
    RowBox[{
     RowBox[{"CaseUnion", "[", 
      RowBox[{"#", ",", "pat"}], "]"}], "&"}]}]}]}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"54bd17a1-cc6b-42ab-a16b-6e6ef1bfb3d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Return", " ", "two", " ", 
     RowBox[{"maps", ":", " ", 
      RowBox[{
      "one", " ", "to", " ", "rename", " ", "all", " ", "indices", " ", "in", 
       " ", "an", " ", "expression", " ", "to", "\[IndentingNewLine]", "FORM",
        " ", "syntax"}]}]}], ",", " ", 
    RowBox[{
    "and", " ", "the", " ", "other", " ", "to", " ", "rename", " ", "them", 
     " ", 
     RowBox[{"back", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RenameIndicesToFromFORM", "[", "ex_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"original", ",", "renamed", ",", "i", ",", "idx", ",", "n"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"original", "=", 
       RowBox[{"CaseUnion", "[", 
        RowBox[{"ex", ",", 
         RowBox[{
         "_lor", "|", "_adj", "|", "_fun", "|", "_spn", "|", "_flv", "|", 
          "_flvt"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"renamed", "=", 
       RowBox[{"original", "//", 
        RowBox[{"Map", "[", 
         RowBox[{"Replace", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"i", ":", 
              RowBox[{
               RowBox[{"(", "idx_", ")"}], "[", 
               RowBox[{"n_", "?", "Negative"}], "]"}]}], "\[RuleDelayed]", 
             RowBox[{"ToExpression", "[", 
              RowBox[{
               RowBox[{"ToString", "[", "idx", "]"}], "<>", "\"\<m\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"-", "n"}], "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"i", ":", 
              RowBox[{
               RowBox[{"(", "idx_", ")"}], "[", "n_", "]"}]}], 
             "\[RuleDelayed]", 
             RowBox[{"ToExpression", "[", 
              RowBox[{
               RowBox[{"ToString", "[", "idx", "]"}], "<>", "\"\<p\>\"", "<>", 
               RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "}"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"MapThread", "[", 
         RowBox[{"Rule", ",", 
          RowBox[{"{", 
           RowBox[{"original", ",", "renamed"}], "}"}]}], "]"}], ",", 
        RowBox[{"MapThread", "[", 
         RowBox[{"Rule", ",", 
          RowBox[{"{", 
           RowBox[{"renamed", ",", "original"}], "}"}]}], "]"}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"a42c984a-0d28-45d4-b6e5-0e860d674abf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Convert", " ", "an", " ", "expression", " ", "to", " ", "FORM", " ", 
    RowBox[{"syntax", ".", "\[IndentingNewLine]", " ", "Note"}], " ", "that", 
    " ", "indices", " ", "should", " ", "be", " ", "renamed", " ", "before", 
    " ", 
    RowBox[{"this", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ToFORM", "[", "expression_", "]"}], ":=", 
   RowBox[{
    RowBox[{"ToString", "[", 
     RowBox[{"expression", ",", "InputForm"}], "]"}], "//", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<\\\"\>\"", "\[Rule]", "\"\<\>\""}], ",", 
       RowBox[{"\"\< \>\"", "\[Rule]", "\"\<\>\""}], ",", 
       RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<(\>\""}], ",", 
       RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}]}], "}"}], 
     "]"}]}]}]}]], "Input",ExpressionUUID->"e7f9a1e1-3c46-47b2-b448-\
06b8d051d177"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Save", " ", "a", " ", "list", " ", "of", " ", "expressions", " ", "to", 
     " ", "a", " ", "FORM", " ", "file"}], ",", " ", 
    RowBox[{
    "execute", " ", "a", " ", "FORM", " ", "program", "\[IndentingNewLine]", 
     "  ", "that", " ", "transforms", " ", "them"}], ",", " ", 
    RowBox[{"read", " ", "the", " ", "results", " ", 
     RowBox[{"back", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"RunThroughFORM", "[", 
     RowBox[{"exprlist_List", ",", "formcode__"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "tmpfile", ",", "tmplogfile", ",", "resultfiles", ",", "toform", ",", 
        "fromform", ",", "results"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tmpfile", "=", 
        RowBox[{"MkTemp", "[", 
         RowBox[{"\"\<tmp\>\"", ",", "\"\<.frm\>\""}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"tmplogfile", "=", 
        RowBox[{"tmpfile", "//", 
         RowBox[{"StringReplace", "[", 
          RowBox[{
           RowBox[{"\"\<.frm\>\"", "~~", "EndOfString"}], "\[Rule]", 
           "\"\<.log\>\""}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"resultfiles", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"MkString", "[", 
           RowBox[{"tmpfile", ",", "\"\<.\>\"", ",", "i", ",", "\"\<.m\>\""}],
            "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "exprlist", "]"}]}], "}"}]}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"toform", ",", "fromform"}], "}"}], "=", 
        RowBox[{"RenameIndicesToFromFORM", "[", "exprlist", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MkFile", "[", 
        RowBox[{
        "tmpfile", ",", "\[IndentingNewLine]", 
         "\"\<#include alltheFORMcode.frm\\n\>\"", ",", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\"\<local EXPR\>\"", ",", "i", ",", "\"\< = (\>\"", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"exprlist", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "/.", "toform"}], "//", 
              "ToFORM"}], ",", "\"\<);\\n\>\""}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "exprlist", "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<#call input\\n\>\"", ",", "\[IndentingNewLine]", "formcode", 
         ",", "\[IndentingNewLine]", "\"\<#call output\\n\>\"", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\"\<#call saveto(EXPR\>\"", ",", "i", ",", "\"\<,\>\"", ",", 
             "tmpfile", ",", "\"\<.\>\"", ",", "i", ",", "\"\<.m)\\n\>\""}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "exprlist", "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<.end\\n\>\""}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Running form \>\"", ",", "tmpfile"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Run", "[", 
        RowBox[{"\"\<form\>\"", ",", "\"\<-l\>\"", ",", "tmpfile"}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"results", "=", 
        RowBox[{
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Get", "[", 
            RowBox[{"MkString", "[", 
             RowBox[{
             "tmpfile", ",", "\"\<.\>\"", ",", "i", ",", "\"\<.m\>\""}], 
             "]"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "exprlist", "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}], "/.", "fromform"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"DeleteFile", "[", 
        RowBox[{"{", 
         RowBox[{"tmpfile", ",", "tmplogfile"}], "}"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"DeleteFile", "[", "resultfiles", "]"}], ";", 
       "\[IndentingNewLine]", "results"}]}], "\[IndentingNewLine]", "]"}]}], 
   "\n", 
   RowBox[{
    RowBox[{"RunThroughFORM", "[", 
     RowBox[{"expr_", ",", "formcode__"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"RunThroughFORM", "[", 
      RowBox[{
       RowBox[{"{", "expr", "}"}], ",", "formcode"}], "]"}], "//", 
     "First"}]}]}]}]], "Input",ExpressionUUID->"febe90d3-a61b-4bff-901f-\
8683e0196570"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Just", " ", "a", " ", 
     RowBox[{"test", ":", " ", 
      RowBox[{
      "with", " ", "no", " ", "code", " ", "in", " ", "the", " ", 
       "middle"}]}]}], ",", " ", 
    RowBox[{
    "all", " ", "expressions", " ", "should", " ", "just", " ", "be", " ", 
     "returned", " ", 
     RowBox[{"unchanged", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"RunThroughFORM", "[", 
     RowBox[{"amplitudes", ",", "\"\<\>\""}], "]"}], "-", "amplitudes"}], "//",
    "Expand"}]}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"f23f4ff5-22ae-4d59-a70e-0dd55ec7e1c2"],

Cell[BoxData[{
 RowBox[{"amplitudes2", "=", 
  RowBox[{"RunThroughFORM", "[", 
   RowBox[{
   "amplitudes", ",", "\[IndentingNewLine]", "\"\<#call applydeltas\\n\>\"", 
    ",", "\[IndentingNewLine]", "\"\<#call colorsum\\n\>\"", ",", 
    "\[IndentingNewLine]", "\"\<#call flavorsum\\n\>\"", ",", 
    "\[IndentingNewLine]", "\"\<#call diracsum\\n\>\"", ",", 
    "\[IndentingNewLine]", "\"\<#call contractmomenta\\n\>\"", ",", 
    "\[IndentingNewLine]", "\"\<id mt1^2 = mt2;\\n\>\""}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Non-zero amplitudes: \>\"", ",", 
    RowBox[{"amplitudes2", "//", 
     RowBox[{"Count", "[", 
      RowBox[{"Except", "[", "0", "]"}], "]"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.82654565136759*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"e94f80cc-b1b6-41de-bb58-6f7c304b35ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"To", " ", "double"}], "-", 
    RowBox[{"check", " ", "that", " ", 
     RowBox[{"we", "'"}], "ve", " ", "got", " ", "only", " ", "what", " ", 
     "we", " ", "expected", " ", "to", " ", 
     RowBox[{"get", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"amplitudes2", "//", 
   RowBox[{"CaseUnion", "[", "_Symbol", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545663686057*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"4826518f-b340-42f2-97c8-935b3a850681"],

Cell[BoxData[
 RowBox[{"amplitudes2", "//", 
  RowBox[{"CaseUnion", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", "head_", ")"}], "[", "___", "]"}], "\[RuleDelayed]", 
    "head"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545664504486*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"fe7b1213-b0d7-4c07-b22b-4ff30eeb7807"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Investigate the amplitudes that became zero", "Subsection",
 CellChangeTimes->{
  3.826545670060255*^9},ExpressionUUID->"46e54469-79f6-4ef5-9730-\
2d257b2a2cde"],

Cell[BoxData[
 RowBox[{"amplitudes", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545681687663*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"815b95d3-b2ec-45d6-8d19-c5860982552f"],

Cell[BoxData[
 RowBox[{"amplitudes2", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545686507369*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"674a3494-7cb8-431b-948d-b4a99d606235"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Answer", ":", " ", 
    RowBox[{
     RowBox[{
     "look", " ", "at", " ", "the", " ", "diagrams", " ", "in", " ", "show"}],
      "-", 
     RowBox[{"diagrams", ".", "nb"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Let", "'"}], "s", " ", "investigate", " ", 
    RowBox[{"further", "."}]}], " ", "*)"}], " "}]], "Input",ExpressionUUID->\
"78ac0065-e5d6-45c7-80fe-f55f92cbc473"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Factors", "[", "ex_Times", "]"}], ":=", 
   RowBox[{"List", "@@", "ex"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Factors", "[", "ex_", "]"}], ":=", 
  RowBox[{"{", "ex", "}"}], " "}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545718313793*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"3a53bef5-e8df-493c-b655-97e40a659f2e"],

Cell[BoxData[
 RowBox[{"colorfactor", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"amplitudes", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "//", "\[IndentingNewLine]", 
      "Factor"}], "//", "\[IndentingNewLine]", "Factors"}], "//", 
    "\[IndentingNewLine]", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"_adj", "|", "_fun"}], "]"}], "/*", "Not"}], "]"}]}], "//", 
   "\[IndentingNewLine]", 
   RowBox[{"Apply", "[", "Times", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.8265457349722958`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"b46866fd-d807-4e7d-93e4-8762b1afdb74"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RunThroughFORM", "[", 
   RowBox[{
   "colorfactor", ",", "\[IndentingNewLine]", "\"\<#call applydeltas\\n\>\"", 
    ",", "\[IndentingNewLine]", "\"\<#call colorsum\\n\>\""}], 
   "\[IndentingNewLine]", "]"}], " "}]], "Input",
 CellLabel->"In[62]:=",ExpressionUUID->"ae98597e-d633-483d-a3a2-47ad1159d79f"],

Cell[BoxData[
 RowBox[{"colorfactors", "=", 
  RowBox[{
   RowBox[{"amplitudes", "//", "\[IndentingNewLine]", 
    RowBox[{"Map", "[", 
     RowBox[{"Factor", "/*", "Factors", "/*", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"_adj", "|", "_fun"}], "]"}], "/*", "Not"}], "]"}], "/*", 
      RowBox[{"Apply", "[", "Times", "]"}]}], "]"}]}], "//", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RunThroughFORM", "[", 
     RowBox[{
     "#", ",", "\[IndentingNewLine]", "\"\<#call applydeltas\\n\>\"", ",", 
      "\[IndentingNewLine]", "\"\<#call colorsum\\n\>\""}], 
     "\[IndentingNewLine]", "]"}], "&"}]}]}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"076b37e1-7717-473b-ad5d-75cb59f869bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral families (IBP topologies)", "Subsection",
 CellChangeTimes->{
  3.826545781284856*^9},ExpressionUUID->"afe10d7b-b51a-4100-b7fe-\
79bc29199776"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DropLeadingSign", "[", 
   RowBox[{"ex_", "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"FactorTermsList", "[", "ex", "]"}], "//", "First"}], "//", 
      "Negative"}], ")"}]}], "]"}], ":=", 
  RowBox[{"-", "ex"}]}], "\n", 
 RowBox[{
  RowBox[{"DropLeadingSign", "[", "ex_", "]"}], ":=", "ex"}]}], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"4a1b8be3-5b8d-4aa6-b2d4-fe409418371d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalizeDens", "[", "ex_", "]"}], ":=", 
  RowBox[{"ex", "/.", 
   RowBox[{
    RowBox[{"den", "[", 
     RowBox[{"p_", ",", "x___"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"den", "[", 
     RowBox[{
      RowBox[{"DropLeadingSign", "[", "p", "]"}], ",", "x"}], 
     "]"}]}]}]}]], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"56f55b48-8595-4ab8-8aff-d19798455ccb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"loopmomenta", "=", 
   RowBox[{"diagrams", "//", 
    RowBox[{"CaseUnion", "[", 
     RowBox[{"l1", "|", "l2", "|", "l3", "|", "l4", "|", "l5"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"externalmomenta", "=", 
   RowBox[{"diagrams", "//", 
    RowBox[{"CaseUnion", "[", 
     RowBox[{
     "q", "|", "q1", "|", "q2", "|", "q3", "|", "q4", "|", "q5", "|", "p1", 
      "|", "p2", "|", "p3", "|", "p4", "|", "p5"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<External momenta: \>\"", ",", "externalmomenta"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Loop momenta: \>\"", ",", "loopmomenta", ",", "\"\< (expected: \>\"", 
    ",", "NLOOPS", ",", "\"\<)\>\""}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545789508782*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"9190a7e8-e490-4a96-9bcc-c9b803c15bb7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"denominatorsets", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"amplitudes2", "//", 
      RowBox[{"DeleteCases", "[", "1", "]"}]}], "//", "NormalizeDens"}], "//", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"CaseUnion", "[", "_den", "]"}], "/*", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"Alternatives", "@@", "loopmomenta"}], "]"}], "/*", "Not"}], 
       "]"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Unique denominator sets: \>\"", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"denominatorsets", "//", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"{", "}"}], "]"}]}], "//", "Union"}], "//", "Length"}]}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545791361732*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"abbdc676-d25b-4a9c-94d3-d0eb478c8546"],

Cell[BoxData[
 RowBox[{
  RowBox[{"denominatorsets", "//", 
   RowBox[{"Map", "[", "Print", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545792086914*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"d64966a1-34ff-41ec-9dfe-d1e7e3fa5a6b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Return", " ", "a", " ", "list", " ", "of", " ", "momenta", " ", "maps"}],
     ",", 
    RowBox[{
    "such", " ", "that", " ", "applying", " ", "them", " ", "to", 
     "\[IndentingNewLine]", " ", "the", " ", "list", " ", "of", " ", 
     "feynman", " ", "integral", " ", "families", " ", "makes", " ", 
     "symmetries", " ", "and", "\[IndentingNewLine]", " ", "subtopology", " ",
      "relations", " ", 
     RowBox[{"explicit", ".", " ", "So"}]}], ",", " ", 
    RowBox[{
    "families", " ", "that", " ", "are", " ", "symmetric", 
     "\[IndentingNewLine]", " ", "will", " ", "have", " ", "identical", " ", 
     "sets", " ", "of", " ", "denominators", " ", "after", " ", "the", " ", 
     "maps", " ", "are", "\[IndentingNewLine]", " ", 
     RowBox[{"applied", ".", " ", "Families"}], " ", "that", " ", "are", " ", 
     "symmetric", " ", "to", " ", "a", " ", "subtopology", " ", "of", " ", 
     "a", "\[IndentingNewLine]", " ", "bigger", " ", "family", " ", "will", 
     " ", "have", " ", "a", " ", "subsets", " ", "of", " ", "the", " ", 
     RowBox[{
     "denominators", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "The"}], " ", "families", " ", "are", " ", "defined", " ", "by", " ", 
     "their", " ", "set", " ", "of", " ", 
     RowBox[{"den", "[", "]"}], 
     RowBox[{"s", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
     " ", "can", " ", "use", " ", 
     RowBox[{"UniqueSupersetMapping", "[", "]"}], " ", "to", " ", "figure", 
     " ", "out", " ", "the", "\[IndentingNewLine]", " ", "topmost", " ", 
     "supertopologies", " ", "after", " ", 
     RowBox[{
     "this", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "Uses"}], " ",
      "Feynson", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"https", ":"}], "//", 
       RowBox[{
        RowBox[{
         RowBox[{"github", ".", "com"}], "/", "magv"}], "/", "feynson"}]}], 
      ")"}], " ", 
     RowBox[{"underneath", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SymmetryMaps", "[", 
     RowBox[{
     "denominatorsetlist_List", ",", "loopmom_List", ",", "extmom_List"}], 
     "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "densets", ",", "uniqdensets", ",", "densetindices", ",", 
        "uniqdensetmaps"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"densets", "=", 
        RowBox[{
         RowBox[{
         "denominatorsetlist", "//", "\[IndentingNewLine]", "NormalizeDens"}],
          "//", "\[IndentingNewLine]", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"CaseUnion", "[", "_den", "]"}], "/*", "Union", "/*", 
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"FreeQ", "[", 
              RowBox[{"Alternatives", "@@", "loopmom"}], "]"}], "/*", "Not"}],
             "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"densets", "=", 
        RowBox[{
         RowBox[{"densets", "/.", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"den", "[", "p_", "]"}], "\[RuleDelayed]", 
           RowBox[{"p", "^", "2"}]}]}], "/.", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"den", "[", 
           RowBox[{"p_", ",", "m_"}], "]"}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"p", "^", "2"}], "-", "m"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"RunThrough", "[", 
         RowBox[{"\"\<./feynson/feynson symmetrize -j1 -q -\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"densets", ",", "loopmom", ",", 
            RowBox[{"{", "}"}]}], "}"}]}], "]"}], "//", "\[IndentingNewLine]", 
        RowBox[{"Map", "[", 
         RowBox[{"Map", "[", 
          RowBox[{"Apply", "[", "Rule", "]"}], "]"}], "]"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellLabel->"In[74]:=",ExpressionUUID->"19ae1b1d-6e84-4dbf-9159-de7816bbe8a5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"momentamaps", "=", 
   RowBox[{"SymmetryMaps", "[", 
    RowBox[{"denominatorsets", ",", "loopmomenta", ",", "externalmomenta"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Found \>\"", ",", 
    RowBox[{
     RowBox[{"momentamaps", "//", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"{", "}"}], "]"}]}], "//", "Length"}], ",", 
    "\"\< momenta mappings\>\""}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545854793219*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"3bd865dd-cc2f-4006-a1c7-b01069b67f9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"momentamaps", "//", 
   RowBox[{"Map", "[", "Print", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545857982526*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"f82ce56b-6454-43d9-8101-cbe784ac03dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"symmetrizeddenominatorsets", "=", 
   RowBox[{
    RowBox[{"MapThread", "[", 
     RowBox[{"ReplaceAll", ",", 
      RowBox[{"{", 
       RowBox[{"denominatorsets", ",", "momentamaps"}], "}"}]}], "]"}], "//", 
    "NormalizeDens"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"92ae3ebe-ad47-4b91-b923-2ab34600dfe6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Return", " ", "the", " ", "first", " ", "index", " ", "of", " ", "the", 
    " ", "given", " ", "list", " ", "where", " ", 
    RowBox[{"`f", "[", "element", "]"}], "`", " ", "is", " ", 
    RowBox[{"true", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ElementIndex", "[", 
    RowBox[{"l_List", ",", "f_", ",", "default_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"FirstPosition", "[", 
     RowBox[{"l", ",", 
      RowBox[{"_", "?", "f"}], ",", 
      RowBox[{"{", "default", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}], "//", 
    "First"}]}]}]], "Input",
 CellLabel->"In[80]:=",ExpressionUUID->"aeea39db-1038-477c-ad86-d88d8a8f3c06"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Among", " ", "a", " ", "list", " ", "of", " ", "sets"}], ",", 
    RowBox[{
    "find", " ", "such", " ", "a", " ", "sublist", " ", "such", " ", "that", 
     " ", "all", " ", "other", "\[IndentingNewLine]", " ", "sets", " ", "are",
      " ", "subsets", " ", "of", " ", "these", " ", 
     RowBox[{"ones", ".", " ", "Return"}], " ", "the", " ", "list"}], ",", 
    " ", 
    RowBox[{
     RowBox[{
     "and", " ", "a", " ", "list", " ", "of", "\[IndentingNewLine]", 
      "indices", " ", "indicating", " ", "which", " ", "set", " ", "belongs", 
      " ", "to", " ", "which", " ", 
      RowBox[{"superset", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Example", ":", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "3", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
          RowBox[{"{", "2", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4", ",", "3"}], "}"}], ",", 
          RowBox[{"{", "4", "}"}]}], "}"}]}]}]}], "//", 
     RowBox[{"UniqueSupersetMapping", "\[IndentingNewLine]", "  ", ">", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4", ",", "3"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2"}], 
         "}"}]}], "}"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"UniqueSupersetMapping", "[", 
    RowBox[{"sets_List", ",", 
     RowBox[{"subsetq_:", "SubsetQ"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"supersets", ",", "idx", ",", "set", ",", "IdxOf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"supersets", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"IdxOf", "[", "set_", "]"}], ":=", 
       RowBox[{
        RowBox[{"IdxOf", "[", "set", "]"}], "=", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"idx", "=", 
           RowBox[{"ElementIndex", "[", 
            RowBox[{"supersets", ",", 
             RowBox[{
              RowBox[{"subsetq", "[", 
               RowBox[{"#", ",", "set"}], "]"}], "&"}], ",", "None"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"idx", "===", "None"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"supersets", "=", 
              RowBox[{"Append", "[", 
               RowBox[{"supersets", ",", 
                RowBox[{"set", "//", "Sort"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Length", "[", "supersets", "]"}]}], ",", "idx"}], 
           "]"}]}], "\[IndentingNewLine]", ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sets", "//", 
        RowBox[{"SortBy", "[", 
         RowBox[{"Length", "/*", "Minus"}], "]"}]}], "//", 
       RowBox[{"Map", "[", "IdxOf", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"supersets", ",", 
        RowBox[{"sets", "//", 
         RowBox[{"Map", "[", "IdxOf", "]"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"e48ab21a-d456-4bd1-9c35-bc007e942be3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"denominatorsupersets", ",", "supersetindices"}], "}"}], "=", 
   RowBox[{
   "UniqueSupersetMapping", "[", "symmetrizeddenominatorsets", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Total integral families: \>\"", ",", 
    RowBox[{"denominatorsupersets", "//", "Length"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"denominatorsupersets", "//", 
   RowBox[{"Map", "[", "Print", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
   3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
   3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, 
   3.826546023865918*^9},
 CellLabel->"In[82]:=",ExpressionUUID->"01e1f07d-124f-477a-8657-54cede4f8e5b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"An", " ", "IBP", " ", "basis", " ", "has", " ", "these", " ", 
      RowBox[{"components", ":", "\[IndentingNewLine]", "\"\<id\>\"", ":", 
       RowBox[{"its", " ", "number", " ", 
        RowBox[{"(", 
         RowBox[{"or", " ", "name"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\"\<denominators\>\"", ":", " ", 
      RowBox[{
      "the", " ", "list", " ", "of", " ", "its", " ", "denominators", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"den", "[", "]"}], " ", "expression"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<loopmom\>\"", ":", " ", 
      RowBox[{
      "the", " ", "list", " ", "of", " ", "loop", " ", "momenta", " ", 
       "names"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\"\<extmom\>\"", ":", " ", 
      RowBox[{
      "the", " ", "list", " ", "of", " ", "external", " ", "momenta", " ", 
       "names"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\"\<sprules\>\"", ":", " ", 
      RowBox[{
      "the", " ", "list", " ", "of", " ", "external", " ", "invariant", " ", 
       "substitutions", " ", 
       RowBox[{"(", 
        RowBox[{"i", ".", "e", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sp", "[", 
            RowBox[{"q", ",", "q"}], "]"}], "\[Rule]", "sqrq"}], "}"}]}], 
        ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\"\<numrules\>\"", ":", " ", 
      RowBox[{
      "the", " ", "map", " ", "from", " ", "scalar", " ", "products", " ", 
       "involving", " ", "loop", " ", "momenta", " ", "to", " ", 
       "denominator", " ", "indices"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\"\<denrules\>\"", ":", " ", 
      RowBox[{"the", " ", "map", " ", "from", " ", 
       RowBox[{"den", "[", "]"}], " ", "expressions", " ", "to", " ", 
       "denominator", " ", 
       RowBox[{"indices", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"CompleteIBPBasis", "[", "]"}]}], " ", "takes", " ", "the", 
       " ", "first", " ", "5"}]}]}], ",", 
    RowBox[{"and", " ", "completes", " ", "the", " ", "last", " ", "two"}], 
    ",", 
    RowBox[{"returning", " ", "an", " ", 
     RowBox[{"Association", "."}]}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CompleteIBPBasis", "[", 
     RowBox[{
     "id_", ",", "denominators_List", ",", "loopmom_List", ",", 
      "externalmom_List", ",", "sprules_List"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "L", ",", "M", ",", "p", ",", "l", ",", "k", ",", "dens", ",", "nums", 
        ",", "vars", ",", "c", ",", "mx", ",", "candidates", ",", "newnum", 
        ",", "newc", ",", "newmx", ",", "Complete", ",", "rels"}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"L", "=", 
        RowBox[{"loopmom", "//", 
         RowBox[{"Apply", "[", "Alternatives", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"M", "=", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"loopmom", ",", "externalmom"}], "]"}], "//", 
         RowBox[{"Apply", "[", "Alternatives", "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"dens", "=", 
        RowBox[{
         RowBox[{"denominators", "//", "NormalizeDens"}], "//", "Sort"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"nums", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"dens", "/.", 
           RowBox[{
            RowBox[{"den", "[", "p_", "]"}], "\[RuleDelayed]", 
            RowBox[{"p", "^", "2"}]}]}], "/.", 
          RowBox[{
           RowBox[{"den", "[", 
            RowBox[{"p_", ",", "m2_", ",", "___"}], "]"}], "\[RuleDelayed]", 
           RowBox[{
            RowBox[{"p", "^", "2"}], "-", "m2"}]}]}], "//", "Expand"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"nums", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"nums", "/.", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", ":", "M"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"k", ":", "M"}], ")"}]}], "\[RuleDelayed]", 
            RowBox[{"Sort", "[", 
             RowBox[{"sp", "[", 
              RowBox[{"l", ",", "k"}], "]"}], "]"}]}]}], "/.", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"l", ":", "M"}], ")"}], "^", "2"}], "\[RuleDelayed]", 
           RowBox[{"sp", "[", 
            RowBox[{"l", ",", "l"}], "]"}]}]}], "/.", "sprules"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"vars", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Tuples", "[", 
           RowBox[{"{", 
            RowBox[{"loopmom", ",", 
             RowBox[{"Join", "[", 
              RowBox[{"loopmom", ",", "externalmom"}], "]"}]}], "}"}], "]"}], 
          "//", 
          RowBox[{"Map", "[", 
           RowBox[{"Sort", "/*", 
            RowBox[{"Apply", "[", "sp", "]"}]}], "]"}]}], "//", "Union"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Independent scalar products: \>\"", ",", 
         RowBox[{"Length", "[", "vars", "]"}], ",", "\"\<, \>\"", ",", 
         "vars"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"c", ",", "mx"}], "}"}], "=", 
        RowBox[{
         RowBox[{"CoefficientArrays", "[", 
          RowBox[{"nums", ",", "vars"}], "]"}], "//", "Normal"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"nums", "\[Equal]", 
         RowBox[{"c", "+", 
          RowBox[{"mx", ".", "vars"}]}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"MatrixRank", "[", "mx", "]"}], "<", 
          RowBox[{"Length", "[", "mx", "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Error", "[", 
          RowBox[{
          "\"\<CompleteIBPBasis: denominators \>\"", ",", "denominators", 
           ",", "\"\< are already linearly dependent\>\""}], "]"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "mx", "]"}], "=!=", 
          RowBox[{"Length", "[", "vars", "]"}]}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"(*", 
          RowBox[{"Error", "[", 
           RowBox[{
           "\"\<CompleteIBPBasis: denominators \>\"", ",", "denominators", 
            ",", "\"\< are incomplete\>\""}], "]"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"candidates", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"Subsets", "[", 
              RowBox[{
               RowBox[{"Join", "[", 
                RowBox[{"loopmom", ",", "externalmom"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], "//", 
             "\[IndentingNewLine]", 
             RowBox[{"Map", "[", 
              RowBox[{"Apply", "[", "Plus", "]"}], "]"}]}], "//", 
            "\[IndentingNewLine]", 
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"FreeQ", "[", "L", "]"}], "/*", "Not"}], "]"}]}]}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Candidate irreducible denominators: \>\"", ",", 
            "candidates"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"While", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "mx", "]"}], "<", 
              RowBox[{"Length", "[", "vars", "]"}]}], "&&", 
             RowBox[{"candidates", "=!=", 
              RowBox[{"{", "}"}]}]}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"newnum", "=", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Expand", "[", 
                  RowBox[{
                   RowBox[{"candidates", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "]"}], "/.", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"l", ":", "M"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"k", ":", "M"}], ")"}]}], "\[RuleDelayed]", 
                  RowBox[{"Sort", "[", 
                   RowBox[{"sp", "[", 
                    RowBox[{"l", ",", "k"}], "]"}], "]"}]}]}], "/.", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"l", ":", "M"}], ")"}], "^", "2"}], 
                 "\[RuleDelayed]", 
                 RowBox[{"sp", "[", 
                  RowBox[{"l", ",", "l"}], "]"}]}]}], "/.", "sprules"}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"newc", ",", "newmx"}], "}"}], "=", 
              RowBox[{
               RowBox[{"CoefficientArrays", "[", 
                RowBox[{"newnum", ",", "vars"}], "]"}], "//", "Normal"}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MatrixRank", "[", 
                 RowBox[{"Append", "[", 
                  RowBox[{"mx", ",", "newmx"}], "]"}], "]"}], "===", 
                RowBox[{
                 RowBox[{"Length", "[", "mx", "]"}], "+", "1"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Print", "[", 
                 RowBox[{"\"\<Adding denominator: \>\"", ",", 
                  RowBox[{"den", "[", 
                   RowBox[{
                    RowBox[{"candidates", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "0", ",", "irr"}], 
                   "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"mx", ",", "newmx"}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"dens", ",", 
                  RowBox[{"den", "[", 
                   RowBox[{
                    RowBox[{"candidates", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "0", ",", "irr"}], 
                   "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"c", ",", "newc"}], "]"}], ";"}], ",", 
               RowBox[{
                RowBox[{"candidates", "=", 
                 RowBox[{"candidates", "[", 
                  RowBox[{"[", 
                   RowBox[{"2", ";;"}], "]"}], "]"}]}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"<|", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\"\<id\>\"", "\[Rule]", "id"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"\"\<denominators\>\"", "\[Rule]", "dens"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<loopmom\>\"", "\[Rule]", "loopmom"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<externalmom\>\"", "\[Rule]", "externalmom"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<sprules\>\"", "\[Rule]", "sprules"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<denmap\>\"", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"MapIndexed", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"#1", "\[Rule]", 
                  RowBox[{"DEN", "@@", "#2"}]}], "&"}], ",", "dens"}], "]"}], 
              "//", "\[IndentingNewLine]", 
              RowBox[{"DeleteCases", "[", 
               RowBox[{
                RowBox[{"den", "[", 
                 RowBox[{"_", ",", "_", ",", "irr"}], "]"}], "\[Rule]", "_"}],
                "]"}]}], "//", "\[IndentingNewLine]", 
             RowBox[{"ReplaceAll", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"den", "[", 
                  RowBox[{"p_", ",", "x___"}], "]"}], "\[Rule]", "y_"}], 
                ")"}], "\[RuleDelayed]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"den", "[", 
                   RowBox[{"p", ",", "x"}], "]"}], "\[Rule]", "y"}], ",", 
                 RowBox[{
                  RowBox[{"den", "[", 
                   RowBox[{
                    RowBox[{"-", "p"}], ",", "x"}], "]"}], "\[Rule]", "y"}]}],
                 "}"}]}], "]"}]}], "//", "\[IndentingNewLine]", "Flatten"}], 
           ")"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"\"\<nummap\>\"", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Inverse", "[", "mx", "]"}], ".", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"DEN", "[", "#", "]"}]}], "&"}], ",", 
                   RowBox[{"Range", "[", 
                    RowBox[{"Length", "[", "mx", "]"}], "]"}]}], "]"}], "-", 
                 "c"}], ")"}]}], "//", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Collect", "[", 
                RowBox[{"#", ",", "_DEN", ",", "Factor"}], "]"}], "&"}]}], "//",
              "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"MapThread", "[", 
               RowBox[{"Rule", ",", 
                RowBox[{"{", 
                 RowBox[{"vars", ",", "#"}], "}"}]}], "]"}], "&"}]}], "//", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Join", "[", 
              RowBox[{"#", ",", 
               RowBox[{"#", "/.", 
                RowBox[{
                 RowBox[{"sp", "[", 
                  RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
                 RowBox[{"sp", "[", 
                  RowBox[{"b", ",", "a"}], "]"}]}]}]}], "]"}], "&"}]}], 
           ")"}]}]}], "\[IndentingNewLine]", "|>"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\n", 
   RowBox[{"CompleteIBPBasis", "[", 
    RowBox[{"1", ",", 
     RowBox[{"denominatorsupersets", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "loopmomenta", ",", 
     "externalmomenta", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"sp", "[", 
        RowBox[{"q", ",", "q"}], "]"}], "\[Rule]", "sqrq"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"85bc21d7-dba9-461d-9695-d3cbcc2cabe3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Test", " ", "auto"}], "-", 
    RowBox[{"completion", " ", "of", " ", "the", " ", "basis"}]}], "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{"CompleteIBPBasis", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"den", "[", "l1", "]"}], "}"}], ",", "loopmomenta", ",", 
     "externalmomenta", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"sp", "[", 
        RowBox[{"q", ",", "q"}], "]"}], "\[Rule]", "sqrq"}], "}"}]}], "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546208782961*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"bb731f43-3094-4818-88b1-27dcef902946"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bases", "=", 
   RowBox[{"denominatorsupersets", "//", 
    RowBox[{"MapIndexed", "[", 
     RowBox[{
      RowBox[{"CompleteIBPBasis", "[", 
       RowBox[{
        RowBox[{"First", "[", "#2", "]"}], ",", "#1", ",", "loopmomenta", ",",
         "externalmomenta", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"sp", "[", 
           RowBox[{"q", ",", "q"}], "]"}], "\[Rule]", "sqrq"}], "}"}]}], 
       "]"}], "&"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546220558318*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"e1f74c98-c949-44b1-a32d-62b21644b8f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Convert amplitudes to B notation", "Subsection",
 CellChangeTimes->{
  3.8265462318074913`*^9},ExpressionUUID->"16760009-857e-4523-8820-\
65335731d8e0"],

Cell["B notation: B[basis id,den1 power,den2 power,...,denN power]", "Text",ExpressionUUID->"36f49ab2-8026-416f-8504-d7485a3a62ff"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FORMCodeToB", "[", "bases_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "basis", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<#procedure toBIDandDEN\\n\>\"", ",", "\[IndentingNewLine]", 
      "\"\<  \>\"", ",", 
      RowBox[{
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<if (match(only, BID^\>\"", ",", 
           RowBox[{"basis", "[", "\"\<id\>\"", "]"}], ",", "\"\<));\\n\>\"", 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"basis", "[", "\"\<denmap\>\"", "]"}], "//", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{"\"\<    id \>\"", ",", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "//", "ToFORM"}], ",", 
                 "\[IndentingNewLine]", "\"\< = \>\"", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/.", 
                    RowBox[{"basis", "[", "\"\<sprules\>\"", "]"}]}], "/.", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"DEN", "[", "n_", "]"}], "\[RuleDelayed]", 
                    RowBox[{"MkString", "[", 
                    RowBox[{"\"\<DEN\>\"", ",", "n"}], "]"}]}]}], "//", 
                  "ToFORM"}], ",", "\"\<;\\n\>\""}], "\[IndentingNewLine]", 
                "}"}], "&"}], "]"}]}], "//", "Union"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"basis", "[", "\"\<nummap\>\"", "]"}], "//", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\"\<    id \>\"", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/.", 
                   RowBox[{"sp", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{"Dot", "/*", "Sort"}], ")"}]}]}], "//", 
                  "ToFORM"}], ",", "\"\< = \>\"", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/.", 
                    RowBox[{"basis", "[", "\"\<sprules\>\"", "]"}]}], "/.", 
                   RowBox[{
                    RowBox[{"DEN", "[", "n_", "]"}], "\[RuleDelayed]", 
                    RowBox[{"MkString", "[", 
                    RowBox[{"\"\<DEN\>\"", ",", "n"}], "]"}]}]}], "//", 
                  "ToFORM"}], ",", "\"\<;\\n\>\""}], "}"}], "&"}], "]"}]}], "//",
             "Union"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"basis", "[", "\"\<sprules\>\"", "]"}], "//", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\"\<    id \>\"", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/.", 
                   RowBox[{"sp", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{"Dot", "/*", "Sort"}], ")"}]}]}], "//", 
                  "ToFORM"}], ",", "\"\< = \>\"", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/.", 
                   RowBox[{
                    RowBox[{"DEN", "[", "n_", "]"}], "\[RuleDelayed]", 
                    RowBox[{"MkString", "[", 
                    RowBox[{"\"\<DEN\>\"", ",", "n"}], "]"}]}]}], "//", 
                  "ToFORM"}], ",", "\"\<;\\n\>\""}], "}"}], "&"}], "]"}]}], "//",
             "Union"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"basis", ",", "bases"}], "}"}]}], "]"}], "//", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Riffle", "[", 
         RowBox[{"#", ",", "\"\<  else\>\""}], "]"}], "&"}]}], ",", 
      "\[IndentingNewLine]", "\"\<  else;\\n\>\"", ",", 
      "\[IndentingNewLine]", 
      "\"\<    exit \\\"ERROR: toBden: got a term without a proper BID^n \
factor.\\\";\\n\>\"", ",", "\[IndentingNewLine]", "\"\<  endif;\\n\>\"", ",", 
      "\[IndentingNewLine]", "\"\<#endprocedure\\n\>\"", ",", 
      "\[IndentingNewLine]", "\"\<#call toB(toBIDandDEN,\>\"", ",", 
      RowBox[{"Length", "[", 
       RowBox[{"bases", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "\"\<denominators\>\""}], "]"}], "]"}], "]"}], 
      ",", "\"\<)\\n\>\""}], "\[IndentingNewLine]", "}"}]}], 
   "\[IndentingNewLine]", "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FORMCodeToB", "[", "bases", "]"}], "//", "MkString"}], "//", 
   "Print"}], ";"}]}], "Input",
 CellLabel->"In[98]:=",ExpressionUUID->"2fb4c365-46e3-441a-8cac-d9e90644c0fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"amplitudesB", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"MapThread", "[", 
      RowBox[{"ReplaceAll", ",", 
       RowBox[{"{", 
        RowBox[{"amplitudes2", ",", "momentamaps"}], "}"}]}], "]"}], "//", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"#", "*", 
       RowBox[{"BID", "^", "supersetindices"}]}], "&"}]}], "//", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"RunThroughFORM", "[", 
      RowBox[{"#", ",", 
       RowBox[{"FORMCodeToB", "[", "bases", "]"}]}], "]"}], "&"}]}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[110]:=",ExpressionUUID->"f4e9249e-49f9-493c-a85c-4b59858fbb10"],

Cell[BoxData[
 RowBox[{"amplitudesB", "//", 
  RowBox[{"CaseUnion", "[", "_Symbol", "]"}]}]], "Input",
 CellLabel->
  "In[106]:=",ExpressionUUID->"e525f6de-fd95-4c0b-8a42-23c53dec821a"],

Cell[BoxData[
 RowBox[{"amplitudesB", "//", 
  RowBox[{"CaseUnion", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", "head_", ")"}], "[", "___", "]"}], "\[RuleDelayed]", 
    "head"}], "]"}]}]], "Input",
 CellLabel->
  "In[107]:=",ExpressionUUID->"fecdc0b5-68e1-4359-8f53-c40ca674f0a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"integrallist", "=", 
   RowBox[{"amplitudesB", "//", 
    RowBox[{"CaseUnion", "[", "_B", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Need to know \>\"", ",", 
    RowBox[{"integrallist", "//", "Length"}], ",", 
    "\"\< different integrals\>\""}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[108]:=",ExpressionUUID->"c820025f-9dc4-4768-bf00-74f4aac6c7c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filter out zero integrals early", "Subsection",
 CellChangeTimes->{
  3.8265471865496693`*^9},ExpressionUUID->"e6b14a44-2262-4781-8dd6-\
34c323762c8c"],

Cell["\<\
Subsector of a family is a subset of its denominators.
Sector Id is a numerical notation for this subset: if
out of all D only D_{k} are present in a subsector,
then its Sector Id is Sum[2^(k-1)].\
\>", "Text",
 CellChangeTimes->{{3.8265472031099377`*^9, 
  3.8265472286448927`*^9}},ExpressionUUID->"a64f3464-6b0f-44fe-8eae-\
6ea384ae41cc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"IndicesToSectorId", "[", "idx_List", "]"}], ":=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"idx", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "===", "0"}], ",", "0", ",", 
       RowBox[{"2", "^", 
        RowBox[{"(", 
         RowBox[{"i", "-", "1"}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "idx", "]"}]}], "}"}]}], "]"}], "//", 
   RowBox[{"Apply", "[", "Plus", "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"SectorIdToIndices", "[", 
   RowBox[{"sector_Integer", ",", "ndens_Integer"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"sector", ",", "2", ",", "ndens"}], "]"}], "//", 
   "Reverse"}]}]}], "Input",ExpressionUUID->"6d895611-b0fa-4b51-a024-\
496e2e09e7d8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"IndicesToR", "[", "idx_List", "]"}], ":=", 
  RowBox[{
   RowBox[{"idx", "//", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"n", ">", "0"}]}], "\[RuleDelayed]", "n"}], "]"}]}], "//", 
   RowBox[{"Apply", "[", "Plus", "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"IndicesToDots", "[", "idx_List", "]"}], ":=", 
  RowBox[{
   RowBox[{"idx", "//", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"n", ">", "1"}]}], "\[RuleDelayed]", 
      RowBox[{"n", "-", "1"}]}], "]"}]}], "//", 
   RowBox[{"Apply", "[", "Plus", "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"IndicesToT", "[", "idx_List", "]"}], ":=", 
  RowBox[{"idx", "//", 
   RowBox[{"Count", "[", 
    RowBox[{"n_", "/;", 
     RowBox[{"n", ">", "0"}]}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"IndicesToS", "[", "idx_List", "]"}], ":=", 
  RowBox[{
   RowBox[{"idx", "//", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"n", "<", "0"}]}], "\[RuleDelayed]", 
      RowBox[{"-", "n"}]}], "]"}]}], "//", 
   RowBox[{"Apply", "[", "Plus", "]"}]}]}]}], "Input",ExpressionUUID->\
"b1eef72e-6f7e-434e-ab67-136de3ad49c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "List", " ", "zero", " ", "sectors", " ", "of", " ", "a", " ", "given", 
    " ", "basis", " ", "in", " ", "B", " ", 
    RowBox[{"notation", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ZeroSectors", "[", "bases_List", "]"}], ":=", 
    RowBox[{
     RowBox[{"bases", "//", 
      RowBox[{"Map", "[", "ZeroSectors", "]"}]}], "//", 
     RowBox[{"Apply", "[", "Join", "]"}]}]}], "\n", 
   RowBox[{
    RowBox[{"ZeroSectors", "[", "basis_", "]"}], ":=", 
    RowBox[{
     RowBox[{"RunThrough", "[", 
      RowBox[{"\"\<./feynson/feynson zero-sectors -sq -j1 -\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"basis", "[", "\"\<denominators\>\"", "]"}], "/.", 
            RowBox[{
             RowBox[{"den", "[", "p_", "]"}], "\[RuleDelayed]", 
             RowBox[{"p", "^", "2"}]}]}], "/.", 
           RowBox[{
            RowBox[{"den", "[", 
             RowBox[{"p_", ",", "m_"}], "]"}], "\[RuleDelayed]", 
            RowBox[{
             RowBox[{"p", "^", "2"}], "-", "m"}]}]}], "/.", 
          RowBox[{
           RowBox[{"den", "[", 
            RowBox[{"p_", ",", "m_", ",", "irr"}], "]"}], "\[RuleDelayed]", 
           RowBox[{
            RowBox[{"p", "^", "2"}], "-", "m"}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"basis", "[", "\"\<denominators\>\"", "]"}], "/.", 
           RowBox[{
            RowBox[{"den", "[", 
             RowBox[{"_", ",", "_", ",", "cut"}], "]"}], "\[Rule]", "1"}]}], "/.", 
          RowBox[{
           RowBox[{"den", "[", "___", "]"}], "\[Rule]", "0"}]}], ",", 
         RowBox[{"basis", "[", "\"\<loopmom\>\"", "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"basis", "[", "\"\<sprules\>\"", "]"}], "/.", 
           RowBox[{"Rule", "\[Rule]", "List"}]}], "/.", 
          RowBox[{"sp", "\[Rule]", "Times"}]}]}], "}"}]}], "]"}], "//", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{
         RowBox[{"basis", "[", "\"\<id\>\"", "]"}], ",", 
         RowBox[{"Sequence", "@@", 
          RowBox[{"SectorIdToIndices", "[", 
           RowBox[{"#", ",", 
            RowBox[{"Length", "[", 
             RowBox[{"basis", "[", "\"\<denominators\>\"", "]"}], "]"}]}], 
           "]"}]}]}], "]"}], "&"}], "]"}]}]}]}]}]], "Input",ExpressionUUID->\
"95eb2221-79be-49de-9a4c-79282a2ae3a8"],

Cell[BoxData[
 RowBox[{"zerosectors", "=", 
  RowBox[{"ZeroSectors", "[", "bases", "]"}]}]], "Input",
 CellLabel->
  "In[128]:=",ExpressionUUID->"88997b88-b765-4968-ab52-206ea81d0b6f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ZeroSectorPattern", "[", "basis_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ZeroSectors", "[", "basis", "]"}], "//", 
    RowBox[{"Map", "[", 
     RowBox[{"Replace", "[", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"bid_", ",", "idx__"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"B", "[", 
        RowBox[{"bid", ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"{", "idx", "}"}], "/.", 
            RowBox[{"1", "\[Rule]", "_"}]}], "/.", 
           RowBox[{"0", "\[Rule]", 
            RowBox[{"_", "?", "NonPositive"}]}]}], "//", 
          RowBox[{"Apply", "[", "Sequence", "]"}]}]}], "]"}]}], "]"}], 
     "]"}]}], "//", 
   RowBox[{"Apply", "[", "Alternatives", "]"}]}]}]], "Input",
 CellLabel->
  "In[129]:=",ExpressionUUID->"3828a45e-4d09-401b-97ad-2e6a66495bcd"],

Cell[BoxData[
 RowBox[{"zerosectorpattern", "=", 
  RowBox[{"ZeroSectorPattern", "[", "bases", "]"}]}]], "Input",
 CellLabel->
  "In[133]:=",ExpressionUUID->"75d0b63b-b9f0-4390-880d-063d7dc077d8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"integrallist2", "=", 
   RowBox[{"integrallist", "//", 
    RowBox[{"DeleteCases", "[", "zerosectorpattern", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Out of all \>\"", ",", 
    RowBox[{"integrallist", "//", "Length"}], ",", "\"\< there are only \>\"",
     ",", 
    RowBox[{"integrallist2", "//", "Length"}], ",", 
    "\"\< non-zero ints\>\""}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[134]:=",ExpressionUUID->"e9988e07-74ab-47d6-96d1-a5b51bc231c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FORMCodeZeroSectors", "[", "zerosectors_List", "]"}], ":=", 
  RowBox[{"zerosectors", "//", 
   RowBox[{"Map", "[", 
    RowBox[{"Replace", "[", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"bid_", ",", "idx__"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"\"\<id B(\>\"", ",", "bid", ",", 
        RowBox[{"MapIndexed", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ReplaceAll", "[", 
            RowBox[{"#1", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<, tmpx\>\"", ",", "#2", ",", "\"\<?neg0_\>\""}],
                  "}"}]}], ",", 
               RowBox[{"1", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<, tmpx\>\"", ",", "#2", ",", "\"\<?\>\""}], 
                 "}"}]}]}], "}"}]}], "]"}], "&"}], ",", 
          RowBox[{"{", "idx", "}"}]}], "]"}], ",", "\"\<) = 0;\\n\>\""}], 
       "}"}]}], "]"}], "]"}]}]}]], "Input",
 CellLabel->
  "In[136]:=",ExpressionUUID->"d514fa35-89d0-4468-b5ac-495845365757"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FORMCodeZeroSectors", "[", "zerosectors", "]"}], "//", 
    "MkString"}], "//", "Print"}], ";"}]], "Input",
 CellLabel->
  "In[137]:=",ExpressionUUID->"7ba48378-9091-4c89-aa54-971aa41b2a24"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"amplitudesB2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"MapThread", "[", 
      RowBox[{"ReplaceAll", ",", 
       RowBox[{"{", 
        RowBox[{"amplitudes2", ",", "momentamaps"}], "}"}]}], "]"}], "//", 
     RowBox[{
      RowBox[{"#", "*", 
       RowBox[{"BID", "^", "supersetindices"}]}], "&"}]}], "//", 
    RowBox[{
     RowBox[{"RunThroughFORM", "[", 
      RowBox[{"#", ",", 
       RowBox[{"FORMCodeToB", "[", "bases", "]"}], ",", 
       RowBox[{"FORMCodeZeroSectors", "[", "zerosectors", "]"}]}], "]"}], 
     "&"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dropping zero integrals early is \>\"", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"ByteCount", "[", "amplitudesB", "]"}], "/", 
      RowBox[{"ByteCount", "[", "amplitudesB2", "]"}]}], "//", "N"}], ",", 
    "\"\< times better\>\""}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[138]:=",ExpressionUUID->"e06cf953-53d9-4f79-99c7-d32f1aec05b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving IBP relations with Kira", "Subsection",ExpressionUUID->"2b5fab19-f168-478e-b729-9dfcb3e3dc05"],

Cell["\<\
https://gitlab.com/kira-pyred/kira
https://kira.hepforge.org/

https://arxiv.org/abs/1705.05610
https://arxiv.org/abs/2008.06494

To define a job for Kira we need multiple files (in a separate directory):
-\[OpenCurlyDoubleQuote]config/kinematics.yaml\[CloseCurlyDoubleQuote] with \
the definition of kinematics;
-\[OpenCurlyDoubleQuote]config/integralfamilies.yaml\[CloseCurlyDoubleQuote] \
with the definition of integral families;
-files with lists of integrals we care about (one file per integral family);
-a jobs file (e.g.\[CloseCurlyDoubleQuote]jobs.yaml\[CloseCurlyDoubleQuote]) \
tying it all together.\
\>", "Text",ExpressionUUID->"d56ce805-fbb8-43e2-829b-38094ad12a5a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "[", 
   RowBox[{
    RowBox[{"CreateDirectory", "[", "\"\<kira-files/config\>\"", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"CreateDirectory", "::", "filex"}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.826547171905283*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"d1245666-ff80-48b3-9749-c49382a5d7e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Kira", " ", "sorts", " ", "bases", " ", "by", " ", "name", " ", 
     "instead", " ", "of", " ", "adhering", " ", "to", " ", "the", " ", 
     "order", "\[IndentingNewLine]", "of", " ", 
     RowBox[{"definition", ".", " ", "We"}], " ", "shall", " ", "make", " ", 
     "sure", " ", "that", " ", "both", " ", "the", " ", "numerical", 
     "\[IndentingNewLine]", "and", " ", "the", " ", "lexicographic", " ", 
     "orders", " ", "match"}], ",", " ", 
    RowBox[{
    "which", " ", "will", " ", "prevent", " ", "Kira", "\[IndentingNewLine]", 
     "from", " ", "messing", " ", "it", " ", 
     RowBox[{"up", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"KiraBasisName", "[", "basisid_", "]"}], ":=", 
   RowBox[{"MkString", "[", 
    RowBox[{"\"\<b\>\"", ",", 
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"basisid", ",", "10", ",", "5"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->
  "In[141]:=",ExpressionUUID->"7c4a3edd-0fdc-4077-b4c1-877cd551c2f4"],

Cell[BoxData[
 RowBox[{"KiraBasisName", "[", "1", "]"}]], "Input",
 CellLabel->
  "In[142]:=",ExpressionUUID->"2f1d7d6f-767d-40e2-8d92-63a7d32c9791"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Create", " ", "Kira", " ", "integral", " ", "list", " ", "files", " ", 
     "in", " ", "the", " ", "given", " ", 
     RowBox[{"directory", ".", "\[IndentingNewLine]", "Kira"}], " ", 
     "insists", " ", "on", " ", "separate", " ", "files", " ", "for", " ", 
     "each", " ", "integral", " ", "family"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{
    "so", " ", "multiple", " ", "files", " ", "with", " ", "names", " ", 
     "\"\<b00xxx.integrals\>\"", " ", "will", " ", "be", " ", "created"}], 
    ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"one", " ", "for", " ", "each", " ", 
     RowBox[{"basis", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MkKiraIntegralList", "[", 
    RowBox[{"dirname_", ",", "blist_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"basisids", ",", "basisid", ",", "idlist"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"basisids", "=", 
       RowBox[{"blist", "//", 
        RowBox[{"CaseUnion", "[", 
         RowBox[{
          RowBox[{"B", "[", 
           RowBox[{"basisid_", ",", "___"}], "]"}], "\[RuleDelayed]", 
          "basisid"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"MkFile", "[", 
          RowBox[{
           RowBox[{"dirname", "<>", "\"\</\>\"", "<>", 
            RowBox[{"KiraBasisName", "[", "basisid", "]"}], "<>", 
            "\"\<.integrals\>\""}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"blist", "//", "\[IndentingNewLine]", 
             RowBox[{"CaseUnion", "[", 
              RowBox[{
               RowBox[{"B", "[", 
                RowBox[{"basisid", ",", "idx__"}], "]"}], "\[RuleDelayed]", 
               RowBox[{"{", "idx", "}"}]}], "]"}]}], "//", 
            "\[IndentingNewLine]", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"KiraBasisName", "[", "basisid", "]"}], ",", 
                "\"\<[\>\"", ",", 
                RowBox[{"Riffle", "[", 
                 RowBox[{"#", ",", "\"\<,\>\""}], "]"}], ",", 
                "\"\<]\\n\>\""}], "}"}], "&"}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"basisid", ",", "basisids"}], "}"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Input",ExpressionUUID->"e27ce882-abc6-\
4de4-9ed0-343cbc4d4dd7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MkKiraIntegralList", "[", 
   RowBox[{"\"\<kira-files/\>\"", ",", "integrallist2"}], "]"}], 
  ";"}]], "Input",
 CellLabel->
  "In[144]:=",ExpressionUUID->"82078444-148c-4402-a12e-08f3c9cccc5e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MkKiraKinematicsYaml", "[", 
    RowBox[{"filename_", ",", "extmom_List", ",", "sprules_List"}], "]"}], ":=", 
   RowBox[{"MkFile", "[", 
    RowBox[{
    "filename", ",", "\[IndentingNewLine]", "\"\<kinematics:\\n\>\"", ",", 
     "\[IndentingNewLine]", "\"\< incoming_momenta: [\>\"", ",", 
     RowBox[{"extmom", "//", 
      RowBox[{
       RowBox[{"Riffle", "[", 
        RowBox[{"#", ",", "\"\<, \>\""}], "]"}], "&"}]}], ",", "\"\<]\\n\>\"",
      ",", "\[IndentingNewLine]", "\"\< kinematic_invariants:\\n\>\"", ",", 
     "\[IndentingNewLine]", "\"\<  - [mt2, 2]\\n\>\"", ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"sprules", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}], "//", 
        RowBox[{"Cases", "[", "_Symbol", "]"}]}], "//", "Union"}], "//", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<  - [\>\"", ",", "#", ",", "\"\<, 2]\\n\>\""}], "}"}], 
        "&"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"sprules", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}], "//", 
        RowBox[{"Cases", "[", 
         RowBox[{"_Symbol", "^", "2"}], "]"}]}], "//", "Union"}], "//", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<  - [\>\"", ",", "#", ",", "\"\<, 1]\\n\>\""}], "}"}], 
        "&"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "\"\< scalarproduct_rules:\\n\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sprules", "//", "\[IndentingNewLine]", 
        RowBox[{"ReplaceAll", "[", 
         RowBox[{"sp", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"sp", "/*", "Sort"}], ")"}]}], "]"}]}], "//", 
       "\[IndentingNewLine]", "Union"}], "//", 
      RowBox[{"Map", "[", 
       RowBox[{"Replace", "[", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sp", "[", "p_", "]"}], "\[Rule]", "v_"}], ")"}], 
           "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{"\"\<  - [[\>\"", ",", 
             RowBox[{"p", "//", "InputForm"}], ",", "\"\<,\>\"", ",", 
             RowBox[{"p", "//", "InputForm"}], ",", "\"\<], \>\"", ",", 
             RowBox[{"v", "//", "InputForm"}], ",", "\"\<]\\n\>\""}], "}"}]}],
           ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sp", "[", 
              RowBox[{"p1_", ",", "p2_"}], "]"}], "\[Rule]", "v_"}], ")"}], 
           "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{"\"\<  - [[\>\"", ",", 
             RowBox[{"p1", "//", "InputForm"}], ",", "\"\<,\>\"", ",", 
             RowBox[{"p2", "//", "InputForm"}], ",", "\"\<], \>\"", ",", 
             RowBox[{"v", "//", "InputForm"}], ",", "\"\<]\\n\>\""}], 
            "}"}]}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "\"\<# symbol_to_replace_by_one: sqrq\>\""}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[145]:=",ExpressionUUID->"61eb1d8c-84c7-47d2-a8e7-6cef437af554"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MkKiraKinematicsYaml", "[", 
   RowBox[{"\"\<kira-files/config/kinematics.yaml\>\"", ",", 
    RowBox[{"bases", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "\"\<externalmom\>\""}], "]"}], "]"}], ",", 
    RowBox[{"bases", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "\"\<sprules\>\""}], "]"}], "]"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->
  "In[152]:=",ExpressionUUID->"bb8b876b-42bc-4bc0-bdc2-12c5cbbb1be9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MkKiraIntegralFamiliesYaml", "[", 
   RowBox[{"filename_", ",", "bases_List"}], "]"}], ":=", 
  RowBox[{"MkKiraIntegralFamiliesYaml", "[", 
   RowBox[{"filename", ",", "bases", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", "\"\<denominators\>\"", "]"}], "//", 
        RowBox[{"Map", "[", 
         RowBox[{"Replace", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"den", "[", 
             RowBox[{"_", ",", "_", ",", "irr"}], "]"}], "\[Rule]", "0"}], 
           ",", 
           RowBox[{"_den", "\[Rule]", "1"}]}], "]"}], "]"}]}], "//", 
       "IndicesToSectorId"}], ")"}], "&"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"MkKiraIntegralFamiliesYaml", "[", 
   RowBox[{"filename_", ",", "bases_List", ",", "topsectors_"}], "]"}], ":=", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"loopmom", ",", "extmom", ",", "dens", ",", "basis"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MkFile", "[", 
      RowBox[{
      "filename", ",", "\[IndentingNewLine]", "\"\<integralfamilies:\\n\>\"", 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"loopmom", "=", 
           RowBox[{"basis", "[", "\"\<loopmom\>\"", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"extmom", "=", 
           RowBox[{"basis", "[", "\"\<externalmom\>\"", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"dens", "=", 
           RowBox[{"basis", "[", "\"\<denominators\>\"", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"\"\<  - name: \\\"\>\"", ",", 
            RowBox[{"KiraBasisName", "[", 
             RowBox[{"basis", "[", "\"\<id\>\"", "]"}], "]"}], ",", 
            "\"\<\\\"\\n\>\"", ",", "\[IndentingNewLine]", 
            "\"\<    loop_momenta: [\>\"", ",", 
            RowBox[{"Riffle", "[", 
             RowBox[{"loopmom", ",", "\"\<, \>\""}], "]"}], ",", 
            "\"\<]\\n\>\"", ",", "\[IndentingNewLine]", 
            "\"\<    top_level_sectors: [\>\"", ",", 
            RowBox[{
             RowBox[{"dens", "//", 
              RowBox[{"Map", "[", 
               RowBox[{"Replace", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"den", "[", 
                   RowBox[{"_", ",", "_", ",", "irr"}], "]"}], "\[Rule]", 
                  "0"}], ",", 
                 RowBox[{"_den", "\[Rule]", "1"}]}], "]"}], "]"}]}], "//", 
             "IndicesToSectorId"}], ",", "\"\<]\\n\>\"", ",", 
            "\[IndentingNewLine]", "\"\<    propagators:\\n\>\"", ",", 
            "\[IndentingNewLine]", 
            RowBox[{"dens", "//", "\[IndentingNewLine]", 
             RowBox[{"Map", "[", 
              RowBox[{"Replace", "[", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"den", "[", "p_", "]"}], "|", 
                   RowBox[{"den", "[", 
                    RowBox[{"p_", ",", "0", ",", "___"}], "]"}]}], 
                  "\[RuleDelayed]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<      - [\\\"\>\"", ",", 
                    RowBox[{"CForm", "[", "p", "]"}], ",", 
                    "\"\<\\\", 0]\\n\>\""}], "}"}]}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"den", "[", 
                   RowBox[{"p_", ",", "m_", ",", "___"}], "]"}], 
                  "\[RuleDelayed]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<      - [\\\"\>\"", ",", 
                    RowBox[{"CForm", "[", "p", "]"}], ",", 
                    "\"\<\\\", \\\"\>\"", ",", 
                    RowBox[{"CForm", "[", 
                    RowBox[{"m", "/.", 
                    RowBox[{
                    RowBox[{"sp", "[", "q", "]"}], "\[Rule]", "qq"}]}], "]"}],
                     ",", "\"\<\\\"]\\n\>\""}], "}"}]}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"d_", "\[RuleDelayed]", 
                  RowBox[{"Error", "[", 
                   RowBox[{
                   "\"\<MkKiraConfig: bad denominator form: \>\"", ",", "d"}],
                    "]"}]}]}], "}"}], "]"}], "\[IndentingNewLine]", "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{"dens", ",", "cut"}], "]"}], "//", "Not"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"\"\<    cut_propagators: [\>\"", ",", 
                RowBox[{"Riffle", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Range", "[", 
                    RowBox[{"Length", "[", "dens", "]"}], "]"}], "//", 
                   RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    RowBox[{"dens", "[", 
                    RowBox[{"[", "#", "]"}], "]"}], ",", 
                    RowBox[{"den", "[", 
                    RowBox[{"_", ",", "_", ",", "cut"}], "]"}]}], "]"}], 
                    "&"}], "]"}]}], ",", "\"\<, \>\""}], "]"}], ",", 
                "\"\<]\\n\>\""}], "}"}], "\[IndentingNewLine]", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"basis", ",", "bases"}], "}"}]}], "]"}]}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",ExpressionUUID->"80a85719-d59e-\
4873-90f6-ad79ec960a2c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MkKiraJobsYaml", "[", 
   RowBox[{
   "filename_", ",", "bids_List", ",", "topsectors_", ",", "mode_String"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"bid", ",", "sector"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MkFile", "[", 
      RowBox[{
      "filename", ",", "\[IndentingNewLine]", "\"\<jobs:\\n\>\"", ",", 
       "\"\< - reduce_sectors:\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<    reduce:\\n\>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<     - {topologies: [\>\"", ",", 
           RowBox[{"KiraBasisName", "[", "bid", "]"}], ",", 
           "\"\<], sectors: [\>\"", ",", 
           RowBox[{"sector", "[", "\"\<id\>\"", "]"}], ",", "\"\<], r: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<r\>\"", "]"}], ",", "\"\<, s: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<s\>\"", "]"}], ",", "\"\<}\\n\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"bid", ",", "bids"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"sector", ",", 
           RowBox[{"topsectors", "[", "bid", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
       "\"\<    select_integrals:\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<     select_mandatory_list:\\n\>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<      - [\>\"", ",", 
           RowBox[{"KiraBasisName", "[", "bid", "]"}], ",", "\"\<, \\\"\>\"", 
           ",", 
           RowBox[{"KiraBasisName", "[", "bid", "]"}], ",", 
           "\"\<.integrals\\\"]\\n\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"{", 
          RowBox[{"bid", ",", "bids"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       "\"\<#     select_mandatory_recursively:\\n\>\"", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<#      - {topologies: [\>\"", ",", 
           RowBox[{"KiraBasisName", "[", "bid", "]"}], ",", 
           "\"\<], sectors: [\>\"", ",", 
           RowBox[{"sector", "[", "\"\<id\>\"", "]"}], ",", "\"\<], r: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<r\>\"", "]"}], ",", "\"\<, s: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<s\>\"", "]"}], ",", "\"\<, d: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<d\>\"", "]"}], ",", "\"\<}\\n\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"bid", ",", "bids"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"sector", ",", 
           RowBox[{"topsectors", "[", "bid", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
       "\"\<    integral_ordering: 8\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<    run_symmetries: true\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<    run_initiate: true\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<    run_triangular: true\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<    run_back_substitution: true\\n\>\"", ",", 
       "\[IndentingNewLine]", "\"\< - kira2math:\\n\>\"", ",", 
       "\[IndentingNewLine]", "\"\<    target:\\n\>\"", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<     - [\>\"", ",", 
           RowBox[{"KiraBasisName", "[", "bid", "]"}], ",", "\"\<, \\\"\>\"", 
           ",", 
           RowBox[{"KiraBasisName", "[", "bid", "]"}], ",", 
           "\"\<.integrals\\\"]\\n\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"{", 
          RowBox[{"bid", ",", "bids"}], "}"}]}], "\[IndentingNewLine]", "]"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<#     - {topologies: [\>\"", ",", 
           RowBox[{"KiraBasisName", "[", "bid", "]"}], ",", 
           "\"\<], sectors: [\>\"", ",", 
           RowBox[{"sector", "[", "\"\<id\>\"", "]"}], ",", "\"\<], r: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<r\>\"", "]"}], ",", "\"\<, s: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<s\>\"", "]"}], ",", "\"\<, d: \>\"", 
           ",", 
           RowBox[{"sector", "[", "\"\<d\>\"", "]"}], ",", "\"\<}\\n\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"bid", ",", "bids"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"sector", ",", 
           RowBox[{"topsectors", "[", "bid", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
       "\"\<    reconstruct_mass: false\\n\>\""}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->
  "In[153]:=",ExpressionUUID->"58d1a8dc-1c00-4f91-b90a-0f96b7669e54"],

Cell[BoxData[
 RowBox[{
  RowBox[{"KiraTopSectors", "[", "idxlist_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "tops", ",", "sector2r", ",", "sector2s", ",", "sector2d", ",", 
      "s2sectors", ",", "int", ",", "sector", ",", "r", ",", "s", ",", "d", 
      ",", "sectors", ",", "done", ",", "i", ",", "ss"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"tops", "=", 
      RowBox[{
       RowBox[{"idxlist", "//", 
        RowBox[{"Map", "[", "IndicesToS", "]"}]}], "//", 
       RowBox[{
        RowBox[{"Max", "[", 
         RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"sector2r", "=", 
      RowBox[{"<|", "|>"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sector2s", "=", 
      RowBox[{"<|", "|>"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sector2d", "=", 
      RowBox[{"<|", "|>"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s2sectors", "=", 
      RowBox[{"Association", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"s", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "0", ",", "tops"}], "}"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sector", "=", 
         RowBox[{"IndicesToSectorId", "[", "int", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{"IndicesToR", "[", "int", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s", "=", 
         RowBox[{"IndicesToS", "[", "int", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"d", "=", 
         RowBox[{"IndicesToDots", "[", "int", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{
          RowBox[{"s2sectors", "[", "s", "]"}], ",", "sector"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sector2r", "[", "sector", "]"}], "=", 
         RowBox[{"Max", "[", 
          RowBox[{"r", ",", 
           RowBox[{
            RowBox[{"sector2r", "[", "sector", "]"}], "/.", 
            RowBox[{"_Missing", "\[Rule]", "0"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sector2d", "[", "sector", "]"}], "=", 
         RowBox[{"Max", "[", 
          RowBox[{"d", ",", 
           RowBox[{
            RowBox[{"sector2d", "[", "sector", "]"}], "/.", 
            RowBox[{"_Missing", "\[Rule]", "0"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
           RowBox[{"Note", ":", " ", "s"}], "=", 
           RowBox[{
            RowBox[{
            "0", " ", "makes", " ", "Kira", " ", "produce", " ", "false", " ", 
             RowBox[{"masters", ".", " ", 
              RowBox[{"It", "'"}]}], "s", " ", "not", " ", "clear", " ", "if",
              " ", "we", " ", "should", " ", "only", " ", "fix", " ", "s"}], 
            "=", 
            RowBox[{"0", " ", "case"}]}]}], ",", " ", 
          RowBox[{
           RowBox[{
           "or", " ", "if", " ", "we", " ", "need", " ", "to", " ", "add"}], 
           " ", "+", 
           RowBox[{"1", " ", "to", " ", "all", " ", 
            RowBox[{"s", ".", " ", "Currently"}], " ", 
            RowBox[{"we", "'"}], "re", " ", "doing", " ", "the", " ", 
            RowBox[{"former", "."}]}]}]}], "*)"}], 
        RowBox[{
         RowBox[{"sector2s", "[", "sector", "]"}], "=", 
         RowBox[{"Max", "[", 
          RowBox[{"s", ",", 
           RowBox[{
            RowBox[{"sector2s", "[", "sector", "]"}], "/.", 
            RowBox[{"_Missing", "\[Rule]", "1"}]}]}], "]"}]}], ";"}], ",", 
       RowBox[{"{", 
        RowBox[{"int", ",", "idxlist"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", "\"\<* Sectors by numerator power sum (s)\>\"", "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"sectors", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"done", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"s", "=", "tops"}], ",", 
       RowBox[{"s", "\[GreaterEqual]", "0"}], ",", 
       RowBox[{"s", "--"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"s2sectors", "[", "s", "]"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"s2sectors", "[", "s", "]"}], "//", "Union"}], "//", 
          "Reverse"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{"done", ",", "sector"}], "]"}], ",", 
             RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"i", "=", 
            RowBox[{"FirstPosition", "[", 
             RowBox[{"done", ",", 
              RowBox[{"ss_", "/;", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"BitAnd", "[", 
                  RowBox[{"ss", ",", "sector"}], "]"}], "===", "sector"}], 
                ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MatchQ", "[", 
              RowBox[{"i", ",", "_Missing"}], "]"}], ",", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{"done", ",", "sector"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"sectors", ",", "sector"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<Unique sector: \>\"", ",", "sector", ",", 
                "\"\<, nprops=\>\"", ",", 
                RowBox[{"DigitCount", "[", 
                 RowBox[{"sector", ",", "2", ",", "1"}], "]"}], ",", 
                "\"\<, r=\>\"", ",", 
                RowBox[{"sector2r", "[", "sector", "]"}], ",", "\"\<, s=\>\"",
                 ",", 
                RowBox[{"sector2s", "[", "sector", "]"}], ",", "\"\<, d=\>\"",
                 ",", 
                RowBox[{"sector2d", "[", "sector", "]"}]}], "]"}], ";"}], ",", 
             RowBox[{
              RowBox[{"i", "=", 
               RowBox[{"i", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
              
              RowBox[{"Print", "[", 
               RowBox[{"\"\<Subsector of \>\"", ",", 
                RowBox[{"done", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<: \>\"", ",", 
                "sector", ",", "\"\<, nprops=\>\"", ",", 
                RowBox[{"DigitCount", "[", 
                 RowBox[{"sector", ",", "2", ",", "1"}], "]"}], ",", 
                "\"\<, r=\>\"", ",", 
                RowBox[{"sector2r", "[", "sector", "]"}], ",", "\"\<, s=\>\"",
                 ",", 
                RowBox[{"sector2s", "[", "sector", "]"}], ",", "\"\<, d=\>\"",
                 ",", 
                RowBox[{"sector2d", "[", "sector", "]"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"sector2r", "[", 
                RowBox[{"done", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}], "=", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{"sector2r", "[", "sector", "]"}], ",", 
                 RowBox[{"sector2r", "[", 
                  RowBox[{"done", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"sector2d", "[", 
                RowBox[{"done", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}], "=", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{"sector2d", "[", "sector", "]"}], ",", 
                 RowBox[{"sector2d", "[", 
                  RowBox[{"done", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"sector2s", "[", 
                RowBox[{"done", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}], "=", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{"sector2s", "[", "sector", "]"}], ",", 
                 RowBox[{"sector2s", "[", 
                  RowBox[{"done", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "]"}]}], ";"}]}], 
            "]"}], ";"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"sector", ",", 
            RowBox[{"s2sectors", "[", "s", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "We", " ", "need", " ", "to", " ", "make", " ", "sure", " ", "each", 
        " ", "sector", " ", "has", " ", "more", " ", "integrals", " ", "than",
         " ", "masters"}], ",", " ", 
       RowBox[{
       "otherwise", " ", "Kira", " ", "will", " ", "have", " ", "nothing", 
        " ", "to", " ", "work", " ", "with"}], ",", 
       RowBox[{"and", " ", 
        RowBox[{"we", "'"}], "ll", " ", "miss", " ", "masters", " ", "in", 
        " ", "the", " ", "IBP", " ", 
        RowBox[{"table", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sector2s", "[", "sector", "]"}], "=", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"sector2s", "[", "sector", "]"}], ",", "1"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sector2d", "[", "sector", "]"}], "=", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"sector2d", "[", "sector", "]"}], ",", "1"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sector2r", "[", "sector", "]"}], "=", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"sector2r", "[", "sector", "]"}], ",", 
           RowBox[{"DigitCount", "[", 
            RowBox[{"sector", ",", "2", ",", "1"}], "]"}]}], "]"}]}], ";"}], 
       "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"sector", ",", "sectors"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\<Final sectors:\>\"", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<- \>\"", ",", "sector", ",", "\"\< \>\"", ",", 
          RowBox[{
           RowBox[{"IntegerDigits", "[", 
            RowBox[{"sector", ",", "2", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"First", "[", "idxlist", "]"}], "]"}]}], "]"}], "//", 
           "Reverse"}], ",", "\"\<, nprops=\>\"", ",", 
          RowBox[{"DigitCount", "[", 
           RowBox[{"sector", ",", "2", ",", "1"}], "]"}], ",", "\"\<, r=\>\"",
           ",", 
          RowBox[{"sector2r", "[", "sector", "]"}], ",", "\"\<, s=\>\"", ",", 
          
          RowBox[{"sector2s", "[", "sector", "]"}], ",", "\"\<, d=\>\"", ",", 
          
          RowBox[{"sector2d", "[", "sector", "]"}]}], "]"}], ";"}], ",", 
       RowBox[{"{", 
        RowBox[{"sector", ",", "sectors"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<id\>\"", "\[Rule]", "sector"}], ",", 
         RowBox[{"\"\<r\>\"", "\[Rule]", 
          RowBox[{"sector2r", "[", "sector", "]"}]}], ",", 
         RowBox[{"\"\<s\>\"", "\[Rule]", 
          RowBox[{"sector2s", "[", "sector", "]"}]}], ",", 
         RowBox[{"\"\<d\>\"", "\[Rule]", 
          RowBox[{"sector2d", "[", "sector", "]"}]}]}], "|>"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"sector", ",", "sectors"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"e0cd9b0e-4b02-4628-a505-9c0d340127e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MkKiraConfig", "[", 
   RowBox[{"dirname_", ",", "bases_List", ",", "blist_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"bid", ",", "bids", ",", "bid2topsectors", ",", "idxlist"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"FileExistsQ", "[", "dirname", "]"}], "]"}], ",", 
       RowBox[{"CreateDirectory", "[", "dirname", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"FileExistsQ", "[", 
         RowBox[{"dirname", "<>", "\"\</config\>\""}], "]"}], "]"}], ",", 
       RowBox[{"CreateDirectory", "[", 
        RowBox[{"dirname", "<>", "\"\</config\>\""}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bids", "=", 
      RowBox[{"blist", "//", 
       RowBox[{"CaseUnion", "[", 
        RowBox[{
         RowBox[{"B", "[", 
          RowBox[{"bid_", ",", "___"}], "]"}], "\[RuleDelayed]", "bid"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bid2topsectors", "=", 
      RowBox[{
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"idxlist", "=", 
           RowBox[{"blist", "//", 
            RowBox[{"CaseUnion", "[", 
             RowBox[{
              RowBox[{"B", "[", 
               RowBox[{"bid", ",", "idx__"}], "]"}], "\[RuleDelayed]", 
              RowBox[{"{", "idx", "}"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"bid", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"idxlist", "//", "KiraTopSectors"}], "//", "Sort"}], 
            ")"}]}]}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"bid", ",", "bids"}], "}"}]}], "\[IndentingNewLine]", "]"}],
        "//", "Association"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"MkKiraKinematicsYaml", "[", 
      RowBox[{
       RowBox[{"dirname", "<>", "\"\</config/kinematics.yaml\>\""}], ",", 
       RowBox[{"bases", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "\"\<externalmom\>\""}], "]"}], "]"}], ",", 
       RowBox[{"bases", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "\"\<sprules\>\""}], "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MkKiraIntegralFamiliesYaml", "[", 
      RowBox[{
       RowBox[{"dirname", "<>", "\"\</config/integralfamilies.yaml\>\""}], 
       ",", "bases", ",", "bid2topsectors"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MkKiraJobsYaml", "[", 
      RowBox[{
       RowBox[{"dirname", "<>", "\"\</jobs.yaml\>\""}], ",", "bids", ",", 
       "bid2topsectors", ",", "\"\<all\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MkKiraIntegralList", "[", 
      RowBox[{"dirname", ",", "blist"}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"ab546653-256d-4528-824b-c68fd4b4d165"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Run", "[", "\"\<rm -rf kira-files\>\"", "]"}], ";"}], "\n", 
 RowBox[{"MkKiraConfig", "[", 
  RowBox[{"\"\<kira-files\>\"", ",", "bases", ",", "integrallist2"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.826547160974935*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"9214ad4e-83a5-4b4e-8bb6-4de90ff082c7"],

Cell[BoxData[
 RowBox[{"Run", "[", 
  "\"\<cd kira-files && rm -rf results sectormappings tmp && env \
FERMATPATH=$PWD/../fermat/fer64 ../kira/kira jobs.yaml\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.826547159471726*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"24f61866-73ef-485c-b9ca-e678ddf6183a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<Master integrals:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
   "FileNames", "[", "\"\<kira-files/results/b*/masters.final\>\"", "]"}], "//", 
   RowBox[{"Map", "[", 
    RowBox[{"ReadString", "/*", "Print"}], "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[163]:=",ExpressionUUID->"048fa36a-4982-41b6-bb4b-389582a4bc32"],

Cell[BoxData[
 RowBox[{
  RowBox[{"KiraApplyResults", "[", 
   RowBox[{"ex_", ",", "confdir_String", ",", "bases_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "exx", ",", "basisids", ",", "basisid", ",", "filename", ",", "map"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"exx", "=", "ex"}], ";", "\[IndentingNewLine]", 
     RowBox[{"basisids", "=", 
      RowBox[{"ex", "//", 
       RowBox[{"CaseUnion", "[", 
        RowBox[{
         RowBox[{"B", "[", 
          RowBox[{"basisid_", ",", "__"}], "]"}], "\[RuleDelayed]", 
         "basisid"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"filename", "=", 
         RowBox[{"MkString", "[", 
          RowBox[{"confdir", ",", "\"\</results/\>\"", ",", 
           RowBox[{"KiraBasisName", "[", "basisid", "]"}], ",", 
           "\"\</kira_\>\"", ",", 
           RowBox[{"KiraBasisName", "[", "basisid", "]"}], ",", 
           "\"\<.integrals.m\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"map", "=", 
         RowBox[{"Get", "[", "filename", "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"map", "===", "$Failed"}], ",", 
          RowBox[{"Error", "[", 
           RowBox[{"\"\<Failed to load: \>\"", ",", "filename"}], "]"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"map", "=", 
         RowBox[{"map", "/.", 
          RowBox[{
           RowBox[{
            RowBox[{"ToExpression", "[", 
             RowBox[{"KiraBasisName", "[", "basisid", "]"}], "]"}], "[", 
            "idx__", "]"}], "\[RuleDelayed]", 
           RowBox[{"B", "[", 
            RowBox[{"basisid", ",", "idx"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"exx", "=", 
         RowBox[{"exx", "/.", "map"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"map", "=", "None"}], ";"}], ",", 
       RowBox[{"{", 
        RowBox[{"basisid", ",", "basisids"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "exx"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[165]:=",ExpressionUUID->"6e5734c8-cfa9-4c18-8b7c-69b127fbbe4a"],

Cell[BoxData[
 RowBox[{"amplitudesIBP", "=", 
  RowBox[{"KiraApplyResults", "[", 
   RowBox[{"amplitudesB2", ",", "\"\<kira-files\>\"", ",", "bases"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.826547155099476*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"607eced4-5879-418e-adfc-67d9db79135d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"masters", "=", 
   RowBox[{"amplitudesIBP", "//", 
    RowBox[{"CaseUnion", "[", "_B", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Previously we had \>\"", ",", 
    RowBox[{
     RowBox[{"amplitudesB2", "//", 
      RowBox[{"CaseUnion", "[", "_B", "]"}]}], "//", "Length"}], ",", 
    "\"\< integrals\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Now we have \>\"", ",", 
    RowBox[{"masters", "//", "Length"}], ",", "\"\< integrals\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.8265471539793453`*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"23635db6-cd66-496a-844e-5d63040f8caf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fullamplitude", "=", 
   RowBox[{
    RowBox[{"amplitudesIBP", "//", 
     RowBox[{"Apply", "[", "Plus", "]"}]}], "//", 
    RowBox[{
     RowBox[{"Collect", "[", 
      RowBox[{"#", ",", "_B", ",", "Factor"}], "]"}], "&"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.826547152483131*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"9771a3d7-b7b6-449e-b98a-4313806b69be"],

Cell[BoxData["fullamplitude"], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.8265471515389214`*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"2f1f3815-1b59-4867-a0e4-c8fe18c3f739"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fullamplitude", "/.", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Nt", "|", "SumQt", "|", "SumQt2"}], ")"}], "\[RuleDelayed]", 
    "0"}]}], "/.", 
  RowBox[{"mt2", "\[Rule]", "0"}]}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.8265470730349207`*^9}, {3.826547129838648*^9, 3.826547150533278*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"e0777ef1-3d1c-4eec-99c2-327173a1a9a5"],

Cell["\<\
At NLOOPS=1 this would be the known leading order R ratio:
fullamplitude/(fullamplitude/.Nc\[Rule]1/.SumQf2\[Rule]1)/.mt2\[Rule]0/.\
SumQt2\[Rule]0\
\>", "Text",ExpressionUUID->"b09f88fd-35a3-432e-9067-1840cd488bba"],

Cell["\<\
Note these environment variables:
export SECDEC_CONTRIB=$PWD/pySecDec-1.4.5/
export PYTHONPATH=$PWD/pySecDec-1.4.5/pySecDec-1.4.5:$PYTHONPATH\
\>", "Text",
 CellChangeTimes->{{3.826547104379838*^9, 
  3.826547115756249*^9}},ExpressionUUID->"a2b4bcc9-3f88-491c-acb2-\
e33ba0504fc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "[", 
   RowBox[{
    RowBox[{"CreateDirectory", "[", "\"\<secdec-files\>\"", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"CreateDirectory", "::", "filex"}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.826545396011743*^9, 3.826545442686738*^9}, {
  3.8265454993227777`*^9, 3.826545602611815*^9}, {3.8265456381564817`*^9, 
  3.826545861632332*^9}, {3.826545971369873*^9, 3.826545992498425*^9}, {
  3.826546023865918*^9, 3.826546278241589*^9}, {3.826547038500744*^9, 
  3.826547067514822*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"ac117b98-e707-409f-8653-9b8d9ff93dc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegralName", "[", "integral_B", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"integral", "//", "ToString"}], "//", 
      RowBox[{"StringReplace", "[", 
       RowBox[{"\"\< \>\"", "\[Rule]", "\"\<\>\""}], "]"}]}], "//", 
     RowBox[{"StringReplace", "[", 
      RowBox[{"\"\<,\>\"", "\[Rule]", "\"\<_\>\""}], "]"}]}], "//", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<\>\""}], "]"}]}], "//", 
   RowBox[{"StringReplace", "[", 
    RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<\>\""}], "]"}]}]}]], "Input",
 CellLabel->
  "In[174]:=",ExpressionUUID->"a836f10b-03e1-49bf-b31d-e9f61f284c7c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"basedir", "=", "\"\<secdec-files\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"name", "=", 
      RowBox[{"IntegralName", "[", "integral", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<* Working on \>\"", ",", "basedir", ",", "\"\</\>\"", ",", "name", 
       ",", "\"\<.*\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"basisid", "=", 
      RowBox[{"integral", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"indices", "=", 
      RowBox[{
       RowBox[{"integral", "[", 
        RowBox[{"[", 
         RowBox[{"2", ";;"}], "]"}], "]"}], "//", 
       RowBox[{"Apply", "[", "List", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"basis", "=", 
      RowBox[{"bases", "[", 
       RowBox[{"[", "basisid", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"MkFile", "[", 
      RowBox[{
       RowBox[{
       "basedir", "<>", "\"\</\>\"", "<>", "name", "<>", 
        "\"\<.generate.py\>\""}], ",", "\[IndentingNewLine]", 
       "\"\<#!/usr/bin/env python3\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<import pySecDec as psd\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<loopint = psd.loop_integral.LoopIntegralFromPropagators(\\n\>\"", 
       ",", "\[IndentingNewLine]", "\"\<  loop_momenta = ['\>\"", ",", 
       RowBox[{"loopmomenta", "//", 
        RowBox[{
         RowBox[{"Riffle", "[", 
          RowBox[{"#", ",", "\"\<','\>\""}], "]"}], "&"}]}], ",", 
       "\"\<'],\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<  external_momenta = ['\>\"", ",", 
       RowBox[{"externalmomenta", "//", 
        RowBox[{
         RowBox[{"Riffle", "[", 
          RowBox[{"#", ",", "\"\<','\>\""}], "]"}], "&"}]}], ",", 
       "\"\<'],\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<  propagators = [\\n\>\"", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"basis", "[", "\"\<denominators\>\"", "]"}], "/.", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"den", "[", "p_", "]"}], "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{"\"\<    '(\>\"", ",", 
              RowBox[{"p", "//", "CForm"}], ",", "\"\<)^2'\>\""}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"den", "[", 
             RowBox[{"p_", ",", "m_", ",", "___"}], "]"}], "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{"\"\<    '(\>\"", ",", 
              RowBox[{"p", "//", "CForm"}], ",", "\"\<)^2-\>\"", ",", 
              RowBox[{"m", "//", "CForm"}], ",", "\"\<'\>\""}], "}"}]}]}], 
          "\[IndentingNewLine]", "}"}]}], "//", 
        RowBox[{
         RowBox[{"Riffle", "[", 
          RowBox[{"#", ",", "\"\<,\\n\>\""}], "]"}], "&"}]}], ",", 
       "\"\<\\n\>\"", ",", "\[IndentingNewLine]", "\"\<  ],\\n\>\"", ",", 
       "\[IndentingNewLine]", "\"\<  powerlist = [\>\"", ",", 
       RowBox[{"indices", "//", 
        RowBox[{
         RowBox[{"Riffle", "[", 
          RowBox[{"#", ",", "\"\<,\>\""}], "]"}], "&"}]}], ",", 
       "\"\<],\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<  replacement_rules = [('q*q', 'sqrq')]\\n\>\"", ",", 
       "\[IndentingNewLine]", "\"\<)\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<psd.loop_integral.loop_package(\\n\>\"", ",", 
       "\[IndentingNewLine]", "\"\<    name = '\>\"", ",", "name", ",", 
       "\"\<',\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<    loop_integral = loopint,\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<    real_parameters = ['sqrq', 'mt2'],\\n\>\"", ",", 
       "\[IndentingNewLine]", "\"\<    additional_prefactor = '1',\\n\>\"", 
       ",", "\[IndentingNewLine]", "\"\<    requested_order = 2,\\n\>\"", ",",
        "\[IndentingNewLine]", "\"\<    form_work_space = '50M',\\n\>\"", ",",
        "\[IndentingNewLine]", "\"\<    contour_deformation=True\\n\>\"", ",",
        "\[IndentingNewLine]", "\"\<)\\n\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MkFile", "[", 
      RowBox[{
       RowBox[{
       "basedir", "<>", "\"\</\>\"", "<>", "name", "<>", 
        "\"\<.integrate.py\>\""}], ",", "\[IndentingNewLine]", 
       "\"\<#!/usr/bin/env python3\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<import sys\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<import pySecDec as psd\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<parameters = [float(parameter) for parameter in \
sys.argv[1:]]\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<sys.stderr.write(f'Parameters: {parameters}\\\\n')\\n\>\"", ",", 
       "\[IndentingNewLine]", 
       "\"\<lib = psd.integral_interface.IntegralLibrary('\>\"", ",", "name", 
       ",", "\"\</\>\"", ",", "name", ",", "\"\<_pylink.so')\\n\>\"", ",", 
       "\[IndentingNewLine]", 
       "\"\<lib.use_Vegas(epsrel=1e-4, epsabs=1e-07, maxeval=1000000)\\n\>\"",
        ",", "\[IndentingNewLine]", 
       "\"\<int_wo_prefactor, prefactor, int_with_prefactor = \
lib(real_parameters=parameters)\\n\>\"", ",", "\[IndentingNewLine]", 
       "\"\<print('\\\"', int_wo_prefactor, '\\\"')\\n\>\""}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"integral", ",", "masters"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[175]:=",ExpressionUUID->"6af40c01-178c-445b-ae89-9d6ca99fb086"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"name", "=", 
      RowBox[{"IntegralName", "[", "integral", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Run", "[", 
      RowBox[{"MkString", "[", 
       RowBox[{
       "\"\<rm -rf secdec-files/\>\"", ",", "name", ",", "\"\</\>\""}], "]"}],
       "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Run", "[", 
      RowBox[{"MkString", "[", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<cd secdec-files && env \
SECDEC_CONTRIB=$PWD/../pySecDec-1.4.5/\>\"", ",", "\[IndentingNewLine]", 
        "\"\< PYTHONPATH=$PWD/../pySecDec-1.4.5/pySecDec-1.4.5:$PYTHONPATH\>\"\
", ",", "\[IndentingNewLine]", "\"\< python3 ./\>\"", ",", "name", ",", 
        "\"\<.generate.py\>\""}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Run", "[", 
      RowBox[{"MkString", "[", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<env SECDEC_CONTRIB=$PWD/pySecDec-1.4.5/\>\"", ",", 
        "\[IndentingNewLine]", " ", "\"\< make -j3 -C secdec-files/\>\"", ",",
         "name", ",", "\"\</\>\""}], "\[IndentingNewLine]", "]"}], "]"}], 
     ";"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"integral", ",", "masters"}], "}"}]}], "]"}], ";"}]], "Input",Exp\
ressionUUID->"6e684388-77d5-4e18-aa21-5889cd99c194"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FromPySecDec", "[", "stringresult_String", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"stringresult", "//", "\[IndentingNewLine]", 
               RowBox[{"StringReplace", "[", 
                RowBox[{
                 RowBox[{"\"\<+ O(eps^\>\"", "~~", 
                  RowBox[{"n", ":", 
                   RowBox[{"(", 
                    RowBox[{"_", "..."}], ")"}]}], "~~", "\"\<)\>\"", "~~", 
                  RowBox[{"_", "..."}], "~~", "EndOfString"}], 
                 "\[RuleDelayed]", 
                 RowBox[{"\"\<+ {{1,0},{1,0}}*O[xxx]^\>\"", "<>", "n"}]}], 
                "]"}]}], "//", "\[IndentingNewLine]", 
              RowBox[{"StringReplace", "[", 
               RowBox[{
                RowBox[{"\"\<+ O(eps^\>\"", "~~", 
                 RowBox[{"n", ":", 
                  RowBox[{"(", 
                   RowBox[{"_", "..."}], ")"}]}], "~~", "\"\<)\>\"", "~~", 
                 RowBox[{"_", "..."}], "~~", "EndOfString"}], "\[Rule]", 
                "\"\<O[ep]^\\n\>\""}], "]"}]}], "//", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"StringTrim", "[", 
               RowBox[{"#", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"\"\< \>\"", "|", "\"\<+\>\""}], ")"}], "..."}]}], 
               "]"}], "&"}]}], "//", "\[IndentingNewLine]", 
            RowBox[{"StringReplace", "[", 
             RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}], "]"}]}], "//", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}], "]"}]}], "//", 
          "\[IndentingNewLine]", 
          RowBox[{"StringReplace", "[", 
           RowBox[{"\"\< +/- \>\"", "\[Rule]", "\"\<, \>\""}], "]"}]}], "//", 
         "\[IndentingNewLine]", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"\"\< + \>\"", "\[Rule]", "\"\<, \>\""}], "]"}]}], "//", 
        RowBox[{"StringReplace", "[", 
         RowBox[{"\"\<eps\>\"", "\[Rule]", "\"\<xxx\>\""}], "]"}]}], "//", 
       "\[IndentingNewLine]", 
       RowBox[{"StringReplace", "[", 
        RowBox[{"\"\<e\>\"", "\[Rule]", "\"\<*10^\>\""}], "]"}]}], "//", 
      "\[IndentingNewLine]", 
      RowBox[{"StringReplace", "[", 
       RowBox[{"\"\<xxx\>\"", "\[Rule]", "\"\<ep\>\""}], "]"}]}], "//", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<X[\>\"", "<>", "#", "<>", "\"\<]\>\""}], "&"}]}], "//", 
    "\[IndentingNewLine]", "ToExpression"}], "//", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}], "//", 
        RowBox[{"Map", "[", 
         RowBox[{"Apply", "[", 
          RowBox[{
           RowBox[{"#1", "+", 
            RowBox[{"I", "*", "#2"}]}], "&"}], "]"}], "]"}]}], "//", 
       RowBox[{"Apply", "[", "Plus", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}], "//", 
        RowBox[{"Map", "[", 
         RowBox[{"Apply", "[", 
          RowBox[{
           RowBox[{"#1", "+", 
            RowBox[{"I", "*", "#2"}]}], "&"}], "]"}], "]"}]}], "//", 
       RowBox[{"Apply", "[", "Plus", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
    "&"}]}]}]], "Input",ExpressionUUID->"6fae33be-59a8-4632-92a8-\
82fa72342acb"],

Cell[BoxData[
 RowBox[{"fullamplitudefmt", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"fullamplitude", "/.", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"4", "-", 
       RowBox[{"2", "ep"}]}]}]}], "//", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Collect", "[", 
      RowBox[{"#", ",", 
       RowBox[{
       "gs", "|", "Nf", "|", "Nt", "|", "SumQf", "|", "SumQt", "|", "SumQf2", 
        "|", "SumQt2", "|", "Tf", "|", "Nc", "|", "Na", "|", "Cf", "|", "Ca", 
        "|", "d33", "|", "d44", "|", "Xi"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Collect", "[", 
          RowBox[{"#", ",", "_B", ",", "Factor"}], "]"}], "&"}], "/*", 
        "Coef"}]}], "]"}], "&"}]}], "//", "\[IndentingNewLine]", 
   "Expand"}]}]], "Input",ExpressionUUID->"de110368-6462-4979-9aae-\
89c6122a28b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Put", "[", 
     RowBox[{"fullamplitudefmt", ",", "\"\<fullamplitude.m\>\""}], "]"}], 
    ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fullamplitudefmt", "//", 
    RowBox[{"CaseUnion", "[", 
     RowBox[{
      RowBox[{"c_", "*", 
       RowBox[{"Coef", "[", "a_", "]"}]}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"c", ",", "a"}], "}"}]}], "]"}]}], "//", 
   "TableForm"}]}]], "Input",ExpressionUUID->"0c34230c-069b-45e9-b104-\
c13d25858462"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanParameterizationPrefactor", "[", 
   RowBox[{"B", "[", 
    RowBox[{"basisid_", ",", "idx__"}], "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", "nu"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"{", "idx", "}"}], "//", 
       RowBox[{"Apply", "[", "Plus", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "n"}], " ", "\[IndentingNewLine]", 
       RowBox[{"Gamma", "[", 
        RowBox[{"n", "-", 
         RowBox[{"NLOOPS", "*", 
          RowBox[{"d", "/", "2"}]}]}], "]"}], " ", "\[IndentingNewLine]", 
       RowBox[{"1", "/", 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"Gamma", "[", "nu", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"nu", ",", 
            RowBox[{
             RowBox[{"{", "idx", "}"}], "//", 
             RowBox[{"DeleteCases", "[", "0", "]"}]}]}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"I", " ", 
           RowBox[{
            RowBox[{"Pi", "^", 
             RowBox[{"(", 
              RowBox[{"d", "/", "2"}], ")"}]}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", " ", "Pi"}], ")"}], "^", "d"}]}]}], ")"}], "^", 
         "NLOOPS"}], "*)"}], "\[IndentingNewLine]", " ", 
       RowBox[{
        RowBox[{"(", "I", ")"}], "^", "NLOOPS"}]}], "\[IndentingNewLine]", 
      ")"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",ExpressionUUID->\
"5433bd27-1f29-4023-99d8-ffe922c6bda0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"parameters", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"sqrq", "\[Rule]", "1"}], ",", 
     RowBox[{"mt2", "\[Rule]", 
      RowBox[{"1", "/", "5"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"valuemap", "=", 
   RowBox[{"<|", "|>"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"errormap", "=", 
   RowBox[{"<|", "|>"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"name", "=", 
      RowBox[{"IntegralName", "[", "integral", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<* Integrating \>\"", ",", "name"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"stringresult", "=", 
      RowBox[{"RunThrough", "[", 
       RowBox[{
        RowBox[{"MkString", "[", "\[IndentingNewLine]", 
         RowBox[{
         "\"\<cd secdec-files && env \
PYTHONPATH=$PWD/../pySecDec-1.4.5/pySecDec-1.4.5:$PYTHONPATH\>\"", ",", 
          "\[IndentingNewLine]", "\"\< python3 ./\>\"", ",", "name", ",", 
          "\"\<.integrate.py \>\"", ",", 
          RowBox[{
           RowBox[{"N", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"sqrq", ",", "mt2"}], "}"}], "/.", "parameters"}], 
            "]"}], "//", 
           RowBox[{
            RowBox[{"Riffle", "[", 
             RowBox[{"#", ",", "\"\< \>\""}], "]"}], "&"}]}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"value", ",", "error"}], "}"}], "=", 
      RowBox[{"stringresult", "//", "FromPySecDec"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"prefactor", "=", 
      RowBox[{
       RowBox[{"FeynmanParameterizationPrefactor", "[", 
        RowBox[{"masters", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "/.", 
       RowBox[{"d", "\[Rule]", 
        RowBox[{"4", "-", 
         RowBox[{"2", "ep"}]}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"valuemap", "[", "integral", "]"}], "=", 
      RowBox[{"value", "*", "prefactor"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"errormap", "[", "integral", "]"}], "=", 
      RowBox[{"error", "*", "prefactor"}]}], ";"}], ",", 
    RowBox[{"{", 
     RowBox[{"integral", ",", "masters"}], "}"}]}], "]"}], ";"}]}], "Input",Ex\
pressionUUID->"53af277b-24bd-4af9-8456-f922636eb98c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Put", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"i", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"valuemap", "[", "i", "]"}], ",", 
           RowBox[{"errormap", "[", "i", "]"}]}], "}"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"valuemap", "//", "Keys"}]}], "}"}]}], "]"}], ",", 
      "\"\<valuemap.m\>\""}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"TableForm", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"valuemap", "[", "i", "]"}], ",", 
         RowBox[{"errormap", "[", "i", "]"}]}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"valuemap", "//", "Keys"}]}], "}"}]}], "\[IndentingNewLine]", 
    "]"}], "//", "TableForm"}]}]], "Input",ExpressionUUID->"5872022d-8ead-\
4dbc-bfd5-5f4a7d331182"],

Cell[BoxData[
 RowBox[{"fullvalue", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fullamplitude", "/.", 
        RowBox[{"integral_B", "\[RuleDelayed]", 
         RowBox[{"integral", "*", 
          RowBox[{"Prefactor", "[", "integral", "]"}]}]}]}], "/.", 
       RowBox[{"d", "\[Rule]", 
        RowBox[{"4", "-", 
         RowBox[{"2", "ep"}]}]}]}], "/.", "parameters"}], "//", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Collect", "[", 
       RowBox[{"#", ",", 
        RowBox[{
        "gs", "|", "Nf", "|", "Nt", "|", "SumQf", "|", "SumQt", "|", "SumQf2",
          "|", "SumQt2", "|", "Tf", "|", "Nc", "|", "Na", "|", "Cf", "|", 
         "Ca", "|", "d33", "|", "d44", "|", "Xi"}], ",", "Coef"}], "]"}], 
      "&"}]}], "//", "\[IndentingNewLine]", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{"Coef", "[", "x_", "]"}], "\[RuleDelayed]", 
      RowBox[{"Coef", "[", 
       RowBox[{
        RowBox[{"x", "/.", "valuemap"}], ",", 
        RowBox[{"x", "/.", "errormap"}]}], "]"}]}], "]"}]}], "//", 
   "\[IndentingNewLine]", "Expand"}]}]], "Input",ExpressionUUID->"548ef4a6-\
74c2-41cd-a457-ad1112afa23a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Put", "[", 
     RowBox[{"fullvalue", ",", "\"\<fullvalue.m\>\""}], "]"}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fullvalue", "//", 
    RowBox[{"CaseUnion", "[", 
     RowBox[{
      RowBox[{"c_", "*", 
       RowBox[{"Coef", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}]}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"c", ",", 
        RowBox[{"TableForm", "[", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "}"}]}], "]"}]}], "//", 
   "TableForm"}]}]], "Input",ExpressionUUID->"e09225e0-e726-4d2f-aa1d-\
c858bd5c15d2"]
}, Open  ]]
},
WindowSize->{1920, 1129},
WindowMargins->{{0, Automatic}, {0, Automatic}},
FrontEndVersion->"11.3 for Linux x86 (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 267, 5, 33, "Input",ExpressionUUID->"54174ed4-f1de-4b4e-a331-cc1144982f82"],
Cell[CellGroupData[{
Cell[850, 29, 185, 3, 56, "Subsection",ExpressionUUID->"009f4cd3-e083-405f-bd88-1478667f836a"],
Cell[1038, 34, 267, 5, 33, "Input",ExpressionUUID->"95cb26d1-c426-4396-a78f-df1eb164dd30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1342, 44, 161, 3, 56, "Subsection",ExpressionUUID->"0d1a1bb6-89bd-42fa-90e6-7277b430c476"],
Cell[1506, 49, 383, 8, 33, "Input",ExpressionUUID->"3ad51630-27a0-445d-b8f0-d13fb57956ad"],
Cell[1892, 59, 523, 13, 59, "Input",ExpressionUUID->"2f99be14-130f-4e33-a0fd-4dae74609a6c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2452, 77, 168, 3, 56, "Subsection",ExpressionUUID->"c77bcd28-d250-4925-946d-97bf66b9e05b"],
Cell[2623, 82, 1499, 43, 159, "Input",ExpressionUUID->"1abc6e4b-770c-4101-9ea8-eeb5ab0afb5e"],
Cell[4125, 127, 13491, 377, 884, "Input",ExpressionUUID->"f4e2bb20-d365-49ec-b9f8-71542fc3980d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17653, 509, 132, 0, 56, "Subsection",ExpressionUUID->"44b089ba-2ffc-46e4-9455-19c3f898ce0e"],
Cell[17788, 511, 311, 9, 33, "Input",ExpressionUUID->"a1675b5b-94b6-4894-8509-6faac39a7694"],
Cell[18102, 522, 322, 9, 33, "Input",ExpressionUUID->"0994fa37-fb59-4576-97ba-0341092557f9"],
Cell[18427, 533, 707, 18, 84, "Input",ExpressionUUID->"7808f610-2ea5-418e-9bbf-e4c47d71fd5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19171, 556, 153, 3, 56, "Subsection",ExpressionUUID->"b6555248-188b-454d-a8f1-3593bb2510bb"],
Cell[19327, 561, 786, 19, 59, "Input",ExpressionUUID->"dd37ce3b-d135-48eb-ae60-900cdd463aa4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20150, 585, 155, 3, 56, "Subsection",ExpressionUUID->"9aaa2912-2f03-4426-ba09-3f00719a4182"],
Cell[20308, 590, 582, 16, 59, "Input",ExpressionUUID->"cb1b7a35-36c3-4a0a-97ed-b6957a073520"],
Cell[20893, 608, 1695, 43, 134, "Input",ExpressionUUID->"e1fae73e-658e-44c2-8938-197cb2ec8592"],
Cell[22591, 653, 1307, 34, 184, "Input",ExpressionUUID->"70e53632-8282-409f-b376-709c3c7bc8ca"],
Cell[23901, 689, 764, 22, 84, "Input",ExpressionUUID->"54bd17a1-cc6b-42ab-a16b-6e6ef1bfb3d4"],
Cell[24668, 713, 2661, 67, 259, "Input",ExpressionUUID->"a42c984a-0d28-45d4-b6e5-0e860d674abf"],
Cell[27332, 782, 915, 22, 84, "Input",ExpressionUUID->"e7f9a1e1-3c46-47b2-b448-06b8d051d177"],
Cell[28250, 806, 4954, 118, 834, "Input",ExpressionUUID->"febe90d3-a61b-4bff-901f-8683e0196570"],
Cell[33207, 926, 673, 18, 59, "Input",ExpressionUUID->"f23f4ff5-22ae-4d59-a70e-0dd55ec7e1c2"],
Cell[33883, 946, 974, 19, 209, "Input",ExpressionUUID->"e94f80cc-b1b6-41de-bb58-6f7c304b35ec"],
Cell[34860, 967, 657, 14, 59, "Input",ExpressionUUID->"4826518f-b340-42f2-97c8-935b3a850681"],
Cell[35520, 983, 450, 10, 33, "Input",ExpressionUUID->"fe7b1213-b0d7-4c07-b22b-4ff30eeb7807"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36007, 998, 167, 3, 56, "Subsection",ExpressionUUID->"46e54469-79f6-4ef5-9730-2d257b2a2cde"],
Cell[36177, 1003, 333, 6, 33, "Input",ExpressionUUID->"815b95d3-b2ec-45d6-8d19-c5860982552f"],
Cell[36513, 1011, 334, 6, 33, "Input",ExpressionUUID->"674a3494-7cb8-431b-948d-b4a99d606235"],
Cell[36850, 1019, 487, 14, 59, "Input",ExpressionUUID->"78ac0065-e5d6-45c7-80fe-f55f92cbc473"],
Cell[37340, 1035, 504, 11, 59, "Input",ExpressionUUID->"3a53bef5-e8df-493c-b655-97e40a659f2e"],
Cell[37847, 1048, 769, 19, 134, "Input",ExpressionUUID->"b46866fd-d807-4e7d-93e4-8762b1afdb74"],
Cell[38619, 1069, 341, 7, 109, "Input",ExpressionUUID->"ae98597e-d633-483d-a3a2-47ad1159d79f"],
Cell[38963, 1078, 758, 18, 159, "Input",ExpressionUUID->"076b37e1-7717-473b-ad5d-75cb59f869bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39758, 1101, 158, 3, 56, "Subsection",ExpressionUUID->"afe10d7b-b51a-4100-b7fe-79bc29199776"],
Cell[39919, 1106, 444, 12, 59, "Input",ExpressionUUID->"4a1b8be3-5b8d-4aa6-b2d4-fe409418371d"],
Cell[40366, 1120, 405, 11, 33, "Input",ExpressionUUID->"56f55b48-8595-4ab8-8aff-d19798455ccb"],
Cell[40774, 1133, 1046, 26, 109, "Input",ExpressionUUID->"9190a7e8-e490-4a96-9bcc-c9b803c15bb7"],
Cell[41823, 1161, 1031, 27, 59, "Input",ExpressionUUID->"abbdc676-d25b-4a9c-94d3-d0eb478c8546"],
Cell[42857, 1190, 364, 7, 33, "Input",ExpressionUUID->"d64966a1-34ff-41ec-9dfe-d1e7e3fa5a6b"],
Cell[43224, 1199, 4036, 92, 609, "Input",ExpressionUUID->"19ae1b1d-6e84-4dbf-9159-de7816bbe8a5"],
Cell[47263, 1293, 713, 17, 59, "Input",ExpressionUUID->"3bd865dd-cc2f-4006-a1c7-b01069b67f9f"],
Cell[47979, 1312, 360, 7, 33, "Input",ExpressionUUID->"f82ce56b-6454-43d9-8101-cbe784ac03dd"],
Cell[48342, 1321, 533, 12, 33, "Input",ExpressionUUID->"92ae3ebe-ad47-4b91-b923-2ab34600dfe6"],
Cell[48878, 1335, 781, 19, 59, "Input",ExpressionUUID->"aeea39db-1038-477c-ad86-d88d8a8f3c06"],
Cell[49662, 1356, 3630, 87, 484, "Input",ExpressionUUID->"e48ab21a-d456-4bd1-9c35-bc007e942be3"],
Cell[53295, 1445, 825, 19, 84, "Input",ExpressionUUID->"01e1f07d-124f-477a-8657-54cede4f8e5b"],
Cell[54123, 1466, 15011, 362, 1559, "Input",ExpressionUUID->"85bc21d7-dba9-461d-9695-d3cbcc2cabe3"],
Cell[69137, 1830, 873, 22, 59, "Input",ExpressionUUID->"bb731f43-3094-4818-88b1-27dcef902946"],
Cell[70013, 1854, 840, 19, 33, "Input",ExpressionUUID->"e1f74c98-c949-44b1-a32d-62b21644b8f0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70890, 1878, 158, 3, 56, "Subsection",ExpressionUUID->"16760009-857e-4523-8820-65335731d8e0"],
Cell[71051, 1883, 131, 0, 37, "Text",ExpressionUUID->"36f49ab2-8026-416f-8504-d7485a3a62ff"],
Cell[71185, 1885, 5135, 117, 534, "Input",ExpressionUUID->"2fb4c365-46e3-441a-8cac-d9e90644c0fd"],
Cell[76323, 2004, 653, 20, 84, "Input",ExpressionUUID->"f4e9249e-49f9-493c-a85c-4b59858fbb10"],
Cell[76979, 2026, 185, 4, 33, "Input",ExpressionUUID->"e525f6de-fd95-4c0b-8a42-23c53dec821a"],
Cell[77167, 2032, 286, 8, 33, "Input",ExpressionUUID->"fecdc0b5-68e1-4359-8f53-c40ca674f0a2"],
Cell[77456, 2042, 425, 11, 59, "Input",ExpressionUUID->"c820025f-9dc4-4768-bf00-74f4aac6c7c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77918, 2058, 157, 3, 56, "Subsection",ExpressionUUID->"e6b14a44-2262-4781-8dd6-34c323762c8c"],
Cell[78078, 2063, 350, 8, 112, "Text",ExpressionUUID->"a64f3464-6b0f-44fe-8eae-6ea384ae41cc"],
Cell[78431, 2073, 869, 25, 59, "Input",ExpressionUUID->"6d895611-b0fa-4b51-a024-496e2e09e7d8"],
Cell[79303, 2100, 1202, 36, 109, "Input",ExpressionUUID->"b1eef72e-6f7e-434e-ab67-136de3ad49c2"],
Cell[80508, 2138, 2483, 63, 159, "Input",ExpressionUUID->"95eb2221-79be-49de-9a4c-79282a2ae3a8"],
Cell[82994, 2203, 184, 4, 33, "Input",ExpressionUUID->"88997b88-b765-4968-ab52-206ea81d0b6f"],
Cell[83181, 2209, 865, 24, 33, "Input",ExpressionUUID->"3828a45e-4d09-401b-97ad-2e6a66495bcd"],
Cell[84049, 2235, 196, 4, 33, "Input",ExpressionUUID->"75d0b63b-b9f0-4390-880d-063d7dc077d8"],
Cell[84248, 2241, 527, 13, 59, "Input",ExpressionUUID->"e9988e07-74ab-47d6-96d1-a5b51bc231c4"],
Cell[84778, 2256, 1134, 29, 33, "Input",ExpressionUUID->"d514fa35-89d0-4468-b5ac-495845365757"],
Cell[85915, 2287, 250, 7, 33, "Input",ExpressionUUID->"7ba48378-9091-4c89-aa54-971aa41b2a24"],
Cell[86168, 2296, 985, 27, 59, "Input",ExpressionUUID->"e06cf953-53d9-4f79-99c7-d32f1aec05b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87190, 2328, 108, 0, 56, "Subsection",ExpressionUUID->"2b5fab19-f168-478e-b729-9dfcb3e3dc05"],
Cell[87301, 2330, 691, 15, 287, "Text",ExpressionUUID->"d56ce805-fbb8-43e2-829b-38094ad12a5a"],
Cell[87995, 2347, 684, 14, 33, "Input",ExpressionUUID->"d1245666-ff80-48b3-9749-c49382a5d7e5"],
Cell[88682, 2363, 1054, 23, 134, "Input",ExpressionUUID->"7c4a3edd-0fdc-4077-b4c1-877cd551c2f4"],
Cell[89739, 2388, 149, 3, 33, "Input",ExpressionUUID->"2f1d7d6f-767d-40e2-8d92-63a7d32c9791"],
Cell[89891, 2393, 2647, 63, 384, "Input",ExpressionUUID->"e27ce882-abc6-4de4-9ed0-343cbc4d4dd7"],
Cell[92541, 2458, 229, 6, 33, "Input",ExpressionUUID->"82078444-148c-4402-a12e-08f3c9cccc5e"],
Cell[92773, 2466, 3309, 80, 409, "Input",ExpressionUUID->"61eb1d8c-84c7-47d2-a8e7-6cef437af554"],
Cell[96085, 2548, 457, 12, 33, "Input",ExpressionUUID->"bb8b876b-42bc-4bc0-bdc2-12c5cbbb1be9"],
Cell[96545, 2562, 5887, 134, 684, "Input",ExpressionUUID->"80a85719-d59e-4873-90f6-ad79ec960a2c"],
Cell[102435, 2698, 5307, 113, 984, "Input",ExpressionUUID->"58d1a8dc-1c00-4f91-b90a-0f96b7669e54"],
Cell[107745, 2813, 12430, 296, 1234, "Input",ExpressionUUID->"e0cd9b0e-4b02-4628-a505-9c0d340127e7"],
Cell[120178, 3111, 3086, 76, 384, "Input",ExpressionUUID->"ab546653-256d-4528-824b-c68fd4b4d165"],
Cell[123267, 3189, 661, 12, 59, "Input",ExpressionUUID->"9214ad4e-83a5-4b4e-8bb6-4de90ff082c7"],
Cell[123931, 3203, 623, 10, 33, "Input",ExpressionUUID->"24f61866-73ef-485c-b9ca-e678ddf6183a"],
Cell[124557, 3215, 410, 11, 59, "Input",ExpressionUUID->"048fa36a-4982-41b6-bb4b-389582a4bc32"],
Cell[124970, 3228, 2251, 55, 284, "Input",ExpressionUUID->"6e5734c8-cfa9-4c18-8b7c-69b127fbbe4a"],
Cell[127224, 3285, 617, 11, 33, "Input",ExpressionUUID->"607eced4-5879-418e-adfc-67d9db79135d"],
Cell[127844, 3298, 1017, 23, 84, "Input",ExpressionUUID->"23635db6-cd66-496a-844e-5d63040f8caf"],
Cell[128864, 3323, 726, 16, 33, "Input",ExpressionUUID->"9771a3d7-b7b6-449e-b98a-4313806b69be"],
Cell[129593, 3341, 484, 7, 33, "Input",ExpressionUUID->"2f1f3815-1b59-4867-a0e4-c8fe18c3f739"],
Cell[130080, 3350, 673, 14, 33, "Input",ExpressionUUID->"e0777ef1-3d1c-4eec-99c2-327173a1a9a5"],
Cell[130756, 3366, 226, 4, 62, "Text",ExpressionUUID->"b09f88fd-35a3-432e-9067-1840cd488bba"],
Cell[130985, 3372, 291, 7, 87, "Text",ExpressionUUID->"a2b4bcc9-3f88-491c-acb2-e33ba0504fc6"],
Cell[131279, 3381, 631, 14, 33, "Input",ExpressionUUID->"ac117b98-e707-409f-8653-9b8d9ff93dc3"],
Cell[131913, 3397, 686, 17, 33, "Input",ExpressionUUID->"a836f10b-03e1-49bf-b31d-e9f61f284c7c"],
Cell[132602, 3416, 5489, 113, 1059, "Input",ExpressionUUID->"6af40c01-178c-445b-ae89-9d6ca99fb086"],
Cell[138094, 3531, 1375, 30, 334, "Input",ExpressionUUID->"6e684388-77d5-4e18-aa21-5889cd99c194"],
Cell[139472, 3563, 3665, 90, 409, "Input",ExpressionUUID->"6fae33be-59a8-4632-92a8-82fa72342acb"],
Cell[143140, 3655, 808, 21, 84, "Input",ExpressionUUID->"de110368-6462-4979-9aae-89c6122a28b6"],
Cell[143951, 3678, 541, 16, 59, "Input",ExpressionUUID->"0c34230c-069b-45e9-b104-c13d25858462"],
Cell[144495, 3696, 1760, 48, 259, "Input",ExpressionUUID->"5433bd27-1f29-4023-99d8-ffe922c6bda0"],
Cell[146258, 3746, 2432, 65, 359, "Input",ExpressionUUID->"53af277b-24bd-4af9-8456-f922636eb98c"],
Cell[148693, 3813, 1074, 31, 134, "Input",ExpressionUUID->"5872022d-8ead-4dbc-bfd5-5f4a7d331182"],
Cell[149770, 3846, 1183, 31, 109, "Input",ExpressionUUID->"548ef4a6-74c2-41cd-a457-ad1112afa23a"],
Cell[150956, 3879, 654, 20, 59, "Input",ExpressionUUID->"e09225e0-e726-4d2f-aa1d-c858bd5c15d2"]
}, Open  ]]
}
]
*)

