* This example is the same as example.dirac-trace.frm, but with
* transformation from Mathematica notation into native FORM.

symbol d, FAIL;

auto index lor = d;
auto index spn = FAIL;
auto vector p, q, tmpvec;

cFunction delta, momentum, sp, gammachain, gamma, slash, gammatrace;

* Normally just 4, but can be changed.
symbol gamma1Trace;
unitTrace gamma1Trace;

* Tr(gamma(mu) gamma(nu)) = 4 g(mu,nu)
    local [Tr(gamma_mu*gamma_nu)] = gammachain(gamma(lormu), gamma(lornu), spn1, spn1);
    local [Tr(gamma_mu*gamma_nu),again] = gammachain(gamma(lormu), spn1, spn2) * gammachain(gamma(lornu), spn2, spn1);

* Tr(gamma(mu) slash(p)) = 4 p(mu)
    local [Tr(gamma_mu*slash(p))] = gammachain(gamma(lormu), slash(p), spn1, spn1);

* Complicated...
    local [Tr(gamma_mu*gamma_nu*slash(p)*slash(q))] = gammachain(gamma(lormu),gamma(lornu),slash(p),slash(q), spn1, spn1);
    print;

.sort:after-initial-definitions;

* Chain related gammachains together, identify traces.

    repeat id gammachain(?x1, spn1?, spn?)*gammachain(?x2, spn?, spn2?) = gammachain(?x1, ?x2, spn1, spn2);
    id gammachain(?x, spn?, spn?) = gammatrace(?x);

* Rename slash(p1+p2) into slash(123), remembering that extrasymbols[123]=p1+p2.

    argument gammatrace;
        argToExtraSymbol tonumber slash,1;
    endargument;
    print;

.sort:after-extrasymbols;

    #write "*** unique slashed momenta combinations: `EXTRASYMBOLS_'"
    #write "%X"

* Rename slash(123)=vec123, gamma(lorxx)=lorxx.

    argument gammatrace;
        #do i=1,`EXTRASYMBOLS_'
            id slash(`i') = tmpvec`i';
        #enddo
        id gamma(lor?) = lor;
    endargument;
    print;

.sort:after-gammatrace-argument-simplification;

* Transform into g_(); five spin lines per diagram should be enough
* for everyone?

    #do i = 1, 5
        id once gammatrace(?x) = g_(`i', ?x);
    #enddo
    print;

.sort:after-gammatrace-substitution;

* Expand g_() traces.

    #do i = 1, 5
        traceN `i';
    #enddo

* Double-check.

    if (match(gammatrace(?x)));
      exit "ERROR: diractrace: leftover gammatrace() at the end; is MaxGammaTracesPerTerm too small?";
    endif;
    print;

.sort:after-traceN;

* Rename tmpvec123=extrasymbols[123] back to p1+p2, etc.

    id p1?.p2? = sp(p1, p2);
    id p1?(lor1?) = momentum(p1, lor1);
    id momentum(p1?, p2?) = sp(p1, p2);
    argument momentum, sp;
        #do i=1,`EXTRASYMBOLS_'
            id tmpvec`i' = extrasymbol_(`i');
        #enddo
    endargument;
    print;

.sort:after-extrasymbols;

    delete extrasymbols;

* Convert to Mathematica format.

    format Mathematica;
    print;

.end
