(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    125818,       3665]
NotebookOptionsPosition[    119818,       3453]
NotebookOutlinePosition[    120340,       3475]
CellTagsIndexPosition[    120253,       3470]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 ExpressionUUID -> "a17de269-edd4-4aef-a84b-7f2e18c05c83"],

Cell[CellGroupData[{

Cell["IBP and the masters", "Subsection",
 ExpressionUUID -> "91bb6df5-bfac-426c-8886-46aed2f9b13b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "LiteRed`"}]], "Input",
 ExpressionUUID -> "4d5d57ae-ff93-4e0c-9268-426152050b7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"**************** \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"LiteRed v1.83\"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 
      Rational[1, 3], 
      Rational[1, 3]],
    FrontFaceColor->RGBColor[1, 
      Rational[1, 3], 
      Rational[1, 3]],
    BackFaceColor->RGBColor[1, 
      Rational[1, 3], 
      Rational[1, 3]],
    GraphicsColor->RGBColor[1, 
      Rational[1, 3], 
      Rational[1, 3]],
    FontWeight->Bold,
    FontColor->RGBColor[1, 
      Rational[1, 3], 
      Rational[1, 3]]], 
   "\[InvisibleSpace]", "\<\" ********************\\nAuthor: Roman N. Lee, \
Budker Institute of Nuclear Physics, Novosibirsk.\\nRelease Date: \
11.01.2020\\nLiteRed stands for Loop InTEgrals REDuction.\\nThe package is \
designed for the search and application of the Integration-By-Part reduction \
rules. It also contains some other useful tools.\\nInput file timestamp: Mon \
11 Jan 2021 11:19:15\\nSee ?LiteRed`* for a list of functions. \"\>"}],
  SequenceForm["**************** ", 
   Style["LiteRed v1.83", {Bold, 
     RGBColor[1, 
      Rational[1, 3], 
      Rational[1, 3]]}], 
   " ********************\nAuthor: Roman N. Lee, Budker Institute of Nuclear \
Physics, Novosibirsk.\nRelease Date: 11.01.2020\nLiteRed stands for Loop \
InTEgrals REDuction.\nThe package is designed for the search and application \
of the Integration-By-Part reduction rules. It also contains some other \
useful tools.\nInput file timestamp: Mon 11 Jan 2021 11:19:15\nSee ?LiteRed`* \
for a list of functions. "],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDim", "[", "d", "]"}], ";"}]], "Input",
 ExpressionUUID -> "625d1db4-39cb-44e1-9caf-19fedb82ef52"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Declare", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"q", ",", "l"}], "}"}], ",", "Vector", ",", 
    RowBox[{"{", 
     RowBox[{"m2", ",", "q2"}], "}"}], ",", "Number"}], "]"}], ";"}]], "Input",\

 ExpressionUUID -> "3e477495-fa96-4352-80bb-72ca35413e21"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"q", ",", "q"}], "]"}], "=", "q2"}], ";"}]], "Input",
 ExpressionUUID -> "f71bedcf-cbef-4df1-ba0f-0e7a893fd453"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewBasis", "[", 
  RowBox[{"b1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"sp", "[", 
      RowBox[{"q", "-", "l"}], "]"}], ",", 
     RowBox[{
      RowBox[{"sp", "[", "l", "]"}], "-", "m2"}]}], "}"}], ",", 
   RowBox[{"{", "l", "}"}]}], "]"}]], "Input",
 ExpressionUUID -> "1940efc1-5f91-4076-aeac-f65b18ebd5aa"],

Cell[BoxData["\<\"Valid basis.\\n    Ds[b1] \[LongDash] denominators,\\n    \
SPs[b1] \[LongDash] scalar products involving loop momenta,\\n    LMs[b1] \
\[LongDash] loop momenta,\\n    EMs[b1] \[LongDash] external momenta,\\n    \
Toj[b1] \[LongDash] rules to transform scalar products to \
denominators.\"\>"], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GenerateIBP", "[", "b1", "]"}], ";"}]], "Input",
 ExpressionUUID -> "d206ec29-47bc-402e-a0e8-5af4d2462f6d"],

Cell[BoxData["\<\"Integration-By-Part&Lorentz-Invariance identities are \
generated.\\n    IBP[b1] \[LongDash] integration-by-part identities,\\n    \
LI[b1] \[LongDash] Lorentz invariance identities.\"\>"], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AnalyzeSectors", "[", "b1", "]"}], ";"}]], "Input",
 ExpressionUUID -> "2d43956e-26d6-4eea-86d2-3845e27d81cf"],

Cell[BoxData["\<\"Found 2 zero sectors out of 4.\\n    ZeroSectors[b1] \
\[LongDash] zero sectors,\\n    NonZeroSectors[b1] \[LongDash] nonzero \
sectors,\\n    SimpleSectors[b1] \[LongDash] simple sectors (no nonzero \
subsectors),\\n    BasisSectors[b1] \[LongDash] basis sectors (at least one \
immediate subsector is zero),\\n    ZerojRule[b1] \[LongDash] a rule to \
nullify all zero j[b1\[Ellipsis]],\\n    CutDs[b1] \[LongDash] a flag list of \
cut denominatorsj (1=cut).\"\>"], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindSymmetries", "[", "b1", "]"}], ";"}]], "Input",
 ExpressionUUID -> "32df6618-e398-453c-b20d-7c449f603173"],

Cell[BoxData["\<\"Found 0 mapped sectors and 2 unique sectors.\\n    \
UniqueSectors[b1] \[LongDash] unique sectors.\\n    MappedSectors[b1] \
\[LongDash] mapped sectors.\\n    SR[b1][\[Ellipsis]] \[LongDash] symmetry \
relations for j[b1,\[Ellipsis]] from UniqueSectors[b1].\\n    jSymmetries[b1,\
\[Ellipsis]] \[LongDash] symmetry rules for the sector js[b1,\[Ellipsis]] in \
UniqueSectors[b1].\\n    jRules[b1,\[Ellipsis]] \[LongDash] reduction rules \
for j[b1,\[Ellipsis]] from MappedSectors[b1].\"\>"], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UniqueSectors", "[", "b1", "]"}], "//", 
   RowBox[{"Map", "[", "SolvejSector", "]"}]}], ";"}]], "Input",
 ExpressionUUID -> "d40d3760-f4d6-47b5-8527-bfadb61210ef"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sector \"\>", "\[InvisibleSpace]", 
   RowBox[{"js", "[", 
    RowBox[{"b1", ",", "0", ",", "1"}], "]"}]}],
  SequenceForm["Sector ", 
   LiteRed`js[$CellContext`b1, 0, 1]],
  Editable->False]], "Print"],

Cell[BoxData["\<\"    1 master integrals found:\\nj[b1, 0, 1].\\n    \
jRules[b1, 0, 1] \[LongDash] reduction rules for the sector.\\n    MIs[b1] \
\[LongDash] updated list of the masters.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sector \"\>", "\[InvisibleSpace]", 
   RowBox[{"js", "[", 
    RowBox[{"b1", ",", "1", ",", "1"}], "]"}]}],
  SequenceForm["Sector ", 
   LiteRed`js[$CellContext`b1, 1, 1]],
  Editable->False]], "Print"],

Cell[BoxData["\<\"    1 master integrals found:\\nj[b1, 1, 1].\\n    \
jRules[b1, 1, 1] \[LongDash] reduction rules for the sector.\\n    MIs[b1] \
\[LongDash] updated list of the masters.\"\>"], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"masters", "=", 
  RowBox[{"MIs", "[", "b1", "]"}]}]], "Input",
 ExpressionUUID -> "d78308f6-fe34-4a0d-98d2-66a4517d4d5d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"j", "[", 
    RowBox[{"b1", ",", "0", ",", "1"}], "]"}], ",", 
   RowBox[{"j", "[", 
    RowBox[{"b1", ",", "1", ",", "1"}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{"j", "[", 
     RowBox[{"b1", ",", "0", ",", "2"}], "]"}], ",", " ", 
    RowBox[{"j", "[", 
     RowBox[{"b1", ",", "1", ",", "2"}], "]"}]}], "}"}], "//", 
  "IBPReduce"}]], "Input",
 ExpressionUUID -> "824f87d9-d73e-424b-a200-47676bb8766f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", 
     RowBox[{"j", "[", 
      RowBox[{"b1", ",", "0", ",", "1"}], "]"}]}], 
    RowBox[{"2", " ", "m2"}]], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", 
       RowBox[{"j", "[", 
        RowBox[{"b1", ",", "0", ",", "1"}], "]"}]}], 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"(", 
        RowBox[{"m2", "-", "q2"}], ")"}]}]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "d"}], ")"}], " ", 
      RowBox[{"j", "[", 
       RowBox[{"b1", ",", "1", ",", "1"}], "]"}]}], 
     RowBox[{"m2", "-", "q2"}]]}]}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Differential Equations", "Subsection",
 ExpressionUUID -> "c4207409-079f-40b4-8d2b-42f9261d16c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Dinv"}]], "Input",
 ExpressionUUID -> "b017826e-54d3-403c-a00e-aa870b69582a"],

Cell[BoxData[
 StyleBox["\<\"Dinv[\!\(\*\\nStyleBox[\\\"expr\\\", \\\"TI\\\"]\),p\
\[CenterDot]q] is the differentiation of \!\(\*\\nStyleBox[\\\"expr\\\", \
\\\"TI\\\"]\) with respect to p\[CenterDot]q. It assumes, that other scalar \
products of the external momenta are constants. Pay attention that p\
\[CenterDot]q and q\[CenterDot]p is not exactly the same in the second \
argument. If p\[CenterDot]q is used, the derivative of j[...] is expressed in \
terms of \[PartialD]/\[PartialD]p.\\nExplicit scalar functions of p\
\[CenterDot]q are differentiated correctly, unless p\[CenterDot]q is \
evaluated to something.\\nDinv[\!\(\*\\nStyleBox[\\\"expr\\\", \\\"TI\\\"]\),\
\!\(\*\\nStyleBox[\\\"x\\\", \\\"TI\\\"]\)] gives the derivative of \
\!\(\*\\nStyleBox[\\\"expr\\\", \\\"TI\\\"]\) with respect to the variable \!\
\(\*\\nStyleBox[\\\"x\\\", \\\"TI\\\"]\).\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3826805898-1669308"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dmasters", "=", 
  RowBox[{
   RowBox[{"masters", "//", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Dinv", "[", 
       RowBox[{"#", ",", "m2"}], "]"}], "&"}], "]"}]}], "//", 
   "IBPReduce"}]}]], "Input",
 ExpressionUUID -> "4d58d422-12c6-4d57-a5a3-0147176922eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", 
     RowBox[{"j", "[", 
      RowBox[{"b1", ",", "0", ",", "1"}], "]"}]}], 
    RowBox[{"2", " ", "m2"}]], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "d"}], ")"}], " ", 
       RowBox[{"j", "[", 
        RowBox[{"b1", ",", "0", ",", "1"}], "]"}]}], 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"(", 
        RowBox[{"m2", "-", "q2"}], ")"}]}]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "d"}], ")"}], " ", 
      RowBox[{"j", "[", 
       RowBox[{"b1", ",", "1", ",", "1"}], "]"}]}], 
     RowBox[{"m2", "-", "q2"}]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"dm", ",", "m"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"dm", ",", "dmasters"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "masters"}], "}"}]}], "]"}], "/.", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"4", "-", 
       RowBox[{"2", "ep"}]}]}]}], "/.", 
    RowBox[{"q2", "\[Rule]", "1"}]}], "//", "Factor"}]}]], "Input",
 ExpressionUUID -> "772872be-bf08-4418-b70e-999f51b0e1f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "ep"}], "m2"]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "ep"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "m2"}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "ep"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}]]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Put", "[", 
  RowBox[{
   RowBox[{"M", "/.", 
    RowBox[{"d", "\[Rule]", 
     RowBox[{"4", "-", 
      RowBox[{"2", "eps"}]}]}]}], ",", "\"\<de-matrix.m\>\""}], 
  "]"}]], "Input",
 ExpressionUUID -> "3d531f5f-bf77-4c49-8741-7ab103f654f9"]
}, Closed]],

Cell[CellGroupData[{

Cell["The epsilon form", "Subsection",
 ExpressionUUID -> "1a0d17f3-4bb5-40f1-8c19-d65064f6337d"],

Cell["\<\
Manual step, run: ./fuchsia/fuchsia reduce de-matrix.m -x m2 -e ep -m \
de-matrix.eps -t de-matrix.t\
\>", "Text",
 ExpressionUUID -> "2833c6e0-c48f-448f-b267-5bff77da54fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Run", "[", 
  "\"\<./fuchsia/fuchsia reduce de-matrix.m -x m2 -e ep -m de-matrix.eps -t \
de-matrix.t\>\"", "]"}]], "Input",
 ExpressionUUID -> "71dd99e1-e133-4282-9ee9-7b8b63065317"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Meps", "=", 
   RowBox[{
    RowBox[{"Get", "[", "\"\<de-matrix.eps\>\"", "]"}], "//", 
    RowBox[{
     RowBox[{"Apart", "[", 
      RowBox[{"#", ",", "m2"}], "]"}], "&"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Meps", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "=", 
   RowBox[{"Meps", "/", "ep"}]}], ";"}]}], "Input",
 ExpressionUUID -> "521042ee-e597-46d4-a81f-83091a1b3691"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["ep", "m2"]}], "0"},
     {
      RowBox[{"-", 
       FractionBox["ep", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}]]}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "ep"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"Get", "[", "\"\<de-matrix.t\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"T", "//", "MatrixForm"}]}], "Input",
 ExpressionUUID -> "49681c60-c60d-4831-94d3-2a07d6b62496"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "ep"}]}], ")"}], " ", "m2"}], "0"},
     {
      RowBox[{
       RowBox[{"-", "m2"}], "+", 
       RowBox[{"ep", " ", "m2"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "ep"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Inverse", "[", "T", "]"}], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"M", ".", "T"}], "-", 
      RowBox[{"D", "[", 
       RowBox[{"T", ",", "m2"}], "]"}]}], ")"}]}], "//", "Factor"}], "//", 
  "MatrixForm"}]], "Input",
 ExpressionUUID -> "e75b7fda-15ea-40c2-b193-567517af79dc"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["ep", "m2"]}], "0"},
     {
      RowBox[{"-", 
       FractionBox["ep", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}]]}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "ep"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The solution as a series in epsilon, via Mathematica", "Subsection",
 ExpressionUUID -> "4ba02684-1c33-4a35-ad17-76e40a00b143"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "J", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "[", "0", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "1"}], "]"}], ",", 
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "2"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "[", "k_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"S", ".", 
      RowBox[{"J", "[", 
       RowBox[{"k", "-", "1"}], "]"}]}], ",", "m2"}], "]"}], "+", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"C", "[", 
      RowBox[{"k", ",", "1"}], "]"}], ",", 
     RowBox[{"C", "[", 
      RowBox[{"k", ",", "2"}], "]"}]}], "}"}]}]}]}], "Input",
 ExpressionUUID -> "a5c5271a-230d-4296-8d08-8ae5f2d81793"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"C", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", 
   RowBox[{"C", "[", 
    RowBox[{"0", ",", "2"}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", "1", "]"}], "//", "TraditionalForm"}]], "Input",
 ExpressionUUID -> "745a79b0-ebb9-4bff-9565-0c4d92d821b0"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "-", 
     RowBox[{
      RowBox[{"log", "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"C", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "-", 
     RowBox[{
      RowBox[{"log", "(", 
       RowBox[{"1", "-", "m2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"C", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "2"}], "]"}]}]}], ")"}]}]}]}], "}"}], 
  TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", "2", "]"}], "//", "TraditionalForm"}]], "Input",
 ExpressionUUID -> "ba06ac06-ff44-4f44-83d0-caf7d50bfcb4"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{
       SuperscriptBox["log", "2"], "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"log", "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"2", ",", "1"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      TemplateBox[{"2","m2"},
       "PolyLog"], " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"log", "(", 
       RowBox[{"1", "-", "m2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"log", "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"C", "[", 
            RowBox[{"0", ",", "1"}], "]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"C", "[", 
             RowBox[{"0", ",", "2"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"log", "(", "m2", ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "-", 
        RowBox[{"C", "[", 
         RowBox[{"1", ",", "1"}], "]"}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", 
          RowBox[{"1", ",", "2"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", "3", "]"}], "//", "TraditionalForm"}]], "Input",
 ExpressionUUID -> "96fa7af9-3bad-42ce-99ab-573066c8c231"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{
        SuperscriptBox["log", "3"], "(", "m2", ")"}], " ", 
       RowBox[{"C", "[", 
        RowBox[{"0", ",", "1"}], "]"}]}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{
       SuperscriptBox["log", "2"], "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"log", "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"3", ",", "1"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         TemplateBox[{"3",RowBox[{"1", "-", "m2"}]},
          "PolyLog"], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         TemplateBox[{"3","m2"},
          "PolyLog"], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         TemplateBox[{"2",RowBox[{"1", "-", "m2"}]},
          "PolyLog"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"log", "(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"C", "[", 
             RowBox[{"0", ",", "1"}], "]"}]}], "+", 
           RowBox[{"C", "[", 
            RowBox[{"1", ",", "1"}], "]"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         TemplateBox[{"2","m2"},
          "PolyLog"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"log", "(", 
             RowBox[{"1", "-", "m2"}], ")"}]}], "+", 
           RowBox[{"log", "(", "m2", ")"}]}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "-", 
        RowBox[{
         FractionBox["4", "3"], " ", 
         RowBox[{
          SuperscriptBox["log", "3"], "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "-", 
        RowBox[{
         FractionBox["8", "3"], " ", 
         RowBox[{
          SuperscriptBox["log", "3"], "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "2"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["log", "2"], "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"1", ",", "1"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["log", "2"], "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"1", ",", "2"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"log", "(", "m2", ")"}], " ", 
         RowBox[{
          SuperscriptBox["log", "2"], "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["log", "2"], "(", "m2", ")"}], " ", 
         RowBox[{"log", "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"log", "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"2", ",", "1"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"log", "(", 
          RowBox[{"1", "-", "m2"}], ")"}], " ", 
         RowBox[{"C", "[", 
          RowBox[{"2", ",", "2"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"3", ",", "2"}], "]"}]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", "4", "]"}], "//", "TraditionalForm"}]], "Input",
 ExpressionUUID -> "c0c87a18-7e8d-4817-b2fb-30e95a9de4d4"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "24"], " ", 
      RowBox[{
       SuperscriptBox["log", "4"], "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}]}], "-", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{
       SuperscriptBox["log", "3"], "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{
       SuperscriptBox["log", "2"], "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"log", "(", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"4", ",", "1"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"m2", "-", "1"}]]}], "2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                TemplateBox[{"3",RowBox[{"1", "-", "m2"}]},
                 "PolyLog"], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"0", ",", "1"}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                TemplateBox[{"3","m2"},
                 "PolyLog"], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"0", ",", "1"}], "]"}]}], "-", 
               RowBox[{"2", " ", 
                TemplateBox[{"2",RowBox[{"1", "-", "m2"}]},
                 "PolyLog"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   RowBox[{"log", "(", 
                    RowBox[{"1", "-", "m2"}], ")"}], " ", 
                   RowBox[{"C", "[", 
                    RowBox[{"0", ",", "1"}], "]"}]}], "+", 
                  RowBox[{"C", "[", 
                   RowBox[{"1", ",", "1"}], "]"}]}], ")"}]}], "-", 
               RowBox[{"2", " ", 
                TemplateBox[{"2","m2"},
                 "PolyLog"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   RowBox[{"log", "(", 
                    RowBox[{"1", "-", "m2"}], ")"}]}], "+", 
                  RowBox[{"log", "(", "m2", ")"}]}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"0", ",", "1"}], "]"}]}], "-", 
               RowBox[{
                FractionBox["4", "3"], " ", 
                RowBox[{
                 SuperscriptBox["log", "3"], "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"0", ",", "1"}], "]"}]}], "-", 
               RowBox[{
                FractionBox["8", "3"], " ", 
                RowBox[{
                 SuperscriptBox["log", "3"], "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"0", ",", "2"}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{
                 SuperscriptBox["log", "2"], "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"1", ",", "1"}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                RowBox[{
                 SuperscriptBox["log", "2"], "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"1", ",", "2"}], "]"}]}], "-", 
               RowBox[{"4", " ", 
                RowBox[{"log", "(", "m2", ")"}], " ", 
                RowBox[{
                 SuperscriptBox["log", "2"], "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"0", ",", "1"}], "]"}]}], "-", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["log", "2"], "(", "m2", ")"}], " ", 
                RowBox[{"log", "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"0", ",", "1"}], "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"log", "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"2", ",", "1"}], "]"}]}], "-", 
               RowBox[{"4", " ", 
                RowBox[{"log", "(", 
                 RowBox[{"1", "-", "m2"}], ")"}], " ", 
                RowBox[{"C", "[", 
                 RowBox[{"2", ",", "2"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"3", ",", "2"}], "]"}]}], ")"}]}], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             FractionBox["1", "6"], " ", 
             RowBox[{
              SuperscriptBox["log", "3"], "(", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}]}], "+", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{
             SuperscriptBox["log", "2"], "(", "m2", ")"}], " ", 
            RowBox[{"C", "[", 
             RowBox[{"1", ",", "1"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"log", "(", "m2", ")"}], " ", 
            RowBox[{"C", "[", 
             RowBox[{"2", ",", "1"}], "]"}]}], "+", 
           RowBox[{"C", "[", 
            RowBox[{"3", ",", "1"}], "]"}]}], 
          RowBox[{"m2", "-", "1"}]]}], ")"}], 
       RowBox[{"\[DifferentialD]", "m2"}]}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"4", ",", "2"}], "]"}]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The solution as a series in epsilon, via GPLs", "Subsection",
 ExpressionUUID -> "1fd75bb0-d426-4ccc-b46c-7a206218e2f8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"G", "[", 
     RowBox[{"w___", ",", "x_"}], "]"}], ",", 
    RowBox[{"form", ":", 
     RowBox[{"(", "TraditionalForm", ")"}]}]}], "]"}], ":=", 
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<G\>\"", ",", "\"\<(\>\"", ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"MakeBoxes", "[", 
            RowBox[{"#", ",", "form"}], "]"}], "&"}], ",", 
          RowBox[{"{", "w", "}"}]}], "]"}], ",", "\"\<,\>\""}], "]"}], "]"}], 
     ",", "\"\<;\>\"", ",", 
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"x", ",", "form"}], "]"}], ",", "\"\<)\>\""}], "}"}], 
   "]"}]}]], "Input",
 ExpressionUUID -> "5694a397-db2a-4544-806c-505f1acbf4f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}]], "Input",
 ExpressionUUID -> "157c0a7c-b4c8-4960-86ff-cc61cfbcb9c5"],

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"G", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 ExpressionUUID -> "4b290a5c-ff81-4121-9c97-3cbab987713e"],

Cell[BoxData[
 FormBox[
  RowBox[{"G", "(", 
   RowBox[{"a", ",", "b", ",", "c"}], ";", "x", ")"}], 
  TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"HlogSimpleIntegrate", "[", 
   RowBox[{"ex_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"symbol", ",", "a", ",", "b", ",", "w"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ex", "//", 
         RowBox[{
          RowBox[{"Apart", "[", 
           RowBox[{"#", ",", "x"}], "]"}], "&"}]}], "//", 
        "\[IndentingNewLine]", 
        RowBox[{"ReplaceAll", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a_.", "*", "x"}], "+", "b_."}], ")"}]}], ":>", 
          RowBox[{
           RowBox[{"1", "/", "a"}], " ", 
           RowBox[{"symbol", "[", 
            RowBox[{
             RowBox[{"-", "b"}], "/", "a"}], "]"}]}]}], "]"}]}], "//", 
       "\[IndentingNewLine]", "Expand"}], "//", "\[IndentingNewLine]", 
      RowBox[{"ReplaceAll", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"symbol", "[", "a_", "]"}], "*", 
         RowBox[{"G", "[", 
          RowBox[{"w___", ",", "x"}], "]"}]}], "\[RuleDelayed]", 
        RowBox[{"G", "[", 
         RowBox[{"a", ",", "w", ",", "x"}], "]"}]}], "]"}]}], "//", 
     "\[IndentingNewLine]", 
     RowBox[{"ReplaceAll", "[", 
      RowBox[{
       RowBox[{"symbol", "[", "a_", "]"}], "\[RuleDelayed]", 
       RowBox[{"G", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HlogSimpleIntegrate", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"HlogSimpleIntegrate", "[", 
    RowBox[{"#", ",", "x"}], "]"}], "&"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HlogSimpleIntegrate", "[", 
   RowBox[{"ex_List", ",", "x_"}], "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{"HlogSimpleIntegrate", "[", "x", "]"}], ",", "ex"}], 
   "]"}]}]}], "Input",
 ExpressionUUID -> "2f4448a3-41d2-4653-989a-0af903b5c7c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "/", "x"}], " ", 
   RowBox[{"G", "[", 
    RowBox[{"1", ",", "2", ",", "x"}], "]"}]}], "//", 
  RowBox[{"HlogSimpleIntegrate", "[", "x", "]"}]}]], "Input",
 ExpressionUUID -> "ff0d8d8e-1d32-46da-b2f7-b10a7a56c90f"],

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"0", ",", "1", ",", "2", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "J", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "[", "0", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "1"}], "]"}], ",", 
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "2"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "[", "k_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"S", ".", 
     RowBox[{"J", "[", 
      RowBox[{"k", "-", "1"}], "]"}]}], "//", 
    RowBox[{"HlogSimpleIntegrate", "[", "m2", "]"}]}], "//", 
   RowBox[{
    RowBox[{"#", "+", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"C", "[", 
        RowBox[{"k", ",", "1"}], "]"}], ",", 
       RowBox[{"C", "[", 
        RowBox[{"k", ",", "2"}], "]"}]}], "}"}]}], "&"}]}]}]}], "Input",
 ExpressionUUID -> "2bb37d0e-79fb-446c-b3c4-0d8db37729ab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"C", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", 
   RowBox[{"C", "[", 
    RowBox[{"0", ",", "2"}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J", "[", "1", "]"}]], "Input",
 ExpressionUUID -> "7baed363-0ff1-44b5-92cb-da43b6f15e5f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"1", ",", "1"}], "]"}], "-", 
    RowBox[{
     RowBox[{"C", "[", 
      RowBox[{"0", ",", "1"}], "]"}], " ", 
     RowBox[{"G", "[", 
      RowBox[{"0", ",", "m2"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "-", 
    RowBox[{
     RowBox[{"C", "[", 
      RowBox[{"0", ",", "1"}], "]"}], " ", 
     RowBox[{"G", "[", 
      RowBox[{"1", ",", "m2"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"C", "[", 
      RowBox[{"0", ",", "2"}], "]"}], " ", 
     RowBox[{"G", "[", 
      RowBox[{"1", ",", "m2"}], "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", "2", "]"}], "//", "TraditionalForm"}]], "Input",
 ExpressionUUID -> "7300a0b0-b79a-47f0-960b-eee6186d8d24"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
       RowBox[{"C", "[", 
        RowBox[{"1", ",", "1"}], "]"}]}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"2", ",", "1"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
       RowBox[{"C", "[", 
        RowBox[{"1", ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "2"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", "3", "]"}], "//", "TraditionalForm"}]], "Input",
 ExpressionUUID -> "ac37aa40-7761-45eb-9d86-31db4fdf09af"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
       RowBox[{"C", "[", 
        RowBox[{"2", ",", "1"}], "]"}]}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"3", ",", "1"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
       RowBox[{"C", "[", 
        RowBox[{"2", ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "2"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"3", ",", "2"}], "]"}]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", "10", "]"}], "//", "TraditionalForm"}]], "Input",
 ExpressionUUID -> "0ae201f3-1d7b-40b0-8d7c-f9c1aef92380"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", 
      RowBox[{"10", ",", "1"}], "]"}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"9", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", "0", ";", "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"8", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"7", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"6", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"5", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], ";", "m2", 
       ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], ";", 
       "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], ";",
        "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"C", "[", 
      RowBox[{"10", ",", "2"}], "]"}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"9", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", "1", ";", "m2", ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"9", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", "1", ";", "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"8", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"8", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"8", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"7", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"7", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"7", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"7", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"6", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"6", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"6", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"6", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"16", " ", 
      RowBox[{"C", "[", 
       RowBox[{"6", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"5", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ";", "m2", 
       ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"5", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], ";", "m2", 
       ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"5", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "0"}], ";", "m2", 
       ")"}]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"5", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "0"}], ";", "m2", 
       ")"}]}], "-", 
     RowBox[{"16", " ", 
      RowBox[{"C", "[", 
       RowBox[{"5", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], ";", "m2", 
       ")"}]}], "-", 
     RowBox[{"32", " ", 
      RowBox[{"C", "[", 
       RowBox[{"5", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], ";", "m2", 
       ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], ";", 
       "m2", ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], ";", 
       "m2", ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], ";", 
       "m2", ")"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0"}], ";", 
       "m2", ")"}]}], "+", 
     RowBox[{"16", " ", 
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0"}], ";", 
       "m2", ")"}]}], "+", 
     RowBox[{"32", " ", 
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], ";", 
       "m2", ")"}]}], "+", 
     RowBox[{"64", " ", 
      RowBox[{"C", "[", 
       RowBox[{"4", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], ";", 
       "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], ";",
        "m2", ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], ";",
        "m2", ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], ";",
        "m2", ")"}]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], ";",
        "m2", ")"}]}], "-", 
     RowBox[{"16", " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0"}], ";",
        "m2", ")"}]}], "-", 
     RowBox[{"32", " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0"}], ";",
        "m2", ")"}]}], "-", 
     RowBox[{"64", " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], ";",
        "m2", ")"}]}], "-", 
     RowBox[{"128", " ", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], ";",
        "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
        "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"16", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
        "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"32", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
        "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"64", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"128", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"256", " ", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1"}], ";", "m2", ")"}]}], "-", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"16", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"32", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"64", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"128", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "0"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"256", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1"}], ";", "m2", ")"}]}], "-", 
     RowBox[{"512", " ", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"16", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"32", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"64", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"128", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"256", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "0"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"512", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "1"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
     RowBox[{"1024", " ", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "2"}], "]"}], " ", 
      RowBox[{"G", "(", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1", ",", "1", ",", "1"}], ";", "m2", ")"}]}]}]}], "}"}], 
  TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Jseries", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"J", "[", "0", "]"}], "+", 
     RowBox[{
      RowBox[{"J", "[", "1", "]"}], "ep"}], "+", 
     RowBox[{
      RowBox[{"J", "[", "2", "]"}], 
      RowBox[{"ep", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"J", "[", "3", "]"}], 
      RowBox[{"ep", "^", "3"}]}], "+", 
     RowBox[{
      RowBox[{"O", "[", "ep", "]"}], "^", "4"}]}], ")"}]}], ";"}]], "Input",
 ExpressionUUID -> "03966599-5d00-4d29-8f28-f9ac4e8506b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Jseries", "//", "TableForm"}], "//", "TraditionalForm"}]], "Input",\

 ExpressionUUID -> "109b25e8-9a2b-47a4-9e68-49167c08a94f"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       InterpretationBox[
        RowBox[{
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "1"}], "]"}], "+", 
         RowBox[{"ep", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"C", "[", 
             RowBox[{"1", ",", "1"}], "]"}], "-", 
            RowBox[{
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
              RowBox[{"C", "[", 
               RowBox[{"1", ",", "1"}], "]"}]}]}], "+", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"2", ",", "1"}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
              RowBox[{"C", "[", 
               RowBox[{"2", ",", "1"}], "]"}]}]}], "+", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"3", ",", "1"}], "]"}]}], ")"}]}], "+", 
         InterpretationBox[
          RowBox[{"O", "(", 
           SuperscriptBox["ep", "4"], ")"}],
          SeriesData[$CellContext`ep, 0, {}, 0, 4, 1],
          Editable->False]}],
        SeriesData[$CellContext`ep, 0, {
          C[0, 1], C[1, 1] - C[0, 1] $CellContext`G[0, $CellContext`m2], 
          C[2, 1] - C[1, 1] $CellContext`G[0, $CellContext`m2] + 
          C[0, 1] $CellContext`G[0, 0, $CellContext`m2], C[3, 1] - 
          C[2, 1] $CellContext`G[0, $CellContext`m2] + 
          C[1, 1] $CellContext`G[0, 0, $CellContext`m2] - 
          C[0, 1] $CellContext`G[0, 0, 0, $CellContext`m2]}, 0, 4, 1],
        Editable->False]},
      {
       InterpretationBox[
        RowBox[{
         RowBox[{"C", "[", 
          RowBox[{"0", ",", "2"}], "]"}], "+", 
         RowBox[{"ep", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
              RowBox[{"C", "[", 
               RowBox[{"0", ",", "1"}], "]"}]}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}]}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
              RowBox[{"C", "[", 
               RowBox[{"1", ",", "1"}], "]"}]}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"2", ",", "2"}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
              RowBox[{"C", "[", 
               RowBox[{"2", ",", "1"}], "]"}]}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"8", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"3", ",", "2"}], "]"}]}], ")"}]}], "+", 
         InterpretationBox[
          RowBox[{"O", "(", 
           SuperscriptBox["ep", "4"], ")"}],
          SeriesData[$CellContext`ep, 0, {}, 0, 4, 1],
          Editable->False]}],
        SeriesData[$CellContext`ep, 0, {
          C[0, 2], C[1, 2] - C[0, 1] $CellContext`G[1, $CellContext`m2] - 2 
          C[0, 2] $CellContext`G[1, $CellContext`m2], C[2, 2] - 
          C[1, 1] $CellContext`G[1, $CellContext`m2] - 2 
          C[1, 2] $CellContext`G[1, $CellContext`m2] + 
          C[0, 1] $CellContext`G[1, 0, $CellContext`m2] + 
          2 C[0, 1] $CellContext`G[1, 1, $CellContext`m2] + 
          4 C[0, 2] $CellContext`G[1, 1, $CellContext`m2], C[3, 2] - 
          C[2, 1] $CellContext`G[1, $CellContext`m2] - 2 
          C[2, 2] $CellContext`G[1, $CellContext`m2] + 
          C[1, 1] $CellContext`G[1, 0, $CellContext`m2] + 
          2 C[1, 1] $CellContext`G[1, 1, $CellContext`m2] + 
          4 C[1, 2] $CellContext`G[1, 1, $CellContext`m2] - 
          C[0, 1] $CellContext`G[1, 0, 0, $CellContext`m2] - 2 
          C[0, 1] $CellContext`G[1, 1, 0, $CellContext`m2] - 4 
          C[0, 1] $CellContext`G[1, 1, 1, $CellContext`m2] - 8 
          C[0, 2] $CellContext`G[1, 1, 1, $CellContext`m2]}, 0, 4, 1],
        Editable->False]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column],
   Function[BoxForm`e$, 
    TableForm[BoxForm`e$]]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Iseries", "=", 
   RowBox[{"T", ".", "Jseries"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Iseries", "//", "ExpandAll"}], "//", "TableForm"}], "//", 
  "TraditionalForm"}]}], "Input",
 ExpressionUUID -> "8946efd3-f139-48dd-a0af-5112ce8481f2"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{"m2", " ", 
           RowBox[{"C", "[", 
            RowBox[{"0", ",", "1"}], "]"}]}]}], "+", 
         RowBox[{"ep", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"3", ",", "1"}], "]"}]}]}], ")"}]}], "+", 
         InterpretationBox[
          RowBox[{"O", "(", 
           SuperscriptBox["ep", "4"], ")"}],
          SeriesData[$CellContext`ep, 0, {}, 0, 4, 1],
          Editable->False]}],
        SeriesData[$CellContext`ep, 
         0, {-$CellContext`m2 C[0, 1], 
          2 $CellContext`m2 C[0, 1] - $CellContext`m2 
          C[1, 1] + $CellContext`m2 
           C[0, 1] $CellContext`G[0, $CellContext`m2], 
          2 $CellContext`m2 C[1, 1] - $CellContext`m2 C[2, 1] - 
          2 $CellContext`m2 
          C[0, 1] $CellContext`G[0, $CellContext`m2] + $CellContext`m2 
           C[1, 1] $CellContext`G[0, $CellContext`m2] - $CellContext`m2 
          C[0, 1] $CellContext`G[0, 0, $CellContext`m2], 
          2 $CellContext`m2 C[2, 1] - $CellContext`m2 C[3, 1] - 
          2 $CellContext`m2 
          C[1, 1] $CellContext`G[0, $CellContext`m2] + $CellContext`m2 
           C[2, 1] $CellContext`G[0, $CellContext`m2] + 
          2 $CellContext`m2 
           C[0, 1] $CellContext`G[0, 0, $CellContext`m2] - $CellContext`m2 
          C[1, 1] $CellContext`G[0, 0, $CellContext`m2] + $CellContext`m2 
           C[0, 1] $CellContext`G[0, 0, 0, $CellContext`m2]}, 0, 4, 1],
        Editable->False]},
      {
       InterpretationBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}]}], "-", 
           RowBox[{"m2", " ", 
            RowBox[{"C", "[", 
             RowBox[{"0", ",", "2"}], "]"}]}], "+", 
           RowBox[{"C", "[", 
            RowBox[{"0", ",", "2"}], "]"}]}], ")"}], "+", 
         RowBox[{"ep", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}]}], "-", 
            RowBox[{"C", "[", 
             RowBox[{"0", ",", "2"}], "]"}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}]}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"4", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "-", 
            RowBox[{"C", "[", 
             RowBox[{"1", ",", "2"}], "]"}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"2", ",", "2"}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ep", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "0", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"G", "(", "1", ";", "m2", ")"}], " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"4", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"4", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", 
              RowBox[{"1", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"0", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "0", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "0"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "0"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"4", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "1"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"8", " ", "m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "-", 
            RowBox[{"8", " ", 
             RowBox[{"C", "[", 
              RowBox[{"0", ",", "2"}], "]"}], " ", 
             RowBox[{"G", "(", 
              RowBox[{"1", ",", "1", ",", "1"}], ";", "m2", ")"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "1"}], "]"}]}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"3", ",", "1"}], "]"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"C", "[", 
              RowBox[{"3", ",", "2"}], "]"}]}], "-", 
            RowBox[{"C", "[", 
             RowBox[{"2", ",", "2"}], "]"}], "+", 
            RowBox[{"C", "[", 
             RowBox[{"3", ",", "2"}], "]"}]}], ")"}]}], "+", 
         InterpretationBox[
          RowBox[{"O", "(", 
           SuperscriptBox["ep", "4"], ")"}],
          SeriesData[$CellContext`ep, 0, {}, 0, 4, 1],
          Editable->False]}],
        SeriesData[$CellContext`ep, 
         0, {-$CellContext`m2 C[0, 1] + C[0, 2] - $CellContext`m2 
          C[0, 2], $CellContext`m2 C[0, 1] - C[
          0, 2] + $CellContext`m2 C[0, 2] - $CellContext`m2 C[1, 1] + 
          C[1, 2] - $CellContext`m2 
          C[1, 2] + $CellContext`m2 
           C[0, 1] $CellContext`G[0, $CellContext`m2] - 
          C[0, 1] $CellContext`G[1, $CellContext`m2] + $CellContext`m2 
           C[0, 1] $CellContext`G[1, $CellContext`m2] - 2 
          C[0, 2] $CellContext`G[1, $CellContext`m2] + 
          2 $CellContext`m2 
           C[0, 2] $CellContext`G[1, $CellContext`m2], $CellContext`m2 
           C[1, 1] - C[1, 2] + $CellContext`m2 C[1, 2] - $CellContext`m2 
          C[2, 1] + C[2, 2] - $CellContext`m2 C[2, 2] - $CellContext`m2 
          C[0, 1] $CellContext`G[0, $CellContext`m2] + $CellContext`m2 
           C[1, 1] $CellContext`G[0, $CellContext`m2] + 
          C[0, 1] $CellContext`G[1, $CellContext`m2] - $CellContext`m2 
          C[0, 1] $CellContext`G[1, $CellContext`m2] + 
          2 C[0, 2] $CellContext`G[1, $CellContext`m2] - 2 $CellContext`m2 
          C[0, 2] $CellContext`G[1, $CellContext`m2] - 
          C[1, 1] $CellContext`G[1, $CellContext`m2] + $CellContext`m2 
           C[1, 1] $CellContext`G[1, $CellContext`m2] - 2 
          C[1, 2] $CellContext`G[1, $CellContext`m2] + 
          2 $CellContext`m2 
           C[1, 2] $CellContext`G[1, $CellContext`m2] - $CellContext`m2 
          C[0, 1] $CellContext`G[0, 0, $CellContext`m2] + 
          C[0, 1] $CellContext`G[1, 0, $CellContext`m2] - $CellContext`m2 
          C[0, 1] $CellContext`G[1, 0, $CellContext`m2] + 
          2 C[0, 1] $CellContext`G[1, 1, $CellContext`m2] - 2 $CellContext`m2 
          C[0, 1] $CellContext`G[1, 1, $CellContext`m2] + 
          4 C[0, 2] $CellContext`G[1, 1, $CellContext`m2] - 4 $CellContext`m2 
          C[0, 2] $CellContext`G[1, 1, $CellContext`m2], $CellContext`m2 
           C[2, 1] - C[2, 2] + $CellContext`m2 C[2, 2] - $CellContext`m2 
          C[3, 1] + C[3, 2] - $CellContext`m2 C[3, 2] - $CellContext`m2 
          C[1, 1] $CellContext`G[0, $CellContext`m2] + $CellContext`m2 
           C[2, 1] $CellContext`G[0, $CellContext`m2] + 
          C[1, 1] $CellContext`G[1, $CellContext`m2] - $CellContext`m2 
          C[1, 1] $CellContext`G[1, $CellContext`m2] + 
          2 C[1, 2] $CellContext`G[1, $CellContext`m2] - 2 $CellContext`m2 
          C[1, 2] $CellContext`G[1, $CellContext`m2] - 
          C[2, 1] $CellContext`G[1, $CellContext`m2] + $CellContext`m2 
           C[2, 1] $CellContext`G[1, $CellContext`m2] - 2 
          C[2, 2] $CellContext`G[1, $CellContext`m2] + 
          2 $CellContext`m2 
           C[2, 2] $CellContext`G[1, $CellContext`m2] + $CellContext`m2 
           C[0, 1] $CellContext`G[0, 0, $CellContext`m2] - $CellContext`m2 
          C[1, 1] $CellContext`G[0, 0, $CellContext`m2] - 
          C[0, 1] $CellContext`G[1, 0, $CellContext`m2] + $CellContext`m2 
           C[0, 1] $CellContext`G[1, 0, $CellContext`m2] + 
          C[1, 1] $CellContext`G[1, 0, $CellContext`m2] - $CellContext`m2 
          C[1, 1] $CellContext`G[1, 0, $CellContext`m2] - 2 
          C[0, 1] $CellContext`G[1, 1, $CellContext`m2] + 
          2 $CellContext`m2 C[0, 1] $CellContext`G[1, 1, $CellContext`m2] - 4 
          C[0, 2] $CellContext`G[1, 1, $CellContext`m2] + 
          4 $CellContext`m2 C[0, 2] $CellContext`G[1, 1, $CellContext`m2] + 
          2 C[1, 1] $CellContext`G[1, 1, $CellContext`m2] - 2 $CellContext`m2 
          C[1, 1] $CellContext`G[1, 1, $CellContext`m2] + 
          4 C[1, 2] $CellContext`G[1, 1, $CellContext`m2] - 4 $CellContext`m2 
          C[1, 2] $CellContext`G[1, 1, $CellContext`m2] + $CellContext`m2 
           C[0, 1] $CellContext`G[0, 0, 0, $CellContext`m2] - 
          C[0, 1] $CellContext`G[1, 0, 0, $CellContext`m2] + $CellContext`m2 
           C[0, 1] $CellContext`G[1, 0, 0, $CellContext`m2] - 2 
          C[0, 1] $CellContext`G[1, 1, 0, $CellContext`m2] + 
          2 $CellContext`m2 C[0, 1] $CellContext`G[1, 1, 0, $CellContext`m2] - 
          4 C[0, 1] $CellContext`G[1, 1, 1, $CellContext`m2] + 
          4 $CellContext`m2 C[0, 1] $CellContext`G[1, 1, 1, $CellContext`m2] - 
          8 C[0, 2] $CellContext`G[1, 1, 1, $CellContext`m2] + 
          8 $CellContext`m2 C[0, 2] $CellContext`G[1, 1, 1, $CellContext`m2]},
          0, 4, 1],
        Editable->False]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column],
   Function[BoxForm`e$, 
    TableForm[BoxForm`e$]]], TraditionalForm]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Fixing integration constants", "Subsection",
 ExpressionUUID -> "2ce9ef3e-a7f0-4544-987b-635fe07186ef"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"massivevacuumbubble", "=", 
   RowBox[{
    RowBox[{"-", "I"}], " ", 
    RowBox[{
     RowBox[{"Pi", "^", 
      RowBox[{"(", 
       RowBox[{"d", "/", "2"}], ")"}]}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "Pi"}], ")"}], "^", "d"}]}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "-", 
      RowBox[{"d", "/", "2"}]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m2", "-", "i0"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", "/", "2"}], "-", "1"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"masslessbubble", "=", 
   RowBox[{"I", " ", 
    RowBox[{
     RowBox[{"Pi", "^", 
      RowBox[{"(", 
       RowBox[{"d", "/", "2"}], ")"}]}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "Pi"}], ")"}], "^", "d"}]}], " ", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"d", "/", "2"}], "-", "1"}], "]"}], "^", "2"}], 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"2", "-", 
       RowBox[{"d", "/", "2"}]}], "]"}], "/", 
     RowBox[{"Gamma", "[", 
      RowBox[{"d", "-", "2"}], "]"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "q2"}], "-", "i0"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", "/", "2"}], "-", "2"}], ")"}]}]}]}], ";"}]}], "Input"],

Cell["Take out a common prefactor, just for convenience:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"commonfactor", "=", 
   RowBox[{"I", " ", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "EulerGamma"}], " ", "ep"}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", "Pi"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"2", "-", "ep"}], ")"}]}]}], 
    RowBox[{"q2", "^", 
     RowBox[{"(", 
      RowBox[{"-", "ep"}], ")"}]}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"knownI1series", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"massivevacuumbubble", "/", "commonfactor"}], "/.", 
         RowBox[{"d", "\[Rule]", 
          RowBox[{"4", "-", 
           RowBox[{"2", "ep"}]}]}]}], "/.", 
        RowBox[{"i0", "\[Rule]", "0"}]}], ")"}], "+", 
      RowBox[{
       RowBox[{"O", "[", "ep", "]"}], "^", "3"}]}], "/.", 
     RowBox[{"q2", "\[Rule]", "1"}]}], "/.", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", "m2", "]"}], "^", "n_."}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"n", "!"}], 
      RowBox[{"G", "[", 
       RowBox[{
        RowBox[{"Sequence", "@@", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", "n", "}"}]}], "]"}]}], ",", "m2"}], "]"}]}]}]}], "//",
    "FunctionExpand"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["m2", "ep"], "+", 
   RowBox[{"(", 
    RowBox[{"m2", "-", 
     RowBox[{"m2", " ", 
      RowBox[{"G", "[", 
       RowBox[{"0", ",", "m2"}], "]"}]}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], " ", "m2"}], "-", 
         RowBox[{"m2", " ", 
          SuperscriptBox["\[Pi]", "2"]}], "+", 
         RowBox[{"12", " ", "m2", " ", 
          RowBox[{"G", "[", 
           RowBox[{"0", ",", "m2"}], "]"}]}], "-", 
         RowBox[{"12", " ", "m2", " ", 
          RowBox[{"G", "[", 
           RowBox[{"0", ",", "0", ",", "m2"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["3", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", "m2"}], "+", 
         RowBox[{"m2", " ", 
          SuperscriptBox["\[Pi]", "2"]}], "-", 
         RowBox[{"12", " ", "m2", " ", 
          RowBox[{"G", "[", 
           RowBox[{"0", ",", "m2"}], "]"}]}], "+", 
         RowBox[{"12", " ", "m2", " ", 
          RowBox[{"G", "[", 
           RowBox[{"0", ",", "0", ",", "m2"}], "]"}]}]}], ")"}]}]}], ")"}], 
    " ", "ep"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m2", "+", 
      FractionBox[
       RowBox[{"m2", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "12"], "-", 
      RowBox[{"m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "12"], " ", "m2", " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "0", ",", "0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "3"], " ", "m2", " ", 
       RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["ep", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "ep", "]"}], "3"],
    SeriesData[$CellContext`ep, 0, {}, -1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`ep, 
   0, {$CellContext`m2, $CellContext`m2 - $CellContext`m2 $CellContext`G[
     0, $CellContext`m2], 
    Rational[2, 3] ((-12) $CellContext`m2 - $CellContext`m2 Pi^2 + 
      12 $CellContext`m2 $CellContext`G[0, $CellContext`m2] - 
      12 $CellContext`m2 $CellContext`G[0, 0, $CellContext`m2]) + 
    Rational[3, 4] (12 $CellContext`m2 + $CellContext`m2 Pi^2 - 
      12 $CellContext`m2 $CellContext`G[0, $CellContext`m2] + 
      12 $CellContext`m2 $CellContext`G[
        0, 0, $CellContext`m2]), $CellContext`m2 + 
    Rational[1, 12] $CellContext`m2 Pi^2 - $CellContext`m2 $CellContext`G[
     0, $CellContext`m2] + 
    Rational[-1, 12] $CellContext`m2 
     Pi^2 $CellContext`G[0, $CellContext`m2] + $CellContext`m2 $CellContext`G[
      0, 0, $CellContext`m2] - $CellContext`m2 $CellContext`G[
     0, 0, 0, $CellContext`m2] + Rational[-1, 3] $CellContext`m2 Zeta[3]}, -1,
    3, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"knownI2nomassseries", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"masslessbubble", "/", "commonfactor"}], "/.", 
        RowBox[{"d", "\[Rule]", 
         RowBox[{"4", "-", 
          RowBox[{"2", "ep"}]}]}]}], ")"}], "+", 
      RowBox[{
       RowBox[{"O", "[", "ep", "]"}], "^", "3"}]}], "/.", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "q2"}], "-", "i0"}], "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"Log", "[", "q2", "]"}], "-", 
       RowBox[{"I", " ", "Pi"}]}]}]}], "/.", 
    RowBox[{"q2", "\[Rule]", "1"}]}], "//", "FunctionExpand"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "ep"], "+", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["3", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"48", "+", 
         RowBox[{"24", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "48"}], "-", 
         RowBox[{"24", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}]}], ")"}], " ", "ep"}], 
   "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"8", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
      FractionBox[
       RowBox[{"7", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "6"], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["\[Pi]", "3"]}], "4"], "-", 
      FractionBox[
       RowBox[{"7", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}], "3"]}], ")"}], " ", 
    SuperscriptBox["ep", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "ep", "]"}], "3"],
    SeriesData[$CellContext`ep, 0, {}, -1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`ep, 0, {
   1, 2 + Complex[0, 1] Pi, Rational[3, 4] (48 + Complex[0, 24] Pi - 7 Pi^2) + 
    Rational[2, 3] (-48 + Complex[0, -24] Pi + 7 Pi^2), 8 + Complex[0, 4] Pi + 
    Rational[-7, 6] Pi^2 + Complex[0, 
       Rational[-1, 4]] Pi^3 + Rational[-7, 3] Zeta[3]}, -1, 3, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k0", "=", 
  RowBox[{"-", "1"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"CaseUnion", "[", "pat_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{"#", ",", "pat", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], "&"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cvalues1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Iseries", "[", 
           RowBox[{"[", "1", "]"}], "]"}], 
          RowBox[{"ep", "^", "k0"}]}], "-", "knownI1series"}], "//", 
        "\[IndentingNewLine]", "Normal"}], "//", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Collect", "[", 
         RowBox[{"#", ",", 
          RowBox[{"ep", "|", "_G"}], ",", "COEF"}], "]"}], "&"}]}], "//", 
      "\[IndentingNewLine]", "Expand"}], "//", "\[IndentingNewLine]", 
     RowBox[{"CaseUnion", "[", 
      RowBox[{
       RowBox[{"COEF", "[", "ex_", "]"}], "\[RuleDelayed]", 
       RowBox[{"ex", "\[Equal]", "0"}]}], "]"}]}], "//", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"#", ",", 
       RowBox[{"#", "//", 
        RowBox[{"CaseUnion", "[", "_C", "]"}]}]}], "]"}], "&"}]}], "//", 
   "\[IndentingNewLine]", "First"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"2", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "84"}], "-", 
       SuperscriptBox["\[Pi]", "2"]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"3", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "180"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Iseries", "[", 
      RowBox[{"[", "2", "]"}], "]"}], 
     RowBox[{"ep", "^", "k0"}]}], "/.", "cvalues1"}], "/.", 
   RowBox[{"m2", "\[Rule]", "0"}]}], "/.", 
  RowBox[{
   RowBox[{"G", "[", 
    RowBox[{"___", ",", "1", ",", "0"}], "]"}], "\[Rule]", "0"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "2"}], "]"}], "ep"], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"C", "[", 
       RowBox[{"0", ",", "2"}], "]"}]}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"C", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "+", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "-", 
      RowBox[{"G", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], ")"}], " ", "ep"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"C", "[", 
        RowBox[{"2", ",", "2"}], "]"}]}], "+", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "2"}], "]"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], "+", 
      RowBox[{"G", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["ep", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "ep", "]"}], "3"],
    SeriesData[$CellContext`ep, 0, {}, -1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`ep, 0, {
    C[0, 2], -C[0, 2] + C[1, 2], -C[1, 2] + C[2, 2] - $CellContext`G[
    1, 0, 0], -C[2, 2] + C[3, 2] - 
    2 $CellContext`G[1, 0, 0] + $CellContext`G[1, 0, 0, 0] + 
    2 $CellContext`G[1, 1, 0, 0]}, -1, 3, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Iseries", "[", 
       RowBox[{"[", "2", "]"}], "]"}], 
      RowBox[{"ep", "^", "k0"}]}], "-", "knownI2nomassseries"}], "/.", 
    RowBox[{"m2", "\[Rule]", "0"}]}], "/.", 
   RowBox[{
    RowBox[{"G", "[", 
     RowBox[{"___", ",", "0"}], "]"}], "\[Rule]", "0"}]}], "/.", 
  "cvalues1"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"0", ",", "2"}], "]"}]}], "ep"], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "-", 
     RowBox[{"C", "[", 
      RowBox[{"0", ",", "2"}], "]"}], "+", 
     RowBox[{"C", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{"48", "+", 
         RowBox[{"24", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "48"}], "-", 
         RowBox[{"24", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}], "-", 
      RowBox[{"C", "[", 
       RowBox[{"1", ",", "2"}], "]"}], "+", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "2"}], "]"}]}], ")"}], " ", "ep"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "8"}], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      FractionBox[
       RowBox[{"7", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "6"], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["\[Pi]", "3"]}], "4"], "-", 
      RowBox[{"C", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "+", 
      RowBox[{"C", "[", 
       RowBox[{"3", ",", "2"}], "]"}], "+", 
      FractionBox[
       RowBox[{"7", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}], "3"]}], ")"}], " ", 
    SuperscriptBox["ep", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "ep", "]"}], "3"],
    SeriesData[$CellContext`ep, 0, {}, -1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`ep, 
   0, {-1 + C[0, 2], -2 + Complex[0, -1] Pi - C[0, 2] + C[1, 2], 
    Rational[-3, 4] (48 + Complex[0, 24] Pi - 7 Pi^2) + 
    Rational[-2, 3] (-48 + Complex[0, -24] Pi + 7 Pi^2) - C[1, 2] + 
    C[2, 2], -8 + Complex[0, -4] Pi + Rational[7, 6] Pi^2 + Complex[0, 
       Rational[1, 4]] Pi^3 - C[2, 2] + C[3, 2] + Rational[7, 3] Zeta[3]}, -1,
    3, 1],
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cvalues2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Iseries", "[", 
              RowBox[{"[", "2", "]"}], "]"}], 
             RowBox[{"ep", "^", "k0"}]}], "-", "knownI2nomassseries"}], "/.", 
           
           RowBox[{"m2", "\[Rule]", "0"}]}], "/.", 
          RowBox[{
           RowBox[{"G", "[", 
            RowBox[{"___", ",", "0"}], "]"}], "\[Rule]", "0"}]}], "/.", 
         "cvalues1"}], "//", "\[IndentingNewLine]", "Normal"}], "//", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Collect", "[", 
         RowBox[{"#", ",", 
          RowBox[{"ep", "|", "_G"}], ",", "COEF"}], "]"}], "&"}]}], "//", 
      "\[IndentingNewLine]", "Expand"}], "//", "\[IndentingNewLine]", 
     RowBox[{"CaseUnion", "[", 
      RowBox[{
       RowBox[{"COEF", "[", "ex_", "]"}], "\[RuleDelayed]", 
       RowBox[{"ex", "\[Equal]", "0"}]}], "]"}]}], "//", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"#", ",", 
       RowBox[{"#", "//", 
        RowBox[{"CaseUnion", "[", "_C", "]"}]}]}], "]"}], "&"}]}], "//", 
   "\[IndentingNewLine]", "First"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "2"}], "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", "\[Pi]"}], ")"}]}]}],
    ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{"84", "+", 
       RowBox[{"36", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"3", ",", "2"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "12"]}], " ", "\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"180", " ", "\[ImaginaryI]"}], "-", 
       RowBox[{"84", " ", "\[Pi]"}], "-", 
       RowBox[{"21", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[Pi]", "3"]}], "-", 
       RowBox[{"28", " ", "\[ImaginaryI]", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cvalues", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"cvalues1", ",", "cvalues2"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"2", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "84"}], "-", 
       SuperscriptBox["\[Pi]", "2"]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"3", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "180"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"0", ",", "2"}], "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", "\[Pi]"}], ")"}]}]}],
    ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{"84", "+", 
       RowBox[{"36", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"3", ",", "2"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "12"]}], " ", "\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"180", " ", "\[ImaginaryI]"}], "-", 
       RowBox[{"84", " ", "\[Pi]"}], "-", 
       RowBox[{"21", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[Pi]", "3"]}], "-", 
       RowBox[{"28", " ", "\[ImaginaryI]", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Iseries", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "*", 
    RowBox[{"ep", "^", "k0"}]}], "/.", "cvalues"}], "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "ep"], "+", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "m2", " ", "\[Pi]"}], "-", 
     RowBox[{"m2", " ", 
      RowBox[{"G", "[", 
       RowBox[{"0", ",", "m2"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
      RowBox[{"G", "[", 
       RowBox[{"1", ",", "m2"}], "]"}]}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "m2", " ", "\[Pi]"}], "-", 
      FractionBox[
       RowBox[{"7", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "12"], "+", 
      FractionBox[
       RowBox[{"2", " ", "m2", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "3"], "-", 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}], " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"G", "[", 
       RowBox[{"1", ",", "0", ",", "m2"}], "]"}], "+", 
      RowBox[{"m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "0", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "m2"}], "]"}]}]}], ")"}], " ", "ep"}], 
   "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"8", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "m2", " ", "\[Pi]"}], "-", 
      FractionBox[
       RowBox[{"7", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "6"], "+", 
      FractionBox[
       RowBox[{"4", " ", "m2", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "3"], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["\[Pi]", "3"]}], "4"], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "m2", " ", 
       SuperscriptBox["\[Pi]", "3"]}], "-", 
      RowBox[{
       FractionBox["1", "12"], " ", "m2", " ", 
       RowBox[{"(", 
        RowBox[{"48", "+", 
         SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "16"}], "-", 
         RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["\[Pi]", "2"]}]}], ")"}], " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "0", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "0", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"4", " ", "m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "m2", " ", "\[Pi]", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"0", ",", "0", ",", "0", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"G", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", "m2"}], "]"}], "-", 
      RowBox[{"m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "0", ",", "0", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "0", ",", "m2"}], "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "1", ",", "m2"}], "]"}]}], "+", 
      RowBox[{"4", " ", "m2", " ", 
       RowBox[{"G", "[", 
        RowBox[{"1", ",", "1", ",", "1", ",", "m2"}], "]"}]}], "-", 
      FractionBox[
       RowBox[{"7", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}], "3"], "+", 
      RowBox[{"2", " ", "m2", " ", 
       RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["ep", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "ep", "]"}], "3"],
    SeriesData[$CellContext`ep, 0, {}, -1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`ep, 0, {
   1, 2 + Complex[0, 1] Pi + 
    Complex[0, -1] $CellContext`m2 Pi - $CellContext`m2 $CellContext`G[
     0, $CellContext`m2] + (-1 + $CellContext`m2) $CellContext`G[
      1, $CellContext`m2], 4 + Complex[0, 2] Pi + 
    Complex[0, -2] $CellContext`m2 Pi + Rational[-7, 12] Pi^2 + 
    Rational[2, 3] $CellContext`m2 Pi^2 - 
    2 $CellContext`m2 $CellContext`G[0, $CellContext`m2] + 
    2 (-1 + $CellContext`m2) (1 + Complex[0, 1] Pi) $CellContext`G[
      1, $CellContext`m2] + $CellContext`m2 $CellContext`G[
      0, 0, $CellContext`m2] - $CellContext`G[
    1, 0, $CellContext`m2] + $CellContext`m2 $CellContext`G[
      1, 0, $CellContext`m2] + 2 $CellContext`G[1, 1, $CellContext`m2] - 
    2 $CellContext`m2 $CellContext`G[1, 1, $CellContext`m2], 8 + 
    Complex[0, 4] Pi + Complex[0, -4] $CellContext`m2 Pi + 
    Rational[-7, 6] Pi^2 + Rational[4, 3] $CellContext`m2 Pi^2 + Complex[0, 
       Rational[-1, 4]] Pi^3 + Complex[0, 
       Rational[1, 4]] $CellContext`m2 Pi^3 + 
    Rational[-1, 12] $CellContext`m2 (48 + Pi^2) $CellContext`G[
      0, $CellContext`m2] + 
    Rational[-1, 4] (-1 + $CellContext`m2) (-16 + Complex[0, -16] Pi + 
      5 Pi^2) $CellContext`G[1, $CellContext`m2] + 
    2 $CellContext`m2 $CellContext`G[0, 0, $CellContext`m2] - 
    2 $CellContext`G[1, 0, $CellContext`m2] + 
    2 $CellContext`m2 $CellContext`G[1, 0, $CellContext`m2] + 
    4 $CellContext`G[1, 1, $CellContext`m2] - 
    4 $CellContext`m2 $CellContext`G[1, 1, $CellContext`m2] + 
    Complex[0, 4] Pi $CellContext`G[1, 1, $CellContext`m2] + 
    Complex[0, -4] $CellContext`m2 
     Pi $CellContext`G[
      1, 1, $CellContext`m2] - $CellContext`m2 $CellContext`G[
     0, 0, 0, $CellContext`m2] + $CellContext`G[
     1, 0, 0, $CellContext`m2] - $CellContext`m2 $CellContext`G[
     1, 0, 0, $CellContext`m2] + 2 $CellContext`G[1, 1, 0, $CellContext`m2] - 
    2 $CellContext`m2 $CellContext`G[1, 1, 0, $CellContext`m2] - 
    4 $CellContext`G[1, 1, 1, $CellContext`m2] + 
    4 $CellContext`m2 $CellContext`G[1, 1, 1, $CellContext`m2] + 
    Rational[-7, 3] Zeta[3] + 2 $CellContext`m2 Zeta[3]}, -1, 3, 1],
  Editable->False]], "Output"]
}, Open  ]]
}, Closed]]
},
WindowSize->{1920, 1129},
WindowMargins->{{0, Automatic}, {0, Automatic}},
Magnification:>1.25 Inherited,
FrontEndVersion->"10.1 for Linux x86 (64-bit) (March 23, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3826805898-1669308"->{
  Cell[8809, 279, 943, 13, 124, "Print",
   CellTags->"Info3826805898-1669308"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3826805898-1669308", 120148, 3464}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 182, 4, 39, "Input"],
Cell[CellGroupData[{
Cell[765, 28, 100, 1, 52, "Subsection"],
Cell[CellGroupData[{
Cell[890, 33, 111, 2, 39, "Input"],
Cell[1004, 37, 1599, 38, 174, "Print"]
}, Open  ]],
Cell[2618, 78, 136, 3, 39, "Input"],
Cell[2757, 83, 297, 9, 39, "Input"],
Cell[3057, 94, 182, 5, 39, "Input"],
Cell[CellGroupData[{
Cell[3264, 103, 346, 10, 39, "Input"],
Cell[3613, 115, 321, 4, 150, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3971, 124, 142, 3, 39, "Input"],
Cell[4116, 129, 216, 2, 78, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4369, 136, 145, 3, 39, "Input"],
Cell[4517, 141, 494, 6, 174, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5048, 152, 145, 3, 39, "Input"],
Cell[5196, 157, 517, 6, 150, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5750, 168, 211, 5, 39, "Input"],
Cell[CellGroupData[{
Cell[5986, 177, 252, 7, 29, "Print"],
Cell[6241, 186, 204, 2, 102, "Print"],
Cell[6448, 190, 252, 7, 29, "Print"],
Cell[6703, 199, 204, 2, 102, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6956, 207, 145, 3, 39, "Input"],
Cell[7104, 212, 203, 6, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7344, 223, 311, 9, 39, "Input"],
Cell[7658, 234, 865, 30, 68, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8572, 270, 103, 1, 41, "Subsection"],
Cell[CellGroupData[{
Cell[8700, 275, 106, 2, 39, "Input"],
Cell[8809, 279, 943, 13, 124, "Print",
 CellTags->"Info3826805898-1669308"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9789, 297, 299, 9, 39, "Input"],
Cell[10091, 308, 865, 30, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10993, 343, 576, 17, 39, "Input"],
Cell[11572, 362, 638, 24, 67, "Output"]
}, Open  ]],
Cell[12225, 389, 265, 8, 39, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[12527, 402, 97, 1, 41, "Subsection"],
Cell[12627, 405, 183, 4, 41, "Text"],
Cell[CellGroupData[{
Cell[12835, 413, 207, 4, 39, "Input"],
Cell[13045, 419, 28, 0, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13110, 424, 453, 13, 94, "Input"],
Cell[13566, 439, 872, 28, 102, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14475, 472, 240, 6, 67, "Input"],
Cell[14718, 480, 1000, 32, 78, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15755, 517, 349, 11, 39, "Input"],
Cell[16107, 530, 872, 28, 102, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17028, 564, 133, 1, 41, "Subsection"],
Cell[CellGroupData[{
Cell[17186, 569, 794, 25, 94, "Input"],
Cell[17983, 596, 181, 6, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18201, 607, 151, 3, 39, "Input"],
Cell[18355, 612, 696, 24, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19088, 641, 151, 3, 39, "Input"],
Cell[19242, 646, 1515, 48, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20794, 699, 151, 3, 39, "Input"],
Cell[20948, 704, 3875, 113, 229, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24860, 822, 151, 3, 39, "Input"],
Cell[25014, 827, 5863, 153, 377, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30926, 986, 126, 1, 41, "Subsection"],
Cell[31055, 989, 843, 24, 39, "Input"],
Cell[CellGroupData[{
Cell[31923, 1017, 156, 3, 39, "Input"],
Cell[32082, 1022, 98, 2, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32217, 1029, 198, 5, 39, "Input"],
Cell[32418, 1036, 131, 4, 57, "Output"]
}, Open  ]],
Cell[32564, 1043, 2004, 57, 256, "Input"],
Cell[CellGroupData[{
Cell[34593, 1104, 266, 7, 39, "Input"],
Cell[34862, 1113, 98, 2, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34997, 1120, 859, 27, 94, "Input"],
Cell[35859, 1149, 181, 6, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36077, 1160, 113, 2, 39, "Input"],
Cell[36193, 1164, 679, 23, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36909, 1192, 151, 3, 39, "Input"],
Cell[37063, 1197, 1414, 43, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38514, 1245, 151, 3, 39, "Input"],
Cell[38668, 1250, 2329, 68, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41034, 1323, 152, 3, 39, "Input"],
Cell[41189, 1328, 17589, 481, 408, "Output"]
}, Open  ]],
Cell[58793, 1812, 517, 16, 39, "Input"],
Cell[CellGroupData[{
Cell[59335, 1832, 163, 4, 39, "Input"],
Cell[59501, 1838, 8303, 203, 96, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67841, 2046, 303, 8, 67, "Input"],
Cell[68147, 2056, 23053, 515, 96, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[91249, 2577, 109, 1, 41, "Subsection"],
Cell[91361, 2580, 1371, 48, 67, "Input"],
Cell[92735, 2630, 66, 0, 41, "Text"],
Cell[92804, 2632, 433, 15, 39, "Input"],
Cell[CellGroupData[{
Cell[93262, 2651, 893, 28, 39, "Input"],
Cell[94158, 2681, 3204, 86, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97399, 2772, 687, 21, 39, "Input"],
Cell[98089, 2795, 1743, 50, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99869, 2850, 68, 2, 39, "Input"],
Cell[99940, 2854, 45, 1, 39, "Output"]
}, Open  ]],
Cell[100000, 2858, 237, 7, 39, "Input"],
Cell[CellGroupData[{
Cell[100262, 2869, 1011, 29, 203, "Input"],
Cell[101276, 2900, 902, 31, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102215, 2936, 344, 11, 39, "Input"],
Cell[102562, 2949, 1653, 50, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104252, 3004, 388, 13, 39, "Input"],
Cell[104643, 3019, 2409, 70, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107089, 3094, 1301, 38, 203, "Input"],
Cell[108393, 3134, 1317, 40, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109747, 3179, 124, 3, 39, "Input"],
Cell[109874, 3184, 2166, 69, 116, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112077, 3258, 203, 7, 39, "Input"],
Cell[112283, 3267, 7507, 182, 286, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)

