" Everything you need to have a REPL in your Vim.

" Vim-Plug plugin manager. Install from
"   https://github.com/junegunn/vim-plug
" Or just:
"   curl -fLo ~/.vim/autoload/plug.vim --create-dirs https://raw.githubusercontent.com/junegunn/vim-plug/master/plug.vim
" Then, in Vim:
"   :PlugInstall
call plug#begin('~/.vim/plugged')
Plug 'jpalardy/vim-slime'
call plug#end()

" Vim-Slime config
let g:slime_target = "vimterminal"
let g:slime_paste_file = "/tmp/.slime_paste"
let g:slime_python_ipython = 1
let g:slime_mma_paste_index = 0
function! _EscapeText_mma(text)
    let text = substitute(a:text, "\n*$", "", "")
    if count(text, "\n") >= 2
        let file = printf("/tmp/.slime.%c.m", 97 + g:slime_mma_paste_index)
        let g:slime_mma_paste_index = (g:slime_mma_paste_index + 1) % 26
        call writefile(split(a:text, "\n"), file, "b")
        return ["Get[\"" . file . "\"]\n"]
    else
        return [text . "\n"]
    endif
endfunction

" The main command is :Repl <command>
function! ReplV(args)
    let oldbuf = bufnr("%")
    exec "vert rightb term ++close " . a:args
    let g:slime_target = "vimterminal"
    call setbufvar(oldbuf, "slime_config", {"bufnr": bufnr("%")})
    exec ":vertical resize 65"
    exec ":wincmd p"
endfunction
function! ReplH(args)
    let oldbuf = bufnr("%")
    exec "rightb term ++close " . a:args
    let g:slime_target = "vimterminal"
    call setbufvar(oldbuf, "slime_config", {"bufnr": bufnr("%")})
    exec ":5wincmd -"
    "exec ":resize 55"
    exec ":wincmd p"
endfunction
command! -nargs=* Repl call ReplV(<q-args>)
command! -nargs=* ReplV call ReplV(<q-args>)
command! -nargs=* ReplH call ReplH(<q-args>)

" Repl interaction key bindings:
"   F1 to send the current paragraph (or selected text)
"   F2 to send the current word
xmap <F1> <Plug>SlimeRegionSend
nmap <F1> <Plug>SlimeParagraphSend
nmap <F2> vaw<F1>
