(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   3333849,      58847]
NotebookOptionsPosition[   3331118,      58765]
NotebookOutlinePosition[   3331488,      58781]
CellTagsIndexPosition[   3331445,      58778]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825907859754035*^9, 3.825907867711714*^9}}],

Cell[CellGroupData[{

Cell["Mathematica graphs", "Subsection",
 CellChangeTimes->{{3.825904199347887*^9, 3.825904202987825*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"v1", "<->", "v2"}], ",", 
    RowBox[{"v2", "<->", "v3"}], ",", 
    RowBox[{"v3", "<->", "v1"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.825904205017929*^9, 3.825904315590094*^9}, {
  3.8259043607415752`*^9, 3.825904399301776*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`v1, $CellContext`v2, $CellContext`v3}, {
      Null, {{1, 2}, {2, 3}, {3, 1}}}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{-0.8660254037844384, -0.4999999999999994}, {
       0.8660254037844389, -0.5000000000000012}, {1.8369701987210297`*^-16, 
       1.}}, {
        {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
         {Arrowheads[0.], ArrowBox[{1, 2}, 0.020399597244776385`]}, 
         {Arrowheads[0.], ArrowBox[{1, 3}, 0.020399597244776385`]}, 
         {Arrowheads[0.], ArrowBox[{2, 3}, 0.020399597244776385`]}}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         DiskBox[1, 0.020399597244776385`], DiskBox[2, 0.020399597244776385`],
          DiskBox[3, 0.020399597244776385`]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.825904300542637*^9, 3.825904315974165*^9}, {
   3.825904395549996*^9, 3.8259044000113363`*^9}, 3.825905360476219*^9, 
   3.825905527627139*^9, 3.8259078726562843`*^9, 3.825908030983214*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{
      RowBox[{"v1", "<->", "v2"}], ",", "\"\<One\>\""}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{
      RowBox[{"v2", "<->", "v3"}], ",", "\"\<Two\>\""}], "]"}], ",", 
    RowBox[{"v3", "<->", "v1"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.825904404685588*^9, 3.825904435557773*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`v1, $CellContext`v2, $CellContext`v3}, {
      Null, {{1, 2}, {2, 3}, {3, 1}}}, {
      EdgeLabels -> {
        UndirectedEdge[$CellContext`v2, $CellContext`v3] -> "Two", 
         UndirectedEdge[$CellContext`v1, $CellContext`v2] -> "One"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844384, -0.4999999999999994}, {
           0.8660254037844389, -0.5000000000000012}}, 0.020399597244776385`]},
          InsetBox["\<\"One\"\>", {2.7755575615628914`*^-16, -0.5000000000000003},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, 
        {Arrowheads[0.], 
         ArrowBox[{{-0.8660254037844384, -0.4999999999999994}, {
          1.8369701987210297`*^-16, 1.}}, 0.020399597244776385`]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.8660254037844389, -0.5000000000000012}, {
           1.8369701987210297`*^-16, 1.}}, 0.020399597244776385`]}, 
         InsetBox["\<\"Two\"\>", {0.4330127018922196, 0.2499999999999994}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
        DiskBox[{-0.8660254037844384, -0.4999999999999994}, 
         0.020399597244776385`], 
        DiskBox[{0.8660254037844389, -0.5000000000000012}, 
         0.020399597244776385`], 
        DiskBox[{1.8369701987210297`*^-16, 1.}, 0.020399597244776385`]}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.825904417804874*^9, 3.825904436281807*^9}, 
   3.8259053606046877`*^9, 3.825905527652051*^9, 3.825907872676633*^9, 
   3.825908031009942*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{
      RowBox[{"v1", "<->", "v2"}], ",", "\"\<One\>\""}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{
      RowBox[{"v1", "<->", "v2"}], ",", "\"\<Two\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8259043312530537`*^9, 3.825904348558079*^9}, {
  3.825904448791284*^9, 3.825904455741893*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`v1, $CellContext`v2}, {Null, {{1, 2}, {1, 2}}}, {
      EdgeLabels -> {
        UndirectedEdge[$CellContext`v1, $CellContext`v2] -> "One"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{1., 0.}, {
           0.5000000000000009, -0.1644407471831162}, {0., 
           1.2246467991473532`*^-16}}], 0.01273]}, 
         InsetBox["\<\"One\"\>", {0.5000000000000001, -0.07}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{1., 0.}, {0.5000000000000004, 
           0.16444074718311671`}, {0., 1.2246467991473532`*^-16}}], 0.01273]},
          InsetBox["\<\"One\"\>", {0.5000000000000001, 0.07000000000000012}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
        DiskBox[{1., 0.}, 0.01273], 
        DiskBox[{0., 1.2246467991473532`*^-16}, 0.01273]}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.825904349671589*^9, 3.8259044563473587`*^9, 
  3.8259053607795267`*^9, 3.8259055276694603`*^9, 3.8259078726953*^9, 
  3.825908031033*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematica graphs from diagrams", "Subsection",
 CellChangeTimes->{{3.8259041836277742`*^9, 3.825904189899962*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"diagrams", "=", 
   RowBox[{"Get", "[", "\"\<dia-A-A-2.m\>\"", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8259041563484373`*^9, 3.825904166348487*^9}, 
   3.82590534154685*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DiagramGraphEdges", "[", 
    RowBox[{"Diagram", "[", 
     RowBox[{
     "_", ",", "_", ",", "i_List", ",", "o_List", ",", "p_List", ",", "_"}], 
     "]"}], "]"}], ":=", 
   RowBox[{"Join", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "/.", 
      RowBox[{
       RowBox[{"P", "[", 
        RowBox[{
        "f_", ",", "fi1_", ",", "fi2_", ",", "vi1_", ",", "vi2_", ",", 
         "mom_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"II", "[", "vi1", "]"}], "\[UndirectedEdge]", 
        RowBox[{"II", "[", "vi2", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"i", "/.", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{"f_", ",", "fi_", ",", "vi_", ",", "mom_"}], "]"}], 
       "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"SS", "[", "fi", "]"}], "\[UndirectedEdge]", 
        RowBox[{"II", "[", "vi", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"o", "/.", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{"f_", ",", "fi_", ",", "vi_", ",", "mom_"}], "]"}], 
       "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"II", "[", "vi", "]"}], "\[UndirectedEdge]", 
        RowBox[{"EE", "[", "fi", "]"}]}]}]}]}], "]"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DiagramGraph", "[", "d_Diagram", "]"}], ":=", 
  RowBox[{
   RowBox[{"DiagramGraphEdges", "[", "d", "]"}], "//", "Graph"}]}]}], "Input",\

 CellChangeTimes->{{3.8259041694615307`*^9, 3.825904170172332*^9}, {
  3.8259044886545687`*^9, 3.825904490797758*^9}, {3.825904535827594*^9, 
  3.8259045499343643`*^9}, {3.825907961064188*^9, 3.825907971512185*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DiagramGraphEdges", "[", 
  RowBox[{"diagrams", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DiagramGraph", "[", 
  RowBox[{"diagrams", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.825904552472332*^9, 3.82590459764664*^9}, {
  3.82590464119096*^9, 3.825904675014852*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"II", "[", "3", "]"}], "\[UndirectedEdge]", 
    RowBox[{"II", "[", "1", "]"}]}], ",", 
   RowBox[{
    RowBox[{"II", "[", "1", "]"}], "\[UndirectedEdge]", 
    RowBox[{"II", "[", "4", "]"}]}], ",", 
   RowBox[{
    RowBox[{"II", "[", "2", "]"}], "\[UndirectedEdge]", 
    RowBox[{"II", "[", "3", "]"}]}], ",", 
   RowBox[{
    RowBox[{"II", "[", "4", "]"}], "\[UndirectedEdge]", 
    RowBox[{"II", "[", "2", "]"}]}], ",", 
   RowBox[{
    RowBox[{"II", "[", "4", "]"}], "\[UndirectedEdge]", 
    RowBox[{"II", "[", "3", "]"}]}], ",", 
   RowBox[{
    RowBox[{"SS", "[", 
     RowBox[{"-", "1"}], "]"}], "\[UndirectedEdge]", 
    RowBox[{"II", "[", "1", "]"}]}], ",", 
   RowBox[{
    RowBox[{"II", "[", "2", "]"}], "\[UndirectedEdge]", 
    RowBox[{"EE", "[", 
     RowBox[{"-", "2"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8259045606672897`*^9, 3.82590459848248*^9}, {
   3.825904631421455*^9, 3.825904676263085*^9}, 3.82590536099571*^9, 
   3.825905527796417*^9, 3.825907872998806*^9, 3.82590803106133*^9}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
       $CellContext`II[3], 
       $CellContext`II[1], 
       $CellContext`II[4], 
       $CellContext`II[2], 
       $CellContext`SS[-1], 
       $CellContext`EE[-2]}, {
      Null, {{1, 2}, {2, 3}, {4, 1}, {3, 4}, {3, 1}, {5, 2}, {4, 6}}}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{2.05692530080174, 0.}, {1.080240837460165, 
       0.3263968203821309}, {2.0566166088267357`, 0.6526593268900065}, {
       3.033140300619724, 0.326597136223013}, {0., 0.3269659634495179}, {
       4.113572727629652, 0.326919828949017}}, {
        {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
         {Arrowheads[0.], ArrowBox[{1, 2}, 0.037726059753419916`]}, 
         {Arrowheads[0.], ArrowBox[{1, 3}, 0.037726059753419916`]}, 
         {Arrowheads[0.], ArrowBox[{1, 4}, 0.037726059753419916`]}, 
         {Arrowheads[0.], ArrowBox[{2, 3}, 0.037726059753419916`]}, 
         {Arrowheads[0.], ArrowBox[{2, 5}, 0.037726059753419916`]}, 
         {Arrowheads[0.], ArrowBox[{3, 4}, 0.037726059753419916`]}, 
         {Arrowheads[0.], ArrowBox[{4, 6}, 0.037726059753419916`]}}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         DiskBox[1, 0.037726059753419916`], DiskBox[2, 0.037726059753419916`],
          DiskBox[3, 0.037726059753419916`], 
         DiskBox[4, 0.037726059753419916`], DiskBox[5, 0.037726059753419916`],
          DiskBox[6, 0.037726059753419916`]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.8259045606672897`*^9, 3.82590459848248*^9}, {
   3.825904631421455*^9, 3.825904676263085*^9}, 3.82590536099571*^9, 
   3.825905527796417*^9, 3.825907872998806*^9, 3.825908031072353*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphviz graphs from diagrams", "Subsection",
 CellChangeTimes->{{3.82590471002243*^9, 3.8259047186064587`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Flatten", ",", "join", ",", 
    RowBox[{
    "and", " ", "convert", " ", "the", " ", "arguments", " ", "to", " ", "a", 
     " ", 
     RowBox[{"string", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MkString", "[", "args__", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"args", "//", "List"}], "//", "Flatten"}], "//", 
      RowBox[{"Map", "[", "ToString", "]"}]}], "//", "StringJoin"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Return", " ", "a", " ", "name", " ", "of", " ", "an", " ", "unexisting", 
     " ", "temporary", " ", "file"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MkTemp", "[", 
     RowBox[{"prefix_", ",", "suffix_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "fn", ",", "alphabet"}], "}"}], ",", 
      RowBox[{
       RowBox[{"alphabet", "=", 
        RowBox[{
        "Characters", "[", "\"\<abcdefghijklmnopqrstuvwxyz0123456789\>\"", 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"While", "[", 
        RowBox[{"True", ",", 
         RowBox[{
          RowBox[{"i", "=", 
           RowBox[{"RandomSample", "[", 
            RowBox[{"alphabet", ",", "8"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"fn", "=", 
           RowBox[{"FileNameJoin", "[", 
            RowBox[{"{", 
             RowBox[{"$TemporaryDirectory", ",", 
              RowBox[{"MkString", "[", 
               RowBox[{"prefix", ",", "\"\<.\>\"", ",", 
                RowBox[{"Environment", "[", "\"\<USER\>\"", "]"}], ",", 
                "\"\<.\>\"", ",", "$ProcessID", ",", "\"\<.\>\"", ",", "i", 
                ",", "suffix"}], "]"}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Not", "[", 
             RowBox[{"FileExistsQ", "[", "fn", "]"}], "]"}], ",", 
            RowBox[{"Return", "[", "fn", "]"}]}], "]"}], ";"}]}], "]"}]}]}], 
     "]"}]}], "\n", "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
    "Produce", " ", "Graphviz", " ", "code", " ", "string", " ", "for", " ", 
     "a", " ", 
     RowBox[{"diagram", "."}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DiagramToGraphviz", "[", 
     RowBox[{"Diagram", "[", 
      RowBox[{
      "id_", ",", "_", ",", "i_List", ",", "o_List", ",", "p_List", ",", 
       "_"}], "]"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "defc"}], "}"}], ",", 
      RowBox[{
       RowBox[{"c", "=", 
        RowBox[{"<|", 
         RowBox[{
          RowBox[{"\"\<q\>\"", "\[Rule]", "6"}], ",", 
          RowBox[{"\"\<Q\>\"", "\[Rule]", "6"}], ",", 
          RowBox[{"\"\<t\>\"", "\[Rule]", "6"}], ",", 
          RowBox[{"\"\<T\>\"", "\[Rule]", "6"}], ",", 
          RowBox[{"\"\<g\>\"", "\[Rule]", "4"}], ",", 
          RowBox[{"\"\<c\>\"", "\[Rule]", "8"}], ",", 
          RowBox[{"\"\<C\>\"", "\[Rule]", "8"}], ",", 
          RowBox[{"\"\<O\>\"", "\[Rule]", "10"}], ",", 
          RowBox[{"\"\<H\>\"", "\[Rule]", "10"}], ",", 
          RowBox[{"\"\<A\>\"", "\[Rule]", "10"}], ",", 
          RowBox[{"\"\<Z\>\"", "\[Rule]", "10"}], ",", 
          RowBox[{"\"\<s\>\"", "\[Rule]", "10"}], ",", 
          RowBox[{"\"\<S\>\"", "\[Rule]", "10"}]}], "|>"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"defc", "=", "12"}], ";", "\[IndentingNewLine]", 
       RowBox[{"MkString", "[", 
        RowBox[{
        "\"\<digraph {\\n\>\"", ",", "\"\< fontsize=12; margin=0;\\n\>\"", 
         ",", "\"\< node [shape=circle width=0.1 color=black];\\n\>\"", ",", 
         "\"\< edge [fontsize=8; colorscheme=paired12];\\n\>\"", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"i", "/.", 
            RowBox[{
             RowBox[{"F", "[", 
              RowBox[{"f_", ",", "fi_", ",", "vi_", ",", "mom_"}], "]"}], 
             "\[RuleDelayed]", "fi"}]}], "//", "Union"}], "//", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "\"\< \>\"", ",", "#", ",", 
              "\"\< [width=0.05 color=gray];\\n\>\""}], "}"}], "&"}], "]"}]}],
          ",", 
         RowBox[{
          RowBox[{
           RowBox[{"o", "/.", 
            RowBox[{
             RowBox[{"F", "[", 
              RowBox[{"f_", ",", "fi_", ",", "vi_", ",", "mom_"}], "]"}], 
             "\[RuleDelayed]", "fi"}]}], "//", "Union"}], "//", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "\"\< \>\"", ",", "#", ",", 
              "\"\< [width=0.05 color=gray];\\n\>\""}], "}"}], "&"}], "]"}]}],
          ",", 
         RowBox[{"i", "/.", 
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{"f_", ",", "fi_", ",", "vi_", ",", "mom_"}], "]"}], 
           "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{
            "\"\< \>\"", ",", "fi", ",", "\"\< -> \>\"", ",", "vi", ",", 
             "\"\< [label=\\\"\>\"", ",", "f", ",", "\"\<(\>\"", ",", 
             RowBox[{
              RowBox[{"mom", "//", "ToString"}], "//", 
              RowBox[{"StringReplace", "[", 
               RowBox[{"\"\< \>\"", "\[Rule]", "\"\<\>\""}], "]"}]}], ",", 
             "\"\<)\\\",color=\>\"", ",", 
             RowBox[{
              RowBox[{"Lookup", "[", 
               RowBox[{"c", ",", "f", ",", "defc"}], "]"}], "-", "1"}], ",", 
             "\"\<];\\n\>\""}], "}"}]}]}], ",", 
         RowBox[{"p", "/.", 
          RowBox[{
           RowBox[{"P", "[", 
            RowBox[{
            "f_", ",", "fi1_", ",", "fi2_", ",", "vi1_", ",", "vi2_", ",", 
             "mom_"}], "]"}], "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{
            "\"\< \>\"", ",", "vi1", ",", "\"\< -> \>\"", ",", "vi2", ",", 
             "\"\< [label=\\\"\>\"", ",", "f", ",", "\"\<(\>\"", ",", 
             RowBox[{
              RowBox[{"mom", "//", "ToString"}], "//", 
              RowBox[{"StringReplace", "[", 
               RowBox[{"\"\< \>\"", "\[Rule]", "\"\<\>\""}], "]"}]}], ",", 
             "\"\<)\\\",color=\>\"", ",", 
             RowBox[{"Lookup", "[", 
              RowBox[{"c", ",", "f", ",", "defc"}], "]"}], ",", 
             "\"\<,style=bold];\\n\>\""}], "}"}]}]}], ",", 
         RowBox[{"o", "/.", 
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{"f_", ",", "fi_", ",", "vi_", ",", "mom_"}], "]"}], 
           "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{
            "\"\< \>\"", ",", "vi", ",", "\"\< -> \>\"", ",", "fi", ",", 
             "\"\< [label=\\\"\>\"", ",", "f", ",", "\"\<(\>\"", ",", 
             RowBox[{
              RowBox[{"mom", "//", "ToString"}], "//", 
              RowBox[{"StringReplace", "[", 
               RowBox[{"\"\< \>\"", "\[Rule]", "\"\<\>\""}], "]"}]}], ",", 
             "\"\<)\\\",color=\>\"", ",", 
             RowBox[{
              RowBox[{"Lookup", "[", 
               RowBox[{"c", ",", "f", ",", "defc"}], "]"}], "-", "1"}], ",", 
             "\"\<];\\n\>\""}], "}"}]}]}], ",", "\"\<}\\n\>\""}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{"Use", " ", "Graphviz", " ", "to", " ", "turn", " ", "a", " ", 
     RowBox[{"Diagram", "[", "]"}], " ", "object", " ", "into", " ", "a", " ",
      "pretty", " ", 
     RowBox[{"Graphics", "[", "]"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DiagramViz", "[", 
     RowBox[{"d", ":", 
      RowBox[{"(", 
       RowBox[{"_Diagram", "|", "_CutDiagram"}], ")"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tmp", ",", "pdf", ",", "result"}], "}"}], ",", 
      RowBox[{
       RowBox[{"tmp", "=", 
        RowBox[{"MkTemp", "[", 
         RowBox[{"\"\<diavis\>\"", ",", "\"\<.gv\>\""}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"pdf", "=", 
        RowBox[{"tmp", "<>", "\"\<.pdf\>\""}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Export", "[", 
        RowBox[{"tmp", ",", 
         RowBox[{"DiagramToGraphviz", "[", "d", "]"}], ",", 
         "\"\<String\>\""}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Run", "[", 
        RowBox[{"\"\<neato -Tpdf -o\>\"", ",", "pdf", ",", "tmp"}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"result", "=", 
        RowBox[{"Import", "[", "pdf", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"DeleteFile", "[", 
        RowBox[{"{", 
         RowBox[{"tmp", ",", "pdf"}], "}"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"result", "//", "First"}]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8259047031141243`*^9, 3.8259047851118717`*^9}, {
  3.825904818122898*^9, 3.82590493222676*^9}, {3.825908004643018*^9, 
  3.825908011418668*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DiagramToGraphviz", "[", 
  RowBox[{"diagrams", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DiagramViz", "[", 
  RowBox[{"diagrams", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.825904933743003*^9, 3.8259049399603577`*^9}, {
  3.82590550923207*^9, 3.825905513628104*^9}}],

Cell[BoxData["\<\"digraph {\\n fontsize=12; margin=0;\\n node [shape=circle \
width=0.1 color=black];\\n edge [fontsize=8; colorscheme=paired12];\\n -1 \
[width=0.05 color=gray];\\n -2 [width=0.05 color=gray];\\n -1 -> 1 \
[label=\\\"A(q)\\\",color=9];\\n 3 -> 1 \
[label=\\\"q(-l1)\\\",color=6,style=bold];\\n 1 -> 4 \
[label=\\\"q(-l1+q)\\\",color=6,style=bold];\\n 2 -> 3 \
[label=\\\"q(l2)\\\",color=6,style=bold];\\n 4 -> 2 \
[label=\\\"q(l2+q)\\\",color=6,style=bold];\\n 4 -> 3 \
[label=\\\"g(-l1-l2)\\\",color=4,style=bold];\\n 2 -> -2 \
[label=\\\"A(q)\\\",color=9];\\n}\\n\"\>"], "Output",
 CellChangeTimes->{
  3.825904940875581*^9, 3.825905361598217*^9, {3.825905515070423*^9, 
   3.8259055278869867`*^9}, 3.825907873157694*^9, 3.825908031097084*^9}],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.0033003300330033004`], 
   {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 166.}, {
     303.367, 166.}, {303.367, 0.10899999999998045`}, {0., 
     0.10899999999998045`}}}]}, 
   {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
    Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
     24.617000000000004`}, {45.02, 13.289}, {35.836, 4.1049999999999995`}, {
     24.508, 4.1049999999999995`}, {13.176, 4.1049999999999995`}, {
     3.9919999999999995`, 13.289}, {3.9919999999999995`, 
     24.617000000000004`}, {3.9919999999999995`, 35.945}, {13.176, 
     45.129000000000005`}, {24.508, 45.129000000000005`}, {35.836, 
     45.129000000000005`}, {45.02, 35.945}, {45.02, 24.617000000000004`}}},
     CurveClosed->{0}]}, 
   {Thickness[0.0033003300330033004`], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     18.552508993125002`, 24.501156448750002`}, {21.99788154, 
     24.501156448750002`}, {21.99788154, 23.632703813125005`}, {
     18.552508993125002`, 23.632703813125005`}, {18.552508993125002`, 
     24.501156448750002`}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQXZ+egvmK+/bdca4cH
D018voUh+MyN2VWPPpvC+T+6hFlM5pk6NFQwsdk1Wzt8v7NtbWuKqcONs1Pe
x6yzdvB88M7gm7upg4Gy+s3qm9YOxfKfHxzSM3WY4PqEtcjMxiGv+uuFQwqm
DkfWnlladMjG4WNXjPt1GQT/5V5DFobXJg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcNcnpDntv6mDvfPXe8/qGDl4MMpk3I229RB
8DZbc6qllcOy9tsNh3ch+FuXJWh5mpjB+Xw//TIDemzg/OwF1jtl/9s48G26
6d8nauXwIfZ/6wMTWweOhPqX989awvkh+3fGBCxG8C8wfuvvzbV0kHNkdFur
aetQpW7SPF3H0uGNyaUgTkFbh0Wv08OsNS0dClwsT8ry2jr47mda8FnR0mEG
R+6cg5y2DgrhF/f4i1s6yEhcEbrGautwRiuHjUPA0sHlDvuzSiZbh+Nted/Y
mSzh7vuWWbDtyjcLB7GSa0zXvtvAw29Ws23lq882Du65Kyxdb1k4vOJeKm/0
1sZBirU8bOF5C4dcaZ5pbi8R/LlrstYcFLd1QE8vAOyw+t4=
     "]]}, 
   {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{107.836,
      56.074}, {107.836, 46.719}, {100.25, 39.133}, {90.895, 39.133}, {81.539,
      39.133}, {73.953, 46.719}, {73.953, 56.074}, {73.953, 
     65.43400000000001}, {81.539, 73.016}, {90.895, 73.016}, {100.25, 
     73.016}, {107.836, 65.43400000000001}, {107.836, 56.074}}},
     CurveClosed->{0}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4kscerbv94Y5qGmY/J/30s+B/aeOoM2RMIc/
ExlVfj9F8HsfylgXbvGC8zueffg/s9PLQW7tUaa+k2EO7f2HrhzK8XIocdLa
G3olzMFgYpxYdZyXw6nrfeWy98Mcjm5IyHsY6OWQpLCPKfpbmMOhe4lpD728
HPKtdmhFS4Y7tKRNXfjaA8FnAAEDL4eqAw9XfVYKw+DD1NtyOIuGOiLM+6x8
s443DGGf6fXF/s1JYQ5R6hM/yiV5OWxlsn76riDMYaPq1/VpBV4Oh46yPRIv
D3O4/yRk38PpCH5aifjkJVcQ/Elz+4xWMPjB+Y4fW27xWfk5NFZbiyrlhTkw
X3jm8CHEz4Hh+ZJqsxgE/3Jd8YxJgQh+Ub/TU0WXMIfZB58vCPP3c7gjIZT0
xDjMock6YDmLs5/DM877YbxAvsvh5kd8jn4OF/e5ZlobhjmEL5U9k2Dv53As
pbJgkl6Yg5RuIHu2rZ/DRskHTQd0whx0+V9/2GPt57B+w4M6B02E+6o1H64r
VgtzEI8O+p9l5gcPv5uPWq1KTfwcArTWn/eXB4bv8p28koZ+Di4XHl1bJgMM
T723Hsr6CH5UucyVBDc/B/T0AgA2dvY8
     "]]}, 
   {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
    "Butt"], JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}}}, {{{43.352, 33.547}, {50.469, 36.918}, {
     58.676, 40.809}, {66.242, 44.395}}},
     CurveClosed->{0}]}, 
   {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], 
    Thickness[0.0033003300330033004`], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
    0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.824, 47.594}, {75.363, 
     48.715}, {67.824, 41.27}}}]}, 
   {Thickness[0.0033003300330033004`], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQbV0y+80zCz8HVY4/bWm3XRxgfEmnc7//n3Bx+CkZ
qXXM2BeDD1N//dOM3aF+vg6fFpR5x9xxcag9EMp4O9HXIcqx4VTBPReH7cWF
bRI5vg7fpfh6+x+7OHxU6+UOK/N1mPJltv+6Fy4OfQzS50qqfR0Y+G0Fvn1E
8K9+9pWT/4fgr2n4nlrN6+rQ2dbc41ji69DebvGeS8XVQWrW48M/03wdzq+Q
snzk7OqQavLrFa+tr0PJ+YUrtZa6Orz+MWv1ekMfOH/WTmWBpUw+Dl8W3lwf
pOvqkHSDbXL6H28HWVGDjG+yrg6685v8Y396O6zTmDB/nQCCfyv3aXwQK4Kf
2CsmsuSli8M1O7u5jwR84OER9dSq5LsdJh8WfratUr22Jd4YfJj6Rp3UqQ97
vOHhGdXN+9R2gbdD/G5xniVPXRymPTu4eN1ab4e5L05dEvnu4sB6OTHn2y5v
h5XrfsRWc7o6rCuS3VV9ydvh99v8n60Wrg6HdapOeHz2djjKu+2BXTMwvBy2
mTic8HEoTJ4kqlLl7hBtn8G88S6Cb6y+yG7vHV+HY1teb602dXUoDAll1Xvn
6+DW0aYwi8/VodqjpWPKH18H5ofWEt++ujhs+T2f9xKbn0Oy6Xrf629cHN6t
2z2JX9DPQatp8omZj1wcJl25Py9R0Q/uH/T0BgBd1yCG
      "], {{56.516927460000005`, 
      43.61787444875001}, {58.371984037500006`, 43.61787444875001}, {
      57.44445574875001, 45.82669181562501}, {56.516927460000005`, 
      43.61787444875001}}}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1HEAx+9hq27zMFN2WkaURXVZF87D6Yvf3Z/G/4ekVq5aGFJYnnOt
SKTi8li4Hlg2NvMwEpVMKlqdxbIMmae2bKJJrkS6V2frxefF5+X3YfuZuKAI
PofD4eqw18HTsZIUsqgtoBjiq4slSgZRt7UtBysoeCkLfqPnGFwtyanxTaaw
XjLPNKcMhmw0Qa+OU5i0Bj++7Mhgbe5G/wEfiiizsshlCwY/dinkfY4UecbH
xs5uZED5Lq7KnRQNTkL/kVk5UpNVC5ZmFOXKZx5G7+XQiNxiIv+wMJhUTReq
5CiotRqz+8Zik7EoVe267l3FGXyeRqb3Fs130+poGfavyibTf7MQVty17TaT
YUTNdeCaUFjlh8vEHwmE1ts6PCwpYpfTEpl6gtzW4M72fRRd47Zf8lUEJcrM
Q1ZeFELPmDuCVIJKr8bB7GCKuMoG36zTBBnd1x/6XqAIbQ/0fuJN9P1sjhXs
NrUhKB70S5pSUUgnTk21mhJ8DSu0PJlIMbEha37TDgJDRWBpn4KirWivc4SY
QN0rLD7sT/EyJ/TpO0+CX1WLOVwpxV+DFEYQQDA7+mal3J7i0bA4Lz+MYCyW
I+FuofC/OD9smk7QFWU4zplh4V60KJE2ENTVN/aLe1lotxrlqaYIXHzSetqa
WVxxq6r+JJTh9YRnh/QBC0Go0wtLVoabIlsJp4TFytyAQpm77rdOrHZq3657
QobTWiPkiLcrJUvtLCysjzTtqZVjoGagrpyn+8M9ejSEy+j3LBu8Ft1vziBo
0NlLaUdh4N6R4Cdi9PkuffiZ1OPB4H58kyY7gOL5ao27JIDB9MzyZ/vzFA7h
4/LmcAb///EfbsQhXQ==
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVj1yvErqwIcZlRH3BKvdnO4em7GjLxjAQ7V5/TX
3prj5lC0Qi269zQmPzR3989mCxc4XySPU1tY2cXhlofBrYVnAxy4q24tXyPi
4uAcZBm77WKAg2X6iYXNPC4Orvys//yvBjiYvDVICGB1cXi6NC6R416Ag37x
TDnZf84O7UnNmVFvAhyOMkyczvEDwQ8T+XjuwCtnhxyJn75/izD5vyxFbwv9
dnaouKd2M7kVYZ6Ukc/drRMDHNJCts2OYnFxeHU77v696QEOC9gvKczgc3F4
x6jVUjE3wOHWrrdLr0q4OHQV7XCaviDAYYvktK+GOgj+z0n3Wa95IPjl7sVK
hVyuDu7yVtd7OoHhcfxFh+11Fwez7hW5kXkBDkIK8xpm7nNxCPs6x9ogAMF/
cHHmBGkLBH+B9fOjq1QCHIK/vmywvezicHKdbZ2faICD1aGIqcZ/XBwi8y5K
5LIFOCj2H1+pqerqcNv/58vav/4OAivOsAdHIvhWMm0qb2ch+HNnH+qZ+NjV
4eu9+OvdnMDwTH+c/0PRzcHsnuCyP3IBDpL+n13MQtwcVs0Q9RU0Bdp3vvZe
ZrubQ0dh6L0F/gEOtWUnnvEucHMwv1/C9TkfwXdeumhqZBOC32wdmnBqaoDD
HaXFj3ZPdnNAT08AbO8UMw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3VW0w2n6ggAHS2nlA988XR1g/ENTn6T/kHWD8zus
J/PWJbo5PEs8Pnf1hACHrL6sBw7Nbg4Xf5vpVBQi+IcrbBkqohH819OPSzd5
BTj8PH+a/2ehm8Pj7ymmW20DHGpKU5vE/d0cbocz+b8wCHD4L/X/i6mOm0Ph
05/HL2sFODxw4p1q+scVzg9a8dBq134EvyCUK+P7XFcH+0sOmsm6AQ5Rs9dG
atW6OvBrtPd9MgxwWNsYdaowztXBdev1vGlmAQ5nGZr+r3NwdahZrR5sBbR/
X0ZojoeWq4OMU+O2T64BDltL1F4+lHZ1CPs6x9ogIMChpLREqpDN1eHoQxuW
itgAB6tDEVON/7g4nLfL7r6Xi+Dfmj1TyLUOwa+N2Cc1vSfAwZHv/b00dleH
Ny5xj+/NDHBo4l249rqMq4PSpXWHm+YFOLS3W7znUkGEd5zII7N0YwQfFh8A
cmy5Tw==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcx91dFFJujrjWUtf8OVLKzPn7xu9+P2Hc97pOXBJ2Z0aHyqz8
6cb6o5Uu0tyw2kS1ZCaTG7f+YFlR1gOyswrtanabks5WSvfIbT14PXhtnyfv
9/uzK6dIquTY2dmxrAitsK38PS808iwSRM1mzfe5URhdmv5V/F0CntoxwE1A
Ifwbl2XmEPhqxtc6QcHVf/FhF5cg7Fn9GJ1BoSJeW2jhE8xmpfDHSihU+/j2
+O8hGFRdb1NcpiATifqlgQQhzPFFx7sUnq65zNiFECSyBv5MDlNoFPTvzIwl
mGo2pUlZYhxUiU3lCQRGdcJwgtzml2aVVcMvbN5433Jylw+NnMEDn6VxBMHG
FAXnLI06syxKG0rg97U6smGAhsBH4zUXRFBas/qydY6GxE3tpvch2N2amiZn
MUjaPzV+YQfB60jndqMngw/uoS7RPIJ78clBBfsYRKRz7c32BObBxuitycx6
P+yypeSZQgZNLeZV3YoE7zktN8MqGGysvToyu4Egryi33lDAoHTz3iv+rgQ3
5vSJ2ccYdMkPOed5EsgybxsEKQw0+Qqu1psgKb843BDD4GLyknzIn+CU0+jC
iUAG12qOiLTWvlZ/r3T08Bg0O6QqtYkELvNLCbWfaLTnVpotGQRSxfRyaCeN
jx66khAlwa0H6e+2ldHwetVrKSmy3teO6N/G0uhri9NrzxDwLX780w42N/AX
nr8ZEa/75HJ3tXuqGFSH02P3HIJAWf2EzkShQWWuGooi+MF0euvqbHt238n2
/FlK4fCEqFcqJIgMF245l02t52viObD9CIVH7Er1uAdBxhdpxJMYCk70UVX5
JgKTZntwZACF///xH7xBGWM=
     "]]}, 
   {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
    Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[RGBColor[
    0., 0., 0.]], 
    JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{299.371,
      141.49200000000002`}, {299.371, 130.164}, {290.188, 120.98}, {
     278.85900000000004`, 120.98}, {267.53099999999995`, 120.98}, {258.348, 
     130.164}, {258.348, 141.49200000000002`}, {258.348, 152.824}, {
     267.53099999999995`, 162.008}, {278.85900000000004`, 162.008}, {290.188, 
     162.008}, {299.371, 152.824}, {299.371, 141.49200000000002`}}},
     CurveClosed->{0}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     272.904071993125, 141.37615644875}, {276.34944454, 141.37615644875}, {
     276.34944454, 140.507703813125}, {272.904071993125, 140.507703813125}, {
     272.904071993125, 141.37615644875}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1,
      3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4htRbu0vDhc65H6pXuNWluiw/8q63mnbCx32
mrcxJFgmOlzw79pZkYDJj0hpzXGzS3TQO70tPKyj0OHAUoG21MmJDlt7NudO
m13oEPfbRlV5T6JDxduNFWZLCx1q5mQeUniM4Pc9PplWyp4E57O1T+a2kEpy
SGXxOe63CKj+YOyaKs0kB3ujhpT6OYUOsX/6YrVNkxzOT3nOvXxaocPKBWrK
pxySHO45+W/k6y90OF/0qXWmW5LDtMxX2rdaEfy5HTskmOsQ/E3JbVb7ywsd
9r3eLzDHKcnhyq/giXzFhQ4/NPpOClolOaw5FvIpJK/QwSgtpqndMMnhXKyS
55LMQofAQ9pnw5SSHNbu2JOkmVrooCVw8lI0T5JDr3B4zTpgeOx69Nt1Jl+S
w4rusGdXkgsdmt4d1jivleTQ9qWjvzWj0GFKaK/pD7skh0LJ3bkngeZ/ddn3
IsMnyeGNgMJ+L6B72r63f74Yl+TgtKylUqip0OGYY/CB4+lJDnPYZEpc+hF8
o7IG/TezEPy/qRKfTy0pdOhWeZevlpDk8M3Ni23RmkIH0VfK5x8HAP3z2uPO
ui2FDsZunyU3OyY5eFVVt9TvKHRQ55nQeU8PwWeI0u1/LIHgC9XM9Lz3LdHB
5a6njej6QofWtfPl5S4lOuyV9lW7CozfxPs8bGdWJjosWd7GqlNW6LBaVMot
NTrRQTPV69K71Qg+f6yYyb0NCP579RrJSqB7Njg1HNoZk+hgs6/a/822Qgc3
J8lN3gmJDpMei9jN2wk0f5eETFFyokOW/MOsX3sKHcTjxT/VZSc6HC18cJXh
YKHD32Pr5FsqEh3Q0y8A/fZGhw==
     "]]}, 
   {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{182.707,
      52.992000000000004`}, {182.707, 43.637}, {175.125, 
     36.050999999999995`}, {165.766, 36.050999999999995`}, {156.41, 
     36.050999999999995`}, {148.824, 43.637}, {148.824, 
     52.992000000000004`}, {148.824, 62.348}, {156.41, 69.93400000000001}, {
     165.766, 69.93400000000001}, {175.125, 69.93400000000001}, {182.707, 
     62.348}, {182.707, 52.992000000000004`}}},
     CurveClosed->{0}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{168.35886490874998`, 
      52.52615034875001}, {168.35886490874998`, 51.629259717500005`}, {
      166.94571527999997`, 51.629259717500005`}, {166.94571527999997`, 
      49.29296900000001}, {165.85194621749997`, 49.29296900000001}, {
      165.85194621749997`, 51.629259717500005`}, {161.91875266874996`, 
      51.629259717500005`}, {161.91875266874996`, 52.52615034875001}, {
      166.32882952874996`, 58.74313370000001}, {166.94571527999997`, 
      58.74313370000001}, {166.94571527999997`, 52.52615034875001}, {
      168.35886490874998`, 52.52615034875001}}, {{165.85194621749997`, 
      52.52615034875001}, {165.85194621749997`, 57.32779653312501}, {
      162.47876242874997`, 52.52615034875001}, {165.85194621749997`, 
      52.52615034875001}}}]}, 
   {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
    0.006600660066006601], Opacity[1.], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}}}, {{{107.887, 55.375}, {116.91400000000002`, 
     55.004}, {128.23399999999998`, 54.539}, {138.465, 54.117}}},
     CurveClosed->{0}]}, 
   {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[1.],
     Thickness[0.006600660066006601], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
    0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{138.738, 57.609}, {148.586, 
     53.699000000000005`}, {138.44899999999998`, 50.613}}}]}, 
   {Thickness[0.0033003300330033004`], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPU3rWdTkzbEOXVGFd6bf83RYcXmVtu75WIfctR7r
oxi8HFzXWrzzvoLJd/e58pt5jjucz+arpDu5zd1hja9TbsK1WIe/EZ9X6lS4
O4iGe38ouRXroO32cDFzgbuDhIj4RL57sQ5qZzyTLmS4O2xfVfDl2LNYB8Wg
TQpzE90dotKn/pH4Guuw/f7KmR3RCL7HZ86LDn7uDvay3A93V2Py30jo3Z0U
5+7g9dgiR6kPYd4bs7iCklmxDhHG5+feSnd32PugoGjugliHSc9eKUkUuTsc
YLMRN18W63BmJtuK0Bp3h5jyU1dDV8Y6LPux7vvGfgT/deEP9rA1CH6mWo/K
x1wPBykVnyzvScDwWMbYvdfKw4Fjwi4GifJYB5b/25oklTwcNH6tO/cuAsHf
dG218i0HBL/I4WdEpm6sg+sVpua9Zh4Oczb7C/LKxTroLCycvjnew0G7+PFq
bf5YB+G8B6tXdng4HFjD11HLHuvA1P6U8/IeBF/n9zy13H8Ifn/V7T5Bd0+H
448Ls7yEgOHp9qewotXTgeOxsuVu9VgHbj0e923bPR1q56o/OG8L1L9u2oOX
rzwdosvSC+OB7s0Pffiil9nLgfNJ29yNFQi+6KotGhLdCH6oQ/rnjnmxDucY
9zyx/u7pgJ6eANtqCrc=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHVN+6mroylgH7V/Wh8rWejjA+FtK/mZWNHrC+VVS
a/j/HfF02JF20yBrZqxDTG7zowPPPB2WMHjuN6tC8KfV+k82S0Hw9825uc4h
ONbh9bongpVXPR22/Sk7UewW65AXUtcyfZOnw9oYkUfLLGMdPv4U/76139PB
+RV39CTjWIdLimrTt8Yj+C7tv2yslBH8JBPlrHJGTweh60F7FM1iHXyqjkWv
euDh8FBnpuJGq1iH+QnFZz4e9HAQ3/WSMdQ+1mH//VmM+ks8HPw3WD774Rrr
sME9L+9Er4fDO7fJnhv9Yh2WB9u/Tqz3cND4te7cu4hYh7SQXpmPmR4O05/5
TTdLi3XQWVg4fXO8h8Mi51q5uWUI/poFq5cytyP4/rEX1oZOjXUwfsv+8FmW
h8M+z4KyuYtiHUre7Fwf3uDh8OXagTDH5bEOlWmBH7vaEeEd8PmXxfNpCD4s
PgCVisLe
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEcxt2KLohQO2TSHK3lVnNJK08Tv//5i6PM7GA/lxNKOx0dccwt
zMgYwzouaxwtl2TqdM5GpbnM5rJsNZfcM0utlFV4Qaj/K2frxfPi8+L7bN/n
eY7HSq/F6evo6OhyOsVJj5Nop1Y1n0sxvKhRdH5kUVa8XJ5XQLEWekAY+Y7F
sVJ1seFdCovxM/k1L1iQ0ImFy/EU+g8kHX+rWcx4u9ttR1KEr6tupueyGA+r
mx4Kobi3krTwLZGFnl/JmDKAosHSTRgRzKIqu+P5b1+KkogxlLqw6As3lig8
KHZ6Wj6brwpw4mhOk9yFYvOHf7pNnZbVybV78ly13NS2z8phhMFab0WL0p1i
f7rqpG86g6HyJKH4EoW5JIuoPRkkjG1b5jEU0VMVqQNmDOpteVXdwZxft88X
k1WCRl3V7G8Rd2+XX1M0Q/D0E7HniylicgYDDPoJrB00hYYyiqDqRD/PZrKb
z95Ae6fKAgIHZyvZWA6FS0/akoecQLjuNWCWTDG69PDX/UKCxTvVesMJFK0y
/3NLCoInjpm5JVEUmviUroBGgg8WiRniMIqfy2WCIjXBe7dRd9cgCsXLK2Um
AwTDm9IQMZeXj8hornKeoEue6ih2onCWGZ9/Y85AxWOUWzYUXzf4ZaaEgTzh
tHW3OYWM97o5LJPBBc0hRa4RxR9vYU+9ikHDdN5orD7Fyshy1NZ3LWd7W/XJ
nQS7HBct1HV7LMDhyVdTc5YUprq31W0HWfQfmTJ29eb2kHlDNHFd22expu7W
1SwWBu3Fk8pArk/eRMrbcnb3P+kzkzTyiEVrBmPLj6Fon+292KlmEegl4adJ
Kex9N5izgyz+3+M/sKwoLA==
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     122.98924642912498`, 50.39521844874999}, {124.95805647599998`, 
     50.39521844874999}, {124.95805647599998`, 49.89895331312499}, {
     122.98924642912498`, 49.89895331312499}, {122.98924642912498`, 
     50.39521844874999}}}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4v5J61/MKIl3cDykUFewyssBxpfwP3X0zE4v
h3yN3VKHJsU7KDn/9DA+4eXQuMen5evaeIcf5xdN6L/u5TBhheuWr0fjHc7H
+Nx4/czL4YeHvzHXiXiH9D1OkdefIPj8Xzyyyho94PxpwlVyJ1I9HI6bTpsy
81S8Q7evz+TEYA+Hv4eeldiej3fYYWXVa+Ht4XBWQvfWmcvxDj4KM898cPRw
YDvjEc91L95hvRs31yUbDwdBzfJnBe/iHdyXMXbvtULwuRWf/63X8XDQWl/I
JVeGyYepT++IMPnaGu9Qe7/13HFbD4e8/bvFDk2Id9hyYJE3q4uHA/dMz5sP
psY7BOfoi6n4ejjcftdvVzAr3uFA24Vr2WEeDitvX5v/f068wxmff4mXMhB8
F92zaxtaEPwt6l+Vv+Z6wflaZkfTF7d6OfDvF6mrmh3vcC76ZfHXqV4ON1sn
WBXMiHewKusysZ3vBbefp3OOVdpyLwer92bXt/fHO6xM0vrbssbLIeOOysW+
dgT/TPY0oYIWBF9/EkdAYD0w/KNnO6Wt9nKY6F/daVSBGd8wPgCVF/QB
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4ktMBqVyHgkOpx5tmbbjvpdD8MOprq89ExyS
nVaLL7mL4C+6uXylXoUHnK+zsHD65ngPh7d/w9MLvBMcdvNYTrXw93C4FpT4
osUvweHlT7V+fncPh33LszJnBiY4PKnv971j7+Hwbe4uX9uIBIdHaye43rH2
cPizanuibVKCg/syxu69Vgg+t+Lzv/U6Hg7nrWbmXZPG5MPU796aO6VFBWFe
xM5E1QIthH3Lo1Z0/NdNcAicZcCn4unhcLjezFPOKMFBea2TiG+gh8NEJ/E7
D4wTHP5tbp57Jx3BXzf/qsnULgT/9gmfKzOivOD8D00rH6VWezkcDr1QFWiY
4HCcP1jrUJeXg1qN0w4jHQT/o9O+Eg1NBH/3/ctJgaoJDkfSd33oa/dyaA1q
blqrkODQG2O+tKXByyFoTYpgAZD/KWTFq9R6LwcLl0UfX8knOKju0VUrqPNy
eGV6MEEDyO/eMi87sNbL4cLZfw6L5RIc9kqrLI+u8XIIkPxvt1gW4T7/9zMK
rskkOHQ8mp8cWOkFD793twRWGlV4OczOEtE/I5XgELxSWsG9zMvBN8Z4HieQ
v3NhT6pGKYKv0aejV9Dk5YCeXgD2Efyo
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
     0}}}, {{{134.413594861125, 50.63522576874999}, {134.413594861125, 
     52.38777921999999}, {134.942360988, 52.38777921999999}, {134.942360988, 
     50.63522576874999}, {136.693664401125, 50.63522576874999}, {
     136.693664401125, 50.098959413124994`}, {134.942360988, 
     50.098959413124994`}, {134.942360988, 48.34765599999999}, {
     134.413594861125, 48.34765599999999}, {134.413594861125, 
     50.098959413124994`}, {132.662291448, 50.098959413124994`}, {
     132.662291448, 50.63522576874999}, {134.413594861125, 
     50.63522576874999}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/UQq6uvciYkOXVGFd6bf83TIzd9zN2t+okPuWo/1
UQxeDjYxzPa/FmLy3X2u/Gae4w7ns/kq6U5uc3co0OmoY1mc6PA34vNKnQp3
B5WNPAf4liY6aLs9XMxc4O6wtL9owu1liQ5qZzyTLmS4O3yNkj9kvjrRQTFo
k8LcRHcHt52GxxI2JTpsv79yZkc0gu/xmfOig5+7g+WUHItNpZj8NxJ6dyfF
uTvYlzPXPa1DmCegKNbA15roEGF8fu6tdHeHH6XyjModiQ6Tnr1Skihyd/jF
0Xr5fVeiw5mZbCtCa9wdPBzPGNX3JDos+7Hu+8Z+BP914Q/2sDUIfqZaj8rH
XA+HZeK8f382AMNjGWP3XisPh3m+Lh4JxYkOLP+3NUkqeTisa7Jb752C4H/+
sCfSMQLBv7w0+UuHX6KD6xWm5r1mHg7p9/su3HJLdNBZWDh9c7yHg/7+G7JZ
9okOwnkPVq/s8HD4Ff2Oe7J1ogNT+1POy3sQfJ3f89Ry/yH4/VW3+wTdPR1q
v8vX/nQAhqfbn8KKVk8Hue8VTzZ6Jzpw6/G4b9vu6RBx5Zf5njCg/nXTHrx8
5elw/MAsBhage/NDH77oZfZymFe+Sky3BMFfEuUYk1CL4B9ZOuugRHuiwznG
PU+sv3s6oKcnANniDFw=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7eF4xqi+J9FB+5f1obK1Hg4w/paSv5kVjZ5wfpXU
Gv5/Rzwdvu0ITuhsSXSIyW1+dOCZp8Pr1u7l70sQ/JQjfRPfZyL4Py4Hzy9J
THR4ve6JYOVVT4cvzUo6fNGJDnkhdS3TN3k6fDD+uGN5SKLDx5/i37f2ezrs
/pVTOjcw0eGSotr0rfEIvkv7LxsrZQQ/yUQ5q5zR00GpUEDtaVCig0/VsehV
DzwcuOZsvqETmugwP6H4zMeDHg5LH90+URee6LD//ixG/SUeDgfvMu++EJXo
sME9L+9Er4eD4MoNb3TiEx2WB9u/Tqz3cFjXZLfeOyXRIS2kV+ZjpofD04q+
ye+zEh10FhZO3xzv4ZC1XPW6UjGC/+HqHqmwagTf0eS8XH1TooPxW/aHz7I8
HCq15JmVOxMdSt7sXB/e4OEgUuj+uaQ70aEyLfBjVzsivAM+/7J4Pg3Bh8UH
AMcZwv0=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI02EYxqdWVkZpKbJ5KK2WszRJMahtPNHy/9/XPCAkLBX5RFsZUXZA
c2KBoi5FSzuqVOYkQ5odRs3UVJrTjdTa0spT09AQD5SWZDdr3Sh08bv4wXvx
vM/7+iWfjk114nA4DnYC7Tj+g11pE72k2N2WOR6ewUDhMLx+WkuxKtI/qDyf
wRbO4jXBawpu0oRDkJpBUZXi29oOisB79T2GFgbtAl2nxkhhESu8ZX0MJJW5
aWwPheZQXe3gFIPH6uKZBDMFn5/xQ+XM4qtzhi20n0JotdjiAlh0c2V+Y0MU
xiyb3JzCwqepLC/dStEdSQ1djct+sS3nsoQvXfKCgg1nqlVShB1TOSUOU2x9
pUjMHZKC5PCeKD9S8DorxZs2E7h7hdxVWygUyR4mnwiCercdXld7Kdyzj8v7
UwgC7sdnLpgoWry2PYzPJpjb6HI71kBxxz81ZKqMoFr7u1zQSjFSqUFpA1nq
5+cRl+iEdwTRcROlHB2FaUx7U/eFoEAWfl5t70selX1d1EsgLsmPY/UUue1m
2WgrwdHn7p6KLooIoa615inBm2afCuVbChGrEopqCCKCJ4Ue7ylSJq3T1lIC
o5GnUdr7mh1wfbQnkyCmyFOvHKWwtbscXiMh6G/UODdMUkj2zS282EBwrlxo
6p6lKCw8++HWgBSup0zF0/P2ecVIU3StFCNyt1nlAsW6vgPe8yeWvWHRUR8l
WPYuizHvxjMW2+N/pYlnKHxD681cwkK2fyLGY5BinN/hz51jlu754FIW78Jn
Bru+F08l2PMHcw+6/tEzS/tdmfddUadlIFdp2IpOCpnhpGhvDYPVO6sk6W0U
n5LCQptLGPz/j38BrJg0NA==
     "]]}, 
   {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     153.35200000000003`, 115.695}, {153.35200000000003`, 106.34}, {145.766, 
     98.754}, {136.41, 98.754}, {127.051, 98.754}, {119.46900000000001`, 
     106.34}, {119.46900000000001`, 115.695}, {119.46900000000001`, 
     125.05499999999999`}, {127.051, 132.637}, {136.41, 132.637}, {145.766, 
     132.637}, {153.35200000000003`, 125.05499999999999`}, {
     153.35200000000003`, 115.695}}},
     CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
     
     "], CompressedData["
1:eJxd1Gk01mkYBvAXiYw1ZSmSeJkSIWKocSGa1OhIc8byf17PQ6oTqaRo0Cpb
ymnKSYs1S8soWzHDGRl5iWmoVIppwcRQSYQo5v3C/5z5cH/4fXmW+1zn0vff
uTFQRiAQSEmGSEZaMmbZLeP59ylapBy37jQmmLLU9lA3dUsCVVfZotaXFPvs
V3U/WkUwcGiFf8IbioIz9lXZawiWpl8oXjJEMdL08FD1BoIOp/PxNp8ptJ/b
BlX+SKDk9OdWXxmGwCPN5r4BBL//urlaXYFBvFuqq3EXQfpQSuiduQxx3QGu
pvEEcB/3mZzPsGnhz7llubzX93948Y+Yt6H2u+XnOgn0rqSExWgyVDLdqsdj
BAFPzBcZKDOsGi7x+kNRBIMTgT+YyjJUJbp9KFggQl3D+QVqnygEj+ZWXTIW
gV6X6V/Xy/t9ZkYDaee9eG/IQc9miufiwpbLeiI8fDGr9ngtxbak18u3qIoQ
7ZarcOc3igEPndMGUiK4DuRZjhRS2N2LFfb1EAzHXx46mk/hNCHsq6wjcFFT
vdCYSbHjjJeYNhK893WKWJZHITzy1ka7myAp3rFr7jWKtrSjWffHCSzylFyE
NygsL3b7aSuI8Ljmaa5VCcXp41rqiZoivA0PPRtbTjH001rxmKEIaf0KA99W
UUDv1fFz5iKkN2XFb2+iUPZS6TNwFyFTy9ZQo5Pi5NG8Q8mcCE4brXKiPvGe
2t+UfcRjd4R6DLbvHMV1HiJYqPodLjBhyMydbZ9oJ4JmxPD1YluGiSCNCgPJ
/fX9J+WDHBjkZ96M2TuTt+zfcR7pHWTa4ceEFQkNBAXhyemrVzI0+nCuY6UE
nyeHVydZMyxJ9GtQzyaoUxnd5bCMoeR1itAjmUBWzTQ7wZBBR25L+ulIgjkb
7ka2zWFI1pJRnNxCEFu7NGetkeS98zK+L/MieBU38izQkuHSpZCG/d8R6OZy
JnJ2DPoqreYnVxAcOHPiefgahj2zVUsntCX5VzSyNXdnWOnfWegzyE17+Fjf
L0o1vF3vfhQYx3Jo3Vcdvc2ZoaPw7LwXmzhUd5wa6jVluCYI0rQ34yDoEgut
DRgWB7dEb9DhpvP+YMeuKjlliedMPkuV5DOq9StZyHCwaJRadvAjhZFzvlvE
qC/s2m2SorooVJOVvY0GfWHVZBfx+QFvZ6UnHu41vINrQlPEtyjMrcIcskZ8
YbI/v765gGL3AQfFswIOvWbt489yKIrrFZ4mzeJQEeSc05FBoXtF/rCRBu/t
tzLcXIS8b6+bIatkzqH5Vvup0iyKN24rusxt+PNMlkoX5K3kIJvfFih1mYLp
SB0edOKgYabcNiHJc/C+e/svukj2E4Fy/yLe3W6K8y3LeNuUKHjn3qbQt7cu
j17FISFG/kLqPTq9z7FTwVWxbXR6n81tzZHKPRT/6s8q8lbnkDX6V4XjIG9d
OtnaKumfKX96fFftppqkX6TlvAf1OLhEsieeugwLH1iXfvlG8t5UP824rxlq
wixsuzw53BfUBm4zY8gbHY3BHt71JOn87FTeV195doeUcTDpHJ3hvYQhoKnH
y/ghh73fjpmtX8QwrqnVtbmXw43I+u5qbYbiiwUeadIE76K+aCmqSPpqkdrL
InUC6Z7JkGIBQ1ikSvkBXYLqNKvsyhGKq0HKSY0GZPq//+/rKf8HxVeLRg==

     "]]}, 
   {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
    0.006600660066006601], Opacity[1.], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}}}, {{{126.082, 102.16799999999999`}, {
     120.62899999999999`, 95.027}, {113.809, 86.09}, {107.62499999999999`, 
     77.992}}},
     CurveClosed->{0}]}, 
   {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[1.],
     Thickness[0.006600660066006601], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
    0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{110.348, 75.789}, {101.5, 
     69.965}, {104.785, 80.039}}}]}, 
   {Thickness[0.006600660066006601], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQLbv7ZuTldxEOm3/HfuxmiXDQT5mnlcsV6aCy9GRU
rmiEwxlbnbfd/Jj8iSX8jE6Pw+D8DyXbZnbeCHMwvmeas0Aw0uHNL7mIsIth
DnOe273fIhrp0PxR9Krj2TCH+Uu4JvhJRjo0mHiZrDgZ5mBnnfKZTSnSoa68
bjLfsTCHh987fkcYRDp42v3yZzmM4At6rMpO2BPmcGztv/u/t0Vg8J9E7Sns
PBLmcLFYJzvpZATcvOLjgflbrkY4SL3gCdIF2udSmFJ493aEw/aDs0R8zoU5
uE/XFyt/GOEQMlvjetblMIfH7PuuTH0S4XDg1J9/EncR/OR2Rfbs1wj+osTs
qRY+4Q4Lt9hndp+NcJiouOzEPKNwh36Fdf/DN0U4fDjbcMRHLdxhfdeis3pT
EHzL9PlKUjUI/s8Lb8JXZkQ4TNix7Mg8g3AHZRdnAd/ICAcW+XvnJF3DHTYx
X1+V7RXhUN4qenNKZLiDuy1T+16nCId3ghIdK4sRfJYzJdPKpiD4W7knnzqx
I9zBryQ1s8s3wuFkobLNn+tA9xWLW/xOinAoTl2tJv0x3IFFT/o+f2WEQ/PS
gs9buCIcHrFFF8yfHOGg+nPqdzZxoLtKquZ83Izgz7FaoR5xDMG/cyHq04mb
wPDzb/56VyDCAT09AQC38BbS
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zh935WpTyIcmr2dU35nhzvA+Cc4VCz+XEXwV0X/
5tr/PdzB/vsZ/VVXIhxkWNNLFnBEOGhPtNlXthXBl+VznlQ2H8F31T27tqEv
wuHxUvGeP//DHWx7s45vboxwWFKRcrT7XbiDyVv2h89KIhzSvDf+k7ob7nCq
6n/kpbwIh7D4HeekjiL4ApMWKd5dhuDPe2G24/fUcIeZ6W67EwsjHKZ0cxhO
bQ13yNjbo/CxNMJh77+4lxZl4Q7zvO4yTK2KcPDd96k5PD3c4ZqD7lMLoP1u
RTFWKjHhDqXX2zw+dkY4OP448uNDSLjD+q5FZ/WmRDgs+JE90cIr3EGu3Gla
2cIIBxb5e+ckXcMdNK8UyN7diOAbG85f4nwIwb/29vCaqRciHNhdVxZvBup3
vZVcevduhMMKF6bb2aHhDtXpW0IbHwHDk/FcNWskInxFTyyavzkBwYfFBwBZ
OcLP
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx11Ok3LphbUKx1AmU7nU0nD2XWyisrD+/9+zMPfklEtiiai5
hGOUjcqa28GRw9Fq6myFkeMQq0bhxHIsxiZJl6m16Lxi68XnxefNs+f7fB/b
qKTgWEM9PT19HU46DHRoS0sfCTsJo905gVb5DDutpm/39hDO/25xSrzO0CCU
Ffu1E1aVIlVJIsPrucHpvDrC8q6pj92RDFFDjjbe9wiW/mtH/55lCF24ozEu
I7SpwlI7AhiK3+eMagsIIk1nyyVvBqG5vN0th+CeVWZvdIDBf1Hv4lgK4bMi
I33QjKGlObXxWQJBrDqBwFl+w/0Kv2252bbpPXudSkcyeWQGF8i0yYTU7dl3
I4N5nLGLCZRm6fYVzDbtduXxJWbFojeXIHye2GUv5OHQblq5LtHNO6hKV5vx
cC5vmHSrIFwOn38jMOThluZpG1dNqC413n98lUN9h6zAr41QUfWhcXKB27jP
1ytP7xdNcGjtMk6xeEHIV8ykTb7lMJbv3B+kIPA93zMFGg4XDEr0t0kJL28N
1DzWcnBRJt0YriKo9SNm5uY5hDeGXZOWE2J9l2SCZQ6st/9wchHhmHwoQP2L
Q5AkOliaTTDNfLhSJODhszXBQRpPyDNqra3W5fGQe9Z4MdL1oHyl9uCxtmqz
Z/00oWnSYFwcwqPPV1DR40NYXDz1yTyRh6M4faReRIg5YuneJdn0NrHL7B/5
pteuDeeyeR5V8YoJ6yDCz8Cp0EpLhpPNwybJaYSrJZpDcr/NPp80/1AuhDBI
RDnj2kLC0rkdIodwtpFvX5Nzd3Qcg6uJl3XcA0KfV4GdVRLDu4GIfcoWwtpy
nYwyGP7/x38W1TU+
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     103.91502742912499`, 94.72725044874998}, {105.883837476, 
     94.72725044874998}, {105.883837476, 94.23098531312499}, {
     103.91502742912499`, 94.23098531312499}, {103.91502742912499`, 
     94.72725044874998}}}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYjHlxc9vrI9y6Ftv6lSRFeEA4/8q5UpTK4pw
+LZjnSTTuSiHf+8XLo+sjHDg8HVoNn0Z5ZC1rew0e2OEg7il5WZTxmiHqzXe
77d2RDjU33Qy8mKOdli45tj61e0IfukJT4vfoeFwvmVEkpCKR7iD37HOyTdZ
ox2MS0+f+WAX7tASfKu4liva4VT2Ic87VuEOISsVbvLwRztMuVeYaWEW7tAb
YxPnJRntcPSjFsdK43CHGTuznm7QjHaYqLjsxDwjBP/zPQmmBu1wh432qZxx
G6Mw+DD17yR8jE0PRjno2GW8UjYJd/jqv16U6UyUw/F131Y4mYc7TNK0vaFw
McphOost3yXrcIek+mbbDVejHM5O7H1X6hDuYJBzap79jSiHyyUqJis9EXz+
p9xRDeEIvscj+alWPhFwftNL9u2CEREO0/w5anddi3II+SO51yohwiFBrMVy
w+Uoh+7OrLn3UiLg9n+ZVKzwOSPC4WC91rXvp6IcDtXvamzKjnB4nyNx4dwh
BD/4T6fghv0I/jalP34Td0U5fP1dpPIZGL8SD/I6ijZjxjeMDwA3G+jH
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYq1pwS9rTkc7XN5f7yfTGuGgGyzfJXY+2mH+
+198Qi0Ivr31z/DwwHA4n0X+3jlJ13CHpJ7FZxUuRTucvnLQ945NuIOR2bbz
njeiHZJO7zh13CLcgfnBiYtF96IdEvjeauqZhjsUncmYtet1tEPc0reqesbh
DvXPkg7t+h/tMFFx2Yl5Rgj+53sSTA3a4Q4qbGp33hRh8mHq//w+p+7ZgjDP
nHm7p8IEhH1XXV0E7KdHO0ybbct1yTLcgW9CwsSa+dEO/5e49T6zDXdYJaq0
nXFxtEOuxvNAPU8E31VuwtyuKAT/9ibv3B6nCDj/KX/Vl09BEQ68NlO+PJob
7RB4zU9iYVSEw+WOivylkxH8TLGCFxN6Efy//rOPPGqNdghoaqpmj4xwmGj6
i3l2TbTDlj8HQptCIxy0Xu5RVADyn1dU/vgUEuHwTcLikWh1tEODjo1YBZAf
86f0wITKaIfNK77seBEc4aCh87GhrSLawSdm+7VcIF/t8MeatjKE+1TzVR+8
KYl22GT/dcuLwAh4+D3ZvTY8EsjfkyoTe6Mg2kFc2XhyckCEg5JnlHVwfrSD
1/zXplf8EfzGqdZSFWFA96GlFwCVbPsz
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx10yygplViNGNCk7zlFLafXdEmuZ5vb//+LhBR3huFYWcpkQ
oSM6VhSGhGNuk8uSNI1VZI0JneaSOLayWiVzzHReOVsvPi8+2/Pieb7fxzok
1kesq6Wlpa3GQY2OGrPNutSuCEJ281yC4gOH2Xi+fI+Y8PN6Z+mdSQ4+sYU1
0hsEVereLE7Jwb4+yss7m6BjeTPywB8Osv6dRqVSwsQyM1nc5FBW+8Rv+AHB
LX5t3NGQR1R3Z8BKJSFjbnZ92z4eE2n5aTV1hPzTRpmSQzyaqo/1bz4jjBra
OTV48Liw0J9r+YLgt+IfZntV4/Lmy2dD6jUu3O3YY/yJR7Jr6+2VDkL64am2
DF2Gp5LRGZGcsC68Vv3WlsG1dqMnq5pQtSlY8nJhCC/+1hFYRkgsmBI0ejCE
tvjF2RcRPKnrY7Qvw19Ze8tsDuH5DP+oI5jBd1JaJ00iBD1OqdGPZlv5XFmT
O8SkMrSaR1aekhDG+tK9LLIZrAx2hGclEsoSQt9PpzDczZcfGc4kCFqkDU4J
DIPjg03bCwhFUdrzJjEMD5cm20UyQsGviKrpMIaKodg1cTnB6nVJklMQQ63O
mEJUT/ja08Rf8mZozx7Wd35JiBY01rsdZ+j9opKWjhAKJRVp5vsZVkvMTCcm
CW3Fwcv5OgzC86JS03n1/C3TOaWSx4jNq0DnJcJvF/eiE+80fm7ooFjZoHEf
l7yBvBgeZJfr3z1O2FAmf/c8yaNxIcI6rI0wO5cj89yl6fOMNOSeSpuH5GIX
t6LeX0/hbti7ym3d5/zmqJ7sB4eBDJVxXB7hvlBRpVjkYDMwbmCZQghI67Oo
+Mzh/3/8Bxv5Pbo=
     "]]}, 
   {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
    0.006600660066006601], Opacity[1.], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}}}, {{{158.512, 68.492}, {155.359, 75.223}, {
     151.586, 83.277}, {148.059, 90.812}}},
     CurveClosed->{0}]}, 
   {EdgeForm[{RGBColor[0.2, 0.627451, 0.17254900000000004`], Opacity[1.], 
    Thickness[0.006600660066006601], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
    0.2, 0.627451, 0.17254900000000004`], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.85500000000002`, 
     89.398}, {143.785, 99.938}, {151.195, 92.367}}}]}, 
   {Thickness[0.0033003300330033004`], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxl1HtQVFUcB3CGHUBxIBMSkKFamHCQyJGUxVHabxCMvBK3c1dencMjiocI
yhqKAgXKwylFllCTBmTkYcAEOLyEVQh5qCAQyUNBqcUpAlJYMcmgNnbgztQf
d37zmTn33vP7nfP7CUNiJGHaWlpaRP38GzO06vykKQzRoa06UikHXZM0q/t7
eTsZDOglU4bcAbNr824ccOtiqWkIg8psrqbEkfdxO26a2fI21Jc4expx2F93
uvCxH8OduPz4e38ThPoHm2e6M2QL6vcIZgl8F+xzLLczPHaTu1cpCbxEOqub
rBkmu17oJY0QDPd2L2Id70EjbVpiyDvfovqIYBVDvY9LmMEoQVdt/wAWKU5M
KGwED/7vs4m75Q4veLf37zxjMEfR0OAcYfCQoMWvaPe9abryvZOhXJTDLxQp
rbPHI4aI5r0xivULFsGNvQTvq6Jd2TDFy6lpr2XcJPB0KLzUdpeiZG3SubhW
3vqiJ3fJNd75sebVxbUEQn+vX4VKigjlrT7taoKwyNynbQsU24zcsp9XEmSp
Ug63ixnspQkztIIgwul5UJOEoWu100vj5WSl3p3KA5EeJQQV3s7RQdEMc8fk
HenfEJj3/byl9DBD4814Zw85Qf23sU/bExmu2LwSmJjGeyQvylgYzztPt8G9
MlR9Hlk9byfLGOiwTqpYwv8v3Stwh9KZ4E8f33MyVwbX+dGeIVuCxGcz+nJL
hsFDTmvOvE6wedTV2HKerlgSrZOePcZ7qW63KQwFpya3vkFQMLyhtvgqRYJ9
iJHyLaLJ6zKF93nUFjkS2Hib6mUXUFhGvPph+Hu8//iis+DGHt4fNeV1Hgwg
sNUfL7G9RCGyOhq1LUx9/r31t4fLKJx011WF7yeaOldTuEyUPrugzn/pnJop
qva5NypTCL6rHEvCDxRpWapFcRbBpws35rU7KawiP2+hXxEcSLWr71GvV13v
sP79PEFMe7CJg4Ku1F9X4ZsjbFDvbzsLF14kiCrIPZhXR9Fxuqi7soj3lumE
aVrGeynWEAx8HJXrcZ1CHCszYy0ExpA0C3sojo0FiB16iCb28fdxg9WEDjdE
NfdykMCy1XNK+Iiu9JdHd2FBWz/FqdGp8ogpPp+c5tTZvDk+/+V+Xd7/qo2N
f5nocxBofalKr6GINwpoYya8U2Izvdo38t601vVrTzGHnR6XZW3qeog2ib/3
/IBDhcr4QfEdikMC6ynLUE7TZw8pPgsicZlxHGzrEmIyVBST1jZnRUc5/Ch1
UBisYSt2cRk4wZnyTr6iKHtTPS9+U9jIRUc4NFoV9Qm2MniPX+g1lXEItFp0
bHqHYf1ezyeyGA6bT47cT9rF8JNFR3nkPg7aM1eT3lX3U0Kiwk4ayWGHj/4n
j/x5L8/H/3p5Pv4D951aCg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQvf1P2Yniu3EOQQfy9pv2hzis3/CgzuFSnEPtnCPV
NxtDHASb2+Q7Tsc5lO/UNVtWEeJwx5PpTu2JOIdb9+cXtxeHOCwXqJtRfDTO
wZZNaGNGXojDsj0bf988HOdg+cCN53wGgn++qfCNQjKC/3vTZNe48BCH1Wae
trxA82NkrB4t9QtxkFJ+yRp6I85h78010u3uIQ5hky9o6zyLc5BfE7TnnEOI
w2+eg1fEf8Q5tKhNnOZpG+Jgm2DvoMQfD+e/FJh8+pY2gj9pg59kgnO8Q3DN
9d83HEMcLt5lfHAhJN4hMj7Pkcc7xKEs/FPHnrR4h2OV/EwhIUD/b3MsTMiP
d5jl+XaFWAKCvyTIf/LjPARfIPdDsDYwPO4n/Oa+mBXv4JHsYHG+LsSB55dM
Jl9ivMPGHM/dj5tCHNjE25Rvh8c7bNYUjaltA7p/Z/icEvd4hy2TRBJqO0Ic
gqTm+L3XR/A5J+xikOBD8H88+6pf9ynOQcZY7v7ErhAH9PgCAGm8yS8=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3fpyrybzgziHGOV/FntsQh1g/INsNuLm1gi+92OL
HCXlUIfdZXxcy5/EOSxl8Nxvxh/q0Hf3zZrMd3EO54rnl9/6H+Lwm+fgFfEf
cQ4/nn3Vr/sQ4jA34dmNTJZ4hx4FRZ4LL0Icit/2KxwTRvA99uYe75BH8P0W
sPDu0Yh3+Kqp1f/kTYhDkNQcv/f68Q5TDjR/mvM1xOFjjKYon3m8Q9rlqT+O
/g1x+Cz5detyq3iHK2Fme3k5Q+H8cuHoo/HiCP7ryknnb2mHOoQ5pH/uMI13
iHtw8maoQ6jDNge+ngta8Q6X3BifXAgJdaj99pFrslK8w93F+tnmqaEOTreu
NYaKxTt4ZLH0P80JdbhokC1RworgT9Ns/jbnZxycP8HtzYbMD3EO9xN+c1/M
CHWICJhz5ujLOAeHUwtXSCSEOihG+bxQfBznkLe9f9H7cET4Gm9Y3iDhg+DD
4gMAX9W+Sw==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx39E4iZKQugyRQ/UjBY211tNXF1/dH1/lOH3ZdMVNnFJD8ZN
cnWtRQ+mZNVRWrOLPD/VdjO3PJ1LK+SZ2aSspmuYWr+/3NYf7z9e+3z+eL8/
n7dHQqo0cQ3DMGa8dvMy5+VQcyVetJ3iTFr0seFZFpol9YkCL4rlV9e9906y
MC7n90rdKVRJLlpJPwtVnPPltM0UuZ31X3I6WBCDrrhnA4VmeSCgrZmFgVsx
+ttSIDPwfMZrFmcjF9KF1hQGVXGFr5qF/8K6+AhLig7fpG26QhYFWll2wB8O
CkrkN+UsfuYMNTj+5vD3omfIerGJh4J6zEM3mph8srh1d5xAu+t7k2iFw9q2
U/c9Ggi6shKrGAveb/3bssEHBFu2VjoUWFFUp4hbpnIJDhwO/qgRUAyNPZEr
5QTNtZaZEfYUlvba7nYZQYiXwWVyE4UfpneYxxBkHFF2S90odkrq1CXHyep9
8rwKi8QhBEtHG0ObPCmcaWt6yX6COxrxt8/8/tf03kvt/HwgZck6wIkiMqjs
cXoYQUt4stjRgSK6Jnj0uYRAKkroYOwoFo268vaTBPruIk+ZDUV3zItwZSyB
xC/xDcPf66lP3rz4HIFqrC/Q7BcHp6b80rhrBDm56upHUxyMWfd0ylKCMH2+
T+wgh6DbI/17GgkEbskVQj2H7FLvcf0HgtRDI9NMJ4fFGeO+7B8mhrtgosWe
XWX/qgqFs4TFxEHHuavDHG4wDacjFSzev3toJ2MoBKJan+RK0z+PROvrXjay
mLVZuCDk/Sts54JntOxqvsYoq1bPLhataQanST5/1DwVDvN9su2bchW4UhQ+
yyp3GWXxfx//AQFaKiI=
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     130.09264412112498`, 84.30146844875}, {132.06145416799998`, 
     84.30146844875}, {132.06145416799998`, 83.805203313125}, {
     130.09264412112498`, 83.805203313125}, {130.09264412112498`, 
     84.30146844875}}}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr2/LLWz5yY4KCYK2FucD3WA8XvVnyY9uxbq
IHeCS2zDmgSHiQtrlkjeC3VQn3T5lOeuBIe/6YEnjj8NddDnuPDI81iCQ4ae
2pvSt6EOyTdClEKOJziYxC1ck/0GweeoUjHdvSsEzj/Dacv/ZE2Iwym/H5dm
n0hwOKa27OSGxSEOqVMVDr89leAQKzvXbc78EAffA4dLTc8mOKhP8En7MSvE
4dXMQIuQSwkOEYtZWTNnhDjkn3hR3X4rwUHlcsPRuOkIftuEz//sJ4Q4VHM/
442bh8mHqZequLnIc1mCw/73Ts8fA82bK8wtsmF1gkNUwsWlTHNCHHIYgkrt
1yU4aG0T5560IMQhRPurevuGBIcE54zXpktDHHYvnHHj3MYEhzS1/waZ6xD8
RdOehTnsQfBvTf418deGUDhfdPajzRf3hDrkTd7uzgPkP1/7ZeevI6EOl8u+
qravT3CQs3adNe9kKNz+dhc/2c1nQx1aVnt80QK6L9Rwap3ThVAH6UX2hWLL
EfyzmT8E25ci+P9qNm74vijBoWOtr+JmYPyuv53lmzEfM75hfAC9Svhw
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4h1md2tztRMd0gqjvO+8DHWwFHX2s9JNdDBa
eJX70gsE/9KbyyHi20Lg/OkXdpy+uTLE4bIha8F+vUSHuLY5XnMWhjjsaeP7
eNkw0eFrzeTj7XNDHJbcFi96YZLo8Hn/cbV3M0Mc7lxMD+uxTnT4GHZC6d30
EIdH91KyelwTHVQuNxyNQ+K3Tfj8z35CiMPWPLdy1f8JGHyY+oUvpeZeZkeY
Z/eWT28/L8K+3r7QiX6CiQ6avhLsk+aFOKzc/DgwVzTRYVKYYteyRSEO5WVH
nuiLJzow3Dro924tgn/jfNYsr/0Ifl6KWpbP8lA4v+JgyMdN20MdVnbWNi8Q
SXR40q4pmrg/1IFnw/sDjfwI/vWy7NpyHgR/oXBj9gKORIfHxrEVx/eGOmS3
GXT/YU50cF83O8hpV6iDxQNBqf1AfpVWyNdNO0Md5Cr8f1kC+cL3xIQtgPwL
mXmZ5UyJDm5R57eu2BHqsI1xjecnxkSH+7yTLusC+Wa+a9w/MSDcZ6rsVqkK
5Lt+PL9xxbZQePiV53aESAL5jfMOmkv/S3BYdYV3gvLWUAfjCQ+WRfxNcLgb
cMxoyhYEX8RdTNxid6gDenoBADjYA9g=
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     139.84494155712497`, 84.30146844875}, {141.81375160399998`, 
     84.30146844875}, {141.81375160399998`, 83.805203313125}, {
     139.84494155712497`, 83.805203313125}, {139.84494155712497`, 
     84.30146844875}}}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4g094v7rriY6KCYK2FucD3WA8XvVnyY9uxbq
sCBc9sWhJ4kOExfWLJG8F+qwUvHZnJhPiQ5/0wNPHH8a6rBx+qMtMf8SHTL0
1N6Uvg11eJqe/iXtf6KDSdzCNdlvEHyOKhXT3btC4PwznLb8T9aEOPjc41q6
jiHJ4ZjaspMbFoc4PFcxnsrAnOQQKzvXbc78EIfz/tfcPViTHNQn+KT9mBXi
kKOZwpXOleQQsZiVNXNGiMPH8N++s4SSHFQuNxyNm47gt034/M9+QojD31k/
7hdcS8Tgw9TPYX9TEnMv0WH/e6fnj4HmyS+WfXbocaJDVMLFpUxzQhze9ae4
Bz1LdNDaJs49aUGIw7Vd7L9mvkh0SHDOeG26NMTB1nD1qocvEx3S1P4bZK5D
8BdNexbmsAfBvzX518RfG0LhfNHZjzZf3BPq8EHplKQ8kP987Zedv46EOoSy
cfyY+TzRQc7adda8k6Fw+9td/GQ3nw11YLOOPmYLdF+o4dQ6pwuhDnMNg5w1
7yP4/j+5nsy8i+A38Bxp4rqd6NCx1ldxMzB+DbNr5auvY8Y3jA8ATCD79w==

     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1,
      3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltIk2EcBnArS8NSo5UolKdKpDSlwhPY06xE3Izkey0kbL2pJC6tMCMV
Np1ttghN1Epqms2yZmCec24GW7Ok4TqYhxKTxJSEbS6M0qSvqw/q4rn4Xf2P
/jQ3OWOVk5PTCjYhbFaycSs0dx2rpGj7oAkcG2JwJ73fL66UQl7hWN5fwcB9
493frX7/W9mpvz9azeDy0eF2fhLF7vFDvIAfDBTvLZ/56RQ+Fon56XYC9xrz
Aj+Xwjm1p+RAMufux+e+mwo5/3wUYIi4QTBf2+hsz6aIHB662tRAoFUTP2EG
xfpFidm5hcBSKV1WpVEUffWtEegIpryaR2yEon08t8BmIDA2zKmzEznbM/Is
F/mc613oa0EMxZQieNOpPoJBRcct2z6KDf6JF1QdBII5WZAyjCK2Rzz4UUNQ
JB52hOykyDQaZJJagonKhHCPHRS9lpjbomIC/jNtju3vPnQlv6wygoP5Cg/l
Noq3jpuaEDUBb2FP3HQwBS9+s1ekliCTORzvEU7x7V1fWtUAgbyurrk/mmKX
PtakmiAIchhbvOPZeudTEz/NEnjpBxJCUzhHm6xHpKc5P0yo4L3MoTCNOc0E
ThIUyF1ndZcoyp4I/dsGCaRZdaF2KUVLl3ooRc/Ou1cgEl6hcC2eufamifPJ
66J7reWcJ0SLbm/OsPN752iVBRRGg0u3JZbgbE1euZK9L7a4TWo9CbYGLy1K
oijW6I5X+Xex/3CiwceezzlMNb9UVcRZaJDq2th+6kd9Oh90M0hKmS6XyijW
fgmM0vYyiNBYPavlFOvqraPMcwZi97EAsZK9j0zuW/aKgVXS+GJ1OUWJYb40
a4TBv//7ByRcU08=
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE3AUxtUsxdyEbuhDmhJK5px4eZCafoIEOock/392o8bJS1qipiWi
0gUVRyotKUxzmpRWSNg0MV0XNy/kJW+h1iZLl9QsUasHNcz25KCH7+EH34Fz
vu94Unpc4hYbGxtbi3wtsrOoec2tqkZNcJVrLlWHMOxuXX4ibSYUeivvRkkY
3qsFIsVLQpn417U9MQyhsfk3Ut8S7gzzZNNxhnTDIAl7CKm1QcKGBIafssqt
j98RJr0+jC2kM5yKf1CiGSLsquhc6S5gUHbcrKoYJbgvma8eLGfIG5RrIqYI
ia82/FKaGAbSGj1G9YSvDQHnvkxYWSIPh5eAb3K3zqF9JIxj1lWl0ljmd0y3
PIs4z7ESIJbqxwjlJlmtQsGhHYoMtR8mBD93mhPWcJzoPtS22E/YHtbqd6GJ
YyIuY+exXoJRcHtc1M5R1+MRpO4iyJSBlZd1HLHJArGig7Aki6/rG+Wb+aw9
LfLxn+VYd/zjK28hJGWelBrMHCEb0S72Fr/IJ6xfNcPxA9XLjW8IWnlKw9JH
DsekA+peHWG/u8E4OsaRmR4You8jeDyMVKkGOH5/Xp/MHiSoszOuLHVx5OSL
o/SWvHLSSphbG8dfid9ZvYFgM1P0yP4+R+FFXb1wjuC1NzdPf53D88jRRNE8
ITIydF6azPHaw+gTs2jxBy9ON8ZwlDp7K/TLhOL5feWr/laeyrelRqGV58wJ
2uhxhnGB0zbVN8Kte9zsXMuwtrD2PXuCkFVBSucsa59j4ZKyjiSGT/UPijWW
/StLPR0LTrPN+3pzXewYY3A4rDOtagnepheqailD23SzcaSTsCCucjsTwfD/
P/4DtsA+fA==
     "]]}, 
   {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     228.21099999999998`, 112.65199999999999`}, {228.21099999999998`, 
     103.29700000000001`}, {220.629, 95.71100000000001}, {211.26999999999998`,
      95.71100000000001}, {201.914, 95.71100000000001}, {194.33200000000002`, 
     103.29700000000001`}, {194.33200000000002`, 112.65199999999999`}, {
     194.33200000000002`, 122.012}, {201.914, 129.594}, {211.26999999999998`, 
     129.594}, {220.629, 129.594}, {228.21099999999998`, 122.012}, {
     228.21099999999998`, 112.65199999999999`}}},
     CurveClosed->{0}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1,
      3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4i1nlfw+7MlySKx8HX52W7RD08HPUT5LshxA
ahhsox0Wb1+1SeBbJgbfIvLf9TNu0Q7x65jfn3bNcmC7I8LN/THaIc/wr5RP
TpaDc3uuZ5tTjMPXTz8NeuqzHOpPHmtunIDgLwlvP6N1E8GfPE9KbMO/GIfz
Cnrn9lQC1QuvDzeVjXVorpnGIZeX5eDQKbhrmkmswyLH1PDcpCyHGxcdXK94
xzocmGuyyCY4y0Gl7AZXcXisg/7rrOmXHRB8O032QlVDBD/j/qItc1WyHJgz
ihUq/GMd1vDaJdlIZzmUP+KflGwX6xC91F7lpGCWw5uYNcz+urEOCy7fupjO
keWgIeo98y1frEN8Jz9r0f9Mh1sbWpd8fxTjIGfvYlEDDI/foa+7ip7HOITo
O/Oc/JPp0J1bHXBPPtaBn3FFnBZblsM6a74sA49Yh2dePNKbhLIcCqQKLggm
xzrctby2d4tylsOkeuZnj9tjHTpT5hu5WGY5iIjMqj8/M9bBRvWc+opgBD+D
Zfq871kI/v/Hx1S31mU5zLt5/l5PV6zDh6VaPsl9WQ4bU6znsufEOsS8V/9R
My/L4Z3MLaNlvrEO03l6PeSWZTlcXSEs9Fcdwe9w8ZNl/xMD56/pUJv0Z3uM
Q/clzR2ek7McJr42sqvJi3Go9TfoOQmMXy9/Xu4bsjEOvumLvcoVsxzu7lbv
5mqMdgh7pPXkTw+Cr3jp0PLb0xD8h+l9RYJA97wQ/dK8uTnaoXZK773vi4D+
EVVLvt4V7aBxf//u6BVZDp6squYqE6MdboRFiIqsz3LY6qf02HZhtEPf77DX
CtuzHJrkAu08dkc7oKdfAJ4DNzw=
     "]]}, 
   {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
    0.006600660066006601], Opacity[1.], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}}}, {{{176.094, 66.531}, {181.54299999999998`, 
     73.67599999999999}, {188.363, 82.617}, {194.54299999999998`, 90.723}}},
     CurveClosed->{0}]}, 
   {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[1.],
     Thickness[0.006600660066006601], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
    0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{191.824, 92.926}, {200.672, 
     98.754}, {197.39100000000002`, 88.67999999999999}}}]}, 
   {Thickness[0.0033003300330033004`], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3X/3zZpMtxSHM7Y6b7vVQx0kjPynmoWkONg+nx6W
axHq8Fxu2rejYZj8Vdvu/nFkC4Hzuba3TO38Hewg/V7K7EJ4igOr7dvgsC/B
DueL55ffikxxmGP85ILjh2CHgCBWj+XRKQ4zyyQMVrwJdlggu6mSOSHFYfpO
n36+l8EOH6uP1OqkpzgkNZzwZnmG4Gt1VaQn3A92eBL2/32tFib/75yu3M7n
wQ6vLKeZbjRGmLf78QrzW5YpDsZat311gfYttti0451NisMF5kwBn4/BDktP
i3fvtk9xyL377VLWt2CHz8zxr7wcUxxu8pz+JcEQAufXnHzPlM2H4O9ebDnR
Ij/EIfDW/C1HTYHhkVxyZF5oiIOnwPX/2hopDpwC/gd8PEMcIl0vpolLIvjz
NvsL8vIi+HUZ31aHMKc4rPxVcmBecIiD0CLFjmW/kx1kE9eckswIcbjVmH3V
9Euyw4Tjj69MqQlxWCrXeDjuQ7IDR8iz5pXTEHxZPudJZdsR/HO+icdO3A5x
0Ni1yeTo12SHR5s/mv/5FeJwcif3nFqGFIee5ZVK0iKhDszTe9+3cwPj57nd
+y26oQ5Fzbo7zkukONhZp3xmswp18LSyPfdDA8H3l70irGOE4Odn6FY+sQaG
38TAj3eNQx3Q0xMAH1YRgA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zk5/pWXY4rDnF7BhN99IQ4w/kOvT8Z/fiD4h+ee
ZNsvFeqwsPqZeKhlioOpu2nBAu1Qh2kecvG7NRF8/nZFz91yCP7iac/CHMRS
HP48f9r+RynUYb7b1sc3+VMc9u4yOtgtGOow+1tzQTFnikN9b/0vKYZQh7S9
/3Uy2VIc8he2nZJ6EQLna14pkL17EsHfrsW65feOEIezxovvbmBPcVh79prO
1BUhDlvj3Cb8AJp3zUH3qcXMEIeApXkNXjwpDmkMB+vDu0IcchZMK5oDtD9+
i5aZSn2Iw55s5yU/hFMcoqwmf/lQHuIQ6XoxTVwyxWGnlVWvRW6IwwRrRe/d
8ikOsolrTklmhDiIZu3oe6eO4M+e4X9J0QDBf/Mt8ZqXeYqDQnt5/magfpW3
G3e9s01xONh24Vp2RYjDfuNbqxwcgOHpPKectQYRvnpchbM3NyP4sPgAAEPQ
tPw=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx7ccM5ap+ZB4ychiZZeFtywU+2bgMsya+/2bYYHmT8FENwWd
JVjWSobXOZWWblrLa3hhJF5CV4ozL4iNRPCSSgVmE7o9RGr2f3LQw/fh83DO
+Z7vOQduymOTHTgcDpfVUVY7WGWKxXFlbRQ2bsxF72YGTqXyC8sdFPdCbwsz
6hlIy6TDxkYK13WnN8UaBis/PskH6yh2xrfOmlUMTMmVZT41FEFFE4GbuQxO
/nprU1VTWByPy7vSGVhWzamKCgqZV3FjegKD8sJpma6UInrgxn7HKwwasjmn
vhZS8L+Ls0b9GVx932uNV1GoHN3DYhztnDD2mlswRbZ5NuW32mogOOs3JFWw
9cWXorWJ2QR+ewKaJCWsX7HpmQchyDXlCpbLKUI2w/oOniOonOGPb1Wy/RTa
rBF/Avcoa7pOR1FU3zXOExI86dO7BhoouqdmDkV4ElhnpUPGBor2+eanc7vI
dj6CblWVel0K2aLqtIDNz/CtI3PupxS2iL0fj7B5KRwGlbwNKYK5Fs7Deor5
0eoakwOBx3wIUmopls6LFj4LCDqton7JY4r8R6+MPDeCE4lJnj1aitg1XeSI
F0HLsH+LhM1L2K9cUx8m8OUFayUPKPRRd2oN7D76af1lnzyKvN2FlpF4As6G
S8lWNoV53ztrWg5Bku/9sSUFBU/kteiiIagKDk2VZLDzlF9EA+12trT9XVyf
tHMvau7GCRjEBMlspUoKZ01rXHU4AyFJ4feoKTSTTcde3LLfc2J18OVKDoPI
OnOagvXPN3w4IyxgtvcLX/nTl6Rm4Mk3OAfqKRbyiY93BYM02ul2/TmFe4DC
eK2Wwf//+A/qjCqZ
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr+Hbze/PpbisPwjs11Fb6gDjC+840ai2tRQ
B7s1n30YrqU4iBsVLI6cE+rgXraHcdbjFIfmHy7H2ZeEOvi/2SE5632Kw7t9
kq+3rg51aN5jG7nkQ4rDrndTVq9eheD3cUmY/K4IgfODZhnwqWSHOLwyesj5
5mOKg8/2mSc+JIY4tFZy/rL9kuLweO0E1zuxIQ65S9asaf2W4rBWwSHVIjLE
gavOKn/J7xSHe8Y/mVeGhTj0r7m46TpzqsOq5JIj80IRfB7F53/r/UIcZr8/
57LueAoGH6beKubQzZnnUxxcG8yeKYeHOOz9/tmL4WqKw4MPR5Y4RYU49Dyx
WtN/PcVhgxs316W4EIcS/ntx12+mODy7HP2qNDnE4XZrI7/87RSHN9s+6a/M
QfA11G+FNlQh+Akq7yZY5YfC+bO1r20SrA516CtfUBdzK8Uh1+7FDqvmUIfP
Ufdirt9IcVhy2mLmvfZQuP28Vx1lPneHOizpN9SuvpLicPtgR21TX6iDdZvG
irQLCP5b34ce188h+HKJs567n0lx4LNzVPgMjN/z+4NbdpzAjG8YHwCbIgMy

     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1,
      3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4pXnF8tMbU51sEyfryQ1JcTBaufc1obSVAce
xed/6/1CHNakFyd9EMTkC7hvWiQZEuIgvmytZIN9qsPWXEvhpK0hDqqay10b
QlMdFiQUn/n4GKj+1eLohoRUh65XaxsbBULhfDvrlM9sVgh+vZXYoXL/UIcJ
76sz9WJTHfaln+x4kRDqEPlTu7UrLNVhcnfxGZe8UIe852HJd/xTHZgqhKf2
VIc6NOU02eq5pzpY5SVXGjSFOiR9P8S50gbB79/lZbrZGMG3i7Ew7NJJdciS
kBVZWBvqkHun+6+ueqrD9I12hfeKQx1eOUT1HFdMdTjilXBOOivUQerg2ohs
mVSHNyHbm/ZHhDrUPpef5iOe6uCUqD9jgX2owwPeSZd1hYDh4Vf2U98p1OHR
qdiS46KpDhEt3atyk0IdNnlxrVCWTnWYdZ1TrKIy1IFlpcwaH6VUh8KUzbFX
OkIdVL6UCrIC3bPJz+jovbmhDkfdZ4uGWwDtY/TzklkR6rBVaOG6bHcE/4bU
sS17QxB813lplazA8PPJ/vIseX6og8Tte76/M1Id+OwcFT73hjrI7SudrFeU
6mDmMePKtBqgfzuVjnaVpTr0Cd7pEkxH8J/Khiz45Ivgp358xyWoDvR/novC
iexUB6+Q39sE/oY4cL/2+nIcGL/H1v67//tciMOe2ksJe7VSHXp8fSYnlgLT
w8aKer0MBP/cpxOJl3IR/Nfi4UofC1Md1LL4tj4rC3F4s2rPl70lqQ79xeIW
v6tCHK7+P1p6qTzVYZLB4xtT6kIcuJI3tK+sBsaPcJXcifYQh94r1VrODakO
HCHPmldOC3FAT78AFGM2bA==
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
     0}}}, {{{174.80803436112504`, 83.51413176875}, {174.80803436112504`, 
     85.26668522}, {175.33680048800002`, 85.26668522}, {175.33680048800002`, 
     83.51413176875}, {177.08810390112504`, 83.51413176875}, {
     177.08810390112504`, 82.977865413125}, {175.33680048800002`, 
     82.977865413125}, {175.33680048800002`, 81.226562}, {174.80803436112504`,
      81.226562}, {174.80803436112504`, 82.977865413125}, {
     173.05673094800002`, 82.977865413125}, {173.05673094800002`, 
     83.51413176875}, {174.80803436112504`, 83.51413176875}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/crog4ntvDSHM7Y6b7vVQx2K24NkudakOdg+nx6W
axHq4FQys27mOkz+qm13/ziyhcD5XNtbpnb+DnYoc5Hbt3h9mgOr7dvgsC/B
DlonF/1fuzHNYY7xkwuOH4IdVi/nuFC1Oc1hZpmEwYo3wQ6/i7YyXt+e5jB9
p08/38tgB5+Lx1kZ9qc5JDWc8GZ5huBrdVWkJ9wPdrBfw1QR2ITJ/zunK7fz
ebCDa//MvS3dCPPELNfsXzsxzcFY67avLtC+f71bHQ5NSXO4wJwp4PMx2IFB
UVq4f3qaQ+7db5eyvgU7+EUmFcnNTHO4yXP6lwRDCJxfc/I9UzYfgr97seVE
i/wQhzX6i21m9gLDI7nkyLzQEIclqbfa/9enOXAK+B/w8Qxx2DLryrtXBQj+
T47gmQ9SEPybe38aa0SnOaz8VXJgXnCIQ+53FYGq4DQH2cQ1pyQzQhxMr+fF
cvqkOUw4/vjKlJoQB4aSFm8jjzQHjpBnzSunIfiyfM6TyrYj+Od8E4+duB3i
0My/bc8M3zSHR5s/mv/5FeKgws+vEhiR5tCzvFJJWiTUIe7NhPLoZGD8PLd7
v0U31OHsDQOHxUD32lmnfGazCnVY0u8QdqYBwV9VdH32/04E/9ReA8Ydk4Hh
NzHw413jUAf09AQApBMLLA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7ReZVCQ3M81hTq9gwu++EAcY/6HXJ+M/PxD8w3NP
su2XCnX4c+HlfI2JaQ6m7qYFC7RDHT7OVXze14jgZ91RudhXhuD/e/3ynnBe
msOf50/b/yiFOvyavSN7bXqaw95dRge7BUMdvnm3/3BLTHOo763/JcUQ6nBQ
iHmrTVyaQ/7CtlNSL0LgfM0rBbJ3TyL427VYt/zeEeKg0bkstSU+zWHt2Ws6
U1eEOAhs8ZQ4AzTvmoPuU4uZIQ6rfxVyyKWkOaQxHKwP7wpxOP515q98oP3x
W7TMVOpDHMQPuumcyU5ziLKa/OVDeYjDlllX3r0qSHPYaWXVa5Eb4vB6gsrl
vvI0B9nENackM0IcCvbvFjtUj+B/exsU9bUdwXf3SY2T609zUGgvz98M1F/v
tNXp0NQ0h4NtF65lV4Q4SHXeNRKZAQxP5znlrDWI8NXjKpy9uRnBh8UHAPkc
uaw=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EYhmer1JFhZaabJTpb5fJYkFbkLUrmWCPc9w6zrCH6CtoMmQke
8AAq2bIcpEnhTNKmM9OYZUSCouRp5WFWmG6UikvKUqSDqdV+OejH9eOC54bn
5JVwOSaJzWKx7Kz4WtlgxUF+94Spm0Kz0JI+sSSFwl0pUXVRcNqLKkpXpBC4
3RzpG6DY0TmbL+MwULetCXQjFDx5NOXvYtAbLrGXvKVYCNjnNOvNQKR311ne
U8Tre0f8/BnoX3j7rZop7vBbfm48zmDO0ynMOEVRV2DKSxUzMAZNyQvnKD6f
XhI2pjDgG/f3OM9TKI74JPhU2Lx7ITgsYdDmImblqfMag6N5nhGr1nyVQttc
KCA4U9n6jTtD4ZIRrumPIuAeemmK+EDxPPzPtOQcweMDHXEBkxTq11phUwqB
/7PF9op3FEma4lFFJsEv39p3i6MURi/B7SeFBFrDDWPfIEWmWVRjX07W91Nw
LEuQdo+ApOUO1fRQfLGTiDwaCMoSDfoIa72+PajfXEMQ+cCj0jJMcWrxfH1g
FYF8UCfb/IZC92jIvE1N0D+mH+eOU9QfDqk2lxKIT+bntpkoQjYlXgksIBj6
2DrPnaZYW8uRns0gkN1vZvO+UpSkZ9VFxhFMjkRGSX5QNDRfyuaBIKtp1FGx
QjEwdnBOtZfAtVhuULGSUdIzNWnhEMyka/147GRsyXEpC51n1v2C03e5xWDz
1OzYrmtqBkKlSmdapnD1jf4kjmcQI80tb7NQLPNl5eIg2z1jhwOv//ZhEOzA
F65a+9+ze6d9B5dZn0/MYdvd2s7gYm3k1dAxiofKxuoJRwZbI4KLnF9RKDvL
3DR/pfj/H/8B7W405g==
     "]]}, 
   {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
    "Butt"], JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}}}, {{{226.94899999999998`, 
     119.34400000000001`}, {234.012, 122.35499999999999`}, {
     242.57399999999998`, 126.012}, {250.691, 129.47299999999998`}}},
     CurveClosed->{0}]}, 
   {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], 
    Thickness[0.0033003300330033004`], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
    0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{249.32800000000003`, 
     132.695}, {259.89799999999997`, 133.40200000000002`}, {
     252.07399999999998`, 126.258}}}]}, 
   {Thickness[0.006600660066006601], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPS1XatfPvjwHIZY6580n4x1gfB7F53/rD8Q7sF7v
7Nzoi8mHqbc5ezM3NCTPoTJgt6reqXiHZQye+80i8xzWKjikWpyOdyh5269w
LDrPoZq3/djxs/EOzreuNYbG5Tl4/jqrHn4h3mFVQJXR3Pg8h4Z2OY7fVxD8
Vz/V+vlvI/ihB35v2vso3kGzSCTpQmyew2HnOeWs7+IdeMvf5NdF5Tmkh/TK
fPwb77BAdlMlc0Cew93ijFVe4gkOh/xuvdTmRfDf1v1xymTMc/h54U34yk/x
DvPdtj6++T/XoY9LwuT3q3iHIIsrQeJAfpjICf/wJwj+m22f9FfeQ/A3uHFz
XQK630bBedkPFkR43PVkulMrgMmHhd81Q6uk83dzMfgw9ctv+6T8eJwLD8/Y
z2YV51/kOqy/y8126Vy8gw7Xk+Xab3Id/EpSM7uuxzt4sPLMqn2f6xAS/mfd
3gfxDkZvq97Gfc11+Ptt+x+nH/EO26WFDCf9zXUobNbdcZ4vwaFXQZHnglGe
w50ZKaydPQkOsQvO2utYIPjBUnP83pfnOSTd+npr77d4h8VPPRq8a/IclF2c
BXwfxzssXSSi+LQ+z6HxgyzP72vA+O2PbippynPYOOv6suxL8Q5ONYseM7fm
OYgc9HziA4zv1a2r0yQ6EekDPb0BAMmaJzs=
      "], {{240.54036446000003`, 
      129.05537444875}, {242.39542103750003`, 129.05537444875}, {
      241.46789274875002`, 131.264191815625}, {240.54036446000003`, 
      129.05537444875}}}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdknss1XEYxn8cbZJbkzVNZChMYjaWkWclJK1lY81s3682mjWvy46sOEYu
J8XY3DoVI02WHEvlfonmFppDzb1cO02MzUYtpl//OFt/PH989r7v9j7P+1rd
iAmKkAiCoCXKQZS2qANOB3e8lglbwilbw1yOcqnLap6a8L7U08Q9m0OdYBoV
9JVwX5bFe9M4kierTOLGCRmng9dYEodvYIjr8Cjh8cXvipQEjg9TD/JdPxEW
JcWNUzEcoao0A8uPhBoD3zG3KA4bKvnj10s4+U2ZJwnnOBvWPanoJKT/sm5e
usax0pJ0W6+N0J1+yOKFp4adI+ZSYaXhaNcdnyhdjjGjzG0LcT7nSmBBuJqh
fXszQOghGPvVPzPrZdBXeCjz+gnuu54t1m8Y7Dr6STlE4LEF8X2VDDVnCg/7
qwgPy98N6jxicKpgb+e/EBpHxm3O5zBEdpneDJolKGeqK6ZlbD8fvcaMouxo
hp89vjNNS4Syjbq46QiGVPuJrHGxP1bSnahDDANq+XPXCcLMQPGT+gSG2u7f
i0c+E+YuOM0uJzP4NG9wYYSQktVaqZPB0OVn2xE5SAhaU/j25TJ4vdoMFP7l
1Z64lq1gaFjZchNaCaWX7j4tE/24tLHNoXpCkoG8t2+YoXBB5aysJXQeV43e
+sGwretDedUE7ZLcdbkWh735rr5QJdZbpUeZsYYXQ/bWZSc0HFY+7O14jmPh
mFm+Vx1B7h/sePk6R4uH3cvILoK/eqwomDT3jEwID5VKOaYy04wsxf0lV9fN
C+7wfX+WUtnsaxmHcpXVz4v+Y7wdjAzvcewFxDfozRD0zZpUjnKO///xL1Do
OSk=
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQnb74bpJWWL7DM7lp3476JDh8+G7v/T0532HeZ+/V
ZqEJDvuftK1pS8Pkr9p2949jRTycz7W9ZWpnbrzD5y3cbyak5zuw2r4NDkuL
d1huOUF3dma+wxzjJxcck+IdNCS+/U3PzneYWSZhsCIu3qHi8SL9I/n5DtN3
+vTzRcc7nHTcavy2LN8hqeGEN0sEgq/VVZGeEBjvsEfmw1I7K0z+3zlduZ2R
8Q6H/re9LnRGmDd55cy3szzzHYy1bvvqAu2r/rcob71PvsMF5kwBn+R4h9qJ
HI41/vkOuXe/XcrKiHc4fdJ/AXdgvsNNntO/JIoQ/JqT75myGxD83YstJ1o8
jHfQXDAhq80VGB7JJUfmHY93ULx2fOsb83wHTgH/Az674x0MuQ/J3NBA8Msq
HY6flUHww/SeJ4oK5zus/FVyYN7ReIdX6UJ26dz5DrKJa05J3op32OQe0/2N
Od9hwvHHV6a8A7r3SWGlPEO+A4vW54MhLAlwPl+7ouduEQT/+TKD5CdqCQ4M
DYtftbLmO3y8+UO6zizBYWH9n0A7gXyHY5dtJvI6Jzjcjqlb6iGd73CueH75
Lf8EBy9PubwJQPfOl91UyRyW4KDIoNey0wLBV3985OQbRwTfXU9Of6l3vsP2
Eyt+vAtKcEBPTwAd5hA9
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffqk/wLuwHyHc8c4NtQyJDjA+AWqPyXrTBH8R+dS
muPdEhwqHa+fFfXMd5i1WMrigl+CQx4fv2iNJYL/3Efof7Uegl8dc52HUS3f
4d/nT851XgkO5TzLZs6Sz3eIj5354KhjgkPxnhI1E8l8h/3H7Gt5LRMc7Jo/
PNIUy3fYEeCcyquL4Itk7eh7J4vgx0xlulUrmuCw9OfkyYXi+Q7X0rKnefEm
OPSqmLvtBJqXvWBa0RzWBAeN7Hgzbpl8hzSGg/Xhf+IdXNLaNWJB9m/RMlP5
GO8wxdAkaqdyvkOU1eQvH17GOxhyH5K5oZHvsNPKqtfifrxDBqMQY41+voNs
4ppTkrfiHd7qr3RZb47gF8c5dDyyR/CP7Anq4XbPd1BoL8/fDNT/Z9OigvW+
+Q4H2y5cy34V7zD956kExoB8h8POc8pZ38XDw1ePq3D25q8IPiw+ACbesJc=

      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxjdXOVaKJYm0vNQywzIvoULTeNCKpBkxUjKL/5ukYZkvYwkz
Zxebstk003mfy6VdNHHpaFqhLMwkK2ZpJV6SbtYSVLKMBLP/Jwd9eD784Nye
c86GZCpN4XE4HC6rAFZOrPL61el92RSGGZNsJIXBdw1RKrIoBO2qMs0ZBvVq
5eL9XAp368SFBCUDV7/JQxUaCiGJTRVpGOxuE4eJiyhmgvxdJnQMekXOQ4Ml
FMfMva8C6xgEB7ol2cspqkWm38taGKQWz6dbqykaLo6dP93F4OANW1GGkWIy
bnZr4yiDuhiPHwsNFBbhmpASHlniZEWVT6u3g/2acpLUEQTtU6tkdjb/hWXg
LSQEL1cYvPh6dv6HvrbPRwkq6s0rQyopxnwXZbdTCbZXN6nX6yj2fR0oi88g
uLtl/EvuVYodtmh7+FmCzJqi5eMFFHa30ufDWQSbopRcy2UKMb1p410iS/ux
1ka6R2gIXr9PW9AqKeY4/n6uhQSCNw8+BLPxwyOVJ6bVBI89BE8G1axfRYvU
M49gTFypmtVSxL87Oa1m6+3dY3TmX6OQrtMfmM4heGZJbzKWUeid2nZ6sv0l
UoOQX0Ox+LezcZucYMC9JoR/i6K7I1K6kfWTGB2aKW6hGEwI73RJJJgTWiOO
mClSTpX/7NlPUPorbl7RQRGTLJuS7yI4/lGXxH9EkR9V8FQf5GBT/rl7ch8H
h0U1kx4uwZ1PiqG+VgqPgNhvEhsDW3dal/E6xR9RQrGk3nHPw/3B2vlyBiaF
W6Kdnd/ba61zp5ZZ8icR8Lg6FYPR1aGWzaz/Znlj7Ug2gytmn7YFFYXcWuhp
kDH4/x//AVsVNkI=
     "]]}, 
   {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
    0.006600660066006601], Opacity[1.], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}], 
    JoinedCurveBox[{{{1, 4, 3}}}, {{{194.285, 113.34400000000001`}, {185.254, 
     113.71100000000001`}, {173.93800000000002`, 114.17199999999998`}, {
     163.71099999999998`, 114.586}}},
     CurveClosed->{0}]}, 
   {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[1.],
     Thickness[0.006600660066006601], CapForm["Butt"], 
    JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
    0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.43800000000002`, 
     111.09400000000001`}, {153.59, 115.}, {163.72299999999998`, 
     118.09}}}]}, 
   {Thickness[0.006600660066006601], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbSlfh3nnBQHt7UW77z/xjr43Xw47drKFIftYUvC
dfniHGSPafxIXYPJV1F79ZfxTgyc36I2cZrnxRiHwGlrzQvWpjjUr/kZInYq
xoFV2qiyan2Kg9jiDxcZj8U4tP2c7um+McVB+JmKYcahGIdrR1yqF29NcRDU
jJxwbl+Mg7pyeP2ZPSkOd95f8TmyG8Ff8rMlQ2FrjIPUv4kfZRsw+eU80/M8
98Y4KDzUMA/sRJj3scvasqo/xWHtzOd+bw/GONy877Krb1KKg1dxqSDP8RiH
20WreqKnpjg892G+onUmxkFz9cfXr6alOATXXP994yqC/83iD7P2EwTfVNht
0g+XWIf2RqNtqd3A8LjccDROO9ahfnsm45naFIfm+uiDPPKxDv1vkjO25yH4
V6IeCa1NQvC38Heu/RKR4qCc1XgwTjPWwcNzS6dbYIrD9As7Tt+0jXUQ0Px3
7apnigOX+YerIUGxDrePCh/955ri0HT4U0tmDoI/vdZ/slkvgu+xN/d4x8ZY
h7hEV7NU7xSHGOV/FnsuxDr8T5g3VzYsxYFNvE359stYB0s7hY/qicD4Cff+
UMIc57BC68DOfKB7d6wq+HKMP86h/uH58zPqEPzWI2miZ9oR/KX8B6paJgLD
jyHu01zOOAf09AQAkwgdAg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbn64+tX01IcxP7KJu5OiXWA8aN3/TPZcw7Bt+W9
xl7/IdbhulKl5Ne+FIf12xwLExjjHM6835AQXY/gu+pt8YouQfBv2lZGPMhO
cSgL/9Sx50esw9W37k8rU1MczLXsD3k/j3W4OFesSDg+xeHnn+7ft67GOsxJ
maTHGZPi8FJg8ulbexH8xc61cnPnI/iGswS37u6LdWC+bXo/IDbFQd32sW5o
XazDa9abE2cAzQvYYPnsR16sQ5sPY9OrxBSHB/lnG8QTYh0WuWuW2ADtv6ls
bv4kJNbhk9C1pTMyUxyurJz/dYNvrEP/m+SM7XkpDsar3Pp+OMU6HHu02Se6
NMVh+oUdp2/axjp4C3pP6KtF8C/aP7p8sBXBV5r35fqrnhSHWd+aC4qdYx2i
prjs6Zuc4mD97c51bb9Yh6+3ctY8mAoMz80rKo4GIsJ3RWXtnOJIBB8WHwA8
FcqY
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EYXTNTmMUISaWrmdnFK5U1oTgmGOa6iZdtfd+n2TsLNcyZWrRs
mmlqBkuJzMS8pGIkRWmGOsjGljpTWYRLTU1ZarlcMTFn0ffLQT/Oj8NzO+d5
Hvf4lAipHYfDWcFiFwsui3qTQexnJ0VCqiR8+BqDw/u4R7PtpVhsvOnlm8Gg
INCoCVkiKEx06xSeY7DpQWZqvIUgp7tl6LqEwZSTl1I1R9C0OLi34zgDaflp
07bvBMg8cDE9hMGSMiKJP0UwUHi/3ieQgcb3vFgwSaDxSdyi9WQwtKFkf9EI
gSIuMq3AgcHtq8IPVgPB3wyPg2tG6GX+SdDLDa6z8ciPK4vuXqKR3h8VxWfr
V3WISt3DacS2qhvMX1i9Laoaw04aTWKeU7aR4HlyWNvEOhrdWWW6yhm232hl
Wr4DjWNzJEXwg8Ce36lTWyn0n/Ffq/9FEIBJT+4cBcccozrESrBD2FxdPk4t
7yd3u/Je2ACF4jyXoEauFK5x7bLyLgpbZxom37H5M7L3l9VsPKlBxPWcJ4gW
1DyUGSicuNEdvOongeRF0OfHYxSMV96ozLMECxZtrforhbOO8+tF0wQ6qu5I
vpnCaLK60TxB8Mg71xT2h4LoibbUPEjg8jqvgnGhoZf7n1L1E1jkJdr8ABqB
NdV3KnsIBMUj+t1CGmVdzjqFhiCrwmusL4FGz3BvovktO89o8cvKtXFs5I23
1dr4nmf1CtcxGrlD07O+vQS3OK/E0c4MKOuCg2iUgHfopXcSbPcMlfQ1NwgZ
yEMjLvBZ/YrV34KM0cyyv9YYh3aPWAYnn/rz9az/GFPc5mH2n6p4Ic5LvwmU
VfJaNxmD///xH/qsRAE=
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4paOhq3dMqkOiokC9hbJcQ4wfq/606RnWXEO
JcFtfgu0Ux0mLqxZIlkU51Ar689sZZnq8Dc98MTxyjiH1sne0lauqQ4Zempv
ShvjHHYmX4hycUt1MIlbuCa7AcHnqFIx3e0XC+ef4bTlf+IQ66Bwq5i7xz3V
4ZjaspMbzGMddivM+X3XM9UhVnau2xzjWIfF3vbrVH1SHdQn+KT90It1cFA9
W+ASmOoQsZiVNVMn1uFocMqW8shUB5XLDUfjtBH8tgmf/9mrxDpcnJbo5ieL
yYepL2AOvW2pmuqw/73T88dA8z7Pa/NZoJXqEJVwcSmTQazDoe6za/V1Ux20
tolzTzKJdVi1rSChXD/VIcE547WpZayDoK6I4H6DVIc0tf8GmU4I/qJpz8Ic
AhD8W5N/TfzlEgfni85+tPliQJzDETnjhj9A856v/bLzV0ScgyZTYVy5XqqD
nLXrrHmxcXD72138ZDcnxjncMjuiIw10X6jh1DqnlDiHQt3dK9nUEHzlr8Ve
5SoIfgiH7svniqkOHWt9FTcD45c1/VlrhBxmfMP4AAOd0vA=
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1,
      3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ntI01EUB/CVYtZqEToNI93c+kPRkqKlFXqkRETNpVZjcm/zcZqioK5M
UMOc4SPRVHxUmhhqpSaZ5vKRk5otyLamsWTWkDJqoqRpD8yofv3TD+qP7x8f
uJx77zlHmJAejXYcDmcNE18ma5lMn5W477Ug9L7sFE2lEMhQ+BULxhCKKpd/
BokJvOU5JFUq//dFjbbF4kUgMhK2CWoRdllDnD3LCMSZAkIFnQhupnzD3QHm
fJWECDQI9vJBdfB71v0dGZ/1m+lfr7R76vbtoKCv46UaexD8J82ltyQULjVr
i7xvI2xazTfYH6bQWjGblNeGkPfBoy7iKIV+J36QsRHhnjU9Z/EEhctNx7hh
1awfx1slMaWsz9iN7fZWI7wr9uLHx1BoKXT/ZchD2CIMVzWFURDY5suV2QiB
g2nPXwVRkCaDnKtCODWqK8zfSaG3oqd+Pg3hgenAFQWfgkuf2Gz4049h9fcF
VwpbVYtZylSEieX6Tl9/CrZPje26DATnUBdX/ygK+6V3uuaZ+nMvRmgNpSBv
cHRqK0Dw0Qbqm05TWP3o6/qtnLkvUx7++hyFuYE93dxrrHmPZBrSwTo3ZCWn
rQ9BP8WxibIoHFFnRjVoEUq6IoW9iRRi0bHW+ASh+36r+Xg081+/Pr33MwTH
AlvZ+EHWJ8sV13tErKcVq9zxHwSk/Elh8kOEUd26ftMEgeBq6xclM1/Yzn0z
1EpgSYwJ5DyCw7CsRhjO7IOMW2AcZm1/NS5RpWMtHJkVVTHvaba4aW5EEPCM
jvpKniKsnxEFDEkJcG/KslUGhI3NC5bYWAKw4VBp2Dgzn8IijxJCQJfL85kx
I6h1SxdS0gj8u7+/AYHKRdU=
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxze15uYlLQ1HqTlDMWfTtIuQ+pfsombBUhR53ydT95g3ytSV
mBThxCI1FWVT2EpMQWhilgwrMDPT7q5CxYmKSc4UB928BPV+atCH/4cfnAPn
/M7xST8nV9jyeDw+l11cbLiU/7zGK11VwCPt8YXmYQbmzlSXgF8KlPvVNsaO
MGjRK+spj6JK9u3q1mkGTvFz80cFFA3vkrJmFxkcGts7/NWBIkcX6ty2wmAw
lp+ncqEYlXw0LtmykJ0SLWvcKNzqH60MuLJQ9HznFXhQeFnMVwIlLE4ODUu8
vSkUT/5Is8FCl+1SoZdQfGkLzvicY+WItChI7lh54JnA8N7IosdNsKGJ6988
2a2P/s3itVTdZRBTVM8m6K57EjQO39PNuFOEdYnmnEMIgvpat79xpXCIfCDN
BUHHifGSUCeKKae6D0HHCYqeVmpq7CkSaveoi5MJfDOUDZRPYUlIvv1CQf75
WetQ+e9WEozYZdZGrClAC1LjTWUEwvXu4hnOV5B/5EttMUHfQbsU1UaK/rTs
Nks+gelMnUeriGKnl2lqhBIczm1uNjhTeLfGaLWnCYZMNFK+heJ+0XmlJYkg
/pK608D5uphfmSiOIzCGNzw3+FLwZlR37YIJUs5KhYuBFBLPktIJd4If0b2v
RCEUMTHhC/HrLOq2HasO2MfVhy1Ptk+zSLOvWTYcoKhY2FG92m/lscv89PYW
K8+ZM/vjsli0CwvzSmUUtzRJZsdQFm/NGXK5J0VhfXqto8B6T2NURFXvGgO9
VrSk4eZX3/SxL7Mw//YbLNlkkzjPYGK/NG5USOE3+1DbPMXgxrj4iN6GYknW
JCafGPz/j38BjMci5g==
     "]]}},
  AspectRatio->Automatic,
  ImageSize->{303., 166.},
  PlotRange->{{0., 303.}, {0., 166.}}]], "Output",
 CellChangeTimes->{
  3.825904940875581*^9, 3.825905361598217*^9, {3.825905515070423*^9, 
   3.8259055278869867`*^9}, 3.825907873157694*^9, 3.825908031511757*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["See all the diagrams", "Subsection",
 CellChangeTimes->{{3.825904989304098*^9, 3.825904992335999*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"diagrams", "//", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"#1", "//", "First"}], ",", "\"\<: \>\"", ",", " ", 
       RowBox[{"DiagramViz", "[", "#", "]"}]}], "]"}], "&"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.825904997406891*^9, 3.825905053697407*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "1"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.0033003300330033004`], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 166.}, {
       303.367, 166.}, {303.367, 0.10899999999998045`}, {0., 
       0.10899999999998045`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        24.617000000000004`}, {45.02, 13.289}, {35.836, 
       4.1049999999999995`}, {24.508, 4.1049999999999995`}, {13.176, 
       4.1049999999999995`}, {3.9919999999999995`, 13.289}, {
       3.9919999999999995`, 24.617000000000004`}, {3.9919999999999995`, 
       35.945}, {13.176, 45.129000000000005`}, {24.508, 
       45.129000000000005`}, {35.836, 45.129000000000005`}, {45.02, 35.945}, {
       45.02, 24.617000000000004`}}},
       CurveClosed->{0}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 24.501156448750002`}, {21.99788154, 
       24.501156448750002`}, {21.99788154, 23.632703813125005`}, {
       18.552508993125002`, 23.632703813125005`}, {18.552508993125002`, 
       24.501156448750002`}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQXZ+egvmK+/bdca4cH
D018voUh+MyN2VWPPpvC+T+6hFlM5pk6NFQwsdk1Wzt8v7NtbWuKqcONs1Pe
x6yzdvB88M7gm7upg4Gy+s3qm9YOxfKfHxzSM3WY4PqEtcjMxiGv+uuFQwqm
DkfWnlladMjG4WNXjPt1GQT/5V5DFobXJg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcNcnpDntv6mDvfPXe8/qGDl4MMpk3I229RB
8DZbc6qllcOy9tsNh3ch+FuXJWh5mpjB+Xw//TIDemzg/OwF1jtl/9s48G26
6d8nauXwIfZ/6wMTWweOhPqX989awvkh+3fGBCxG8C8wfuvvzbV0kHNkdFur
aetQpW7SPF3H0uGNyaUgTkFbh0Wv08OsNS0dClwsT8ry2jr47mda8FnR0mEG
R+6cg5y2DgrhF/f4i1s6yEhcEbrGautwRiuHjUPA0sHlDvuzSiZbh+Nted/Y
mSzh7vuWWbDtyjcLB7GSa0zXvtvAw29Ws23lq882Du65Kyxdb1k4vOJeKm/0
1sZBirU8bOF5C4dcaZ5pbi8R/LlrstYcFLd1QE8vAOyw+t4=
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       107.836, 56.074}, {107.836, 46.719}, {100.25, 39.133}, {90.895, 
       39.133}, {81.539, 39.133}, {73.953, 46.719}, {73.953, 56.074}, {73.953,
        65.43400000000001}, {81.539, 73.016}, {90.895, 73.016}, {100.25, 
       73.016}, {107.836, 65.43400000000001}, {107.836, 56.074}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4kscerbv94Y5qGmY/J/30s+B/aeOoM2RMIc/
ExlVfj9F8HsfylgXbvGC8zueffg/s9PLQW7tUaa+k2EO7f2HrhzK8XIocdLa
G3olzMFgYpxYdZyXw6nrfeWy98Mcjm5IyHsY6OWQpLCPKfpbmMOhe4lpD728
HPKtdmhFS4Y7tKRNXfjaA8FnAAEDL4eqAw9XfVYKw+DD1NtyOIuGOiLM+6x8
s443DGGf6fXF/s1JYQ5R6hM/yiV5OWxlsn76riDMYaPq1/VpBV4Oh46yPRIv
D3O4/yRk38PpCH5aifjkJVcQ/Elz+4xWMPjB+Y4fW27xWfk5NFZbiyrlhTkw
X3jm8CHEz4Hh+ZJqsxgE/3Jd8YxJgQh+Ub/TU0WXMIfZB58vCPP3c7gjIZT0
xDjMock6YDmLs5/DM877YbxAvsvh5kd8jn4OF/e5ZlobhjmEL5U9k2Dv53As
pbJgkl6Yg5RuIHu2rZ/DRskHTQd0whx0+V9/2GPt57B+w4M6B02E+6o1H64r
VgtzEI8O+p9l5gcPv5uPWq1KTfwcArTWn/eXB4bv8p28koZ+Di4XHl1bJgMM
T723Hsr6CH5UucyVBDc/B/T0AgA2dvY8
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{43.352, 33.547}, {50.469, 36.918}, {
       58.676, 40.809}, {66.242, 44.395}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.0033003300330033004`], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.824, 47.594}, {75.363, 
       48.715}, {67.824, 41.27}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQbV0y+80zCz8HVY4/bWm3XRxgfEmnc7//n3Bx+CkZ
qXXM2BeDD1N//dOM3aF+vg6fFpR5x9xxcag9EMp4O9HXIcqx4VTBPReH7cWF
bRI5vg7fpfh6+x+7OHxU6+UOK/N1mPJltv+6Fy4OfQzS50qqfR0Y+G0Fvn1E
8K9+9pWT/4fgr2n4nlrN6+rQ2dbc41ji69DebvGeS8XVQWrW48M/03wdzq+Q
snzk7OqQavLrFa+tr0PJ+YUrtZa6Orz+MWv1ekMfOH/WTmWBpUw+Dl8W3lwf
pOvqkHSDbXL6H28HWVGDjG+yrg6685v8Y396O6zTmDB/nQCCfyv3aXwQK4Kf
2CsmsuSli8M1O7u5jwR84OER9dSq5LsdJh8WfratUr22Jd4YfJj6Rp3UqQ97
vOHhGdXN+9R2gbdD/G5xniVPXRymPTu4eN1ab4e5L05dEvnu4sB6OTHn2y5v
h5XrfsRWc7o6rCuS3VV9ydvh99v8n60Wrg6HdapOeHz2djjKu+2BXTMwvBy2
mTic8HEoTJ4kqlLl7hBtn8G88S6Cb6y+yG7vHV+HY1teb602dXUoDAll1Xvn
6+DW0aYwi8/VodqjpWPKH18H5ofWEt++ujhs+T2f9xKbn0Oy6Xrf629cHN6t
2z2JX9DPQatp8omZj1wcJl25Py9R0Q/uH/T0BgBd1yCG
        "], {{
        56.516927460000005`, 43.61787444875001}, {58.371984037500006`, 
        43.61787444875001}, {57.44445574875001, 45.82669181562501}, {
        56.516927460000005`, 43.61787444875001}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1HEAx+9hq27zMFN2WkaURXVZF87D6Yvf3Z/G/4ekVq5aGFJYnnOt
SKTi8li4Hlg2NvMwEpVMKlqdxbIMmae2bKJJrkS6V2frxefF5+X3YfuZuKAI
PofD4eqw18HTsZIUsqgtoBjiq4slSgZRt7UtBysoeCkLfqPnGFwtyanxTaaw
XjLPNKcMhmw0Qa+OU5i0Bj++7Mhgbe5G/wEfiiizsshlCwY/dinkfY4UecbH
xs5uZED5Lq7KnRQNTkL/kVk5UpNVC5ZmFOXKZx5G7+XQiNxiIv+wMJhUTReq
5CiotRqz+8Zik7EoVe267l3FGXyeRqb3Fs130+poGfavyibTf7MQVty17TaT
YUTNdeCaUFjlh8vEHwmE1ts6PCwpYpfTEpl6gtzW4M72fRRd47Zf8lUEJcrM
Q1ZeFELPmDuCVIJKr8bB7GCKuMoG36zTBBnd1x/6XqAIbQ/0fuJN9P1sjhXs
NrUhKB70S5pSUUgnTk21mhJ8DSu0PJlIMbEha37TDgJDRWBpn4KirWivc4SY
QN0rLD7sT/EyJ/TpO0+CX1WLOVwpxV+DFEYQQDA7+mal3J7i0bA4Lz+MYCyW
I+FuofC/OD9smk7QFWU4zplh4V60KJE2ENTVN/aLe1lotxrlqaYIXHzSetqa
WVxxq6r+JJTh9YRnh/QBC0Go0wtLVoabIlsJp4TFytyAQpm77rdOrHZq3657
QobTWiPkiLcrJUvtLCysjzTtqZVjoGagrpyn+8M9ejSEy+j3LBu8Ft1vziBo
0NlLaUdh4N6R4Cdi9PkuffiZ1OPB4H58kyY7gOL5ao27JIDB9MzyZ/vzFA7h
4/LmcAb///EfbsQhXQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVj1yvErqwIcZlRH3BKvdnO4em7GjLxjAQ7V5/TX
3prj5lC0Qi269zQmPzR3989mCxc4XySPU1tY2cXhlofBrYVnAxy4q24tXyPi
4uAcZBm77WKAg2X6iYXNPC4Orvys//yvBjiYvDVICGB1cXi6NC6R416Ag37x
TDnZf84O7UnNmVFvAhyOMkyczvEDwQ8T+XjuwCtnhxyJn75/izD5vyxFbwv9
dnaouKd2M7kVYZ6Ukc/drRMDHNJCts2OYnFxeHU77v696QEOC9gvKczgc3F4
x6jVUjE3wOHWrrdLr0q4OHQV7XCaviDAYYvktK+GOgj+z0n3Wa95IPjl7sVK
hVyuDu7yVtd7OoHhcfxFh+11Fwez7hW5kXkBDkIK8xpm7nNxCPs6x9ogAMF/
cHHmBGkLBH+B9fOjq1QCHIK/vmywvezicHKdbZ2faICD1aGIqcZ/XBwi8y5K
5LIFOCj2H1+pqerqcNv/58vav/4OAivOsAdHIvhWMm0qb2ch+HNnH+qZ+NjV
4eu9+OvdnMDwTH+c/0PRzcHsnuCyP3IBDpL+n13MQtwcVs0Q9RU0Bdp3vvZe
ZrubQ0dh6L0F/gEOtWUnnvEucHMwv1/C9TkfwXdeumhqZBOC32wdmnBqaoDD
HaXFj3ZPdnNAT08AbO8UMw==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3VW0w2n6ggAHS2nlA988XR1g/ENTn6T/kHWD8zus
J/PWJbo5PEs8Pnf1hACHrL6sBw7Nbg4Xf5vpVBQi+IcrbBkqohH819OPSzd5
BTj8PH+a/2ehm8Pj7ymmW20DHGpKU5vE/d0cbocz+b8wCHD4L/X/i6mOm0Ph
05/HL2sFODxw4p1q+scVzg9a8dBq134EvyCUK+P7XFcH+0sOmsm6AQ5Rs9dG
atW6OvBrtPd9MgxwWNsYdaowztXBdev1vGlmAQ5nGZr+r3NwdahZrR5sBbR/
X0ZojoeWq4OMU+O2T64BDltL1F4+lHZ1CPs6x9ogIMChpLREqpDN1eHoQxuW
itgAB6tDEVON/7g4nLfL7r6Xi+Dfmj1TyLUOwa+N2Cc1vSfAwZHv/b00dleH
Ny5xj+/NDHBo4l249rqMq4PSpXWHm+YFOLS3W7znUkGEd5zII7N0YwQfFh8A
cmy5Tw==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcx91dFFJujrjWUtf8OVLKzPn7xu9+P2Hc97pOXBJ2Z0aHyqz8
6cb6o5Uu0tyw2kS1ZCaTG7f+YFlR1gOyswrtanabks5WSvfIbT14PXhtnyfv
9/uzK6dIquTY2dmxrAitsK38PS808iwSRM1mzfe5URhdmv5V/F0CntoxwE1A
Ifwbl2XmEPhqxtc6QcHVf/FhF5cg7Fn9GJ1BoSJeW2jhE8xmpfDHSihU+/j2
+O8hGFRdb1NcpiATifqlgQQhzPFFx7sUnq65zNiFECSyBv5MDlNoFPTvzIwl
mGo2pUlZYhxUiU3lCQRGdcJwgtzml2aVVcMvbN5433Jylw+NnMEDn6VxBMHG
FAXnLI06syxKG0rg97U6smGAhsBH4zUXRFBas/qydY6GxE3tpvch2N2amiZn
MUjaPzV+YQfB60jndqMngw/uoS7RPIJ78clBBfsYRKRz7c32BObBxuitycx6
P+yypeSZQgZNLeZV3YoE7zktN8MqGGysvToyu4Egryi33lDAoHTz3iv+rgQ3
5vSJ2ccYdMkPOed5EsgybxsEKQw0+Qqu1psgKb843BDD4GLyknzIn+CU0+jC
iUAG12qOiLTWvlZ/r3T08Bg0O6QqtYkELvNLCbWfaLTnVpotGQRSxfRyaCeN
jx66khAlwa0H6e+2ldHwetVrKSmy3teO6N/G0uhri9NrzxDwLX780w42N/AX
nr8ZEa/75HJ3tXuqGFSH02P3HIJAWf2EzkShQWWuGooi+MF0euvqbHt238n2
/FlK4fCEqFcqJIgMF245l02t52viObD9CIVH7Er1uAdBxhdpxJMYCk70UVX5
JgKTZntwZACF///xH7xBGWM=
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       299.371, 141.49200000000002`}, {299.371, 130.164}, {290.188, 120.98}, {
       278.85900000000004`, 120.98}, {267.53099999999995`, 120.98}, {258.348, 
       130.164}, {258.348, 141.49200000000002`}, {258.348, 152.824}, {
       267.53099999999995`, 162.008}, {278.85900000000004`, 162.008}, {
       290.188, 162.008}, {299.371, 152.824}, {299.371, 141.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       272.904071993125, 141.37615644875}, {276.34944454, 141.37615644875}, {
       276.34944454, 140.507703813125}, {272.904071993125, 
       140.507703813125}, {272.904071993125, 141.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4htRbu0vDhc65H6pXuNWluiw/8q63mnbCx32
mrcxJFgmOlzw79pZkYDJj0hpzXGzS3TQO70tPKyj0OHAUoG21MmJDlt7NudO
m13oEPfbRlV5T6JDxduNFWZLCx1q5mQeUniM4Pc9PplWyp4E57O1T+a2kEpy
SGXxOe63CKj+YOyaKs0kB3ujhpT6OYUOsX/6YrVNkxzOT3nOvXxaocPKBWrK
pxySHO45+W/k6y90OF/0qXWmW5LDtMxX2rdaEfy5HTskmOsQ/E3JbVb7ywsd
9r3eLzDHKcnhyq/giXzFhQ4/NPpOClolOaw5FvIpJK/QwSgtpqndMMnhXKyS
55LMQofAQ9pnw5SSHNbu2JOkmVrooCVw8lI0T5JDr3B4zTpgeOx69Nt1Jl+S
w4rusGdXkgsdmt4d1jivleTQ9qWjvzWj0GFKaK/pD7skh0LJ3bkngeZ/ddn3
IsMnyeGNgMJ+L6B72r63f74Yl+TgtKylUqip0OGYY/CB4+lJDnPYZEpc+hF8
o7IG/TezEPy/qRKfTy0pdOhWeZevlpDk8M3Ni23RmkIH0VfK5x8HAP3z2uPO
ui2FDsZunyU3OyY5eFVVt9TvKHRQ55nQeU8PwWeI0u1/LIHgC9XM9Lz3LdHB
5a6njej6QofWtfPl5S4lOuyV9lW7CozfxPs8bGdWJjosWd7GqlNW6LBaVMot
NTrRQTPV69K71Qg+f6yYyb0NCP579RrJSqB7Njg1HNoZk+hgs6/a/822Qgc3
J8lN3gmJDpMei9jN2wk0f5eETFFyokOW/MOsX3sKHcTjxT/VZSc6HC18cJXh
YKHD32Pr5FsqEh3Q0y8A/fZGhw==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       182.707, 52.992000000000004`}, {182.707, 43.637}, {175.125, 
       36.050999999999995`}, {165.766, 36.050999999999995`}, {156.41, 
       36.050999999999995`}, {148.824, 43.637}, {148.824, 
       52.992000000000004`}, {148.824, 62.348}, {156.41, 69.93400000000001}, {
       165.766, 69.93400000000001}, {175.125, 69.93400000000001}, {182.707, 
       62.348}, {182.707, 52.992000000000004`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{168.35886490874998`, 
        52.52615034875001}, {168.35886490874998`, 51.629259717500005`}, {
        166.94571527999997`, 51.629259717500005`}, {166.94571527999997`, 
        49.29296900000001}, {165.85194621749997`, 49.29296900000001}, {
        165.85194621749997`, 51.629259717500005`}, {161.91875266874996`, 
        51.629259717500005`}, {161.91875266874996`, 52.52615034875001}, {
        166.32882952874996`, 58.74313370000001}, {166.94571527999997`, 
        58.74313370000001}, {166.94571527999997`, 52.52615034875001}, {
        168.35886490874998`, 52.52615034875001}}, {{165.85194621749997`, 
        52.52615034875001}, {165.85194621749997`, 57.32779653312501}, {
        162.47876242874997`, 52.52615034875001}, {165.85194621749997`, 
        52.52615034875001}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{107.887, 55.375}, {116.91400000000002`,
        55.004}, {128.23399999999998`, 54.539}, {138.465, 54.117}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{138.738, 57.609}, {148.586, 
       53.699000000000005`}, {138.44899999999998`, 50.613}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPU3rWdTkzbEOXVGFd6bf83RYcXmVtu75WIfctR7r
oxi8HFzXWrzzvoLJd/e58pt5jjucz+arpDu5zd1hja9TbsK1WIe/EZ9X6lS4
O4iGe38ouRXroO32cDFzgbuDhIj4RL57sQ5qZzyTLmS4O2xfVfDl2LNYB8Wg
TQpzE90dotKn/pH4Guuw/f7KmR3RCL7HZ86LDn7uDvay3A93V2Py30jo3Z0U
5+7g9dgiR6kPYd4bs7iCklmxDhHG5+feSnd32PugoGjugliHSc9eKUkUuTsc
YLMRN18W63BmJtuK0Bp3h5jyU1dDV8Y6LPux7vvGfgT/deEP9rA1CH6mWo/K
x1wPBykVnyzvScDwWMbYvdfKw4Fjwi4GifJYB5b/25oklTwcNH6tO/cuAsHf
dG218i0HBL/I4WdEpm6sg+sVpua9Zh4Oczb7C/LKxTroLCycvjnew0G7+PFq
bf5YB+G8B6tXdng4HFjD11HLHuvA1P6U8/IeBF/n9zy13H8Ifn/V7T5Bd0+H
448Ls7yEgOHp9qewotXTgeOxsuVu9VgHbj0e923bPR1q56o/OG8L1L9u2oOX
rzwdosvSC+OB7s0Pffiil9nLgfNJ29yNFQi+6KotGhLdCH6oQ/rnjnmxDucY
9zyx/u7pgJ6eANtqCrc=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHVN+6mroylgH7V/Wh8rWejjA+FtK/mZWNHrC+VVS
a/j/HfF02JF20yBrZqxDTG7zowPPPB2WMHjuN6tC8KfV+k82S0Hw9825uc4h
ONbh9bongpVXPR22/Sk7UewW65AXUtcyfZOnw9oYkUfLLGMdPv4U/76139PB
+RV39CTjWIdLimrTt8Yj+C7tv2yslBH8JBPlrHJGTweh60F7FM1iHXyqjkWv
euDh8FBnpuJGq1iH+QnFZz4e9HAQ3/WSMdQ+1mH//VmM+ks8HPw3WD774Rrr
sME9L+9Er4fDO7fJnhv9Yh2WB9u/Tqz3cND4te7cu4hYh7SQXpmPmR4O05/5
TTdLi3XQWVg4fXO8h8Mi51q5uWUI/poFq5cytyP4/rEX1oZOjXUwfsv+8FmW
h8M+z4KyuYtiHUre7Fwf3uDh8OXagTDH5bEOlWmBH7vaEeEd8PmXxfNpCD4s
PgCVisLe
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEcxt2KLohQO2TSHK3lVnNJK08Tv//5i6PM7GA/lxNKOx0dccwt
zMgYwzouaxwtl2TqdM5GpbnM5rJsNZfcM0utlFV4Qaj/K2frxfPi8+L7bN/n
eY7HSq/F6evo6OhyOsVJj5Nop1Y1n0sxvKhRdH5kUVa8XJ5XQLEWekAY+Y7F
sVJ1seFdCovxM/k1L1iQ0ImFy/EU+g8kHX+rWcx4u9ttR1KEr6tupueyGA+r
mx4Kobi3krTwLZGFnl/JmDKAosHSTRgRzKIqu+P5b1+KkogxlLqw6As3lig8
KHZ6Wj6brwpw4mhOk9yFYvOHf7pNnZbVybV78ly13NS2z8phhMFab0WL0p1i
f7rqpG86g6HyJKH4EoW5JIuoPRkkjG1b5jEU0VMVqQNmDOpteVXdwZxft88X
k1WCRl3V7G8Rd2+XX1M0Q/D0E7HniylicgYDDPoJrB00hYYyiqDqRD/PZrKb
z95Ae6fKAgIHZyvZWA6FS0/akoecQLjuNWCWTDG69PDX/UKCxTvVesMJFK0y
/3NLCoInjpm5JVEUmviUroBGgg8WiRniMIqfy2WCIjXBe7dRd9cgCsXLK2Um
AwTDm9IQMZeXj8hornKeoEue6ih2onCWGZ9/Y85AxWOUWzYUXzf4ZaaEgTzh
tHW3OYWM97o5LJPBBc0hRa4RxR9vYU+9ikHDdN5orD7Fyshy1NZ3LWd7W/XJ
nQS7HBct1HV7LMDhyVdTc5YUprq31W0HWfQfmTJ29eb2kHlDNHFd22expu7W
1SwWBu3Fk8pArk/eRMrbcnb3P+kzkzTyiEVrBmPLj6Fon+292KlmEegl4adJ
Kex9N5izgyz+3+M/sKwoLA==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       122.98924642912498`, 50.39521844874999}, {124.95805647599998`, 
       50.39521844874999}, {124.95805647599998`, 49.89895331312499}, {
       122.98924642912498`, 49.89895331312499}, {122.98924642912498`, 
       50.39521844874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4v5J61/MKIl3cDykUFewyssBxpfwP3X0zE4v
h3yN3VKHJsU7KDn/9DA+4eXQuMen5evaeIcf5xdN6L/u5TBhheuWr0fjHc7H
+Nx4/czL4YeHvzHXiXiH9D1OkdefIPj8Xzyyyho94PxpwlVyJ1I9HI6bTpsy
81S8Q7evz+TEYA+Hv4eeldiej3fYYWXVa+Ht4XBWQvfWmcvxDj4KM898cPRw
YDvjEc91L95hvRs31yUbDwdBzfJnBe/iHdyXMXbvtULwuRWf/63X8XDQWl/I
JVeGyYepT++IMPnaGu9Qe7/13HFbD4e8/bvFDk2Id9hyYJE3q4uHA/dMz5sP
psY7BOfoi6n4ejjcftdvVzAr3uFA24Vr2WEeDitvX5v/f068wxmff4mXMhB8
F92zaxtaEPwt6l+Vv+Z6wflaZkfTF7d6OfDvF6mrmh3vcC76ZfHXqV4ON1sn
WBXMiHewKusysZ3vBbefp3OOVdpyLwer92bXt/fHO6xM0vrbssbLIeOOysW+
dgT/TPY0oYIWBF9/EkdAYD0w/KNnO6Wt9nKY6F/daVSBGd8wPgCVF/QB
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4ktMBqVyHgkOpx5tmbbjvpdD8MOprq89ExyS
nVaLL7mL4C+6uXylXoUHnK+zsHD65ngPh7d/w9MLvBMcdvNYTrXw93C4FpT4
osUvweHlT7V+fncPh33LszJnBiY4PKnv971j7+Hwbe4uX9uIBIdHaye43rH2
cPizanuibVKCg/syxu69Vgg+t+Lzv/U6Hg7nrWbmXZPG5MPU796aO6VFBWFe
xM5E1QIthH3Lo1Z0/NdNcAicZcCn4unhcLjezFPOKMFBea2TiG+gh8NEJ/E7
D4wTHP5tbp57Jx3BXzf/qsnULgT/9gmfKzOivOD8D00rH6VWezkcDr1QFWiY
4HCcP1jrUJeXg1qN0w4jHQT/o9O+Eg1NBH/3/ctJgaoJDkfSd33oa/dyaA1q
blqrkODQG2O+tKXByyFoTYpgAZD/KWTFq9R6LwcLl0UfX8knOKju0VUrqPNy
eGV6MEEDyO/eMi87sNbL4cLZfw6L5RIc9kqrLI+u8XIIkPxvt1gW4T7/9zMK
rskkOHQ8mp8cWOkFD793twRWGlV4OczOEtE/I5XgELxSWsG9zMvBN8Z4HieQ
v3NhT6pGKYKv0aejV9Dk5YCeXgD2Efyo
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{134.413594861125, 50.63522576874999}, {134.413594861125,
        52.38777921999999}, {134.942360988, 52.38777921999999}, {
       134.942360988, 50.63522576874999}, {136.693664401125, 
       50.63522576874999}, {136.693664401125, 50.098959413124994`}, {
       134.942360988, 50.098959413124994`}, {134.942360988, 
       48.34765599999999}, {134.413594861125, 48.34765599999999}, {
       134.413594861125, 50.098959413124994`}, {132.662291448, 
       50.098959413124994`}, {132.662291448, 50.63522576874999}, {
       134.413594861125, 50.63522576874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/UQq6uvciYkOXVGFd6bf83TIzd9zN2t+okPuWo/1
UQxeDjYxzPa/FmLy3X2u/Gae4w7ns/kq6U5uc3co0OmoY1mc6PA34vNKnQp3
B5WNPAf4liY6aLs9XMxc4O6wtL9owu1liQ5qZzyTLmS4O3yNkj9kvjrRQTFo
k8LcRHcHt52GxxI2JTpsv79yZkc0gu/xmfOig5+7g+WUHItNpZj8NxJ6dyfF
uTvYlzPXPa1DmCegKNbA15roEGF8fu6tdHeHH6XyjModiQ6Tnr1Skihyd/jF
0Xr5fVeiw5mZbCtCa9wdPBzPGNX3JDos+7Hu+8Z+BP914Q/2sDUIfqZaj8rH
XA+HZeK8f382AMNjGWP3XisPh3m+Lh4JxYkOLP+3NUkqeTisa7Jb752C4H/+
sCfSMQLBv7w0+UuHX6KD6xWm5r1mHg7p9/su3HJLdNBZWDh9c7yHg/7+G7JZ
9okOwnkPVq/s8HD4Ff2Oe7J1ogNT+1POy3sQfJ3f89Ry/yH4/VW3+wTdPR1q
v8vX/nQAhqfbn8KKVk8Hue8VTzZ6Jzpw6/G4b9vu6RBx5Zf5njCg/nXTHrx8
5elw/MAsBhage/NDH77oZfZymFe+Sky3BMFfEuUYk1CL4B9ZOuugRHuiwznG
PU+sv3s6oKcnANniDFw=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7eF4xqi+J9FB+5f1obK1Hg4w/paSv5kVjZ5wfpXU
Gv5/Rzwdvu0ITuhsSXSIyW1+dOCZp8Pr1u7l70sQ/JQjfRPfZyL4Py4Hzy9J
THR4ve6JYOVVT4cvzUo6fNGJDnkhdS3TN3k6fDD+uGN5SKLDx5/i37f2ezrs
/pVTOjcw0eGSotr0rfEIvkv7LxsrZQQ/yUQ5q5zR00GpUEDtaVCig0/VsehV
DzwcuOZsvqETmugwP6H4zMeDHg5LH90+URee6LD//ixG/SUeDgfvMu++EJXo
sME9L+9Er4eD4MoNb3TiEx2WB9u/Tqz3cFjXZLfeOyXRIS2kV+ZjpofD04q+
ye+zEh10FhZO3xzv4ZC1XPW6UjGC/+HqHqmwagTf0eS8XH1TooPxW/aHz7I8
HCq15JmVOxMdSt7sXB/e4OEgUuj+uaQ70aEyLfBjVzsivAM+/7J4Pg3Bh8UH
AMcZwv0=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI02EYxqdWVkZpKbJ5KK2WszRJMahtPNHy/9/XPCAkLBX5RFsZUXZA
c2KBoi5FSzuqVOYkQ5odRs3UVJrTjdTa0spT09AQD5SWZDdr3Sh08bv4wXvx
vM/7+iWfjk114nA4DnYC7Tj+g11pE72k2N2WOR6ewUDhMLx+WkuxKtI/qDyf
wRbO4jXBawpu0oRDkJpBUZXi29oOisB79T2GFgbtAl2nxkhhESu8ZX0MJJW5
aWwPheZQXe3gFIPH6uKZBDMFn5/xQ+XM4qtzhi20n0JotdjiAlh0c2V+Y0MU
xiyb3JzCwqepLC/dStEdSQ1djct+sS3nsoQvXfKCgg1nqlVShB1TOSUOU2x9
pUjMHZKC5PCeKD9S8DorxZs2E7h7hdxVWygUyR4mnwiCercdXld7Kdyzj8v7
UwgC7sdnLpgoWry2PYzPJpjb6HI71kBxxz81ZKqMoFr7u1zQSjFSqUFpA1nq
5+cRl+iEdwTRcROlHB2FaUx7U/eFoEAWfl5t70selX1d1EsgLsmPY/UUue1m
2WgrwdHn7p6KLooIoa615inBm2afCuVbChGrEopqCCKCJ4Ue7ylSJq3T1lIC
o5GnUdr7mh1wfbQnkyCmyFOvHKWwtbscXiMh6G/UODdMUkj2zS282EBwrlxo
6p6lKCw8++HWgBSup0zF0/P2ecVIU3StFCNyt1nlAsW6vgPe8yeWvWHRUR8l
WPYuizHvxjMW2+N/pYlnKHxD681cwkK2fyLGY5BinN/hz51jlu754FIW78Jn
Bru+F08l2PMHcw+6/tEzS/tdmfddUadlIFdp2IpOCpnhpGhvDYPVO6sk6W0U
n5LCQptLGPz/j38BrJg0NA==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       153.35200000000003`, 115.695}, {153.35200000000003`, 106.34}, {145.766,
        98.754}, {136.41, 98.754}, {127.051, 98.754}, {119.46900000000001`, 
       106.34}, {119.46900000000001`, 115.695}, {119.46900000000001`, 
       125.05499999999999`}, {127.051, 132.637}, {136.41, 132.637}, {145.766, 
       132.637}, {153.35200000000003`, 125.05499999999999`}, {
       153.35200000000003`, 115.695}}},
       CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
       
       "], CompressedData["
1:eJxd1Gk01mkYBvAXiYw1ZSmSeJkSIWKocSGa1OhIc8byf17PQ6oTqaRo0Cpb
ymnKSYs1S8soWzHDGRl5iWmoVIppwcRQSYQo5v3C/5z5cH/4fXmW+1zn0vff
uTFQRiAQSEmGSEZaMmbZLeP59ylapBy37jQmmLLU9lA3dUsCVVfZotaXFPvs
V3U/WkUwcGiFf8IbioIz9lXZawiWpl8oXjJEMdL08FD1BoIOp/PxNp8ptJ/b
BlX+SKDk9OdWXxmGwCPN5r4BBL//urlaXYFBvFuqq3EXQfpQSuiduQxx3QGu
pvEEcB/3mZzPsGnhz7llubzX93948Y+Yt6H2u+XnOgn0rqSExWgyVDLdqsdj
BAFPzBcZKDOsGi7x+kNRBIMTgT+YyjJUJbp9KFggQl3D+QVqnygEj+ZWXTIW
gV6X6V/Xy/t9ZkYDaee9eG/IQc9miufiwpbLeiI8fDGr9ngtxbak18u3qIoQ
7ZarcOc3igEPndMGUiK4DuRZjhRS2N2LFfb1EAzHXx46mk/hNCHsq6wjcFFT
vdCYSbHjjJeYNhK893WKWJZHITzy1ka7myAp3rFr7jWKtrSjWffHCSzylFyE
NygsL3b7aSuI8Ljmaa5VCcXp41rqiZoivA0PPRtbTjH001rxmKEIaf0KA99W
UUDv1fFz5iKkN2XFb2+iUPZS6TNwFyFTy9ZQo5Pi5NG8Q8mcCE4brXKiPvGe
2t+UfcRjd4R6DLbvHMV1HiJYqPodLjBhyMydbZ9oJ4JmxPD1YluGiSCNCgPJ
/fX9J+WDHBjkZ96M2TuTt+zfcR7pHWTa4ceEFQkNBAXhyemrVzI0+nCuY6UE
nyeHVydZMyxJ9GtQzyaoUxnd5bCMoeR1itAjmUBWzTQ7wZBBR25L+ulIgjkb
7ka2zWFI1pJRnNxCEFu7NGetkeS98zK+L/MieBU38izQkuHSpZCG/d8R6OZy
JnJ2DPoqreYnVxAcOHPiefgahj2zVUsntCX5VzSyNXdnWOnfWegzyE17+Fjf
L0o1vF3vfhQYx3Jo3Vcdvc2ZoaPw7LwXmzhUd5wa6jVluCYI0rQ34yDoEgut
DRgWB7dEb9DhpvP+YMeuKjlliedMPkuV5DOq9StZyHCwaJRadvAjhZFzvlvE
qC/s2m2SorooVJOVvY0GfWHVZBfx+QFvZ6UnHu41vINrQlPEtyjMrcIcskZ8
YbI/v765gGL3AQfFswIOvWbt489yKIrrFZ4mzeJQEeSc05FBoXtF/rCRBu/t
tzLcXIS8b6+bIatkzqH5Vvup0iyKN24rusxt+PNMlkoX5K3kIJvfFih1mYLp
SB0edOKgYabcNiHJc/C+e/svukj2E4Fy/yLe3W6K8y3LeNuUKHjn3qbQt7cu
j17FISFG/kLqPTq9z7FTwVWxbXR6n81tzZHKPRT/6s8q8lbnkDX6V4XjIG9d
OtnaKumfKX96fFftppqkX6TlvAf1OLhEsieeugwLH1iXfvlG8t5UP824rxlq
wixsuzw53BfUBm4zY8gbHY3BHt71JOn87FTeV195doeUcTDpHJ3hvYQhoKnH
y/ghh73fjpmtX8QwrqnVtbmXw43I+u5qbYbiiwUeadIE76K+aCmqSPpqkdrL
InUC6Z7JkGIBQ1ikSvkBXYLqNKvsyhGKq0HKSY0GZPq//+/rKf8HxVeLRg==

       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{126.082, 102.16799999999999`}, {
       120.62899999999999`, 95.027}, {113.809, 86.09}, {107.62499999999999`, 
       77.992}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{110.348, 75.789}, {101.5, 
       69.965}, {104.785, 80.039}}}]}, 
     {Thickness[0.006600660066006601], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQLbv7ZuTldxEOm3/HfuxmiXDQT5mnlcsV6aCy9GRU
rmiEwxlbnbfd/Jj8iSX8jE6Pw+D8DyXbZnbeCHMwvmeas0Aw0uHNL7mIsIth
DnOe273fIhrp0PxR9Krj2TCH+Uu4JvhJRjo0mHiZrDgZ5mBnnfKZTSnSoa68
bjLfsTCHh987fkcYRDp42v3yZzmM4At6rMpO2BPmcGztv/u/t0Vg8J9E7Sns
PBLmcLFYJzvpZATcvOLjgflbrkY4SL3gCdIF2udSmFJ493aEw/aDs0R8zoU5
uE/XFyt/GOEQMlvjetblMIfH7PuuTH0S4XDg1J9/EncR/OR2Rfbs1wj+osTs
qRY+4Q4Lt9hndp+NcJiouOzEPKNwh36Fdf/DN0U4fDjbcMRHLdxhfdeis3pT
EHzL9PlKUjUI/s8Lb8JXZkQ4TNix7Mg8g3AHZRdnAd/ICAcW+XvnJF3DHTYx
X1+V7RXhUN4qenNKZLiDuy1T+16nCId3ghIdK4sRfJYzJdPKpiD4W7knnzqx
I9zBryQ1s8s3wuFkobLNn+tA9xWLW/xOinAoTl2tJv0x3IFFT/o+f2WEQ/PS
gs9buCIcHrFFF8yfHOGg+nPqdzZxoLtKquZ83Izgz7FaoR5xDMG/cyHq04mb
wPDzb/56VyDCAT09AQC38BbS
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zh935WpTyIcmr2dU35nhzvA+Cc4VCz+XEXwV0X/
5tr/PdzB/vsZ/VVXIhxkWNNLFnBEOGhPtNlXthXBl+VznlQ2H8F31T27tqEv
wuHxUvGeP//DHWx7s45vboxwWFKRcrT7XbiDyVv2h89KIhzSvDf+k7ob7nCq
6n/kpbwIh7D4HeekjiL4ApMWKd5dhuDPe2G24/fUcIeZ6W67EwsjHKZ0cxhO
bQ13yNjbo/CxNMJh77+4lxZl4Q7zvO4yTK2KcPDd96k5PD3c4ZqD7lMLoP1u
RTFWKjHhDqXX2zw+dkY4OP448uNDSLjD+q5FZ/WmRDgs+JE90cIr3EGu3Gla
2cIIBxb5e+ckXcMdNK8UyN7diOAbG85f4nwIwb/29vCaqRciHNhdVxZvBup3
vZVcevduhMMKF6bb2aHhDtXpW0IbHwHDk/FcNWskInxFTyyavzkBwYfFBwBZ
OcLP
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx11Ok3LphbUKx1AmU7nU0nD2XWyisrD+/9+zMPfklEtiiai5
hGOUjcqa28GRw9Fq6myFkeMQq0bhxHIsxiZJl6m16Lxi68XnxefNs+f7fB/b
qKTgWEM9PT19HU46DHRoS0sfCTsJo905gVb5DDutpm/39hDO/25xSrzO0CCU
Ffu1E1aVIlVJIsPrucHpvDrC8q6pj92RDFFDjjbe9wiW/mtH/55lCF24ozEu
I7SpwlI7AhiK3+eMagsIIk1nyyVvBqG5vN0th+CeVWZvdIDBf1Hv4lgK4bMi
I33QjKGlObXxWQJBrDqBwFl+w/0Kv2252bbpPXudSkcyeWQGF8i0yYTU7dl3
I4N5nLGLCZRm6fYVzDbtduXxJWbFojeXIHye2GUv5OHQblq5LtHNO6hKV5vx
cC5vmHSrIFwOn38jMOThluZpG1dNqC413n98lUN9h6zAr41QUfWhcXKB27jP
1ytP7xdNcGjtMk6xeEHIV8ykTb7lMJbv3B+kIPA93zMFGg4XDEr0t0kJL28N
1DzWcnBRJt0YriKo9SNm5uY5hDeGXZOWE2J9l2SCZQ6st/9wchHhmHwoQP2L
Q5AkOliaTTDNfLhSJODhszXBQRpPyDNqra3W5fGQe9Z4MdL1oHyl9uCxtmqz
Z/00oWnSYFwcwqPPV1DR40NYXDz1yTyRh6M4faReRIg5YuneJdn0NrHL7B/5
pteuDeeyeR5V8YoJ6yDCz8Cp0EpLhpPNwybJaYSrJZpDcr/NPp80/1AuhDBI
RDnj2kLC0rkdIodwtpFvX5Nzd3Qcg6uJl3XcA0KfV4GdVRLDu4GIfcoWwtpy
nYwyGP7/x38W1TU+
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       103.91502742912499`, 94.72725044874998}, {105.883837476, 
       94.72725044874998}, {105.883837476, 94.23098531312499}, {
       103.91502742912499`, 94.23098531312499}, {103.91502742912499`, 
       94.72725044874998}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYjHlxc9vrI9y6Ftv6lSRFeEA4/8q5UpTK4pw
+LZjnSTTuSiHf+8XLo+sjHDg8HVoNn0Z5ZC1rew0e2OEg7il5WZTxmiHqzXe
77d2RDjU33Qy8mKOdli45tj61e0IfukJT4vfoeFwvmVEkpCKR7iD37HOyTdZ
ox2MS0+f+WAX7tASfKu4liva4VT2Ic87VuEOISsVbvLwRztMuVeYaWEW7tAb
YxPnJRntcPSjFsdK43CHGTuznm7QjHaYqLjsxDwjBP/zPQmmBu1wh432qZxx
G6Mw+DD17yR8jE0PRjno2GW8UjYJd/jqv16U6UyUw/F131Y4mYc7TNK0vaFw
McphOost3yXrcIek+mbbDVejHM5O7H1X6hDuYJBzap79jSiHyyUqJis9EXz+
p9xRDeEIvscj+alWPhFwftNL9u2CEREO0/w5anddi3II+SO51yohwiFBrMVy
w+Uoh+7OrLn3UiLg9n+ZVKzwOSPC4WC91rXvp6IcDtXvamzKjnB4nyNx4dwh
BD/4T6fghv0I/jalP34Td0U5fP1dpPIZGL8SD/I6ijZjxjeMDwA3G+jH
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYq1pwS9rTkc7XN5f7yfTGuGgGyzfJXY+2mH+
+198Qi0Ivr31z/DwwHA4n0X+3jlJ13CHpJ7FZxUuRTucvnLQ945NuIOR2bbz
njeiHZJO7zh13CLcgfnBiYtF96IdEvjeauqZhjsUncmYtet1tEPc0reqesbh
DvXPkg7t+h/tMFFx2Yl5Rgj+53sSTA3a4Q4qbGp33hRh8mHq//w+p+7ZgjDP
nHm7p8IEhH1XXV0E7KdHO0ybbct1yTLcgW9CwsSa+dEO/5e49T6zDXdYJaq0
nXFxtEOuxvNAPU8E31VuwtyuKAT/9ibv3B6nCDj/KX/Vl09BEQ68NlO+PJob
7RB4zU9iYVSEw+WOivylkxH8TLGCFxN6Efy//rOPPGqNdghoaqpmj4xwmGj6
i3l2TbTDlj8HQptCIxy0Xu5RVADyn1dU/vgUEuHwTcLikWh1tEODjo1YBZAf
86f0wITKaIfNK77seBEc4aCh87GhrSLawSdm+7VcIF/t8MeatjKE+1TzVR+8
KYl22GT/dcuLwAh4+D3ZvTY8EsjfkyoTe6Mg2kFc2XhyckCEg5JnlHVwfrSD
1/zXplf8EfzGqdZSFWFA96GlFwCVbPsz
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx10yygplViNGNCk7zlFLafXdEmuZ5vb//+LhBR3huFYWcpkQ
oSM6VhSGhGNuk8uSNI1VZI0JneaSOLayWiVzzHReOVsvPi8+2/Pieb7fxzok
1kesq6Wlpa3GQY2OGrPNutSuCEJ281yC4gOH2Xi+fI+Y8PN6Z+mdSQ4+sYU1
0hsEVereLE7Jwb4+yss7m6BjeTPywB8Osv6dRqVSwsQyM1nc5FBW+8Rv+AHB
LX5t3NGQR1R3Z8BKJSFjbnZ92z4eE2n5aTV1hPzTRpmSQzyaqo/1bz4jjBra
OTV48Liw0J9r+YLgt+IfZntV4/Lmy2dD6jUu3O3YY/yJR7Jr6+2VDkL64am2
DF2Gp5LRGZGcsC68Vv3WlsG1dqMnq5pQtSlY8nJhCC/+1hFYRkgsmBI0ejCE
tvjF2RcRPKnrY7Qvw19Ze8tsDuH5DP+oI5jBd1JaJ00iBD1OqdGPZlv5XFmT
O8SkMrSaR1aekhDG+tK9LLIZrAx2hGclEsoSQt9PpzDczZcfGc4kCFqkDU4J
DIPjg03bCwhFUdrzJjEMD5cm20UyQsGviKrpMIaKodg1cTnB6nVJklMQQ63O
mEJUT/ja08Rf8mZozx7Wd35JiBY01rsdZ+j9opKWjhAKJRVp5vsZVkvMTCcm
CW3Fwcv5OgzC86JS03n1/C3TOaWSx4jNq0DnJcJvF/eiE+80fm7ooFjZoHEf
l7yBvBgeZJfr3z1O2FAmf/c8yaNxIcI6rI0wO5cj89yl6fOMNOSeSpuH5GIX
t6LeX0/hbti7ym3d5/zmqJ7sB4eBDJVxXB7hvlBRpVjkYDMwbmCZQghI67Oo
+Mzh/3/8Bxv5Pbo=
       "]]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{158.512, 68.492}, {155.359, 75.223}, {
       151.586, 83.277}, {148.059, 90.812}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.2, 0.627451, 0.17254900000000004`], Opacity[1.], 
      Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.2, 0.627451, 0.17254900000000004`], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.85500000000002`, 
       89.398}, {143.785, 99.938}, {151.195, 92.367}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1HtQVFUcB3CGHUBxIBMSkKFamHCQyJGUxVHabxCMvBK3c1dencMjiocI
yhqKAgXKwylFllCTBmTkYcAEOLyEVQh5qCAQyUNBqcUpAlJYMcmgNnbgztQf
d37zmTn33vP7nfP7CUNiJGHaWlpaRP38GzO06vykKQzRoa06UikHXZM0q/t7
eTsZDOglU4bcAbNr824ccOtiqWkIg8psrqbEkfdxO26a2fI21Jc4expx2F93
uvCxH8OduPz4e38ThPoHm2e6M2QL6vcIZgl8F+xzLLczPHaTu1cpCbxEOqub
rBkmu17oJY0QDPd2L2Id70EjbVpiyDvfovqIYBVDvY9LmMEoQVdt/wAWKU5M
KGwED/7vs4m75Q4veLf37zxjMEfR0OAcYfCQoMWvaPe9abryvZOhXJTDLxQp
rbPHI4aI5r0xivULFsGNvQTvq6Jd2TDFy6lpr2XcJPB0KLzUdpeiZG3SubhW
3vqiJ3fJNd75sebVxbUEQn+vX4VKigjlrT7taoKwyNynbQsU24zcsp9XEmSp
Ug63ixnspQkztIIgwul5UJOEoWu100vj5WSl3p3KA5EeJQQV3s7RQdEMc8fk
HenfEJj3/byl9DBD4814Zw85Qf23sU/bExmu2LwSmJjGeyQvylgYzztPt8G9
MlR9Hlk9byfLGOiwTqpYwv8v3Stwh9KZ4E8f33MyVwbX+dGeIVuCxGcz+nJL
hsFDTmvOvE6wedTV2HKerlgSrZOePcZ7qW63KQwFpya3vkFQMLyhtvgqRYJ9
iJHyLaLJ6zKF93nUFjkS2Hib6mUXUFhGvPph+Hu8//iis+DGHt4fNeV1Hgwg
sNUfL7G9RCGyOhq1LUx9/r31t4fLKJx011WF7yeaOldTuEyUPrugzn/pnJop
qva5NypTCL6rHEvCDxRpWapFcRbBpws35rU7KawiP2+hXxEcSLWr71GvV13v
sP79PEFMe7CJg4Ku1F9X4ZsjbFDvbzsLF14kiCrIPZhXR9Fxuqi7soj3lumE
aVrGeynWEAx8HJXrcZ1CHCszYy0ExpA0C3sojo0FiB16iCb28fdxg9WEDjdE
NfdykMCy1XNK+Iiu9JdHd2FBWz/FqdGp8ogpPp+c5tTZvDk+/+V+Xd7/qo2N
f5nocxBofalKr6GINwpoYya8U2Izvdo38t601vVrTzGHnR6XZW3qeog2ib/3
/IBDhcr4QfEdikMC6ynLUE7TZw8pPgsicZlxHGzrEmIyVBST1jZnRUc5/Ch1
UBisYSt2cRk4wZnyTr6iKHtTPS9+U9jIRUc4NFoV9Qm2MniPX+g1lXEItFp0
bHqHYf1ezyeyGA6bT47cT9rF8JNFR3nkPg7aM1eT3lX3U0Kiwk4ayWGHj/4n
j/x5L8/H/3p5Pv4D951aCg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQvf1P2Yniu3EOQQfy9pv2hzis3/CgzuFSnEPtnCPV
NxtDHASb2+Q7Tsc5lO/UNVtWEeJwx5PpTu2JOIdb9+cXtxeHOCwXqJtRfDTO
wZZNaGNGXojDsj0bf988HOdg+cCN53wGgn++qfCNQjKC/3vTZNe48BCH1Wae
trxA82NkrB4t9QtxkFJ+yRp6I85h78010u3uIQ5hky9o6zyLc5BfE7TnnEOI
w2+eg1fEf8Q5tKhNnOZpG+Jgm2DvoMQfD+e/FJh8+pY2gj9pg59kgnO8Q3DN
9d83HEMcLt5lfHAhJN4hMj7Pkcc7xKEs/FPHnrR4h2OV/EwhIUD/b3MsTMiP
d5jl+XaFWAKCvyTIf/LjPARfIPdDsDYwPO4n/Oa+mBXv4JHsYHG+LsSB55dM
Jl9ivMPGHM/dj5tCHNjE25Rvh8c7bNYUjaltA7p/Z/icEvd4hy2TRBJqO0Ic
gqTm+L3XR/A5J+xikOBD8H88+6pf9ynOQcZY7v7ErhAH9PgCAGm8yS8=
        
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3fpyrybzgziHGOV/FntsQh1g/INsNuLm1gi+92OL
HCXlUIfdZXxcy5/EOSxl8Nxvxh/q0Hf3zZrMd3EO54rnl9/6H+Lwm+fgFfEf
cQ4/nn3Vr/sQ4jA34dmNTJZ4hx4FRZ4LL0Icit/2KxwTRvA99uYe75BH8P0W
sPDu0Yh3+Kqp1f/kTYhDkNQcv/f68Q5TDjR/mvM1xOFjjKYon3m8Q9rlqT+O
/g1x+Cz5detyq3iHK2Fme3k5Q+H8cuHoo/HiCP7ryknnb2mHOoQ5pH/uMI13
iHtw8maoQ6jDNge+ngta8Q6X3BifXAgJdaj99pFrslK8w93F+tnmqaEOTreu
NYaKxTt4ZLH0P80JdbhokC1RworgT9Ns/jbnZxycP8HtzYbMD3EO9xN+c1/M
CHWICJhz5ujLOAeHUwtXSCSEOihG+bxQfBznkLe9f9H7cET4Gm9Y3iDhg+DD
4gMAX9W+Sw==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx39E4iZKQugyRQ/UjBY211tNXF1/dH1/lOH3ZdMVNnFJD8ZN
cnWtRQ+mZNVRWrOLPD/VdjO3PJ1LK+SZ2aSspmuYWr+/3NYf7z9e+3z+eL8/
n7dHQqo0cQ3DMGa8dvMy5+VQcyVetJ3iTFr0seFZFpol9YkCL4rlV9e9906y
MC7n90rdKVRJLlpJPwtVnPPltM0UuZ31X3I6WBCDrrhnA4VmeSCgrZmFgVsx
+ttSIDPwfMZrFmcjF9KF1hQGVXGFr5qF/8K6+AhLig7fpG26QhYFWll2wB8O
CkrkN+UsfuYMNTj+5vD3omfIerGJh4J6zEM3mph8srh1d5xAu+t7k2iFw9q2
U/c9Ggi6shKrGAveb/3bssEHBFu2VjoUWFFUp4hbpnIJDhwO/qgRUAyNPZEr
5QTNtZaZEfYUlvba7nYZQYiXwWVyE4UfpneYxxBkHFF2S90odkrq1CXHyep9
8rwKi8QhBEtHG0ObPCmcaWt6yX6COxrxt8/8/tf03kvt/HwgZck6wIkiMqjs
cXoYQUt4stjRgSK6Jnj0uYRAKkroYOwoFo268vaTBPruIk+ZDUV3zItwZSyB
xC/xDcPf66lP3rz4HIFqrC/Q7BcHp6b80rhrBDm56upHUxyMWfd0ylKCMH2+
T+wgh6DbI/17GgkEbskVQj2H7FLvcf0HgtRDI9NMJ4fFGeO+7B8mhrtgosWe
XWX/qgqFs4TFxEHHuavDHG4wDacjFSzev3toJ2MoBKJan+RK0z+PROvrXjay
mLVZuCDk/Sts54JntOxqvsYoq1bPLhataQanST5/1DwVDvN9su2bchW4UhQ+
yyp3GWXxfx//AQFaKiI=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       130.09264412112498`, 84.30146844875}, {132.06145416799998`, 
       84.30146844875}, {132.06145416799998`, 83.805203313125}, {
       130.09264412112498`, 83.805203313125}, {130.09264412112498`, 
       84.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr2/LLWz5yY4KCYK2FucD3WA8XvVnyY9uxbq
IHeCS2zDmgSHiQtrlkjeC3VQn3T5lOeuBIe/6YEnjj8NddDnuPDI81iCQ4ae
2pvSt6EOyTdClEKOJziYxC1ck/0GweeoUjHdvSsEzj/Dacv/ZE2Iwym/H5dm
n0hwOKa27OSGxSEOqVMVDr89leAQKzvXbc78EAffA4dLTc8mOKhP8En7MSvE
4dXMQIuQSwkOEYtZWTNnhDjkn3hR3X4rwUHlcsPRuOkIftuEz//sJ4Q4VHM/
442bh8mHqZequLnIc1mCw/73Ts8fA82bK8wtsmF1gkNUwsWlTHNCHHIYgkrt
1yU4aG0T5560IMQhRPurevuGBIcE54zXpktDHHYvnHHj3MYEhzS1/waZ6xD8
RdOehTnsQfBvTf418deGUDhfdPajzRf3hDrkTd7uzgPkP1/7ZeevI6EOl8u+
qravT3CQs3adNe9kKNz+dhc/2c1nQx1aVnt80QK6L9Rwap3ThVAH6UX2hWLL
EfyzmT8E25ci+P9qNm74vijBoWOtr+JmYPyuv53lmzEfM75hfAC9Svhw
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4h1md2tztRMd0gqjvO+8DHWwFHX2s9JNdDBa
eJX70gsE/9KbyyHi20Lg/OkXdpy+uTLE4bIha8F+vUSHuLY5XnMWhjjsaeP7
eNkw0eFrzeTj7XNDHJbcFi96YZLo8Hn/cbV3M0Mc7lxMD+uxTnT4GHZC6d30
EIdH91KyelwTHVQuNxyNQ+K3Tfj8z35CiMPWPLdy1f8JGHyY+oUvpeZeZkeY
Z/eWT28/L8K+3r7QiX6CiQ6avhLsk+aFOKzc/DgwVzTRYVKYYteyRSEO5WVH
nuiLJzow3Dro924tgn/jfNYsr/0Ifl6KWpbP8lA4v+JgyMdN20MdVnbWNi8Q
SXR40q4pmrg/1IFnw/sDjfwI/vWy7NpyHgR/oXBj9gKORIfHxrEVx/eGOmS3
GXT/YU50cF83O8hpV6iDxQNBqf1AfpVWyNdNO0Md5Cr8f1kC+cL3xIQtgPwL
mXmZ5UyJDm5R57eu2BHqsI1xjecnxkSH+7yTLusC+Wa+a9w/MSDcZ6rsVqkK
5Lt+PL9xxbZQePiV53aESAL5jfMOmkv/S3BYdYV3gvLWUAfjCQ+WRfxNcLgb
cMxoyhYEX8RdTNxid6gDenoBADjYA9g=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       139.84494155712497`, 84.30146844875}, {141.81375160399998`, 
       84.30146844875}, {141.81375160399998`, 83.805203313125}, {
       139.84494155712497`, 83.805203313125}, {139.84494155712497`, 
       84.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4g094v7rriY6KCYK2FucD3WA8XvVnyY9uxbq
sCBc9sWhJ4kOExfWLJG8F+qwUvHZnJhPiQ5/0wNPHH8a6rBx+qMtMf8SHTL0
1N6Uvg11eJqe/iXtf6KDSdzCNdlvEHyOKhXT3btC4PwznLb8T9aEOPjc41q6
jiHJ4ZjaspMbFoc4PFcxnsrAnOQQKzvXbc78EIfz/tfcPViTHNQn+KT9mBXi
kKOZwpXOleQQsZiVNXNGiMPH8N++s4SSHFQuNxyNm47gt034/M9+QojD31k/
7hdcS8Tgw9TPYX9TEnMv0WH/e6fnj4HmyS+WfXbocaJDVMLFpUxzQhze9ae4
Bz1LdNDaJs49aUGIw7Vd7L9mvkh0SHDOeG26NMTB1nD1qocvEx3S1P4bZK5D
8BdNexbmsAfBvzX518RfG0LhfNHZjzZf3BPq8EHplKQ8kP987Zedv46EOoSy
cfyY+TzRQc7adda8k6Fw+9td/GQ3nw11YLOOPmYLdF+o4dQ6pwuhDnMNg5w1
7yP4/j+5nsy8i+A38Bxp4rqd6NCx1ldxMzB+DbNr5auvY8Y3jA8ATCD79w==

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltIk2EcBnArS8NSo5UolKdKpDSlwhPY06xE3Izkey0kbL2pJC6tMCMV
Np1ttghN1Epqms2yZmCec24GW7Ok4TqYhxKTxJSEbS6M0qSvqw/q4rn4Xf2P
/jQ3OWOVk5PTCjYhbFaycSs0dx2rpGj7oAkcG2JwJ73fL66UQl7hWN5fwcB9
493frX7/W9mpvz9azeDy0eF2fhLF7vFDvIAfDBTvLZ/56RQ+Fon56XYC9xrz
Aj+Xwjm1p+RAMufux+e+mwo5/3wUYIi4QTBf2+hsz6aIHB662tRAoFUTP2EG
xfpFidm5hcBSKV1WpVEUffWtEegIpryaR2yEon08t8BmIDA2zKmzEznbM/Is
F/mc613oa0EMxZQieNOpPoJBRcct2z6KDf6JF1QdBII5WZAyjCK2Rzz4UUNQ
JB52hOykyDQaZJJagonKhHCPHRS9lpjbomIC/jNtju3vPnQlv6wygoP5Cg/l
Noq3jpuaEDUBb2FP3HQwBS9+s1ekliCTORzvEU7x7V1fWtUAgbyurrk/mmKX
PtakmiAIchhbvOPZeudTEz/NEnjpBxJCUzhHm6xHpKc5P0yo4L3MoTCNOc0E
ThIUyF1ndZcoyp4I/dsGCaRZdaF2KUVLl3ooRc/Ou1cgEl6hcC2eufamifPJ
66J7reWcJ0SLbm/OsPN752iVBRRGg0u3JZbgbE1euZK9L7a4TWo9CbYGLy1K
oijW6I5X+Xex/3CiwceezzlMNb9UVcRZaJDq2th+6kd9Oh90M0hKmS6XyijW
fgmM0vYyiNBYPavlFOvqraPMcwZi97EAsZK9j0zuW/aKgVXS+GJ1OUWJYb40
a4TBv//7ByRcU08=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE3AUxtUsxdyEbuhDmhJK5px4eZCafoIEOock/392o8bJS1qipiWi
0gUVRyotKUxzmpRWSNg0MV0XNy/kJW+h1iZLl9QsUasHNcz25KCH7+EH34Fz
vu94Unpc4hYbGxtbi3wtsrOoec2tqkZNcJVrLlWHMOxuXX4ibSYUeivvRkkY
3qsFIsVLQpn417U9MQyhsfk3Ut8S7gzzZNNxhnTDIAl7CKm1QcKGBIafssqt
j98RJr0+jC2kM5yKf1CiGSLsquhc6S5gUHbcrKoYJbgvma8eLGfIG5RrIqYI
ia82/FKaGAbSGj1G9YSvDQHnvkxYWSIPh5eAb3K3zqF9JIxj1lWl0ljmd0y3
PIs4z7ESIJbqxwjlJlmtQsGhHYoMtR8mBD93mhPWcJzoPtS22E/YHtbqd6GJ
YyIuY+exXoJRcHtc1M5R1+MRpO4iyJSBlZd1HLHJArGig7Aki6/rG+Wb+aw9
LfLxn+VYd/zjK28hJGWelBrMHCEb0S72Fr/IJ6xfNcPxA9XLjW8IWnlKw9JH
DsekA+peHWG/u8E4OsaRmR4You8jeDyMVKkGOH5/Xp/MHiSoszOuLHVx5OSL
o/SWvHLSSphbG8dfid9ZvYFgM1P0yP4+R+FFXb1wjuC1NzdPf53D88jRRNE8
ITIydF6azPHaw+gTs2jxBy9ON8ZwlDp7K/TLhOL5feWr/laeyrelRqGV58wJ
2uhxhnGB0zbVN8Kte9zsXMuwtrD2PXuCkFVBSucsa59j4ZKyjiSGT/UPijWW
/StLPR0LTrPN+3pzXewYY3A4rDOtagnepheqailD23SzcaSTsCCucjsTwfD/
P/4DtsA+fA==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       228.21099999999998`, 112.65199999999999`}, {228.21099999999998`, 
       103.29700000000001`}, {220.629, 95.71100000000001}, {
       211.26999999999998`, 95.71100000000001}, {201.914, 
       95.71100000000001}, {194.33200000000002`, 103.29700000000001`}, {
       194.33200000000002`, 112.65199999999999`}, {194.33200000000002`, 
       122.012}, {201.914, 129.594}, {211.26999999999998`, 129.594}, {220.629,
        129.594}, {228.21099999999998`, 122.012}, {228.21099999999998`, 
       112.65199999999999`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4i1nlfw+7MlySKx8HX52W7RD08HPUT5LshxA
ahhsox0Wb1+1SeBbJgbfIvLf9TNu0Q7x65jfn3bNcmC7I8LN/THaIc/wr5RP
TpaDc3uuZ5tTjMPXTz8NeuqzHOpPHmtunIDgLwlvP6N1E8GfPE9KbMO/GIfz
Cnrn9lQC1QuvDzeVjXVorpnGIZeX5eDQKbhrmkmswyLH1PDcpCyHGxcdXK94
xzocmGuyyCY4y0Gl7AZXcXisg/7rrOmXHRB8O032QlVDBD/j/qItc1WyHJgz
ihUq/GMd1vDaJdlIZzmUP+KflGwX6xC91F7lpGCWw5uYNcz+urEOCy7fupjO
keWgIeo98y1frEN8Jz9r0f9Mh1sbWpd8fxTjIGfvYlEDDI/foa+7ip7HOITo
O/Oc/JPp0J1bHXBPPtaBn3FFnBZblsM6a74sA49Yh2dePNKbhLIcCqQKLggm
xzrctby2d4tylsOkeuZnj9tjHTpT5hu5WGY5iIjMqj8/M9bBRvWc+opgBD+D
Zfq871kI/v/Hx1S31mU5zLt5/l5PV6zDh6VaPsl9WQ4bU6znsufEOsS8V/9R
My/L4Z3MLaNlvrEO03l6PeSWZTlcXSEs9Fcdwe9w8ZNl/xMD56/pUJv0Z3uM
Q/clzR2ek7McJr42sqvJi3Go9TfoOQmMXy9/Xu4bsjEOvumLvcoVsxzu7lbv
5mqMdgh7pPXkTw+Cr3jp0PLb0xD8h+l9RYJA97wQ/dK8uTnaoXZK773vi4D+
EVVLvt4V7aBxf//u6BVZDp6squYqE6MdboRFiIqsz3LY6qf02HZhtEPf77DX
CtuzHJrkAu08dkc7oKdfAJ4DNzw=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{176.094, 66.531}, {181.54299999999998`,
        73.67599999999999}, {188.363, 82.617}, {194.54299999999998`, 90.723}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{191.824, 92.926}, {200.672, 
       98.754}, {197.39100000000002`, 88.67999999999999}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3X/3zZpMtxSHM7Y6b7vVQx0kjPynmoWkONg+nx6W
axHq8Fxu2rejYZj8Vdvu/nFkC4Hzuba3TO38Hewg/V7K7EJ4igOr7dvgsC/B
DueL55ffikxxmGP85ILjh2CHgCBWj+XRKQ4zyyQMVrwJdlggu6mSOSHFYfpO
n36+l8EOH6uP1OqkpzgkNZzwZnmG4Gt1VaQn3A92eBL2/32tFib/75yu3M7n
wQ6vLKeZbjRGmLf78QrzW5YpDsZat311gfYttti0451NisMF5kwBn4/BDktP
i3fvtk9xyL377VLWt2CHz8zxr7wcUxxu8pz+JcEQAufXnHzPlM2H4O9ebDnR
Ij/EIfDW/C1HTYHhkVxyZF5oiIOnwPX/2hopDpwC/gd8PEMcIl0vpolLIvjz
NvsL8vIi+HUZ31aHMKc4rPxVcmBecIiD0CLFjmW/kx1kE9eckswIcbjVmH3V
9Euyw4Tjj69MqQlxWCrXeDjuQ7IDR8iz5pXTEHxZPudJZdsR/HO+icdO3A5x
0Ni1yeTo12SHR5s/mv/5FeJwcif3nFqGFIee5ZVK0iKhDszTe9+3cwPj57nd
+y26oQ5Fzbo7zkukONhZp3xmswp18LSyPfdDA8H3l70irGOE4Odn6FY+sQaG
38TAj3eNQx3Q0xMAH1YRgA==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zk5/pWXY4rDnF7BhN99IQ4w/kOvT8Z/fiD4h+ee
ZNsvFeqwsPqZeKhlioOpu2nBAu1Qh2kecvG7NRF8/nZFz91yCP7iac/CHMRS
HP48f9r+RynUYb7b1sc3+VMc9u4yOtgtGOow+1tzQTFnikN9b/0vKYZQh7S9
/3Uy2VIc8he2nZJ6EQLna14pkL17EsHfrsW65feOEIezxovvbmBPcVh79prO
1BUhDlvj3Cb8AJp3zUH3qcXMEIeApXkNXjwpDmkMB+vDu0IcchZMK5oDtD9+
i5aZSn2Iw55s5yU/hFMcoqwmf/lQHuIQ6XoxTVwyxWGnlVWvRW6IwwRrRe/d
8ikOsolrTklmhDiIZu3oe6eO4M+e4X9J0QDBf/Mt8ZqXeYqDQnt5/magfpW3
G3e9s01xONh24Vp2RYjDfuNbqxwcgOHpPKectQYRvnpchbM3NyP4sPgAAEPQ
tPw=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx7ccM5ap+ZB4ychiZZeFtywU+2bgMsya+/2bYYHmT8FENwWd
JVjWSobXOZWWblrLa3hhJF5CV4ozL4iNRPCSSgVmE7o9RGr2f3LQw/fh83DO
+Z7vOQduymOTHTgcDpfVUVY7WGWKxXFlbRQ2bsxF72YGTqXyC8sdFPdCbwsz
6hlIy6TDxkYK13WnN8UaBis/PskH6yh2xrfOmlUMTMmVZT41FEFFE4GbuQxO
/nprU1VTWByPy7vSGVhWzamKCgqZV3FjegKD8sJpma6UInrgxn7HKwwasjmn
vhZS8L+Ls0b9GVx932uNV1GoHN3DYhztnDD2mlswRbZ5NuW32mogOOs3JFWw
9cWXorWJ2QR+ewKaJCWsX7HpmQchyDXlCpbLKUI2w/oOniOonOGPb1Wy/RTa
rBF/Avcoa7pOR1FU3zXOExI86dO7BhoouqdmDkV4ElhnpUPGBor2+eanc7vI
dj6CblWVel0K2aLqtIDNz/CtI3PupxS2iL0fj7B5KRwGlbwNKYK5Fs7Deor5
0eoakwOBx3wIUmopls6LFj4LCDqton7JY4r8R6+MPDeCE4lJnj1aitg1XeSI
F0HLsH+LhM1L2K9cUx8m8OUFayUPKPRRd2oN7D76af1lnzyKvN2FlpF4As6G
S8lWNoV53ztrWg5Bku/9sSUFBU/kteiiIagKDk2VZLDzlF9EA+12trT9XVyf
tHMvau7GCRjEBMlspUoKZ01rXHU4AyFJ4feoKTSTTcde3LLfc2J18OVKDoPI
OnOagvXPN3w4IyxgtvcLX/nTl6Rm4Mk3OAfqKRbyiY93BYM02ul2/TmFe4DC
eK2Wwf//+A/qjCqZ
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr+Hbze/PpbisPwjs11Fb6gDjC+840ai2tRQ
B7s1n30YrqU4iBsVLI6cE+rgXraHcdbjFIfmHy7H2ZeEOvi/2SE5632Kw7t9
kq+3rg51aN5jG7nkQ4rDrndTVq9eheD3cUmY/K4IgfODZhnwqWSHOLwyesj5
5mOKg8/2mSc+JIY4tFZy/rL9kuLweO0E1zuxIQ65S9asaf2W4rBWwSHVIjLE
gavOKn/J7xSHe8Y/mVeGhTj0r7m46TpzqsOq5JIj80IRfB7F53/r/UIcZr8/
57LueAoGH6beKubQzZnnUxxcG8yeKYeHOOz9/tmL4WqKw4MPR5Y4RYU49Dyx
WtN/PcVhgxs316W4EIcS/ntx12+mODy7HP2qNDnE4XZrI7/87RSHN9s+6a/M
QfA11G+FNlQh+Akq7yZY5YfC+bO1r20SrA516CtfUBdzK8Uh1+7FDqvmUIfP
Ufdirt9IcVhy2mLmvfZQuP28Vx1lPneHOizpN9SuvpLicPtgR21TX6iDdZvG
irQLCP5b34ce188h+HKJs567n0lx4LNzVPgMjN/z+4NbdpzAjG8YHwCbIgMy

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4pXnF8tMbU51sEyfryQ1JcTBaufc1obSVAce
xed/6/1CHNakFyd9EMTkC7hvWiQZEuIgvmytZIN9qsPWXEvhpK0hDqqay10b
QlMdFiQUn/n4GKj+1eLohoRUh65XaxsbBULhfDvrlM9sVgh+vZXYoXL/UIcJ
76sz9WJTHfaln+x4kRDqEPlTu7UrLNVhcnfxGZe8UIe852HJd/xTHZgqhKf2
VIc6NOU02eq5pzpY5SVXGjSFOiR9P8S50gbB79/lZbrZGMG3i7Ew7NJJdciS
kBVZWBvqkHun+6+ueqrD9I12hfeKQx1eOUT1HFdMdTjilXBOOivUQerg2ohs
mVSHNyHbm/ZHhDrUPpef5iOe6uCUqD9jgX2owwPeSZd1hYDh4Vf2U98p1OHR
qdiS46KpDhEt3atyk0IdNnlxrVCWTnWYdZ1TrKIy1IFlpcwaH6VUh8KUzbFX
OkIdVL6UCrIC3bPJz+jovbmhDkfdZ4uGWwDtY/TzklkR6rBVaOG6bHcE/4bU
sS17QxB813lplazA8PPJ/vIseX6og8Tte76/M1Id+OwcFT73hjrI7SudrFeU
6mDmMePKtBqgfzuVjnaVpTr0Cd7pEkxH8J/Khiz45Ivgp358xyWoDvR/novC
iexUB6+Q39sE/oY4cL/2+nIcGL/H1v67//tciMOe2ksJe7VSHXp8fSYnlgLT
w8aKer0MBP/cpxOJl3IR/Nfi4UofC1Md1LL4tj4rC3F4s2rPl70lqQ79xeIW
v6tCHK7+P1p6qTzVYZLB4xtT6kIcuJI3tK+sBsaPcJXcifYQh94r1VrODakO
HCHPmldOC3FAT78AFGM2bA==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{174.80803436112504`, 83.51413176875}, {
       174.80803436112504`, 85.26668522}, {175.33680048800002`, 
       85.26668522}, {175.33680048800002`, 83.51413176875}, {
       177.08810390112504`, 83.51413176875}, {177.08810390112504`, 
       82.977865413125}, {175.33680048800002`, 82.977865413125}, {
       175.33680048800002`, 81.226562}, {174.80803436112504`, 81.226562}, {
       174.80803436112504`, 82.977865413125}, {173.05673094800002`, 
       82.977865413125}, {173.05673094800002`, 83.51413176875}, {
       174.80803436112504`, 83.51413176875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/crog4ntvDSHM7Y6b7vVQx2K24NkudakOdg+nx6W
axHq4FQys27mOkz+qm13/ziyhcD5XNtbpnb+DnYoc5Hbt3h9mgOr7dvgsC/B
DlonF/1fuzHNYY7xkwuOH4IdVi/nuFC1Oc1hZpmEwYo3wQ6/i7YyXt+e5jB9
p08/38tgB5+Lx1kZ9qc5JDWc8GZ5huBrdVWkJ9wPdrBfw1QR2ITJ/zunK7fz
ebCDa//MvS3dCPPELNfsXzsxzcFY67avLtC+f71bHQ5NSXO4wJwp4PMx2IFB
UVq4f3qaQ+7db5eyvgU7+EUmFcnNTHO4yXP6lwRDCJxfc/I9UzYfgr97seVE
i/wQhzX6i21m9gLDI7nkyLzQEIclqbfa/9enOXAK+B/w8Qxx2DLryrtXBQj+
T47gmQ9SEPybe38aa0SnOaz8VXJgXnCIQ+53FYGq4DQH2cQ1pyQzQhxMr+fF
cvqkOUw4/vjKlJoQB4aSFm8jjzQHjpBnzSunIfiyfM6TyrYj+Od8E4+duB3i
0My/bc8M3zSHR5s/mv/5FeKgws+vEhiR5tCzvFJJWiTUIe7NhPLoZGD8PLd7
v0U31OHsDQOHxUD32lmnfGazCnVY0u8QdqYBwV9VdH32/04E/9ReA8Ydk4Hh
NzHw413jUAf09AQApBMLLA==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7ReZVCQ3M81hTq9gwu++EAcY/6HXJ+M/PxD8w3NP
su2XCnX4c+HlfI2JaQ6m7qYFC7RDHT7OVXze14jgZ91RudhXhuD/e/3ynnBe
msOf50/b/yiFOvyavSN7bXqaw95dRge7BUMdvnm3/3BLTHOo763/JcUQ6nBQ
iHmrTVyaQ/7CtlNSL0LgfM0rBbJ3TyL427VYt/zeEeKg0bkstSU+zWHt2Ws6
U1eEOAhs8ZQ4AzTvmoPuU4uZIQ6rfxVyyKWkOaQxHKwP7wpxOP515q98oP3x
W7TMVOpDHMQPuumcyU5ziLKa/OVDeYjDlllX3r0qSHPYaWXVa5Eb4vB6gsrl
vvI0B9nENackM0IcCvbvFjtUj+B/exsU9bUdwXf3SY2T609zUGgvz98M1F/v
tNXp0NQ0h4NtF65lV4Q4SHXeNRKZAQxP5znlrDWI8NXjKpy9uRnBh8UHAPkc
uaw=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EYhmer1JFhZaabJTpb5fJYkFbkLUrmWCPc9w6zrCH6CtoMmQke
8AAq2bIcpEnhTNKmM9OYZUSCouRp5WFWmG6UikvKUqSDqdV+OejH9eOC54bn
5JVwOSaJzWKx7Kz4WtlgxUF+94Spm0Kz0JI+sSSFwl0pUXVRcNqLKkpXpBC4
3RzpG6DY0TmbL+MwULetCXQjFDx5NOXvYtAbLrGXvKVYCNjnNOvNQKR311ne
U8Tre0f8/BnoX3j7rZop7vBbfm48zmDO0ynMOEVRV2DKSxUzMAZNyQvnKD6f
XhI2pjDgG/f3OM9TKI74JPhU2Lx7ITgsYdDmImblqfMag6N5nhGr1nyVQttc
KCA4U9n6jTtD4ZIRrumPIuAeemmK+EDxPPzPtOQcweMDHXEBkxTq11phUwqB
/7PF9op3FEma4lFFJsEv39p3i6MURi/B7SeFBFrDDWPfIEWmWVRjX07W91Nw
LEuQdo+ApOUO1fRQfLGTiDwaCMoSDfoIa72+PajfXEMQ+cCj0jJMcWrxfH1g
FYF8UCfb/IZC92jIvE1N0D+mH+eOU9QfDqk2lxKIT+bntpkoQjYlXgksIBj6
2DrPnaZYW8uRns0gkN1vZvO+UpSkZ9VFxhFMjkRGSX5QNDRfyuaBIKtp1FGx
QjEwdnBOtZfAtVhuULGSUdIzNWnhEMyka/147GRsyXEpC51n1v2C03e5xWDz
1OzYrmtqBkKlSmdapnD1jf4kjmcQI80tb7NQLPNl5eIg2z1jhwOv//ZhEOzA
F65a+9+ze6d9B5dZn0/MYdvd2s7gYm3k1dAxiofKxuoJRwZbI4KLnF9RKDvL
3DR/pfj/H/8B7W405g==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{226.94899999999998`, 
       119.34400000000001`}, {234.012, 122.35499999999999`}, {
       242.57399999999998`, 126.012}, {250.691, 129.47299999999998`}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.0033003300330033004`], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{249.32800000000003`, 
       132.695}, {259.89799999999997`, 133.40200000000002`}, {
       252.07399999999998`, 126.258}}}]}, 
     {Thickness[0.006600660066006601], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPS1XatfPvjwHIZY6580n4x1gfB7F53/rD8Q7sF7v
7Nzoi8mHqbc5ezM3NCTPoTJgt6reqXiHZQye+80i8xzWKjikWpyOdyh5269w
LDrPoZq3/djxs/EOzreuNYbG5Tl4/jqrHn4h3mFVQJXR3Pg8h4Z2OY7fVxD8
Vz/V+vlvI/ihB35v2vso3kGzSCTpQmyew2HnOeWs7+IdeMvf5NdF5Tmkh/TK
fPwb77BAdlMlc0Cew93ijFVe4gkOh/xuvdTmRfDf1v1xymTMc/h54U34yk/x
DvPdtj6++T/XoY9LwuT3q3iHIIsrQeJAfpjICf/wJwj+m22f9FfeQ/A3uHFz
XQK630bBedkPFkR43PVkulMrgMmHhd81Q6uk83dzMfgw9ctv+6T8eJwLD8/Y
z2YV51/kOqy/y8126Vy8gw7Xk+Xab3Id/EpSM7uuxzt4sPLMqn2f6xAS/mfd
3gfxDkZvq97Gfc11+Ptt+x+nH/EO26WFDCf9zXUobNbdcZ4vwaFXQZHnglGe
w50ZKaydPQkOsQvO2utYIPjBUnP83pfnOSTd+npr77d4h8VPPRq8a/IclF2c
BXwfxzssXSSi+LQ+z6HxgyzP72vA+O2PbippynPYOOv6suxL8Q5ONYseM7fm
OYgc9HziA4zv1a2r0yQ6EekDPb0BAMmaJzs=
        "], {{240.54036446000003`, 
        129.05537444875}, {242.39542103750003`, 129.05537444875}, {
        241.46789274875002`, 131.264191815625}, {240.54036446000003`, 
        129.05537444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdknss1XEYxn8cbZJbkzVNZChMYjaWkWclJK1lY81s3682mjWvy46sOEYu
J8XY3DoVI02WHEvlfonmFppDzb1cO02MzUYtpl//OFt/PH989r7v9j7P+1rd
iAmKkAiCoCXKQZS2qANOB3e8lglbwilbw1yOcqnLap6a8L7U08Q9m0OdYBoV
9JVwX5bFe9M4kierTOLGCRmng9dYEodvYIjr8Cjh8cXvipQEjg9TD/JdPxEW
JcWNUzEcoao0A8uPhBoD3zG3KA4bKvnj10s4+U2ZJwnnOBvWPanoJKT/sm5e
usax0pJ0W6+N0J1+yOKFp4adI+ZSYaXhaNcdnyhdjjGjzG0LcT7nSmBBuJqh
fXszQOghGPvVPzPrZdBXeCjz+gnuu54t1m8Y7Dr6STlE4LEF8X2VDDVnCg/7
qwgPy98N6jxicKpgb+e/EBpHxm3O5zBEdpneDJolKGeqK6ZlbD8fvcaMouxo
hp89vjNNS4Syjbq46QiGVPuJrHGxP1bSnahDDANq+XPXCcLMQPGT+gSG2u7f
i0c+E+YuOM0uJzP4NG9wYYSQktVaqZPB0OVn2xE5SAhaU/j25TJ4vdoMFP7l
1Z64lq1gaFjZchNaCaWX7j4tE/24tLHNoXpCkoG8t2+YoXBB5aysJXQeV43e
+sGwretDedUE7ZLcdbkWh735rr5QJdZbpUeZsYYXQ/bWZSc0HFY+7O14jmPh
mFm+Vx1B7h/sePk6R4uH3cvILoK/eqwomDT3jEwID5VKOaYy04wsxf0lV9fN
C+7wfX+WUtnsaxmHcpXVz4v+Y7wdjAzvcewFxDfozRD0zZpUjnKO///xL1Do
OSk=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQnb74bpJWWL7DM7lp3476JDh8+G7v/T0532HeZ+/V
ZqEJDvuftK1pS8Pkr9p2949jRTycz7W9ZWpnbrzD5y3cbyak5zuw2r4NDkuL
d1huOUF3dma+wxzjJxcck+IdNCS+/U3PzneYWSZhsCIu3qHi8SL9I/n5DtN3
+vTzRcc7nHTcavy2LN8hqeGEN0sEgq/VVZGeEBjvsEfmw1I7K0z+3zlduZ2R
8Q6H/re9LnRGmDd55cy3szzzHYy1bvvqAu2r/rcob71PvsMF5kwBn+R4h9qJ
HI41/vkOuXe/XcrKiHc4fdJ/AXdgvsNNntO/JIoQ/JqT75myGxD83YstJ1o8
jHfQXDAhq80VGB7JJUfmHY93ULx2fOsb83wHTgH/Az674x0MuQ/J3NBA8Msq
HY6flUHww/SeJ4oK5zus/FVyYN7ReIdX6UJ26dz5DrKJa05J3op32OQe0/2N
Od9hwvHHV6a8A7r3SWGlPEO+A4vW54MhLAlwPl+7ouduEQT/+TKD5CdqCQ4M
DYtftbLmO3y8+UO6zizBYWH9n0A7gXyHY5dtJvI6Jzjcjqlb6iGd73CueH75
Lf8EBy9PubwJQPfOl91UyRyW4KDIoNey0wLBV3985OQbRwTfXU9Of6l3vsP2
Eyt+vAtKcEBPTwAd5hA9
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffqk/wLuwHyHc8c4NtQyJDjA+AWqPyXrTBH8R+dS
muPdEhwqHa+fFfXMd5i1WMrigl+CQx4fv2iNJYL/3Efof7Uegl8dc52HUS3f
4d/nT851XgkO5TzLZs6Sz3eIj5354KhjgkPxnhI1E8l8h/3H7Gt5LRMc7Jo/
PNIUy3fYEeCcyquL4Itk7eh7J4vgx0xlulUrmuCw9OfkyYXi+Q7X0rKnefEm
OPSqmLvtBJqXvWBa0RzWBAeN7Hgzbpl8hzSGg/Xhf+IdXNLaNWJB9m/RMlP5
GO8wxdAkaqdyvkOU1eQvH17GOxhyH5K5oZHvsNPKqtfifrxDBqMQY41+voNs
4ppTkrfiHd7qr3RZb47gF8c5dDyyR/CP7Anq4XbPd1BoL8/fDNT/Z9OigvW+
+Q4H2y5cy34V7zD956kExoB8h8POc8pZ38XDw1ePq3D25q8IPiw+ACbesJc=

        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxjdXOVaKJYm0vNQywzIvoULTeNCKpBkxUjKL/5ukYZkvYwkz
Zxebstk003mfy6VdNHHpaFqhLMwkK2ZpJV6SbtYSVLKMBLP/Jwd9eD784Nye
c86GZCpN4XE4HC6rAFZOrPL61el92RSGGZNsJIXBdw1RKrIoBO2qMs0ZBvVq
5eL9XAp368SFBCUDV7/JQxUaCiGJTRVpGOxuE4eJiyhmgvxdJnQMekXOQ4Ml
FMfMva8C6xgEB7ol2cspqkWm38taGKQWz6dbqykaLo6dP93F4OANW1GGkWIy
bnZr4yiDuhiPHwsNFBbhmpASHlniZEWVT6u3g/2acpLUEQTtU6tkdjb/hWXg
LSQEL1cYvPh6dv6HvrbPRwkq6s0rQyopxnwXZbdTCbZXN6nX6yj2fR0oi88g
uLtl/EvuVYodtmh7+FmCzJqi5eMFFHa30ufDWQSbopRcy2UKMb1p410iS/ux
1ka6R2gIXr9PW9AqKeY4/n6uhQSCNw8+BLPxwyOVJ6bVBI89BE8G1axfRYvU
M49gTFypmtVSxL87Oa1m6+3dY3TmX6OQrtMfmM4heGZJbzKWUeid2nZ6sv0l
UoOQX0Ox+LezcZucYMC9JoR/i6K7I1K6kfWTGB2aKW6hGEwI73RJJJgTWiOO
mClSTpX/7NlPUPorbl7RQRGTLJuS7yI4/lGXxH9EkR9V8FQf5GBT/rl7ch8H
h0U1kx4uwZ1PiqG+VgqPgNhvEhsDW3dal/E6xR9RQrGk3nHPw/3B2vlyBiaF
W6Kdnd/ba61zp5ZZ8icR8Lg6FYPR1aGWzaz/Znlj7Ug2gytmn7YFFYXcWuhp
kDH4/x//AVsVNkI=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{194.285, 113.34400000000001`}, {
       185.254, 113.71100000000001`}, {173.93800000000002`, 
       114.17199999999998`}, {163.71099999999998`, 114.586}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.43800000000002`, 
       111.09400000000001`}, {153.59, 115.}, {163.72299999999998`, 
       118.09}}}]}, 
     {Thickness[0.006600660066006601], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbSlfh3nnBQHt7UW77z/xjr43Xw47drKFIftYUvC
dfniHGSPafxIXYPJV1F79ZfxTgyc36I2cZrnxRiHwGlrzQvWpjjUr/kZInYq
xoFV2qiyan2Kg9jiDxcZj8U4tP2c7um+McVB+JmKYcahGIdrR1yqF29NcRDU
jJxwbl+Mg7pyeP2ZPSkOd95f8TmyG8Ff8rMlQ2FrjIPUv4kfZRsw+eU80/M8
98Y4KDzUMA/sRJj3scvasqo/xWHtzOd+bw/GONy877Krb1KKg1dxqSDP8RiH
20WreqKnpjg892G+onUmxkFz9cfXr6alOATXXP994yqC/83iD7P2EwTfVNht
0g+XWIf2RqNtqd3A8LjccDROO9ahfnsm45naFIfm+uiDPPKxDv1vkjO25yH4
V6IeCa1NQvC38Heu/RKR4qCc1XgwTjPWwcNzS6dbYIrD9As7Tt+0jXUQ0Px3
7apnigOX+YerIUGxDrePCh/955ri0HT4U0tmDoI/vdZ/slkvgu+xN/d4x8ZY
h7hEV7NU7xSHGOV/FnsuxDr8T5g3VzYsxYFNvE359stYB0s7hY/qicD4Cff+
UMIc57BC68DOfKB7d6wq+HKMP86h/uH58zPqEPzWI2miZ9oR/KX8B6paJgLD
jyHu01zOOAf09AQAkwgdAg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbn64+tX01IcxP7KJu5OiXWA8aN3/TPZcw7Bt+W9
xl7/IdbhulKl5Ne+FIf12xwLExjjHM6835AQXY/gu+pt8YouQfBv2lZGPMhO
cSgL/9Sx50esw9W37k8rU1MczLXsD3k/j3W4OFesSDg+xeHnn+7ft67GOsxJ
maTHGZPi8FJg8ulbexH8xc61cnPnI/iGswS37u6LdWC+bXo/IDbFQd32sW5o
XazDa9abE2cAzQvYYPnsR16sQ5sPY9OrxBSHB/lnG8QTYh0WuWuW2ADtv6ls
bv4kJNbhk9C1pTMyUxyurJz/dYNvrEP/m+SM7XkpDsar3Pp+OMU6HHu02Se6
NMVh+oUdp2/axjp4C3pP6KtF8C/aP7p8sBXBV5r35fqrnhSHWd+aC4qdYx2i
prjs6Zuc4mD97c51bb9Yh6+3ctY8mAoMz80rKo4GIsJ3RWXtnOJIBB8WHwA8
FcqY
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EYXTNTmMUISaWrmdnFK5U1oTgmGOa6iZdtfd+n2TsLNcyZWrRs
mmlqBkuJzMS8pGIkRWmGOsjGljpTWYRLTU1ZarlcMTFn0ffLQT/Oj8NzO+d5
Hvf4lAipHYfDWcFiFwsui3qTQexnJ0VCqiR8+BqDw/u4R7PtpVhsvOnlm8Gg
INCoCVkiKEx06xSeY7DpQWZqvIUgp7tl6LqEwZSTl1I1R9C0OLi34zgDaflp
07bvBMg8cDE9hMGSMiKJP0UwUHi/3ieQgcb3vFgwSaDxSdyi9WQwtKFkf9EI
gSIuMq3AgcHtq8IPVgPB3wyPg2tG6GX+SdDLDa6z8ciPK4vuXqKR3h8VxWfr
V3WISt3DacS2qhvMX1i9Laoaw04aTWKeU7aR4HlyWNvEOhrdWWW6yhm232hl
Wr4DjWNzJEXwg8Ce36lTWyn0n/Ffq/9FEIBJT+4cBcccozrESrBD2FxdPk4t
7yd3u/Je2ACF4jyXoEauFK5x7bLyLgpbZxom37H5M7L3l9VsPKlBxPWcJ4gW
1DyUGSicuNEdvOongeRF0OfHYxSMV96ozLMECxZtrforhbOO8+tF0wQ6qu5I
vpnCaLK60TxB8Mg71xT2h4LoibbUPEjg8jqvgnGhoZf7n1L1E1jkJdr8ABqB
NdV3KnsIBMUj+t1CGmVdzjqFhiCrwmusL4FGz3BvovktO89o8cvKtXFs5I23
1dr4nmf1CtcxGrlD07O+vQS3OK/E0c4MKOuCg2iUgHfopXcSbPcMlfQ1NwgZ
yEMjLvBZ/YrV34KM0cyyv9YYh3aPWAYnn/rz9az/GFPc5mH2n6p4Ic5LvwmU
VfJaNxmD///xH/qsRAE=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4paOhq3dMqkOiokC9hbJcQ4wfq/606RnWXEO
JcFtfgu0Ux0mLqxZIlkU51Ar689sZZnq8Dc98MTxyjiH1sne0lauqQ4Zempv
ShvjHHYmX4hycUt1MIlbuCa7AcHnqFIx3e0XC+ef4bTlf+IQ66Bwq5i7xz3V
4ZjaspMbzGMddivM+X3XM9UhVnau2xzjWIfF3vbrVH1SHdQn+KT90It1cFA9
W+ASmOoQsZiVNVMn1uFocMqW8shUB5XLDUfjtBH8tgmf/9mrxDpcnJbo5ieL
yYepL2AOvW2pmuqw/73T88dA8z7Pa/NZoJXqEJVwcSmTQazDoe6za/V1Ux20
tolzTzKJdVi1rSChXD/VIcE547WpZayDoK6I4H6DVIc0tf8GmU4I/qJpz8Ic
AhD8W5N/TfzlEgfni85+tPliQJzDETnjhj9A856v/bLzV0ScgyZTYVy5XqqD
nLXrrHmxcXD72138ZDcnxjncMjuiIw10X6jh1DqnlDiHQt3dK9nUEHzlr8Ve
5SoIfgiH7svniqkOHWt9FTcD45c1/VlrhBxmfMP4AAOd0vA=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ntI01EUB/CVYtZqEToNI93c+kPRkqKlFXqkRETNpVZjcm/zcZqioK5M
UMOc4SPRVHxUmhhqpSaZ5vKRk5otyLamsWTWkDJqoqRpD8yofv3TD+qP7x8f
uJx77zlHmJAejXYcDmcNE18ma5lMn5W477Ug9L7sFE2lEMhQ+BULxhCKKpd/
BokJvOU5JFUq//dFjbbF4kUgMhK2CWoRdllDnD3LCMSZAkIFnQhupnzD3QHm
fJWECDQI9vJBdfB71v0dGZ/1m+lfr7R76vbtoKCv46UaexD8J82ltyQULjVr
i7xvI2xazTfYH6bQWjGblNeGkPfBoy7iKIV+J36QsRHhnjU9Z/EEhctNx7hh
1awfx1slMaWsz9iN7fZWI7wr9uLHx1BoKXT/ZchD2CIMVzWFURDY5suV2QiB
g2nPXwVRkCaDnKtCODWqK8zfSaG3oqd+Pg3hgenAFQWfgkuf2Gz4049h9fcF
VwpbVYtZylSEieX6Tl9/CrZPje26DATnUBdX/ygK+6V3uuaZ+nMvRmgNpSBv
cHRqK0Dw0Qbqm05TWP3o6/qtnLkvUx7++hyFuYE93dxrrHmPZBrSwTo3ZCWn
rQ9BP8WxibIoHFFnRjVoEUq6IoW9iRRi0bHW+ASh+36r+Xg081+/Pr33MwTH
AlvZ+EHWJ8sV13tErKcVq9zxHwSk/Elh8kOEUd26ftMEgeBq6xclM1/Yzn0z
1EpgSYwJ5DyCw7CsRhjO7IOMW2AcZm1/NS5RpWMtHJkVVTHvaba4aW5EEPCM
jvpKniKsnxEFDEkJcG/KslUGhI3NC5bYWAKw4VBp2Dgzn8IijxJCQJfL85kx
I6h1SxdS0gj8u7+/AYHKRdU=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxze15uYlLQ1HqTlDMWfTtIuQ+pfsombBUhR53ydT95g3ytSV
mBThxCI1FWVT2EpMQWhilgwrMDPT7q5CxYmKSc4UB928BPV+atCH/4cfnAPn
/M7xST8nV9jyeDw+l11cbLiU/7zGK11VwCPt8YXmYQbmzlSXgF8KlPvVNsaO
MGjRK+spj6JK9u3q1mkGTvFz80cFFA3vkrJmFxkcGts7/NWBIkcX6ty2wmAw
lp+ncqEYlXw0LtmykJ0SLWvcKNzqH60MuLJQ9HznFXhQeFnMVwIlLE4ODUu8
vSkUT/5Is8FCl+1SoZdQfGkLzvicY+WItChI7lh54JnA8N7IosdNsKGJ6988
2a2P/s3itVTdZRBTVM8m6K57EjQO39PNuFOEdYnmnEMIgvpat79xpXCIfCDN
BUHHifGSUCeKKae6D0HHCYqeVmpq7CkSaveoi5MJfDOUDZRPYUlIvv1CQf75
WetQ+e9WEozYZdZGrClAC1LjTWUEwvXu4hnOV5B/5EttMUHfQbsU1UaK/rTs
Nks+gelMnUeriGKnl2lqhBIczm1uNjhTeLfGaLWnCYZMNFK+heJ+0XmlJYkg
/pK608D5uphfmSiOIzCGNzw3+FLwZlR37YIJUs5KhYuBFBLPktIJd4If0b2v
RCEUMTHhC/HrLOq2HasO2MfVhy1Ptk+zSLOvWTYcoKhY2FG92m/lscv89PYW
K8+ZM/vjsli0CwvzSmUUtzRJZsdQFm/NGXK5J0VhfXqto8B6T2NURFXvGgO9
VrSk4eZX3/SxL7Mw//YbLNlkkzjPYGK/NG5USOE3+1DbPMXgxrj4iN6GYknW
JCafGPz/j38BjMci5g==
       "]]}},
    AspectRatio->Automatic,
    ImageSize->{303., 166.},
    PlotRange->{{0., 303.}, {0., 166.}}]}],
  SequenceForm[
   $CellContext`Dia["A", "A", 2, 1], ": ", 
   Graphics[{
     Thickness[0.0033003300330033004`], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 166.}, {
        303.367, 166.}, {303.367, 0.10899999999998045`}, {0., 
        0.10899999999998045`}}}]}, 
      FaceForm[
       RGBColor[1., 1., 1., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
        24.617000000000004`}, {45.02, 13.289}, {35.836, 
        4.1049999999999995`}, {24.508, 4.1049999999999995`}, {13.176, 
        4.1049999999999995`}, {3.9919999999999995`, 13.289}, {
        3.9919999999999995`, 24.617000000000004`}, {3.9919999999999995`, 
        35.945}, {13.176, 45.129000000000005`}, {24.508, 
        45.129000000000005`}, {35.836, 45.129000000000005`}, {45.02, 
        35.945}, {45.02, 24.617000000000004`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        18.552508993125002`, 24.501156448750002`}, {21.99788154, 
        24.501156448750002`}, {21.99788154, 23.632703813125005`}, {
        18.552508993125002`, 23.632703813125005`}, {18.552508993125002`, 
        24.501156448750002`}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQXZ+egvmK+/bdca4cH
D018voUh+MyN2VWPPpvC+T+6hFlM5pk6NFQwsdk1Wzt8v7NtbWuKqcONs1Pe
x6yzdvB88M7gm7upg4Gy+s3qm9YOxfKfHxzSM3WY4PqEtcjMxiGv+uuFQwqm
DkfWnlladMjG4WNXjPt1GQT/5V5DFobXJg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcNcnpDntv6mDvfPXe8/qGDl4MMpk3I229RB
8DZbc6qllcOy9tsNh3ch+FuXJWh5mpjB+Xw//TIDemzg/OwF1jtl/9s48G26
6d8nauXwIfZ/6wMTWweOhPqX989awvkh+3fGBCxG8C8wfuvvzbV0kHNkdFur
aetQpW7SPF3H0uGNyaUgTkFbh0Wv08OsNS0dClwsT8ry2jr47mda8FnR0mEG
R+6cg5y2DgrhF/f4i1s6yEhcEbrGautwRiuHjUPA0sHlDvuzSiZbh+Nted/Y
mSzh7vuWWbDtyjcLB7GSa0zXvtvAw29Ws23lq882Du65Kyxdb1k4vOJeKm/0
1sZBirU8bOF5C4dcaZ5pbi8R/LlrstYcFLd1QE8vAOyw+t4=
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{107.836,
         56.074}, {107.836, 46.719}, {100.25, 39.133}, {90.895, 39.133}, {
        81.539, 39.133}, {73.953, 46.719}, {73.953, 56.074}, {73.953, 
        65.43400000000001}, {81.539, 73.016}, {90.895, 73.016}, {100.25, 
        73.016}, {107.836, 65.43400000000001}, {107.836, 56.074}}}, 
        CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4kscerbv94Y5qGmY/J/30s+B/aeOoM2RMIc/
ExlVfj9F8HsfylgXbvGC8zueffg/s9PLQW7tUaa+k2EO7f2HrhzK8XIocdLa
G3olzMFgYpxYdZyXw6nrfeWy98Mcjm5IyHsY6OWQpLCPKfpbmMOhe4lpD728
HPKtdmhFS4Y7tKRNXfjaA8FnAAEDL4eqAw9XfVYKw+DD1NtyOIuGOiLM+6x8
s443DGGf6fXF/s1JYQ5R6hM/yiV5OWxlsn76riDMYaPq1/VpBV4Oh46yPRIv
D3O4/yRk38PpCH5aifjkJVcQ/Elz+4xWMPjB+Y4fW27xWfk5NFZbiyrlhTkw
X3jm8CHEz4Hh+ZJqsxgE/3Jd8YxJgQh+Ub/TU0WXMIfZB58vCPP3c7gjIZT0
xDjMock6YDmLs5/DM877YbxAvsvh5kd8jn4OF/e5ZlobhjmEL5U9k2Dv53As
pbJgkl6Yg5RuIHu2rZ/DRskHTQd0whx0+V9/2GPt57B+w4M6B02E+6o1H64r
VgtzEI8O+p9l5gcPv5uPWq1KTfwcArTWn/eXB4bv8p28koZ+Di4XHl1bJgMM
T723Hsr6CH5UucyVBDc/B/T0AgA2dvY8
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{43.352, 33.547}, {50.469, 36.918}, {
        58.676, 40.809}, {66.242, 44.395}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.824, 47.594}, {75.363, 
        48.715}, {67.824, 41.27}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.0033003300330033004`]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQbV0y+80zCz8HVY4/bWm3XRxgfEmnc7//n3Bx+CkZ
qXXM2BeDD1N//dOM3aF+vg6fFpR5x9xxcag9EMp4O9HXIcqx4VTBPReH7cWF
bRI5vg7fpfh6+x+7OHxU6+UOK/N1mPJltv+6Fy4OfQzS50qqfR0Y+G0Fvn1E
8K9+9pWT/4fgr2n4nlrN6+rQ2dbc41ji69DebvGeS8XVQWrW48M/03wdzq+Q
snzk7OqQavLrFa+tr0PJ+YUrtZa6Orz+MWv1ekMfOH/WTmWBpUw+Dl8W3lwf
pOvqkHSDbXL6H28HWVGDjG+yrg6685v8Y396O6zTmDB/nQCCfyv3aXwQK4Kf
2CsmsuSli8M1O7u5jwR84OER9dSq5LsdJh8WfratUr22Jd4YfJj6Rp3UqQ97
vOHhGdXN+9R2gbdD/G5xniVPXRymPTu4eN1ab4e5L05dEvnu4sB6OTHn2y5v
h5XrfsRWc7o6rCuS3VV9ydvh99v8n60Wrg6HdapOeHz2djjKu+2BXTMwvBy2
mTic8HEoTJ4kqlLl7hBtn8G88S6Cb6y+yG7vHV+HY1teb602dXUoDAll1Xvn
6+DW0aYwi8/VodqjpWPKH18H5ofWEt++ujhs+T2f9xKbn0Oy6Xrf629cHN6t
2z2JX9DPQatp8omZj1wcJl25Py9R0Q/uH/T0BgBd1yCG
         "], {{
         56.516927460000005`, 43.61787444875001}, {58.371984037500006`, 
         43.61787444875001}, {57.44445574875001, 45.82669181562501}, {
         56.516927460000005`, 43.61787444875001}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1HEAx+9hq27zMFN2WkaURXVZF87D6Yvf3Z/G/4ekVq5aGFJYnnOt
SKTi8li4Hlg2NvMwEpVMKlqdxbIMmae2bKJJrkS6V2frxefF5+X3YfuZuKAI
PofD4eqw18HTsZIUsqgtoBjiq4slSgZRt7UtBysoeCkLfqPnGFwtyanxTaaw
XjLPNKcMhmw0Qa+OU5i0Bj++7Mhgbe5G/wEfiiizsshlCwY/dinkfY4UecbH
xs5uZED5Lq7KnRQNTkL/kVk5UpNVC5ZmFOXKZx5G7+XQiNxiIv+wMJhUTReq
5CiotRqz+8Zik7EoVe267l3FGXyeRqb3Fs130+poGfavyibTf7MQVty17TaT
YUTNdeCaUFjlh8vEHwmE1ts6PCwpYpfTEpl6gtzW4M72fRRd47Zf8lUEJcrM
Q1ZeFELPmDuCVIJKr8bB7GCKuMoG36zTBBnd1x/6XqAIbQ/0fuJN9P1sjhXs
NrUhKB70S5pSUUgnTk21mhJ8DSu0PJlIMbEha37TDgJDRWBpn4KirWivc4SY
QN0rLD7sT/EyJ/TpO0+CX1WLOVwpxV+DFEYQQDA7+mal3J7i0bA4Lz+MYCyW
I+FuofC/OD9smk7QFWU4zplh4V60KJE2ENTVN/aLe1lotxrlqaYIXHzSetqa
WVxxq6r+JJTh9YRnh/QBC0Go0wtLVoabIlsJp4TFytyAQpm77rdOrHZq3657
QobTWiPkiLcrJUvtLCysjzTtqZVjoGagrpyn+8M9ejSEy+j3LBu8Ft1vziBo
0NlLaUdh4N6R4Cdi9PkuffiZ1OPB4H58kyY7gOL5ao27JIDB9MzyZ/vzFA7h
4/LmcAb///EfbsQhXQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVj1yvErqwIcZlRH3BKvdnO4em7GjLxjAQ7V5/TX
3prj5lC0Qi269zQmPzR3989mCxc4XySPU1tY2cXhlofBrYVnAxy4q24tXyPi
4uAcZBm77WKAg2X6iYXNPC4Orvys//yvBjiYvDVICGB1cXi6NC6R416Ag37x
TDnZf84O7UnNmVFvAhyOMkyczvEDwQ8T+XjuwCtnhxyJn75/izD5vyxFbwv9
dnaouKd2M7kVYZ6Ukc/drRMDHNJCts2OYnFxeHU77v696QEOC9gvKczgc3F4
x6jVUjE3wOHWrrdLr0q4OHQV7XCaviDAYYvktK+GOgj+z0n3Wa95IPjl7sVK
hVyuDu7yVtd7OoHhcfxFh+11Fwez7hW5kXkBDkIK8xpm7nNxCPs6x9ogAMF/
cHHmBGkLBH+B9fOjq1QCHIK/vmywvezicHKdbZ2faICD1aGIqcZ/XBwi8y5K
5LIFOCj2H1+pqerqcNv/58vav/4OAivOsAdHIvhWMm0qb2ch+HNnH+qZ+NjV
4eu9+OvdnMDwTH+c/0PRzcHsnuCyP3IBDpL+n13MQtwcVs0Q9RU0Bdp3vvZe
ZrubQ0dh6L0F/gEOtWUnnvEucHMwv1/C9TkfwXdeumhqZBOC32wdmnBqaoDD
HaXFj3ZPdnNAT08AbO8UMw==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3VW0w2n6ggAHS2nlA988XR1g/ENTn6T/kHWD8zus
J/PWJbo5PEs8Pnf1hACHrL6sBw7Nbg4Xf5vpVBQi+IcrbBkqohH819OPSzd5
BTj8PH+a/2ehm8Pj7ymmW20DHGpKU5vE/d0cbocz+b8wCHD4L/X/i6mOm0Ph
05/HL2sFODxw4p1q+scVzg9a8dBq134EvyCUK+P7XFcH+0sOmsm6AQ5Rs9dG
atW6OvBrtPd9MgxwWNsYdaowztXBdev1vGlmAQ5nGZr+r3NwdahZrR5sBbR/
X0ZojoeWq4OMU+O2T64BDltL1F4+lHZ1CPs6x9ogIMChpLREqpDN1eHoQxuW
itgAB6tDEVON/7g4nLfL7r6Xi+Dfmj1TyLUOwa+N2Cc1vSfAwZHv/b00dleH
Ny5xj+/NDHBo4l249rqMq4PSpXWHm+YFOLS3W7znUkGEd5zII7N0YwQfFh8A
cmy5Tw==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcx91dFFJujrjWUtf8OVLKzPn7xu9+P2Hc97pOXBJ2Z0aHyqz8
6cb6o5Uu0tyw2kS1ZCaTG7f+YFlR1gOyswrtanabks5WSvfIbT14PXhtnyfv
9/uzK6dIquTY2dmxrAitsK38PS808iwSRM1mzfe5URhdmv5V/F0CntoxwE1A
Ifwbl2XmEPhqxtc6QcHVf/FhF5cg7Fn9GJ1BoSJeW2jhE8xmpfDHSihU+/j2
+O8hGFRdb1NcpiATifqlgQQhzPFFx7sUnq65zNiFECSyBv5MDlNoFPTvzIwl
mGo2pUlZYhxUiU3lCQRGdcJwgtzml2aVVcMvbN5433Jylw+NnMEDn6VxBMHG
FAXnLI06syxKG0rg97U6smGAhsBH4zUXRFBas/qydY6GxE3tpvch2N2amiZn
MUjaPzV+YQfB60jndqMngw/uoS7RPIJ78clBBfsYRKRz7c32BObBxuitycx6
P+yypeSZQgZNLeZV3YoE7zktN8MqGGysvToyu4Egryi33lDAoHTz3iv+rgQ3
5vSJ2ccYdMkPOed5EsgybxsEKQw0+Qqu1psgKb843BDD4GLyknzIn+CU0+jC
iUAG12qOiLTWvlZ/r3T08Bg0O6QqtYkELvNLCbWfaLTnVpotGQRSxfRyaCeN
jx66khAlwa0H6e+2ldHwetVrKSmy3teO6N/G0uhri9NrzxDwLX780w42N/AX
nr8ZEa/75HJ3tXuqGFSH02P3HIJAWf2EzkShQWWuGooi+MF0euvqbHt238n2
/FlK4fCEqFcqJIgMF245l02t52viObD9CIVH7Er1uAdBxhdpxJMYCk70UVX5
JgKTZntwZACF///xH7xBGWM=
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{299.371,
         141.49200000000002`}, {299.371, 130.164}, {290.188, 120.98}, {
        278.85900000000004`, 120.98}, {267.53099999999995`, 120.98}, {258.348,
         130.164}, {258.348, 141.49200000000002`}, {258.348, 152.824}, {
        267.53099999999995`, 162.008}, {278.85900000000004`, 162.008}, {
        290.188, 162.008}, {299.371, 152.824}, {299.371, 
        141.49200000000002`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        272.904071993125, 141.37615644875}, {276.34944454, 141.37615644875}, {
        276.34944454, 140.507703813125}, {272.904071993125, 
        140.507703813125}, {272.904071993125, 141.37615644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4htRbu0vDhc65H6pXuNWluiw/8q63mnbCx32
mrcxJFgmOlzw79pZkYDJj0hpzXGzS3TQO70tPKyj0OHAUoG21MmJDlt7NudO
m13oEPfbRlV5T6JDxduNFWZLCx1q5mQeUniM4Pc9PplWyp4E57O1T+a2kEpy
SGXxOe63CKj+YOyaKs0kB3ujhpT6OYUOsX/6YrVNkxzOT3nOvXxaocPKBWrK
pxySHO45+W/k6y90OF/0qXWmW5LDtMxX2rdaEfy5HTskmOsQ/E3JbVb7ywsd
9r3eLzDHKcnhyq/giXzFhQ4/NPpOClolOaw5FvIpJK/QwSgtpqndMMnhXKyS
55LMQofAQ9pnw5SSHNbu2JOkmVrooCVw8lI0T5JDr3B4zTpgeOx69Nt1Jl+S
w4rusGdXkgsdmt4d1jivleTQ9qWjvzWj0GFKaK/pD7skh0LJ3bkngeZ/ddn3
IsMnyeGNgMJ+L6B72r63f74Yl+TgtKylUqip0OGYY/CB4+lJDnPYZEpc+hF8
o7IG/TezEPy/qRKfTy0pdOhWeZevlpDk8M3Ni23RmkIH0VfK5x8HAP3z2uPO
ui2FDsZunyU3OyY5eFVVt9TvKHRQ55nQeU8PwWeI0u1/LIHgC9XM9Lz3LdHB
5a6njej6QofWtfPl5S4lOuyV9lW7CozfxPs8bGdWJjosWd7GqlNW6LBaVMot
NTrRQTPV69K71Qg+f6yYyb0NCP579RrJSqB7Njg1HNoZk+hgs6/a/822Qgc3
J8lN3gmJDpMei9jN2wk0f5eETFFyokOW/MOsX3sKHcTjxT/VZSc6HC18cJXh
YKHD32Pr5FsqEh3Q0y8A/fZGhw==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{182.707,
         52.992000000000004`}, {182.707, 43.637}, {175.125, 
        36.050999999999995`}, {165.766, 36.050999999999995`}, {156.41, 
        36.050999999999995`}, {148.824, 43.637}, {148.824, 
        52.992000000000004`}, {148.824, 62.348}, {156.41, 
        69.93400000000001}, {165.766, 69.93400000000001}, {175.125, 
        69.93400000000001}, {182.707, 62.348}, {182.707, 
        52.992000000000004`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{
         0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{168.35886490874998`, 
         52.52615034875001}, {168.35886490874998`, 51.629259717500005`}, {
         166.94571527999997`, 51.629259717500005`}, {166.94571527999997`, 
         49.29296900000001}, {165.85194621749997`, 49.29296900000001}, {
         165.85194621749997`, 51.629259717500005`}, {161.91875266874996`, 
         51.629259717500005`}, {161.91875266874996`, 52.52615034875001}, {
         166.32882952874996`, 58.74313370000001}, {166.94571527999997`, 
         58.74313370000001}, {166.94571527999997`, 52.52615034875001}, {
         168.35886490874998`, 52.52615034875001}}, {{165.85194621749997`, 
         52.52615034875001}, {165.85194621749997`, 57.32779653312501}, {
         162.47876242874997`, 52.52615034875001}, {165.85194621749997`, 
         52.52615034875001}}}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{107.887, 55.375}, {116.91400000000002`, 
        55.004}, {128.23399999999998`, 54.539}, {138.465, 54.117}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{138.738, 57.609}, {148.586, 
        53.699000000000005`}, {138.44899999999998`, 50.613}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPU3rWdTkzbEOXVGFd6bf83RYcXmVtu75WIfctR7r
oxi8HFzXWrzzvoLJd/e58pt5jjucz+arpDu5zd1hja9TbsK1WIe/EZ9X6lS4
O4iGe38ouRXroO32cDFzgbuDhIj4RL57sQ5qZzyTLmS4O2xfVfDl2LNYB8Wg
TQpzE90dotKn/pH4Guuw/f7KmR3RCL7HZ86LDn7uDvay3A93V2Py30jo3Z0U
5+7g9dgiR6kPYd4bs7iCklmxDhHG5+feSnd32PugoGjugliHSc9eKUkUuTsc
YLMRN18W63BmJtuK0Bp3h5jyU1dDV8Y6LPux7vvGfgT/deEP9rA1CH6mWo/K
x1wPBykVnyzvScDwWMbYvdfKw4Fjwi4GifJYB5b/25oklTwcNH6tO/cuAsHf
dG218i0HBL/I4WdEpm6sg+sVpua9Zh4Oczb7C/LKxTroLCycvjnew0G7+PFq
bf5YB+G8B6tXdng4HFjD11HLHuvA1P6U8/IeBF/n9zy13H8Ifn/V7T5Bd0+H
448Ls7yEgOHp9qewotXTgeOxsuVu9VgHbj0e923bPR1q56o/OG8L1L9u2oOX
rzwdosvSC+OB7s0Pffiil9nLgfNJ29yNFQi+6KotGhLdCH6oQ/rnjnmxDucY
9zyx/u7pgJ6eANtqCrc=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHVN+6mroylgH7V/Wh8rWejjA+FtK/mZWNHrC+VVS
a/j/HfF02JF20yBrZqxDTG7zowPPPB2WMHjuN6tC8KfV+k82S0Hw9825uc4h
ONbh9bongpVXPR22/Sk7UewW65AXUtcyfZOnw9oYkUfLLGMdPv4U/76139PB
+RV39CTjWIdLimrTt8Yj+C7tv2yslBH8JBPlrHJGTweh60F7FM1iHXyqjkWv
euDh8FBnpuJGq1iH+QnFZz4e9HAQ3/WSMdQ+1mH//VmM+ks8HPw3WD774Rrr
sME9L+9Er4fDO7fJnhv9Yh2WB9u/Tqz3cND4te7cu4hYh7SQXpmPmR4O05/5
TTdLi3XQWVg4fXO8h8Mi51q5uWUI/poFq5cytyP4/rEX1oZOjXUwfsv+8FmW
h8M+z4KyuYtiHUre7Fwf3uDh8OXagTDH5bEOlWmBH7vaEeEd8PmXxfNpCD4s
PgCVisLe
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEcxt2KLohQO2TSHK3lVnNJK08Tv//5i6PM7GA/lxNKOx0dccwt
zMgYwzouaxwtl2TqdM5GpbnM5rJsNZfcM0utlFV4Qaj/K2frxfPi8+L7bN/n
eY7HSq/F6evo6OhyOsVJj5Nop1Y1n0sxvKhRdH5kUVa8XJ5XQLEWekAY+Y7F
sVJ1seFdCovxM/k1L1iQ0ImFy/EU+g8kHX+rWcx4u9ttR1KEr6tupueyGA+r
mx4Kobi3krTwLZGFnl/JmDKAosHSTRgRzKIqu+P5b1+KkogxlLqw6As3lig8
KHZ6Wj6brwpw4mhOk9yFYvOHf7pNnZbVybV78ly13NS2z8phhMFab0WL0p1i
f7rqpG86g6HyJKH4EoW5JIuoPRkkjG1b5jEU0VMVqQNmDOpteVXdwZxft88X
k1WCRl3V7G8Rd2+XX1M0Q/D0E7HniylicgYDDPoJrB00hYYyiqDqRD/PZrKb
z95Ae6fKAgIHZyvZWA6FS0/akoecQLjuNWCWTDG69PDX/UKCxTvVesMJFK0y
/3NLCoInjpm5JVEUmviUroBGgg8WiRniMIqfy2WCIjXBe7dRd9cgCsXLK2Um
AwTDm9IQMZeXj8hornKeoEue6ih2onCWGZ9/Y85AxWOUWzYUXzf4ZaaEgTzh
tHW3OYWM97o5LJPBBc0hRa4RxR9vYU+9ikHDdN5orD7Fyshy1NZ3LWd7W/XJ
nQS7HBct1HV7LMDhyVdTc5YUprq31W0HWfQfmTJ29eb2kHlDNHFd22expu7W
1SwWBu3Fk8pArk/eRMrbcnb3P+kzkzTyiEVrBmPLj6Fon+292KlmEegl4adJ
Kex9N5izgyz+3+M/sKwoLA==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        122.98924642912498`, 50.39521844874999}, {124.95805647599998`, 
        50.39521844874999}, {124.95805647599998`, 49.89895331312499}, {
        122.98924642912498`, 49.89895331312499}, {122.98924642912498`, 
        50.39521844874999}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4v5J61/MKIl3cDykUFewyssBxpfwP3X0zE4v
h3yN3VKHJsU7KDn/9DA+4eXQuMen5evaeIcf5xdN6L/u5TBhheuWr0fjHc7H
+Nx4/czL4YeHvzHXiXiH9D1OkdefIPj8Xzyyyho94PxpwlVyJ1I9HI6bTpsy
81S8Q7evz+TEYA+Hv4eeldiej3fYYWXVa+Ht4XBWQvfWmcvxDj4KM898cPRw
YDvjEc91L95hvRs31yUbDwdBzfJnBe/iHdyXMXbvtULwuRWf/63X8XDQWl/I
JVeGyYepT++IMPnaGu9Qe7/13HFbD4e8/bvFDk2Id9hyYJE3q4uHA/dMz5sP
psY7BOfoi6n4ejjcftdvVzAr3uFA24Vr2WEeDitvX5v/f068wxmff4mXMhB8
F92zaxtaEPwt6l+Vv+Z6wflaZkfTF7d6OfDvF6mrmh3vcC76ZfHXqV4ON1sn
WBXMiHewKusysZ3vBbefp3OOVdpyLwer92bXt/fHO6xM0vrbssbLIeOOysW+
dgT/TPY0oYIWBF9/EkdAYD0w/KNnO6Wt9nKY6F/daVSBGd8wPgCVF/QB
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4ktMBqVyHgkOpx5tmbbjvpdD8MOprq89ExyS
nVaLL7mL4C+6uXylXoUHnK+zsHD65ngPh7d/w9MLvBMcdvNYTrXw93C4FpT4
osUvweHlT7V+fncPh33LszJnBiY4PKnv971j7+Hwbe4uX9uIBIdHaye43rH2
cPizanuibVKCg/syxu69Vgg+t+Lzv/U6Hg7nrWbmXZPG5MPU796aO6VFBWFe
xM5E1QIthH3Lo1Z0/NdNcAicZcCn4unhcLjezFPOKMFBea2TiG+gh8NEJ/E7
D4wTHP5tbp57Jx3BXzf/qsnULgT/9gmfKzOivOD8D00rH6VWezkcDr1QFWiY
4HCcP1jrUJeXg1qN0w4jHQT/o9O+Eg1NBH/3/ctJgaoJDkfSd33oa/dyaA1q
blqrkODQG2O+tKXByyFoTYpgAZD/KWTFq9R6LwcLl0UfX8knOKju0VUrqPNy
eGV6MEEDyO/eMi87sNbL4cLZfw6L5RIc9kqrLI+u8XIIkPxvt1gW4T7/9zMK
rskkOHQ8mp8cWOkFD793twRWGlV4OczOEtE/I5XgELxSWsG9zMvBN8Z4HieQ
v3NhT6pGKYKv0aejV9Dk5YCeXgD2Efyo
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{134.413594861125, 50.63522576874999}, {134.413594861125, 
        52.38777921999999}, {134.942360988, 52.38777921999999}, {
        134.942360988, 50.63522576874999}, {136.693664401125, 
        50.63522576874999}, {136.693664401125, 50.098959413124994`}, {
        134.942360988, 50.098959413124994`}, {134.942360988, 
        48.34765599999999}, {134.413594861125, 48.34765599999999}, {
        134.413594861125, 50.098959413124994`}, {132.662291448, 
        50.098959413124994`}, {132.662291448, 50.63522576874999}, {
        134.413594861125, 50.63522576874999}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/UQq6uvciYkOXVGFd6bf83TIzd9zN2t+okPuWo/1
UQxeDjYxzPa/FmLy3X2u/Gae4w7ns/kq6U5uc3co0OmoY1mc6PA34vNKnQp3
B5WNPAf4liY6aLs9XMxc4O6wtL9owu1liQ5qZzyTLmS4O3yNkj9kvjrRQTFo
k8LcRHcHt52GxxI2JTpsv79yZkc0gu/xmfOig5+7g+WUHItNpZj8NxJ6dyfF
uTvYlzPXPa1DmCegKNbA15roEGF8fu6tdHeHH6XyjModiQ6Tnr1Skihyd/jF
0Xr5fVeiw5mZbCtCa9wdPBzPGNX3JDos+7Hu+8Z+BP914Q/2sDUIfqZaj8rH
XA+HZeK8f382AMNjGWP3XisPh3m+Lh4JxYkOLP+3NUkqeTisa7Jb752C4H/+
sCfSMQLBv7w0+UuHX6KD6xWm5r1mHg7p9/su3HJLdNBZWDh9c7yHg/7+G7JZ
9okOwnkPVq/s8HD4Ff2Oe7J1ogNT+1POy3sQfJ3f89Ry/yH4/VW3+wTdPR1q
v8vX/nQAhqfbn8KKVk8Hue8VTzZ6Jzpw6/G4b9vu6RBx5Zf5njCg/nXTHrx8
5elw/MAsBhage/NDH77oZfZymFe+Sky3BMFfEuUYk1CL4B9ZOuugRHuiwznG
PU+sv3s6oKcnANniDFw=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7eF4xqi+J9FB+5f1obK1Hg4w/paSv5kVjZ5wfpXU
Gv5/Rzwdvu0ITuhsSXSIyW1+dOCZp8Pr1u7l70sQ/JQjfRPfZyL4Py4Hzy9J
THR4ve6JYOVVT4cvzUo6fNGJDnkhdS3TN3k6fDD+uGN5SKLDx5/i37f2ezrs
/pVTOjcw0eGSotr0rfEIvkv7LxsrZQQ/yUQ5q5zR00GpUEDtaVCig0/VsehV
DzwcuOZsvqETmugwP6H4zMeDHg5LH90+URee6LD//ixG/SUeDgfvMu++EJXo
sME9L+9Er4eD4MoNb3TiEx2WB9u/Tqz3cFjXZLfeOyXRIS2kV+ZjpofD04q+
ye+zEh10FhZO3xzv4ZC1XPW6UjGC/+HqHqmwagTf0eS8XH1TooPxW/aHz7I8
HCq15JmVOxMdSt7sXB/e4OEgUuj+uaQ70aEyLfBjVzsivAM+/7J4Pg3Bh8UH
AMcZwv0=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI02EYxqdWVkZpKbJ5KK2WszRJMahtPNHy/9/XPCAkLBX5RFsZUXZA
c2KBoi5FSzuqVOYkQ5odRs3UVJrTjdTa0spT09AQD5SWZDdr3Sh08bv4wXvx
vM/7+iWfjk114nA4DnYC7Tj+g11pE72k2N2WOR6ewUDhMLx+WkuxKtI/qDyf
wRbO4jXBawpu0oRDkJpBUZXi29oOisB79T2GFgbtAl2nxkhhESu8ZX0MJJW5
aWwPheZQXe3gFIPH6uKZBDMFn5/xQ+XM4qtzhi20n0JotdjiAlh0c2V+Y0MU
xiyb3JzCwqepLC/dStEdSQ1djct+sS3nsoQvXfKCgg1nqlVShB1TOSUOU2x9
pUjMHZKC5PCeKD9S8DorxZs2E7h7hdxVWygUyR4mnwiCercdXld7Kdyzj8v7
UwgC7sdnLpgoWry2PYzPJpjb6HI71kBxxz81ZKqMoFr7u1zQSjFSqUFpA1nq
5+cRl+iEdwTRcROlHB2FaUx7U/eFoEAWfl5t70selX1d1EsgLsmPY/UUue1m
2WgrwdHn7p6KLooIoa615inBm2afCuVbChGrEopqCCKCJ4Ue7ylSJq3T1lIC
o5GnUdr7mh1wfbQnkyCmyFOvHKWwtbscXiMh6G/UODdMUkj2zS282EBwrlxo
6p6lKCw8++HWgBSup0zF0/P2ecVIU3StFCNyt1nlAsW6vgPe8yeWvWHRUR8l
WPYuizHvxjMW2+N/pYlnKHxD681cwkK2fyLGY5BinN/hz51jlu754FIW78Jn
Bru+F08l2PMHcw+6/tEzS/tdmfddUadlIFdp2IpOCpnhpGhvDYPVO6sk6W0U
n5LCQptLGPz/j38BrJg0NA==
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        153.35200000000003`, 115.695}, {153.35200000000003`, 106.34}, {
        145.766, 98.754}, {136.41, 98.754}, {127.051, 98.754}, {
        119.46900000000001`, 106.34}, {119.46900000000001`, 115.695}, {
        119.46900000000001`, 125.05499999999999`}, {127.051, 132.637}, {
        136.41, 132.637}, {145.766, 132.637}, {153.35200000000003`, 
        125.05499999999999`}, {153.35200000000003`, 115.695}}}, 
        CurveClosed -> {0}], 
       FilledCurve[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
        
        "], CompressedData["
1:eJxd1Gk01mkYBvAXiYw1ZSmSeJkSIWKocSGa1OhIc8byf17PQ6oTqaRo0Cpb
ymnKSYs1S8soWzHDGRl5iWmoVIppwcRQSYQo5v3C/5z5cH/4fXmW+1zn0vff
uTFQRiAQSEmGSEZaMmbZLeP59ylapBy37jQmmLLU9lA3dUsCVVfZotaXFPvs
V3U/WkUwcGiFf8IbioIz9lXZawiWpl8oXjJEMdL08FD1BoIOp/PxNp8ptJ/b
BlX+SKDk9OdWXxmGwCPN5r4BBL//urlaXYFBvFuqq3EXQfpQSuiduQxx3QGu
pvEEcB/3mZzPsGnhz7llubzX93948Y+Yt6H2u+XnOgn0rqSExWgyVDLdqsdj
BAFPzBcZKDOsGi7x+kNRBIMTgT+YyjJUJbp9KFggQl3D+QVqnygEj+ZWXTIW
gV6X6V/Xy/t9ZkYDaee9eG/IQc9miufiwpbLeiI8fDGr9ngtxbak18u3qIoQ
7ZarcOc3igEPndMGUiK4DuRZjhRS2N2LFfb1EAzHXx46mk/hNCHsq6wjcFFT
vdCYSbHjjJeYNhK893WKWJZHITzy1ka7myAp3rFr7jWKtrSjWffHCSzylFyE
NygsL3b7aSuI8Ljmaa5VCcXp41rqiZoivA0PPRtbTjH001rxmKEIaf0KA99W
UUDv1fFz5iKkN2XFb2+iUPZS6TNwFyFTy9ZQo5Pi5NG8Q8mcCE4brXKiPvGe
2t+UfcRjd4R6DLbvHMV1HiJYqPodLjBhyMydbZ9oJ4JmxPD1YluGiSCNCgPJ
/fX9J+WDHBjkZ96M2TuTt+zfcR7pHWTa4ceEFQkNBAXhyemrVzI0+nCuY6UE
nyeHVydZMyxJ9GtQzyaoUxnd5bCMoeR1itAjmUBWzTQ7wZBBR25L+ulIgjkb
7ka2zWFI1pJRnNxCEFu7NGetkeS98zK+L/MieBU38izQkuHSpZCG/d8R6OZy
JnJ2DPoqreYnVxAcOHPiefgahj2zVUsntCX5VzSyNXdnWOnfWegzyE17+Fjf
L0o1vF3vfhQYx3Jo3Vcdvc2ZoaPw7LwXmzhUd5wa6jVluCYI0rQ34yDoEgut
DRgWB7dEb9DhpvP+YMeuKjlliedMPkuV5DOq9StZyHCwaJRadvAjhZFzvlvE
qC/s2m2SorooVJOVvY0GfWHVZBfx+QFvZ6UnHu41vINrQlPEtyjMrcIcskZ8
YbI/v765gGL3AQfFswIOvWbt489yKIrrFZ4mzeJQEeSc05FBoXtF/rCRBu/t
tzLcXIS8b6+bIatkzqH5Vvup0iyKN24rusxt+PNMlkoX5K3kIJvfFih1mYLp
SB0edOKgYabcNiHJc/C+e/svukj2E4Fy/yLe3W6K8y3LeNuUKHjn3qbQt7cu
j17FISFG/kLqPTq9z7FTwVWxbXR6n81tzZHKPRT/6s8q8lbnkDX6V4XjIG9d
OtnaKumfKX96fFftppqkX6TlvAf1OLhEsieeugwLH1iXfvlG8t5UP824rxlq
wixsuzw53BfUBm4zY8gbHY3BHt71JOn87FTeV195doeUcTDpHJ3hvYQhoKnH
y/ghh73fjpmtX8QwrqnVtbmXw43I+u5qbYbiiwUeadIE76K+aCmqSPpqkdrL
InUC6Z7JkGIBQ1ikSvkBXYLqNKvsyhGKq0HKSY0GZPq//+/rKf8HxVeLRg==

        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{126.082, 102.16799999999999`}, {
        120.62899999999999`, 95.027}, {113.809, 86.09}, {107.62499999999999`, 
        77.992}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{110.348, 75.789}, {101.5, 
        69.965}, {104.785, 80.039}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQLbv7ZuTldxEOm3/HfuxmiXDQT5mnlcsV6aCy9GRU
rmiEwxlbnbfd/Jj8iSX8jE6Pw+D8DyXbZnbeCHMwvmeas0Aw0uHNL7mIsIth
DnOe273fIhrp0PxR9Krj2TCH+Uu4JvhJRjo0mHiZrDgZ5mBnnfKZTSnSoa68
bjLfsTCHh987fkcYRDp42v3yZzmM4At6rMpO2BPmcGztv/u/t0Vg8J9E7Sns
PBLmcLFYJzvpZATcvOLjgflbrkY4SL3gCdIF2udSmFJ493aEw/aDs0R8zoU5
uE/XFyt/GOEQMlvjetblMIfH7PuuTH0S4XDg1J9/EncR/OR2Rfbs1wj+osTs
qRY+4Q4Lt9hndp+NcJiouOzEPKNwh36Fdf/DN0U4fDjbcMRHLdxhfdeis3pT
EHzL9PlKUjUI/s8Lb8JXZkQ4TNix7Mg8g3AHZRdnAd/ICAcW+XvnJF3DHTYx
X1+V7RXhUN4qenNKZLiDuy1T+16nCId3ghIdK4sRfJYzJdPKpiD4W7knnzqx
I9zBryQ1s8s3wuFkobLNn+tA9xWLW/xOinAoTl2tJv0x3IFFT/o+f2WEQ/PS
gs9buCIcHrFFF8yfHOGg+nPqdzZxoLtKquZ83Izgz7FaoR5xDMG/cyHq04mb
wPDzb/56VyDCAT09AQC38BbS
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zh935WpTyIcmr2dU35nhzvA+Cc4VCz+XEXwV0X/
5tr/PdzB/vsZ/VVXIhxkWNNLFnBEOGhPtNlXthXBl+VznlQ2H8F31T27tqEv
wuHxUvGeP//DHWx7s45vboxwWFKRcrT7XbiDyVv2h89KIhzSvDf+k7ob7nCq
6n/kpbwIh7D4HeekjiL4ApMWKd5dhuDPe2G24/fUcIeZ6W67EwsjHKZ0cxhO
bQ13yNjbo/CxNMJh77+4lxZl4Q7zvO4yTK2KcPDd96k5PD3c4ZqD7lMLoP1u
RTFWKjHhDqXX2zw+dkY4OP448uNDSLjD+q5FZ/WmRDgs+JE90cIr3EGu3Gla
2cIIBxb5e+ckXcMdNK8UyN7diOAbG85f4nwIwb/29vCaqRciHNhdVxZvBup3
vZVcevduhMMKF6bb2aHhDtXpW0IbHwHDk/FcNWskInxFTyyavzkBwYfFBwBZ
OcLP
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx11Ok3LphbUKx1AmU7nU0nD2XWyisrD+/9+zMPfklEtiiai5
hGOUjcqa28GRw9Fq6myFkeMQq0bhxHIsxiZJl6m16Lxi68XnxefNs+f7fB/b
qKTgWEM9PT19HU46DHRoS0sfCTsJo905gVb5DDutpm/39hDO/25xSrzO0CCU
Ffu1E1aVIlVJIsPrucHpvDrC8q6pj92RDFFDjjbe9wiW/mtH/55lCF24ozEu
I7SpwlI7AhiK3+eMagsIIk1nyyVvBqG5vN0th+CeVWZvdIDBf1Hv4lgK4bMi
I33QjKGlObXxWQJBrDqBwFl+w/0Kv2252bbpPXudSkcyeWQGF8i0yYTU7dl3
I4N5nLGLCZRm6fYVzDbtduXxJWbFojeXIHye2GUv5OHQblq5LtHNO6hKV5vx
cC5vmHSrIFwOn38jMOThluZpG1dNqC413n98lUN9h6zAr41QUfWhcXKB27jP
1ytP7xdNcGjtMk6xeEHIV8ykTb7lMJbv3B+kIPA93zMFGg4XDEr0t0kJL28N
1DzWcnBRJt0YriKo9SNm5uY5hDeGXZOWE2J9l2SCZQ6st/9wchHhmHwoQP2L
Q5AkOliaTTDNfLhSJODhszXBQRpPyDNqra3W5fGQe9Z4MdL1oHyl9uCxtmqz
Z/00oWnSYFwcwqPPV1DR40NYXDz1yTyRh6M4faReRIg5YuneJdn0NrHL7B/5
pteuDeeyeR5V8YoJ6yDCz8Cp0EpLhpPNwybJaYSrJZpDcr/NPp80/1AuhDBI
RDnj2kLC0rkdIodwtpFvX5Nzd3Qcg6uJl3XcA0KfV4GdVRLDu4GIfcoWwtpy
nYwyGP7/x38W1TU+
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        103.91502742912499`, 94.72725044874998}, {105.883837476, 
        94.72725044874998}, {105.883837476, 94.23098531312499}, {
        103.91502742912499`, 94.23098531312499}, {103.91502742912499`, 
        94.72725044874998}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYjHlxc9vrI9y6Ftv6lSRFeEA4/8q5UpTK4pw
+LZjnSTTuSiHf+8XLo+sjHDg8HVoNn0Z5ZC1rew0e2OEg7il5WZTxmiHqzXe
77d2RDjU33Qy8mKOdli45tj61e0IfukJT4vfoeFwvmVEkpCKR7iD37HOyTdZ
ox2MS0+f+WAX7tASfKu4liva4VT2Ic87VuEOISsVbvLwRztMuVeYaWEW7tAb
YxPnJRntcPSjFsdK43CHGTuznm7QjHaYqLjsxDwjBP/zPQmmBu1wh432qZxx
G6Mw+DD17yR8jE0PRjno2GW8UjYJd/jqv16U6UyUw/F131Y4mYc7TNK0vaFw
McphOost3yXrcIek+mbbDVejHM5O7H1X6hDuYJBzap79jSiHyyUqJis9EXz+
p9xRDeEIvscj+alWPhFwftNL9u2CEREO0/w5anddi3II+SO51yohwiFBrMVy
w+Uoh+7OrLn3UiLg9n+ZVKzwOSPC4WC91rXvp6IcDtXvamzKjnB4nyNx4dwh
BD/4T6fghv0I/jalP34Td0U5fP1dpPIZGL8SD/I6ijZjxjeMDwA3G+jH
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYq1pwS9rTkc7XN5f7yfTGuGgGyzfJXY+2mH+
+198Qi0Ivr31z/DwwHA4n0X+3jlJ13CHpJ7FZxUuRTucvnLQ945NuIOR2bbz
njeiHZJO7zh13CLcgfnBiYtF96IdEvjeauqZhjsUncmYtet1tEPc0reqesbh
DvXPkg7t+h/tMFFx2Yl5Rgj+53sSTA3a4Q4qbGp33hRh8mHq//w+p+7ZgjDP
nHm7p8IEhH1XXV0E7KdHO0ybbct1yTLcgW9CwsSa+dEO/5e49T6zDXdYJaq0
nXFxtEOuxvNAPU8E31VuwtyuKAT/9ibv3B6nCDj/KX/Vl09BEQ68NlO+PJob
7RB4zU9iYVSEw+WOivylkxH8TLGCFxN6Efy//rOPPGqNdghoaqpmj4xwmGj6
i3l2TbTDlj8HQptCIxy0Xu5RVADyn1dU/vgUEuHwTcLikWh1tEODjo1YBZAf
86f0wITKaIfNK77seBEc4aCh87GhrSLawSdm+7VcIF/t8MeatjKE+1TzVR+8
KYl22GT/dcuLwAh4+D3ZvTY8EsjfkyoTe6Mg2kFc2XhyckCEg5JnlHVwfrSD
1/zXplf8EfzGqdZSFWFA96GlFwCVbPsz
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx10yygplViNGNCk7zlFLafXdEmuZ5vb//+LhBR3huFYWcpkQ
oSM6VhSGhGNuk8uSNI1VZI0JneaSOLayWiVzzHReOVsvPi8+2/Pieb7fxzok
1kesq6Wlpa3GQY2OGrPNutSuCEJ281yC4gOH2Xi+fI+Y8PN6Z+mdSQ4+sYU1
0hsEVereLE7Jwb4+yss7m6BjeTPywB8Osv6dRqVSwsQyM1nc5FBW+8Rv+AHB
LX5t3NGQR1R3Z8BKJSFjbnZ92z4eE2n5aTV1hPzTRpmSQzyaqo/1bz4jjBra
OTV48Liw0J9r+YLgt+IfZntV4/Lmy2dD6jUu3O3YY/yJR7Jr6+2VDkL64am2
DF2Gp5LRGZGcsC68Vv3WlsG1dqMnq5pQtSlY8nJhCC/+1hFYRkgsmBI0ejCE
tvjF2RcRPKnrY7Qvw19Ze8tsDuH5DP+oI5jBd1JaJ00iBD1OqdGPZlv5XFmT
O8SkMrSaR1aekhDG+tK9LLIZrAx2hGclEsoSQt9PpzDczZcfGc4kCFqkDU4J
DIPjg03bCwhFUdrzJjEMD5cm20UyQsGviKrpMIaKodg1cTnB6nVJklMQQ63O
mEJUT/ja08Rf8mZozx7Wd35JiBY01rsdZ+j9opKWjhAKJRVp5vsZVkvMTCcm
CW3Fwcv5OgzC86JS03n1/C3TOaWSx4jNq0DnJcJvF/eiE+80fm7ooFjZoHEf
l7yBvBgeZJfr3z1O2FAmf/c8yaNxIcI6rI0wO5cj89yl6fOMNOSeSpuH5GIX
t6LeX0/hbti7ym3d5/zmqJ7sB4eBDJVxXB7hvlBRpVjkYDMwbmCZQghI67Oo
+Mzh/3/8Bxv5Pbo=
        "]]}, 
      Thickness[0.006600660066006601]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{158.512, 68.492}, {155.359, 75.223}, {
        151.586, 83.277}, {148.059, 90.812}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.85500000000002`, 
        89.398}, {143.785, 99.938}, {151.195, 92.367}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
      FaceForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 
         0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1HtQVFUcB3CGHUBxIBMSkKFamHCQyJGUxVHabxCMvBK3c1dencMjiocI
yhqKAgXKwylFllCTBmTkYcAEOLyEVQh5qCAQyUNBqcUpAlJYMcmgNnbgztQf
d37zmTn33vP7nfP7CUNiJGHaWlpaRP38GzO06vykKQzRoa06UikHXZM0q/t7
eTsZDOglU4bcAbNr824ccOtiqWkIg8psrqbEkfdxO26a2fI21Jc4expx2F93
uvCxH8OduPz4e38ThPoHm2e6M2QL6vcIZgl8F+xzLLczPHaTu1cpCbxEOqub
rBkmu17oJY0QDPd2L2Id70EjbVpiyDvfovqIYBVDvY9LmMEoQVdt/wAWKU5M
KGwED/7vs4m75Q4veLf37zxjMEfR0OAcYfCQoMWvaPe9abryvZOhXJTDLxQp
rbPHI4aI5r0xivULFsGNvQTvq6Jd2TDFy6lpr2XcJPB0KLzUdpeiZG3SubhW
3vqiJ3fJNd75sebVxbUEQn+vX4VKigjlrT7taoKwyNynbQsU24zcsp9XEmSp
Ug63ixnspQkztIIgwul5UJOEoWu100vj5WSl3p3KA5EeJQQV3s7RQdEMc8fk
HenfEJj3/byl9DBD4814Zw85Qf23sU/bExmu2LwSmJjGeyQvylgYzztPt8G9
MlR9Hlk9byfLGOiwTqpYwv8v3Stwh9KZ4E8f33MyVwbX+dGeIVuCxGcz+nJL
hsFDTmvOvE6wedTV2HKerlgSrZOePcZ7qW63KQwFpya3vkFQMLyhtvgqRYJ9
iJHyLaLJ6zKF93nUFjkS2Hib6mUXUFhGvPph+Hu8//iis+DGHt4fNeV1Hgwg
sNUfL7G9RCGyOhq1LUx9/r31t4fLKJx011WF7yeaOldTuEyUPrugzn/pnJop
qva5NypTCL6rHEvCDxRpWapFcRbBpws35rU7KawiP2+hXxEcSLWr71GvV13v
sP79PEFMe7CJg4Ku1F9X4ZsjbFDvbzsLF14kiCrIPZhXR9Fxuqi7soj3lumE
aVrGeynWEAx8HJXrcZ1CHCszYy0ExpA0C3sojo0FiB16iCb28fdxg9WEDjdE
NfdykMCy1XNK+Iiu9JdHd2FBWz/FqdGp8ogpPp+c5tTZvDk+/+V+Xd7/qo2N
f5nocxBofalKr6GINwpoYya8U2Izvdo38t601vVrTzGHnR6XZW3qeog2ib/3
/IBDhcr4QfEdikMC6ynLUE7TZw8pPgsicZlxHGzrEmIyVBST1jZnRUc5/Ch1
UBisYSt2cRk4wZnyTr6iKHtTPS9+U9jIRUc4NFoV9Qm2MniPX+g1lXEItFp0
bHqHYf1ezyeyGA6bT47cT9rF8JNFR3nkPg7aM1eT3lX3U0Kiwk4ayWGHj/4n
j/x5L8/H/3p5Pv4D951aCg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQvf1P2Yniu3EOQQfy9pv2hzis3/CgzuFSnEPtnCPV
NxtDHASb2+Q7Tsc5lO/UNVtWEeJwx5PpTu2JOIdb9+cXtxeHOCwXqJtRfDTO
wZZNaGNGXojDsj0bf988HOdg+cCN53wGgn++qfCNQjKC/3vTZNe48BCH1Wae
trxA82NkrB4t9QtxkFJ+yRp6I85h78010u3uIQ5hky9o6zyLc5BfE7TnnEOI
w2+eg1fEf8Q5tKhNnOZpG+Jgm2DvoMQfD+e/FJh8+pY2gj9pg59kgnO8Q3DN
9d83HEMcLt5lfHAhJN4hMj7Pkcc7xKEs/FPHnrR4h2OV/EwhIUD/b3MsTMiP
d5jl+XaFWAKCvyTIf/LjPARfIPdDsDYwPO4n/Oa+mBXv4JHsYHG+LsSB55dM
Jl9ivMPGHM/dj5tCHNjE25Rvh8c7bNYUjaltA7p/Z/icEvd4hy2TRBJqO0Ic
gqTm+L3XR/A5J+xikOBD8H88+6pf9ynOQcZY7v7ErhAH9PgCAGm8yS8=
         
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3fpyrybzgziHGOV/FntsQh1g/INsNuLm1gi+92OL
HCXlUIfdZXxcy5/EOSxl8Nxvxh/q0Hf3zZrMd3EO54rnl9/6H+Lwm+fgFfEf
cQ4/nn3Vr/sQ4jA34dmNTJZ4hx4FRZ4LL0Icit/2KxwTRvA99uYe75BH8P0W
sPDu0Yh3+Kqp1f/kTYhDkNQcv/f68Q5TDjR/mvM1xOFjjKYon3m8Q9rlqT+O
/g1x+Cz5detyq3iHK2Fme3k5Q+H8cuHoo/HiCP7ryknnb2mHOoQ5pH/uMI13
iHtw8maoQ6jDNge+ngta8Q6X3BifXAgJdaj99pFrslK8w93F+tnmqaEOTreu
NYaKxTt4ZLH0P80JdbhokC1RworgT9Ns/jbnZxycP8HtzYbMD3EO9xN+c1/M
CHWICJhz5ujLOAeHUwtXSCSEOihG+bxQfBznkLe9f9H7cET4Gm9Y3iDhg+DD
4gMAX9W+Sw==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx39E4iZKQugyRQ/UjBY211tNXF1/dH1/lOH3ZdMVNnFJD8ZN
cnWtRQ+mZNVRWrOLPD/VdjO3PJ1LK+SZ2aSspmuYWr+/3NYf7z9e+3z+eL8/
n7dHQqo0cQ3DMGa8dvMy5+VQcyVetJ3iTFr0seFZFpol9YkCL4rlV9e9906y
MC7n90rdKVRJLlpJPwtVnPPltM0UuZ31X3I6WBCDrrhnA4VmeSCgrZmFgVsx
+ttSIDPwfMZrFmcjF9KF1hQGVXGFr5qF/8K6+AhLig7fpG26QhYFWll2wB8O
CkrkN+UsfuYMNTj+5vD3omfIerGJh4J6zEM3mph8srh1d5xAu+t7k2iFw9q2
U/c9Ggi6shKrGAveb/3bssEHBFu2VjoUWFFUp4hbpnIJDhwO/qgRUAyNPZEr
5QTNtZaZEfYUlvba7nYZQYiXwWVyE4UfpneYxxBkHFF2S90odkrq1CXHyep9
8rwKi8QhBEtHG0ObPCmcaWt6yX6COxrxt8/8/tf03kvt/HwgZck6wIkiMqjs
cXoYQUt4stjRgSK6Jnj0uYRAKkroYOwoFo268vaTBPruIk+ZDUV3zItwZSyB
xC/xDcPf66lP3rz4HIFqrC/Q7BcHp6b80rhrBDm56upHUxyMWfd0ylKCMH2+
T+wgh6DbI/17GgkEbskVQj2H7FLvcf0HgtRDI9NMJ4fFGeO+7B8mhrtgosWe
XWX/qgqFs4TFxEHHuavDHG4wDacjFSzev3toJ2MoBKJan+RK0z+PROvrXjay
mLVZuCDk/Sts54JntOxqvsYoq1bPLhataQanST5/1DwVDvN9su2bchW4UhQ+
yyp3GWXxfx//AQFaKiI=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        130.09264412112498`, 84.30146844875}, {132.06145416799998`, 
        84.30146844875}, {132.06145416799998`, 83.805203313125}, {
        130.09264412112498`, 83.805203313125}, {130.09264412112498`, 
        84.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr2/LLWz5yY4KCYK2FucD3WA8XvVnyY9uxbq
IHeCS2zDmgSHiQtrlkjeC3VQn3T5lOeuBIe/6YEnjj8NddDnuPDI81iCQ4ae
2pvSt6EOyTdClEKOJziYxC1ck/0GweeoUjHdvSsEzj/Dacv/ZE2Iwym/H5dm
n0hwOKa27OSGxSEOqVMVDr89leAQKzvXbc78EAffA4dLTc8mOKhP8En7MSvE
4dXMQIuQSwkOEYtZWTNnhDjkn3hR3X4rwUHlcsPRuOkIftuEz//sJ4Q4VHM/
442bh8mHqZequLnIc1mCw/73Ts8fA82bK8wtsmF1gkNUwsWlTHNCHHIYgkrt
1yU4aG0T5560IMQhRPurevuGBIcE54zXpktDHHYvnHHj3MYEhzS1/waZ6xD8
RdOehTnsQfBvTf418deGUDhfdPajzRf3hDrkTd7uzgPkP1/7ZeevI6EOl8u+
qravT3CQs3adNe9kKNz+dhc/2c1nQx1aVnt80QK6L9Rwap3ThVAH6UX2hWLL
EfyzmT8E25ci+P9qNm74vijBoWOtr+JmYPyuv53lmzEfM75hfAC9Svhw
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4h1md2tztRMd0gqjvO+8DHWwFHX2s9JNdDBa
eJX70gsE/9KbyyHi20Lg/OkXdpy+uTLE4bIha8F+vUSHuLY5XnMWhjjsaeP7
eNkw0eFrzeTj7XNDHJbcFi96YZLo8Hn/cbV3M0Mc7lxMD+uxTnT4GHZC6d30
EIdH91KyelwTHVQuNxyNQ+K3Tfj8z35CiMPWPLdy1f8JGHyY+oUvpeZeZkeY
Z/eWT28/L8K+3r7QiX6CiQ6avhLsk+aFOKzc/DgwVzTRYVKYYteyRSEO5WVH
nuiLJzow3Dro924tgn/jfNYsr/0Ifl6KWpbP8lA4v+JgyMdN20MdVnbWNi8Q
SXR40q4pmrg/1IFnw/sDjfwI/vWy7NpyHgR/oXBj9gKORIfHxrEVx/eGOmS3
GXT/YU50cF83O8hpV6iDxQNBqf1AfpVWyNdNO0Md5Cr8f1kC+cL3xIQtgPwL
mXmZ5UyJDm5R57eu2BHqsI1xjecnxkSH+7yTLusC+Wa+a9w/MSDcZ6rsVqkK
5Lt+PL9xxbZQePiV53aESAL5jfMOmkv/S3BYdYV3gvLWUAfjCQ+WRfxNcLgb
cMxoyhYEX8RdTNxid6gDenoBADjYA9g=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        139.84494155712497`, 84.30146844875}, {141.81375160399998`, 
        84.30146844875}, {141.81375160399998`, 83.805203313125}, {
        139.84494155712497`, 83.805203313125}, {139.84494155712497`, 
        84.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4g094v7rriY6KCYK2FucD3WA8XvVnyY9uxbq
sCBc9sWhJ4kOExfWLJG8F+qwUvHZnJhPiQ5/0wNPHH8a6rBx+qMtMf8SHTL0
1N6Uvg11eJqe/iXtf6KDSdzCNdlvEHyOKhXT3btC4PwznLb8T9aEOPjc41q6
jiHJ4ZjaspMbFoc4PFcxnsrAnOQQKzvXbc78EIfz/tfcPViTHNQn+KT9mBXi
kKOZwpXOleQQsZiVNXNGiMPH8N++s4SSHFQuNxyNm47gt034/M9+QojD31k/
7hdcS8Tgw9TPYX9TEnMv0WH/e6fnj4HmyS+WfXbocaJDVMLFpUxzQhze9ae4
Bz1LdNDaJs49aUGIw7Vd7L9mvkh0SHDOeG26NMTB1nD1qocvEx3S1P4bZK5D
8BdNexbmsAfBvzX518RfG0LhfNHZjzZf3BPq8EHplKQ8kP987Zedv46EOoSy
cfyY+TzRQc7adda8k6Fw+9td/GQ3nw11YLOOPmYLdF+o4dQ6pwuhDnMNg5w1
7yP4/j+5nsy8i+A38Bxp4rqd6NCx1ldxMzB+DbNr5auvY8Y3jA8ATCD79w==

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltIk2EcBnArS8NSo5UolKdKpDSlwhPY06xE3Izkey0kbL2pJC6tMCMV
Np1ttghN1Epqms2yZmCec24GW7Ok4TqYhxKTxJSEbS6M0qSvqw/q4rn4Xf2P
/jQ3OWOVk5PTCjYhbFaycSs0dx2rpGj7oAkcG2JwJ73fL66UQl7hWN5fwcB9
493frX7/W9mpvz9azeDy0eF2fhLF7vFDvIAfDBTvLZ/56RQ+Fon56XYC9xrz
Aj+Xwjm1p+RAMufux+e+mwo5/3wUYIi4QTBf2+hsz6aIHB662tRAoFUTP2EG
xfpFidm5hcBSKV1WpVEUffWtEegIpryaR2yEon08t8BmIDA2zKmzEznbM/Is
F/mc613oa0EMxZQieNOpPoJBRcct2z6KDf6JF1QdBII5WZAyjCK2Rzz4UUNQ
JB52hOykyDQaZJJagonKhHCPHRS9lpjbomIC/jNtju3vPnQlv6wygoP5Cg/l
Noq3jpuaEDUBb2FP3HQwBS9+s1ekliCTORzvEU7x7V1fWtUAgbyurrk/mmKX
PtakmiAIchhbvOPZeudTEz/NEnjpBxJCUzhHm6xHpKc5P0yo4L3MoTCNOc0E
ThIUyF1ndZcoyp4I/dsGCaRZdaF2KUVLl3ooRc/Ou1cgEl6hcC2eufamifPJ
66J7reWcJ0SLbm/OsPN752iVBRRGg0u3JZbgbE1euZK9L7a4TWo9CbYGLy1K
oijW6I5X+Xex/3CiwceezzlMNb9UVcRZaJDq2th+6kd9Oh90M0hKmS6XyijW
fgmM0vYyiNBYPavlFOvqraPMcwZi97EAsZK9j0zuW/aKgVXS+GJ1OUWJYb40
a4TBv//7ByRcU08=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE3AUxtUsxdyEbuhDmhJK5px4eZCafoIEOock/392o8bJS1qipiWi
0gUVRyotKUxzmpRWSNg0MV0XNy/kJW+h1iZLl9QsUasHNcz25KCH7+EH34Fz
vu94Unpc4hYbGxtbi3wtsrOoec2tqkZNcJVrLlWHMOxuXX4ibSYUeivvRkkY
3qsFIsVLQpn417U9MQyhsfk3Ut8S7gzzZNNxhnTDIAl7CKm1QcKGBIafssqt
j98RJr0+jC2kM5yKf1CiGSLsquhc6S5gUHbcrKoYJbgvma8eLGfIG5RrIqYI
ia82/FKaGAbSGj1G9YSvDQHnvkxYWSIPh5eAb3K3zqF9JIxj1lWl0ljmd0y3
PIs4z7ESIJbqxwjlJlmtQsGhHYoMtR8mBD93mhPWcJzoPtS22E/YHtbqd6GJ
YyIuY+exXoJRcHtc1M5R1+MRpO4iyJSBlZd1HLHJArGig7Aki6/rG+Wb+aw9
LfLxn+VYd/zjK28hJGWelBrMHCEb0S72Fr/IJ6xfNcPxA9XLjW8IWnlKw9JH
DsekA+peHWG/u8E4OsaRmR4You8jeDyMVKkGOH5/Xp/MHiSoszOuLHVx5OSL
o/SWvHLSSphbG8dfid9ZvYFgM1P0yP4+R+FFXb1wjuC1NzdPf53D88jRRNE8
ITIydF6azPHaw+gTs2jxBy9ON8ZwlDp7K/TLhOL5feWr/laeyrelRqGV58wJ
2uhxhnGB0zbVN8Kte9zsXMuwtrD2PXuCkFVBSucsa59j4ZKyjiSGT/UPijWW
/StLPR0LTrPN+3pzXewYY3A4rDOtagnepheqailD23SzcaSTsCCucjsTwfD/
P/4DtsA+fA==
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        228.21099999999998`, 112.65199999999999`}, {228.21099999999998`, 
        103.29700000000001`}, {220.629, 95.71100000000001}, {
        211.26999999999998`, 95.71100000000001}, {201.914, 
        95.71100000000001}, {194.33200000000002`, 103.29700000000001`}, {
        194.33200000000002`, 112.65199999999999`}, {194.33200000000002`, 
        122.012}, {201.914, 129.594}, {211.26999999999998`, 129.594}, {
        220.629, 129.594}, {228.21099999999998`, 122.012}, {
        228.21099999999998`, 112.65199999999999`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4i1nlfw+7MlySKx8HX52W7RD08HPUT5LshxA
ahhsox0Wb1+1SeBbJgbfIvLf9TNu0Q7x65jfn3bNcmC7I8LN/THaIc/wr5RP
TpaDc3uuZ5tTjMPXTz8NeuqzHOpPHmtunIDgLwlvP6N1E8GfPE9KbMO/GIfz
Cnrn9lQC1QuvDzeVjXVorpnGIZeX5eDQKbhrmkmswyLH1PDcpCyHGxcdXK94
xzocmGuyyCY4y0Gl7AZXcXisg/7rrOmXHRB8O032QlVDBD/j/qItc1WyHJgz
ihUq/GMd1vDaJdlIZzmUP+KflGwX6xC91F7lpGCWw5uYNcz+urEOCy7fupjO
keWgIeo98y1frEN8Jz9r0f9Mh1sbWpd8fxTjIGfvYlEDDI/foa+7ip7HOITo
O/Oc/JPp0J1bHXBPPtaBn3FFnBZblsM6a74sA49Yh2dePNKbhLIcCqQKLggm
xzrctby2d4tylsOkeuZnj9tjHTpT5hu5WGY5iIjMqj8/M9bBRvWc+opgBD+D
Zfq871kI/v/Hx1S31mU5zLt5/l5PV6zDh6VaPsl9WQ4bU6znsufEOsS8V/9R
My/L4Z3MLaNlvrEO03l6PeSWZTlcXSEs9Fcdwe9w8ZNl/xMD56/pUJv0Z3uM
Q/clzR2ek7McJr42sqvJi3Go9TfoOQmMXy9/Xu4bsjEOvumLvcoVsxzu7lbv
5mqMdgh7pPXkTw+Cr3jp0PLb0xD8h+l9RYJA97wQ/dK8uTnaoXZK773vi4D+
EVVLvt4V7aBxf//u6BVZDp6squYqE6MdboRFiIqsz3LY6qf02HZhtEPf77DX
CtuzHJrkAu08dkc7oKdfAJ4DNzw=
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{176.094, 66.531}, {181.54299999999998`, 
        73.67599999999999}, {188.363, 82.617}, {194.54299999999998`, 
        90.723}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{191.824, 92.926}, {200.672, 
        98.754}, {197.39100000000002`, 88.67999999999999}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3X/3zZpMtxSHM7Y6b7vVQx0kjPynmoWkONg+nx6W
axHq8Fxu2rejYZj8Vdvu/nFkC4Hzuba3TO38Hewg/V7K7EJ4igOr7dvgsC/B
DueL55ffikxxmGP85ILjh2CHgCBWj+XRKQ4zyyQMVrwJdlggu6mSOSHFYfpO
n36+l8EOH6uP1OqkpzgkNZzwZnmG4Gt1VaQn3A92eBL2/32tFib/75yu3M7n
wQ6vLKeZbjRGmLf78QrzW5YpDsZat311gfYttti0451NisMF5kwBn4/BDktP
i3fvtk9xyL377VLWt2CHz8zxr7wcUxxu8pz+JcEQAufXnHzPlM2H4O9ebDnR
Ij/EIfDW/C1HTYHhkVxyZF5oiIOnwPX/2hopDpwC/gd8PEMcIl0vpolLIvjz
NvsL8vIi+HUZ31aHMKc4rPxVcmBecIiD0CLFjmW/kx1kE9eckswIcbjVmH3V
9Euyw4Tjj69MqQlxWCrXeDjuQ7IDR8iz5pXTEHxZPudJZdsR/HO+icdO3A5x
0Ni1yeTo12SHR5s/mv/5FeJwcif3nFqGFIee5ZVK0iKhDszTe9+3cwPj57nd
+y26oQ5Fzbo7zkukONhZp3xmswp18LSyPfdDA8H3l70irGOE4Odn6FY+sQaG
38TAj3eNQx3Q0xMAH1YRgA==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zk5/pWXY4rDnF7BhN99IQ4w/kOvT8Z/fiD4h+ee
ZNsvFeqwsPqZeKhlioOpu2nBAu1Qh2kecvG7NRF8/nZFz91yCP7iac/CHMRS
HP48f9r+RynUYb7b1sc3+VMc9u4yOtgtGOow+1tzQTFnikN9b/0vKYZQh7S9
/3Uy2VIc8he2nZJ6EQLna14pkL17EsHfrsW65feOEIezxovvbmBPcVh79prO
1BUhDlvj3Cb8AJp3zUH3qcXMEIeApXkNXjwpDmkMB+vDu0IcchZMK5oDtD9+
i5aZSn2Iw55s5yU/hFMcoqwmf/lQHuIQ6XoxTVwyxWGnlVWvRW6IwwRrRe/d
8ikOsolrTklmhDiIZu3oe6eO4M+e4X9J0QDBf/Mt8ZqXeYqDQnt5/magfpW3
G3e9s01xONh24Vp2RYjDfuNbqxwcgOHpPKectQYRvnpchbM3NyP4sPgAAEPQ
tPw=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx7ccM5ap+ZB4ychiZZeFtywU+2bgMsya+/2bYYHmT8FENwWd
JVjWSobXOZWWblrLa3hhJF5CV4ozL4iNRPCSSgVmE7o9RGr2f3LQw/fh83DO
+Z7vOQduymOTHTgcDpfVUVY7WGWKxXFlbRQ2bsxF72YGTqXyC8sdFPdCbwsz
6hlIy6TDxkYK13WnN8UaBis/PskH6yh2xrfOmlUMTMmVZT41FEFFE4GbuQxO
/nprU1VTWByPy7vSGVhWzamKCgqZV3FjegKD8sJpma6UInrgxn7HKwwasjmn
vhZS8L+Ls0b9GVx932uNV1GoHN3DYhztnDD2mlswRbZ5NuW32mogOOs3JFWw
9cWXorWJ2QR+ewKaJCWsX7HpmQchyDXlCpbLKUI2w/oOniOonOGPb1Wy/RTa
rBF/Avcoa7pOR1FU3zXOExI86dO7BhoouqdmDkV4ElhnpUPGBor2+eanc7vI
dj6CblWVel0K2aLqtIDNz/CtI3PupxS2iL0fj7B5KRwGlbwNKYK5Fs7Deor5
0eoakwOBx3wIUmopls6LFj4LCDqton7JY4r8R6+MPDeCE4lJnj1aitg1XeSI
F0HLsH+LhM1L2K9cUx8m8OUFayUPKPRRd2oN7D76af1lnzyKvN2FlpF4As6G
S8lWNoV53ztrWg5Bku/9sSUFBU/kteiiIagKDk2VZLDzlF9EA+12trT9XVyf
tHMvau7GCRjEBMlspUoKZ01rXHU4AyFJ4feoKTSTTcde3LLfc2J18OVKDoPI
OnOagvXPN3w4IyxgtvcLX/nTl6Rm4Mk3OAfqKRbyiY93BYM02ul2/TmFe4DC
eK2Wwf//+A/qjCqZ
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr+Hbze/PpbisPwjs11Fb6gDjC+840ai2tRQ
B7s1n30YrqU4iBsVLI6cE+rgXraHcdbjFIfmHy7H2ZeEOvi/2SE5632Kw7t9
kq+3rg51aN5jG7nkQ4rDrndTVq9eheD3cUmY/K4IgfODZhnwqWSHOLwyesj5
5mOKg8/2mSc+JIY4tFZy/rL9kuLweO0E1zuxIQ65S9asaf2W4rBWwSHVIjLE
gavOKn/J7xSHe8Y/mVeGhTj0r7m46TpzqsOq5JIj80IRfB7F53/r/UIcZr8/
57LueAoGH6beKubQzZnnUxxcG8yeKYeHOOz9/tmL4WqKw4MPR5Y4RYU49Dyx
WtN/PcVhgxs316W4EIcS/ntx12+mODy7HP2qNDnE4XZrI7/87RSHN9s+6a/M
QfA11G+FNlQh+Akq7yZY5YfC+bO1r20SrA516CtfUBdzK8Uh1+7FDqvmUIfP
Ufdirt9IcVhy2mLmvfZQuP28Vx1lPneHOizpN9SuvpLicPtgR21TX6iDdZvG
irQLCP5b34ce188h+HKJs567n0lx4LNzVPgMjN/z+4NbdpzAjG8YHwCbIgMy

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4pXnF8tMbU51sEyfryQ1JcTBaufc1obSVAce
xed/6/1CHNakFyd9EMTkC7hvWiQZEuIgvmytZIN9qsPWXEvhpK0hDqqay10b
QlMdFiQUn/n4GKj+1eLohoRUh65XaxsbBULhfDvrlM9sVgh+vZXYoXL/UIcJ
76sz9WJTHfaln+x4kRDqEPlTu7UrLNVhcnfxGZe8UIe852HJd/xTHZgqhKf2
VIc6NOU02eq5pzpY5SVXGjSFOiR9P8S50gbB79/lZbrZGMG3i7Ew7NJJdciS
kBVZWBvqkHun+6+ueqrD9I12hfeKQx1eOUT1HFdMdTjilXBOOivUQerg2ohs
mVSHNyHbm/ZHhDrUPpef5iOe6uCUqD9jgX2owwPeSZd1hYDh4Vf2U98p1OHR
qdiS46KpDhEt3atyk0IdNnlxrVCWTnWYdZ1TrKIy1IFlpcwaH6VUh8KUzbFX
OkIdVL6UCrIC3bPJz+jovbmhDkfdZ4uGWwDtY/TzklkR6rBVaOG6bHcE/4bU
sS17QxB813lplazA8PPJ/vIseX6og8Tte76/M1Id+OwcFT73hjrI7SudrFeU
6mDmMePKtBqgfzuVjnaVpTr0Cd7pEkxH8J/Khiz45Ivgp358xyWoDvR/novC
iexUB6+Q39sE/oY4cL/2+nIcGL/H1v67//tciMOe2ksJe7VSHXp8fSYnlgLT
w8aKer0MBP/cpxOJl3IR/Nfi4UofC1Md1LL4tj4rC3F4s2rPl70lqQ79xeIW
v6tCHK7+P1p6qTzVYZLB4xtT6kIcuJI3tK+sBsaPcJXcifYQh94r1VrODakO
HCHPmldOC3FAT78AFGM2bA==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{174.80803436112504`, 83.51413176875}, {
        174.80803436112504`, 85.26668522}, {175.33680048800002`, 
        85.26668522}, {175.33680048800002`, 83.51413176875}, {
        177.08810390112504`, 83.51413176875}, {177.08810390112504`, 
        82.977865413125}, {175.33680048800002`, 82.977865413125}, {
        175.33680048800002`, 81.226562}, {174.80803436112504`, 81.226562}, {
        174.80803436112504`, 82.977865413125}, {173.05673094800002`, 
        82.977865413125}, {173.05673094800002`, 83.51413176875}, {
        174.80803436112504`, 83.51413176875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/crog4ntvDSHM7Y6b7vVQx2K24NkudakOdg+nx6W
axHq4FQys27mOkz+qm13/ziyhcD5XNtbpnb+DnYoc5Hbt3h9mgOr7dvgsC/B
DlonF/1fuzHNYY7xkwuOH4IdVi/nuFC1Oc1hZpmEwYo3wQ6/i7YyXt+e5jB9
p08/38tgB5+Lx1kZ9qc5JDWc8GZ5huBrdVWkJ9wPdrBfw1QR2ITJ/zunK7fz
ebCDa//MvS3dCPPELNfsXzsxzcFY67avLtC+f71bHQ5NSXO4wJwp4PMx2IFB
UVq4f3qaQ+7db5eyvgU7+EUmFcnNTHO4yXP6lwRDCJxfc/I9UzYfgr97seVE
i/wQhzX6i21m9gLDI7nkyLzQEIclqbfa/9enOXAK+B/w8Qxx2DLryrtXBQj+
T47gmQ9SEPybe38aa0SnOaz8VXJgXnCIQ+53FYGq4DQH2cQ1pyQzQhxMr+fF
cvqkOUw4/vjKlJoQB4aSFm8jjzQHjpBnzSunIfiyfM6TyrYj+Od8E4+duB3i
0My/bc8M3zSHR5s/mv/5FeKgws+vEhiR5tCzvFJJWiTUIe7NhPLoZGD8PLd7
v0U31OHsDQOHxUD32lmnfGazCnVY0u8QdqYBwV9VdH32/04E/9ReA8Ydk4Hh
NzHw413jUAf09AQApBMLLA==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7ReZVCQ3M81hTq9gwu++EAcY/6HXJ+M/PxD8w3NP
su2XCnX4c+HlfI2JaQ6m7qYFC7RDHT7OVXze14jgZ91RudhXhuD/e/3ynnBe
msOf50/b/yiFOvyavSN7bXqaw95dRge7BUMdvnm3/3BLTHOo763/JcUQ6nBQ
iHmrTVyaQ/7CtlNSL0LgfM0rBbJ3TyL427VYt/zeEeKg0bkstSU+zWHt2Ws6
U1eEOAhs8ZQ4AzTvmoPuU4uZIQ6rfxVyyKWkOaQxHKwP7wpxOP515q98oP3x
W7TMVOpDHMQPuumcyU5ziLKa/OVDeYjDlllX3r0qSHPYaWXVa5Eb4vB6gsrl
vvI0B9nENackM0IcCvbvFjtUj+B/exsU9bUdwXf3SY2T609zUGgvz98M1F/v
tNXp0NQ0h4NtF65lV4Q4SHXeNRKZAQxP5znlrDWI8NXjKpy9uRnBh8UHAPkc
uaw=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EYhmer1JFhZaabJTpb5fJYkFbkLUrmWCPc9w6zrCH6CtoMmQke
8AAq2bIcpEnhTNKmM9OYZUSCouRp5WFWmG6UikvKUqSDqdV+OejH9eOC54bn
5JVwOSaJzWKx7Kz4WtlgxUF+94Spm0Kz0JI+sSSFwl0pUXVRcNqLKkpXpBC4
3RzpG6DY0TmbL+MwULetCXQjFDx5NOXvYtAbLrGXvKVYCNjnNOvNQKR311ne
U8Tre0f8/BnoX3j7rZop7vBbfm48zmDO0ynMOEVRV2DKSxUzMAZNyQvnKD6f
XhI2pjDgG/f3OM9TKI74JPhU2Lx7ITgsYdDmImblqfMag6N5nhGr1nyVQttc
KCA4U9n6jTtD4ZIRrumPIuAeemmK+EDxPPzPtOQcweMDHXEBkxTq11phUwqB
/7PF9op3FEma4lFFJsEv39p3i6MURi/B7SeFBFrDDWPfIEWmWVRjX07W91Nw
LEuQdo+ApOUO1fRQfLGTiDwaCMoSDfoIa72+PajfXEMQ+cCj0jJMcWrxfH1g
FYF8UCfb/IZC92jIvE1N0D+mH+eOU9QfDqk2lxKIT+bntpkoQjYlXgksIBj6
2DrPnaZYW8uRns0gkN1vZvO+UpSkZ9VFxhFMjkRGSX5QNDRfyuaBIKtp1FGx
QjEwdnBOtZfAtVhuULGSUdIzNWnhEMyka/147GRsyXEpC51n1v2C03e5xWDz
1OzYrmtqBkKlSmdapnD1jf4kjmcQI80tb7NQLPNl5eIg2z1jhwOv//ZhEOzA
F65a+9+ze6d9B5dZn0/MYdvd2s7gYm3k1dAxiofKxuoJRwZbI4KLnF9RKDvL
3DR/pfj/H/8B7W405g==
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{226.94899999999998`, 
        119.34400000000001`}, {234.012, 122.35499999999999`}, {
        242.57399999999998`, 126.012}, {250.691, 129.47299999999998`}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{249.32800000000003`, 
        132.695}, {259.89799999999997`, 133.40200000000002`}, {
        252.07399999999998`, 126.258}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.0033003300330033004`]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPS1XatfPvjwHIZY6580n4x1gfB7F53/rD8Q7sF7v
7Nzoi8mHqbc5ezM3NCTPoTJgt6reqXiHZQye+80i8xzWKjikWpyOdyh5269w
LDrPoZq3/djxs/EOzreuNYbG5Tl4/jqrHn4h3mFVQJXR3Pg8h4Z2OY7fVxD8
Vz/V+vlvI/ihB35v2vso3kGzSCTpQmyew2HnOeWs7+IdeMvf5NdF5Tmkh/TK
fPwb77BAdlMlc0Cew93ijFVe4gkOh/xuvdTmRfDf1v1xymTMc/h54U34yk/x
DvPdtj6++T/XoY9LwuT3q3iHIIsrQeJAfpjICf/wJwj+m22f9FfeQ/A3uHFz
XQK630bBedkPFkR43PVkulMrgMmHhd81Q6uk83dzMfgw9ctv+6T8eJwLD8/Y
z2YV51/kOqy/y8126Vy8gw7Xk+Xab3Id/EpSM7uuxzt4sPLMqn2f6xAS/mfd
3gfxDkZvq97Gfc11+Ptt+x+nH/EO26WFDCf9zXUobNbdcZ4vwaFXQZHnglGe
w50ZKaydPQkOsQvO2utYIPjBUnP83pfnOSTd+npr77d4h8VPPRq8a/IclF2c
BXwfxzssXSSi+LQ+z6HxgyzP72vA+O2PbippynPYOOv6suxL8Q5ONYseM7fm
OYgc9HziA4zv1a2r0yQ6EekDPb0BAMmaJzs=
         "], {{240.54036446000003`, 
         129.05537444875}, {242.39542103750003`, 129.05537444875}, {
         241.46789274875002`, 131.264191815625}, {240.54036446000003`, 
         129.05537444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdknss1XEYxn8cbZJbkzVNZChMYjaWkWclJK1lY81s3682mjWvy46sOEYu
J8XY3DoVI02WHEvlfonmFppDzb1cO02MzUYtpl//OFt/PH989r7v9j7P+1rd
iAmKkAiCoCXKQZS2qANOB3e8lglbwilbw1yOcqnLap6a8L7U08Q9m0OdYBoV
9JVwX5bFe9M4kierTOLGCRmng9dYEodvYIjr8Cjh8cXvipQEjg9TD/JdPxEW
JcWNUzEcoao0A8uPhBoD3zG3KA4bKvnj10s4+U2ZJwnnOBvWPanoJKT/sm5e
usax0pJ0W6+N0J1+yOKFp4adI+ZSYaXhaNcdnyhdjjGjzG0LcT7nSmBBuJqh
fXszQOghGPvVPzPrZdBXeCjz+gnuu54t1m8Y7Dr6STlE4LEF8X2VDDVnCg/7
qwgPy98N6jxicKpgb+e/EBpHxm3O5zBEdpneDJolKGeqK6ZlbD8fvcaMouxo
hp89vjNNS4Syjbq46QiGVPuJrHGxP1bSnahDDANq+XPXCcLMQPGT+gSG2u7f
i0c+E+YuOM0uJzP4NG9wYYSQktVaqZPB0OVn2xE5SAhaU/j25TJ4vdoMFP7l
1Z64lq1gaFjZchNaCaWX7j4tE/24tLHNoXpCkoG8t2+YoXBB5aysJXQeV43e
+sGwretDedUE7ZLcdbkWh735rr5QJdZbpUeZsYYXQ/bWZSc0HFY+7O14jmPh
mFm+Vx1B7h/sePk6R4uH3cvILoK/eqwomDT3jEwID5VKOaYy04wsxf0lV9fN
C+7wfX+WUtnsaxmHcpXVz4v+Y7wdjAzvcewFxDfozRD0zZpUjnKO///xL1Do
OSk=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQnb74bpJWWL7DM7lp3476JDh8+G7v/T0532HeZ+/V
ZqEJDvuftK1pS8Pkr9p2949jRTycz7W9ZWpnbrzD5y3cbyak5zuw2r4NDkuL
d1huOUF3dma+wxzjJxcck+IdNCS+/U3PzneYWSZhsCIu3qHi8SL9I/n5DtN3
+vTzRcc7nHTcavy2LN8hqeGEN0sEgq/VVZGeEBjvsEfmw1I7K0z+3zlduZ2R
8Q6H/re9LnRGmDd55cy3szzzHYy1bvvqAu2r/rcob71PvsMF5kwBn+R4h9qJ
HI41/vkOuXe/XcrKiHc4fdJ/AXdgvsNNntO/JIoQ/JqT75myGxD83YstJ1o8
jHfQXDAhq80VGB7JJUfmHY93ULx2fOsb83wHTgH/Az674x0MuQ/J3NBA8Msq
HY6flUHww/SeJ4oK5zus/FVyYN7ReIdX6UJ26dz5DrKJa05J3op32OQe0/2N
Od9hwvHHV6a8A7r3SWGlPEO+A4vW54MhLAlwPl+7ouduEQT/+TKD5CdqCQ4M
DYtftbLmO3y8+UO6zizBYWH9n0A7gXyHY5dtJvI6Jzjcjqlb6iGd73CueH75
Lf8EBy9PubwJQPfOl91UyRyW4KDIoNey0wLBV3985OQbRwTfXU9Of6l3vsP2
Eyt+vAtKcEBPTwAd5hA9
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffqk/wLuwHyHc8c4NtQyJDjA+AWqPyXrTBH8R+dS
muPdEhwqHa+fFfXMd5i1WMrigl+CQx4fv2iNJYL/3Efof7Uegl8dc52HUS3f
4d/nT851XgkO5TzLZs6Sz3eIj5354KhjgkPxnhI1E8l8h/3H7Gt5LRMc7Jo/
PNIUy3fYEeCcyquL4Itk7eh7J4vgx0xlulUrmuCw9OfkyYXi+Q7X0rKnefEm
OPSqmLvtBJqXvWBa0RzWBAeN7Hgzbpl8hzSGg/Xhf+IdXNLaNWJB9m/RMlP5
GO8wxdAkaqdyvkOU1eQvH17GOxhyH5K5oZHvsNPKqtfifrxDBqMQY41+voNs
4ppTkrfiHd7qr3RZb47gF8c5dDyyR/CP7Anq4XbPd1BoL8/fDNT/Z9OigvW+
+Q4H2y5cy34V7zD956kExoB8h8POc8pZ38XDw1ePq3D25q8IPiw+ACbesJc=

         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxjdXOVaKJYm0vNQywzIvoULTeNCKpBkxUjKL/5ukYZkvYwkz
Zxebstk003mfy6VdNHHpaFqhLMwkK2ZpJV6SbtYSVLKMBLP/Jwd9eD784Nye
c86GZCpN4XE4HC6rAFZOrPL61el92RSGGZNsJIXBdw1RKrIoBO2qMs0ZBvVq
5eL9XAp368SFBCUDV7/JQxUaCiGJTRVpGOxuE4eJiyhmgvxdJnQMekXOQ4Ml
FMfMva8C6xgEB7ol2cspqkWm38taGKQWz6dbqykaLo6dP93F4OANW1GGkWIy
bnZr4yiDuhiPHwsNFBbhmpASHlniZEWVT6u3g/2acpLUEQTtU6tkdjb/hWXg
LSQEL1cYvPh6dv6HvrbPRwkq6s0rQyopxnwXZbdTCbZXN6nX6yj2fR0oi88g
uLtl/EvuVYodtmh7+FmCzJqi5eMFFHa30ufDWQSbopRcy2UKMb1p410iS/ux
1ka6R2gIXr9PW9AqKeY4/n6uhQSCNw8+BLPxwyOVJ6bVBI89BE8G1axfRYvU
M49gTFypmtVSxL87Oa1m6+3dY3TmX6OQrtMfmM4heGZJbzKWUeid2nZ6sv0l
UoOQX0Ox+LezcZucYMC9JoR/i6K7I1K6kfWTGB2aKW6hGEwI73RJJJgTWiOO
mClSTpX/7NlPUPorbl7RQRGTLJuS7yI4/lGXxH9EkR9V8FQf5GBT/rl7ch8H
h0U1kx4uwZ1PiqG+VgqPgNhvEhsDW3dal/E6xR9RQrGk3nHPw/3B2vlyBiaF
W6Kdnd/ba61zp5ZZ8icR8Lg6FYPR1aGWzaz/Znlj7Ug2gytmn7YFFYXcWuhp
kDH4/x//AVsVNkI=
        "]]}, 
      Thickness[0.006600660066006601]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{194.285, 113.34400000000001`}, {185.254, 
        113.71100000000001`}, {173.93800000000002`, 114.17199999999998`}, {
        163.71099999999998`, 114.586}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.43800000000002`, 
        111.09400000000001`}, {153.59, 115.}, {163.72299999999998`, 
        118.09}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbSlfh3nnBQHt7UW77z/xjr43Xw47drKFIftYUvC
dfniHGSPafxIXYPJV1F79ZfxTgyc36I2cZrnxRiHwGlrzQvWpjjUr/kZInYq
xoFV2qiyan2Kg9jiDxcZj8U4tP2c7um+McVB+JmKYcahGIdrR1yqF29NcRDU
jJxwbl+Mg7pyeP2ZPSkOd95f8TmyG8Ff8rMlQ2FrjIPUv4kfZRsw+eU80/M8
98Y4KDzUMA/sRJj3scvasqo/xWHtzOd+bw/GONy877Krb1KKg1dxqSDP8RiH
20WreqKnpjg892G+onUmxkFz9cfXr6alOATXXP994yqC/83iD7P2EwTfVNht
0g+XWIf2RqNtqd3A8LjccDROO9ahfnsm45naFIfm+uiDPPKxDv1vkjO25yH4
V6IeCa1NQvC38Heu/RKR4qCc1XgwTjPWwcNzS6dbYIrD9As7Tt+0jXUQ0Px3
7apnigOX+YerIUGxDrePCh/955ri0HT4U0tmDoI/vdZ/slkvgu+xN/d4x8ZY
h7hEV7NU7xSHGOV/FnsuxDr8T5g3VzYsxYFNvE359stYB0s7hY/qicD4Cff+
UMIc57BC68DOfKB7d6wq+HKMP86h/uH58zPqEPzWI2miZ9oR/KX8B6paJgLD
jyHu01zOOAf09AQAkwgdAg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbn64+tX01IcxP7KJu5OiXWA8aN3/TPZcw7Bt+W9
xl7/IdbhulKl5Ne+FIf12xwLExjjHM6835AQXY/gu+pt8YouQfBv2lZGPMhO
cSgL/9Sx50esw9W37k8rU1MczLXsD3k/j3W4OFesSDg+xeHnn+7ft67GOsxJ
maTHGZPi8FJg8ulbexH8xc61cnPnI/iGswS37u6LdWC+bXo/IDbFQd32sW5o
XazDa9abE2cAzQvYYPnsR16sQ5sPY9OrxBSHB/lnG8QTYh0WuWuW2ADtv6ls
bv4kJNbhk9C1pTMyUxyurJz/dYNvrEP/m+SM7XkpDsar3Pp+OMU6HHu02Se6
NMVh+oUdp2/axjp4C3pP6KtF8C/aP7p8sBXBV5r35fqrnhSHWd+aC4qdYx2i
prjs6Zuc4mD97c51bb9Yh6+3ctY8mAoMz80rKo4GIsJ3RWXtnOJIBB8WHwA8
FcqY
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EYXTNTmMUISaWrmdnFK5U1oTgmGOa6iZdtfd+n2TsLNcyZWrRs
mmlqBkuJzMS8pGIkRWmGOsjGljpTWYRLTU1ZarlcMTFn0ffLQT/Oj8NzO+d5
Hvf4lAipHYfDWcFiFwsui3qTQexnJ0VCqiR8+BqDw/u4R7PtpVhsvOnlm8Gg
INCoCVkiKEx06xSeY7DpQWZqvIUgp7tl6LqEwZSTl1I1R9C0OLi34zgDaflp
07bvBMg8cDE9hMGSMiKJP0UwUHi/3ieQgcb3vFgwSaDxSdyi9WQwtKFkf9EI
gSIuMq3AgcHtq8IPVgPB3wyPg2tG6GX+SdDLDa6z8ciPK4vuXqKR3h8VxWfr
V3WISt3DacS2qhvMX1i9Laoaw04aTWKeU7aR4HlyWNvEOhrdWWW6yhm232hl
Wr4DjWNzJEXwg8Ce36lTWyn0n/Ffq/9FEIBJT+4cBcccozrESrBD2FxdPk4t
7yd3u/Je2ACF4jyXoEauFK5x7bLyLgpbZxom37H5M7L3l9VsPKlBxPWcJ4gW
1DyUGSicuNEdvOongeRF0OfHYxSMV96ozLMECxZtrforhbOO8+tF0wQ6qu5I
vpnCaLK60TxB8Mg71xT2h4LoibbUPEjg8jqvgnGhoZf7n1L1E1jkJdr8ABqB
NdV3KnsIBMUj+t1CGmVdzjqFhiCrwmusL4FGz3BvovktO89o8cvKtXFs5I23
1dr4nmf1CtcxGrlD07O+vQS3OK/E0c4MKOuCg2iUgHfopXcSbPcMlfQ1NwgZ
yEMjLvBZ/YrV34KM0cyyv9YYh3aPWAYnn/rz9az/GFPc5mH2n6p4Ic5LvwmU
VfJaNxmD///xH/qsRAE=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4paOhq3dMqkOiokC9hbJcQ4wfq/606RnWXEO
JcFtfgu0Ux0mLqxZIlkU51Ar689sZZnq8Dc98MTxyjiH1sne0lauqQ4Zempv
ShvjHHYmX4hycUt1MIlbuCa7AcHnqFIx3e0XC+ef4bTlf+IQ66Bwq5i7xz3V
4ZjaspMbzGMddivM+X3XM9UhVnau2xzjWIfF3vbrVH1SHdQn+KT90It1cFA9
W+ASmOoQsZiVNVMn1uFocMqW8shUB5XLDUfjtBH8tgmf/9mrxDpcnJbo5ieL
yYepL2AOvW2pmuqw/73T88dA8z7Pa/NZoJXqEJVwcSmTQazDoe6za/V1Ux20
tolzTzKJdVi1rSChXD/VIcE547WpZayDoK6I4H6DVIc0tf8GmU4I/qJpz8Ic
AhD8W5N/TfzlEgfni85+tPliQJzDETnjhj9A856v/bLzV0ScgyZTYVy5XqqD
nLXrrHmxcXD72138ZDcnxjncMjuiIw10X6jh1DqnlDiHQt3dK9nUEHzlr8Ve
5SoIfgiH7svniqkOHWt9FTcD45c1/VlrhBxmfMP4AAOd0vA=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ntI01EUB/CVYtZqEToNI93c+kPRkqKlFXqkRETNpVZjcm/zcZqioK5M
UMOc4SPRVHxUmhhqpSaZ5vKRk5otyLamsWTWkDJqoqRpD8yofv3TD+qP7x8f
uJx77zlHmJAejXYcDmcNE18ma5lMn5W477Ug9L7sFE2lEMhQ+BULxhCKKpd/
BokJvOU5JFUq//dFjbbF4kUgMhK2CWoRdllDnD3LCMSZAkIFnQhupnzD3QHm
fJWECDQI9vJBdfB71v0dGZ/1m+lfr7R76vbtoKCv46UaexD8J82ltyQULjVr
i7xvI2xazTfYH6bQWjGblNeGkPfBoy7iKIV+J36QsRHhnjU9Z/EEhctNx7hh
1awfx1slMaWsz9iN7fZWI7wr9uLHx1BoKXT/ZchD2CIMVzWFURDY5suV2QiB
g2nPXwVRkCaDnKtCODWqK8zfSaG3oqd+Pg3hgenAFQWfgkuf2Gz4049h9fcF
VwpbVYtZylSEieX6Tl9/CrZPje26DATnUBdX/ygK+6V3uuaZ+nMvRmgNpSBv
cHRqK0Dw0Qbqm05TWP3o6/qtnLkvUx7++hyFuYE93dxrrHmPZBrSwTo3ZCWn
rQ9BP8WxibIoHFFnRjVoEUq6IoW9iRRi0bHW+ASh+36r+Xg081+/Pr33MwTH
AlvZ+EHWJ8sV13tErKcVq9zxHwSk/Elh8kOEUd26ftMEgeBq6xclM1/Yzn0z
1EpgSYwJ5DyCw7CsRhjO7IOMW2AcZm1/NS5RpWMtHJkVVTHvaba4aW5EEPCM
jvpKniKsnxEFDEkJcG/KslUGhI3NC5bYWAKw4VBp2Dgzn8IijxJCQJfL85kx
I6h1SxdS0gj8u7+/AYHKRdU=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxze15uYlLQ1HqTlDMWfTtIuQ+pfsombBUhR53ydT95g3ytSV
mBThxCI1FWVT2EpMQWhilgwrMDPT7q5CxYmKSc4UB928BPV+atCH/4cfnAPn
/M7xST8nV9jyeDw+l11cbLiU/7zGK11VwCPt8YXmYQbmzlSXgF8KlPvVNsaO
MGjRK+spj6JK9u3q1mkGTvFz80cFFA3vkrJmFxkcGts7/NWBIkcX6ty2wmAw
lp+ncqEYlXw0LtmykJ0SLWvcKNzqH60MuLJQ9HznFXhQeFnMVwIlLE4ODUu8
vSkUT/5Is8FCl+1SoZdQfGkLzvicY+WItChI7lh54JnA8N7IosdNsKGJ6988
2a2P/s3itVTdZRBTVM8m6K57EjQO39PNuFOEdYnmnEMIgvpat79xpXCIfCDN
BUHHifGSUCeKKae6D0HHCYqeVmpq7CkSaveoi5MJfDOUDZRPYUlIvv1CQf75
WetQ+e9WEozYZdZGrClAC1LjTWUEwvXu4hnOV5B/5EttMUHfQbsU1UaK/rTs
Nks+gelMnUeriGKnl2lqhBIczm1uNjhTeLfGaLWnCYZMNFK+heJ+0XmlJYkg
/pK608D5uphfmSiOIzCGNzw3+FLwZlR37YIJUs5KhYuBFBLPktIJd4If0b2v
RCEUMTHhC/HrLOq2HasO2MfVhy1Ptk+zSLOvWTYcoKhY2FG92m/lscv89PYW
K8+ZM/vjsli0CwvzSmUUtzRJZsdQFm/NGXK5J0VhfXqto8B6T2NURFXvGgO9
VrSk4eZX3/SxL7Mw//YbLNlkkzjPYGK/NG5USOE3+1DbPMXgxrj4iN6GYknW
JCafGPz/j38BjMci5g==
        "]]}, 
      Thickness[0.006600660066006601]]}, ImageSize -> {303., 166.}, 
    PlotRange -> {{0., 303.}, {0., 166.}}, AspectRatio -> Automatic]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.825905024147108*^9, 3.825905072463655*^9}, 
   3.825905363382402*^9, 3.825905528383874*^9, 3.82590787412798*^9, 
   3.82590803197503*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "2"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.0033003300330033004`], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 166.}, {
       303.367, 166.}, {303.367, 0.10899999999998045`}, {0., 
       0.10899999999998045`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        24.617000000000004`}, {45.02, 13.289}, {35.836, 
       4.1049999999999995`}, {24.508, 4.1049999999999995`}, {13.176, 
       4.1049999999999995`}, {3.9919999999999995`, 13.289}, {
       3.9919999999999995`, 24.617000000000004`}, {3.9919999999999995`, 
       35.945}, {13.176, 45.129000000000005`}, {24.508, 
       45.129000000000005`}, {35.836, 45.129000000000005`}, {45.02, 35.945}, {
       45.02, 24.617000000000004`}}},
       CurveClosed->{0}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 24.501156448750002`}, {21.99788154, 
       24.501156448750002`}, {21.99788154, 23.632703813125005`}, {
       18.552508993125002`, 23.632703813125005`}, {18.552508993125002`, 
       24.501156448750002`}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQXZ+egvmK+/bdca4cH
D018voUh+MyN2VWPPpvC+T+6hFlM5pk6NFQwsdk1Wzt8v7NtbWuKqcONs1Pe
x6yzdvB88M7gm7upg4Gy+s3qm9YOxfKfHxzSM3WY4PqEtcjMxiGv+uuFQwqm
DkfWnlladMjG4WNXjPt1GQT/5V5DFobXJg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcNcnpDntv6mDvfPXe8/qGDl4MMpk3I229RB
8DZbc6qllcOy9tsNh3ch+FuXJWh5mpjB+Xw//TIDemzg/OwF1jtl/9s48G26
6d8nauXwIfZ/6wMTWweOhPqX989awvkh+3fGBCxG8C8wfuvvzbV0kHNkdFur
aetQpW7SPF3H0uGNyaUgTkFbh0Wv08OsNS0dClwsT8ry2jr47mda8FnR0mEG
R+6cg5y2DgrhF/f4i1s6yEhcEbrGautwRiuHjUPA0sHlDvuzSiZbh+Nted/Y
mSzh7vuWWbDtyjcLB7GSa0zXvtvAw29Ws23lq882Du65Kyxdb1k4vOJeKm/0
1sZBirU8bOF5C4dcaZ5pbi8R/LlrstYcFLd1QE8vAOyw+t4=
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       107.836, 56.074}, {107.836, 46.719}, {100.25, 39.133}, {90.895, 
       39.133}, {81.539, 39.133}, {73.953, 46.719}, {73.953, 56.074}, {73.953,
        65.43400000000001}, {81.539, 73.016}, {90.895, 73.016}, {100.25, 
       73.016}, {107.836, 65.43400000000001}, {107.836, 56.074}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4kscerbv94Y5qGmY/J/30s+B/aeOoM2RMIc/
ExlVfj9F8HsfylgXbvGC8zueffg/s9PLQW7tUaa+k2EO7f2HrhzK8XIocdLa
G3olzMFgYpxYdZyXw6nrfeWy98Mcjm5IyHsY6OWQpLCPKfpbmMOhe4lpD728
HPKtdmhFS4Y7tKRNXfjaA8FnAAEDL4eqAw9XfVYKw+DD1NtyOIuGOiLM+6x8
s443DGGf6fXF/s1JYQ5R6hM/yiV5OWxlsn76riDMYaPq1/VpBV4Oh46yPRIv
D3O4/yRk38PpCH5aifjkJVcQ/Elz+4xWMPjB+Y4fW27xWfk5NFZbiyrlhTkw
X3jm8CHEz4Hh+ZJqsxgE/3Jd8YxJgQh+Ub/TU0WXMIfZB58vCPP3c7gjIZT0
xDjMock6YDmLs5/DM877YbxAvsvh5kd8jn4OF/e5ZlobhjmEL5U9k2Dv53As
pbJgkl6Yg5RuIHu2rZ/DRskHTQd0whx0+V9/2GPt57B+w4M6B02E+6o1H64r
VgtzEI8O+p9l5gcPv5uPWq1KTfwcArTWn/eXB4bv8p28koZ+Di4XHl1bJgMM
T723Hsr6CH5UucyVBDc/B/T0AgA2dvY8
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{43.352, 33.547}, {50.469, 36.918}, {
       58.676, 40.809}, {66.242, 44.395}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.0033003300330033004`], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.824, 47.594}, {75.363, 
       48.715}, {67.824, 41.27}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQbV0y+80zCz8HVY4/bWm3XRxgfEmnc7//n3Bx+CkZ
qXXM2BeDD1N//dOM3aF+vg6fFpR5x9xxcag9EMp4O9HXIcqx4VTBPReH7cWF
bRI5vg7fpfh6+x+7OHxU6+UOK/N1mPJltv+6Fy4OfQzS50qqfR0Y+G0Fvn1E
8K9+9pWT/4fgr2n4nlrN6+rQ2dbc41ji69DebvGeS8XVQWrW48M/03wdzq+Q
snzk7OqQavLrFa+tr0PJ+YUrtZa6Orz+MWv1ekMfOH/WTmWBpUw+Dl8W3lwf
pOvqkHSDbXL6H28HWVGDjG+yrg6685v8Y396O6zTmDB/nQCCfyv3aXwQK4Kf
2CsmsuSli8M1O7u5jwR84OER9dSq5LsdJh8WfratUr22Jd4YfJj6Rp3UqQ97
vOHhGdXN+9R2gbdD/G5xniVPXRymPTu4eN1ab4e5L05dEvnu4sB6OTHn2y5v
h5XrfsRWc7o6rCuS3VV9ydvh99v8n60Wrg6HdapOeHz2djjKu+2BXTMwvBy2
mTic8HEoTJ4kqlLl7hBtn8G88S6Cb6y+yG7vHV+HY1teb602dXUoDAll1Xvn
6+DW0aYwi8/VodqjpWPKH18H5ofWEt++ujhs+T2f9xKbn0Oy6Xrf629cHN6t
2z2JX9DPQatp8omZj1wcJl25Py9R0Q/uH/T0BgBd1yCG
        "], {{
        56.516927460000005`, 43.61787444875001}, {58.371984037500006`, 
        43.61787444875001}, {57.44445574875001, 45.82669181562501}, {
        56.516927460000005`, 43.61787444875001}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1HEAx+9hq27zMFN2WkaURXVZF87D6Yvf3Z/G/4ekVq5aGFJYnnOt
SKTi8li4Hlg2NvMwEpVMKlqdxbIMmae2bKJJrkS6V2frxefF5+X3YfuZuKAI
PofD4eqw18HTsZIUsqgtoBjiq4slSgZRt7UtBysoeCkLfqPnGFwtyanxTaaw
XjLPNKcMhmw0Qa+OU5i0Bj++7Mhgbe5G/wEfiiizsshlCwY/dinkfY4UecbH
xs5uZED5Lq7KnRQNTkL/kVk5UpNVC5ZmFOXKZx5G7+XQiNxiIv+wMJhUTReq
5CiotRqz+8Zik7EoVe267l3FGXyeRqb3Fs130+poGfavyibTf7MQVty17TaT
YUTNdeCaUFjlh8vEHwmE1ts6PCwpYpfTEpl6gtzW4M72fRRd47Zf8lUEJcrM
Q1ZeFELPmDuCVIJKr8bB7GCKuMoG36zTBBnd1x/6XqAIbQ/0fuJN9P1sjhXs
NrUhKB70S5pSUUgnTk21mhJ8DSu0PJlIMbEha37TDgJDRWBpn4KirWivc4SY
QN0rLD7sT/EyJ/TpO0+CX1WLOVwpxV+DFEYQQDA7+mal3J7i0bA4Lz+MYCyW
I+FuofC/OD9smk7QFWU4zplh4V60KJE2ENTVN/aLe1lotxrlqaYIXHzSetqa
WVxxq6r+JJTh9YRnh/QBC0Go0wtLVoabIlsJp4TFytyAQpm77rdOrHZq3657
QobTWiPkiLcrJUvtLCysjzTtqZVjoGagrpyn+8M9ejSEy+j3LBu8Ft1vziBo
0NlLaUdh4N6R4Cdi9PkuffiZ1OPB4H58kyY7gOL5ao27JIDB9MzyZ/vzFA7h
4/LmcAb///EfbsQhXQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVj1yvErqwIcZlRH3BKvdnO4em7GjLxjAQ7V5/TX
3prj5lC0Qi269zQmPzR3989mCxc4XySPU1tY2cXhlofBrYVnAxy4q24tXyPi
4uAcZBm77WKAg2X6iYXNPC4Orvys//yvBjiYvDVICGB1cXi6NC6R416Ag37x
TDnZf84O7UnNmVFvAhyOMkyczvEDwQ8T+XjuwCtnhxyJn75/izD5vyxFbwv9
dnaouKd2M7kVYZ6Ukc/drRMDHNJCts2OYnFxeHU77v696QEOC9gvKczgc3F4
x6jVUjE3wOHWrrdLr0q4OHQV7XCaviDAYYvktK+GOgj+z0n3Wa95IPjl7sVK
hVyuDu7yVtd7OoHhcfxFh+11Fwez7hW5kXkBDkIK8xpm7nNxCPs6x9ogAMF/
cHHmBGkLBH+B9fOjq1QCHIK/vmywvezicHKdbZ2faICD1aGIqcZ/XBwi8y5K
5LIFOCj2H1+pqerqcNv/58vav/4OAivOsAdHIvhWMm0qb2ch+HNnH+qZ+NjV
4eu9+OvdnMDwTH+c/0PRzcHsnuCyP3IBDpL+n13MQtwcVs0Q9RU0Bdp3vvZe
ZrubQ0dh6L0F/gEOtWUnnvEucHMwv1/C9TkfwXdeumhqZBOC32wdmnBqaoDD
HaXFj3ZPdnNAT08AbO8UMw==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3VW0w2n6ggAHS2nlA988XR1g/ENTn6T/kHWD8zus
J/PWJbo5PEs8Pnf1hACHrL6sBw7Nbg4Xf5vpVBQi+IcrbBkqohH819OPSzd5
BTj8PH+a/2ehm8Pj7ymmW20DHGpKU5vE/d0cbocz+b8wCHD4L/X/i6mOm0Ph
05/HL2sFODxw4p1q+scVzg9a8dBq134EvyCUK+P7XFcH+0sOmsm6AQ5Rs9dG
atW6OvBrtPd9MgxwWNsYdaowztXBdev1vGlmAQ5nGZr+r3NwdahZrR5sBbR/
X0ZojoeWq4OMU+O2T64BDltL1F4+lHZ1CPs6x9ogIMChpLREqpDN1eHoQxuW
itgAB6tDEVON/7g4nLfL7r6Xi+Dfmj1TyLUOwa+N2Cc1vSfAwZHv/b00dleH
Ny5xj+/NDHBo4l249rqMq4PSpXWHm+YFOLS3W7znUkGEd5zII7N0YwQfFh8A
cmy5Tw==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcx91dFFJujrjWUtf8OVLKzPn7xu9+P2Hc97pOXBJ2Z0aHyqz8
6cb6o5Uu0tyw2kS1ZCaTG7f+YFlR1gOyswrtanabks5WSvfIbT14PXhtnyfv
9/uzK6dIquTY2dmxrAitsK38PS808iwSRM1mzfe5URhdmv5V/F0CntoxwE1A
Ifwbl2XmEPhqxtc6QcHVf/FhF5cg7Fn9GJ1BoSJeW2jhE8xmpfDHSihU+/j2
+O8hGFRdb1NcpiATifqlgQQhzPFFx7sUnq65zNiFECSyBv5MDlNoFPTvzIwl
mGo2pUlZYhxUiU3lCQRGdcJwgtzml2aVVcMvbN5433Jylw+NnMEDn6VxBMHG
FAXnLI06syxKG0rg97U6smGAhsBH4zUXRFBas/qydY6GxE3tpvch2N2amiZn
MUjaPzV+YQfB60jndqMngw/uoS7RPIJ78clBBfsYRKRz7c32BObBxuitycx6
P+yypeSZQgZNLeZV3YoE7zktN8MqGGysvToyu4Egryi33lDAoHTz3iv+rgQ3
5vSJ2ccYdMkPOed5EsgybxsEKQw0+Qqu1psgKb843BDD4GLyknzIn+CU0+jC
iUAG12qOiLTWvlZ/r3T08Bg0O6QqtYkELvNLCbWfaLTnVpotGQRSxfRyaCeN
jx66khAlwa0H6e+2ldHwetVrKSmy3teO6N/G0uhri9NrzxDwLX780w42N/AX
nr8ZEa/75HJ3tXuqGFSH02P3HIJAWf2EzkShQWWuGooi+MF0euvqbHt238n2
/FlK4fCEqFcqJIgMF245l02t52viObD9CIVH7Er1uAdBxhdpxJMYCk70UVX5
JgKTZntwZACF///xH7xBGWM=
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       299.371, 141.49200000000002`}, {299.371, 130.164}, {290.188, 120.98}, {
       278.85900000000004`, 120.98}, {267.53099999999995`, 120.98}, {258.348, 
       130.164}, {258.348, 141.49200000000002`}, {258.348, 152.824}, {
       267.53099999999995`, 162.008}, {278.85900000000004`, 162.008}, {
       290.188, 162.008}, {299.371, 152.824}, {299.371, 141.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       272.904071993125, 141.37615644875}, {276.34944454, 141.37615644875}, {
       276.34944454, 140.507703813125}, {272.904071993125, 
       140.507703813125}, {272.904071993125, 141.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4htRbu0vDhc65H6pXuNWluiw/8q63mnbCx32
mrcxJFgmOlzw79pZkYDJj0hpzXGzS3TQO70tPKyj0OHAUoG21MmJDlt7NudO
m13oEPfbRlV5T6JDxduNFWZLCx1q5mQeUniM4Pc9PplWyp4E57O1T+a2kEpy
SGXxOe63CKj+YOyaKs0kB3ujhpT6OYUOsX/6YrVNkxzOT3nOvXxaocPKBWrK
pxySHO45+W/k6y90OF/0qXWmW5LDtMxX2rdaEfy5HTskmOsQ/E3JbVb7ywsd
9r3eLzDHKcnhyq/giXzFhQ4/NPpOClolOaw5FvIpJK/QwSgtpqndMMnhXKyS
55LMQofAQ9pnw5SSHNbu2JOkmVrooCVw8lI0T5JDr3B4zTpgeOx69Nt1Jl+S
w4rusGdXkgsdmt4d1jivleTQ9qWjvzWj0GFKaK/pD7skh0LJ3bkngeZ/ddn3
IsMnyeGNgMJ+L6B72r63f74Yl+TgtKylUqip0OGYY/CB4+lJDnPYZEpc+hF8
o7IG/TezEPy/qRKfTy0pdOhWeZevlpDk8M3Ni23RmkIH0VfK5x8HAP3z2uPO
ui2FDsZunyU3OyY5eFVVt9TvKHRQ55nQeU8PwWeI0u1/LIHgC9XM9Lz3LdHB
5a6njej6QofWtfPl5S4lOuyV9lW7CozfxPs8bGdWJjosWd7GqlNW6LBaVMot
NTrRQTPV69K71Qg+f6yYyb0NCP579RrJSqB7Njg1HNoZk+hgs6/a/822Qgc3
J8lN3gmJDpMei9jN2wk0f5eETFFyokOW/MOsX3sKHcTjxT/VZSc6HC18cJXh
YKHD32Pr5FsqEh3Q0y8A/fZGhw==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       182.707, 52.992000000000004`}, {182.707, 43.637}, {175.125, 
       36.050999999999995`}, {165.766, 36.050999999999995`}, {156.41, 
       36.050999999999995`}, {148.824, 43.637}, {148.824, 
       52.992000000000004`}, {148.824, 62.348}, {156.41, 69.93400000000001}, {
       165.766, 69.93400000000001}, {175.125, 69.93400000000001}, {182.707, 
       62.348}, {182.707, 52.992000000000004`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{168.35886490874998`, 
        52.52615034875001}, {168.35886490874998`, 51.629259717500005`}, {
        166.94571527999997`, 51.629259717500005`}, {166.94571527999997`, 
        49.29296900000001}, {165.85194621749997`, 49.29296900000001}, {
        165.85194621749997`, 51.629259717500005`}, {161.91875266874996`, 
        51.629259717500005`}, {161.91875266874996`, 52.52615034875001}, {
        166.32882952874996`, 58.74313370000001}, {166.94571527999997`, 
        58.74313370000001}, {166.94571527999997`, 52.52615034875001}, {
        168.35886490874998`, 52.52615034875001}}, {{165.85194621749997`, 
        52.52615034875001}, {165.85194621749997`, 57.32779653312501}, {
        162.47876242874997`, 52.52615034875001}, {165.85194621749997`, 
        52.52615034875001}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{107.887, 55.375}, {116.91400000000002`,
        55.004}, {128.23399999999998`, 54.539}, {138.465, 54.117}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{138.738, 57.609}, {148.586, 
       53.699000000000005`}, {138.44899999999998`, 50.613}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4huWZ5kce2MdTBcdTQ746ekA47c9uDkr5bqn
w/adTpm8UZj8E5dPtkzd5AHnb5bMLTsx0cNBPsrnhWJMrANX1UYN5yoPh47k
0GyzhFgHxrampXeyPRw+5sS980qJdTjCkCExP9bDQSN53aV3WbEOvfLesxPD
PRx+n+wp3ViC4JvWrvj1rg7Bzzc4Uq/TGeuQeOvrrb1JHg5O0xcpvZ8U63BD
SOetRbWHw4Ob+i95Z8U6XDg2dTFrAUL9o7UTXO9YI8xn+b+tSVLJw6F1Weep
OTEI/o0eM+sntgj+ueYrAeL6sQ7BOfpiKr4I/v77sxj1lyD4sPAJW8zKmimM
4CtdbjgaJxTr8K7hsWTlTU+Hd0x/WkMEYx2Ud6XHNt9B8LuiCu9Mv4fgH7Lu
i7z6xNOhq7jLpVgk1uGnm+DS+689HaJl57rNkYp1+HdgxTOhz54OR9SWndwg
F+uQlrgpVf2rp8NvmW9rQ1RjHXLXeqyPYvByYGTo/dyuF+tQLc1f8kXUy+FK
WvY0L4tYhz1SB51Stb0cHKfZ7/vhGOvw/yC3N6eLl4PIX9nE3d6xDhWLbk3b
Hu/lsPHaauVbAbEOz/qq4v/neDk84zdIfxIc66DgNO2JTbmXw9Y/ZSeKw2Id
urfMyw6s9XJofrlXkzkSwYelj3e3BFYaVSD4Mif+LeIsQPDR0x+MDwC/QCqd

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx4+LIlEXGmMcq9QSMoTl3svy/d0PXbXKPPy+1JJS0q552O0u
lBKax+Up0zIlZuWc5qmWjFg7k5KxPDScJg/LaAuh+4utP15/vP77vN/vj/Bi
7JlIPo/H09FyUIuuFk/+alSpC8XHsfqCxlEWsTmBDNwpFs9tl4R9YrGaZ3a8
w57C9OuR1OI6FvtDjhbqmlPwH8U0rBexaBEV9jcbUYT8Vl6VpbB4HcbLTeNT
JM3d/P4zmsWYeC6DrnB4auYiCT3FIuGuRVTtAoeHoX3IcmJRHh5rf3aSw1rr
i0nBghh867Ewt1EOy7N+MquyTVfdKtG747zpz2sMzPd2M+j7sEiphoOhTOng
K2NQVfBZTzjPQRCjICoPBmQwXC36wyFiMC++cxeDJHt5oIJHoXon+mG8QHBP
f3d+rQGFoW1qcfo3gsypqoFxAcWF5C7/Le0EKwfMfTqEFCeLok94VJKNfvQD
7Rzz7xPouSY65DlTOLUmatwTCJyWSxQ9dhRfNKXzD9II2uKXG9P2UFRL/Tw1
BQTph0Y8WBOK+stxb/yfETRYqF2EWyl+TWeL01UESne3mdlVDgVNAdnGnQTV
670GQm1fouBtw/kjBKXygWHbYQ6HpTu83woY5NpUn29Wc5ha2pdtQhgEXc/q
lbdxkFq2VAbJGVg3SQNEjRxWvCStT5QMUkYn0m1VHOa6p8P/zmz6bS/ztgRH
8YZHRkh0XCrEWBiyynncwcFE54aqxohFhZV3++wUB1P5leD+S5t7ZtaXXTut
YDFRN5tFtfevWfbHqXPZjXyxr4wTSTmLjOTqvvGdFC+H3vs0qlg4HusZcrOh
sPNdYly7WPz/j/8ATqosnQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       121.73520055712497`, 50.39521844874999}, {123.70401060399998`, 
       50.39521844874999}, {123.70401060399998`, 49.89895331312499}, {
       121.73520055712497`, 49.89895331312499}, {121.73520055712497`, 
       50.39521844874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4vzpgvPDVOIdHA8p1BWs8nKA8SX8Tx09s9PL
wV9X9mK9U7yDkvNPD+MTXg6JB9dZbY6Nd/hxftGE/uteDgVrl2dtLo13OB/j
c+P1My+HG74bXx4vj3dI3+MUef0Jgs//xSOrrNEDzp8mXCV3ItXDYbnVD6/w
qniHbl+fyYnBHg53j3to/66Ld9hhZdVr4e3hsFa2f0JXc7yDj8LMMx8cPRye
XVgleqI33mG9GzfXJRsPh4+6N+fozYt3cF/G2L3XCsHnVnz+t17Hw4Fry+UD
t1Ux+TD17r27Xm0yjXeovd967rith4PfEdmz9Q7xDlsOLPJmdfFweD13df88
13iH4Bx9MRVfD4fdnz9+0fWKdzjQduFadpiHQ+cDi7C9PvEOZ3z+JV7KQPBd
dM+ubWhB8Leof1X+musF52uZHU1f3Orl8P5wmYmFd7zDueiXxV+nejns7Pr0
Qdcj3sGqrMvEdr4X3H6ezjlWacu9HKS+zOgttY93WJmk9bdljZeDx8O2dh9z
BH9NwY8TuiYIPv/0LDZ+fWD4R892Slvt5VAYctf+gzpmfMP4ABZi770=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYifWxIC/8gkOpx5tmbbjvpfD4cfHFE4pJjgk
O60WX3IXwV90c/lKvQoPOF9nYeH0zfEeDrEMnU7+ygkOu3ksp1r4ezi4hU46
nKyW4PDyp1o/v7uHg96q2S4VmgkOT+r7fe/YezikLXitIWOQ4PBo7QTXO9Ye
DjlrX9jIWCU4uC9j7N5rheBzKz7/W6/j4VBbNWVy1vN4DD5MfWiB7f1jP+Lh
5p3YPYnBnwlhn3jszeR7rAkOgbMM+FQ8PRyMm9JV/nImOCivdRLxDfRwYHT1
2L6fO8Hh3+bmuXfSEfx186+aTO1C8G+f8LkyI8oLzv/QtPJRarWXg3EEY5gB
0Lzj/MFah7q8HKbVFU8WZEHwE13f+7MzIvhhRzhrEn7FOxxJ3/Whr93L4dXK
jN0SH+MdemPMl7Y0eDk0x2rfnPsh3uFTyIpXqfVeDv69y2ZOfh/voLpHV62g
zstha8GTcr538Q7dW+ZlB9Z6OTQuiLdgeRvvsFdaZXl0jZdDvXmCCcvreLj7
6h5Pnp71Mt6h49H85MBKL3j4vbslsNKowstB9FaXSNjTeIfgldIK7mVeDtV7
T3y68DjeYefCnlSNUgRfo09Hr6DJywE9vQAA5aP9sw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{133.159548989125, 50.63522576874999}, {133.159548989125,
        52.38777921999999}, {133.68831511599998`, 52.38777921999999}, {
       133.68831511599998`, 50.63522576874999}, {135.439618529125, 
       50.63522576874999}, {135.439618529125, 50.098959413124994`}, {
       133.68831511599998`, 50.098959413124994`}, {133.68831511599998`, 
       48.34765599999999}, {133.159548989125, 48.34765599999999}, {
       133.159548989125, 50.098959413124994`}, {131.40824557599998`, 
       50.098959413124994`}, {131.40824557599998`, 50.63522576874999}, {
       133.159548989125, 50.63522576874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHSLbfaEmM9GhK6rwzvR7ng53C9/u8CxPdMhd67E+
isHLYU2cidTNSky+u8+V38xz3OF8Nl8l3clt7g4P9HZGPq5KdPgb8XmlToW7
w5TNtrPf1iQ6aLs9XMxc4O4gOmlx9q66RAe1M55JFzLcHVJjA+aKNSc6KAZt
Upib6O6wbXfSQvuuRIft91fO7IhG8D0+c1508HN3WDltrvBEX0z+Gwm9u5Pi
3B3WV5pEHglDmNeg7B79NibRIcL4/Nxb6e4OGRUBdxgTEh0mPXulJFHk7pDF
vW3duaREhzMz2VaE1rg77HD+yxuXkuiw7Me67xv7EfzXhT/Yw9Yg+JlqPSof
cz0cxKTsbtyIAIbHMsbuvVYeDnwBpcr23okOLP+3NUkqeTjIteZ3adkg+Mmf
35ooGCD4ziumnE9XS3RwvcLUvNfMw+H6w/2rd8olOugsLJy+Od7DYf5Bzp8e
4okOwnkPVq/s8HDIipN/Xiic6MDU/pTz8h4EX+f3PLXcfwh+f9XtPkF3T4e3
PwMibkgAw9PtT2FFq6dD38+V+ycoJzpw6/G4b9vu6XDimrbwbD2g/nXTHrx8
5elgfvj07UfWiQ75oQ9f9DJ7OfBV3f7I7YPgi8QWmduHIvgmK07P+R6X6HCO
cc8T6++eDujpCQBdrwlF
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvcP5L29cSqKD9i/rQ2VrPRxg/C0lfzMrGj3h/Cqp
Nfz/jng6pO1usc6ISXSIyW1+dOCZp0N0x56mcz4I/pVj+3POOSL4GddaqoIt
Ex1er3siWHnV0yGlLZj9rVGiQ15IXcv0TZ4OCWZKU9p0Eh0+/hT/vrXf00H7
79yAGs1Eh0uKatO3xiP4Lu2/bKyUEfwkE+WsckZPh0nFjoxHtBIdfKqORa96
4OFQNe/JZm7dRIf5CcVnPh70cBB9yrMkVj/RYf/9WYz6SzwcDB+YTFsPtH+D
e17eiV4Ph8bVD49zmyc6LA+2f51Y7+Eg15rfpWWT6JAW0ivzMdPDIbR6f945
p0QHnYWF0zfHezjcWhm2idEbwU+48farSTCCv9GM4VdsVKKD8Vv2h8+yPBxe
6gTcY0xMdCh5s3N9eIOHQ0txxbng5ESHyrTAj13tiPAO+PzL4vk0BB8WHwAp
gbxr
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx/1opbSomHDHop0YRZpW7uxdOd+7D45lNS5mH2OnmTTN/JjK
dhYXF6tII3LISTvLzs/cjuJyRI3042pOmjZpbWFaadP3r7P1x+uP1/b887ye
Z39K1pk0WysrK2sWPxYblmwSYuJUUBwezFsIyWXwznbXt7Fyiq3RXgG3rzOo
tPHLtKumcE3+ah3QzGC9vubZYh2FX0P7pEHHIMh/UaVspJgOk3GiZhho72uF
Pg8pNEJ1y8clBtxW3WjoIwoeL/enYpsIcTvUpj0aCv7c9Ma5gyIIOFf+Dmop
jAUbCVOpIih1z5NjeykmoqlhtG/T8wevFoXzxBYvKXG41KgQozm9fza0i8K7
X5Yk/yRGf1FkmbSDwu1FbdheT4JiLs2Xt1PIUpzHuBEE7k7xaxdbKZwK0xPe
phLUqMrjZlQUOvcDrecLCVKc+ZeD6inueaUFLt0i2N3jm2V3l2K2VoOKDmLp
s3rWPibxNYE+3iXDzPYbm9dW95oJfklkMXK2V4Kk8I7gFYGmsifIh+0lH5qK
+qwnGOsSLgsfUETwe/VNTwiC9ZIcaTOFQKTgC5oIugPd9q2qKVIX577PVRAc
fxmpkLK9fpgc247kEQwqRQ3SPoqNIfvI7eEEEQPmeeUQRfiJ5bVuB4IvVZkt
jw0UpaXZb+6axCjKWpeNj7PzstmnMS1iSBJPGaWTFDtnTnJWLmx6x2+bYYnv
po9OG4urOkWoSuJFcEcoPILbp1yJCAMCF//VTooF3oiX6zJjuafqWoFbzgcG
dcs6Q2gbxSHX045/hhnLfjdWPLaotQyMZWbv/AaKKEOG4FgTg7yACc/YGor3
yUeDB24y+P8f/wEMiDDy
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       153.35200000000003`, 115.695}, {153.35200000000003`, 106.34}, {145.766,
        98.754}, {136.41, 98.754}, {127.051, 98.754}, {119.46900000000001`, 
       106.34}, {119.46900000000001`, 115.695}, {119.46900000000001`, 
       125.05499999999999`}, {127.051, 132.637}, {136.41, 132.637}, {145.766, 
       132.637}, {153.35200000000003`, 125.05499999999999`}, {
       153.35200000000003`, 115.695}}},
       CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
       
       "], CompressedData["
1:eJxd1Gk01mkYBvAXiYw1ZSmSeJkSIWKocSGa1OhIc8byf17PQ6oTqaRo0Cpb
ymnKSYs1S8soWzHDGRl5iWmoVIppwcRQSYQo5v3C/5z5cH/4fXmW+1zn0vff
uTFQRiAQSEmGSEZaMmbZLeP59ylapBy37jQmmLLU9lA3dUsCVVfZotaXFPvs
V3U/WkUwcGiFf8IbioIz9lXZawiWpl8oXjJEMdL08FD1BoIOp/PxNp8ptJ/b
BlX+SKDk9OdWXxmGwCPN5r4BBL//urlaXYFBvFuqq3EXQfpQSuiduQxx3QGu
pvEEcB/3mZzPsGnhz7llubzX93948Y+Yt6H2u+XnOgn0rqSExWgyVDLdqsdj
BAFPzBcZKDOsGi7x+kNRBIMTgT+YyjJUJbp9KFggQl3D+QVqnygEj+ZWXTIW
gV6X6V/Xy/t9ZkYDaee9eG/IQc9miufiwpbLeiI8fDGr9ngtxbak18u3qIoQ
7ZarcOc3igEPndMGUiK4DuRZjhRS2N2LFfb1EAzHXx46mk/hNCHsq6wjcFFT
vdCYSbHjjJeYNhK893WKWJZHITzy1ka7myAp3rFr7jWKtrSjWffHCSzylFyE
NygsL3b7aSuI8Ljmaa5VCcXp41rqiZoivA0PPRtbTjH001rxmKEIaf0KA99W
UUDv1fFz5iKkN2XFb2+iUPZS6TNwFyFTy9ZQo5Pi5NG8Q8mcCE4brXKiPvGe
2t+UfcRjd4R6DLbvHMV1HiJYqPodLjBhyMydbZ9oJ4JmxPD1YluGiSCNCgPJ
/fX9J+WDHBjkZ96M2TuTt+zfcR7pHWTa4ceEFQkNBAXhyemrVzI0+nCuY6UE
nyeHVydZMyxJ9GtQzyaoUxnd5bCMoeR1itAjmUBWzTQ7wZBBR25L+ulIgjkb
7ka2zWFI1pJRnNxCEFu7NGetkeS98zK+L/MieBU38izQkuHSpZCG/d8R6OZy
JnJ2DPoqreYnVxAcOHPiefgahj2zVUsntCX5VzSyNXdnWOnfWegzyE17+Fjf
L0o1vF3vfhQYx3Jo3Vcdvc2ZoaPw7LwXmzhUd5wa6jVluCYI0rQ34yDoEgut
DRgWB7dEb9DhpvP+YMeuKjlliedMPkuV5DOq9StZyHCwaJRadvAjhZFzvlvE
qC/s2m2SorooVJOVvY0GfWHVZBfx+QFvZ6UnHu41vINrQlPEtyjMrcIcskZ8
YbI/v765gGL3AQfFswIOvWbt489yKIrrFZ4mzeJQEeSc05FBoXtF/rCRBu/t
tzLcXIS8b6+bIatkzqH5Vvup0iyKN24rusxt+PNMlkoX5K3kIJvfFih1mYLp
SB0edOKgYabcNiHJc/C+e/svukj2E4Fy/yLe3W6K8y3LeNuUKHjn3qbQt7cu
j17FISFG/kLqPTq9z7FTwVWxbXR6n81tzZHKPRT/6s8q8lbnkDX6V4XjIG9d
OtnaKumfKX96fFftppqkX6TlvAf1OLhEsieeugwLH1iXfvlG8t5UP824rxlq
wixsuzw53BfUBm4zY8gbHY3BHt71JOn87FTeV195doeUcTDpHJ3hvYQhoKnH
y/ghh73fjpmtX8QwrqnVtbmXw43I+u5qbYbiiwUeadIE76K+aCmqSPpqkdrL
InUC6Z7JkGIBQ1ikSvkBXYLqNKvsyhGKq0HKSY0GZPq//+/rKf8HxVeLRg==

       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{126.082, 102.16799999999999`}, {
       120.62899999999999`, 95.027}, {113.809, 86.09}, {107.62499999999999`, 
       77.992}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{110.348, 75.789}, {101.5, 
       69.965}, {104.785, 80.039}}}]}, 
     {Thickness[0.006600660066006601], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4oRTBxgbf0Q4dMhzmL4QjHCA8TfYTQr4xBDh
YO9lluF7FJMfZNF1tCsvHM53vx1tpxIX7rD8lf3zxOMRDsXcddMTg8IdBL54
ZJWdjnDIm/gsVM873KHyb+DbrvMRDhf8Ivv5XcIdNnxeeFHvWoSDyb1TFz44
hDs0RzWUfLyP4O/lnfNT7xWC//3A9rqcLxEO86wXfJjnFu5wSn2aov6/CIeb
4bsr7wDty8hSfuHLGulwzfDDFSdfhPq4pW9V9YwR5n8423DERy3cgde89uSd
4wh+gqyWlcpKBD9M5IR/+KwIh+kstnyXrBF8332fmsPTEXxY+Nwz/sm8sg7B
X5VccmRebYTDEz7xCX8YIxzKJr9vmVIT4VCvfXNjIzOCv/l37MduFgTfL+fN
+lXsEQ5CLHXOm+sjHF59XHtVnzvC4fHaCa53WiMc3qyrLDvJF+Hgs33miQ+d
EQ4K9f+2XuaPcGhe+3LNlAkRDipLT0blikY4dE5o+HR8ZoSD9h0dWyuFCIeY
73FTuxZHOJy53brkk1aEw0k1470WayMccvVXr3Axj3CY0yuY8HtbhMPK+ZPO
SbtGOFimz1eS2hPh8HDqo037vYHxuEA5TWV/hENdfkHpvYAIB9verOObDwLd
v+LLjhfBEQ7cVRs1nI8g+LD08WT32vDIQAS/etOSKy6+CD56+oPxAc80NAM=

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxz2cdGvnIf9kzMopdTmRlWzRG224zIr5/b7feZgjV7qc5qk8
RCrF4a71wHpw8QeKTq0Sq7hJ11U0YubhbtUtjSW5UlMqdX+x9cfrj9c/n33e
789nXXJGdKq1hYWFpRmBGSsz3RdMEsM1iiFNcZRrKcH82uCwE/UUB342C2TH
CUr53GAbJcV8R5C2UkZw++Pm6pASitk1hjcaMUHogHx44SiFS8Si/59YgsCZ
OaVORqHWJmS1iQgOjRvLVRKKoLHO5vRAgr9OPIkpkcKvUMm3FRIITMnuF/dR
fGrNy31hR1ChHo7LEVFIteGImmCXPKzsq02Jetm7PQSKwQIW8exUgmovRdaq
ohpxNAtfz2cccbx5X85Eo7Mvi/60mN7iFAq3R7IuvhsL2/sZkZ1S8zxvba7O
jgWvZsV5UzZFZuJkP8eahVN+7Qi/iEKl4G4KmWdw6iE30KaK4tKV8Qb9FLPU
jyn7weXyUQZVPVLPwasUpa3GHP0Ag3a5otBeQcF2zxVwxhiIbD+3605S9Jx9
fv3uOwaOna+3y/MpdJZJxg+TDHY1a3zEmRSpu2eaOLMMAnQbp4VpFAEtvSLd
DwZbz2lXis198QpufinnsPDg9RmSwilO296qU5nzON+pjV3wp0ju7Xip28Hi
7e+SgcdCika91Yg0hkVDhGRPMZ9iejryvb2MBffIaFmSG8X+bS5+XRXLrpb6
TPxqWfa6xb5TZJJFQbqDUu9D8T3KEF/tQuCl9u4RxlIcqxzb0hK2fM97N751
TMUQHA41VqkOUszEOQRtSCRL+dY3emlSJASrHVVD/EKKpzvPuLtmELS9eqLP
kVMsztY30TyC///xH1FeMcg=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       103.410981557125, 94.72725044874998}, {105.379791604, 
       94.72725044874998}, {105.379791604, 94.23098531312499}, {
       103.410981557125, 94.23098531312499}, {103.410981557125, 
       94.72725044874998}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4u/qrPOm9Uc59K03darIinCA8X+VcqWpFUU4
XN8rcGH/2iiHf+8XLo+sjHB4GbjI8vOJKIesbWWn2RsjHH7Yzs78/CDK4WqN
9/utHREOCfeWvGB/HOWwcM2x9avbEfzSE54Wv0PD4XzLiCQhFY9wB/3Trz2n
P41yMC49feaDXbhDaoSNlvWrKIdT2Yc871iFO5iua+o/9S7KYcq9wkwLs3CH
vMR5Ihw/oxyOftTiWGkc7lC578zsPM5oh4mKy07MM0LwP9+TYGrQDneY5HJ8
v/TEKAw+TP152XUvPy2IctCxy3ilbBLucC1E8Mz+1VEOx9d9W+FkHu5QrDe/
796GKIfpLLZ8l6zDHZxbnn7O3RrlcHZi77tSh3AHwUKd0L/boxwul6iYrPRE
8Pmfckc1hCP4Ho/kp1r5RMD5TS/ZtwtGRDiUh2QZV2yLcgj5I7nXKiHCwVH6
2fvczVEO3Z1Zc++lRMDt/zKpWOFzRoTDopaenq2rohwO1e9qbMqOcLhQWNXW
swjBN2F8czx3PoI/XT2O1X9WlMPX30Uqn4Hx+/PJBTuDyZjxDeMDAGq+9Mo=

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYu7ZW+dbrY52uLy/3k+mNcKBL6LR4cq6aIf5
73/xCbUg+PbWP8PDA8PhfBb5e+ckXcMdnCeyttzbGO1w+spB3zs24Q7C1hJt
7DuiHZJO7zh13CLc4ckTrQ6DfdEOCXxvNfVMwx2CL54KqDgd7RC39K2qnnG4
Q8LrIxUV96MdJiouOzHPCMH/fE+CqUE73IGVu2PSqiBMPkz9XQbDe2wpCPMk
OCQZ7uUj7NvmtezYn7Joh2mzbbkuWYY7vJ9yyN2qPtrh/xK33me24Q7dUi25
+5uiHXI1ngfqeSL4rnIT5nZFIfi3N3nn9jhFwPlP+au+fAqKcHjn8G3Vgtpo
h8BrfhILoyIctvTeUk0uRvC9pC/N88tF8O+F/K1akBrtENDUVM0eGeFQZBWz
KyIm2mHLnwOhTaERDtzv5G7cjY52eF5R+eNTSITDddlZMy5HRTs06NiIVQD5
tow3yvwiox02r/iy40VwhAOnYbC5S0S0g0/M9mu5QD77iWBjlzCE+9hK2qet
Col22GT/dcuLwAh4+D3ZvTY8Esifm1UnPC0g2kFc2XhyckCEA7Pfno8C/tEO
XvNfm17xR/Abp1pLVYQB3YeWXgAWy/cZ
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx3HI6iSx2ljShVRKmNPIJt/JZdqh5fL//+Sh5bpcDuHI3RDm
Mjk6MpRNbbkNM5EyWTVTVEMrlyMxzWmWdXSZYU3nlbP14vPisz0vvs/3eY6E
JfhFCrS0tLTVWKvRUbMm2CWSehMKOxakijEOL1Kf+o+7E1QpvbUlUxwcUlaD
xDxhI9vkFqfksLP9va5hJEHHPDPG4jcH6XDCECchTK4wo6UtDpmtO4SlNwnu
N9Y/2gh5+AyYGHXnEvIW5jd1TXn0FayIrhUTys4bFsSe5FHRVJM2ICdMCI/Z
tXjxOL1s6TpbTwj4ExhlmaTx1o6IC2HNGrc3tunfO8MjGMYu3dWE3FPTXXkC
huJE0V1VCWHTPvnBG0sGs9arSW75hMYt22++TgzeNT5xphmEtPJp2zYvBvfH
vVZLiQQxPfkU788wWbs/qiGa8OwLX98TyiD6rAoRBxFC7mU91I9n2/1Er7da
S7IZZIffBm5cJHwYzPU1K2TQMogzd2OEOmn4u7ksBknl7sWScIJtZ0WLnZSh
aeZExHAsQRanvWgkYUhfcY5RJRPKf15vnItiyB0b77TIJhx6VZ1uF8JQpH+2
SqXu62t/Ox90mUFeeua56j4h3rat2d2RoUFJHnwH4XZsQ86BgwxTdWkj8j5C
V1XoSpkOg7Gv/NLES/V8/r4FpZJH5/GjxqvDhF9OnrJzIxr3GLWKVLZo3M+p
dKhUwsPFelmY2kP4q8z4LnbmUb48OmkhI8wvFMvFezT3dK0Iq9zQ5iEOMDXo
VufXU3gKB9a47f0cXov05D84PCqiYZsYwh17RaNiiYNgxHFQEUy4kjNo1jDL
4f9//AdRzS1S
       "]]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{158.512, 68.492}, {155.359, 75.223}, {
       151.586, 83.277}, {148.059, 90.812}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.2, 0.627451, 0.17254900000000004`], Opacity[1.], 
      Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.2, 0.627451, 0.17254900000000004`], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.85500000000002`, 
       89.398}, {143.785, 99.938}, {151.195, 92.367}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1HtQVFUcB3CGHUBxIBMSkKFamHCQyJGUxVHabxCMvBK3c1dencMjiocI
yhqKAgXKwylFllCTBmTkYcAEOLyEVQh5qCAQyUNBqcUpAlJYMcmgNnbgztQf
d37zmTn33vP7nfP7CUNiJGHaWlpaRP38GzO06vykKQzRoa06UikHXZM0q/t7
eTsZDOglU4bcAbNr824ccOtiqWkIg8psrqbEkfdxO26a2fI21Jc4expx2F93
uvCxH8OduPz4e38ThPoHm2e6M2QL6vcIZgl8F+xzLLczPHaTu1cpCbxEOqub
rBkmu17oJY0QDPd2L2Id70EjbVpiyDvfovqIYBVDvY9LmMEoQVdt/wAWKU5M
KGwED/7vs4m75Q4veLf37zxjMEfR0OAcYfCQoMWvaPe9abryvZOhXJTDLxQp
rbPHI4aI5r0xivULFsGNvQTvq6Jd2TDFy6lpr2XcJPB0KLzUdpeiZG3SubhW
3vqiJ3fJNd75sebVxbUEQn+vX4VKigjlrT7taoKwyNynbQsU24zcsp9XEmSp
Ug63ixnspQkztIIgwul5UJOEoWu100vj5WSl3p3KA5EeJQQV3s7RQdEMc8fk
HenfEJj3/byl9DBD4814Zw85Qf23sU/bExmu2LwSmJjGeyQvylgYzztPt8G9
MlR9Hlk9byfLGOiwTqpYwv8v3Stwh9KZ4E8f33MyVwbX+dGeIVuCxGcz+nJL
hsFDTmvOvE6wedTV2HKerlgSrZOePcZ7qW63KQwFpya3vkFQMLyhtvgqRYJ9
iJHyLaLJ6zKF93nUFjkS2Hib6mUXUFhGvPph+Hu8//iis+DGHt4fNeV1Hgwg
sNUfL7G9RCGyOhq1LUx9/r31t4fLKJx011WF7yeaOldTuEyUPrugzn/pnJop
qva5NypTCL6rHEvCDxRpWapFcRbBpws35rU7KawiP2+hXxEcSLWr71GvV13v
sP79PEFMe7CJg4Ku1F9X4ZsjbFDvbzsLF14kiCrIPZhXR9Fxuqi7soj3lumE
aVrGeynWEAx8HJXrcZ1CHCszYy0ExpA0C3sojo0FiB16iCb28fdxg9WEDjdE
NfdykMCy1XNK+Iiu9JdHd2FBWz/FqdGp8ogpPp+c5tTZvDk+/+V+Xd7/qo2N
f5nocxBofalKr6GINwpoYya8U2Izvdo38t601vVrTzGHnR6XZW3qeog2ib/3
/IBDhcr4QfEdikMC6ynLUE7TZw8pPgsicZlxHGzrEmIyVBST1jZnRUc5/Ch1
UBisYSt2cRk4wZnyTr6iKHtTPS9+U9jIRUc4NFoV9Qm2MniPX+g1lXEItFp0
bHqHYf1ezyeyGA6bT47cT9rF8JNFR3nkPg7aM1eT3lX3U0Kiwk4ayWGHj/4n
j/x5L8/H/3p5Pv4D951aCg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQvf1P2Yniu3EOQQfy9pv2hzis3/CgzuFSnEPtnCPV
NxtDHASb2+Q7Tsc5lO/UNVtWEeJwx5PpTu2JOIdb9+cXtxeHOCwXqJtRfDTO
wZZNaGNGXojDsj0bf988HOdg+cCN53wGgn++qfCNQjKC/3vTZNe48BCH1Wae
trxA82NkrB4t9QtxkFJ+yRp6I85h78010u3uIQ5hky9o6zyLc5BfE7TnnEOI
w2+eg1fEf8Q5tKhNnOZpG+Jgm2DvoMQfD+e/FJh8+pY2gj9pg59kgnO8Q3DN
9d83HEMcLt5lfHAhJN4hMj7Pkcc7xKEs/FPHnrR4h2OV/EwhIUD/b3MsTMiP
d5jl+XaFWAKCvyTIf/LjPARfIPdDsDYwPO4n/Oa+mBXv4JHsYHG+LsSB55dM
Jl9ivMPGHM/dj5tCHNjE25Rvh8c7bNYUjaltA7p/Z/icEvd4hy2TRBJqO0Ic
gqTm+L3XR/A5J+xikOBD8H88+6pf9ynOQcZY7v7ErhAH9PgCAGm8yS8=
        
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3fpyrybzgziHGOV/FntsQh1g/INsNuLm1gi+92OL
HCXlUIfdZXxcy5/EOSxl8Nxvxh/q0Hf3zZrMd3EO54rnl9/6H+Lwm+fgFfEf
cQ4/nn3Vr/sQ4jA34dmNTJZ4hx4FRZ4LL0Icit/2KxwTRvA99uYe75BH8P0W
sPDu0Yh3+Kqp1f/kTYhDkNQcv/f68Q5TDjR/mvM1xOFjjKYon3m8Q9rlqT+O
/g1x+Cz5detyq3iHK2Fme3k5Q+H8cuHoo/HiCP7ryknnb2mHOoQ5pH/uMI13
iHtw8maoQ6jDNge+ngta8Q6X3BifXAgJdaj99pFrslK8w93F+tnmqaEOTreu
NYaKxTt4ZLH0P80JdbhokC1RworgT9Ns/jbnZxycP8HtzYbMD3EO9xN+c1/M
CHWICJhz5ujLOAeHUwtXSCSEOihG+bxQfBznkLe9f9H7cET4Gm9Y3iDhg+DD
4gMAX9W+Sw==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx39E4iZKQugyRQ/UjBY211tNXF1/dH1/lOH3ZdMVNnFJD8ZN
cnWtRQ+mZNVRWrOLPD/VdjO3PJ1LK+SZ2aSspmuYWr+/3NYf7z9e+3z+eL8/
n7dHQqo0cQ3DMGa8dvMy5+VQcyVetJ3iTFr0seFZFpol9YkCL4rlV9e9906y
MC7n90rdKVRJLlpJPwtVnPPltM0UuZ31X3I6WBCDrrhnA4VmeSCgrZmFgVsx
+ttSIDPwfMZrFmcjF9KF1hQGVXGFr5qF/8K6+AhLig7fpG26QhYFWll2wB8O
CkrkN+UsfuYMNTj+5vD3omfIerGJh4J6zEM3mph8srh1d5xAu+t7k2iFw9q2
U/c9Ggi6shKrGAveb/3bssEHBFu2VjoUWFFUp4hbpnIJDhwO/qgRUAyNPZEr
5QTNtZaZEfYUlvba7nYZQYiXwWVyE4UfpneYxxBkHFF2S90odkrq1CXHyep9
8rwKi8QhBEtHG0ObPCmcaWt6yX6COxrxt8/8/tf03kvt/HwgZck6wIkiMqjs
cXoYQUt4stjRgSK6Jnj0uYRAKkroYOwoFo268vaTBPruIk+ZDUV3zItwZSyB
xC/xDcPf66lP3rz4HIFqrC/Q7BcHp6b80rhrBDm56upHUxyMWfd0ylKCMH2+
T+wgh6DbI/17GgkEbskVQj2H7FLvcf0HgtRDI9NMJ4fFGeO+7B8mhrtgosWe
XWX/qgqFs4TFxEHHuavDHG4wDacjFSzev3toJ2MoBKJan+RK0z+PROvrXjay
mLVZuCDk/Sts54JntOxqvsYoq1bPLhataQanST5/1DwVDvN9su2bchW4UhQ+
yyp3GWXxfx//AQFaKiI=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       130.09264412112498`, 84.30146844875}, {132.06145416799998`, 
       84.30146844875}, {132.06145416799998`, 83.805203313125}, {
       130.09264412112498`, 83.805203313125}, {130.09264412112498`, 
       84.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr2/LLWz5yY4KCYK2FucD3WA8XvVnyY9uxbq
IHeCS2zDmgSHiQtrlkjeC3VQn3T5lOeuBIe/6YEnjj8NddDnuPDI81iCQ4ae
2pvSt6EOyTdClEKOJziYxC1ck/0GweeoUjHdvSsEzj/Dacv/ZE2Iwym/H5dm
n0hwOKa27OSGxSEOqVMVDr89leAQKzvXbc78EAffA4dLTc8mOKhP8En7MSvE
4dXMQIuQSwkOEYtZWTNnhDjkn3hR3X4rwUHlcsPRuOkIftuEz//sJ4Q4VHM/
442bh8mHqZequLnIc1mCw/73Ts8fA82bK8wtsmF1gkNUwsWlTHNCHHIYgkrt
1yU4aG0T5560IMQhRPurevuGBIcE54zXpktDHHYvnHHj3MYEhzS1/waZ6xD8
RdOehTnsQfBvTf418deGUDhfdPajzRf3hDrkTd7uzgPkP1/7ZeevI6EOl8u+
qravT3CQs3adNe9kKNz+dhc/2c1nQx1aVnt80QK6L9Rwap3ThVAH6UX2hWLL
EfyzmT8E25ci+P9qNm74vijBoWOtr+JmYPyuv53lmzEfM75hfAC9Svhw
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4h1md2tztRMd0gqjvO+8DHWwFHX2s9JNdDBa
eJX70gsE/9KbyyHi20Lg/OkXdpy+uTLE4bIha8F+vUSHuLY5XnMWhjjsaeP7
eNkw0eFrzeTj7XNDHJbcFi96YZLo8Hn/cbV3M0Mc7lxMD+uxTnT4GHZC6d30
EIdH91KyelwTHVQuNxyNQ+K3Tfj8z35CiMPWPLdy1f8JGHyY+oUvpeZeZkeY
Z/eWT28/L8K+3r7QiX6CiQ6avhLsk+aFOKzc/DgwVzTRYVKYYteyRSEO5WVH
nuiLJzow3Dro924tgn/jfNYsr/0Ifl6KWpbP8lA4v+JgyMdN20MdVnbWNi8Q
SXR40q4pmrg/1IFnw/sDjfwI/vWy7NpyHgR/oXBj9gKORIfHxrEVx/eGOmS3
GXT/YU50cF83O8hpV6iDxQNBqf1AfpVWyNdNO0Md5Cr8f1kC+cL3xIQtgPwL
mXmZ5UyJDm5R57eu2BHqsI1xjecnxkSH+7yTLusC+Wa+a9w/MSDcZ6rsVqkK
5Lt+PL9xxbZQePiV53aESAL5jfMOmkv/S3BYdYV3gvLWUAfjCQ+WRfxNcLgb
cMxoyhYEX8RdTNxid6gDenoBADjYA9g=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       139.84494155712497`, 84.30146844875}, {141.81375160399998`, 
       84.30146844875}, {141.81375160399998`, 83.805203313125}, {
       139.84494155712497`, 83.805203313125}, {139.84494155712497`, 
       84.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4g094v7rriY6KCYK2FucD3WA8XvVnyY9uxbq
sCBc9sWhJ4kOExfWLJG8F+qwUvHZnJhPiQ5/0wNPHH8a6rBx+qMtMf8SHTL0
1N6Uvg11eJqe/iXtf6KDSdzCNdlvEHyOKhXT3btC4PwznLb8T9aEOPjc41q6
jiHJ4ZjaspMbFoc4PFcxnsrAnOQQKzvXbc78EIfz/tfcPViTHNQn+KT9mBXi
kKOZwpXOleQQsZiVNXNGiMPH8N++s4SSHFQuNxyNm47gt034/M9+QojD31k/
7hdcS8Tgw9TPYX9TEnMv0WH/e6fnj4HmyS+WfXbocaJDVMLFpUxzQhze9ae4
Bz1LdNDaJs49aUGIw7Vd7L9mvkh0SHDOeG26NMTB1nD1qocvEx3S1P4bZK5D
8BdNexbmsAfBvzX518RfG0LhfNHZjzZf3BPq8EHplKQ8kP987Zedv46EOoSy
cfyY+TzRQc7adda8k6Fw+9td/GQ3nw11YLOOPmYLdF+o4dQ6pwuhDnMNg5w1
7yP4/j+5nsy8i+A38Bxp4rqd6NCx1ldxMzB+DbNr5auvY8Y3jA8ATCD79w==

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltIk2EcBnArS8NSo5UolKdKpDSlwhPY06xE3Izkey0kbL2pJC6tMCMV
Np1ttghN1Epqms2yZmCec24GW7Ok4TqYhxKTxJSEbS6M0qSvqw/q4rn4Xf2P
/jQ3OWOVk5PTCjYhbFaycSs0dx2rpGj7oAkcG2JwJ73fL66UQl7hWN5fwcB9
493frX7/W9mpvz9azeDy0eF2fhLF7vFDvIAfDBTvLZ/56RQ+Fon56XYC9xrz
Aj+Xwjm1p+RAMufux+e+mwo5/3wUYIi4QTBf2+hsz6aIHB662tRAoFUTP2EG
xfpFidm5hcBSKV1WpVEUffWtEegIpryaR2yEon08t8BmIDA2zKmzEznbM/Is
F/mc613oa0EMxZQieNOpPoJBRcct2z6KDf6JF1QdBII5WZAyjCK2Rzz4UUNQ
JB52hOykyDQaZJJagonKhHCPHRS9lpjbomIC/jNtju3vPnQlv6wygoP5Cg/l
Noq3jpuaEDUBb2FP3HQwBS9+s1ekliCTORzvEU7x7V1fWtUAgbyurrk/mmKX
PtakmiAIchhbvOPZeudTEz/NEnjpBxJCUzhHm6xHpKc5P0yo4L3MoTCNOc0E
ThIUyF1ndZcoyp4I/dsGCaRZdaF2KUVLl3ooRc/Ou1cgEl6hcC2eufamifPJ
66J7reWcJ0SLbm/OsPN752iVBRRGg0u3JZbgbE1euZK9L7a4TWo9CbYGLy1K
oijW6I5X+Xex/3CiwceezzlMNb9UVcRZaJDq2th+6kd9Oh90M0hKmS6XyijW
fgmM0vYyiNBYPavlFOvqraPMcwZi97EAsZK9j0zuW/aKgVXS+GJ1OUWJYb40
a4TBv//7ByRcU08=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE3AUxtUsxdyEbuhDmhJK5px4eZCafoIEOock/392o8bJS1qipiWi
0gUVRyotKUxzmpRWSNg0MV0XNy/kJW+h1iZLl9QsUasHNcz25KCH7+EH34Fz
vu94Unpc4hYbGxtbi3wtsrOoec2tqkZNcJVrLlWHMOxuXX4ibSYUeivvRkkY
3qsFIsVLQpn417U9MQyhsfk3Ut8S7gzzZNNxhnTDIAl7CKm1QcKGBIafssqt
j98RJr0+jC2kM5yKf1CiGSLsquhc6S5gUHbcrKoYJbgvma8eLGfIG5RrIqYI
ia82/FKaGAbSGj1G9YSvDQHnvkxYWSIPh5eAb3K3zqF9JIxj1lWl0ljmd0y3
PIs4z7ESIJbqxwjlJlmtQsGhHYoMtR8mBD93mhPWcJzoPtS22E/YHtbqd6GJ
YyIuY+exXoJRcHtc1M5R1+MRpO4iyJSBlZd1HLHJArGig7Aki6/rG+Wb+aw9
LfLxn+VYd/zjK28hJGWelBrMHCEb0S72Fr/IJ6xfNcPxA9XLjW8IWnlKw9JH
DsekA+peHWG/u8E4OsaRmR4You8jeDyMVKkGOH5/Xp/MHiSoszOuLHVx5OSL
o/SWvHLSSphbG8dfid9ZvYFgM1P0yP4+R+FFXb1wjuC1NzdPf53D88jRRNE8
ITIydF6azPHaw+gTs2jxBy9ON8ZwlDp7K/TLhOL5feWr/laeyrelRqGV58wJ
2uhxhnGB0zbVN8Kte9zsXMuwtrD2PXuCkFVBSucsa59j4ZKyjiSGT/UPijWW
/StLPR0LTrPN+3pzXewYY3A4rDOtagnepheqailD23SzcaSTsCCucjsTwfD/
P/4DtsA+fA==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       228.21099999999998`, 112.65199999999999`}, {228.21099999999998`, 
       103.29700000000001`}, {220.629, 95.71100000000001}, {
       211.26999999999998`, 95.71100000000001}, {201.914, 
       95.71100000000001}, {194.33200000000002`, 103.29700000000001`}, {
       194.33200000000002`, 112.65199999999999`}, {194.33200000000002`, 
       122.012}, {201.914, 129.594}, {211.26999999999998`, 129.594}, {220.629,
        129.594}, {228.21099999999998`, 122.012}, {228.21099999999998`, 
       112.65199999999999`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4i1nlfw+7MlySKx8HX52W7RD08HPUT5LshxA
ahhsox0Wb1+1SeBbJgbfIvLf9TNu0Q7x65jfn3bNcmC7I8LN/THaIc/wr5RP
TpaDc3uuZ5tTjMPXTz8NeuqzHOpPHmtunIDgLwlvP6N1E8GfPE9KbMO/GIfz
Cnrn9lQC1QuvDzeVjXVorpnGIZeX5eDQKbhrmkmswyLH1PDcpCyHGxcdXK94
xzocmGuyyCY4y0Gl7AZXcXisg/7rrOmXHRB8O032QlVDBD/j/qItc1WyHJgz
ihUq/GMd1vDaJdlIZzmUP+KflGwX6xC91F7lpGCWw5uYNcz+urEOCy7fupjO
keWgIeo98y1frEN8Jz9r0f9Mh1sbWpd8fxTjIGfvYlEDDI/foa+7ip7HOITo
O/Oc/JPp0J1bHXBPPtaBn3FFnBZblsM6a74sA49Yh2dePNKbhLIcCqQKLggm
xzrctby2d4tylsOkeuZnj9tjHTpT5hu5WGY5iIjMqj8/M9bBRvWc+opgBD+D
Zfq871kI/v/Hx1S31mU5zLt5/l5PV6zDh6VaPsl9WQ4bU6znsufEOsS8V/9R
My/L4Z3MLaNlvrEO03l6PeSWZTlcXSEs9Fcdwe9w8ZNl/xMD56/pUJv0Z3uM
Q/clzR2ek7McJr42sqvJi3Go9TfoOQmMXy9/Xu4bsjEOvumLvcoVsxzu7lbv
5mqMdgh7pPXkTw+Cr3jp0PLb0xD8h+l9RYJA97wQ/dK8uTnaoXZK773vi4D+
EVVLvt4V7aBxf//u6BVZDp6squYqE6MdboRFiIqsz3LY6qf02HZhtEPf77DX
CtuzHJrkAu08dkc7oKdfAJ4DNzw=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{176.094, 66.531}, {181.54299999999998`,
        73.67599999999999}, {188.363, 82.617}, {194.54299999999998`, 90.723}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{191.824, 92.926}, {200.672, 
       98.754}, {197.39100000000002`, 88.67999999999999}}}]}, 
     {Thickness[0.0033003300330033004`], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYCYsPUBw0O3ikOCxOvGbwwCXWA8U82JPh8Ug51
UFCV3rLMEJOfXRVxsGtiCJyfIKtlpdIY4hDydf7nDUYpDj2+PpMTS0McOKtU
THebpDi0X94SqJcX4rD334qyo2YpDi8nqHfzp4c43Px5IUPcKsXBV2HmmQ/J
IQ7Oug67ftgh+A/YztWIuyD4tQ+i7c08Uxy21+a9mZcZ4vBM+PQEcb8Uh08z
O0vvAO0z3Sr4ZVlgisP74n0XnAoQ6suf71bUC0OYzyngf8DHM8ShY/a+lHdG
CP5GPlHZScoIvg7Xk+XaMikOG9y4uS7FIfhpDAfrw7sQfFj4fJj5pzGED8G/
ZmiVdJ43xeFvwNPuPyqhDntOljt5AfkzcpevbVRD8M/Y6rztVkfw09ftWr1K
K9SBi2n/wptA85hNai7q64U6fAo7ofROMMWB7aN70UnDUIflt31SfginOFge
PLPxslGow+FrJWFe4ikOts+nh+VahDq4eTj8fCyd4uAi99vCyjnUYX31eq+j
CikOT2VDFnzyDXVImzwzbo5qikNbYeUSl6hQh/PHODbUaqU4HHqYcEo6I9Rh
3mZ/QV7dFIdf1zes258X6mBxQdB4kl6Kw/SNdoX3ikMd5rttfXxTH+j+V4e2
vCgLdWDfGzFF0RDBh6WPv3+rgyNLEPwpX4ouuBQg+OjpD8YHACkyHuY=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx0933ZlSycx0emTXRrudNEpm7+RhSjS+v9L0IPclUx5ScXoQ
1w2Hynm4MpyTkTRsIktzJ627yC5pPczDyR82lE0rPems319s/fH+4/XH5/N5
f96fz9bYlIg4LofDsWLlxmoFq4kQmWdyNcUXq7ADzo0MrhZrXXpqKLL3ZoqS
tQyeqxRauZpi3cLqZ0UqBlHzDgdrb1NYRzcN6xUMtiW8SLQUUOwqHPC0yBjU
/PhtlOZSGAQ7UjqSGHjNzgWEyymOCosakmIYcAr4nrIsilDdic2CwwwcZB52
/RkU/K/BaX0eDAzvZ5p9LlIoBI6+YYJljunvscoZJEs8HP9LOaQhaHX/Lg5n
64sOhZaevkRQYS+VS66xfoPb7jkRgqn2B5P6bApvi2+Xyz4C3rB3g1nB9kst
TTN6EOQd5IbIlBSF2o5XPBGBTbfps90tis7BD67+Gwj8xxQaeTlFy2hj7cgq
spSPTaeiXLkQCeNEh/10FYVmrvX8yLdIHA8M1gnYvFK5vRm8v5Go5/4ckRZT
jPapK9u4BEpzgjCwiOLTfvHYpA3Blnen7kryKbJyn9bx1hNUS8vm1TcoImYr
goxCAqeXsQoJm5eoO2NWuZ2ghB+fLLlAUR1yuUrD7mP70eRmSaS4YptnMEYT
pC4iwRxHod/4ZuhsOsFb10f1+hgKnlg4vlZFsHL3uQDJSXZexrRY17LMhubF
8QXTMj9B5fUoGwY6r3xj0hmKNaqmKLUfA/WROxPqTAqV6b77w8Tlew7M9LZP
pTN4XDsXFM7652vMe0Q5zNJ+flN/uqRKBgXWr6ftblKMZZFNziUMRuInZn3K
KBx3ptYdq2Lw/z/+A3JhLEY=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4n2P5fpPbUtxWP6R2a6iN9QBxhfecSNRbWqo
w7p1Khr3j6Y4iBsVLI6cE+qwveLtnYrLKQ7NP1yOsy8Jddj/7uWXivspDu/2
Sb7eujrU4fO+PJPmBykOu95NWb16FYLfxyVh8rsiBM4PmmXAp5Id4hBlKvT0
1MMUB5/tM098SAxx+FptdVXmSYrD47UTXO/EhjjcXXa3PeVZisNaBYdUi8gQ
h6qGbK/m1ykO94x/Mq8MC3H4v46pb9vnFIdVySVH5oUi+DyKz//W+4U4cH/6
L9+7HZMPU78q7vOWiv0pDq4NZs+Uw0McdH+pqN0/kuLw4MORJU5RIQ5/nmW3
5x1Pcdjgxs11KS7E4Ykgv9W2kykOzy5HvypNDnHw7tj06u+pFIc32z7pr8xB
8DXUb4U2VCH4CSrvJljlh8L5s7WvbRKsDnX4V3kx0hrIz7V7scOqOdQhOZbf
YtuJFIclpy1m3msPhdvPe9VR5nN3qIPIpCS2KKD7bh/sqG3qC3VY3RHZ7HoA
wY8NEFLZtg/B70s+fUhtT4oDn52jwmdg/NofaomfvgMzvmF8ANhlBSc=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk2EUB/A5setmW5Z3Q41uaCiFmpfmyaxkuDnseWB4ndPT2MSlLE1d
ZWqw5UzBO2G4IoaaCiqrD0pFViSYAxklkYvQLMNFXkpkrHo/9UJ9+H/4wYHD
uYQpL2aiJ4fD8WBylAmXScCMfUOnQ4hX9YQHthHoH5tW5CMCL+yzu0ZKIFhz
/6TN438Lzo3cCyAEDL2O9bwoBGtJvI/SSqA9YjY0/wyCWaGbWpln6p322HwZ
QsPXwdpaAf1rUWLR2pYE1jUJvs8uZ1DgrA6k8iUIj1WTxi8KCpOuHIX6LEKr
STeVqqXgWDKIxpIRuJU+7Y16CqvaUX9+HEKCtrAquo7CzObagiGS9e9xvaBl
P+uhPDVPHYyg8Q/Zc/cqhTnH+CzPD6FzWFTm0FHIOm1SWYQIz8WK6SANhYYJ
x3ExD2GZPKp7IqfgXJKVRWxFSCmI6jInU5AJJoZ4XGYf0orNqBQKma+bMixe
CPIbpv4SJYVwSWI9dyfC7bfbfSurKFx6IDFE7EYoKxrNtRsptP20LM8HIYxI
j71w3KEQI576HnOY6echFQf3Ujiwd+amOI51WshGc3cqa6u5kyxkIKQXry8W
9lAwzu068k6O4C06Fbp2i0LTU4uWr0SITeuyd1xh5jWdN6svIDQJ3zcIVaw/
hRDzqoQ1rnzbITzEzF9a7rJkI4iJ66HATUDv1NsszH1fDv764JomEHndM6k7
EKFRkt5aUM78w2hfFl/OWvRjM2k4l3V2oNFtK0A4qPG2LlYQyBl02rqLEJp1
fidc1QTOcDdkwyqEluj52bZrBKrxo9JYzNzHp3rfKwMB95sBr/BShG1ksb6v
g8C///sH91M3Ag==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{174.30398848912503`, 83.51413176875}, {
       174.30398848912503`, 85.26668522}, {174.83275461600002`, 
       85.26668522}, {174.83275461600002`, 83.51413176875}, {
       176.58405802912503`, 83.51413176875}, {176.58405802912503`, 
       82.977865413125}, {174.83275461600002`, 82.977865413125}, {
       174.83275461600002`, 81.226562}, {174.30398848912503`, 81.226562}, {
       174.30398848912503`, 82.977865413125}, {172.55268507600002`, 
       82.977865413125}, {172.55268507600002`, 83.51413176875}, {
       174.30398848912503`, 83.51413176875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHWWqKCDTl+Zwxlbnbbd6qMPjzuYfL2anOdg+nx6W
axHqsKnsVGTFPEz+qm13/ziyhcD5XNtbpnb+DnZ45uY/s2l+mgOr7dvgsC/B
DrNOX77VszDNYY7xkwuOH4IdpFdZro5cnOYws0zCYMWbYIfs0md3ti5Pc5i+
06ef72Www57LPx7cW5fmkNRwwpvlGYKv1VWRnnA/2GH9OuNggyJM/t85Xbmd
z4Mdtk48NSO5GmFem/XdWT2NaQ7GWrd9dYH25U14Jr2wJc3hAnOmgM/HYIcC
ZZ93ue1pDrl3v13K+hbssC96su/fjjSHmzynf0kwhMD5NSffM2XzIfi7F1tO
tMgPcZAxuiJeUQsMj+SSI/NCQxxEMriT7+WnOXAK+B/w8QxxUJnLeupkAoKf
yd1Ssj8Ewfc8oMXP7p3msPJXyYF5wSEOd3+Gvo5wTnOQTVxzSjIjxGHpzfkW
L6zTHCYcf3xlSk2IQ0HZVjVBizQHjpBnzSunIfiyfM6TyrYj+Od8E4+duB3i
8Fnw+fRy2zSHR5s/mv/5FeIwRdDhv75HmkPP8kolaZFQh3PvDgZZBQPj57nd
+y26oQ62txOlm4DutbNO+cxmFeogMqnQcHUBgi9VylF+rxLBtzqQeGdaMzD8
JgZ+vGsc6oCengBKkBGf
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvS96su/fjjSHOb2CCb/7Qhxg/Iden4z//EDwD889
ybZfKtQh57JUNXtjmoOpu2nBAu1Qh8QFQYdyCxH8W/dC1+SmIfh576R2fYpN
c/jz/Gn7H6VQh6x5L916wtMc9u4yOtgtGOqQ5rfjsmpgmkN9b/0vKYZQB0NR
kwnSfmkO+QvbTkm9CIHzNa8UyN49ieBv12Ld8ntHiMOM7usOyf5pDmvPXtOZ
uiLEoWFb1edVQPOuOeg+tZgZ4iD9d9HjP8FpDmkMB+vDu0IczH+cuuoHtD9+
i5aZSn2IQ/vhcvbV0WkOUVaTv3woD3FQmct66mRCmsNOK6tei9wQh+jJoety
09McZBPXnJLMCHF4cPDNxwX5CH7ah2bTK+UI/na/aZZ/69IcFNrL8zcD9b93
eSa7sDXN4WDbhWvZFSEOXd18fJ/bgeHpPKectQYRvnpchbM3NyP4sPgAADpx
vIM=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxz1UdEurKKJsjrQ8RWNYlrelxXWsdd+vqJSdfNdIZR4WNs4W
jdLcpKzmtGKHHOUh7brmSOchT6GpHbeRh0wPypodu+r3l9v64/3Ha3t/ts/7
/fk4ia+eSjA3MTEx5eTGyYzTdXH/blUzg2ypMUW7LMKkQ9WBxOcMvLYbZYVr
ItyzV9fLlQzW6rncKB6BaZuXWWEHg0NcOHO2JfAPzZ320DAsHdxvNccnULYK
8jV9DLHN3e89vQic20WW2kGGB86NKxuCCGL4R+ybRhiqJJM5SUKCo77WQXGf
GBYjlt1rEwlKP8RU/phgSPZ3EbuUGfnN0qFg8TsjC8jai20GgjrJSUctN1+e
LFfkuVKoy6f69KMMNmkhst7jFEV+Ky/5wwzKkD+fI89SOHl899vazyAdlLs/
TaSQKfmlad0MCbL8keQMikueI03DnQyjTq73W/MobIfaG+SvGDJ0gkqLErre
j+RwpuuVRxRvrynqcloYvppGCvbUUBiY4Q6f8ze3+fTqKilaaiJSNGqGsJ/n
qr3LKYYHtD6zXQx1DUO67VKKwPGZFn0PQ7VvQIWukEIV9ux06QBDwMaL6d4S
iuCZqR4915fBkC2KSaPQVOt0+kmGgpTMqtAzFMKxdL7nHEON4nKWAygWFOaz
JxYZ+sY8Fm7toyi4KZUnLnH+rumJeR4FSftoufqLYUu2TXHgN7LO561+x833
GzkpK7qjSErwMF2Vr1pg2OUW/kUYS9BJFUml4wx656gSoY/xntHD3rdXXQge
88gmLbe/496dFq/tyXo+Ic/c9O4OgqEn6fF2XP761NoK7WaCnGPxF36oGFLV
xXayvyL8/4//ADsjQYg=
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{226.94899999999998`, 
       119.34400000000001`}, {234.012, 122.35499999999999`}, {
       242.57399999999998`, 126.012}, {250.691, 129.47299999999998`}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.0033003300330033004`], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{249.32800000000003`, 
       132.695}, {259.89799999999997`, 133.40200000000002`}, {
       252.07399999999998`, 126.258}}}]}, 
     {Thickness[0.006600660066006601], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPS1XatfPvjwHIZY6580n4x1gfB7F53/rD8Q7sF7v
7Nzoi8mHqbc5ezM3NCTPoTJgt6reqXiHZQye+80i8xzWKjikWpyOdyh5269w
LDrPoZq3/djxs/EOzreuNYbG5Tl4/jqrHn4h3mFVQJXR3Pg8h4Z2OY7fVxD8
Vz/V+vlvI/ihB35v2vso3kGzSCTpQmyew2HnOeWs7+IdeMvf5NdF5Tmkh/TK
fPwb77BAdlMlc0Cew93ijFVe4gkOh/xuvdTmRfDf1v1xymTMc/h54U34yk/x
DvPdtj6++T/XoY9LwuT3q3iHIIsrQeJAfpjICf/wJwj+m22f9FfeQ/A3uHFz
XQK630bBedkPFkR43PVkulMrgMmHhd81Q6uk83dzMfgw9ctv+6T8eJwLD8/Y
z2YV51/kOqy/y8126Vy8gw7Xk+Xab3Id/EpSM7uuxzt4sPLMqn2f6xAS/mfd
3gfxDkZvq97Gfc11+Ptt+x+nH/EO26WFDCf9zXUobNbdcZ4vwaFXQZHnglGe
w50ZKaydPQkOsQvO2utYIPjBUnP83pfnOSTd+npr77d4h8VPPRq8a/IclF2c
BXwfxzssXSSi+LQ+z6HxgyzP72vA+O2PbippynPYOOv6suxL8Q5ONYseM7fm
OYgc9HziA4zv1a2r0yQ6EekDPb0BAMmaJzs=
        "], {{240.54036446000003`, 
        129.05537444875}, {242.39542103750003`, 129.05537444875}, {
        241.46789274875002`, 131.264191815625}, {240.54036446000003`, 
        129.05537444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdknss1XEYxn8cbZJbkzVNZChMYjaWkWclJK1lY81s3682mjWvy46sOEYu
J8XY3DoVI02WHEvlfonmFppDzb1cO02MzUYtpl//OFt/PH989r7v9j7P+1rd
iAmKkAiCoCXKQZS2qANOB3e8lglbwilbw1yOcqnLap6a8L7U08Q9m0OdYBoV
9JVwX5bFe9M4kierTOLGCRmng9dYEodvYIjr8Cjh8cXvipQEjg9TD/JdPxEW
JcWNUzEcoao0A8uPhBoD3zG3KA4bKvnj10s4+U2ZJwnnOBvWPanoJKT/sm5e
usax0pJ0W6+N0J1+yOKFp4adI+ZSYaXhaNcdnyhdjjGjzG0LcT7nSmBBuJqh
fXszQOghGPvVPzPrZdBXeCjz+gnuu54t1m8Y7Dr6STlE4LEF8X2VDDVnCg/7
qwgPy98N6jxicKpgb+e/EBpHxm3O5zBEdpneDJolKGeqK6ZlbD8fvcaMouxo
hp89vjNNS4Syjbq46QiGVPuJrHGxP1bSnahDDANq+XPXCcLMQPGT+gSG2u7f
i0c+E+YuOM0uJzP4NG9wYYSQktVaqZPB0OVn2xE5SAhaU/j25TJ4vdoMFP7l
1Z64lq1gaFjZchNaCaWX7j4tE/24tLHNoXpCkoG8t2+YoXBB5aysJXQeV43e
+sGwretDedUE7ZLcdbkWh735rr5QJdZbpUeZsYYXQ/bWZSc0HFY+7O14jmPh
mFm+Vx1B7h/sePk6R4uH3cvILoK/eqwomDT3jEwID5VKOaYy04wsxf0lV9fN
C+7wfX+WUtnsaxmHcpXVz4v+Y7wdjAzvcewFxDfozRD0zZpUjnKO///xL1Do
OSk=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQnb74bpJWWL7DM7lp3476JDh8+G7v/T0532HeZ+/V
ZqEJDvuftK1pS8Pkr9p2949jRTycz7W9ZWpnbrzD5y3cbyak5zuw2r4NDkuL
d1huOUF3dma+wxzjJxcck+IdNCS+/U3PzneYWSZhsCIu3qHi8SL9I/n5DtN3
+vTzRcc7nHTcavy2LN8hqeGEN0sEgq/VVZGeEBjvsEfmw1I7K0z+3zlduZ2R
8Q6H/re9LnRGmDd55cy3szzzHYy1bvvqAu2r/rcob71PvsMF5kwBn+R4h9qJ
HI41/vkOuXe/XcrKiHc4fdJ/AXdgvsNNntO/JIoQ/JqT75myGxD83YstJ1o8
jHfQXDAhq80VGB7JJUfmHY93ULx2fOsb83wHTgH/Az674x0MuQ/J3NBA8Msq
HY6flUHww/SeJ4oK5zus/FVyYN7ReIdX6UJ26dz5DrKJa05J3op32OQe0/2N
Od9hwvHHV6a8A7r3SWGlPEO+A4vW54MhLAlwPl+7ouduEQT/+TKD5CdqCQ4M
DYtftbLmO3y8+UO6zizBYWH9n0A7gXyHY5dtJvI6Jzjcjqlb6iGd73CueH75
Lf8EBy9PubwJQPfOl91UyRyW4KDIoNey0wLBV3985OQbRwTfXU9Of6l3vsP2
Eyt+vAtKcEBPTwAd5hA9
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffqk/wLuwHyHc8c4NtQyJDjA+AWqPyXrTBH8R+dS
muPdEhwqHa+fFfXMd5i1WMrigl+CQx4fv2iNJYL/3Efof7Uegl8dc52HUS3f
4d/nT851XgkO5TzLZs6Sz3eIj5354KhjgkPxnhI1E8l8h/3H7Gt5LRMc7Jo/
PNIUy3fYEeCcyquL4Itk7eh7J4vgx0xlulUrmuCw9OfkyYXi+Q7X0rKnefEm
OPSqmLvtBJqXvWBa0RzWBAeN7Hgzbpl8hzSGg/Xhf+IdXNLaNWJB9m/RMlP5
GO8wxdAkaqdyvkOU1eQvH17GOxhyH5K5oZHvsNPKqtfifrxDBqMQY41+voNs
4ppTkrfiHd7qr3RZb47gF8c5dDyyR/CP7Anq4XbPd1BoL8/fDNT/Z9OigvW+
+Q4H2y5cy34V7zD956kExoB8h8POc8pZ38XDw1ePq3D25q8IPiw+ACbesJc=

        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxjdXOVaKJYm0vNQywzIvoULTeNCKpBkxUjKL/5ukYZkvYwkz
Zxebstk003mfy6VdNHHpaFqhLMwkK2ZpJV6SbtYSVLKMBLP/Jwd9eD784Nye
c86GZCpN4XE4HC6rAFZOrPL61el92RSGGZNsJIXBdw1RKrIoBO2qMs0ZBvVq
5eL9XAp368SFBCUDV7/JQxUaCiGJTRVpGOxuE4eJiyhmgvxdJnQMekXOQ4Ml
FMfMva8C6xgEB7ol2cspqkWm38taGKQWz6dbqykaLo6dP93F4OANW1GGkWIy
bnZr4yiDuhiPHwsNFBbhmpASHlniZEWVT6u3g/2acpLUEQTtU6tkdjb/hWXg
LSQEL1cYvPh6dv6HvrbPRwkq6s0rQyopxnwXZbdTCbZXN6nX6yj2fR0oi88g
uLtl/EvuVYodtmh7+FmCzJqi5eMFFHa30ufDWQSbopRcy2UKMb1p410iS/ux
1ka6R2gIXr9PW9AqKeY4/n6uhQSCNw8+BLPxwyOVJ6bVBI89BE8G1axfRYvU
M49gTFypmtVSxL87Oa1m6+3dY3TmX6OQrtMfmM4heGZJbzKWUeid2nZ6sv0l
UoOQX0Ox+LezcZucYMC9JoR/i6K7I1K6kfWTGB2aKW6hGEwI73RJJJgTWiOO
mClSTpX/7NlPUPorbl7RQRGTLJuS7yI4/lGXxH9EkR9V8FQf5GBT/rl7ch8H
h0U1kx4uwZ1PiqG+VgqPgNhvEhsDW3dal/E6xR9RQrGk3nHPw/3B2vlyBiaF
W6Kdnd/ba61zp5ZZ8icR8Lg6FYPR1aGWzaz/Znlj7Ug2gytmn7YFFYXcWuhp
kDH4/x//AVsVNkI=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.006600660066006601], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{194.285, 113.34400000000001`}, {
       185.254, 113.71100000000001`}, {173.93800000000002`, 
       114.17199999999998`}, {163.71099999999998`, 114.586}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.006600660066006601], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.43800000000002`, 
       111.09400000000001`}, {153.59, 115.}, {163.72299999999998`, 
       118.09}}}]}, 
     {Thickness[0.006600660066006601], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4nSe4qYHC1IcpC8+MlzBFecA4zt/yPHd9DPW
IezM2q1u7Zj8py9TDnmlI/i3esysn4TFOnTNMfoa0JHiwLY3Yoqid6yDveJ2
s+iuFAdG54NB75xjHT4vta5I7UlxSGYw6TlvE+vAvzA5a3t/isPx/qVnN1jG
OlReubR7xhQEX2xdQt32mQj+5vZ3DtfmpTgYvq16G2cf6yCzO3bS9sUpDjmc
08rmAO3Ljlny1W15ikPm41MXmdwQ6j+GnVB6p40wv7k++iCPfKzDPqfAtL4O
BP/51uVyRpUIftLGspWnC1MctLaJc08yQfAf5J9tEE9A8GHho+bY3/wlGcHn
uXkmOR/ILz/wsWfPr1iHTwVcLq+SUhyE7m5e5/gHwXdba/HO+y+C/1D2+Jos
hjgHh5WBiytTUhxqF3dces8c56DxL0qlLz3FoSEhpLiTPc7hbtP91BmZKQ6b
DW5umswR5/Czlj3iVU6Kw/awJeG6fHEONe8v/WoGum9fL7vVL4k4h6dKTj6p
ZSkO8b0JCzcpxznMsdJJsKlOcWB42LqUxSDOgTVv9kbZhhQHm8Dc07dt4xyu
RD0SWtuU4lDivnd9vUucQ175EhOjlhQHQUXvonmecQ5X37o/rWwFuj/q/NYV
PnEOtimvpx5sQ/Bh6aM8tyNE0gvB50upv8jihuCjpz8YHwAKejRS
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx0VlMXpYdadVwiRFZXShh73NiNxqa3Z0+/1+TvumJZs6kj84
ynnsYSO1jFvydGYrSfTAxewWZ6c7ruSOy0lYEVG3RKzfX27rj/cfr30++zy9
Py7nEs+ct7GyslrFai8ra1acWbtDjj8J4q4II4bSGTw77OsuMhMs1GV77E9h
8MefU+E6RVAQ79TBv8DgTlktP2iM4EZ382CGkEH0+ugEmYngycKAn+IUgw+y
WyqbIQJc8798NZhBQnFW6MxHgt6CB3JvHgOeT4kf9z3BW+/4XZ3uDCKclZvi
ewgyRZFJ+bYM/qan1xtUBMspbsccjfQKGwJ6rINqLBzZv/pmUTKNsb6cgzNq
grWK6GKXCBqa1+YsbR87b/ObSr0njZ3U0YmYfoKGhPCW0a00Aq93yyUGtt7w
w6RcWxqKuXsnucMEazZ0qJWLFEBivzeMEvjgi7v1DwqpUk656yTBHn5TRekI
tXIf6e7C++G9FJbywrbkzxFwRa3iUhWFoil9m5zN/yZ+l6pk44N1+UabcQJB
QGWZWE+hLXtx+9gIgbAx8FO1iYIgba5EaySYN3dWKSco6Ow8fvP0BGqq5kTu
LIXTieZsrY6g3Es6Hb5EoevxfKK2i4DzKkfGcGgEZ8R6ydoJzGl3O3N9aNRU
6y5KWggCbht1+/g01qlD5DHNBBKZh0kTR+PI8HKItpHtN24+IJFaGDvsR1qq
LOz7VJ7JNdH4ZdymclAQ5Fm9OCvYzEC95DnK0xDYH3/udQkWP0OFmqZaPoOp
sKywmQHWT4fJwHEBs7LfyyjbVrcYBu31sZMNnwmipkXOQ+w/bXRMnjF8JSh8
lFblJGbw/z/+A1USRq0=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4i9dGydk8aQ6KCYK2FskxznA+L3qT5OeZcU5
PAndrlkvneowcWHNEsmiOIe38g33JDRTHf6mB544Xhnn8HVqzTcJ01SHDD21
N6WNcQ6aaYxmymapDiZxC9dkNyD4HFUqprv9YuH8M5y2/E8cYh0m3FnyLMs8
1eGY2rKTG8xjHbSVz17bY5nqECs7122OcayDsF9BJ4tNqoP6BJ+0H3qxDhvU
/3krO6Y6RCxmZc3UiXUwDZvaH+aZ6qByueFonDaC3zbh8z97lVgHx5mTFHV5
Mfkw9Q9Y27ZJiKY67H/v9Pwx0LzkhdvV66VSHaISLi5lMoh1MOr718Enm+qg
tU2ce5JJrIPUzoXWYfKpDgnOGa9NLWMdGvVd38xVSHVIU/tvkOmE4C+a9izM
IQDBvzX518RfLnFwvujsR5svBsQ5mCimRN8Gmvd87ZedvyLiHGayLLIMk0t1
kLN2nTUvNg5uf7uLn+zmxDgHL8uv7L8kUx1CDafWOaXEOTzUf9PyVBTBn/x9
iWqYCIJ/hCvuyDHBVIeOtb6Km4HxW5opnmjOhxnfMD4ANHrS5w==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk1EcBvBVlg4vYd5gIDJXeCELEm+03BPUJDSWy1TU9+SWp6EJc2Yf
tNTSsWYauFiGZqLLIi8LzVBTZ9qWUCKpYaElGYqJQpZKYJrr7Usv1Ifnww8O
5/I/j1CpltMdPB5vG5sQNtvZyPJV6x6vKDretYimMhnMKBVKew+FrnJ1S7KX
gdw9QqJO+t83OvvvTwYxsMg0P7a0FAenj3v6lzMYHs/yt9dQCEaLR9qfseuN
qkj7AwqHlJ6So/Ocu5tz1oZ2k79eb/K3RuwjCK+WSM0misj3E2WPwgnspmUF
v5bCdaN4xOEYgadBgNTbFFe++FXFxRMEeksF5gqKp9Pqgm9JBE4NuvmAEs5h
GW57DuVzntu56crPpZi7HuSlOE3goZNNtWZTuAtjc+tOEFQu+mZKVRTRPdlv
PkgIBrI0YYsKivM2a2nxAQKRYTZ3OI2ib/RwdboXga7rTFvrn3lYSn4u+xDo
84Tx0lSK8dU7LSGRBMlrI1pTOoVnjLdPpIygWT6jH2b3X3r7nBgJwet7UV9L
NRT7+6OH6i4SXPhOViYK2fM0KbEfCwlS+zLKFys4F9nKDOIazksxwYladn5D
U7wF0SWCfq0puOAxhd58UthxjsCmisoxd1G0dTVOJMrZ94bON/D7KJyuLZSP
iTmfvZne8ETE+VP6hvPYJoMBH6df0nYKm9Wxe3ScQbvRbUx6lwK+zp97Gxko
A6qOiHModlmSjcJYtg8p4jSzmXNebUV0fAdnw6DArmbvUz8p6HwYx+BWwtUx
Mds3/qwoqvcUg8tNZfJ4C4VL/fJkQgKDNpe8jMBB9n9KdX56hkFokcTxxUuK
EuuKNjObwb/9/Q23dUVs
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EYhuehNPNAVpqVp5EzSvNYWJ5uQ5HU0QGHKN/3Zrb3FU3NSs1Z
UkRGB5XMbJbkIcxBQaBmWBbJFNMhpJYUqc1wYvNAKyN1tmq/HPTj+nHB8+N+
7ufxTDt5hFoIBAIzIzuMmBv5udg6kqyl2JT68nRNH4fklhszVlMUl0UVdw4M
cnBsVuTE6CjK/OYvOo1zKBY7dYsWKKreStInZjm0fmKNqmWKzLog+6ZFDnsS
AmOlAoYPwvdDcxY86iShqkJLhg2VHYvd63gMt3uNHrRmcNNpL+wU8nit0hsM
9gz01V+fDPBwyIo6VubIMNXkf1yTafLw1EgIG0ze3WXVPjDEQ+QcMl7owOA4
1vok6jePML++UvkahvIJcd01V4LV/Z+LOlcxBDfbTNoHENxXDi88NmNYG/HU
5wQINh+2kTgaKNR2t975JhBoup7n5SxSiCsCq/OTCCqpIjfmO4VOnFT/hpKV
fvSPSrx3FRBEWVVlbZ2mYKdS4keLCWQGzaFOY1++3hGq2nwC/8jdQdJfFMrU
jCZdNkGCtGv+kp5im9uoepARtGX3F8j/ULg3RtfWHiUIUctdAiwYWvJyC3QS
go6ivutyY19ns68musQR7A/rqZevZxB8KXlo6U/Qm8lrVFsYhK6ycyMbCWj0
TJPWgyE6eu90/DIPczdZhrXIOB/8bUwxzmPAplMl385wZdqjfElp8o/nzdIU
D0w+qZUq49J5ONs2xqa4M9y8K9HaBvGImL3tG2DHcKYyrcLWynTPocjwshd6
Dm4Nob2FxvzVpZ7WxTpuZb8emYN54lcO8ft4r2dLFKKJttoaNQf9SJxn2Q+K
Ob97LmSYw///+A9aXi+I
       "]]}},
    AspectRatio->Automatic,
    ImageSize->{303., 166.},
    PlotRange->{{0., 303.}, {0., 166.}}]}],
  SequenceForm[
   $CellContext`Dia["A", "A", 2, 2], ": ", 
   Graphics[{
     Thickness[0.0033003300330033004`], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 166.}, {
        303.367, 166.}, {303.367, 0.10899999999998045`}, {0., 
        0.10899999999998045`}}}]}, 
      FaceForm[
       RGBColor[1., 1., 1., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
        24.617000000000004`}, {45.02, 13.289}, {35.836, 
        4.1049999999999995`}, {24.508, 4.1049999999999995`}, {13.176, 
        4.1049999999999995`}, {3.9919999999999995`, 13.289}, {
        3.9919999999999995`, 24.617000000000004`}, {3.9919999999999995`, 
        35.945}, {13.176, 45.129000000000005`}, {24.508, 
        45.129000000000005`}, {35.836, 45.129000000000005`}, {45.02, 
        35.945}, {45.02, 24.617000000000004`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        18.552508993125002`, 24.501156448750002`}, {21.99788154, 
        24.501156448750002`}, {21.99788154, 23.632703813125005`}, {
        18.552508993125002`, 23.632703813125005`}, {18.552508993125002`, 
        24.501156448750002`}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQXZ+egvmK+/bdca4cH
D018voUh+MyN2VWPPpvC+T+6hFlM5pk6NFQwsdk1Wzt8v7NtbWuKqcONs1Pe
x6yzdvB88M7gm7upg4Gy+s3qm9YOxfKfHxzSM3WY4PqEtcjMxiGv+uuFQwqm
DkfWnlladMjG4WNXjPt1GQT/5V5DFobXJg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcNcnpDntv6mDvfPXe8/qGDl4MMpk3I229RB
8DZbc6qllcOy9tsNh3ch+FuXJWh5mpjB+Xw//TIDemzg/OwF1jtl/9s48G26
6d8nauXwIfZ/6wMTWweOhPqX989awvkh+3fGBCxG8C8wfuvvzbV0kHNkdFur
aetQpW7SPF3H0uGNyaUgTkFbh0Wv08OsNS0dClwsT8ry2jr47mda8FnR0mEG
R+6cg5y2DgrhF/f4i1s6yEhcEbrGautwRiuHjUPA0sHlDvuzSiZbh+Nted/Y
mSzh7vuWWbDtyjcLB7GSa0zXvtvAw29Ws23lq882Du65Kyxdb1k4vOJeKm/0
1sZBirU8bOF5C4dcaZ5pbi8R/LlrstYcFLd1QE8vAOyw+t4=
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{107.836,
         56.074}, {107.836, 46.719}, {100.25, 39.133}, {90.895, 39.133}, {
        81.539, 39.133}, {73.953, 46.719}, {73.953, 56.074}, {73.953, 
        65.43400000000001}, {81.539, 73.016}, {90.895, 73.016}, {100.25, 
        73.016}, {107.836, 65.43400000000001}, {107.836, 56.074}}}, 
        CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4kscerbv94Y5qGmY/J/30s+B/aeOoM2RMIc/
ExlVfj9F8HsfylgXbvGC8zueffg/s9PLQW7tUaa+k2EO7f2HrhzK8XIocdLa
G3olzMFgYpxYdZyXw6nrfeWy98Mcjm5IyHsY6OWQpLCPKfpbmMOhe4lpD728
HPKtdmhFS4Y7tKRNXfjaA8FnAAEDL4eqAw9XfVYKw+DD1NtyOIuGOiLM+6x8
s443DGGf6fXF/s1JYQ5R6hM/yiV5OWxlsn76riDMYaPq1/VpBV4Oh46yPRIv
D3O4/yRk38PpCH5aifjkJVcQ/Elz+4xWMPjB+Y4fW27xWfk5NFZbiyrlhTkw
X3jm8CHEz4Hh+ZJqsxgE/3Jd8YxJgQh+Ub/TU0WXMIfZB58vCPP3c7gjIZT0
xDjMock6YDmLs5/DM877YbxAvsvh5kd8jn4OF/e5ZlobhjmEL5U9k2Dv53As
pbJgkl6Yg5RuIHu2rZ/DRskHTQd0whx0+V9/2GPt57B+w4M6B02E+6o1H64r
VgtzEI8O+p9l5gcPv5uPWq1KTfwcArTWn/eXB4bv8p28koZ+Di4XHl1bJgMM
T723Hsr6CH5UucyVBDc/B/T0AgA2dvY8
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{43.352, 33.547}, {50.469, 36.918}, {
        58.676, 40.809}, {66.242, 44.395}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.824, 47.594}, {75.363, 
        48.715}, {67.824, 41.27}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.0033003300330033004`]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQbV0y+80zCz8HVY4/bWm3XRxgfEmnc7//n3Bx+CkZ
qXXM2BeDD1N//dOM3aF+vg6fFpR5x9xxcag9EMp4O9HXIcqx4VTBPReH7cWF
bRI5vg7fpfh6+x+7OHxU6+UOK/N1mPJltv+6Fy4OfQzS50qqfR0Y+G0Fvn1E
8K9+9pWT/4fgr2n4nlrN6+rQ2dbc41ji69DebvGeS8XVQWrW48M/03wdzq+Q
snzk7OqQavLrFa+tr0PJ+YUrtZa6Orz+MWv1ekMfOH/WTmWBpUw+Dl8W3lwf
pOvqkHSDbXL6H28HWVGDjG+yrg6685v8Y396O6zTmDB/nQCCfyv3aXwQK4Kf
2CsmsuSli8M1O7u5jwR84OER9dSq5LsdJh8WfratUr22Jd4YfJj6Rp3UqQ97
vOHhGdXN+9R2gbdD/G5xniVPXRymPTu4eN1ab4e5L05dEvnu4sB6OTHn2y5v
h5XrfsRWc7o6rCuS3VV9ydvh99v8n60Wrg6HdapOeHz2djjKu+2BXTMwvBy2
mTic8HEoTJ4kqlLl7hBtn8G88S6Cb6y+yG7vHV+HY1teb602dXUoDAll1Xvn
6+DW0aYwi8/VodqjpWPKH18H5ofWEt++ujhs+T2f9xKbn0Oy6Xrf629cHN6t
2z2JX9DPQatp8omZj1wcJl25Py9R0Q/uH/T0BgBd1yCG
         "], {{
         56.516927460000005`, 43.61787444875001}, {58.371984037500006`, 
         43.61787444875001}, {57.44445574875001, 45.82669181562501}, {
         56.516927460000005`, 43.61787444875001}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1HEAx+9hq27zMFN2WkaURXVZF87D6Yvf3Z/G/4ekVq5aGFJYnnOt
SKTi8li4Hlg2NvMwEpVMKlqdxbIMmae2bKJJrkS6V2frxefF5+X3YfuZuKAI
PofD4eqw18HTsZIUsqgtoBjiq4slSgZRt7UtBysoeCkLfqPnGFwtyanxTaaw
XjLPNKcMhmw0Qa+OU5i0Bj++7Mhgbe5G/wEfiiizsshlCwY/dinkfY4UecbH
xs5uZED5Lq7KnRQNTkL/kVk5UpNVC5ZmFOXKZx5G7+XQiNxiIv+wMJhUTReq
5CiotRqz+8Zik7EoVe267l3FGXyeRqb3Fs130+poGfavyibTf7MQVty17TaT
YUTNdeCaUFjlh8vEHwmE1ts6PCwpYpfTEpl6gtzW4M72fRRd47Zf8lUEJcrM
Q1ZeFELPmDuCVIJKr8bB7GCKuMoG36zTBBnd1x/6XqAIbQ/0fuJN9P1sjhXs
NrUhKB70S5pSUUgnTk21mhJ8DSu0PJlIMbEha37TDgJDRWBpn4KirWivc4SY
QN0rLD7sT/EyJ/TpO0+CX1WLOVwpxV+DFEYQQDA7+mal3J7i0bA4Lz+MYCyW
I+FuofC/OD9smk7QFWU4zplh4V60KJE2ENTVN/aLe1lotxrlqaYIXHzSetqa
WVxxq6r+JJTh9YRnh/QBC0Go0wtLVoabIlsJp4TFytyAQpm77rdOrHZq3657
QobTWiPkiLcrJUvtLCysjzTtqZVjoGagrpyn+8M9ejSEy+j3LBu8Ft1vziBo
0NlLaUdh4N6R4Cdi9PkuffiZ1OPB4H58kyY7gOL5ao27JIDB9MzyZ/vzFA7h
4/LmcAb///EfbsQhXQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVj1yvErqwIcZlRH3BKvdnO4em7GjLxjAQ7V5/TX
3prj5lC0Qi269zQmPzR3989mCxc4XySPU1tY2cXhlofBrYVnAxy4q24tXyPi
4uAcZBm77WKAg2X6iYXNPC4Orvys//yvBjiYvDVICGB1cXi6NC6R416Ag37x
TDnZf84O7UnNmVFvAhyOMkyczvEDwQ8T+XjuwCtnhxyJn75/izD5vyxFbwv9
dnaouKd2M7kVYZ6Ukc/drRMDHNJCts2OYnFxeHU77v696QEOC9gvKczgc3F4
x6jVUjE3wOHWrrdLr0q4OHQV7XCaviDAYYvktK+GOgj+z0n3Wa95IPjl7sVK
hVyuDu7yVtd7OoHhcfxFh+11Fwez7hW5kXkBDkIK8xpm7nNxCPs6x9ogAMF/
cHHmBGkLBH+B9fOjq1QCHIK/vmywvezicHKdbZ2faICD1aGIqcZ/XBwi8y5K
5LIFOCj2H1+pqerqcNv/58vav/4OAivOsAdHIvhWMm0qb2ch+HNnH+qZ+NjV
4eu9+OvdnMDwTH+c/0PRzcHsnuCyP3IBDpL+n13MQtwcVs0Q9RU0Bdp3vvZe
ZrubQ0dh6L0F/gEOtWUnnvEucHMwv1/C9TkfwXdeumhqZBOC32wdmnBqaoDD
HaXFj3ZPdnNAT08AbO8UMw==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3VW0w2n6ggAHS2nlA988XR1g/ENTn6T/kHWD8zus
J/PWJbo5PEs8Pnf1hACHrL6sBw7Nbg4Xf5vpVBQi+IcrbBkqohH819OPSzd5
BTj8PH+a/2ehm8Pj7ymmW20DHGpKU5vE/d0cbocz+b8wCHD4L/X/i6mOm0Ph
05/HL2sFODxw4p1q+scVzg9a8dBq134EvyCUK+P7XFcH+0sOmsm6AQ5Rs9dG
atW6OvBrtPd9MgxwWNsYdaowztXBdev1vGlmAQ5nGZr+r3NwdahZrR5sBbR/
X0ZojoeWq4OMU+O2T64BDltL1F4+lHZ1CPs6x9ogIMChpLREqpDN1eHoQxuW
itgAB6tDEVON/7g4nLfL7r6Xi+Dfmj1TyLUOwa+N2Cc1vSfAwZHv/b00dleH
Ny5xj+/NDHBo4l249rqMq4PSpXWHm+YFOLS3W7znUkGEd5zII7N0YwQfFh8A
cmy5Tw==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcx91dFFJujrjWUtf8OVLKzPn7xu9+P2Hc97pOXBJ2Z0aHyqz8
6cb6o5Uu0tyw2kS1ZCaTG7f+YFlR1gOyswrtanabks5WSvfIbT14PXhtnyfv
9/uzK6dIquTY2dmxrAitsK38PS808iwSRM1mzfe5URhdmv5V/F0CntoxwE1A
Ifwbl2XmEPhqxtc6QcHVf/FhF5cg7Fn9GJ1BoSJeW2jhE8xmpfDHSihU+/j2
+O8hGFRdb1NcpiATifqlgQQhzPFFx7sUnq65zNiFECSyBv5MDlNoFPTvzIwl
mGo2pUlZYhxUiU3lCQRGdcJwgtzml2aVVcMvbN5433Jylw+NnMEDn6VxBMHG
FAXnLI06syxKG0rg97U6smGAhsBH4zUXRFBas/qydY6GxE3tpvch2N2amiZn
MUjaPzV+YQfB60jndqMngw/uoS7RPIJ78clBBfsYRKRz7c32BObBxuitycx6
P+yypeSZQgZNLeZV3YoE7zktN8MqGGysvToyu4Egryi33lDAoHTz3iv+rgQ3
5vSJ2ccYdMkPOed5EsgybxsEKQw0+Qqu1psgKb843BDD4GLyknzIn+CU0+jC
iUAG12qOiLTWvlZ/r3T08Bg0O6QqtYkELvNLCbWfaLTnVpotGQRSxfRyaCeN
jx66khAlwa0H6e+2ldHwetVrKSmy3teO6N/G0uhri9NrzxDwLX780w42N/AX
nr8ZEa/75HJ3tXuqGFSH02P3HIJAWf2EzkShQWWuGooi+MF0euvqbHt238n2
/FlK4fCEqFcqJIgMF245l02t52viObD9CIVH7Er1uAdBxhdpxJMYCk70UVX5
JgKTZntwZACF///xH7xBGWM=
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{299.371,
         141.49200000000002`}, {299.371, 130.164}, {290.188, 120.98}, {
        278.85900000000004`, 120.98}, {267.53099999999995`, 120.98}, {258.348,
         130.164}, {258.348, 141.49200000000002`}, {258.348, 152.824}, {
        267.53099999999995`, 162.008}, {278.85900000000004`, 162.008}, {
        290.188, 162.008}, {299.371, 152.824}, {299.371, 
        141.49200000000002`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        272.904071993125, 141.37615644875}, {276.34944454, 141.37615644875}, {
        276.34944454, 140.507703813125}, {272.904071993125, 
        140.507703813125}, {272.904071993125, 141.37615644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4htRbu0vDhc65H6pXuNWluiw/8q63mnbCx32
mrcxJFgmOlzw79pZkYDJj0hpzXGzS3TQO70tPKyj0OHAUoG21MmJDlt7NudO
m13oEPfbRlV5T6JDxduNFWZLCx1q5mQeUniM4Pc9PplWyp4E57O1T+a2kEpy
SGXxOe63CKj+YOyaKs0kB3ujhpT6OYUOsX/6YrVNkxzOT3nOvXxaocPKBWrK
pxySHO45+W/k6y90OF/0qXWmW5LDtMxX2rdaEfy5HTskmOsQ/E3JbVb7ywsd
9r3eLzDHKcnhyq/giXzFhQ4/NPpOClolOaw5FvIpJK/QwSgtpqndMMnhXKyS
55LMQofAQ9pnw5SSHNbu2JOkmVrooCVw8lI0T5JDr3B4zTpgeOx69Nt1Jl+S
w4rusGdXkgsdmt4d1jivleTQ9qWjvzWj0GFKaK/pD7skh0LJ3bkngeZ/ddn3
IsMnyeGNgMJ+L6B72r63f74Yl+TgtKylUqip0OGYY/CB4+lJDnPYZEpc+hF8
o7IG/TezEPy/qRKfTy0pdOhWeZevlpDk8M3Ni23RmkIH0VfK5x8HAP3z2uPO
ui2FDsZunyU3OyY5eFVVt9TvKHRQ55nQeU8PwWeI0u1/LIHgC9XM9Lz3LdHB
5a6njej6QofWtfPl5S4lOuyV9lW7CozfxPs8bGdWJjosWd7GqlNW6LBaVMot
NTrRQTPV69K71Qg+f6yYyb0NCP579RrJSqB7Njg1HNoZk+hgs6/a/822Qgc3
J8lN3gmJDpMei9jN2wk0f5eETFFyokOW/MOsX3sKHcTjxT/VZSc6HC18cJXh
YKHD32Pr5FsqEh3Q0y8A/fZGhw==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{182.707,
         52.992000000000004`}, {182.707, 43.637}, {175.125, 
        36.050999999999995`}, {165.766, 36.050999999999995`}, {156.41, 
        36.050999999999995`}, {148.824, 43.637}, {148.824, 
        52.992000000000004`}, {148.824, 62.348}, {156.41, 
        69.93400000000001}, {165.766, 69.93400000000001}, {175.125, 
        69.93400000000001}, {182.707, 62.348}, {182.707, 
        52.992000000000004`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{
         0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{168.35886490874998`, 
         52.52615034875001}, {168.35886490874998`, 51.629259717500005`}, {
         166.94571527999997`, 51.629259717500005`}, {166.94571527999997`, 
         49.29296900000001}, {165.85194621749997`, 49.29296900000001}, {
         165.85194621749997`, 51.629259717500005`}, {161.91875266874996`, 
         51.629259717500005`}, {161.91875266874996`, 52.52615034875001}, {
         166.32882952874996`, 58.74313370000001}, {166.94571527999997`, 
         58.74313370000001}, {166.94571527999997`, 52.52615034875001}, {
         168.35886490874998`, 52.52615034875001}}, {{165.85194621749997`, 
         52.52615034875001}, {165.85194621749997`, 57.32779653312501}, {
         162.47876242874997`, 52.52615034875001}, {165.85194621749997`, 
         52.52615034875001}}}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{107.887, 55.375}, {116.91400000000002`, 
        55.004}, {128.23399999999998`, 54.539}, {138.465, 54.117}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{138.738, 57.609}, {148.586, 
        53.699000000000005`}, {138.44899999999998`, 50.613}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4huWZ5kce2MdTBcdTQ746ekA47c9uDkr5bqn
w/adTpm8UZj8E5dPtkzd5AHnb5bMLTsx0cNBPsrnhWJMrANX1UYN5yoPh47k
0GyzhFgHxrampXeyPRw+5sS980qJdTjCkCExP9bDQSN53aV3WbEOvfLesxPD
PRx+n+wp3ViC4JvWrvj1rg7Bzzc4Uq/TGeuQeOvrrb1JHg5O0xcpvZ8U63BD
SOetRbWHw4Ob+i95Z8U6XDg2dTFrAUL9o7UTXO9YI8xn+b+tSVLJw6F1Weep
OTEI/o0eM+sntgj+ueYrAeL6sQ7BOfpiKr4I/v77sxj1lyD4sPAJW8zKmimM
4CtdbjgaJxTr8K7hsWTlTU+Hd0x/WkMEYx2Ud6XHNt9B8LuiCu9Mv4fgH7Lu
i7z6xNOhq7jLpVgk1uGnm+DS+689HaJl57rNkYp1+HdgxTOhz54OR9SWndwg
F+uQlrgpVf2rp8NvmW9rQ1RjHXLXeqyPYvByYGTo/dyuF+tQLc1f8kXUy+FK
WvY0L4tYhz1SB51Stb0cHKfZ7/vhGOvw/yC3N6eLl4PIX9nE3d6xDhWLbk3b
Hu/lsPHaauVbAbEOz/qq4v/neDk84zdIfxIc66DgNO2JTbmXw9Y/ZSeKw2Id
urfMyw6s9XJofrlXkzkSwYelj3e3BFYaVSD4Mif+LeIsQPDR0x+MDwC/QCqd

        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx4+LIlEXGmMcq9QSMoTl3svy/d0PXbXKPPy+1JJS0q552O0u
lBKax+Up0zIlZuWc5qmWjFg7k5KxPDScJg/LaAuh+4utP15/vP77vN/vj/Bi
7JlIPo/H09FyUIuuFk/+alSpC8XHsfqCxlEWsTmBDNwpFs9tl4R9YrGaZ3a8
w57C9OuR1OI6FvtDjhbqmlPwH8U0rBexaBEV9jcbUYT8Vl6VpbB4HcbLTeNT
JM3d/P4zmsWYeC6DrnB4auYiCT3FIuGuRVTtAoeHoX3IcmJRHh5rf3aSw1rr
i0nBghh867Ewt1EOy7N+MquyTVfdKtG747zpz2sMzPd2M+j7sEiphoOhTOng
K2NQVfBZTzjPQRCjICoPBmQwXC36wyFiMC++cxeDJHt5oIJHoXon+mG8QHBP
f3d+rQGFoW1qcfo3gsypqoFxAcWF5C7/Le0EKwfMfTqEFCeLok94VJKNfvQD
7Rzz7xPouSY65DlTOLUmatwTCJyWSxQ9dhRfNKXzD9II2uKXG9P2UFRL/Tw1
BQTph0Y8WBOK+stxb/yfETRYqF2EWyl+TWeL01UESne3mdlVDgVNAdnGnQTV
670GQm1fouBtw/kjBKXygWHbYQ6HpTu83woY5NpUn29Wc5ha2pdtQhgEXc/q
lbdxkFq2VAbJGVg3SQNEjRxWvCStT5QMUkYn0m1VHOa6p8P/zmz6bS/ztgRH
8YZHRkh0XCrEWBiyynncwcFE54aqxohFhZV3++wUB1P5leD+S5t7ZtaXXTut
YDFRN5tFtfevWfbHqXPZjXyxr4wTSTmLjOTqvvGdFC+H3vs0qlg4HusZcrOh
sPNdYly7WPz/j/8ATqosnQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        121.73520055712497`, 50.39521844874999}, {123.70401060399998`, 
        50.39521844874999}, {123.70401060399998`, 49.89895331312499}, {
        121.73520055712497`, 49.89895331312499}, {121.73520055712497`, 
        50.39521844874999}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4vzpgvPDVOIdHA8p1BWs8nKA8SX8Tx09s9PL
wV9X9mK9U7yDkvNPD+MTXg6JB9dZbY6Nd/hxftGE/uteDgVrl2dtLo13OB/j
c+P1My+HG74bXx4vj3dI3+MUef0Jgs//xSOrrNEDzp8mXCV3ItXDYbnVD6/w
qniHbl+fyYnBHg53j3to/66Ld9hhZdVr4e3hsFa2f0JXc7yDj8LMMx8cPRye
XVgleqI33mG9GzfXJRsPh4+6N+fozYt3cF/G2L3XCsHnVnz+t17Hw4Fry+UD
t1Ux+TD17r27Xm0yjXeovd967rith4PfEdmz9Q7xDlsOLPJmdfFweD13df88
13iH4Bx9MRVfD4fdnz9+0fWKdzjQduFadpiHQ+cDi7C9PvEOZ3z+JV7KQPBd
dM+ubWhB8Leof1X+musF52uZHU1f3Orl8P5wmYmFd7zDueiXxV+nejns7Pr0
Qdcj3sGqrMvEdr4X3H6ezjlWacu9HKS+zOgttY93WJmk9bdljZeDx8O2dh9z
BH9NwY8TuiYIPv/0LDZ+fWD4R892Slvt5VAYctf+gzpmfMP4ABZi770=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYifWxIC/8gkOpx5tmbbjvpfD4cfHFE4pJjgk
O60WX3IXwV90c/lKvQoPOF9nYeH0zfEeDrEMnU7+ygkOu3ksp1r4ezi4hU46
nKyW4PDyp1o/v7uHg96q2S4VmgkOT+r7fe/YezikLXitIWOQ4PBo7QTXO9Ye
DjlrX9jIWCU4uC9j7N5rheBzKz7/W6/j4VBbNWVy1vN4DD5MfWiB7f1jP+Lh
5p3YPYnBnwlhn3jszeR7rAkOgbMM+FQ8PRyMm9JV/nImOCivdRLxDfRwYHT1
2L6fO8Hh3+bmuXfSEfx186+aTO1C8G+f8LkyI8oLzv/QtPJRarWXg3EEY5gB
0Lzj/MFah7q8HKbVFU8WZEHwE13f+7MzIvhhRzhrEn7FOxxJ3/Whr93L4dXK
jN0SH+MdemPMl7Y0eDk0x2rfnPsh3uFTyIpXqfVeDv69y2ZOfh/voLpHV62g
zstha8GTcr538Q7dW+ZlB9Z6OTQuiLdgeRvvsFdaZXl0jZdDvXmCCcvreLj7
6h5Pnp71Mt6h49H85MBKL3j4vbslsNKowstB9FaXSNjTeIfgldIK7mVeDtV7
T3y68DjeYefCnlSNUgRfo09Hr6DJywE9vQAA5aP9sw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{133.159548989125, 50.63522576874999}, {133.159548989125, 
        52.38777921999999}, {133.68831511599998`, 52.38777921999999}, {
        133.68831511599998`, 50.63522576874999}, {135.439618529125, 
        50.63522576874999}, {135.439618529125, 50.098959413124994`}, {
        133.68831511599998`, 50.098959413124994`}, {133.68831511599998`, 
        48.34765599999999}, {133.159548989125, 48.34765599999999}, {
        133.159548989125, 50.098959413124994`}, {131.40824557599998`, 
        50.098959413124994`}, {131.40824557599998`, 50.63522576874999}, {
        133.159548989125, 50.63522576874999}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHSLbfaEmM9GhK6rwzvR7ng53C9/u8CxPdMhd67E+
isHLYU2cidTNSky+u8+V38xz3OF8Nl8l3clt7g4P9HZGPq5KdPgb8XmlToW7
w5TNtrPf1iQ6aLs9XMxc4O4gOmlx9q66RAe1M55JFzLcHVJjA+aKNSc6KAZt
Upib6O6wbXfSQvuuRIft91fO7IhG8D0+c1508HN3WDltrvBEX0z+Gwm9u5Pi
3B3WV5pEHglDmNeg7B79NibRIcL4/Nxb6e4OGRUBdxgTEh0mPXulJFHk7pDF
vW3duaREhzMz2VaE1rg77HD+yxuXkuiw7Me67xv7EfzXhT/Yw9Yg+JlqPSof
cz0cxKTsbtyIAIbHMsbuvVYeDnwBpcr23okOLP+3NUkqeTjIteZ3adkg+Mmf
35ooGCD4ziumnE9XS3RwvcLUvNfMw+H6w/2rd8olOugsLJy+Od7DYf5Bzp8e
4okOwnkPVq/s8HDIipN/Xiic6MDU/pTz8h4EX+f3PLXcfwh+f9XtPkF3T4e3
PwMibkgAw9PtT2FFq6dD38+V+ycoJzpw6/G4b9vu6XDimrbwbD2g/nXTHrx8
5elgfvj07UfWiQ75oQ9f9DJ7OfBV3f7I7YPgi8QWmduHIvgmK07P+R6X6HCO
cc8T6++eDujpCQBdrwlF
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvcP5L29cSqKD9i/rQ2VrPRxg/C0lfzMrGj3h/Cqp
Nfz/jng6pO1usc6ISXSIyW1+dOCZp0N0x56mcz4I/pVj+3POOSL4GddaqoIt
Ex1er3siWHnV0yGlLZj9rVGiQ15IXcv0TZ4OCWZKU9p0Eh0+/hT/vrXf00H7
79yAGs1Eh0uKatO3xiP4Lu2/bKyUEfwkE+WsckZPh0nFjoxHtBIdfKqORa96
4OFQNe/JZm7dRIf5CcVnPh70cBB9yrMkVj/RYf/9WYz6SzwcDB+YTFsPtH+D
e17eiV4Ph8bVD49zmyc6LA+2f51Y7+Eg15rfpWWT6JAW0ivzMdPDIbR6f945
p0QHnYWF0zfHezjcWhm2idEbwU+48farSTCCv9GM4VdsVKKD8Vv2h8+yPBxe
6gTcY0xMdCh5s3N9eIOHQ0txxbng5ESHyrTAj13tiPAO+PzL4vk0BB8WHwAp
gbxr
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx/1opbSomHDHop0YRZpW7uxdOd+7D45lNS5mH2OnmTTN/JjK
dhYXF6tII3LISTvLzs/cjuJyRI3042pOmjZpbWFaadP3r7P1x+uP1/b887ye
Z39K1pk0WysrK2sWPxYblmwSYuJUUBwezFsIyWXwznbXt7Fyiq3RXgG3rzOo
tPHLtKumcE3+ah3QzGC9vubZYh2FX0P7pEHHIMh/UaVspJgOk3GiZhho72uF
Pg8pNEJ1y8clBtxW3WjoIwoeL/enYpsIcTvUpj0aCv7c9Ma5gyIIOFf+Dmop
jAUbCVOpIih1z5NjeykmoqlhtG/T8wevFoXzxBYvKXG41KgQozm9fza0i8K7
X5Yk/yRGf1FkmbSDwu1FbdheT4JiLs2Xt1PIUpzHuBEE7k7xaxdbKZwK0xPe
phLUqMrjZlQUOvcDrecLCVKc+ZeD6inueaUFLt0i2N3jm2V3l2K2VoOKDmLp
s3rWPibxNYE+3iXDzPYbm9dW95oJfklkMXK2V4Kk8I7gFYGmsifIh+0lH5qK
+qwnGOsSLgsfUETwe/VNTwiC9ZIcaTOFQKTgC5oIugPd9q2qKVIX577PVRAc
fxmpkLK9fpgc247kEQwqRQ3SPoqNIfvI7eEEEQPmeeUQRfiJ5bVuB4IvVZkt
jw0UpaXZb+6axCjKWpeNj7PzstmnMS1iSBJPGaWTFDtnTnJWLmx6x2+bYYnv
po9OG4urOkWoSuJFcEcoPILbp1yJCAMCF//VTooF3oiX6zJjuafqWoFbzgcG
dcs6Q2gbxSHX045/hhnLfjdWPLaotQyMZWbv/AaKKEOG4FgTg7yACc/YGor3
yUeDB24y+P8f/wEMiDDy
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        153.35200000000003`, 115.695}, {153.35200000000003`, 106.34}, {
        145.766, 98.754}, {136.41, 98.754}, {127.051, 98.754}, {
        119.46900000000001`, 106.34}, {119.46900000000001`, 115.695}, {
        119.46900000000001`, 125.05499999999999`}, {127.051, 132.637}, {
        136.41, 132.637}, {145.766, 132.637}, {153.35200000000003`, 
        125.05499999999999`}, {153.35200000000003`, 115.695}}}, 
        CurveClosed -> {0}], 
       FilledCurve[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
        
        "], CompressedData["
1:eJxd1Gk01mkYBvAXiYw1ZSmSeJkSIWKocSGa1OhIc8byf17PQ6oTqaRo0Cpb
ymnKSYs1S8soWzHDGRl5iWmoVIppwcRQSYQo5v3C/5z5cH/4fXmW+1zn0vff
uTFQRiAQSEmGSEZaMmbZLeP59ylapBy37jQmmLLU9lA3dUsCVVfZotaXFPvs
V3U/WkUwcGiFf8IbioIz9lXZawiWpl8oXjJEMdL08FD1BoIOp/PxNp8ptJ/b
BlX+SKDk9OdWXxmGwCPN5r4BBL//urlaXYFBvFuqq3EXQfpQSuiduQxx3QGu
pvEEcB/3mZzPsGnhz7llubzX93948Y+Yt6H2u+XnOgn0rqSExWgyVDLdqsdj
BAFPzBcZKDOsGi7x+kNRBIMTgT+YyjJUJbp9KFggQl3D+QVqnygEj+ZWXTIW
gV6X6V/Xy/t9ZkYDaee9eG/IQc9miufiwpbLeiI8fDGr9ngtxbak18u3qIoQ
7ZarcOc3igEPndMGUiK4DuRZjhRS2N2LFfb1EAzHXx46mk/hNCHsq6wjcFFT
vdCYSbHjjJeYNhK893WKWJZHITzy1ka7myAp3rFr7jWKtrSjWffHCSzylFyE
NygsL3b7aSuI8Ljmaa5VCcXp41rqiZoivA0PPRtbTjH001rxmKEIaf0KA99W
UUDv1fFz5iKkN2XFb2+iUPZS6TNwFyFTy9ZQo5Pi5NG8Q8mcCE4brXKiPvGe
2t+UfcRjd4R6DLbvHMV1HiJYqPodLjBhyMydbZ9oJ4JmxPD1YluGiSCNCgPJ
/fX9J+WDHBjkZ96M2TuTt+zfcR7pHWTa4ceEFQkNBAXhyemrVzI0+nCuY6UE
nyeHVydZMyxJ9GtQzyaoUxnd5bCMoeR1itAjmUBWzTQ7wZBBR25L+ulIgjkb
7ka2zWFI1pJRnNxCEFu7NGetkeS98zK+L/MieBU38izQkuHSpZCG/d8R6OZy
JnJ2DPoqreYnVxAcOHPiefgahj2zVUsntCX5VzSyNXdnWOnfWegzyE17+Fjf
L0o1vF3vfhQYx3Jo3Vcdvc2ZoaPw7LwXmzhUd5wa6jVluCYI0rQ34yDoEgut
DRgWB7dEb9DhpvP+YMeuKjlliedMPkuV5DOq9StZyHCwaJRadvAjhZFzvlvE
qC/s2m2SorooVJOVvY0GfWHVZBfx+QFvZ6UnHu41vINrQlPEtyjMrcIcskZ8
YbI/v765gGL3AQfFswIOvWbt489yKIrrFZ4mzeJQEeSc05FBoXtF/rCRBu/t
tzLcXIS8b6+bIatkzqH5Vvup0iyKN24rusxt+PNMlkoX5K3kIJvfFih1mYLp
SB0edOKgYabcNiHJc/C+e/svukj2E4Fy/yLe3W6K8y3LeNuUKHjn3qbQt7cu
j17FISFG/kLqPTq9z7FTwVWxbXR6n81tzZHKPRT/6s8q8lbnkDX6V4XjIG9d
OtnaKumfKX96fFftppqkX6TlvAf1OLhEsieeugwLH1iXfvlG8t5UP824rxlq
wixsuzw53BfUBm4zY8gbHY3BHt71JOn87FTeV195doeUcTDpHJ3hvYQhoKnH
y/ghh73fjpmtX8QwrqnVtbmXw43I+u5qbYbiiwUeadIE76K+aCmqSPpqkdrL
InUC6Z7JkGIBQ1ikSvkBXYLqNKvsyhGKq0HKSY0GZPq//+/rKf8HxVeLRg==

        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{126.082, 102.16799999999999`}, {
        120.62899999999999`, 95.027}, {113.809, 86.09}, {107.62499999999999`, 
        77.992}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{110.348, 75.789}, {101.5, 
        69.965}, {104.785, 80.039}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4oRTBxgbf0Q4dMhzmL4QjHCA8TfYTQr4xBDh
YO9lluF7FJMfZNF1tCsvHM53vx1tpxIX7rD8lf3zxOMRDsXcddMTg8IdBL54
ZJWdjnDIm/gsVM873KHyb+DbrvMRDhf8Ivv5XcIdNnxeeFHvWoSDyb1TFz44
hDs0RzWUfLyP4O/lnfNT7xWC//3A9rqcLxEO86wXfJjnFu5wSn2aov6/CIeb
4bsr7wDty8hSfuHLGulwzfDDFSdfhPq4pW9V9YwR5n8423DERy3cgde89uSd
4wh+gqyWlcpKBD9M5IR/+KwIh+kstnyXrBF8332fmsPTEXxY+Nwz/sm8sg7B
X5VccmRebYTDEz7xCX8YIxzKJr9vmVIT4VCvfXNjIzOCv/l37MduFgTfL+fN
+lXsEQ5CLHXOm+sjHF59XHtVnzvC4fHaCa53WiMc3qyrLDvJF+Hgs33miQ+d
EQ4K9f+2XuaPcGhe+3LNlAkRDipLT0blikY4dE5o+HR8ZoSD9h0dWyuFCIeY
73FTuxZHOJy53brkk1aEw0k1470WayMccvVXr3Axj3CY0yuY8HtbhMPK+ZPO
SbtGOFimz1eS2hPh8HDqo037vYHxuEA5TWV/hENdfkHpvYAIB9verOObDwLd
v+LLjhfBEQ7cVRs1nI8g+LD08WT32vDIQAS/etOSKy6+CD56+oPxAc80NAM=

        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxz2cdGvnIf9kzMopdTmRlWzRG224zIr5/b7feZgjV7qc5qk8
RCrF4a71wHpw8QeKTq0Sq7hJ11U0YubhbtUtjSW5UlMqdX+x9cfrj9c/n33e
789nXXJGdKq1hYWFpRmBGSsz3RdMEsM1iiFNcZRrKcH82uCwE/UUB342C2TH
CUr53GAbJcV8R5C2UkZw++Pm6pASitk1hjcaMUHogHx44SiFS8Si/59YgsCZ
OaVORqHWJmS1iQgOjRvLVRKKoLHO5vRAgr9OPIkpkcKvUMm3FRIITMnuF/dR
fGrNy31hR1ChHo7LEVFIteGImmCXPKzsq02Jetm7PQSKwQIW8exUgmovRdaq
ohpxNAtfz2cccbx5X85Eo7Mvi/60mN7iFAq3R7IuvhsL2/sZkZ1S8zxvba7O
jgWvZsV5UzZFZuJkP8eahVN+7Qi/iEKl4G4KmWdw6iE30KaK4tKV8Qb9FLPU
jyn7weXyUQZVPVLPwasUpa3GHP0Ag3a5otBeQcF2zxVwxhiIbD+3605S9Jx9
fv3uOwaOna+3y/MpdJZJxg+TDHY1a3zEmRSpu2eaOLMMAnQbp4VpFAEtvSLd
DwZbz2lXis198QpufinnsPDg9RmSwilO296qU5nzON+pjV3wp0ju7Xip28Hi
7e+SgcdCika91Yg0hkVDhGRPMZ9iejryvb2MBffIaFmSG8X+bS5+XRXLrpb6
TPxqWfa6xb5TZJJFQbqDUu9D8T3KEF/tQuCl9u4RxlIcqxzb0hK2fM97N751
TMUQHA41VqkOUszEOQRtSCRL+dY3emlSJASrHVVD/EKKpzvPuLtmELS9eqLP
kVMsztY30TyC///xH1FeMcg=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        103.410981557125, 94.72725044874998}, {105.379791604, 
        94.72725044874998}, {105.379791604, 94.23098531312499}, {
        103.410981557125, 94.23098531312499}, {103.410981557125, 
        94.72725044874998}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4u/qrPOm9Uc59K03darIinCA8X+VcqWpFUU4
XN8rcGH/2iiHf+8XLo+sjHB4GbjI8vOJKIesbWWn2RsjHH7Yzs78/CDK4WqN
9/utHREOCfeWvGB/HOWwcM2x9avbEfzSE54Wv0PD4XzLiCQhFY9wB/3Trz2n
P41yMC49feaDXbhDaoSNlvWrKIdT2Yc871iFO5iua+o/9S7KYcq9wkwLs3CH
vMR5Ihw/oxyOftTiWGkc7lC578zsPM5oh4mKy07MM0LwP9+TYGrQDneY5HJ8
v/TEKAw+TP152XUvPy2IctCxy3ilbBLucC1E8Mz+1VEOx9d9W+FkHu5QrDe/
796GKIfpLLZ8l6zDHZxbnn7O3RrlcHZi77tSh3AHwUKd0L/boxwul6iYrPRE
8Pmfckc1hCP4Ho/kp1r5RMD5TS/ZtwtGRDiUh2QZV2yLcgj5I7nXKiHCwVH6
2fvczVEO3Z1Zc++lRMDt/zKpWOFzRoTDopaenq2rohwO1e9qbMqOcLhQWNXW
swjBN2F8czx3PoI/XT2O1X9WlMPX30Uqn4Hx+/PJBTuDyZjxDeMDAGq+9Mo=

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYu7ZW+dbrY52uLy/3k+mNcKBL6LR4cq6aIf5
73/xCbUg+PbWP8PDA8PhfBb5e+ckXcMdnCeyttzbGO1w+spB3zs24Q7C1hJt
7DuiHZJO7zh13CLc4ckTrQ6DfdEOCXxvNfVMwx2CL54KqDgd7RC39K2qnnG4
Q8LrIxUV96MdJiouOzHPCMH/fE+CqUE73IGVu2PSqiBMPkz9XQbDe2wpCPMk
OCQZ7uUj7NvmtezYn7Joh2mzbbkuWYY7vJ9yyN2qPtrh/xK33me24Q7dUi25
+5uiHXI1ngfqeSL4rnIT5nZFIfi3N3nn9jhFwPlP+au+fAqKcHjn8G3Vgtpo
h8BrfhILoyIctvTeUk0uRvC9pC/N88tF8O+F/K1akBrtENDUVM0eGeFQZBWz
KyIm2mHLnwOhTaERDtzv5G7cjY52eF5R+eNTSITDddlZMy5HRTs06NiIVQD5
tow3yvwiox02r/iy40VwhAOnYbC5S0S0g0/M9mu5QD77iWBjlzCE+9hK2qet
Col22GT/dcuLwAh4+D3ZvTY8Esifm1UnPC0g2kFc2XhyckCEA7Pfno8C/tEO
XvNfm17xR/Abp1pLVYQB3YeWXgAWy/cZ
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx3HI6iSx2ljShVRKmNPIJt/JZdqh5fL//+Sh5bpcDuHI3RDm
Mjk6MpRNbbkNM5EyWTVTVEMrlyMxzWmWdXSZYU3nlbP14vPisz0vvs/3eY6E
JfhFCrS0tLTVWKvRUbMm2CWSehMKOxakijEOL1Kf+o+7E1QpvbUlUxwcUlaD
xDxhI9vkFqfksLP9va5hJEHHPDPG4jcH6XDCECchTK4wo6UtDpmtO4SlNwnu
N9Y/2gh5+AyYGHXnEvIW5jd1TXn0FayIrhUTys4bFsSe5FHRVJM2ICdMCI/Z
tXjxOL1s6TpbTwj4ExhlmaTx1o6IC2HNGrc3tunfO8MjGMYu3dWE3FPTXXkC
huJE0V1VCWHTPvnBG0sGs9arSW75hMYt22++TgzeNT5xphmEtPJp2zYvBvfH
vVZLiQQxPfkU788wWbs/qiGa8OwLX98TyiD6rAoRBxFC7mU91I9n2/1Er7da
S7IZZIffBm5cJHwYzPU1K2TQMogzd2OEOmn4u7ksBknl7sWScIJtZ0WLnZSh
aeZExHAsQRanvWgkYUhfcY5RJRPKf15vnItiyB0b77TIJhx6VZ1uF8JQpH+2
SqXu62t/Ox90mUFeeua56j4h3rat2d2RoUFJHnwH4XZsQ86BgwxTdWkj8j5C
V1XoSpkOg7Gv/NLES/V8/r4FpZJH5/GjxqvDhF9OnrJzIxr3GLWKVLZo3M+p
dKhUwsPFelmY2kP4q8z4LnbmUb48OmkhI8wvFMvFezT3dK0Iq9zQ5iEOMDXo
VufXU3gKB9a47f0cXov05D84PCqiYZsYwh17RaNiiYNgxHFQEUy4kjNo1jDL
4f9//AdRzS1S
        "]]}, 
      Thickness[0.006600660066006601]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{158.512, 68.492}, {155.359, 75.223}, {
        151.586, 83.277}, {148.059, 90.812}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.85500000000002`, 
        89.398}, {143.785, 99.938}, {151.195, 92.367}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
      FaceForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 
         0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1HtQVFUcB3CGHUBxIBMSkKFamHCQyJGUxVHabxCMvBK3c1dencMjiocI
yhqKAgXKwylFllCTBmTkYcAEOLyEVQh5qCAQyUNBqcUpAlJYMcmgNnbgztQf
d37zmTn33vP7nfP7CUNiJGHaWlpaRP38GzO06vykKQzRoa06UikHXZM0q/t7
eTsZDOglU4bcAbNr824ccOtiqWkIg8psrqbEkfdxO26a2fI21Jc4expx2F93
uvCxH8OduPz4e38ThPoHm2e6M2QL6vcIZgl8F+xzLLczPHaTu1cpCbxEOqub
rBkmu17oJY0QDPd2L2Id70EjbVpiyDvfovqIYBVDvY9LmMEoQVdt/wAWKU5M
KGwED/7vs4m75Q4veLf37zxjMEfR0OAcYfCQoMWvaPe9abryvZOhXJTDLxQp
rbPHI4aI5r0xivULFsGNvQTvq6Jd2TDFy6lpr2XcJPB0KLzUdpeiZG3SubhW
3vqiJ3fJNd75sebVxbUEQn+vX4VKigjlrT7taoKwyNynbQsU24zcsp9XEmSp
Ug63ixnspQkztIIgwul5UJOEoWu100vj5WSl3p3KA5EeJQQV3s7RQdEMc8fk
HenfEJj3/byl9DBD4814Zw85Qf23sU/bExmu2LwSmJjGeyQvylgYzztPt8G9
MlR9Hlk9byfLGOiwTqpYwv8v3Stwh9KZ4E8f33MyVwbX+dGeIVuCxGcz+nJL
hsFDTmvOvE6wedTV2HKerlgSrZOePcZ7qW63KQwFpya3vkFQMLyhtvgqRYJ9
iJHyLaLJ6zKF93nUFjkS2Hib6mUXUFhGvPph+Hu8//iis+DGHt4fNeV1Hgwg
sNUfL7G9RCGyOhq1LUx9/r31t4fLKJx011WF7yeaOldTuEyUPrugzn/pnJop
qva5NypTCL6rHEvCDxRpWapFcRbBpws35rU7KawiP2+hXxEcSLWr71GvV13v
sP79PEFMe7CJg4Ku1F9X4ZsjbFDvbzsLF14kiCrIPZhXR9Fxuqi7soj3lumE
aVrGeynWEAx8HJXrcZ1CHCszYy0ExpA0C3sojo0FiB16iCb28fdxg9WEDjdE
NfdykMCy1XNK+Iiu9JdHd2FBWz/FqdGp8ogpPp+c5tTZvDk+/+V+Xd7/qo2N
f5nocxBofalKr6GINwpoYya8U2Izvdo38t601vVrTzGHnR6XZW3qeog2ib/3
/IBDhcr4QfEdikMC6ynLUE7TZw8pPgsicZlxHGzrEmIyVBST1jZnRUc5/Ch1
UBisYSt2cRk4wZnyTr6iKHtTPS9+U9jIRUc4NFoV9Qm2MniPX+g1lXEItFp0
bHqHYf1ezyeyGA6bT47cT9rF8JNFR3nkPg7aM1eT3lX3U0Kiwk4ayWGHj/4n
j/x5L8/H/3p5Pv4D951aCg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQvf1P2Yniu3EOQQfy9pv2hzis3/CgzuFSnEPtnCPV
NxtDHASb2+Q7Tsc5lO/UNVtWEeJwx5PpTu2JOIdb9+cXtxeHOCwXqJtRfDTO
wZZNaGNGXojDsj0bf988HOdg+cCN53wGgn++qfCNQjKC/3vTZNe48BCH1Wae
trxA82NkrB4t9QtxkFJ+yRp6I85h78010u3uIQ5hky9o6zyLc5BfE7TnnEOI
w2+eg1fEf8Q5tKhNnOZpG+Jgm2DvoMQfD+e/FJh8+pY2gj9pg59kgnO8Q3DN
9d83HEMcLt5lfHAhJN4hMj7Pkcc7xKEs/FPHnrR4h2OV/EwhIUD/b3MsTMiP
d5jl+XaFWAKCvyTIf/LjPARfIPdDsDYwPO4n/Oa+mBXv4JHsYHG+LsSB55dM
Jl9ivMPGHM/dj5tCHNjE25Rvh8c7bNYUjaltA7p/Z/icEvd4hy2TRBJqO0Ic
gqTm+L3XR/A5J+xikOBD8H88+6pf9ynOQcZY7v7ErhAH9PgCAGm8yS8=
         
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3fpyrybzgziHGOV/FntsQh1g/INsNuLm1gi+92OL
HCXlUIfdZXxcy5/EOSxl8Nxvxh/q0Hf3zZrMd3EO54rnl9/6H+Lwm+fgFfEf
cQ4/nn3Vr/sQ4jA34dmNTJZ4hx4FRZ4LL0Icit/2KxwTRvA99uYe75BH8P0W
sPDu0Yh3+Kqp1f/kTYhDkNQcv/f68Q5TDjR/mvM1xOFjjKYon3m8Q9rlqT+O
/g1x+Cz5detyq3iHK2Fme3k5Q+H8cuHoo/HiCP7ryknnb2mHOoQ5pH/uMI13
iHtw8maoQ6jDNge+ngta8Q6X3BifXAgJdaj99pFrslK8w93F+tnmqaEOTreu
NYaKxTt4ZLH0P80JdbhokC1RworgT9Ns/jbnZxycP8HtzYbMD3EO9xN+c1/M
CHWICJhz5ujLOAeHUwtXSCSEOihG+bxQfBznkLe9f9H7cET4Gm9Y3iDhg+DD
4gMAX9W+Sw==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx39E4iZKQugyRQ/UjBY211tNXF1/dH1/lOH3ZdMVNnFJD8ZN
cnWtRQ+mZNVRWrOLPD/VdjO3PJ1LK+SZ2aSspmuYWr+/3NYf7z9e+3z+eL8/
n7dHQqo0cQ3DMGa8dvMy5+VQcyVetJ3iTFr0seFZFpol9YkCL4rlV9e9906y
MC7n90rdKVRJLlpJPwtVnPPltM0UuZ31X3I6WBCDrrhnA4VmeSCgrZmFgVsx
+ttSIDPwfMZrFmcjF9KF1hQGVXGFr5qF/8K6+AhLig7fpG26QhYFWll2wB8O
CkrkN+UsfuYMNTj+5vD3omfIerGJh4J6zEM3mph8srh1d5xAu+t7k2iFw9q2
U/c9Ggi6shKrGAveb/3bssEHBFu2VjoUWFFUp4hbpnIJDhwO/qgRUAyNPZEr
5QTNtZaZEfYUlvba7nYZQYiXwWVyE4UfpneYxxBkHFF2S90odkrq1CXHyep9
8rwKi8QhBEtHG0ObPCmcaWt6yX6COxrxt8/8/tf03kvt/HwgZck6wIkiMqjs
cXoYQUt4stjRgSK6Jnj0uYRAKkroYOwoFo268vaTBPruIk+ZDUV3zItwZSyB
xC/xDcPf66lP3rz4HIFqrC/Q7BcHp6b80rhrBDm56upHUxyMWfd0ylKCMH2+
T+wgh6DbI/17GgkEbskVQj2H7FLvcf0HgtRDI9NMJ4fFGeO+7B8mhrtgosWe
XWX/qgqFs4TFxEHHuavDHG4wDacjFSzev3toJ2MoBKJan+RK0z+PROvrXjay
mLVZuCDk/Sts54JntOxqvsYoq1bPLhataQanST5/1DwVDvN9su2bchW4UhQ+
yyp3GWXxfx//AQFaKiI=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        130.09264412112498`, 84.30146844875}, {132.06145416799998`, 
        84.30146844875}, {132.06145416799998`, 83.805203313125}, {
        130.09264412112498`, 83.805203313125}, {130.09264412112498`, 
        84.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYr2/LLWz5yY4KCYK2FucD3WA8XvVnyY9uxbq
IHeCS2zDmgSHiQtrlkjeC3VQn3T5lOeuBIe/6YEnjj8NddDnuPDI81iCQ4ae
2pvSt6EOyTdClEKOJziYxC1ck/0GweeoUjHdvSsEzj/Dacv/ZE2Iwym/H5dm
n0hwOKa27OSGxSEOqVMVDr89leAQKzvXbc78EAffA4dLTc8mOKhP8En7MSvE
4dXMQIuQSwkOEYtZWTNnhDjkn3hR3X4rwUHlcsPRuOkIftuEz//sJ4Q4VHM/
442bh8mHqZequLnIc1mCw/73Ts8fA82bK8wtsmF1gkNUwsWlTHNCHHIYgkrt
1yU4aG0T5560IMQhRPurevuGBIcE54zXpktDHHYvnHHj3MYEhzS1/waZ6xD8
RdOehTnsQfBvTf418deGUDhfdPajzRf3hDrkTd7uzgPkP1/7ZeevI6EOl8u+
qravT3CQs3adNe9kKNz+dhc/2c1nQx1aVnt80QK6L9Rwap3ThVAH6UX2hWLL
EfyzmT8E25ci+P9qNm74vijBoWOtr+JmYPyuv53lmzEfM75hfAC9Svhw
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4h1md2tztRMd0gqjvO+8DHWwFHX2s9JNdDBa
eJX70gsE/9KbyyHi20Lg/OkXdpy+uTLE4bIha8F+vUSHuLY5XnMWhjjsaeP7
eNkw0eFrzeTj7XNDHJbcFi96YZLo8Hn/cbV3M0Mc7lxMD+uxTnT4GHZC6d30
EIdH91KyelwTHVQuNxyNQ+K3Tfj8z35CiMPWPLdy1f8JGHyY+oUvpeZeZkeY
Z/eWT28/L8K+3r7QiX6CiQ6avhLsk+aFOKzc/DgwVzTRYVKYYteyRSEO5WVH
nuiLJzow3Dro924tgn/jfNYsr/0Ifl6KWpbP8lA4v+JgyMdN20MdVnbWNi8Q
SXR40q4pmrg/1IFnw/sDjfwI/vWy7NpyHgR/oXBj9gKORIfHxrEVx/eGOmS3
GXT/YU50cF83O8hpV6iDxQNBqf1AfpVWyNdNO0Md5Cr8f1kC+cL3xIQtgPwL
mXmZ5UyJDm5R57eu2BHqsI1xjecnxkSH+7yTLusC+Wa+a9w/MSDcZ6rsVqkK
5Lt+PL9xxbZQePiV53aESAL5jfMOmkv/S3BYdYV3gvLWUAfjCQ+WRfxNcLgb
cMxoyhYEX8RdTNxid6gDenoBADjYA9g=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        139.84494155712497`, 84.30146844875}, {141.81375160399998`, 
        84.30146844875}, {141.81375160399998`, 83.805203313125}, {
        139.84494155712497`, 83.805203313125}, {139.84494155712497`, 
        84.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4g094v7rriY6KCYK2FucD3WA8XvVnyY9uxbq
sCBc9sWhJ4kOExfWLJG8F+qwUvHZnJhPiQ5/0wNPHH8a6rBx+qMtMf8SHTL0
1N6Uvg11eJqe/iXtf6KDSdzCNdlvEHyOKhXT3btC4PwznLb8T9aEOPjc41q6
jiHJ4ZjaspMbFoc4PFcxnsrAnOQQKzvXbc78EIfz/tfcPViTHNQn+KT9mBXi
kKOZwpXOleQQsZiVNXNGiMPH8N++s4SSHFQuNxyNm47gt034/M9+QojD31k/
7hdcS8Tgw9TPYX9TEnMv0WH/e6fnj4HmyS+WfXbocaJDVMLFpUxzQhze9ae4
Bz1LdNDaJs49aUGIw7Vd7L9mvkh0SHDOeG26NMTB1nD1qocvEx3S1P4bZK5D
8BdNexbmsAfBvzX518RfG0LhfNHZjzZf3BPq8EHplKQ8kP987Zedv46EOoSy
cfyY+TzRQc7adda8k6Fw+9td/GQ3nw11YLOOPmYLdF+o4dQ6pwuhDnMNg5w1
7yP4/j+5nsy8i+A38Bxp4rqd6NCx1ldxMzB+DbNr5auvY8Y3jA8ATCD79w==

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltIk2EcBnArS8NSo5UolKdKpDSlwhPY06xE3Izkey0kbL2pJC6tMCMV
Np1ttghN1Epqms2yZmCec24GW7Ok4TqYhxKTxJSEbS6M0qSvqw/q4rn4Xf2P
/jQ3OWOVk5PTCjYhbFaycSs0dx2rpGj7oAkcG2JwJ73fL66UQl7hWN5fwcB9
493frX7/W9mpvz9azeDy0eF2fhLF7vFDvIAfDBTvLZ/56RQ+Fon56XYC9xrz
Aj+Xwjm1p+RAMufux+e+mwo5/3wUYIi4QTBf2+hsz6aIHB662tRAoFUTP2EG
xfpFidm5hcBSKV1WpVEUffWtEegIpryaR2yEon08t8BmIDA2zKmzEznbM/Is
F/mc613oa0EMxZQieNOpPoJBRcct2z6KDf6JF1QdBII5WZAyjCK2Rzz4UUNQ
JB52hOykyDQaZJJagonKhHCPHRS9lpjbomIC/jNtju3vPnQlv6wygoP5Cg/l
Noq3jpuaEDUBb2FP3HQwBS9+s1ekliCTORzvEU7x7V1fWtUAgbyurrk/mmKX
PtakmiAIchhbvOPZeudTEz/NEnjpBxJCUzhHm6xHpKc5P0yo4L3MoTCNOc0E
ThIUyF1ndZcoyp4I/dsGCaRZdaF2KUVLl3ooRc/Ou1cgEl6hcC2eufamifPJ
66J7reWcJ0SLbm/OsPN752iVBRRGg0u3JZbgbE1euZK9L7a4TWo9CbYGLy1K
oijW6I5X+Xex/3CiwceezzlMNb9UVcRZaJDq2th+6kd9Oh90M0hKmS6XyijW
fgmM0vYyiNBYPavlFOvqraPMcwZi97EAsZK9j0zuW/aKgVXS+GJ1OUWJYb40
a4TBv//7ByRcU08=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE3AUxtUsxdyEbuhDmhJK5px4eZCafoIEOock/392o8bJS1qipiWi
0gUVRyotKUxzmpRWSNg0MV0XNy/kJW+h1iZLl9QsUasHNcz25KCH7+EH34Fz
vu94Unpc4hYbGxtbi3wtsrOoec2tqkZNcJVrLlWHMOxuXX4ibSYUeivvRkkY
3qsFIsVLQpn417U9MQyhsfk3Ut8S7gzzZNNxhnTDIAl7CKm1QcKGBIafssqt
j98RJr0+jC2kM5yKf1CiGSLsquhc6S5gUHbcrKoYJbgvma8eLGfIG5RrIqYI
ia82/FKaGAbSGj1G9YSvDQHnvkxYWSIPh5eAb3K3zqF9JIxj1lWl0ljmd0y3
PIs4z7ESIJbqxwjlJlmtQsGhHYoMtR8mBD93mhPWcJzoPtS22E/YHtbqd6GJ
YyIuY+exXoJRcHtc1M5R1+MRpO4iyJSBlZd1HLHJArGig7Aki6/rG+Wb+aw9
LfLxn+VYd/zjK28hJGWelBrMHCEb0S72Fr/IJ6xfNcPxA9XLjW8IWnlKw9JH
DsekA+peHWG/u8E4OsaRmR4You8jeDyMVKkGOH5/Xp/MHiSoszOuLHVx5OSL
o/SWvHLSSphbG8dfid9ZvYFgM1P0yP4+R+FFXb1wjuC1NzdPf53D88jRRNE8
ITIydF6azPHaw+gTs2jxBy9ON8ZwlDp7K/TLhOL5feWr/laeyrelRqGV58wJ
2uhxhnGB0zbVN8Kte9zsXMuwtrD2PXuCkFVBSucsa59j4ZKyjiSGT/UPijWW
/StLPR0LTrPN+3pzXewYY3A4rDOtagnepheqailD23SzcaSTsCCucjsTwfD/
P/4DtsA+fA==
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        228.21099999999998`, 112.65199999999999`}, {228.21099999999998`, 
        103.29700000000001`}, {220.629, 95.71100000000001}, {
        211.26999999999998`, 95.71100000000001}, {201.914, 
        95.71100000000001}, {194.33200000000002`, 103.29700000000001`}, {
        194.33200000000002`, 112.65199999999999`}, {194.33200000000002`, 
        122.012}, {201.914, 129.594}, {211.26999999999998`, 129.594}, {
        220.629, 129.594}, {228.21099999999998`, 122.012}, {
        228.21099999999998`, 112.65199999999999`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4i1nlfw+7MlySKx8HX52W7RD08HPUT5LshxA
ahhsox0Wb1+1SeBbJgbfIvLf9TNu0Q7x65jfn3bNcmC7I8LN/THaIc/wr5RP
TpaDc3uuZ5tTjMPXTz8NeuqzHOpPHmtunIDgLwlvP6N1E8GfPE9KbMO/GIfz
Cnrn9lQC1QuvDzeVjXVorpnGIZeX5eDQKbhrmkmswyLH1PDcpCyHGxcdXK94
xzocmGuyyCY4y0Gl7AZXcXisg/7rrOmXHRB8O032QlVDBD/j/qItc1WyHJgz
ihUq/GMd1vDaJdlIZzmUP+KflGwX6xC91F7lpGCWw5uYNcz+urEOCy7fupjO
keWgIeo98y1frEN8Jz9r0f9Mh1sbWpd8fxTjIGfvYlEDDI/foa+7ip7HOITo
O/Oc/JPp0J1bHXBPPtaBn3FFnBZblsM6a74sA49Yh2dePNKbhLIcCqQKLggm
xzrctby2d4tylsOkeuZnj9tjHTpT5hu5WGY5iIjMqj8/M9bBRvWc+opgBD+D
Zfq871kI/v/Hx1S31mU5zLt5/l5PV6zDh6VaPsl9WQ4bU6znsufEOsS8V/9R
My/L4Z3MLaNlvrEO03l6PeSWZTlcXSEs9Fcdwe9w8ZNl/xMD56/pUJv0Z3uM
Q/clzR2ek7McJr42sqvJi3Go9TfoOQmMXy9/Xu4bsjEOvumLvcoVsxzu7lbv
5mqMdgh7pPXkTw+Cr3jp0PLb0xD8h+l9RYJA97wQ/dK8uTnaoXZK773vi4D+
EVVLvt4V7aBxf//u6BVZDp6squYqE6MdboRFiIqsz3LY6qf02HZhtEPf77DX
CtuzHJrkAu08dkc7oKdfAJ4DNzw=
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{176.094, 66.531}, {181.54299999999998`, 
        73.67599999999999}, {188.363, 82.617}, {194.54299999999998`, 
        90.723}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{191.824, 92.926}, {200.672, 
        98.754}, {197.39100000000002`, 88.67999999999999}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYCYsPUBw0O3ikOCxOvGbwwCXWA8U82JPh8Ug51
UFCV3rLMEJOfXRVxsGtiCJyfIKtlpdIY4hDydf7nDUYpDj2+PpMTS0McOKtU
THebpDi0X94SqJcX4rD334qyo2YpDi8nqHfzp4c43Px5IUPcKsXBV2HmmQ/J
IQ7Oug67ftgh+A/YztWIuyD4tQ+i7c08Uxy21+a9mZcZ4vBM+PQEcb8Uh08z
O0vvAO0z3Sr4ZVlgisP74n0XnAoQ6suf71bUC0OYzyngf8DHM8ShY/a+lHdG
CP5GPlHZScoIvg7Xk+XaMikOG9y4uS7FIfhpDAfrw7sQfFj4fJj5pzGED8G/
ZmiVdJ43xeFvwNPuPyqhDntOljt5AfkzcpevbVRD8M/Y6rztVkfw09ftWr1K
K9SBi2n/wptA85hNai7q64U6fAo7ofROMMWB7aN70UnDUIflt31SfginOFge
PLPxslGow+FrJWFe4ikOts+nh+VahDq4eTj8fCyd4uAi99vCyjnUYX31eq+j
CikOT2VDFnzyDXVImzwzbo5qikNbYeUSl6hQh/PHODbUaqU4HHqYcEo6I9Rh
3mZ/QV7dFIdf1zes258X6mBxQdB4kl6Kw/SNdoX3ikMd5rttfXxTH+j+V4e2
vCgLdWDfGzFF0RDBh6WPv3+rgyNLEPwpX4ouuBQg+OjpD8YHACkyHuY=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx0933ZlSycx0emTXRrudNEpm7+RhSjS+v9L0IPclUx5ScXoQ
1w2Hynm4MpyTkTRsIktzJ627yC5pPczDyR82lE0rPems319s/fH+4/XH5/N5
f96fz9bYlIg4LofDsWLlxmoFq4kQmWdyNcUXq7ADzo0MrhZrXXpqKLL3ZoqS
tQyeqxRauZpi3cLqZ0UqBlHzDgdrb1NYRzcN6xUMtiW8SLQUUOwqHPC0yBjU
/PhtlOZSGAQ7UjqSGHjNzgWEyymOCosakmIYcAr4nrIsilDdic2CwwwcZB52
/RkU/K/BaX0eDAzvZ5p9LlIoBI6+YYJljunvscoZJEs8HP9LOaQhaHX/Lg5n
64sOhZaevkRQYS+VS66xfoPb7jkRgqn2B5P6bApvi2+Xyz4C3rB3g1nB9kst
TTN6EOQd5IbIlBSF2o5XPBGBTbfps90tis7BD67+Gwj8xxQaeTlFy2hj7cgq
spSPTaeiXLkQCeNEh/10FYVmrvX8yLdIHA8M1gnYvFK5vRm8v5Go5/4ckRZT
jPapK9u4BEpzgjCwiOLTfvHYpA3Blnen7kryKbJyn9bx1hNUS8vm1TcoImYr
goxCAqeXsQoJm5eoO2NWuZ2ghB+fLLlAUR1yuUrD7mP70eRmSaS4YptnMEYT
pC4iwRxHod/4ZuhsOsFb10f1+hgKnlg4vlZFsHL3uQDJSXZexrRY17LMhubF
8QXTMj9B5fUoGwY6r3xj0hmKNaqmKLUfA/WROxPqTAqV6b77w8Tlew7M9LZP
pTN4XDsXFM7652vMe0Q5zNJ+flN/uqRKBgXWr6ftblKMZZFNziUMRuInZn3K
KBx3ptYdq2Lw/z/+A3JhLEY=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4n2P5fpPbUtxWP6R2a6iN9QBxhfecSNRbWqo
w7p1Khr3j6Y4iBsVLI6cE+qwveLtnYrLKQ7NP1yOsy8Jddj/7uWXivspDu/2
Sb7eujrU4fO+PJPmBykOu95NWb16FYLfxyVh8rsiBM4PmmXAp5Id4hBlKvT0
1MMUB5/tM098SAxx+FptdVXmSYrD47UTXO/EhjjcXXa3PeVZisNaBYdUi8gQ
h6qGbK/m1ykO94x/Mq8MC3H4v46pb9vnFIdVySVH5oUi+DyKz//W+4U4cH/6
L9+7HZMPU78q7vOWiv0pDq4NZs+Uw0McdH+pqN0/kuLw4MORJU5RIQ5/nmW3
5x1Pcdjgxs11KS7E4Ykgv9W2kykOzy5HvypNDnHw7tj06u+pFIc32z7pr8xB
8DXUb4U2VCH4CSrvJljlh8L5s7WvbRKsDnX4V3kx0hrIz7V7scOqOdQhOZbf
YtuJFIclpy1m3msPhdvPe9VR5nN3qIPIpCS2KKD7bh/sqG3qC3VY3RHZ7HoA
wY8NEFLZtg/B70s+fUhtT4oDn52jwmdg/NofaomfvgMzvmF8ANhlBSc=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk2EUB/A5setmW5Z3Q41uaCiFmpfmyaxkuDnseWB4ndPT2MSlLE1d
ZWqw5UzBO2G4IoaaCiqrD0pFViSYAxklkYvQLMNFXkpkrHo/9UJ9+H/4wYHD
uYQpL2aiJ4fD8WBylAmXScCMfUOnQ4hX9YQHthHoH5tW5CMCL+yzu0ZKIFhz
/6TN438Lzo3cCyAEDL2O9bwoBGtJvI/SSqA9YjY0/wyCWaGbWpln6p322HwZ
QsPXwdpaAf1rUWLR2pYE1jUJvs8uZ1DgrA6k8iUIj1WTxi8KCpOuHIX6LEKr
STeVqqXgWDKIxpIRuJU+7Y16CqvaUX9+HEKCtrAquo7CzObagiGS9e9xvaBl
P+uhPDVPHYyg8Q/Zc/cqhTnH+CzPD6FzWFTm0FHIOm1SWYQIz8WK6SANhYYJ
x3ExD2GZPKp7IqfgXJKVRWxFSCmI6jInU5AJJoZ4XGYf0orNqBQKma+bMixe
CPIbpv4SJYVwSWI9dyfC7bfbfSurKFx6IDFE7EYoKxrNtRsptP20LM8HIYxI
j71w3KEQI576HnOY6echFQf3Ujiwd+amOI51WshGc3cqa6u5kyxkIKQXry8W
9lAwzu068k6O4C06Fbp2i0LTU4uWr0SITeuyd1xh5jWdN6svIDQJ3zcIVaw/
hRDzqoQ1rnzbITzEzF9a7rJkI4iJ66HATUDv1NsszH1fDv764JomEHndM6k7
EKFRkt5aUM78w2hfFl/OWvRjM2k4l3V2oNFtK0A4qPG2LlYQyBl02rqLEJp1
fidc1QTOcDdkwyqEluj52bZrBKrxo9JYzNzHp3rfKwMB95sBr/BShG1ksb6v
g8C///sH91M3Ag==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{174.30398848912503`, 83.51413176875}, {
        174.30398848912503`, 85.26668522}, {174.83275461600002`, 
        85.26668522}, {174.83275461600002`, 83.51413176875}, {
        176.58405802912503`, 83.51413176875}, {176.58405802912503`, 
        82.977865413125}, {174.83275461600002`, 82.977865413125}, {
        174.83275461600002`, 81.226562}, {174.30398848912503`, 81.226562}, {
        174.30398848912503`, 82.977865413125}, {172.55268507600002`, 
        82.977865413125}, {172.55268507600002`, 83.51413176875}, {
        174.30398848912503`, 83.51413176875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHWWqKCDTl+Zwxlbnbbd6qMPjzuYfL2anOdg+nx6W
axHqsKnsVGTFPEz+qm13/ziyhcD5XNtbpnb+DnZ45uY/s2l+mgOr7dvgsC/B
DrNOX77VszDNYY7xkwuOH4IdpFdZro5cnOYws0zCYMWbYIfs0md3ti5Pc5i+
06ef72Www57LPx7cW5fmkNRwwpvlGYKv1VWRnnA/2GH9OuNggyJM/t85Xbmd
z4Mdtk48NSO5GmFem/XdWT2NaQ7GWrd9dYH25U14Jr2wJc3hAnOmgM/HYIcC
ZZ93ue1pDrl3v13K+hbssC96su/fjjSHmzynf0kwhMD5NSffM2XzIfi7F1tO
tMgPcZAxuiJeUQsMj+SSI/NCQxxEMriT7+WnOXAK+B/w8QxxUJnLeupkAoKf
yd1Ssj8Ewfc8oMXP7p3msPJXyYF5wSEOd3+Gvo5wTnOQTVxzSjIjxGHpzfkW
L6zTHCYcf3xlSk2IQ0HZVjVBizQHjpBnzSunIfiyfM6TyrYj+Od8E4+duB3i
8Fnw+fRy2zSHR5s/mv/5FeIwRdDhv75HmkPP8kolaZFQh3PvDgZZBQPj57nd
+y26oQ62txOlm4DutbNO+cxmFeogMqnQcHUBgi9VylF+rxLBtzqQeGdaMzD8
JgZ+vGsc6oCengBKkBGf
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvS96su/fjjSHOb2CCb/7Qhxg/Iden4z//EDwD889
ybZfKtQh57JUNXtjmoOpu2nBAu1Qh8QFQYdyCxH8W/dC1+SmIfh576R2fYpN
c/jz/Gn7H6VQh6x5L916wtMc9u4yOtgtGOqQ5rfjsmpgmkN9b/0vKYZQB0NR
kwnSfmkO+QvbTkm9CIHzNa8UyN49ieBv12Ld8ntHiMOM7usOyf5pDmvPXtOZ
uiLEoWFb1edVQPOuOeg+tZgZ4iD9d9HjP8FpDmkMB+vDu0IczH+cuuoHtD9+
i5aZSn2IQ/vhcvbV0WkOUVaTv3woD3FQmct66mRCmsNOK6tei9wQh+jJoety
09McZBPXnJLMCHF4cPDNxwX5CH7ah2bTK+UI/na/aZZ/69IcFNrL8zcD9b93
eSa7sDXN4WDbhWvZFSEOXd18fJ/bgeHpPKectQYRvnpchbM3NyP4sPgAADpx
vIM=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxz1UdEurKKJsjrQ8RWNYlrelxXWsdd+vqJSdfNdIZR4WNs4W
jdLcpKzmtGKHHOUh7brmSOchT6GpHbeRh0wPypodu+r3l9v64/3Ha3t/ts/7
/fk4ia+eSjA3MTEx5eTGyYzTdXH/blUzg2ypMUW7LMKkQ9WBxOcMvLYbZYVr
ItyzV9fLlQzW6rncKB6BaZuXWWEHg0NcOHO2JfAPzZ320DAsHdxvNccnULYK
8jV9DLHN3e89vQic20WW2kGGB86NKxuCCGL4R+ybRhiqJJM5SUKCo77WQXGf
GBYjlt1rEwlKP8RU/phgSPZ3EbuUGfnN0qFg8TsjC8jai20GgjrJSUctN1+e
LFfkuVKoy6f69KMMNmkhst7jFEV+Ky/5wwzKkD+fI89SOHl899vazyAdlLs/
TaSQKfmlad0MCbL8keQMikueI03DnQyjTq73W/MobIfaG+SvGDJ0gkqLErre
j+RwpuuVRxRvrynqcloYvppGCvbUUBiY4Q6f8ze3+fTqKilaaiJSNGqGsJ/n
qr3LKYYHtD6zXQx1DUO67VKKwPGZFn0PQ7VvQIWukEIV9ux06QBDwMaL6d4S
iuCZqR4915fBkC2KSaPQVOt0+kmGgpTMqtAzFMKxdL7nHEON4nKWAygWFOaz
JxYZ+sY8Fm7toyi4KZUnLnH+rumJeR4FSftoufqLYUu2TXHgN7LO561+x833
GzkpK7qjSErwMF2Vr1pg2OUW/kUYS9BJFUml4wx656gSoY/xntHD3rdXXQge
88gmLbe/496dFq/tyXo+Ic/c9O4OgqEn6fF2XP761NoK7WaCnGPxF36oGFLV
xXayvyL8/4//ADsjQYg=
        "]]}, 
      Thickness[0.0033003300330033004`]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{226.94899999999998`, 
        119.34400000000001`}, {234.012, 122.35499999999999`}, {
        242.57399999999998`, 126.012}, {250.691, 129.47299999999998`}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{249.32800000000003`, 
        132.695}, {259.89799999999997`, 133.40200000000002`}, {
        252.07399999999998`, 126.258}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.0033003300330033004`]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPS1XatfPvjwHIZY6580n4x1gfB7F53/rD8Q7sF7v
7Nzoi8mHqbc5ezM3NCTPoTJgt6reqXiHZQye+80i8xzWKjikWpyOdyh5269w
LDrPoZq3/djxs/EOzreuNYbG5Tl4/jqrHn4h3mFVQJXR3Pg8h4Z2OY7fVxD8
Vz/V+vlvI/ihB35v2vso3kGzSCTpQmyew2HnOeWs7+IdeMvf5NdF5Tmkh/TK
fPwb77BAdlMlc0Cew93ijFVe4gkOh/xuvdTmRfDf1v1xymTMc/h54U34yk/x
DvPdtj6++T/XoY9LwuT3q3iHIIsrQeJAfpjICf/wJwj+m22f9FfeQ/A3uHFz
XQK630bBedkPFkR43PVkulMrgMmHhd81Q6uk83dzMfgw9ctv+6T8eJwLD8/Y
z2YV51/kOqy/y8126Vy8gw7Xk+Xab3Id/EpSM7uuxzt4sPLMqn2f6xAS/mfd
3gfxDkZvq97Gfc11+Ptt+x+nH/EO26WFDCf9zXUobNbdcZ4vwaFXQZHnglGe
w50ZKaydPQkOsQvO2utYIPjBUnP83pfnOSTd+npr77d4h8VPPRq8a/IclF2c
BXwfxzssXSSi+LQ+z6HxgyzP72vA+O2PbippynPYOOv6suxL8Q5ONYseM7fm
OYgc9HziA4zv1a2r0yQ6EekDPb0BAMmaJzs=
         "], {{240.54036446000003`, 
         129.05537444875}, {242.39542103750003`, 129.05537444875}, {
         241.46789274875002`, 131.264191815625}, {240.54036446000003`, 
         129.05537444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdknss1XEYxn8cbZJbkzVNZChMYjaWkWclJK1lY81s3682mjWvy46sOEYu
J8XY3DoVI02WHEvlfonmFppDzb1cO02MzUYtpl//OFt/PH989r7v9j7P+1rd
iAmKkAiCoCXKQZS2qANOB3e8lglbwilbw1yOcqnLap6a8L7U08Q9m0OdYBoV
9JVwX5bFe9M4kierTOLGCRmng9dYEodvYIjr8Cjh8cXvipQEjg9TD/JdPxEW
JcWNUzEcoao0A8uPhBoD3zG3KA4bKvnj10s4+U2ZJwnnOBvWPanoJKT/sm5e
usax0pJ0W6+N0J1+yOKFp4adI+ZSYaXhaNcdnyhdjjGjzG0LcT7nSmBBuJqh
fXszQOghGPvVPzPrZdBXeCjz+gnuu54t1m8Y7Dr6STlE4LEF8X2VDDVnCg/7
qwgPy98N6jxicKpgb+e/EBpHxm3O5zBEdpneDJolKGeqK6ZlbD8fvcaMouxo
hp89vjNNS4Syjbq46QiGVPuJrHGxP1bSnahDDANq+XPXCcLMQPGT+gSG2u7f
i0c+E+YuOM0uJzP4NG9wYYSQktVaqZPB0OVn2xE5SAhaU/j25TJ4vdoMFP7l
1Z64lq1gaFjZchNaCaWX7j4tE/24tLHNoXpCkoG8t2+YoXBB5aysJXQeV43e
+sGwretDedUE7ZLcdbkWh735rr5QJdZbpUeZsYYXQ/bWZSc0HFY+7O14jmPh
mFm+Vx1B7h/sePk6R4uH3cvILoK/eqwomDT3jEwID5VKOaYy04wsxf0lV9fN
C+7wfX+WUtnsaxmHcpXVz4v+Y7wdjAzvcewFxDfozRD0zZpUjnKO///xL1Do
OSk=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQnb74bpJWWL7DM7lp3476JDh8+G7v/T0532HeZ+/V
ZqEJDvuftK1pS8Pkr9p2949jRTycz7W9ZWpnbrzD5y3cbyak5zuw2r4NDkuL
d1huOUF3dma+wxzjJxcck+IdNCS+/U3PzneYWSZhsCIu3qHi8SL9I/n5DtN3
+vTzRcc7nHTcavy2LN8hqeGEN0sEgq/VVZGeEBjvsEfmw1I7K0z+3zlduZ2R
8Q6H/re9LnRGmDd55cy3szzzHYy1bvvqAu2r/rcob71PvsMF5kwBn+R4h9qJ
HI41/vkOuXe/XcrKiHc4fdJ/AXdgvsNNntO/JIoQ/JqT75myGxD83YstJ1o8
jHfQXDAhq80VGB7JJUfmHY93ULx2fOsb83wHTgH/Az674x0MuQ/J3NBA8Msq
HY6flUHww/SeJ4oK5zus/FVyYN7ReIdX6UJ26dz5DrKJa05J3op32OQe0/2N
Od9hwvHHV6a8A7r3SWGlPEO+A4vW54MhLAlwPl+7ouduEQT/+TKD5CdqCQ4M
DYtftbLmO3y8+UO6zizBYWH9n0A7gXyHY5dtJvI6Jzjcjqlb6iGd73CueH75
Lf8EBy9PubwJQPfOl91UyRyW4KDIoNey0wLBV3985OQbRwTfXU9Of6l3vsP2
Eyt+vAtKcEBPTwAd5hA9
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffqk/wLuwHyHc8c4NtQyJDjA+AWqPyXrTBH8R+dS
muPdEhwqHa+fFfXMd5i1WMrigl+CQx4fv2iNJYL/3Efof7Uegl8dc52HUS3f
4d/nT851XgkO5TzLZs6Sz3eIj5354KhjgkPxnhI1E8l8h/3H7Gt5LRMc7Jo/
PNIUy3fYEeCcyquL4Itk7eh7J4vgx0xlulUrmuCw9OfkyYXi+Q7X0rKnefEm
OPSqmLvtBJqXvWBa0RzWBAeN7Hgzbpl8hzSGg/Xhf+IdXNLaNWJB9m/RMlP5
GO8wxdAkaqdyvkOU1eQvH17GOxhyH5K5oZHvsNPKqtfifrxDBqMQY41+voNs
4ppTkrfiHd7qr3RZb47gF8c5dDyyR/CP7Anq4XbPd1BoL8/fDNT/Z9OigvW+
+Q4H2y5cy34V7zD956kExoB8h8POc8pZ38XDw1ePq3D25q8IPiw+ACbesJc=

         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxjdXOVaKJYm0vNQywzIvoULTeNCKpBkxUjKL/5ukYZkvYwkz
Zxebstk003mfy6VdNHHpaFqhLMwkK2ZpJV6SbtYSVLKMBLP/Jwd9eD784Nye
c86GZCpN4XE4HC6rAFZOrPL61el92RSGGZNsJIXBdw1RKrIoBO2qMs0ZBvVq
5eL9XAp368SFBCUDV7/JQxUaCiGJTRVpGOxuE4eJiyhmgvxdJnQMekXOQ4Ml
FMfMva8C6xgEB7ol2cspqkWm38taGKQWz6dbqykaLo6dP93F4OANW1GGkWIy
bnZr4yiDuhiPHwsNFBbhmpASHlniZEWVT6u3g/2acpLUEQTtU6tkdjb/hWXg
LSQEL1cYvPh6dv6HvrbPRwkq6s0rQyopxnwXZbdTCbZXN6nX6yj2fR0oi88g
uLtl/EvuVYodtmh7+FmCzJqi5eMFFHa30ufDWQSbopRcy2UKMb1p410iS/ux
1ka6R2gIXr9PW9AqKeY4/n6uhQSCNw8+BLPxwyOVJ6bVBI89BE8G1axfRYvU
M49gTFypmtVSxL87Oa1m6+3dY3TmX6OQrtMfmM4heGZJbzKWUeid2nZ6sv0l
UoOQX0Ox+LezcZucYMC9JoR/i6K7I1K6kfWTGB2aKW6hGEwI73RJJJgTWiOO
mClSTpX/7NlPUPorbl7RQRGTLJuS7yI4/lGXxH9EkR9V8FQf5GBT/rl7ch8H
h0U1kx4uwZ1PiqG+VgqPgNhvEhsDW3dal/E6xR9RQrGk3nHPw/3B2vlyBiaF
W6Kdnd/ba61zp5ZZ8icR8Lg6FYPR1aGWzaz/Znlj7Ug2gytmn7YFFYXcWuhp
kDH4/x//AVsVNkI=
        "]]}, 
      Thickness[0.006600660066006601]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{194.285, 113.34400000000001`}, {185.254, 
        113.71100000000001`}, {173.93800000000002`, 114.17199999999998`}, {
        163.71099999999998`, 114.586}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.006600660066006601], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.43800000000002`, 
        111.09400000000001`}, {153.59, 115.}, {163.72299999999998`, 
        118.09}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.006600660066006601]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4nSe4qYHC1IcpC8+MlzBFecA4zt/yPHd9DPW
IezM2q1u7Zj8py9TDnmlI/i3esysn4TFOnTNMfoa0JHiwLY3Yoqid6yDveJ2
s+iuFAdG54NB75xjHT4vta5I7UlxSGYw6TlvE+vAvzA5a3t/isPx/qVnN1jG
OlReubR7xhQEX2xdQt32mQj+5vZ3DtfmpTgYvq16G2cf6yCzO3bS9sUpDjmc
08rmAO3Ljlny1W15ikPm41MXmdwQ6j+GnVB6p40wv7k++iCPfKzDPqfAtL4O
BP/51uVyRpUIftLGspWnC1MctLaJc08yQfAf5J9tEE9A8GHho+bY3/wlGcHn
uXkmOR/ILz/wsWfPr1iHTwVcLq+SUhyE7m5e5/gHwXdba/HO+y+C/1D2+Jos
hjgHh5WBiytTUhxqF3dces8c56DxL0qlLz3FoSEhpLiTPc7hbtP91BmZKQ6b
DW5umswR5/Czlj3iVU6Kw/awJeG6fHEONe8v/WoGum9fL7vVL4k4h6dKTj6p
ZSkO8b0JCzcpxznMsdJJsKlOcWB42LqUxSDOgTVv9kbZhhQHm8Dc07dt4xyu
RD0SWtuU4lDivnd9vUucQ175EhOjlhQHQUXvonmecQ5X37o/rWwFuj/q/NYV
PnEOtimvpx5sQ/Bh6aM8tyNE0gvB50upv8jihuCjpz8YHwAKejRS
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx0VlMXpYdadVwiRFZXShh73NiNxqa3Z0+/1+TvumJZs6kj84
ynnsYSO1jFvydGYrSfTAxewWZ6c7ruSOy0lYEVG3RKzfX27rj/cfr30++zy9
Py7nEs+ct7GyslrFai8ra1acWbtDjj8J4q4II4bSGTw77OsuMhMs1GV77E9h
8MefU+E6RVAQ79TBv8DgTlktP2iM4EZ382CGkEH0+ugEmYngycKAn+IUgw+y
WyqbIQJc8798NZhBQnFW6MxHgt6CB3JvHgOeT4kf9z3BW+/4XZ3uDCKclZvi
ewgyRZFJ+bYM/qan1xtUBMspbsccjfQKGwJ6rINqLBzZv/pmUTKNsb6cgzNq
grWK6GKXCBqa1+YsbR87b/ObSr0njZ3U0YmYfoKGhPCW0a00Aq93yyUGtt7w
w6RcWxqKuXsnucMEazZ0qJWLFEBivzeMEvjgi7v1DwqpUk656yTBHn5TRekI
tXIf6e7C++G9FJbywrbkzxFwRa3iUhWFoil9m5zN/yZ+l6pk44N1+UabcQJB
QGWZWE+hLXtx+9gIgbAx8FO1iYIgba5EaySYN3dWKSco6Ow8fvP0BGqq5kTu
LIXTieZsrY6g3Es6Hb5EoevxfKK2i4DzKkfGcGgEZ8R6ydoJzGl3O3N9aNRU
6y5KWggCbht1+/g01qlD5DHNBBKZh0kTR+PI8HKItpHtN24+IJFaGDvsR1qq
LOz7VJ7JNdH4ZdymclAQ5Fm9OCvYzEC95DnK0xDYH3/udQkWP0OFmqZaPoOp
sKywmQHWT4fJwHEBs7LfyyjbVrcYBu31sZMNnwmipkXOQ+w/bXRMnjF8JSh8
lFblJGbw/z/+A1USRq0=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4i9dGydk8aQ6KCYK2FskxznA+L3qT5OeZcU5
PAndrlkvneowcWHNEsmiOIe38g33JDRTHf6mB544Xhnn8HVqzTcJ01SHDD21
N6WNcQ6aaYxmymapDiZxC9dkNyD4HFUqprv9YuH8M5y2/E8cYh0m3FnyLMs8
1eGY2rKTG8xjHbSVz17bY5nqECs7122OcayDsF9BJ4tNqoP6BJ+0H3qxDhvU
/3krO6Y6RCxmZc3UiXUwDZvaH+aZ6qByueFonDaC3zbh8z97lVgHx5mTFHV5
Mfkw9Q9Y27ZJiKY67H/v9Pwx0LzkhdvV66VSHaISLi5lMoh1MOr718Enm+qg
tU2ce5JJrIPUzoXWYfKpDgnOGa9NLWMdGvVd38xVSHVIU/tvkOmE4C+a9izM
IQDBvzX518RfLnFwvujsR5svBsQ5mCimRN8Gmvd87ZedvyLiHGayLLIMk0t1
kLN2nTUvNg5uf7uLn+zmxDgHL8uv7L8kUx1CDafWOaXEOTzUf9PyVBTBn/x9
iWqYCIJ/hCvuyDHBVIeOtb6Km4HxW5opnmjOhxnfMD4ANHrS5w==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk1EcBvBVlg4vYd5gIDJXeCELEm+03BPUJDSWy1TU9+SWp6EJc2Yf
tNTSsWYauFiGZqLLIi8LzVBTZ9qWUCKpYaElGYqJQpZKYJrr7Usv1Ifnww8O
5/I/j1CpltMdPB5vG5sQNtvZyPJV6x6vKDretYimMhnMKBVKew+FrnJ1S7KX
gdw9QqJO+t83OvvvTwYxsMg0P7a0FAenj3v6lzMYHs/yt9dQCEaLR9qfseuN
qkj7AwqHlJ6So/Ocu5tz1oZ2k79eb/K3RuwjCK+WSM0misj3E2WPwgnspmUF
v5bCdaN4xOEYgadBgNTbFFe++FXFxRMEeksF5gqKp9Pqgm9JBE4NuvmAEs5h
GW57DuVzntu56crPpZi7HuSlOE3goZNNtWZTuAtjc+tOEFQu+mZKVRTRPdlv
PkgIBrI0YYsKivM2a2nxAQKRYTZ3OI2ib/RwdboXga7rTFvrn3lYSn4u+xDo
84Tx0lSK8dU7LSGRBMlrI1pTOoVnjLdPpIygWT6jH2b3X3r7nBgJwet7UV9L
NRT7+6OH6i4SXPhOViYK2fM0KbEfCwlS+zLKFys4F9nKDOIazksxwYladn5D
U7wF0SWCfq0puOAxhd58UthxjsCmisoxd1G0dTVOJMrZ94bON/D7KJyuLZSP
iTmfvZne8ETE+VP6hvPYJoMBH6df0nYKm9Wxe3ScQbvRbUx6lwK+zp97Gxko
A6qOiHModlmSjcJYtg8p4jSzmXNebUV0fAdnw6DArmbvUz8p6HwYx+BWwtUx
Mds3/qwoqvcUg8tNZfJ4C4VL/fJkQgKDNpe8jMBB9n9KdX56hkFokcTxxUuK
EuuKNjObwb/9/Q23dUVs
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EYhuehNPNAVpqVp5EzSvNYWJ5uQ5HU0QGHKN/3Zrb3FU3NSs1Z
UkRGB5XMbJbkIcxBQaBmWBbJFNMhpJYUqc1wYvNAKyN1tmq/HPTj+nHB8+N+
7ufxTDt5hFoIBAIzIzuMmBv5udg6kqyl2JT68nRNH4fklhszVlMUl0UVdw4M
cnBsVuTE6CjK/OYvOo1zKBY7dYsWKKreStInZjm0fmKNqmWKzLog+6ZFDnsS
AmOlAoYPwvdDcxY86iShqkJLhg2VHYvd63gMt3uNHrRmcNNpL+wU8nit0hsM
9gz01V+fDPBwyIo6VubIMNXkf1yTafLw1EgIG0ze3WXVPjDEQ+QcMl7owOA4
1vok6jePML++UvkahvIJcd01V4LV/Z+LOlcxBDfbTNoHENxXDi88NmNYG/HU
5wQINh+2kTgaKNR2t975JhBoup7n5SxSiCsCq/OTCCqpIjfmO4VOnFT/hpKV
fvSPSrx3FRBEWVVlbZ2mYKdS4keLCWQGzaFOY1++3hGq2nwC/8jdQdJfFMrU
jCZdNkGCtGv+kp5im9uoepARtGX3F8j/ULg3RtfWHiUIUctdAiwYWvJyC3QS
go6ivutyY19ns68musQR7A/rqZevZxB8KXlo6U/Qm8lrVFsYhK6ycyMbCWj0
TJPWgyE6eu90/DIPczdZhrXIOB/8bUwxzmPAplMl385wZdqjfElp8o/nzdIU
D0w+qZUq49J5ONs2xqa4M9y8K9HaBvGImL3tG2DHcKYyrcLWynTPocjwshd6
Dm4Nob2FxvzVpZ7WxTpuZb8emYN54lcO8ft4r2dLFKKJttoaNQf9SJxn2Q+K
Ob97LmSYw///+A9aXi+I
        "]]}, 
      Thickness[0.006600660066006601]]}, ImageSize -> {303., 166.}, 
    PlotRange -> {{0., 303.}, {0., 166.}}, AspectRatio -> Automatic]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.825905024147108*^9, 3.825905072463655*^9}, 
   3.825905363382402*^9, 3.825905528383874*^9, 3.82590787412798*^9, 
   3.825908031980132*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "3"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.002577319587628866], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
       388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
       0.33199999999999363`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
       24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
       3.9919999999999995`, 13.508}, {3.9919999999999995`, 
       24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
       45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
       24.836000000000002`}}},
       CurveClosed->{0}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
       21.99788154, 23.851453813124998`}, {18.552508993125002`, 
       23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       111.074, 44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {
       94.133, 27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {
       77.191, 44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {
       94.133, 61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074,
        53.512}, {111.074, 44.156}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
       59.891, 34.656}, {67.65599999999999, 36.809}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
       39.508}, {68.684, 33.461}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
        "], {{57.68489645999999, 
        38.21162444875}, {59.53995303749999, 38.21162444875}, {
        58.612424748749994`, 40.420441815625}, {57.68489645999999, 
        38.21162444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       384.125, 140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
       363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`, 
       129.164}, {343.10200000000003`, 140.49200000000002`}, {
       343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
       363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
       140.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       357.65797799312503`, 140.37615644875}, {361.10335054, 
       140.37615644875}, {361.10335054, 139.507703813125}, {
       357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
       140.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
       71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
       147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
       80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
       156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
       90.35199999999999}, {173.45700000000002`, 80.99600000000001}}},
       CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
       
       "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
       62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
       77.762}, {132.35500000000002`, 70.23}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], FaceForm[RGBColor[0., 0., 0.]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3cP5P0b4S6SD+1qLd96XAx3mbTqsu5Y/ymFH2JJw
3SeBDtY9gR9Oi2DyVdVe/WXcFADnt6hNnOa5PMBhkU50/gOxKIeGNT9DxBYE
OHCbpXz6IhXlIL74w0XGOQEOfJ/1J/fJRTmIPFMxzJgR4LC2s/Obm3qUg5Bm
5IRzUwIcAtzW/ZthGuVw9/0VnyMTEfylP1syFLoDHEz/KD+23hOJwa/gmZ7n
OTnAweFQYN6ic5Fw8x6Jlhd9uRXpsG7mc7+30wMcNu/vLJF9GOngXVwqyDM3
wGHb0xDJ7c8iHV74MF/RWhTgEBT2+PrVl5EOITXXf99YjeB/t/jDrL0LwTcT
dpv0QyrQQYA5Nef0pUgH1csNR+MYAx3+5V1mmrE90qGlPvogz9cAB7mbxy/k
zUTwV2w9ohrViOBnyAtFv8yNdFDJajwY9z/AYdKkDOHeuEiHGRd2nL4pHOig
GPRn7Wr/SAdu8w9XQzQCHbZ1q3f9dY90aDr8qSXTCcGfUes/2SwZwffcm3u8
oz3QYe+hrpxTQZEOscr/LPYsA7rvoI21dUakA7t4m/Lt/YEOxTUOj/zrIh3E
w70/lNwMdAgMbSi+PyPSYeeqgi/HngY6/D80f77hTgSfu/Os1ozTCL63fMNX
jvvA8GOI+zT3fqADenoCADBlHPE=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHRT2+PrVl5EO4n9lE3dbBTrA+DG7/pnsWYLg2/Fe
Y68/FuiwzvWT0aubkQ4btjkWJlwPdJh1P/Hgtl0Ifk9MxtRtSxD8LdWfNhyY
HOlQHv6pY8+5QIc1t/tPfW6LdLDQsj/kvTfQYbG17hO1qkiHX3+6f99aHehg
eVIlVqgk0uGVwOTTtyYj+Euca+XmliL4RrMEt+5OCXTg2Ja9b2FZpIOG7WPd
0JBAh+vcm5QNqyMdAjdYPvvhEujAO5OJ5Wp9pMPD/LMN4maBDq79QS8qgPbf
UjY3f6IV6PBEdY23YX+kw9WV879uUA50kLt5/ELezEgHk1VufT8kAh16j6bP
3LYs0mHGhR2nbwoHOsxQmqYgux3BX1R/ZHnzcQTf1ebl+qtXIx1mf2suKJYE
+l+js0L2caSDzbc717VVAh1ebb0ZcfA5MDw3r6g4qo4I35WVtXOK9RF8WHwA
AJEkyRg=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI0wEUxucSJdIyAnOENC9ZlmaYXZTMT8RsJvX//712arKCCCzRZmmI
puZlLbXwltYSnbeJPWhOXaZ2MWlYLjNLNJ2ZCx/UjAjvhO3JQQ/fw48Dh++c
73O4GMdd2sDj8cyM2msU36gzerU6uptw+RqdGgvlkB1jXszXElYbsnfvD+Gw
LbYvX9ZCyI0RdIf4cvD1+jXZU0fIfNc2mnaAw4DgtGNqOaFxZdiry5nD+8Oa
MVExwT/paPwNAYclp9ohYR7h090ylbsVh3zxx2ZpFkHrHiPUrrJ45u0SZ5tE
SJeEJcj1LASLZfWLcYS1RCffzWoTj3rr+P4pJg4fMs8tDGYxXfmkQZhIsOyK
KnZwYPEyXs4aMox+215Uj6wxEKtt7fhyQvNVUYdhlkHJX8+HfgXGfd8qEmR6
BoqJ3nHpI4KFTXdfzwAD5RuJc101wRM/dvHfMthqrpPLmgmuIa1VCg2z/p8s
l4IHIhWDHdYe18NeEwSSTqmigkHgZ7a3QE2YkX642WOcDzNPzYPrCZHe1Y+l
jQwqLEoyrSoJ59Q+47VtDHR/bqcaSgnL89qani4GWpvZI033CLrzdUEyLYNX
I3fCDZkEpVvWnGiQQXPEfVdDLMGuPac8+icD1bKkKkVMWEgp0sosWcSeCLT3
CyX45OsH9zmyOFjkWmYmIqSV757oP8aitF3xZTKAsDQ173GLTOxvv+l7R7KJ
vZpU6XZtLDZqBkfFEQQ5T3M2YprF84XfW5qSCVbHW9yu2JryDKL+1npHDit5
NV+FRv8Z1jM+U27c+n3tkZadToc4VNIFYZ2SEDUn2Tlm7FPA9pw9S42EQmVK
jeAkh//7+A94lDen
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYk5Bxmzxr1EOSokC9haWQQ4wfp/606RnDkEO
L5fxzHUQjnaYtLBmiaRHkMNvq3lsJXrRDv/SA08c9w9y4FKfblbiFu2Qqaf2
pjQ8yKHo+IKtHR7RDqZxC9dkhyH4nFUqprtVAuH8s5y2/E/EAh0ctzwXk/CO
djiutuzkBt5Ah3JHi++7/aMd4mTnus3hDHRwn14X4x0S7aAxwSftB0ugQ4PX
rIcdcdEOkYtZWTOZAh26l5/IeJ8X7aB6ueFoHCOC3z7h8z/7XwEOS3QP98z5
FoXBh6l/yLZqWzFbtMOB907PHwPNe2HLO9NBMNohOuHiUia2QIdW8dnR8WLR
DtrbxLkncQU6hOY+PPBOKtoh0TnjtSl/oINylIZSnWy0Q7raf4NMCQR/8bRn
YQ5qCP6dyb8m/pIKgvPFZj/afFEtyKHTNo3hp3S0w4u1X3b+0gtyCGZ5tOed
RLSDvLXrrHnGQXD7O1z8ZDebBzlsye2INBOIdggznFrnZBXk8CiqLJiXA8F3
e/V8yjsWBH+lQNSl8/+jHDrX+ipuBsYv97kz3Bt/YMY3jA8AOhnSRw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYtmWjTm7BWIc0gujvO8EBzkoONbyhorEOBgv
vMp9KQjBv/zmcoi4QiCcP+PCjtM3hQMdQqsYA+PFYxzi2+Z4zeEOdFBVEQnu
kI1x+FYz+Xg7e6DDt7NqoRuVYxy+7D+u9o450CF11zHZnwYxDp/CTii9Ywx0
KLpywPWnS4yD6uWGo3FI/PYJn//Z/wpwEP/SHK+9IxqDD1P//qXO6vaT0XDz
tD6KnI27Gg2374Txosm1d6IdtHwl2CdxBDow1u0T2f0k2mFymGLXMp5Ah7nM
DVYOL6IdGG8d9HsnjuDfPJ81y0sTwc9PUcvyEQyC8ysPhnzcpBjkwKD1qVzx
cbTD03ZN0UTNIIdjZdc+Pb6B4MewnMs+fwnB/2D7013xdLTDE+PYiuPqQQ4t
yhHtNw9GO3ismx3kpBLkIHtdamkckF+tFfJ1k3KQw0u2aakhB6IdRO6JCVsA
+f6vLjuf3xft4B51fusKpSAHaSl/lqN7ox0e8E66rAvkS270Zzi6G+E+idjm
ZO1d0Q5uH89vXKEQBA+/ityOEEkgf31w1QOxbdEOq6/wTlCWD3IQNd+xb+KW
aId7AceMpsgh+KLuYuIWqkD3oaUXAPbO82g=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcxx0VbpeKzqY/nEuU/3VkVs67RUtSv98PpXwPo5jJdKVitKwy
NX/PNfmzjq3rNG12JUZhQ1G3XZxrolyK0PmTa7ab8qDukdt68Hrw2j5P3u/3
xzU5i7lgZWFhwTLhacLShO3iepaxmcApqfNyXT0FbWIrj2kiuOMuqYpopBAu
WnRXdxKU+S0XOLZR2F6l0pSrCKoGY9OmeikUKTMqP2oJMuoFdor3FEqllqNs
HcEo/8Pw4hiFRMXWL4JpAq701crrWQqqi3rW5AKBi0F/02uFQkOFNFz4hyC1
6693uiMNoZbHEbFE+KHwT/kOswuTQsG/bvY3fdbtQ09oZO61YwesEjjoWpoP
D9OoOeufIl4iKJ+Kqr+3TMNXGh/aN0sQ+Iw9bWfNIL4gIrh2goAjfOGd4cjg
9MPny6kjBF83Vmp9+Az0t7YIXNQEJyX7q6/6MDjav+Cp7ib4FXWmYeAgs9bP
alOhh+8JBo9s3/LzlARp4nOR49EM7I1p871dBL4eQpUskkFBro2S/Y6gLyld
YTjCoKPPbd8xDcFu5/EJzSEGxSMHgsRjBDx5mEwWyEDSoc6XTxK0ZF+6ZvBi
UG3wTxQvEuRk3o1x4jFQXPEsFluJwPpW+HjdBgbKoTj7UQcRdu3Mzfs8T2Pu
dvYDrrMI4WHBc5EaGm5BFTui95juA5Z0jW00ejY7T4h9RCia45X9rjb7WD4r
uTHH7DP6873HQ2iccpgZNW4TQVITq+fY0pBpB+RyI0G2NFnC0Zn31IaGlL4c
opAQwv0kmCKoKXG1udFPreUbyN1kGdNNoT0r7n7zIIHHVKusrpUCt0VQQnoI
fvrVOiU8pfD/P/4DlzIqgg==
       "]], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
       138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
       56.516}, {119.85499999999999`, 51.789}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
       110.84400000000001`, 47.38699999999999}, {118.293, 
       54.922000000000004`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQze77c63m5wSHrqjCO9OzfBwmLIye9o0h0SF3rcf6
qB4fh/i+Rd9bmTH57j5XfjNreMH5bL5KupOFvBwmx6mbT2BJdPgb8XmlDouX
g/vj1RWz2BIdtN0eLmb+4+lw4qCgZzpHooPaGc+kC188HSR691Ud5kl0UAza
pDD3radD5usLdW+EEx223185s+M5gu/xmfOiwy1Ph5hj3B9trydg8N9I6N2d
9MrTIWnlIrPCBwlw84yDt1rMepbgEGF8fu6tz54O0iv27Vz3MsFh0rNXShL/
PB1krVV6qt8kOJyZybYilMPLIbs4+zXXuwSHZT/Wfd8ojeC/LvzBHmaB4Geq
9ah8/OnlcNJzzdbWRwkO7ssYu/ce83I4WP+Y4c2VBAeW/9uaJNd5OVzccjf9
+lEEX0w5RujsTgT/23WmtSIbEhxcrzA17z3k5dAlqNeZtiLBQWdh4fTNr70c
gj6WX/u6IMFBOO/B6pUi3g6yfb1H5OYmODC1P+W87IHg6/yep5bbheD3V93u
E7zs7bBAc79p66IEh+1ufworBH0cHDUl5tquTXDg1uNx3+bs41DNNuuD+w6g
/nXTHrws83F49clyZz/QvfmhD1/09vs4HFzpeX7HVQT/eM8DkTf3EPzn1y2r
lrxIcDjHuOeJdbOPA3p6AgDRphxC
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnV2c/ZrrXYKD9i/rQ2WW3g4w/paSv5kVvD5wfpXU
Gv5/AT4Okq8/SYg+S3CIyW1+dKDIx4Fvh1ZC9TUEv/2brlf1aQRfmu1zOMPh
BIfX654IVib6OIhvO/hk5p4Eh7yQupbpdj4OwmkTCo23JTh8/Cn+fau0j8M9
HR49zc0JDpcU1aZvfe0N57u0/7KxWo/gJ5koZ5X3eju4Ll5/r2BLgoNP1bHo
VTneDrrngibuAJo3P6H4zEdfb4cTItWNXDsTHPbfn8Wob+Dt8IR/cXEM0P4N
7nl5JyS9HUxu+y/dcSDBYXmw/etEbm+Hi1vupl8/muCQFtIr8/GrlwPHal2f
6jMJDjoLC6dvfu3l0HvzSP+6Kwi+MEfM5Yd3EPyUtLzrXE8SHIzfsj989s3L
YU7Mvt3rXiU4lLzZuT6cx9vBfPGz1QxvExwq0wI/dgkjwjvg8y+L50oIPiw+
ADofwRM=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pfbgiP9oxIdTj3aMm1Htq9Dy99qz4UxiQ5f
Qrn9Y2J8HU7/iz+WHJzoIHLVqGWmna9DQtLHgiafRAfmqbnb/6v4OmhdXTDh
nnuiQ9TXjZlVvL4Oy5OvvnVxTnSof1fw4NU3Hwe7qDNZBvaJDgtFDf2j7/g4
cHx/GBFpnejQE33FoW+3j4PsUx7z1SaJDv8OrHgmVO/jcM752GVpw0SHX2/d
qmS0EPzNxbNYm/Z4w/nL1nCKqUZ6O2yfcT7EAKifq2qjhjObt8PCBrsVglaJ
DkK5te6bD3s5fFBs5V5om+iQcHNS2fG5Xg487sJn9jsCzdtv/5yv3suhf8e9
vEg3oH6Flpmd6V4OQlqrBD97JTokNpzwZgnwcvDySjiSHJTo4Dcjy9Xc2Ase
Pmy+SrqThbwczvtNtDwVmeigf6DiqRmzl0PKJqUnL4DqLz+d87FD2MthbcEl
RlffRIdVRW6WT5W8HCZ6uziqeSY6bEkr3eNt6OWg4WS9T9A10eHD637PTnsv
h6UX8qUrHBIdpu306ecL9nJQNLVbJQgML/tIjruTs7wcZhU7ThE0SHTQK+K1
3jvPy0HUdVXAPfVEh5c/1fr5L3s5VGTL9O1XSnQoktq9PJzD2+H2xL7TC2QT
HX5b+R+Yb+vtwLvUPUtQOtHh3dnX8X8qEPw6K7FD5TsR/NQEf0ZDAx+HY4uT
3/qpJDrwM+ZtXjPDx2He4SL2CjNgeqjJiLz2ARGf3VvmZQdy+jrs4zuTYwB0
/z+pa6VnZH3h/stfz1fhrufrMKl0Ff9noP/X3Tlot8Pe1+Hx5T3CMoGJDkrO
Pz2MQ3wd0NMjANbYGCE=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4mMBv7asLk50cDykUFdg5usA40v4nzp6xtXX
YZs0g9+BpkQHJeefHsYhvg77n55gipqQ6PDj/KIJ/cm+Dsejj0pFzUl0OB/j
c+N1ka/Db22vqJS5iQ7pe5wirxcg+PxfPLLKeL3h/GnCVXInPno5JC16y7Vm
XqJDt6/P5MT7Xg5/X4j+/rsg0WGHlVWvxXUvh6fCO9e6Lk508FGYeebDWS+H
prduBSkrEh3Wu3FzXTrh5cAuc2/z9A2JDu7LGLv3HkPwuRWf/63f4eUgHH/b
Na8Ekw9Tv+n0uVuRNYkOtfdbzx0/6eVgms7gc6Ax0WHLgUXerBe8HFhC3Nf6
tyQ6BOfoi6nc9HJ4U/cqfnpbosOBtgvXsh95OQR/7RW4357ocMbnX+KlLwi+
i+7ZtQ0C3nD+FvWvyl9/+sD5WmZH0xcL+jqwPV9TLwPkn4t+WfxV0dch+9Sr
2OmtiQ5WZV0mttq+cPt5OudYpRn7Osj8t9WxBrpvZZLW3xYLX4fNX01WqtUi
+Kl733pOr0bwp11Y9oK9Ehj+0bOd0sx9Hdz1E1orSjHjG8YHAAMf76o=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4oCuS1trGZMcTj3aMm1Htq/DxQyLNi/mJIdk
p9XiSzIR/EU3l6/UY/GG83UWFk7f/NrLIbv11/LzLEkOu3ksp1rc9nIIucWs
+YQ9yeHlT7V+/steDjb6vKt+cCU5PKnv971z2suhRDW2b45gksOjtRNc7xz3
cqgyilo0RzrJwX0ZY/feYwg+t+Lzv/U7vBx8D1mvN72aiMGHqbe0Fbj6+G4i
3LxrDixp5x8nwu1TfeR1Mu55okPgLAM+lateDo7sNztrXyc6KK91EvG96+XA
f2qnjMPbRId/m5vn3vmM4K+bf9Vkqpg3nH/7hM+VGc984PwPTSsfpbL7Ojje
Ldq94VWiw3H+YK1DYr4OS5if/pj4FMHPP5Wwtf0Rgm+ZXrZ4w71EhyPpuz70
Cfs6MN9SPcxzK9GhN8Z8aQuPr8MFY/ag8zcTHT6FrHiVyu3rsO20i5EXkK+6
R1etgMvXIWNv8sL2G4kO3VvmZQdy+jr4hS5sZALy90qrLI/m8HU4t2BhPdN1
hPvOlllvNL2W6NDxaH5yIKsvPPze3RJYacTi6yD5aVu+9pVEh+CV0gruTL4O
px9fvZdxOdFh58KeVA1GBF+jT0evgM/XAT29AADTQQUn
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       146.52642112112497`, 55.48896844874999}, {148.49523116799998`, 
       55.48896844874999}, {148.49523116799998`, 54.99270331312499}, {
       146.52642112112497`, 54.99270331312499}, {146.52642112112497`, 
       55.48896844874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/aaggYOXOdmhK6rwzvQsH4fSo48+3BRIdshd67E+
qsfHwWWTZlCmMCbf3efKb2YNLzifzVdJd7KQl0NF07qJxSLJDn8jPq/UYfFy
0GE3vlwrluyg7fZwMfMfT4e1T2cs9pJIdlA745l04Yunw98NrleXySQ7KAZt
Upj71tPBjz/i5nnlZIft91fO7HiO4Ht85rzocMvTwfHVJG/F50kY/DcSencn
vfJ0cD+rOTHkQxLcPIlym8m135IcIozPz7312dOB4YyryKSfSQ6Tnr1Skvjn
6cAUv/pZ3J8khzMz2VaEcng5BEz/5Prub5LDsh/rvm+URvBfF/5gD7NA8DPV
elQ+/vRyWJdrLJD5KcnBfRlj995jXg7LFmdFn3+S5MDyf1uT5Dovh203Ug7t
uorg/3Z7nLPhJIJ/+3cn+4/9SQ6uV5ia9x7ycsg33frYc0eSg87CwumbX3s5
mIv+N7i5IclBOO/B6pUi3g5Mm0TkmdYmOTC1P+W87IHg6/yep5bbheD3V93u
E7zs7dDq6zYhY1OSw3a3P4UVgj4Oar7zvyvsTXLg1uNx3+bs45CgpeitfQKo
f920By/LfBzOix0ULga6Nz/04Yvefh+HZWcvaM55iuCv2ZCef/4dgn/m94Er
7T+SHM4x7nli3ezjgJ6eAByxFYQ=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHTD9k+u7v0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg4/OOrKv7xNckhJrf50YEiH4fPtzfuinuG4OdIbV0SdxvBZ9Cq2vT4
UpLD63VPBCsTfRz+3PSwrz2T5JAXUtcy3c7H4Uen+BmxY0kOH3+Kf98q7eNw
OGByB8/hJIdLimrTt772hvNd2n/ZWK1H8JNMlLPKe70dtI6bWYYcSXLwqToW
vSrH20Ho083Xs4HmzU8oPvPR19thrQXTnbcnkhz235/FqG/g7XDSWOucPdD+
De55eSckvR0k/1/7P/tCksPyYPvXidzeDttupBzadTXJIS2kV+bjVy+Ht+e2
LIu7k+Sgs7Bw+ubXXg5Ff71fTXyC4P/Qfqx79A2C79n11fDd5yQH47fsD599
83JobHAVm/QryaHkzc714TzeDjLHc9me/ElyqEwL/NgljAjvgM+/LJ4rIfiw
+AAAdJjPwQ==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxueByANoM6NNnbRqmKGbaUq52WMesm/fNw+UJtPM/V0zvFgJ
YZpp4kAtQsJKQ0pSRGUe8JRWRi7LPBU1D4XRmpGCM8JDCe2i9V1N6OK5+MHz
wvs877tHpU1RO3E4HAdWgawcWbk+PMjtCCAQD19ZDHeioE1zEipFBNsYYVAN
l0JAqn9znZiAl7XkECShULN+y1oYThDYoH83epLCeKlp3i+SYDpK40tnU6DX
2q4NHCPojGtt/lxAod/aw5mKIRCJCtaqaiisZD7gNp0gkJqnbal9FGa1+WHJ
CoLxIlu6cZXC/h1Pas3JBG+Z7NGxOLmdC4dLrsf2bHFFhcfFR940pENdu6bY
+b1PNZnluTRSZjBiSSDgv6mP8tLT8L2U2u0VR6BReU/4GWn0aphgGwh2Fuem
z63SkGyW3VRLCZ777GtRbmdgzQ3RGyII7gvVkhUBgzZX/5Y6CYGpvhPVkYy9
n1+n3RIzMhiktbs3aQ8QTHzruzeYx6C6MaPCi/WnK4rvyJQM4r+3Xxg4TFBu
MNILcgYql8jAuSME8dLBF00yBpPc2A6LjECWUCWViRkodB5JuuMEOcvmH2Yf
Bh/8ow0Wtq+f855th5wZnFmQfbSkENgMbnKX9zRMHrN8gZIg9uj65uN6GleX
VV+k5wgqK/Nnas/T2D2y2qBUs36N6VliCI2lrgiHFQ2B+2y078ZvuZ27/ji+
UvRv8dj0uO5ulBxB3T4lHWcJBKF6I2+Owqnb7jk6mmBR9FrIK9m6Z2NpEf+y
mkJYfO/fSXb/YF6MpzWJsue7sSFwbgWF7K8zShc2Pz2aJ4sQU/Ase5lmDiH4
lBUWOsSn8P8//gPm/hyd
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       242.777, 101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
       84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
       208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
       101.48400000000001`}, {208.89800000000002`, 110.84}, {
       216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
       118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
        101.01833734875}, {228.42917790875003`, 100.1214467175}, {
        227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
        97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
        100.1214467175}, {221.98906566875002`, 100.1214467175}, {
        221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
        107.2353207}, {227.01602828000003`, 107.2353207}, {
        227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
        101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
        225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
        101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
       94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
       88.67999999999999}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.2, 0.627451, 0.17254900000000004`], Opacity[1.], 
      Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.2, 0.627451, 0.17254900000000004`], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
       172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
        
        "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
       97.30146844875}, {187.73723616800004`, 96.805203313125}, {
       185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
       97.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
       121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {282.441,
        114.262}, {274.85900000000004`, 121.848}, {274.85900000000004`, 
       131.20299999999997`}, {274.85900000000004`, 140.559}, {282.441, 
       148.14499999999998`}, {291.79699999999997`, 148.14499999999998`}, {
       301.156, 148.14499999999998`}, {308.73799999999994`, 140.559}, {
       308.73799999999994`, 131.20299999999997`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{238.125, 113.293}, {
       245.82000000000002`, 117.87899999999999`}, {255.996, 122.754}, {
       265.42999999999995`, 126.45700000000001`}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
       274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbSlfh3n1ByHM7Y6b7vL4x38bj6cdm1RjoPt8+lh
uR3xDrLHNH6kLsXkr9p2949jWBycz7W9ZWqnd5xD4LS15gXLchxYbd8Gh7nE
ObBKG1VWrchxmGP85IKjQ5xD28/pnu6rchxmlkkYrLCJc7h2xKV68boch+k7
ffr5LOMc1JXD689szXFIajjhzWKG4Gt1VaQn6Mc5SP2b+FG2EpP/d05Xbqd5
nIPCQw3zwCaEeR+7rC2rOnIcjLVu++oC7bt532VXX3eOwwXmTAEfxziH20Wr
eqL7chxy7367lOUW56C5+uPrV/05Djd5Tv+SCEDwa06+Z8qOQ/B3L7acaLE/
zqG90WhbagswPJJLjsxbGudQvz2T8UxZjgOngP8Bn5lxDv1vkjO2pyP4V6Ie
Ca2NRvC38Heu/RKY47DyV8mBeYvjHDw8t3S6eeU4yCauOSW5I85BQPPftatO
OQ4Tjj++MuUM0L1HhY/+s8tx4Ah51rzyGYIvy+c8qYw9Hs4/55t47IR2vENc
oqtZqkuOw6PNH83/eMU7/E+YN1fWP8ehZ3mlknRKvIOlncJH9Shg/Dy3e7+l
Nt5hhdaBnflA99pZp3xm64p3qH94/vyMcgS/9Uia6JkGBH8p/4Gqli5g+E0M
/Hi3Od4BPT0BAHIJFmQ=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbn64+tX/TkOc3oFE37fi3OA8R96fTL+4xEP5x+e
e5Jtf1a8w3WlSsmv7TkOpu6mBQuq4x3OvN+QEF2B4LvqbfGKzkXwb9pWRjxI
yXH48/xp+5+ieIerb92fVsblOOzdZXSwOzHe4eJcsSLhiByH+t76X1IB8Q5z
UibpcYbmOOQvbDslZYHga14pkL0rieBv12Ld8psj3oH5tun9gLAch7Vnr+lM
/RHn8Jr15sQZQPOuOeg+tXgZ59Dmw9j0KirHIY3hYH34rTiHRe6aJTZA++O3
aJmpnI9z+CR0bemMpByHKKvJXz4cj3Pof5OcsT09x2GnlVWvxd44h2OPNvtE
5+U4yCauOSW5I87BW9B7Ql8Zgn/R/tHlg3UIvtK8L9dfteY4KLSX528G6o+a
4rKnryfH4WDbhWvZJ+Icvt7KWfOgDxieznPKWc8gwluPq3D25ssIPiw+AFl2
xrI=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxr3hJK1GCBKa3cygYkkXxZJ4cqBk02olblrvm5oR7jUvUMMU
cyXGcAnDEszyGjkmWkhiWc4U25yu8Eal05aWMk2XiwppKv0/OejD8+EH5/ac
c7anZIrT3F1cXFw57eHkxqnBNirdv8ww7xoXE7BEEXnYLUaxylB4NDf46iKF
MnRGL/zNwHf4dKkmKQIfyLNTbAxeSdqxzhEKq89utW6W4VCJ6eBKL0VaZZIt
aJpBz9uX2dpBsawWy/iTDAn+qicZzyj0givS8AkGke7CVl4NhTmgLKzkA4On
PTrHqKBQ5YlGHEMMRTy/iLgEJ1/se+Oq2ObksctLyiEbwbWB+Hg+l6+KFZUl
vyWgL3o0djM3b3RL3ebHBM1Sbx+FhSFsJaJ9p5qgr6DCVP2Vq5dVlmNQEMQu
XsoMtzKU1LT2e1wnGEgO2TQ8z9A28DEoMp3A69ZMj/AXQ/O4ptacRNb2s66t
6L7yJMHdYr8jWgdD1eLTbLOQYMec5lsvF5/l3i33EBHINBK3XT8Yxo3llS1n
CU7d7jvu+Z3hi1AwMZ1IMJPbpbPPMBQUv6r3SCFI9frjL5liEC9URBlkBBbW
o7WPMwR3yBeUcgJJo+GefZDh0YkbD6s4P8P5IWd0Roa89Xf0hkaC0Pq60uoe
hs4tg0MyPUGF0ddU2MngIfC3bJwk6B9/l25/zfWTzwp0q07WN61aHIF0jV+i
8qYkkaLIPLsg0DNsUGsl5aUU5x1LPMknBvX7hr2N7c57mua6n1v1FPlR4gw+
N79n1efw4EG65u+Y9W976ijF6aYQ/jDnf6LgXGDAFEWtt9B3+SeD34Gseuk8
xf//+A9Tck1q
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4paOhq3dorkOyz8y21XcjXeA8YV33EhUexrv
UBLc5rdAJddB3KhgceSbeIdaWX9mK6Nch+YfLsfZv8Q7tE72lrayy3V4t0/y
9dbf8Q47ky9EudjnOux6N2X16l8Ifh+XhMnvE3FwftAsAz6V3XEOCreKuXsc
ch18ts888WFjnMNuhTm/7zrlOjxeO8H1zto4h8Xe9utUXXMd1io4pFqsjHNw
UD1b4OKV63DP+CfzymVxDkeDU7aUB+U6rEouOTJvKYLPo/j8b/28OIeL0xLd
/MQw+TD1Bcyhty3lch1cG8yeKS+Pc/g8r81ngXKuw4MPR5Y4rYpzONR9dq2+
Wq7DBjdurkvr4hxWbStIKNfIdXh2OfpV6eY4B0FdEcH9mrkOb7Z90l+5B8HX
UL8V2nAKwU9QeTfBan88nD9b+9omwdPxDkfkjBv+AM3LtXuxw+pyvIMmU2Fc
uXquw5LTFjPvXY+H28971VHm8+14h1tmR3Skge67fbCjtulevEOh7u6VbPII
vvLXYq9yWQQ/hEP35XOpXAc+O0eFz8D4ZU1/1hohjhnfMD4ARnDqVw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mlI02EcB3CPEnMxlOVR5thMeiGJQ2mkgX3twBQvbMFQtmfqxkx5yiPv
QNSwUpupeaClK5WyMG0yLQkN50ZeI8TQF6mgtbSWpXbJ6Pj36g/14vvi8+b3
PL9DmHIhQeVoZ2dnzySAiQOTpTwx//AMRYi63XffGzkyFaIrgjGK3cJ3P0va
5FjmOilvKP63a4Tu7t5OOWJi4C3QUOhpCC9lJ0HSy5AIQSeFVpEztRFMsFwr
lgl6KSrf95SWKliHHVVuOVWyLgn1GM1vJzA1cjPMDymG1eNXV/sIarTDFf5d
FPVVOVMnhwk6NWvKS20UDgW8hupJgic892PmBorQ86mFohmC5raznMgq1sbk
BfGZMtYXHSeD/Isp0r189tyZJugo5/+ezqVoehyWtWggEKxar6szKcaiFGbv
IYL4NCRyMiisksGykfsE/Rpdk1VFcTw5sFlbQ+Ch93s1/XcesXnbgXUEXtmf
c9VKCunlqgdUR7C6cavbcI6iZW6XR8E4QWh8b4+VqZ+l7JfNzhMktjrzuooo
dLFBxsWPBLb1AM/vFcx79rFR+38QfHga3MdpZM0dlQ7IOlgXn9ou6npEEZ3x
xZL6iSC2LCuudZCCGxYu2FogkKicG8zPKcSnm2cbp5h+RXqTv5FC4/a60m2Q
9VsfiXbzNmvVxrqLWz7Tv/ucMG2IIkpiG3CNIQivW/iqZvZr6vm1ZOMTbPqp
UmSFFNUx0fXJRuYepJxS8wDrHS1JqdnPWAtH1g7UMv85mM7VW0xy+CbEfZMZ
KGpyPI/YJuTg3JPmZ5so6kQr8zfNcsDlxLXICWY/vCL+izk5DMXcQytmCmeJ
pbzbIse/9/sHix9Emg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{241.265066361125, 124.76413176875}, {241.265066361125, 
       126.51668522}, {241.793832488, 126.51668522}, {241.793832488, 
       124.76413176875}, {243.545135901125, 124.76413176875}, {
       243.545135901125, 124.227865413125}, {241.793832488, 
       124.227865413125}, {241.793832488, 122.476562}, {241.265066361125, 
       122.476562}, {241.265066361125, 124.227865413125}, {239.513762948, 
       124.227865413125}, {239.513762948, 124.76413176875}, {241.265066361125,
        124.76413176875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQrXCryezumzyHM7Y6b7vL4x1W6j2VW/Urz8H2+fSw
3I54hwppnQbLv5j8Vdvu/nEMi4Pzuba3TO30jnNY83rDfud/eQ6stm+Dw1zi
HBIKTBn9GPId5hg/ueDoEOfw0G/2RSmmfIeZZRIGK2ziHAylPJjL2fIdpu/0
6eezjHNoqohiX8Cb75DUcMKbxQzB1+qqSE/Qj3MoDZ5a+fFCHgb/75yu3E7z
OIdqM539Krfy4Ob5PLA76Psgz8FY67avLtA+E1MPp6THeQ4XmDMFfBzjHMxO
rBXRf5bnkHv326UstziHFoavxfue5znc5Dn9SyIAwa85+Z4pOw7B373YcqLF
/jiHR9dM7SzvAMMjueTIvKVxDrd4cjvnn8tz4BTwP+AzM87hlWP6h679CL7+
hqezGjYj+PypPaYnVuY5rPxVcmDe4jiHxfO2C0otynOQTVxzSnJHnEN2HWP8
yll5DhOOP74y5QzQvdLivpem5TlwhDxrXvkMwZflc55Uxh4P55/zTTx2Qjve
Yec2j30Wc/IcHm3+aP7HK94hattC1Y/L8hx6llcqSafEO0yZrFz5e2Oew5zn
du+31MY7MDccdnQGutfOOuUzW1e8wy2zy+E55xH8B5JZc+ffQPAZUg8zRTwC
ht/EwI93m+Md0NMTAGwIDRM=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3cLwtXjf8zyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyvewaiiZuGJ+3kOpu6mBQuq4x3UXbe80LuA4C9o3n5J7yiCbzK55sHm
PXkOf54/bf9TFO9g4Oyd67stz2HvLqOD3YnxDjqfJX89W5/nUN9b/0sqIN7h
+86p2+6syXPIX9h2SsoCwde8UiB7VxLB367FuuU3R7xDnIFlusq6PIe1Z6/p
TP0R5+AWfUcyZ0OewzUH3acWL+McHi5k4dq3Kc8hjeFgffitOIe/c3T+8APt
j9+iZaZyPs7BN+Ombs6uPIcoq8lfPhyPc3jlmP6ha3+ew04rq16LvXEOihbb
r+gdy3OQTVxzSnJHnMOyND+JpHMIvs7Up9FTryH4tZ+/x++7m+eg0F6evxmo
f+tLd5ekJ3kOB9suXMs+EecQYFBgsuUZMDyd55SznkGEtx5X4ezNlxF8WHwA
ACW6y2I=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0sFHAYx0k3RcprixNdJ4rz2puSfI21c52XZHak308XZUm/OGzOiOYl
YaMlrZ3zRyRvnWWXddbSKNNW3mp2icjy0ouXWas01f3ltv74/vHZnmd7ns/z
8KQsMtHIwMDAUBdXXdbpctTYAzmWDMpFVepoEMHdLk6EmzmDSUdBVclxgrin
vOEkWwarrukr0bEEvacqdot2MHDjQ87xzxOszk5smHdiWPR0MZtOI8iLbWku
3sNwur130D2XYO6s2kPhznCHr/qxvozAsbcWMm+Guryx3GQFwUZtupTny/Al
dNmtUUMQI+983ubHkHLQSer0Sc/diz4BUi5dY1HU70fmoRSXdz0MVuj6b6c0
tOZnUhT5By1pfBis0wOVfdUUEe8kH6Y8GDSBf6bCmilmBsLj+l0ZKl83uDVr
KBJoweP9zgyJysKhlBcUHkN7tZU8hmGec7V6kGJMxnubZMeQOS6qNZ6ga37y
/LKcLy1SlNpsGQywYvhqGCay/0nRbUrVUzpf7R3efeMLFPJQVXWxI4NwKa7e
a5biVpq/5B6foelB/7jFJMXf7GOjGheG+n2+NeNaiqvfLHKjBAy+nIQMrwEK
TknQgkbna3U1+2RMD0WZCJzOIwxFqVl1wU0UllkjwvlghvutF+XcCgpVZKKp
mYjh5RvBXGkGhViw/MotXFff8/H9TCyFne1hz84TDJuyrcsP+euZmH2Pn7HX
c7Jc8uz6JMEZO4eWHCHDVteQWXErwbWVzTeiDjD84kdXiPP195QMeJWtpBMk
qdQChW5+h+02xk8ukLX9xCZGhjelBFXCkRLtToYWWWPNaAxB8OeewjYug6yr
fJsynOD/f/wHB1wj6w==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
       324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
       137.844}, {333.668, 133.09}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
        "], {{322.62239645999995`, 
        139.61787444875}, {324.47745303749997`, 139.61787444875}, {
        323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
        139.61787444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 
       114.809}, {261.641, 109.93400000000001`}, {252.207, 106.23}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
       102.85199999999999`}, {251.016, 109.52}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzeH7c+3K8nwH97UW77yLox0mLoyeVtaa77AjbEm4
bku0Q0Lfou+sHZh8VbVXfxmDouD8FrWJ0zzdoxymxKmbC3TmOzSs+Rki5hDl
4PF4dYVUd76D+OIPFxltohxOHhT0fN6T7yDyTMUwwyLKQbJ3X5XzxHwHIc3I
CedMohyyXl+oy5mR73D3/RWfI4YI/tKfLRkK2lEOsce4P+6NxuRX8EzP8zSO
ckheucjsYwrCPJPgrRZS2fkO62Y+93trHuUgs2LfTr28fAfv4lJBHtsoBzlr
lZ7fBfkOL3yYr2g5RTnkFGe/7irKdwipuf77hjeC/93iD7N2FIJvJuw26ceu
KIdTnmu2sqYDw+Nyw9G4hVEOh+ofM+REAsOjPvogz9Qoh0tb7qaHeyH44sox
Qr52CP7360xrp5jkO6hkNR6Mmx/l0C2o1/lMJ99hxoUdp29ujnII/lh+rVQ1
34Hb/MPVkBNA9/b1HpmnmO/QdPhTS+YjBH9Grf9kM+ZoON9zb+7xDvVoh4Wa
+01Z1fMdYpX/Wexxi3Zw0pSYu9cw34FdvE35dny0Qw3brA/HbYDxE+79oaQy
2uH1J8ud/ED37lxV8OVYa7TDoZWe5y2iEPwTPQ9EcpIR/BfXLatUcoHhxxD3
aW59tAN6egIAw7gO+w==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnVOc/bqrKN9B/K9s4u5bUQ4wfsyufyZ7XKLhfDve
a+z1adEOUq8/SUzNynfYsM2xMKE82oF/h1bC7ygEv+ObrtdvfwRfhu1zeIN7
vkN5+KeOPXnRDhLbDj6RdMx3sNCyP+QdG+0gkjahcLNVvsOvP92/b3lHO9zX
4dFbaZ7v8Epg8ulbxgj+EudaubmiCL7RLMGtu1miHdwWr7/3wSLfQcP2sW7o
lygHvXNBEy2s8x0CN1g++/EkyuGkSHVjl22+w8P8sw3i16IcnvIvLr7jkO9w
S9nc/MmpKAfT2/5LLVzzHa6unP91w+Eoh0tb7qaHe+U7mKxy6/uxI8qBc7Wu
z++AfIcZF3acvrk5yqHv5pF+vUgEX4Qj5nJiIoKfmpZ3vSsj32H2t+aC4p1R
DnNj9u3Wy893sPl257r2kSgHi8XPVjcUAsNz84qKo8cR4b2ysnZO8XkEHxYf
AOPfxJE=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EYxeeKJLxUCKFllykl3grCKI3cWRfGVCrSvLxv2VLMmNKrG3Yh
TSNN1BSnEsIU724MqWG6XN5oLkc2nSmzxGmJJqEpSFhmdPl/UujD+XB44OE8
v+cIEtjFpE08Hs+Bkx8nPqd5fWScdYohOZ2E279R5P2+JxFMM/zS5vkc+kph
+XO1f+Y9Q5HMwxgxSXEtYTmN/47h4YB+InuYwt9WWxpvYXi29iGo20ShSbQt
mswMotvH0zIMFEJiken6GEYKK9WBLRRbf0zHjvcymANl+80qir2fnY/5Gxhy
pFGKgiwK6+n+UVU7w99b3iddIzf8RPAgX+S54S+NbS4qmyfoqLRG6ToYHLtj
KwSvCOpzQjXKHi6vvqdhvIZgWZDnJDAytKZKOmceE7iI3SzCfm7fxxpFfhZB
acfUzfEBhi3bjRZTOoGbn3aHwspwBLMH+NcJwsOkppkxBt+I9npVDFnnk3tQ
+UQiJhg+pwwO4/h5SLvkKiFBUqvX7A2O14J86I6Jmz9NG3F4zfGKCW6okp8n
KAs/I2oeZKDPQ6aaogl8T53oUb5h+LlibjRdIWgeZrtXTQyDl5vF+ckEXkdD
tUqOV11A7pJEQaBSiCqUbQzuhkfV8cUEO89qL8S3MHzPLDfnqwnupniWCNUM
IcWTo/5GAruy5O3+eobsap9PVjuBa5NYpqxhWJ1bOXx/bcOL9jhNd+6i6z5I
p85xj6YwNyQuDmkYCngv4qILKWr75I6rLxmcQ9sCUvQb/xQTa7vGSNHraknV
cfkfuCyEzFno+n2GGMcubxtFeYZ2m2KIIXZJus/O9Wl2tMutysZQVpfZ6PGF
4v8+/gN8PUXo
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4uMBv7Zo/8h3UEoUsLe4Ge0A4/epP0169iDa
4Q4vg/oC5gKHSQtrlki+iHZ4UJTCmMtV4PAvPfDE8ffRDk/WJvHmChQ4ZOqp
vSn9Hu3wT1RV9xOQbxq3cE32NwSfs0rFdPeRKDj/LKct/5NtUQ6GF8tYpwkW
OBxXW3Zyw9ooh/ovXX/3CRU4xMnOdZuzMsrhc+eda4+ECxw0Jvik/VgS5XCw
TNmiSKzAIXIxK2vmoigHFr73N7ulChxULzccjVuI4LdP+PzPflaUg0j8bdd3
QP+g82Hqb6amv81hKHA48N7p+WOgebONGdQUgP6NTri4lGlZlAPTqsXX0lkK
HLS3iXNPWhXlUGb/dX03a4FDonPGa9P1UQ6rfrl16LMVOKSr/TfI3IHgL572
LMzhGIJ/Z/Kvib92RcP5YrMfbb54LNqhufia/TmgeS/Wftn561y0g1nq13Xc
QL68teuseZej4fZ3uPjJbr4e7dD3X27aXaYChzDDqXVOt6IdblXNCrnMgOBv
vvdtCTcSf/qFZS/a/+Y7dK71VdwMjF8P/YTWHz8x4xvGBwDu//Hp
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB3CiWUxr5aGU3c6pZTo6yTHG+05yhSxPO79v7KrJzpJvUltP
s5yHbhdjIbIRKQothDrDdBySYp46MnqwSJvW+Yvt6tdfv63+eP/x+uP72Wef
95d/Ji0qycLMzMycjZDNJjZFvA8FKQzFi6kGwcw8g3i72GBFNEVeodEUdJ/B
3ZUeURn/f2vaux8aqhgMWifYKnwpDs6F2LmYE0S+jRcogil2j2aONHsS7BDK
PRZkFJsZbZbkFOdXT+maPofz+hMXnbiCIMfzyGFxKIXf9KS6vpFA6b0neJGd
t3Ujc8RSS5DRIPIqAMXNb7zS8AECU2ooTxxA0TaXdu3nCEFqa3LOmg9nyxL3
iqtenGeTXHYtelAs5rnZnx4iMO4N/+1zgGI7Pyy9sodAJG/Vq9wogrTn38+2
ERzbOdc4uY/iXJ9OlVlLcN29NOyoK0XXqH+5QkPQGBj5vf3vPbqy1lfzCTyc
27QqAcW48V6D8BmBQ4JmQsS+tw91cPTtJwi8UxynZ+f/GO9JLJ4geCeSqGvY
fYTdgfrKZYKq2WjNsDdF8kUm7KORwLF3ajo2gPP+kOUZk5TzfK5fVw17v4EZ
syXBCoHs0eU65wgKdVMEv9VAMOwgOd5xkqK5o3YybpDg0g3Hs4tsv1tuLWnG
Wjgr8hXVLeWcFxQbNmPpBEMX6rdln6Do11m9HJURSJsa1lVsHxJnm0+dTgQV
V1afm4QUVl3yYn4vA1mhFB3hnF2bU0TqSM4tuuaiMnafaoNT++PXDA7lf103
RVFYfxH4deoZ1ImV/uoYCtsHq4aYNwykysS+jDi2H1Uu7/Y4AwuXvpJeOUWW
7le28jODf//vHztSSVc=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE1Acxr1VItOBsVQq00UtamlkkVHply1MxSB1GueAyrwnzeO8baWo
6JrTNJYgXmr2oBuWBGVKeSHRvHRDy4JEJUWTXGYTxW5QnSeFHr6HD/6373eO
tyIjIsnexsbGlms/lx1XQtyfwspLDB7x3aqGQALRSYsuMY2hdK+hJiSYQHVC
HWKvZKjyXSnaFk1g1vuuZmUy1IzIU2YVBGdGY+YGshjSG/1cTEoCB31Pu2su
wwfxu7dfNQRPnIO+71AziKq7fjzTEUQGHityvMKwy7pQeKCWIGTY2xBXwJDc
81ea1kFgdR8IkhQyfDYdSpib3vAB8YEQu9F1P9C/5fHoOYp8Jexu8/6tU233
T6sodL/KLrby+Tdmwxv11RSLw9UjvXz/0QdOn1zMFP4yYVUHv08Q8Eia3kGR
W9HSnZbNMO18c+xgH8WErPiVm4rhvOFwbc5riocidWgJz78cHnNnaIKu8/l9
VyvxWaQon1cOL3F+KZkkbHKFonmmphO83kcS8ML4haLY7uk9V86rPz7NZJ2l
EIo2C8Sc1x7PyY9vJin668rDpTkMXk0yo/E9hTbC6qnJY2jLZrnWlxTBXvoY
Kc+jvlwW5dFL4VSsU7Ty/LYz2mYHE0W4e6TDYAnD7p2aqxMVFNs31SfJrzGc
lR23hGVSWJanB+fKeP2Rb1PmaIoLqaV50nIGncWr6qf/hh/Pt1WY3Tf8/EJi
X+gUwWrqWnullsFQJ18QtBA4ji/t0+QzZFcrDIKCjfccCzxV2ckI1H5Ba7f4
/XXXvR0Lksl6viGN0C4qlkBoM9bUxflKZtuNDXKC+dHnYkkGw5JvvUdsGMH/
//EfCv8qpw==
       "]]}},
    AspectRatio->Automatic,
    ImageSize->{388., 165.},
    PlotRange->{{0., 388.}, {0., 165.}}]}],
  SequenceForm[
   $CellContext`Dia["A", "A", 2, 3], ": ", 
   Graphics[{
     Thickness[0.002577319587628866], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
        388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
        0.33199999999999363`}}}]}, 
      FaceForm[
       RGBColor[1., 1., 1., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
        24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
        3.9919999999999995`, 13.508}, {3.9919999999999995`, 
        24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
        45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
        24.836000000000002`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
        21.99788154, 23.851453813124998`}, {18.552508993125002`, 
        23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{111.074,
         44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {94.133, 
        27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {77.191, 
        44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {94.133, 
        61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074, 
        53.512}, {111.074, 44.156}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
        59.891, 34.656}, {67.65599999999999, 36.809}}}, CurveClosed -> {0}]}, 
      
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
        39.508}, {68.684, 33.461}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
         "], {{57.68489645999999,
          38.21162444875}, {59.53995303749999, 38.21162444875}, {
         58.612424748749994`, 40.420441815625}, {57.68489645999999, 
         38.21162444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{384.125,
         140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
        363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`,
         129.164}, {343.10200000000003`, 140.49200000000002`}, {
        343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
        363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
        140.49200000000002`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        357.65797799312503`, 140.37615644875}, {361.10335054, 
        140.37615644875}, {361.10335054, 139.507703813125}, {
        357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
        140.37615644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
        71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
        147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
        80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
        156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
        90.35199999999999}, {173.45700000000002`, 80.99600000000001}}}, 
        CurveClosed -> {0}], 
       FilledCurve[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
        
        "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
        62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
        77.762}, {132.35500000000002`, 70.23}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3cP5P0b4S6SD+1qLd96XAx3mbTqsu5Y/ymFH2JJw
3SeBDtY9gR9Oi2DyVdVe/WXcFADnt6hNnOa5PMBhkU50/gOxKIeGNT9DxBYE
OHCbpXz6IhXlIL74w0XGOQEOfJ/1J/fJRTmIPFMxzJgR4LC2s/Obm3qUg5Bm
5IRzUwIcAtzW/ZthGuVw9/0VnyMTEfylP1syFLoDHEz/KD+23hOJwa/gmZ7n
OTnAweFQYN6ic5Fw8x6Jlhd9uRXpsG7mc7+30wMcNu/vLJF9GOngXVwqyDM3
wGHb0xDJ7c8iHV74MF/RWhTgEBT2+PrVl5EOITXXf99YjeB/t/jDrL0LwTcT
dpv0QyrQQYA5Nef0pUgH1csNR+MYAx3+5V1mmrE90qGlPvogz9cAB7mbxy/k
zUTwV2w9ohrViOBnyAtFv8yNdFDJajwY9z/AYdKkDOHeuEiHGRd2nL4pHOig
GPRn7Wr/SAdu8w9XQzQCHbZ1q3f9dY90aDr8qSXTCcGfUes/2SwZwffcm3u8
oz3QYe+hrpxTQZEOscr/LPYsA7rvoI21dUakA7t4m/Lt/YEOxTUOj/zrIh3E
w70/lNwMdAgMbSi+PyPSYeeqgi/HngY6/D80f77hTgSfu/Os1ozTCL63fMNX
jvvA8GOI+zT3fqADenoCADBlHPE=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHRT2+PrVl5EO4n9lE3dbBTrA+DG7/pnsWYLg2/Fe
Y68/FuiwzvWT0aubkQ4btjkWJlwPdJh1P/Hgtl0Ifk9MxtRtSxD8LdWfNhyY
HOlQHv6pY8+5QIc1t/tPfW6LdLDQsj/kvTfQYbG17hO1qkiHX3+6f99aHehg
eVIlVqgk0uGVwOTTtyYj+Euca+XmliL4RrMEt+5OCXTg2Ja9b2FZpIOG7WPd
0JBAh+vcm5QNqyMdAjdYPvvhEujAO5OJ5Wp9pMPD/LMN4maBDq79QS8qgPbf
UjY3f6IV6PBEdY23YX+kw9WV879uUA50kLt5/ELezEgHk1VufT8kAh16j6bP
3LYs0mHGhR2nbwoHOsxQmqYgux3BX1R/ZHnzcQTf1ebl+qtXIx1mf2suKJYE
+l+js0L2caSDzbc717VVAh1ebb0ZcfA5MDw3r6g4qo4I35WVtXOK9RF8WHwA
AJEkyRg=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI0wEUxucSJdIyAnOENC9ZlmaYXZTMT8RsJvX//712arKCCCzRZmmI
puZlLbXwltYSnbeJPWhOXaZ2MWlYLjNLNJ2ZCx/UjAjvhO3JQQ/fw48Dh++c
73O4GMdd2sDj8cyM2msU36gzerU6uptw+RqdGgvlkB1jXszXElYbsnfvD+Gw
LbYvX9ZCyI0RdIf4cvD1+jXZU0fIfNc2mnaAw4DgtGNqOaFxZdiry5nD+8Oa
MVExwT/paPwNAYclp9ohYR7h090ylbsVh3zxx2ZpFkHrHiPUrrJ45u0SZ5tE
SJeEJcj1LASLZfWLcYS1RCffzWoTj3rr+P4pJg4fMs8tDGYxXfmkQZhIsOyK
KnZwYPEyXs4aMox+215Uj6wxEKtt7fhyQvNVUYdhlkHJX8+HfgXGfd8qEmR6
BoqJ3nHpI4KFTXdfzwAD5RuJc101wRM/dvHfMthqrpPLmgmuIa1VCg2z/p8s
l4IHIhWDHdYe18NeEwSSTqmigkHgZ7a3QE2YkX642WOcDzNPzYPrCZHe1Y+l
jQwqLEoyrSoJ59Q+47VtDHR/bqcaSgnL89qani4GWpvZI033CLrzdUEyLYNX
I3fCDZkEpVvWnGiQQXPEfVdDLMGuPac8+icD1bKkKkVMWEgp0sosWcSeCLT3
CyX45OsH9zmyOFjkWmYmIqSV757oP8aitF3xZTKAsDQ173GLTOxvv+l7R7KJ
vZpU6XZtLDZqBkfFEQQ5T3M2YprF84XfW5qSCVbHW9yu2JryDKL+1npHDit5
NV+FRv8Z1jM+U27c+n3tkZadToc4VNIFYZ2SEDUn2Tlm7FPA9pw9S42EQmVK
jeAkh//7+A94lDen
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYk5Bxmzxr1EOSokC9haWQQ4wfp/606RnDkEO
L5fxzHUQjnaYtLBmiaRHkMNvq3lsJXrRDv/SA08c9w9y4FKfblbiFu2Qqaf2
pjQ8yKHo+IKtHR7RDqZxC9dkhyH4nFUqprtVAuH8s5y2/E/EAh0ctzwXk/CO
djiutuzkBt5Ah3JHi++7/aMd4mTnus3hDHRwn14X4x0S7aAxwSftB0ugQ4PX
rIcdcdEOkYtZWTOZAh26l5/IeJ8X7aB6ueFoHCOC3z7h8z/7XwEOS3QP98z5
FoXBh6l/yLZqWzFbtMOB907PHwPNe2HLO9NBMNohOuHiUia2QIdW8dnR8WLR
DtrbxLkncQU6hOY+PPBOKtoh0TnjtSl/oINylIZSnWy0Q7raf4NMCQR/8bRn
YQ5qCP6dyb8m/pIKgvPFZj/afFEtyKHTNo3hp3S0w4u1X3b+0gtyCGZ5tOed
RLSDvLXrrHnGQXD7O1z8ZDebBzlsye2INBOIdggznFrnZBXk8CiqLJiXA8F3
e/V8yjsWBH+lQNSl8/+jHDrX+ipuBsYv97kz3Bt/YMY3jA8AOhnSRw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYtmWjTm7BWIc0gujvO8EBzkoONbyhorEOBgv
vMp9KQjBv/zmcoi4QiCcP+PCjtM3hQMdQqsYA+PFYxzi2+Z4zeEOdFBVEQnu
kI1x+FYz+Xg7e6DDt7NqoRuVYxy+7D+u9o450CF11zHZnwYxDp/CTii9Ywx0
KLpywPWnS4yD6uWGo3FI/PYJn//Z/wpwEP/SHK+9IxqDD1P//qXO6vaT0XDz
tD6KnI27Gg2374Txosm1d6IdtHwl2CdxBDow1u0T2f0k2mFymGLXMp5Ah7nM
DVYOL6IdGG8d9HsnjuDfPJ81y0sTwc9PUcvyEQyC8ysPhnzcpBjkwKD1qVzx
cbTD03ZN0UTNIIdjZdc+Pb6B4MewnMs+fwnB/2D7013xdLTDE+PYiuPqQQ4t
yhHtNw9GO3ismx3kpBLkIHtdamkckF+tFfJ1k3KQw0u2aakhB6IdRO6JCVsA
+f6vLjuf3xft4B51fusKpSAHaSl/lqN7ox0e8E66rAvkS270Zzi6G+E+idjm
ZO1d0Q5uH89vXKEQBA+/ityOEEkgf31w1QOxbdEOq6/wTlCWD3IQNd+xb+KW
aId7AceMpsgh+KLuYuIWqkD3oaUXAPbO82g=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcxx0VbpeKzqY/nEuU/3VkVs67RUtSv98PpXwPo5jJdKVitKwy
NX/PNfmzjq3rNG12JUZhQ1G3XZxrolyK0PmTa7ab8qDukdt68Hrw2j5P3u/3
xzU5i7lgZWFhwTLhacLShO3iepaxmcApqfNyXT0FbWIrj2kiuOMuqYpopBAu
WnRXdxKU+S0XOLZR2F6l0pSrCKoGY9OmeikUKTMqP2oJMuoFdor3FEqllqNs
HcEo/8Pw4hiFRMXWL4JpAq701crrWQqqi3rW5AKBi0F/02uFQkOFNFz4hyC1
6693uiMNoZbHEbFE+KHwT/kOswuTQsG/bvY3fdbtQ09oZO61YwesEjjoWpoP
D9OoOeufIl4iKJ+Kqr+3TMNXGh/aN0sQ+Iw9bWfNIL4gIrh2goAjfOGd4cjg
9MPny6kjBF83Vmp9+Az0t7YIXNQEJyX7q6/6MDjav+Cp7ib4FXWmYeAgs9bP
alOhh+8JBo9s3/LzlARp4nOR49EM7I1p871dBL4eQpUskkFBro2S/Y6gLyld
YTjCoKPPbd8xDcFu5/EJzSEGxSMHgsRjBDx5mEwWyEDSoc6XTxK0ZF+6ZvBi
UG3wTxQvEuRk3o1x4jFQXPEsFluJwPpW+HjdBgbKoTj7UQcRdu3Mzfs8T2Pu
dvYDrrMI4WHBc5EaGm5BFTui95juA5Z0jW00ejY7T4h9RCia45X9rjb7WD4r
uTHH7DP6873HQ2iccpgZNW4TQVITq+fY0pBpB+RyI0G2NFnC0Zn31IaGlL4c
opAQwv0kmCKoKXG1udFPreUbyN1kGdNNoT0r7n7zIIHHVKusrpUCt0VQQnoI
fvrVOiU8pfD/P/4DlzIqgg==
        "]], 
       JoinedCurve[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
        138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
        56.516}, {119.85499999999999`, 51.789}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
        110.84400000000001`, 47.38699999999999}, {118.293, 
        54.922000000000004`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQze77c63m5wSHrqjCO9OzfBwmLIye9o0h0SF3rcf6
qB4fh/i+Rd9bmTH57j5XfjNreMH5bL5KupOFvBwmx6mbT2BJdPgb8XmlDouX
g/vj1RWz2BIdtN0eLmb+4+lw4qCgZzpHooPaGc+kC188HSR691Ud5kl0UAza
pDD3radD5usLdW+EEx223185s+M5gu/xmfOiwy1Ph5hj3B9trydg8N9I6N2d
9MrTIWnlIrPCBwlw84yDt1rMepbgEGF8fu6tz54O0iv27Vz3MsFh0rNXShL/
PB1krVV6qt8kOJyZybYilMPLIbs4+zXXuwSHZT/Wfd8ojeC/LvzBHmaB4Geq
9ah8/OnlcNJzzdbWRwkO7ssYu/ce83I4WP+Y4c2VBAeW/9uaJNd5OVzccjf9
+lEEX0w5RujsTgT/23WmtSIbEhxcrzA17z3k5dAlqNeZtiLBQWdh4fTNr70c
gj6WX/u6IMFBOO/B6pUi3g6yfb1H5OYmODC1P+W87IHg6/yep5bbheD3V93u
E7zs7bBAc79p66IEh+1ufworBH0cHDUl5tquTXDg1uNx3+bs41DNNuuD+w6g
/nXTHrws83F49clyZz/QvfmhD1/09vs4HFzpeX7HVQT/eM8DkTf3EPzn1y2r
lrxIcDjHuOeJdbOPA3p6AgDRphxC
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnV2c/ZrrXYKD9i/rQ2WW3g4w/paSv5kVvD5wfpXU
Gv5/AT4Okq8/SYg+S3CIyW1+dKDIx4Fvh1ZC9TUEv/2brlf1aQRfmu1zOMPh
BIfX654IVib6OIhvO/hk5p4Eh7yQupbpdj4OwmkTCo23JTh8/Cn+fau0j8M9
HR49zc0JDpcU1aZvfe0N57u0/7KxWo/gJ5koZ5X3eju4Ll5/r2BLgoNP1bHo
VTneDrrngibuAJo3P6H4zEdfb4cTItWNXDsTHPbfn8Wob+Dt8IR/cXEM0P4N
7nl5JyS9HUxu+y/dcSDBYXmw/etEbm+Hi1vupl8/muCQFtIr8/GrlwPHal2f
6jMJDjoLC6dvfu3l0HvzSP+6Kwi+MEfM5Yd3EPyUtLzrXE8SHIzfsj989s3L
YU7Mvt3rXiU4lLzZuT6cx9vBfPGz1QxvExwq0wI/dgkjwjvg8y+L50oIPiw+
ADofwRM=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pfbgiP9oxIdTj3aMm1Htq9Dy99qz4UxiQ5f
Qrn9Y2J8HU7/iz+WHJzoIHLVqGWmna9DQtLHgiafRAfmqbnb/6v4OmhdXTDh
nnuiQ9TXjZlVvL4Oy5OvvnVxTnSof1fw4NU3Hwe7qDNZBvaJDgtFDf2j7/g4
cHx/GBFpnejQE33FoW+3j4PsUx7z1SaJDv8OrHgmVO/jcM752GVpw0SHX2/d
qmS0EPzNxbNYm/Z4w/nL1nCKqUZ6O2yfcT7EAKifq2qjhjObt8PCBrsVglaJ
DkK5te6bD3s5fFBs5V5om+iQcHNS2fG5Xg487sJn9jsCzdtv/5yv3suhf8e9
vEg3oH6Flpmd6V4OQlqrBD97JTokNpzwZgnwcvDySjiSHJTo4Dcjy9Xc2Ase
Pmy+SrqThbwczvtNtDwVmeigf6DiqRmzl0PKJqUnL4DqLz+d87FD2MthbcEl
RlffRIdVRW6WT5W8HCZ6uziqeSY6bEkr3eNt6OWg4WS9T9A10eHD637PTnsv
h6UX8qUrHBIdpu306ecL9nJQNLVbJQgML/tIjruTs7wcZhU7ThE0SHTQK+K1
3jvPy0HUdVXAPfVEh5c/1fr5L3s5VGTL9O1XSnQoktq9PJzD2+H2xL7TC2QT
HX5b+R+Yb+vtwLvUPUtQOtHh3dnX8X8qEPw6K7FD5TsR/NQEf0ZDAx+HY4uT
3/qpJDrwM+ZtXjPDx2He4SL2CjNgeqjJiLz2ARGf3VvmZQdy+jrs4zuTYwB0
/z+pa6VnZH3h/stfz1fhrufrMKl0Ff9noP/X3Tlot8Pe1+Hx5T3CMoGJDkrO
Pz2MQ3wd0NMjANbYGCE=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4mMBv7asLk50cDykUFdg5usA40v4nzp6xtXX
YZs0g9+BpkQHJeefHsYhvg77n55gipqQ6PDj/KIJ/cm+Dsejj0pFzUl0OB/j
c+N1ka/Db22vqJS5iQ7pe5wirxcg+PxfPLLKeL3h/GnCVXInPno5JC16y7Vm
XqJDt6/P5MT7Xg5/X4j+/rsg0WGHlVWvxXUvh6fCO9e6Lk508FGYeebDWS+H
prduBSkrEh3Wu3FzXTrh5cAuc2/z9A2JDu7LGLv3HkPwuRWf/63f4eUgHH/b
Na8Ekw9Tv+n0uVuRNYkOtfdbzx0/6eVgms7gc6Ax0WHLgUXerBe8HFhC3Nf6
tyQ6BOfoi6nc9HJ4U/cqfnpbosOBtgvXsh95OQR/7RW4357ocMbnX+KlLwi+
i+7ZtQ0C3nD+FvWvyl9/+sD5WmZH0xcL+jqwPV9TLwPkn4t+WfxV0dch+9Sr
2OmtiQ5WZV0mttq+cPt5OudYpRn7Osj8t9WxBrpvZZLW3xYLX4fNX01WqtUi
+Kl733pOr0bwp11Y9oK9Ehj+0bOd0sx9Hdz1E1orSjHjG8YHAAMf76o=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4oCuS1trGZMcTj3aMm1Htq/DxQyLNi/mJIdk
p9XiSzIR/EU3l6/UY/GG83UWFk7f/NrLIbv11/LzLEkOu3ksp1rc9nIIucWs
+YQ9yeHlT7V+/steDjb6vKt+cCU5PKnv971z2suhRDW2b45gksOjtRNc7xz3
cqgyilo0RzrJwX0ZY/feYwg+t+Lzv/U7vBx8D1mvN72aiMGHqbe0Fbj6+G4i
3LxrDixp5x8nwu1TfeR1Mu55okPgLAM+lateDo7sNztrXyc6KK91EvG96+XA
f2qnjMPbRId/m5vn3vmM4K+bf9Vkqpg3nH/7hM+VGc984PwPTSsfpbL7Ojje
Ldq94VWiw3H+YK1DYr4OS5if/pj4FMHPP5Wwtf0Rgm+ZXrZ4w71EhyPpuz70
Cfs6MN9SPcxzK9GhN8Z8aQuPr8MFY/ag8zcTHT6FrHiVyu3rsO20i5EXkK+6
R1etgMvXIWNv8sL2G4kO3VvmZQdy+jr4hS5sZALy90qrLI/m8HU4t2BhPdN1
hPvOlllvNL2W6NDxaH5yIKsvPPze3RJYacTi6yD5aVu+9pVEh+CV0gruTL4O
px9fvZdxOdFh58KeVA1GBF+jT0evgM/XAT29AADTQQUn
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        146.52642112112497`, 55.48896844874999}, {148.49523116799998`, 
        55.48896844874999}, {148.49523116799998`, 54.99270331312499}, {
        146.52642112112497`, 54.99270331312499}, {146.52642112112497`, 
        55.48896844874999}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/aaggYOXOdmhK6rwzvQsH4fSo48+3BRIdshd67E+
qsfHwWWTZlCmMCbf3efKb2YNLzifzVdJd7KQl0NF07qJxSLJDn8jPq/UYfFy
0GE3vlwrluyg7fZwMfMfT4e1T2cs9pJIdlA745l04Yunw98NrleXySQ7KAZt
Upj71tPBjz/i5nnlZIft91fO7HiO4Ht85rzocMvTwfHVJG/F50kY/DcSencn
vfJ0cD+rOTHkQxLcPIlym8m135IcIozPz7312dOB4YyryKSfSQ6Tnr1Skvjn
6cAUv/pZ3J8khzMz2VaEcng5BEz/5Prub5LDsh/rvm+URvBfF/5gD7NA8DPV
elQ+/vRyWJdrLJD5KcnBfRlj995jXg7LFmdFn3+S5MDyf1uT5Dovh203Ug7t
uorg/3Z7nLPhJIJ/+3cn+4/9SQ6uV5ia9x7ycsg33frYc0eSg87CwumbX3s5
mIv+N7i5IclBOO/B6pUi3g5Mm0TkmdYmOTC1P+W87IHg6/yep5bbheD3V93u
E7zs7dDq6zYhY1OSw3a3P4UVgj4Oar7zvyvsTXLg1uNx3+bs45CgpeitfQKo
f920By/LfBzOix0ULga6Nz/04Yvefh+HZWcvaM55iuCv2ZCef/4dgn/m94Er
7T+SHM4x7nli3ezjgJ6eAByxFYQ=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHTD9k+u7v0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg4/OOrKv7xNckhJrf50YEiH4fPtzfuinuG4OdIbV0SdxvBZ9Cq2vT4
UpLD63VPBCsTfRz+3PSwrz2T5JAXUtcy3c7H4Uen+BmxY0kOH3+Kf98q7eNw
OGByB8/hJIdLimrTt772hvNd2n/ZWK1H8JNMlLPKe70dtI6bWYYcSXLwqToW
vSrH20Ho083Xs4HmzU8oPvPR19thrQXTnbcnkhz235/FqG/g7XDSWOucPdD+
De55eSckvR0k/1/7P/tCksPyYPvXidzeDttupBzadTXJIS2kV+bjVy+Ht+e2
LIu7k+Sgs7Bw+ubXXg5Ff71fTXyC4P/Qfqx79A2C79n11fDd5yQH47fsD599
83JobHAVm/QryaHkzc714TzeDjLHc9me/ElyqEwL/NgljAjvgM+/LJ4rIfiw
+AAAdJjPwQ==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxueByANoM6NNnbRqmKGbaUq52WMesm/fNw+UJtPM/V0zvFgJ
YZpp4kAtQsJKQ0pSRGUe8JRWRi7LPBU1D4XRmpGCM8JDCe2i9V1N6OK5+MHz
wvs877tHpU1RO3E4HAdWgawcWbk+PMjtCCAQD19ZDHeioE1zEipFBNsYYVAN
l0JAqn9znZiAl7XkECShULN+y1oYThDYoH83epLCeKlp3i+SYDpK40tnU6DX
2q4NHCPojGtt/lxAod/aw5mKIRCJCtaqaiisZD7gNp0gkJqnbal9FGa1+WHJ
CoLxIlu6cZXC/h1Pas3JBG+Z7NGxOLmdC4dLrsf2bHFFhcfFR940pENdu6bY
+b1PNZnluTRSZjBiSSDgv6mP8tLT8L2U2u0VR6BReU/4GWn0aphgGwh2Fuem
z63SkGyW3VRLCZ777GtRbmdgzQ3RGyII7gvVkhUBgzZX/5Y6CYGpvhPVkYy9
n1+n3RIzMhiktbs3aQ8QTHzruzeYx6C6MaPCi/WnK4rvyJQM4r+3Xxg4TFBu
MNILcgYql8jAuSME8dLBF00yBpPc2A6LjECWUCWViRkodB5JuuMEOcvmH2Yf
Bh/8ow0Wtq+f855th5wZnFmQfbSkENgMbnKX9zRMHrN8gZIg9uj65uN6GleX
VV+k5wgqK/Nnas/T2D2y2qBUs36N6VliCI2lrgiHFQ2B+2y078ZvuZ27/ji+
UvRv8dj0uO5ulBxB3T4lHWcJBKF6I2+Owqnb7jk6mmBR9FrIK9m6Z2NpEf+y
mkJYfO/fSXb/YF6MpzWJsue7sSFwbgWF7K8zShc2Pz2aJ4sQU/Ase5lmDiH4
lBUWOsSn8P8//gPm/hyd
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{242.777,
         101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
        84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
        208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
        101.48400000000001`}, {208.89800000000002`, 110.84}, {
        216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
        118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}}, 
        CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{
         0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
         101.01833734875}, {228.42917790875003`, 100.1214467175}, {
         227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
         97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
         100.1214467175}, {221.98906566875002`, 100.1214467175}, {
         221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
         107.2353207}, {227.01602828000003`, 107.2353207}, {
         227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
         101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
         225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
         101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
        94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
        88.67999999999999}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
        172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
      FaceForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 
         0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
         
         "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
        97.30146844875}, {187.73723616800004`, 96.805203313125}, {
        185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
        97.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
        121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {
        282.441, 114.262}, {274.85900000000004`, 121.848}, {
        274.85900000000004`, 131.20299999999997`}, {274.85900000000004`, 
        140.559}, {282.441, 148.14499999999998`}, {291.79699999999997`, 
        148.14499999999998`}, {301.156, 148.14499999999998`}, {
        308.73799999999994`, 140.559}, {308.73799999999994`, 
        131.20299999999997`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{238.125, 113.293}, {245.82000000000002`, 
        117.87899999999999`}, {255.996, 122.754}, {265.42999999999995`, 
        126.45700000000001`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
        274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbSlfh3n1ByHM7Y6b7vL4x38bj6cdm1RjoPt8+lh
uR3xDrLHNH6kLsXkr9p2949jWBycz7W9ZWqnd5xD4LS15gXLchxYbd8Gh7nE
ObBKG1VWrchxmGP85IKjQ5xD28/pnu6rchxmlkkYrLCJc7h2xKV68boch+k7
ffr5LOMc1JXD689szXFIajjhzWKG4Gt1VaQn6Mc5SP2b+FG2EpP/d05Xbqd5
nIPCQw3zwCaEeR+7rC2rOnIcjLVu++oC7bt532VXX3eOwwXmTAEfxziH20Wr
eqL7chxy7367lOUW56C5+uPrV/05Djd5Tv+SCEDwa06+Z8qOQ/B3L7acaLE/
zqG90WhbagswPJJLjsxbGudQvz2T8UxZjgOngP8Bn5lxDv1vkjO2pyP4V6Ie
Ca2NRvC38Heu/RKY47DyV8mBeYvjHDw8t3S6eeU4yCauOSW5I85BQPPftatO
OQ4Tjj++MuUM0L1HhY/+s8tx4Ah51rzyGYIvy+c8qYw9Hs4/55t47IR2vENc
oqtZqkuOw6PNH83/eMU7/E+YN1fWP8ehZ3mlknRKvIOlncJH9Shg/Dy3e7+l
Nt5hhdaBnflA99pZp3xm64p3qH94/vyMcgS/9Uia6JkGBH8p/4Gqli5g+E0M
/Hi3Od4BPT0BAHIJFmQ=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbn64+tX/TkOc3oFE37fi3OA8R96fTL+4xEP5x+e
e5Jtf1a8w3WlSsmv7TkOpu6mBQuq4x3OvN+QEF2B4LvqbfGKzkXwb9pWRjxI
yXH48/xp+5+ieIerb92fVsblOOzdZXSwOzHe4eJcsSLhiByH+t76X1IB8Q5z
UibpcYbmOOQvbDslZYHga14pkL0rieBv12Ld8psj3oH5tun9gLAch7Vnr+lM
/RHn8Jr15sQZQPOuOeg+tXgZ59Dmw9j0KirHIY3hYH34rTiHRe6aJTZA++O3
aJmpnI9z+CR0bemMpByHKKvJXz4cj3Pof5OcsT09x2GnlVWvxd44h2OPNvtE
5+U4yCauOSW5I87BW9B7Ql8Zgn/R/tHlg3UIvtK8L9dfteY4KLSX528G6o+a
4rKnryfH4WDbhWvZJ+Icvt7KWfOgDxieznPKWc8gwluPq3D25ssIPiw+AFl2
xrI=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxr3hJK1GCBKa3cygYkkXxZJ4cqBk02olblrvm5oR7jUvUMMU
cyXGcAnDEszyGjkmWkhiWc4U25yu8Eal05aWMk2XiwppKv0/OejD8+EH5/ac
c7anZIrT3F1cXFw57eHkxqnBNirdv8ww7xoXE7BEEXnYLUaxylB4NDf46iKF
MnRGL/zNwHf4dKkmKQIfyLNTbAxeSdqxzhEKq89utW6W4VCJ6eBKL0VaZZIt
aJpBz9uX2dpBsawWy/iTDAn+qicZzyj0givS8AkGke7CVl4NhTmgLKzkA4On
PTrHqKBQ5YlGHEMMRTy/iLgEJ1/se+Oq2ObksctLyiEbwbWB+Hg+l6+KFZUl
vyWgL3o0djM3b3RL3ebHBM1Sbx+FhSFsJaJ9p5qgr6DCVP2Vq5dVlmNQEMQu
XsoMtzKU1LT2e1wnGEgO2TQ8z9A28DEoMp3A69ZMj/AXQ/O4ptacRNb2s66t
6L7yJMHdYr8jWgdD1eLTbLOQYMec5lsvF5/l3i33EBHINBK3XT8Yxo3llS1n
CU7d7jvu+Z3hi1AwMZ1IMJPbpbPPMBQUv6r3SCFI9frjL5liEC9URBlkBBbW
o7WPMwR3yBeUcgJJo+GefZDh0YkbD6s4P8P5IWd0Roa89Xf0hkaC0Pq60uoe
hs4tg0MyPUGF0ddU2MngIfC3bJwk6B9/l25/zfWTzwp0q07WN61aHIF0jV+i
8qYkkaLIPLsg0DNsUGsl5aUU5x1LPMknBvX7hr2N7c57mua6n1v1FPlR4gw+
N79n1efw4EG65u+Y9W976ijF6aYQ/jDnf6LgXGDAFEWtt9B3+SeD34Gseuk8
xf//+A9Tck1q
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4paOhq3dorkOyz8y21XcjXeA8YV33EhUexrv
UBLc5rdAJddB3KhgceSbeIdaWX9mK6Nch+YfLsfZv8Q7tE72lrayy3V4t0/y
9dbf8Q47ky9EudjnOux6N2X16l8Ifh+XhMnvE3FwftAsAz6V3XEOCreKuXsc
ch18ts888WFjnMNuhTm/7zrlOjxeO8H1zto4h8Xe9utUXXMd1io4pFqsjHNw
UD1b4OKV63DP+CfzymVxDkeDU7aUB+U6rEouOTJvKYLPo/j8b/28OIeL0xLd
/MQw+TD1Bcyhty3lch1cG8yeKS+Pc/g8r81ngXKuw4MPR5Y4rYpzONR9dq2+
Wq7DBjdurkvr4hxWbStIKNfIdXh2OfpV6eY4B0FdEcH9mrkOb7Z90l+5B8HX
UL8V2nAKwU9QeTfBan88nD9b+9omwdPxDkfkjBv+AM3LtXuxw+pyvIMmU2Fc
uXquw5LTFjPvXY+H28971VHm8+14h1tmR3Skge67fbCjtulevEOh7u6VbPII
vvLXYq9yWQQ/hEP35XOpXAc+O0eFz8D4ZU1/1hohjhnfMD4ARnDqVw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mlI02EcB3CPEnMxlOVR5thMeiGJQ2mkgX3twBQvbMFQtmfqxkx5yiPv
QNSwUpupeaClK5WyMG0yLQkN50ZeI8TQF6mgtbSWpXbJ6Pj36g/14vvi8+b3
PL9DmHIhQeVoZ2dnzySAiQOTpTwx//AMRYi63XffGzkyFaIrgjGK3cJ3P0va
5FjmOilvKP63a4Tu7t5OOWJi4C3QUOhpCC9lJ0HSy5AIQSeFVpEztRFMsFwr
lgl6KSrf95SWKliHHVVuOVWyLgn1GM1vJzA1cjPMDymG1eNXV/sIarTDFf5d
FPVVOVMnhwk6NWvKS20UDgW8hupJgic892PmBorQ86mFohmC5raznMgq1sbk
BfGZMtYXHSeD/Isp0r189tyZJugo5/+ezqVoehyWtWggEKxar6szKcaiFGbv
IYL4NCRyMiisksGykfsE/Rpdk1VFcTw5sFlbQ+Ch93s1/XcesXnbgXUEXtmf
c9VKCunlqgdUR7C6cavbcI6iZW6XR8E4QWh8b4+VqZ+l7JfNzhMktjrzuooo
dLFBxsWPBLb1AM/vFcx79rFR+38QfHga3MdpZM0dlQ7IOlgXn9ou6npEEZ3x
xZL6iSC2LCuudZCCGxYu2FogkKicG8zPKcSnm2cbp5h+RXqTv5FC4/a60m2Q
9VsfiXbzNmvVxrqLWz7Tv/ucMG2IIkpiG3CNIQivW/iqZvZr6vm1ZOMTbPqp
UmSFFNUx0fXJRuYepJxS8wDrHS1JqdnPWAtH1g7UMv85mM7VW0xy+CbEfZMZ
KGpyPI/YJuTg3JPmZ5so6kQr8zfNcsDlxLXICWY/vCL+izk5DMXcQytmCmeJ
pbzbIse/9/sHix9Emg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{241.265066361125, 124.76413176875}, {241.265066361125, 
        126.51668522}, {241.793832488, 126.51668522}, {241.793832488, 
        124.76413176875}, {243.545135901125, 124.76413176875}, {
        243.545135901125, 124.227865413125}, {241.793832488, 
        124.227865413125}, {241.793832488, 122.476562}, {241.265066361125, 
        122.476562}, {241.265066361125, 124.227865413125}, {239.513762948, 
        124.227865413125}, {239.513762948, 124.76413176875}, {
        241.265066361125, 124.76413176875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQrXCryezumzyHM7Y6b7vL4x1W6j2VW/Urz8H2+fSw
3I54hwppnQbLv5j8Vdvu/nEMi4Pzuba3TO30jnNY83rDfud/eQ6stm+Dw1zi
HBIKTBn9GPId5hg/ueDoEOfw0G/2RSmmfIeZZRIGK2ziHAylPJjL2fIdpu/0
6eezjHNoqohiX8Cb75DUcMKbxQzB1+qqSE/Qj3MoDZ5a+fFCHgb/75yu3E7z
OIdqM539Krfy4Ob5PLA76Psgz8FY67avLtA+E1MPp6THeQ4XmDMFfBzjHMxO
rBXRf5bnkHv326UstziHFoavxfue5znc5Dn9SyIAwa85+Z4pOw7B373YcqLF
/jiHR9dM7SzvAMMjueTIvKVxDrd4cjvnn8tz4BTwP+AzM87hlWP6h679CL7+
hqezGjYj+PypPaYnVuY5rPxVcmDe4jiHxfO2C0otynOQTVxzSnJHnEN2HWP8
yll5DhOOP74y5QzQvdLivpem5TlwhDxrXvkMwZflc55Uxh4P55/zTTx2Qjve
Yec2j30Wc/IcHm3+aP7HK94hattC1Y/L8hx6llcqSafEO0yZrFz5e2Oew5zn
du+31MY7MDccdnQGutfOOuUzW1e8wy2zy+E55xH8B5JZc+ffQPAZUg8zRTwC
ht/EwI93m+Md0NMTAGwIDRM=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3cLwtXjf8zyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyvewaiiZuGJ+3kOpu6mBQuq4x3UXbe80LuA4C9o3n5J7yiCbzK55sHm
PXkOf54/bf9TFO9g4Oyd67stz2HvLqOD3YnxDjqfJX89W5/nUN9b/0sqIN7h
+86p2+6syXPIX9h2SsoCwde8UiB7VxLB367FuuU3R7xDnIFlusq6PIe1Z6/p
TP0R5+AWfUcyZ0OewzUH3acWL+McHi5k4dq3Kc8hjeFgffitOIe/c3T+8APt
j9+iZaZyPs7BN+Ombs6uPIcoq8lfPhyPc3jlmP6ha3+ew04rq16LvXEOihbb
r+gdy3OQTVxzSnJHnMOyND+JpHMIvs7Up9FTryH4tZ+/x++7m+eg0F6evxmo
f+tLd5ekJ3kOB9suXMs+EecQYFBgsuUZMDyd55SznkGEtx5X4ezNlxF8WHwA
ACW6y2I=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0sFHAYx0k3RcprixNdJ4rz2puSfI21c52XZHak308XZUm/OGzOiOYl
YaMlrZ3zRyRvnWWXddbSKNNW3mp2icjy0ouXWas01f3ltv74/vHZnmd7ns/z
8KQsMtHIwMDAUBdXXdbpctTYAzmWDMpFVepoEMHdLk6EmzmDSUdBVclxgrin
vOEkWwarrukr0bEEvacqdot2MHDjQ87xzxOszk5smHdiWPR0MZtOI8iLbWku
3sNwur130D2XYO6s2kPhznCHr/qxvozAsbcWMm+Guryx3GQFwUZtupTny/Al
dNmtUUMQI+983ubHkHLQSer0Sc/diz4BUi5dY1HU70fmoRSXdz0MVuj6b6c0
tOZnUhT5By1pfBis0wOVfdUUEe8kH6Y8GDSBf6bCmilmBsLj+l0ZKl83uDVr
KBJoweP9zgyJysKhlBcUHkN7tZU8hmGec7V6kGJMxnubZMeQOS6qNZ6ga37y
/LKcLy1SlNpsGQywYvhqGCay/0nRbUrVUzpf7R3efeMLFPJQVXWxI4NwKa7e
a5biVpq/5B6foelB/7jFJMXf7GOjGheG+n2+NeNaiqvfLHKjBAy+nIQMrwEK
TknQgkbna3U1+2RMD0WZCJzOIwxFqVl1wU0UllkjwvlghvutF+XcCgpVZKKp
mYjh5RvBXGkGhViw/MotXFff8/H9TCyFne1hz84TDJuyrcsP+euZmH2Pn7HX
c7Jc8uz6JMEZO4eWHCHDVteQWXErwbWVzTeiDjD84kdXiPP195QMeJWtpBMk
qdQChW5+h+02xk8ukLX9xCZGhjelBFXCkRLtToYWWWPNaAxB8OeewjYug6yr
fJsynOD/f/wHB1wj6w==
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
        324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
        137.844}, {333.668, 133.09}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
         "], {{322.62239645999995`, 
         139.61787444875}, {324.47745303749997`, 139.61787444875}, {
         323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
         139.61787444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
        "]]}, 
      Thickness[0.005154639175257732]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 114.809}, {
        261.641, 109.93400000000001`}, {252.207, 106.23}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
        102.85199999999999`}, {251.016, 109.52}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzeH7c+3K8nwH97UW77yLox0mLoyeVtaa77AjbEm4
bku0Q0Lfou+sHZh8VbVXfxmDouD8FrWJ0zzdoxymxKmbC3TmOzSs+Rki5hDl
4PF4dYVUd76D+OIPFxltohxOHhT0fN6T7yDyTMUwwyLKQbJ3X5XzxHwHIc3I
CedMohyyXl+oy5mR73D3/RWfI4YI/tKfLRkK2lEOsce4P+6NxuRX8EzP8zSO
ckheucjsYwrCPJPgrRZS2fkO62Y+93trHuUgs2LfTr28fAfv4lJBHtsoBzlr
lZ7fBfkOL3yYr2g5RTnkFGe/7irKdwipuf77hjeC/93iD7N2FIJvJuw26ceu
KIdTnmu2sqYDw+Nyw9G4hVEOh+ofM+REAsOjPvogz9Qoh0tb7qaHeyH44sox
Qr52CP7360xrp5jkO6hkNR6Mmx/l0C2o1/lMJ99hxoUdp29ujnII/lh+rVQ1
34Hb/MPVkBNA9/b1HpmnmO/QdPhTS+YjBH9Grf9kM+ZoON9zb+7xDvVoh4Wa
+01Z1fMdYpX/Wexxi3Zw0pSYu9cw34FdvE35dny0Qw3brA/HbYDxE+79oaQy
2uH1J8ud/ED37lxV8OVYa7TDoZWe5y2iEPwTPQ9EcpIR/BfXLatUcoHhxxD3
aW59tAN6egIAw7gO+w==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnVOc/bqrKN9B/K9s4u5bUQ4wfsyufyZ7XKLhfDve
a+z1adEOUq8/SUzNynfYsM2xMKE82oF/h1bC7ygEv+ObrtdvfwRfhu1zeIN7
vkN5+KeOPXnRDhLbDj6RdMx3sNCyP+QdG+0gkjahcLNVvsOvP92/b3lHO9zX
4dFbaZ7v8Epg8ulbxgj+EudaubmiCL7RLMGtu1miHdwWr7/3wSLfQcP2sW7o
lygHvXNBEy2s8x0CN1g++/EkyuGkSHVjl22+w8P8sw3i16IcnvIvLr7jkO9w
S9nc/MmpKAfT2/5LLVzzHa6unP91w+Eoh0tb7qaHe+U7mKxy6/uxI8qBc7Wu
z++AfIcZF3acvrk5yqHv5pF+vUgEX4Qj5nJiIoKfmpZ3vSsj32H2t+aC4p1R
DnNj9u3Wy893sPl257r2kSgHi8XPVjcUAsNz84qKo8cR4b2ysnZO8XkEHxYf
AOPfxJE=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EYxeeKJLxUCKFllykl3grCKI3cWRfGVCrSvLxv2VLMmNKrG3Yh
TSNN1BSnEsIU724MqWG6XN5oLkc2nSmzxGmJJqEpSFhmdPl/UujD+XB44OE8
v+cIEtjFpE08Hs+Bkx8nPqd5fWScdYohOZ2E279R5P2+JxFMM/zS5vkc+kph
+XO1f+Y9Q5HMwxgxSXEtYTmN/47h4YB+InuYwt9WWxpvYXi29iGo20ShSbQt
mswMotvH0zIMFEJiken6GEYKK9WBLRRbf0zHjvcymANl+80qir2fnY/5Gxhy
pFGKgiwK6+n+UVU7w99b3iddIzf8RPAgX+S54S+NbS4qmyfoqLRG6ToYHLtj
KwSvCOpzQjXKHi6vvqdhvIZgWZDnJDAytKZKOmceE7iI3SzCfm7fxxpFfhZB
acfUzfEBhi3bjRZTOoGbn3aHwspwBLMH+NcJwsOkppkxBt+I9npVDFnnk3tQ
+UQiJhg+pwwO4/h5SLvkKiFBUqvX7A2O14J86I6Jmz9NG3F4zfGKCW6okp8n
KAs/I2oeZKDPQ6aaogl8T53oUb5h+LlibjRdIWgeZrtXTQyDl5vF+ckEXkdD
tUqOV11A7pJEQaBSiCqUbQzuhkfV8cUEO89qL8S3MHzPLDfnqwnupniWCNUM
IcWTo/5GAruy5O3+eobsap9PVjuBa5NYpqxhWJ1bOXx/bcOL9jhNd+6i6z5I
p85xj6YwNyQuDmkYCngv4qILKWr75I6rLxmcQ9sCUvQb/xQTa7vGSNHraknV
cfkfuCyEzFno+n2GGMcubxtFeYZ2m2KIIXZJus/O9Wl2tMutysZQVpfZ6PGF
4v8+/gN8PUXo
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4uMBv7Zo/8h3UEoUsLe4Ge0A4/epP0169iDa
4Q4vg/oC5gKHSQtrlki+iHZ4UJTCmMtV4PAvPfDE8ffRDk/WJvHmChQ4ZOqp
vSn9Hu3wT1RV9xOQbxq3cE32NwSfs0rFdPeRKDj/LKct/5NtUQ6GF8tYpwkW
OBxXW3Zyw9ooh/ovXX/3CRU4xMnOdZuzMsrhc+eda4+ECxw0Jvik/VgS5XCw
TNmiSKzAIXIxK2vmoigHFr73N7ulChxULzccjVuI4LdP+PzPflaUg0j8bdd3
QP+g82Hqb6amv81hKHA48N7p+WOgebONGdQUgP6NTri4lGlZlAPTqsXX0lkK
HLS3iXNPWhXlUGb/dX03a4FDonPGa9P1UQ6rfrl16LMVOKSr/TfI3IHgL572
LMzhGIJ/Z/Kvib92RcP5YrMfbb54LNqhufia/TmgeS/Wftn561y0g1nq13Xc
QL68teuseZej4fZ3uPjJbr4e7dD3X27aXaYChzDDqXVOt6IdblXNCrnMgOBv
vvdtCTcSf/qFZS/a/+Y7dK71VdwMjF8P/YTWHz8x4xvGBwDu//Hp
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB3CiWUxr5aGU3c6pZTo6yTHG+05yhSxPO79v7KrJzpJvUltP
s5yHbhdjIbIRKQothDrDdBySYp46MnqwSJvW+Yvt6tdfv63+eP/x+uP72Wef
95d/Ji0qycLMzMycjZDNJjZFvA8FKQzFi6kGwcw8g3i72GBFNEVeodEUdJ/B
3ZUeURn/f2vaux8aqhgMWifYKnwpDs6F2LmYE0S+jRcogil2j2aONHsS7BDK
PRZkFJsZbZbkFOdXT+maPofz+hMXnbiCIMfzyGFxKIXf9KS6vpFA6b0neJGd
t3Ujc8RSS5DRIPIqAMXNb7zS8AECU2ooTxxA0TaXdu3nCEFqa3LOmg9nyxL3
iqtenGeTXHYtelAs5rnZnx4iMO4N/+1zgGI7Pyy9sodAJG/Vq9wogrTn38+2
ERzbOdc4uY/iXJ9OlVlLcN29NOyoK0XXqH+5QkPQGBj5vf3vPbqy1lfzCTyc
27QqAcW48V6D8BmBQ4JmQsS+tw91cPTtJwi8UxynZ+f/GO9JLJ4geCeSqGvY
fYTdgfrKZYKq2WjNsDdF8kUm7KORwLF3ajo2gPP+kOUZk5TzfK5fVw17v4EZ
syXBCoHs0eU65wgKdVMEv9VAMOwgOd5xkqK5o3YybpDg0g3Hs4tsv1tuLWnG
Wjgr8hXVLeWcFxQbNmPpBEMX6rdln6Do11m9HJURSJsa1lVsHxJnm0+dTgQV
V1afm4QUVl3yYn4vA1mhFB3hnF2bU0TqSM4tuuaiMnafaoNT++PXDA7lf103
RVFYfxH4deoZ1ImV/uoYCtsHq4aYNwykysS+jDi2H1Uu7/Y4AwuXvpJeOUWW
7le28jODf//vHztSSVc=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE1Acxr1VItOBsVQq00UtamlkkVHply1MxSB1GueAyrwnzeO8baWo
6JrTNJYgXmr2oBuWBGVKeSHRvHRDy4JEJUWTXGYTxW5QnSeFHr6HD/6373eO
tyIjIsnexsbGlms/lx1XQtyfwspLDB7x3aqGQALRSYsuMY2hdK+hJiSYQHVC
HWKvZKjyXSnaFk1g1vuuZmUy1IzIU2YVBGdGY+YGshjSG/1cTEoCB31Pu2su
wwfxu7dfNQRPnIO+71AziKq7fjzTEUQGHityvMKwy7pQeKCWIGTY2xBXwJDc
81ea1kFgdR8IkhQyfDYdSpib3vAB8YEQu9F1P9C/5fHoOYp8Jexu8/6tU233
T6sodL/KLrby+Tdmwxv11RSLw9UjvXz/0QdOn1zMFP4yYVUHv08Q8Eia3kGR
W9HSnZbNMO18c+xgH8WErPiVm4rhvOFwbc5riocidWgJz78cHnNnaIKu8/l9
VyvxWaQon1cOL3F+KZkkbHKFonmmphO83kcS8ML4haLY7uk9V86rPz7NZJ2l
EIo2C8Sc1x7PyY9vJin668rDpTkMXk0yo/E9hTbC6qnJY2jLZrnWlxTBXvoY
Kc+jvlwW5dFL4VSsU7Ty/LYz2mYHE0W4e6TDYAnD7p2aqxMVFNs31SfJrzGc
lR23hGVSWJanB+fKeP2Rb1PmaIoLqaV50nIGncWr6qf/hh/Pt1WY3Tf8/EJi
X+gUwWrqWnullsFQJ18QtBA4ji/t0+QzZFcrDIKCjfccCzxV2ckI1H5Ba7f4
/XXXvR0Lksl6viGN0C4qlkBoM9bUxflKZtuNDXKC+dHnYkkGw5JvvUdsGMH/
//EfCv8qpw==
        "]]}, 
      Thickness[0.005154639175257732]]}, ImageSize -> {388., 165.}, 
    PlotRange -> {{0., 388.}, {0., 165.}}, AspectRatio -> Automatic]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.825905024147108*^9, 3.825905072463655*^9}, 
   3.825905363382402*^9, 3.825905528383874*^9, 3.82590787412798*^9, 
   3.825908032180923*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "4"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.002577319587628866], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
       388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
       0.33199999999999363`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
       24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
       3.9919999999999995`, 13.508}, {3.9919999999999995`, 
       24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
       45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
       24.836000000000002`}}},
       CurveClosed->{0}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
       21.99788154, 23.851453813124998`}, {18.552508993125002`, 
       23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       111.074, 44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {
       94.133, 27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {
       77.191, 44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {
       94.133, 61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074,
        53.512}, {111.074, 44.156}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
       59.891, 34.656}, {67.65599999999999, 36.809}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
       39.508}, {68.684, 33.461}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
        "], {{57.68489645999999, 
        38.21162444875}, {59.53995303749999, 38.21162444875}, {
        58.612424748749994`, 40.420441815625}, {57.68489645999999, 
        38.21162444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       384.125, 140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
       363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`, 
       129.164}, {343.10200000000003`, 140.49200000000002`}, {
       343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
       363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
       140.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       357.65797799312503`, 140.37615644875}, {361.10335054, 
       140.37615644875}, {361.10335054, 139.507703813125}, {
       357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
       140.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
       71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
       147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
       80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
       156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
       90.35199999999999}, {173.45700000000002`, 80.99600000000001}}},
       CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
       
       "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
       62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
       77.762}, {132.35500000000002`, 70.23}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], FaceForm[RGBColor[0., 0., 0.]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3cP5P0b4S6SD+1qLd96XAx3mbTqsu5Y/ymFH2JJw
3SeBDtY9gR9Oi2DyVdVe/WXcFADnt6hNnOa5PMBhkU50/gOxKIeGNT9DxBYE
OHCbpXz6IhXlIL74w0XGOQEOfJ/1J/fJRTmIPFMxzJgR4LC2s/Obm3qUg5Bm
5IRzUwIcAtzW/ZthGuVw9/0VnyMTEfylP1syFLoDHEz/KD+23hOJwa/gmZ7n
OTnAweFQYN6ic5Fw8x6Jlhd9uRXpsG7mc7+30wMcNu/vLJF9GOngXVwqyDM3
wGHb0xDJ7c8iHV74MF/RWhTgEBT2+PrVl5EOITXXf99YjeB/t/jDrL0LwTcT
dpv0QyrQQYA5Nef0pUgH1csNR+MYAx3+5V1mmrE90qGlPvogz9cAB7mbxy/k
zUTwV2w9ohrViOBnyAtFv8yNdFDJajwY9z/AYdKkDOHeuEiHGRd2nL4pHOig
GPRn7Wr/SAdu8w9XQzQCHbZ1q3f9dY90aDr8qSXTCcGfUes/2SwZwffcm3u8
oz3QYe+hrpxTQZEOscr/LPYsA7rvoI21dUakA7t4m/Lt/YEOxTUOj/zrIh3E
w70/lNwMdAgMbSi+PyPSYeeqgi/HngY6/D80f77hTgSfu/Os1ozTCL63fMNX
jvvA8GOI+zT3fqADenoCADBlHPE=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHRT2+PrVl5EO4n9lE3dbBTrA+DG7/pnsWYLg2/Fe
Y68/FuiwzvWT0aubkQ4btjkWJlwPdJh1P/Hgtl0Ifk9MxtRtSxD8LdWfNhyY
HOlQHv6pY8+5QIc1t/tPfW6LdLDQsj/kvTfQYbG17hO1qkiHX3+6f99aHehg
eVIlVqgk0uGVwOTTtyYj+Euca+XmliL4RrMEt+5OCXTg2Ja9b2FZpIOG7WPd
0JBAh+vcm5QNqyMdAjdYPvvhEujAO5OJ5Wp9pMPD/LMN4maBDq79QS8qgPbf
UjY3f6IV6PBEdY23YX+kw9WV879uUA50kLt5/ELezEgHk1VufT8kAh16j6bP
3LYs0mHGhR2nbwoHOsxQmqYgux3BX1R/ZHnzcQTf1ebl+qtXIx1mf2suKJYE
+l+js0L2caSDzbc717VVAh1ebb0ZcfA5MDw3r6g4qo4I35WVtXOK9RF8WHwA
AJEkyRg=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI0wEUxucSJdIyAnOENC9ZlmaYXZTMT8RsJvX//712arKCCCzRZmmI
puZlLbXwltYSnbeJPWhOXaZ2MWlYLjNLNJ2ZCx/UjAjvhO3JQQ/fw48Dh++c
73O4GMdd2sDj8cyM2msU36gzerU6uptw+RqdGgvlkB1jXszXElYbsnfvD+Gw
LbYvX9ZCyI0RdIf4cvD1+jXZU0fIfNc2mnaAw4DgtGNqOaFxZdiry5nD+8Oa
MVExwT/paPwNAYclp9ohYR7h090ylbsVh3zxx2ZpFkHrHiPUrrJ45u0SZ5tE
SJeEJcj1LASLZfWLcYS1RCffzWoTj3rr+P4pJg4fMs8tDGYxXfmkQZhIsOyK
KnZwYPEyXs4aMox+215Uj6wxEKtt7fhyQvNVUYdhlkHJX8+HfgXGfd8qEmR6
BoqJ3nHpI4KFTXdfzwAD5RuJc101wRM/dvHfMthqrpPLmgmuIa1VCg2z/p8s
l4IHIhWDHdYe18NeEwSSTqmigkHgZ7a3QE2YkX642WOcDzNPzYPrCZHe1Y+l
jQwqLEoyrSoJ59Q+47VtDHR/bqcaSgnL89qani4GWpvZI033CLrzdUEyLYNX
I3fCDZkEpVvWnGiQQXPEfVdDLMGuPac8+icD1bKkKkVMWEgp0sosWcSeCLT3
CyX45OsH9zmyOFjkWmYmIqSV757oP8aitF3xZTKAsDQ173GLTOxvv+l7R7KJ
vZpU6XZtLDZqBkfFEQQ5T3M2YprF84XfW5qSCVbHW9yu2JryDKL+1npHDit5
NV+FRv8Z1jM+U27c+n3tkZadToc4VNIFYZ2SEDUn2Tlm7FPA9pw9S42EQmVK
jeAkh//7+A94lDen
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYk5Bxmzxr1EOSokC9haWQQ4wfp/606RnDkEO
L5fxzHUQjnaYtLBmiaRHkMNvq3lsJXrRDv/SA08c9w9y4FKfblbiFu2Qqaf2
pjQ8yKHo+IKtHR7RDqZxC9dkhyH4nFUqprtVAuH8s5y2/E/EAh0ctzwXk/CO
djiutuzkBt5Ah3JHi++7/aMd4mTnus3hDHRwn14X4x0S7aAxwSftB0ugQ4PX
rIcdcdEOkYtZWTOZAh26l5/IeJ8X7aB6ueFoHCOC3z7h8z/7XwEOS3QP98z5
FoXBh6l/yLZqWzFbtMOB907PHwPNe2HLO9NBMNohOuHiUia2QIdW8dnR8WLR
DtrbxLkncQU6hOY+PPBOKtoh0TnjtSl/oINylIZSnWy0Q7raf4NMCQR/8bRn
YQ5qCP6dyb8m/pIKgvPFZj/afFEtyKHTNo3hp3S0w4u1X3b+0gtyCGZ5tOed
RLSDvLXrrHnGQXD7O1z8ZDebBzlsye2INBOIdggznFrnZBXk8CiqLJiXA8F3
e/V8yjsWBH+lQNSl8/+jHDrX+ipuBsYv97kz3Bt/YMY3jA8AOhnSRw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYtmWjTm7BWIc0gujvO8EBzkoONbyhorEOBgv
vMp9KQjBv/zmcoi4QiCcP+PCjtM3hQMdQqsYA+PFYxzi2+Z4zeEOdFBVEQnu
kI1x+FYz+Xg7e6DDt7NqoRuVYxy+7D+u9o450CF11zHZnwYxDp/CTii9Ywx0
KLpywPWnS4yD6uWGo3FI/PYJn//Z/wpwEP/SHK+9IxqDD1P//qXO6vaT0XDz
tD6KnI27Gg2374Txosm1d6IdtHwl2CdxBDow1u0T2f0k2mFymGLXMp5Ah7nM
DVYOL6IdGG8d9HsnjuDfPJ81y0sTwc9PUcvyEQyC8ysPhnzcpBjkwKD1qVzx
cbTD03ZN0UTNIIdjZdc+Pb6B4MewnMs+fwnB/2D7013xdLTDE+PYiuPqQQ4t
yhHtNw9GO3ismx3kpBLkIHtdamkckF+tFfJ1k3KQw0u2aakhB6IdRO6JCVsA
+f6vLjuf3xft4B51fusKpSAHaSl/lqN7ox0e8E66rAvkS270Zzi6G+E+idjm
ZO1d0Q5uH89vXKEQBA+/ityOEEkgf31w1QOxbdEOq6/wTlCWD3IQNd+xb+KW
aId7AceMpsgh+KLuYuIWqkD3oaUXAPbO82g=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcxx0VbpeKzqY/nEuU/3VkVs67RUtSv98PpXwPo5jJdKVitKwy
NX/PNfmzjq3rNG12JUZhQ1G3XZxrolyK0PmTa7ab8qDukdt68Hrw2j5P3u/3
xzU5i7lgZWFhwTLhacLShO3iepaxmcApqfNyXT0FbWIrj2kiuOMuqYpopBAu
WnRXdxKU+S0XOLZR2F6l0pSrCKoGY9OmeikUKTMqP2oJMuoFdor3FEqllqNs
HcEo/8Pw4hiFRMXWL4JpAq701crrWQqqi3rW5AKBi0F/02uFQkOFNFz4hyC1
6693uiMNoZbHEbFE+KHwT/kOswuTQsG/bvY3fdbtQ09oZO61YwesEjjoWpoP
D9OoOeufIl4iKJ+Kqr+3TMNXGh/aN0sQ+Iw9bWfNIL4gIrh2goAjfOGd4cjg
9MPny6kjBF83Vmp9+Az0t7YIXNQEJyX7q6/6MDjav+Cp7ib4FXWmYeAgs9bP
alOhh+8JBo9s3/LzlARp4nOR49EM7I1p871dBL4eQpUskkFBro2S/Y6gLyld
YTjCoKPPbd8xDcFu5/EJzSEGxSMHgsRjBDx5mEwWyEDSoc6XTxK0ZF+6ZvBi
UG3wTxQvEuRk3o1x4jFQXPEsFluJwPpW+HjdBgbKoTj7UQcRdu3Mzfs8T2Pu
dvYDrrMI4WHBc5EaGm5BFTui95juA5Z0jW00ejY7T4h9RCia45X9rjb7WD4r
uTHH7DP6873HQ2iccpgZNW4TQVITq+fY0pBpB+RyI0G2NFnC0Zn31IaGlL4c
opAQwv0kmCKoKXG1udFPreUbyN1kGdNNoT0r7n7zIIHHVKusrpUCt0VQQnoI
fvrVOiU8pfD/P/4DlzIqgg==
       "]], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
       138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
       56.516}, {119.85499999999999`, 51.789}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
       110.84400000000001`, 47.38699999999999}, {118.293, 
       54.922000000000004`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQze77c63m5wSHrqjCO9OzfBwmLIye9o0h0SF3rcf6
qB4fh/i+Rd9bmTH57j5XfjNreMH5bL5KupOFvBwmx6mbT2BJdPgb8XmlDouX
g/vj1RWz2BIdtN0eLmb+4+lw4qCgZzpHooPaGc+kC188HSR691Ud5kl0UAza
pDD3radD5usLdW+EEx223185s+M5gu/xmfOiwy1Ph5hj3B9trydg8N9I6N2d
9MrTIWnlIrPCBwlw84yDt1rMepbgEGF8fu6tz54O0iv27Vz3MsFh0rNXShL/
PB1krVV6qt8kOJyZybYilMPLIbs4+zXXuwSHZT/Wfd8ojeC/LvzBHmaB4Geq
9ah8/OnlcNJzzdbWRwkO7ssYu/ce83I4WP+Y4c2VBAeW/9uaJNd5OVzccjf9
+lEEX0w5RujsTgT/23WmtSIbEhxcrzA17z3k5dAlqNeZtiLBQWdh4fTNr70c
gj6WX/u6IMFBOO/B6pUi3g6yfb1H5OYmODC1P+W87IHg6/yep5bbheD3V93u
E7zs7bBAc79p66IEh+1ufworBH0cHDUl5tquTXDg1uNx3+bs41DNNuuD+w6g
/nXTHrws83F49clyZz/QvfmhD1/09vs4HFzpeX7HVQT/eM8DkTf3EPzn1y2r
lrxIcDjHuOeJdbOPA3p6AgDRphxC
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnV2c/ZrrXYKD9i/rQ2WW3g4w/paSv5kVvD5wfpXU
Gv5/AT4Okq8/SYg+S3CIyW1+dKDIx4Fvh1ZC9TUEv/2brlf1aQRfmu1zOMPh
BIfX654IVib6OIhvO/hk5p4Eh7yQupbpdj4OwmkTCo23JTh8/Cn+fau0j8M9
HR49zc0JDpcU1aZvfe0N57u0/7KxWo/gJ5koZ5X3eju4Ll5/r2BLgoNP1bHo
VTneDrrngibuAJo3P6H4zEdfb4cTItWNXDsTHPbfn8Wob+Dt8IR/cXEM0P4N
7nl5JyS9HUxu+y/dcSDBYXmw/etEbm+Hi1vupl8/muCQFtIr8/GrlwPHal2f
6jMJDjoLC6dvfu3l0HvzSP+6Kwi+MEfM5Yd3EPyUtLzrXE8SHIzfsj989s3L
YU7Mvt3rXiU4lLzZuT6cx9vBfPGz1QxvExwq0wI/dgkjwjvg8y+L50oIPiw+
ADofwRM=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pfbgiP9oxIdTj3aMm1Htq9Dy99qz4UxiQ5f
Qrn9Y2J8HU7/iz+WHJzoIHLVqGWmna9DQtLHgiafRAfmqbnb/6v4OmhdXTDh
nnuiQ9TXjZlVvL4Oy5OvvnVxTnSof1fw4NU3Hwe7qDNZBvaJDgtFDf2j7/g4
cHx/GBFpnejQE33FoW+3j4PsUx7z1SaJDv8OrHgmVO/jcM752GVpw0SHX2/d
qmS0EPzNxbNYm/Z4w/nL1nCKqUZ6O2yfcT7EAKifq2qjhjObt8PCBrsVglaJ
DkK5te6bD3s5fFBs5V5om+iQcHNS2fG5Xg487sJn9jsCzdtv/5yv3suhf8e9
vEg3oH6Flpmd6V4OQlqrBD97JTokNpzwZgnwcvDySjiSHJTo4Dcjy9Xc2Ase
Pmy+SrqThbwczvtNtDwVmeigf6DiqRmzl0PKJqUnL4DqLz+d87FD2MthbcEl
RlffRIdVRW6WT5W8HCZ6uziqeSY6bEkr3eNt6OWg4WS9T9A10eHD637PTnsv
h6UX8qUrHBIdpu306ecL9nJQNLVbJQgML/tIjruTs7wcZhU7ThE0SHTQK+K1
3jvPy0HUdVXAPfVEh5c/1fr5L3s5VGTL9O1XSnQoktq9PJzD2+H2xL7TC2QT
HX5b+R+Yb+vtwLvUPUtQOtHh3dnX8X8qEPw6K7FD5TsR/NQEf0ZDAx+HY4uT
3/qpJDrwM+ZtXjPDx2He4SL2CjNgeqjJiLz2ARGf3VvmZQdy+jrs4zuTYwB0
/z+pa6VnZH3h/stfz1fhrufrMKl0Ff9noP/X3Tlot8Pe1+Hx5T3CMoGJDkrO
Pz2MQ3wd0NMjANbYGCE=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4mMBv7asLk50cDykUFdg5usA40v4nzp6xtXX
YZs0g9+BpkQHJeefHsYhvg77n55gipqQ6PDj/KIJ/cm+Dsejj0pFzUl0OB/j
c+N1ka/Db22vqJS5iQ7pe5wirxcg+PxfPLLKeL3h/GnCVXInPno5JC16y7Vm
XqJDt6/P5MT7Xg5/X4j+/rsg0WGHlVWvxXUvh6fCO9e6Lk508FGYeebDWS+H
prduBSkrEh3Wu3FzXTrh5cAuc2/z9A2JDu7LGLv3HkPwuRWf/63f4eUgHH/b
Na8Ekw9Tv+n0uVuRNYkOtfdbzx0/6eVgms7gc6Ax0WHLgUXerBe8HFhC3Nf6
tyQ6BOfoi6nc9HJ4U/cqfnpbosOBtgvXsh95OQR/7RW4357ocMbnX+KlLwi+
i+7ZtQ0C3nD+FvWvyl9/+sD5WmZH0xcL+jqwPV9TLwPkn4t+WfxV0dch+9Sr
2OmtiQ5WZV0mttq+cPt5OudYpRn7Osj8t9WxBrpvZZLW3xYLX4fNX01WqtUi
+Kl733pOr0bwp11Y9oK9Ehj+0bOd0sx9Hdz1E1orSjHjG8YHAAMf76o=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4oCuS1trGZMcTj3aMm1Htq/DxQyLNi/mJIdk
p9XiSzIR/EU3l6/UY/GG83UWFk7f/NrLIbv11/LzLEkOu3ksp1rc9nIIucWs
+YQ9yeHlT7V+/steDjb6vKt+cCU5PKnv971z2suhRDW2b45gksOjtRNc7xz3
cqgyilo0RzrJwX0ZY/feYwg+t+Lzv/U7vBx8D1mvN72aiMGHqbe0Fbj6+G4i
3LxrDixp5x8nwu1TfeR1Mu55okPgLAM+lateDo7sNztrXyc6KK91EvG96+XA
f2qnjMPbRId/m5vn3vmM4K+bf9Vkqpg3nH/7hM+VGc984PwPTSsfpbL7Ojje
Ldq94VWiw3H+YK1DYr4OS5if/pj4FMHPP5Wwtf0Rgm+ZXrZ4w71EhyPpuz70
Cfs6MN9SPcxzK9GhN8Z8aQuPr8MFY/ag8zcTHT6FrHiVyu3rsO20i5EXkK+6
R1etgMvXIWNv8sL2G4kO3VvmZQdy+jr4hS5sZALy90qrLI/m8HU4t2BhPdN1
hPvOlllvNL2W6NDxaH5yIKsvPPze3RJYacTi6yD5aVu+9pVEh+CV0gruTL4O
px9fvZdxOdFh58KeVA1GBF+jT0evgM/XAT29AADTQQUn
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       146.52642112112497`, 55.48896844874999}, {148.49523116799998`, 
       55.48896844874999}, {148.49523116799998`, 54.99270331312499}, {
       146.52642112112497`, 54.99270331312499}, {146.52642112112497`, 
       55.48896844874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/aaggYOXOdmhK6rwzvQsH4fSo48+3BRIdshd67E+
qsfHwWWTZlCmMCbf3efKb2YNLzifzVdJd7KQl0NF07qJxSLJDn8jPq/UYfFy
0GE3vlwrluyg7fZwMfMfT4e1T2cs9pJIdlA745l04Yunw98NrleXySQ7KAZt
Upj71tPBjz/i5nnlZIft91fO7HiO4Ht85rzocMvTwfHVJG/F50kY/DcSencn
vfJ0cD+rOTHkQxLcPIlym8m135IcIozPz7312dOB4YyryKSfSQ6Tnr1Skvjn
6cAUv/pZ3J8khzMz2VaEcng5BEz/5Prub5LDsh/rvm+URvBfF/5gD7NA8DPV
elQ+/vRyWJdrLJD5KcnBfRlj995jXg7LFmdFn3+S5MDyf1uT5Dovh203Ug7t
uorg/3Z7nLPhJIJ/+3cn+4/9SQ6uV5ia9x7ycsg33frYc0eSg87CwumbX3s5
mIv+N7i5IclBOO/B6pUi3g5Mm0TkmdYmOTC1P+W87IHg6/yep5bbheD3V93u
E7zs7dDq6zYhY1OSw3a3P4UVgj4Oar7zvyvsTXLg1uNx3+bs45CgpeitfQKo
f920By/LfBzOix0ULga6Nz/04Yvefh+HZWcvaM55iuCv2ZCef/4dgn/m94Er
7T+SHM4x7nli3ezjgJ6eAByxFYQ=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHTD9k+u7v0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg4/OOrKv7xNckhJrf50YEiH4fPtzfuinuG4OdIbV0SdxvBZ9Cq2vT4
UpLD63VPBCsTfRz+3PSwrz2T5JAXUtcy3c7H4Uen+BmxY0kOH3+Kf98q7eNw
OGByB8/hJIdLimrTt772hvNd2n/ZWK1H8JNMlLPKe70dtI6bWYYcSXLwqToW
vSrH20Ho083Xs4HmzU8oPvPR19thrQXTnbcnkhz235/FqG/g7XDSWOucPdD+
De55eSckvR0k/1/7P/tCksPyYPvXidzeDttupBzadTXJIS2kV+bjVy+Ht+e2
LIu7k+Sgs7Bw+ubXXg5Ff71fTXyC4P/Qfqx79A2C79n11fDd5yQH47fsD599
83JobHAVm/QryaHkzc714TzeDjLHc9me/ElyqEwL/NgljAjvgM+/LJ4rIfiw
+AAAdJjPwQ==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxueByANoM6NNnbRqmKGbaUq52WMesm/fNw+UJtPM/V0zvFgJ
YZpp4kAtQsJKQ0pSRGUe8JRWRi7LPBU1D4XRmpGCM8JDCe2i9V1N6OK5+MHz
wvs877tHpU1RO3E4HAdWgawcWbk+PMjtCCAQD19ZDHeioE1zEipFBNsYYVAN
l0JAqn9znZiAl7XkECShULN+y1oYThDYoH83epLCeKlp3i+SYDpK40tnU6DX
2q4NHCPojGtt/lxAod/aw5mKIRCJCtaqaiisZD7gNp0gkJqnbal9FGa1+WHJ
CoLxIlu6cZXC/h1Pas3JBG+Z7NGxOLmdC4dLrsf2bHFFhcfFR940pENdu6bY
+b1PNZnluTRSZjBiSSDgv6mP8tLT8L2U2u0VR6BReU/4GWn0aphgGwh2Fuem
z63SkGyW3VRLCZ777GtRbmdgzQ3RGyII7gvVkhUBgzZX/5Y6CYGpvhPVkYy9
n1+n3RIzMhiktbs3aQ8QTHzruzeYx6C6MaPCi/WnK4rvyJQM4r+3Xxg4TFBu
MNILcgYql8jAuSME8dLBF00yBpPc2A6LjECWUCWViRkodB5JuuMEOcvmH2Yf
Bh/8ow0Wtq+f855th5wZnFmQfbSkENgMbnKX9zRMHrN8gZIg9uj65uN6GleX
VV+k5wgqK/Nnas/T2D2y2qBUs36N6VliCI2lrgiHFQ2B+2y078ZvuZ27/ji+
UvRv8dj0uO5ulBxB3T4lHWcJBKF6I2+Owqnb7jk6mmBR9FrIK9m6Z2NpEf+y
mkJYfO/fSXb/YF6MpzWJsue7sSFwbgWF7K8zShc2Pz2aJ4sQU/Ase5lmDiH4
lBUWOsSn8P8//gPm/hyd
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       242.777, 101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
       84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
       208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
       101.48400000000001`}, {208.89800000000002`, 110.84}, {
       216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
       118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
        101.01833734875}, {228.42917790875003`, 100.1214467175}, {
        227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
        97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
        100.1214467175}, {221.98906566875002`, 100.1214467175}, {
        221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
        107.2353207}, {227.01602828000003`, 107.2353207}, {
        227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
        101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
        225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
        101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
       94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
       88.67999999999999}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.2, 0.627451, 0.17254900000000004`], Opacity[1.], 
      Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.2, 0.627451, 0.17254900000000004`], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
       172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
        
        "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
       97.30146844875}, {187.73723616800004`, 96.805203313125}, {
       185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
       97.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
       121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {282.441,
        114.262}, {274.85900000000004`, 121.848}, {274.85900000000004`, 
       131.20299999999997`}, {274.85900000000004`, 140.559}, {282.441, 
       148.14499999999998`}, {291.79699999999997`, 148.14499999999998`}, {
       301.156, 148.14499999999998`}, {308.73799999999994`, 140.559}, {
       308.73799999999994`, 131.20299999999997`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{238.125, 113.293}, {
       245.82000000000002`, 117.87899999999999`}, {255.996, 122.754}, {
       265.42999999999995`, 126.45700000000001`}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
       274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4nSe4qYHM3McFiZeM3jREu8A459sSPD5VBzv
EHZm7Va3Bkx+dlXEwa6HcXB+gqyWlcrFOIeuOUZfAxpzHHp8fSYnHo1zsFfc
bhbdnOPQfnlLoN6+OIfPS60rUltzHF5OUO/m3x7nwL8wOWt7R46Dr8LMMx82
xzlUXrm0e0Yvgi+2LqFu+yQEf3P7O4dr03McttfmvZm3M85BZnfspO1zchw+
zewsvQO0LztmyVe3BTkO74v3XXA6gFBf/ny3ot4yhPmcAv4HfGbGOexzCkzr
a0Twn29dLmdUhOAnbSxbeTorx2GDGzfXpXUIfhrDwfrwWwg+LHzUHPubv8Qg
+Dw3zyTnA/l/A552/ymJd/hUwOXyKjrHYUbu8rWNZQj+GVudt93lCH76ul2r
V1XFOzisDFxcGZvjwGxSc1G/Lt5B41+USl9CjgPbR/eik43xDneb7qfOSMpx
sDx4ZuPlpniHn7XsEa9Scxxsn08Py+2Id6h5f+lXM9B9LnK/Lawmxzs8VXLy
Sc3PcXgqG7Lg09x4hzlWOgk2JTkObYWVS1xWxTuw5s3eKFuZ43DoYcIp6R3x
DleiHgmtrc5x+HV9w7r9++Id8sqXmBjV5jhM32hXeO9wvMPVt+5PK+uA7n91
aMuLY/EOtimvpx6sR/Bh6ePv3+rgyCMI/pQvRRdcDiD46OkPxgcAKo9Gsg==

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+ksZaHa2imiVFplVhEVa+8yDyFtarmo7xc9bPEtstb15GQe
6sZsEptxJgojXYzMNY/LebpyTip3zkXdUs7jspTO+v3F1h/vP17bZ5/P5/15
f7ZGxYZc4pmYmJhy2s1pBSf+jMUBKwODwTQ4wG6eosbDdUfEJMN9z9tO16Yp
fh/kFzvqGdYurGnNGKHILCgPOjrMsCq8Qt38nkJgLWCSQQa3dIWrsZNiQJLR
xRtgkJs7x9Y1UrDHyb5TSoZQ24zSqy8p3Pfludm8ZQhqOu9gXkQR6PBmfbSc
YeWMX3xXEsXfhASpuo0hxZzvFRy6zBHdLaZJW5ZZfXlerJok0KvS9k61M2Sc
CMqObCfolc0lK3u4ff1qijc+JbA/5/WN9jJ4GL1k27IIDid1l4n6uX5x2fEd
SQSNszkBNp8Y0ovqesxuEuBi5ET1EEO98uP2Y9EEt1L4RY5fGV4MlT/RhJOl
+1jUp+SIAwmMD/03iMcZCqel1zXeBI8Mg81lXH0cr01oFkSgqRBreTqGoa7c
/JpTBM2pC3Z6NcNnbxetPozgzL3ZPOUHBlHa6xKzKIJ+i52/3FUMIRN5vh0x
BCdj51KVCganRuGEWEjQWTUfq2xlkBy/U1DI+fFOjHSWNDDctXwg76gkKH3W
f0VUy9C8uU8VIydYrfApo1IGMxdbnfUIgadu0Uf5nJsn/O7StLjM8qpF3YI9
XeIG5CcKwih+ajd1Wb5isMqqEORmUiiMu764dzJkvSvbUylbzlPxo612TE5h
8E/2n+rj8iwcPuTUR5f8HRn7I7swSNEijRyv1jBoRaft7UYp1lndmFKPMvD3
x5WcNVD8/4//AL5DSxs=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4i9dGydkseY6LP/IbFdxN94BxhfecSNR7Wm8
w5PQ7Zr1IrkO4kYFiyPfxDu8lW+4J6GU69D8w+U4+5d4h69Ta75J6OU6vNsn
+Xrr73gHzTRGM2X9XIdd76asXv0Lwe/jkjD5fSIOzg+aZcCnsjvOYcKdJc+y
DHIdfLbPPPFhY5yDtvLZa3uMch0er53gemdtnIOwX0Eni2muw1oFh1SLlXEO
G9T/eStb5TrcM/7JvHJZnINp2NT+MKdch1XJJUfmLUXweRSf/62fF+fgOHOS
oi4bJh+m/gFr2zYJvlwH1wazZ8rL4xySF25XrxfOdXjw4cgSp1VxDkZ9/zr4
xHIdNrhxc11aF+cgtXOhdZhErsOzy9GvSjfHOTTqu76ZK5nr8GbbJ/2VexB8
DfVboQ2nEPwElXcTrPbHw/mzta9tEjwd72CimBJ9G2hert2LHVaX4x1msiyy
DBPPdVhy2mLmvevxcPt5rzrKfL4d7+Bl+ZX9l1Cuw+2DHbVN9+IdHuq/aXnK
h+BP/r5ENYwXwT/CFXfkGFeuA5+do8JnYPyWZoonmrNjxjeMDwB3TepO
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk1EYB3A1LBc2XBOtlZIGKUIoiuZszaeIGeIlxwzTes82J8PJk03F
K2nmFG9oc9Ps4m1EpTiYigpSq0wlnQqKoUSZoK1YpXghEtP19umF+vD/8Pty
znme8/eRZ4rT9jk4ODjSOU3HiU58gXKbO4zAV7b58lYoWJLL5PY+BFefL7sl
rRSIOWciMy//b7eoXsPRxxS8iFf/3LuF0I98rtyZgGVW5WvXIbRLsyfXQwiI
9cpweytCtc1YWiplLDyr2NxfzbgkwmM4r41A2P1IkfEhglk5XvnVRMBuWJOx
GhF0NdmTF80E3LU8SKlDcMrnNtZaCPh7iHjGcoSIG6kFQbMEXDoqrH5FjEMV
7MPBWYxXnH8fYmUgqI54uXdMEeBWxL/vTkO41yNUL74hcNfmlS6SIoxES6eP
DRF4pVKH2pIRvksG77x8RuCkdjnLkohwQRbY3F5PoGIw0dT9dx9xuduBDQQq
c3wSRBKEJE1NF/YSSNqa0hiuIjyYZ3nkjxPoEi9VWujz1Yq+63MLBCZa+Ktl
KoTeuODRxR8EMtapjXe59H2OcdHHfxFIea6osZUzLh6p0gp0jL9FBVzR0PuL
ydiypq4RMGsMAYVPEdjC8yc2PxIYUfJvGk0IYZea55om6XlDrB2sfoQ6zodq
ziDjz16S9o0Wxmnrqwc5efT8ni67oi6EaMnOgFssgR49e0akRxgz7n3a8SYg
92s6J0hHqI2N0clG6T4kC64ZnzDOeVQrTOhmrH3Ns2fS7zmlYvdbxyhokNye
EdB9q8/2DN+ZoKCos0qcMIDQELS8oJ+mwOSao/Afov+HW+j9dp6CkOLIA8Nm
BBeJtazTSsG//f0DwMpEMQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{240.761020489125, 124.76413176875}, {240.761020489125, 
       126.51668522}, {241.289786616, 126.51668522}, {241.289786616, 
       124.76413176875}, {243.041090029125, 124.76413176875}, {
       243.041090029125, 124.227865413125}, {241.289786616, 
       124.227865413125}, {241.289786616, 122.476562}, {240.761020489125, 
       122.476562}, {240.761020489125, 124.227865413125}, {239.009717076, 
       124.227865413125}, {239.009717076, 124.76413176875}, {240.761020489125,
        124.76413176875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPeHOZsE9d/IcztjqvO0uj3eQNBT71fEqz8H2+fSw
3I54hxeysdESbzH5q7bd/eMYFgfnc21vmdrpHecg8+7hLKV3eQ6stm+Dw1zi
HC4Upd3R+ZDnMMf4yQVHhziHwMAza35+zHOYWSZhsMImzmGhTOW90G95DtN3
+vTzWcY5fKrqflT3N88hqeGEN4sZgq/VVZGeoB/n8DT0WMiFA5j8v3O6cjvN
4xxeW8TOYj6FMG/Po/w5OhfyHIy1bvvqAu1bYl4p63g5z+ECc6aAj2Ocw7JT
997zXstzyL377VKWW5zDFyY1/7nX8xxu8pz+JRGA4NecfM+UHYfg715sOdFi
f5xD0M00SYkzwPBILjkyb2mcgxf/vJS6fXkOnAL+B3xmxjlEucw4nbkewZ+/
SawsfjGCX5++V2D5zDyHlb9KDsxbHOcgvPDFmx8T8xxkE9ecktwR53C7wciq
oyvPYcLxx1emnAG6V9ZDY2NbngNHyLPmlc8QfFk+50ll7PFw/jnfxGMntOMd
NHdWzhTvyXN4tPmj+R+veIdTOy4xXJiW59CzvFJJOiXegWVaSMithcD4eW73
fkttvENx0xcZJaB77axTPrN1xTt4WbIYe+9H8ANkZlfUnUDwC9K/3DW7BAy/
iYEf7zbHO6CnJwCaKhaD
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/YVJzX/u9TyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyveYVHV2prl5/McTN1NCxZUxztMd396mPcAgi/Q9mIt71YEf8nUtbsn
rclz+PP8afufoniHBa41HjrL8hz27jI62J0Y7zDnq9fVo/PzHOp7639JBcQ7
pO85NnH3nDyH/IVtp6QsEHzNKwWydyUR/O1arFt+c8Q7nDPKcmKel+ew9uw1
nak/4hy2xfJ+9VqQ53DNQfepxcs4h8Alpk/nLMpzSGM4WB9+K84hd37s9XdL
8xzit2iZqZyPc9ibxcXpvSrPIcpq8pcPx+McolxmnM5cn+ew08qq12JvnMNE
qxfrebflOcgmrjkluSPOQSyz/rPDPgR/znQx85JjCP7brxrWc8/mOSi0l+dv
BupXfVMh73glz+Fg24Vr2SfiHA4YLeSffA0Yns5zylnPIMJbj6tw9ubLCD4s
PgCVgsVC
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUh2fL1JWlubSaF0zRclbWJJUQf1Zg3mGVObH3NVGDbL6pm6EL
00jDGxpYNsnVB8W8F95iFHijmFhp+qFQx8yaloKrsCw1+n9y0IffhwfOgXOe
c9yTmTSVz+PxLLj4cNnEpd2GihI3MWhMHZmTJwkcBo+JBTwGQe+tuyWRBCP9
0vYwGwaHPuONuASCANLPP2DHIEoKT/O4RCBfsP80ImQwHfa2NWYRmBKni9P2
MFzofDV2MJ9Alma0Ubkw1Hp0/NpcTlCpGxVJ3RnqC6bz0x8Q5E42BPP2MyxE
/xA3aQl01xcfVYoZ5AGeyZ6fzTxoOhqSLKIbHHF2tccumsLgPeum4vrvyxvb
CnMofoYoRtT7GISKUI2uhqJvqkQ74MqgDf07G9NCcX68IKB9L8OdN43iFi3F
xMXuaqEjQ6qm6J38JYVmIqXrqj3DuLtXTfcYRXSO9EmYgCFHH/HQykA3/BQc
z/XKMFGsOqHVlc+waBET4bxCIdleVTXA+ersPaLTL1F8jTVkpe1gOP0tscFv
nmKLMkNS5MDQ3P5Wbz9DwfKv9aidGBr8A+v0Hyi+L52QSZwZAi1TlH6jFMoy
xbCa87W+rjojG6JYi8o0qH0ZijNz6081U9xUWXu+9md43HYlT1RF4XbunnEh
iGF4wvdLmZLi+SHPJkEIVz/0cWougaJUlC6oDWXYphJWBAWbmdguJ805mzk9
L76/dIZgzDn2dmIgg6NP+HxUG8HKWohc4sXw2yOuKqrQfM/4Ub/yPwqC90+N
VipufleXXVYvLpON/aIEfIvqZALLSOvUZzsZWrOb6iZlBF2Ly0mVWxmy+yp2
a2IJ/v/Hf9LcI5o=
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
       324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
       137.844}, {333.668, 133.09}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
        "], {{322.62239645999995`, 
        139.61787444875}, {324.47745303749997`, 139.61787444875}, {
        323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
        139.61787444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 
       114.809}, {261.641, 109.93400000000001`}, {252.207, 106.23}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
       102.85199999999999`}, {251.016, 109.52}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4lVX3jQ21OQ7yFx8ZLiiIdoBxnf5kOO7KT/a
YdYU9a3PkjD5z16mHPK6GwXn3+4xs35yJsrhbMqaLx+S8x3Y90ZMUTwY5dD0
0sDsd2q+A5PzwaB3O6MczPK2lrNm5DukMJj0nN8U5RCUeTczPDvf4UT/0rMb
1kc57Jnjs9uiAMGPLLtVG16K4H/zz3Aoq8p3MHpb9TZua5RDfPP1ieH1+Q65
nNPK5gDtW6ci9/VZU75D1uNTF5n2INR/Cjuh9G4hwvyW+uiDPFOjHBi5T6fq
pSD4WnWKcpdCEPyllR9WZPvmO2hvE+eetArBf5h/tkH8GoIPC59MTs7mKfYI
vv9Ct2R+IL/iwMeePQXRDqaWLc5ddvkOwnc3r3MsQvDd11q88y5G8B/JHl+T
VRbt0Fx4epGkQ75D3eKOS+8rox2yj11R1nPOd2hICCnurI12UPCOTLVwzXfY
YnBz0+S6aAcbt8bwLo98hx1hS8J1W6Id9m/3+aUMdN/+XnarX33RDhqvd3uz
BuU7JPQmLNw0M9rhPtOy+Dth+Q6MD1uXsiyLdvAwE924NzrfwTYw9/TtzdEO
4soxQr5x+Q6l7nvX1++KdthoL2dyKT7fQUjRu2je/mgHiW0Hn0gmAt0fdX7r
ikPRDg06qVMTkxB8WPqoyO0IkTyA4POn1F9k2YPgo6c/GB8AErA0Qg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxw+NLT3IWqNJiZKQ1m4T6/K20e3qqonQ96umViy077kbyTy1
8zAkI6vsmHQ4mahwXOcht8tV85DMVTsq1VTIP42i2fX7y2398f7jvc/22fvz
+rzdLrBTl2x4PJ4Vp72crDkRTS6/ZZghPpkcm/hFsWBu9uCNMvxtyvPcN0dx
yKqsVmdgKE5w1oknKUYv7hRPPWOQv1Kbsl9TKN6OJgq6GVqX3/F79BROcbYv
lZ0MwVcPSlI0FK0xK6GlbQxviu6qfJspri058rtaGQy+CTsMCoqb3wSOax8w
5MRGyAozKYKO/G5Jr2cwp7oLNoRbvClgyDrYxeJPG9cUl88Q7FHw9pc2Mtj1
RFe49RM4yplc0sLlVfcq39cQnPdQT5sfMzxJEmm/3CDIFIWoXNXcvo81soJM
Ap5249Gupwy2DrpBfTKB3Mc0F9bHcABfd1nHEWjFZTW6AQYvccd9RRRZ5ZO7
u+y2SEiAMN1mL46fc2y3VBFEMN4e3ifkeM1Kh9P03NxVZjOp7GeIClBWSU8S
WJ9IccnrYaBtgR/qIwkqQ5IqJRqGpQVDnf4swZaxe4vGdoahmAZhQTxBuT/L
k3C8an1y50UyAvtUKZPUMThp8qvPlRDkC03egiqGxYxbhgIVwY8rxy+73mEI
LJkc89YRiCv6GsxlDNnVnp9GJgiyVGmhklKGP9MLflnLFh+8zX5Ku5Wuev4j
VY5TJIV/Q8WLh3cZCnmdZyKLKBwGlJ+NTQzrDrf7JKot/xSSkY5GHYXfphVh
KZf/+vrZwOlBunqfJsqu232cwibNNBPWyxA9H7t9gutThPHnfPpzhvLajDrn
7xT/9/Eft5A+ng==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYvNg7QlcL/IdlBIF7C1uRjvA+H3qT5OePYh2
UJcz1JT/nu8waWHNEskX0Q4SX/7kxTAVOPxLDzxx/H20g4z+76oYjgKHTD21
N6Xfox3Mpu+d9RDIN41buCb7G4LPWaViuvtIFJx/ltOW/8m2KIfMIP7iVs4C
h+Nqy05uWBvlsL1UOXsdV4FDnOxctzkroxy0uUtdLnEXOGhM8En7sSTK4ef3
3UsT+QocIhezsmYuinKw6W93rxYqcFC93HA0biGC3z7h8z/7WVEOLYk8imeB
/kHnw9Qrn/u/dceHfIcD752ePwaatyzTUF3+W75DdMLFpUzLohxKwyo61v3I
d9DeJs49aVWUQ2yjtPW3X/kOic4Zr03XRzkc+b7vte2ffId0tf8GmTsQ/MXT
noU5HEPw70z+NfHXrmg4X2z2o80Xj0U7lL+8G1X9O9/hxdovO3+di3a4c0ba
8tvPfAd5a9dZ8y5Hw+3vcPGT3Xw92qGXMZ991td8hzDDqXVOt6IdVH6ktrR+
RPCv7ZdT/fYewWe/fP1w2tt8h861voqbgfG7w3BiwvWXmPEN4wMAp2z53w==

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4pMLCv5EBhU4bLm2WvnW/SiHiVPfbvD3LnBo
n/D5n/2sKIfTORHz2yUx+d3b9i2+OT/KgaHna5W/QYGDwV1XESXGaId2308T
/K0LHKQv1J/dqB/t4L3uw+zzDgUOrFG7mhxjEPydqwq+HGtF8H+tVDpsPjva
Ye+GO4vU7AscLK9f7VyxJtph4dYtG64AzeP7XX+WZVe0wxqdU/NrLQocap/L
T/M5Hu1g9v5+j5pJgcPWu/lVH85GOyw1Yfj8WA/BtxE7wpGpheALP9/VdkWt
wOFpu6Zo4sloB+3lT3LUVAochBS9i+btj3bIvOltUqxY4GC/K+f87a3RDo0z
S6WOyhU4pB053Fy/JNph8xq9naYyBQ57L1jPTOiOdniy/3n4MlB47G369b43
2iFtnq9GsXSBw+XP01frrot28Lun7KQI1C/qLiZucTTaoYxX98hWoPlvLu+P
m3Il2oFt881vE4Hu0d1nd2zey2iH6zFvfuzSKXBIL4zyvvM52sHfKd/V1QTB
TzjW6PHOCsEX57ikNQkYfsdvMbxQfh3t0KDGJ8rrWuDQudZXcfPNaAfmGTe3
L/MscNi4fcnVsBPRDqv/rr9wBRi/nI0vui9uQvATehMWbpqJ4D9I+M19sSja
gfGDQ12xW4HD0cPsOy54RDtU6blkFAPjw1GW++FuqWiHy9/b5d6pFjiw742Y
ongwyqFB8PbaZS4IfowR8/wKdwT/lYvX/3agexbelNq27FCUQzZfbcY7rwIH
rsfKlruPRTnc38G4ssKnwIF3wfubIaeiHKpefTNM8QPGT3ObfMflKAfrxTHM
GwMKHJoOf2rJfBTlgJ5+AXWQVZY=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxnUFhiyzJGtZ5lylmKmYRUXqkximouCd3pdE52XaUt+ZVmMu
L2UqrpUJQx3MgtzIQAwvmRcSTY0itFZg6tJYRpuZmkSFUP0/OejD8+GBczjn
+Z0jFBfEZ22ws7Oz5+TDicdJO6dZLBEzCNL6C7WhBDEDFT8S0hmuH6jTREYQ
tPY7P/6exaD2Xy1zTSaYdXyenpHLoBlPkpjFBIq45bguKYO0+bCTPp/gpGOy
iJfPMOn59s2inGBFPZXJZwzb6/t+PasiqB0cX/wpY9i7bCk92EBQHtn7J7aY
IXvgr29uN4F307l218sMX/QBGZ/mbD4kLRSeO+i6Hxl26Jk4Q9G5NFmg4vpd
TB1tpwopniqEo9pChlvmmOaaeop9Ub7B7dz8I48c550MFGzEsNbC7ccP6fSV
dlO08cN8zl5gmNt8x3hoiMJlVHDC4TxDbF1gQ/ErCqvGuacwm2ElJuXu2DRd
57PWWunl95ViSOJw9APHTyIj0TOrFCaxv3cAV+/nFfJCt0Dx5FqKgMfxGk7L
1S+bKSI0OvlWjtd+95nZ1zMUa7tEfW55DB73w3W6dxQDxmpVTgFDRxG7tPyS
ovSecMSNy3MlrzpRMEgRxvOY0HL57T9WtmzUU1Q2Lsi6FAyiPXLFdC1Fwo1A
Y/hVhtPhx63RMgrPi/Kgt2VcfdCSyZBMUWPZPe9WwVBl9VD/Pmbz70vsxYad
Nv/ZkjkUZSLwtapFSiVDXWOShf+AAKRKk1PEUFQvruMrbfc0hgbf7GUE7Z1T
GSpu/0aVcJMym6znG5Nv4SWmEkSUS7c95Ph6mbt02iQC93jxbVcJwzf/JkFq
NMH///gPECMu+g==
       "]]}},
    AspectRatio->Automatic,
    ImageSize->{388., 165.},
    PlotRange->{{0., 388.}, {0., 165.}}]}],
  SequenceForm[
   $CellContext`Dia["A", "A", 2, 4], ": ", 
   Graphics[{
     Thickness[0.002577319587628866], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
        388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
        0.33199999999999363`}}}]}, 
      FaceForm[
       RGBColor[1., 1., 1., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
        24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
        3.9919999999999995`, 13.508}, {3.9919999999999995`, 
        24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
        45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
        24.836000000000002`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
        21.99788154, 23.851453813124998`}, {18.552508993125002`, 
        23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{111.074,
         44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {94.133, 
        27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {77.191, 
        44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {94.133, 
        61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074, 
        53.512}, {111.074, 44.156}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
        59.891, 34.656}, {67.65599999999999, 36.809}}}, CurveClosed -> {0}]}, 
      
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
        39.508}, {68.684, 33.461}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
         "], {{57.68489645999999,
          38.21162444875}, {59.53995303749999, 38.21162444875}, {
         58.612424748749994`, 40.420441815625}, {57.68489645999999, 
         38.21162444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{384.125,
         140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
        363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`,
         129.164}, {343.10200000000003`, 140.49200000000002`}, {
        343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
        363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
        140.49200000000002`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        357.65797799312503`, 140.37615644875}, {361.10335054, 
        140.37615644875}, {361.10335054, 139.507703813125}, {
        357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
        140.37615644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
        71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
        147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
        80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
        156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
        90.35199999999999}, {173.45700000000002`, 80.99600000000001}}}, 
        CurveClosed -> {0}], 
       FilledCurve[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
        
        "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
        62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
        77.762}, {132.35500000000002`, 70.23}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3cP5P0b4S6SD+1qLd96XAx3mbTqsu5Y/ymFH2JJw
3SeBDtY9gR9Oi2DyVdVe/WXcFADnt6hNnOa5PMBhkU50/gOxKIeGNT9DxBYE
OHCbpXz6IhXlIL74w0XGOQEOfJ/1J/fJRTmIPFMxzJgR4LC2s/Obm3qUg5Bm
5IRzUwIcAtzW/ZthGuVw9/0VnyMTEfylP1syFLoDHEz/KD+23hOJwa/gmZ7n
OTnAweFQYN6ic5Fw8x6Jlhd9uRXpsG7mc7+30wMcNu/vLJF9GOngXVwqyDM3
wGHb0xDJ7c8iHV74MF/RWhTgEBT2+PrVl5EOITXXf99YjeB/t/jDrL0LwTcT
dpv0QyrQQYA5Nef0pUgH1csNR+MYAx3+5V1mmrE90qGlPvogz9cAB7mbxy/k
zUTwV2w9ohrViOBnyAtFv8yNdFDJajwY9z/AYdKkDOHeuEiHGRd2nL4pHOig
GPRn7Wr/SAdu8w9XQzQCHbZ1q3f9dY90aDr8qSXTCcGfUes/2SwZwffcm3u8
oz3QYe+hrpxTQZEOscr/LPYsA7rvoI21dUakA7t4m/Lt/YEOxTUOj/zrIh3E
w70/lNwMdAgMbSi+PyPSYeeqgi/HngY6/D80f77hTgSfu/Os1ozTCL63fMNX
jvvA8GOI+zT3fqADenoCADBlHPE=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHRT2+PrVl5EO4n9lE3dbBTrA+DG7/pnsWYLg2/Fe
Y68/FuiwzvWT0aubkQ4btjkWJlwPdJh1P/Hgtl0Ifk9MxtRtSxD8LdWfNhyY
HOlQHv6pY8+5QIc1t/tPfW6LdLDQsj/kvTfQYbG17hO1qkiHX3+6f99aHehg
eVIlVqgk0uGVwOTTtyYj+Euca+XmliL4RrMEt+5OCXTg2Ja9b2FZpIOG7WPd
0JBAh+vcm5QNqyMdAjdYPvvhEujAO5OJ5Wp9pMPD/LMN4maBDq79QS8qgPbf
UjY3f6IV6PBEdY23YX+kw9WV879uUA50kLt5/ELezEgHk1VufT8kAh16j6bP
3LYs0mHGhR2nbwoHOsxQmqYgux3BX1R/ZHnzcQTf1ebl+qtXIx1mf2suKJYE
+l+js0L2caSDzbc717VVAh1ebb0ZcfA5MDw3r6g4qo4I35WVtXOK9RF8WHwA
AJEkyRg=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI0wEUxucSJdIyAnOENC9ZlmaYXZTMT8RsJvX//712arKCCCzRZmmI
puZlLbXwltYSnbeJPWhOXaZ2MWlYLjNLNJ2ZCx/UjAjvhO3JQQ/fw48Dh++c
73O4GMdd2sDj8cyM2msU36gzerU6uptw+RqdGgvlkB1jXszXElYbsnfvD+Gw
LbYvX9ZCyI0RdIf4cvD1+jXZU0fIfNc2mnaAw4DgtGNqOaFxZdiry5nD+8Oa
MVExwT/paPwNAYclp9ohYR7h090ylbsVh3zxx2ZpFkHrHiPUrrJ45u0SZ5tE
SJeEJcj1LASLZfWLcYS1RCffzWoTj3rr+P4pJg4fMs8tDGYxXfmkQZhIsOyK
KnZwYPEyXs4aMox+215Uj6wxEKtt7fhyQvNVUYdhlkHJX8+HfgXGfd8qEmR6
BoqJ3nHpI4KFTXdfzwAD5RuJc101wRM/dvHfMthqrpPLmgmuIa1VCg2z/p8s
l4IHIhWDHdYe18NeEwSSTqmigkHgZ7a3QE2YkX642WOcDzNPzYPrCZHe1Y+l
jQwqLEoyrSoJ59Q+47VtDHR/bqcaSgnL89qani4GWpvZI033CLrzdUEyLYNX
I3fCDZkEpVvWnGiQQXPEfVdDLMGuPac8+icD1bKkKkVMWEgp0sosWcSeCLT3
CyX45OsH9zmyOFjkWmYmIqSV757oP8aitF3xZTKAsDQ173GLTOxvv+l7R7KJ
vZpU6XZtLDZqBkfFEQQ5T3M2YprF84XfW5qSCVbHW9yu2JryDKL+1npHDit5
NV+FRv8Z1jM+U27c+n3tkZadToc4VNIFYZ2SEDUn2Tlm7FPA9pw9S42EQmVK
jeAkh//7+A94lDen
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYk5Bxmzxr1EOSokC9haWQQ4wfp/606RnDkEO
L5fxzHUQjnaYtLBmiaRHkMNvq3lsJXrRDv/SA08c9w9y4FKfblbiFu2Qqaf2
pjQ8yKHo+IKtHR7RDqZxC9dkhyH4nFUqprtVAuH8s5y2/E/EAh0ctzwXk/CO
djiutuzkBt5Ah3JHi++7/aMd4mTnus3hDHRwn14X4x0S7aAxwSftB0ugQ4PX
rIcdcdEOkYtZWTOZAh26l5/IeJ8X7aB6ueFoHCOC3z7h8z/7XwEOS3QP98z5
FoXBh6l/yLZqWzFbtMOB907PHwPNe2HLO9NBMNohOuHiUia2QIdW8dnR8WLR
DtrbxLkncQU6hOY+PPBOKtoh0TnjtSl/oINylIZSnWy0Q7raf4NMCQR/8bRn
YQ5qCP6dyb8m/pIKgvPFZj/afFEtyKHTNo3hp3S0w4u1X3b+0gtyCGZ5tOed
RLSDvLXrrHnGQXD7O1z8ZDebBzlsye2INBOIdggznFrnZBXk8CiqLJiXA8F3
e/V8yjsWBH+lQNSl8/+jHDrX+ipuBsYv97kz3Bt/YMY3jA8AOhnSRw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYtmWjTm7BWIc0gujvO8EBzkoONbyhorEOBgv
vMp9KQjBv/zmcoi4QiCcP+PCjtM3hQMdQqsYA+PFYxzi2+Z4zeEOdFBVEQnu
kI1x+FYz+Xg7e6DDt7NqoRuVYxy+7D+u9o450CF11zHZnwYxDp/CTii9Ywx0
KLpywPWnS4yD6uWGo3FI/PYJn//Z/wpwEP/SHK+9IxqDD1P//qXO6vaT0XDz
tD6KnI27Gg2374Txosm1d6IdtHwl2CdxBDow1u0T2f0k2mFymGLXMp5Ah7nM
DVYOL6IdGG8d9HsnjuDfPJ81y0sTwc9PUcvyEQyC8ysPhnzcpBjkwKD1qVzx
cbTD03ZN0UTNIIdjZdc+Pb6B4MewnMs+fwnB/2D7013xdLTDE+PYiuPqQQ4t
yhHtNw9GO3ismx3kpBLkIHtdamkckF+tFfJ1k3KQw0u2aakhB6IdRO6JCVsA
+f6vLjuf3xft4B51fusKpSAHaSl/lqN7ox0e8E66rAvkS270Zzi6G+E+idjm
ZO1d0Q5uH89vXKEQBA+/ityOEEkgf31w1QOxbdEOq6/wTlCWD3IQNd+xb+KW
aId7AceMpsgh+KLuYuIWqkD3oaUXAPbO82g=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcxx0VbpeKzqY/nEuU/3VkVs67RUtSv98PpXwPo5jJdKVitKwy
NX/PNfmzjq3rNG12JUZhQ1G3XZxrolyK0PmTa7ab8qDukdt68Hrw2j5P3u/3
xzU5i7lgZWFhwTLhacLShO3iepaxmcApqfNyXT0FbWIrj2kiuOMuqYpopBAu
WnRXdxKU+S0XOLZR2F6l0pSrCKoGY9OmeikUKTMqP2oJMuoFdor3FEqllqNs
HcEo/8Pw4hiFRMXWL4JpAq701crrWQqqi3rW5AKBi0F/02uFQkOFNFz4hyC1
6693uiMNoZbHEbFE+KHwT/kOswuTQsG/bvY3fdbtQ09oZO61YwesEjjoWpoP
D9OoOeufIl4iKJ+Kqr+3TMNXGh/aN0sQ+Iw9bWfNIL4gIrh2goAjfOGd4cjg
9MPny6kjBF83Vmp9+Az0t7YIXNQEJyX7q6/6MDjav+Cp7ib4FXWmYeAgs9bP
alOhh+8JBo9s3/LzlARp4nOR49EM7I1p871dBL4eQpUskkFBro2S/Y6gLyld
YTjCoKPPbd8xDcFu5/EJzSEGxSMHgsRjBDx5mEwWyEDSoc6XTxK0ZF+6ZvBi
UG3wTxQvEuRk3o1x4jFQXPEsFluJwPpW+HjdBgbKoTj7UQcRdu3Mzfs8T2Pu
dvYDrrMI4WHBc5EaGm5BFTui95juA5Z0jW00ejY7T4h9RCia45X9rjb7WD4r
uTHH7DP6873HQ2iccpgZNW4TQVITq+fY0pBpB+RyI0G2NFnC0Zn31IaGlL4c
opAQwv0kmCKoKXG1udFPreUbyN1kGdNNoT0r7n7zIIHHVKusrpUCt0VQQnoI
fvrVOiU8pfD/P/4DlzIqgg==
        "]], 
       JoinedCurve[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
        138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
        56.516}, {119.85499999999999`, 51.789}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
        110.84400000000001`, 47.38699999999999}, {118.293, 
        54.922000000000004`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQze77c63m5wSHrqjCO9OzfBwmLIye9o0h0SF3rcf6
qB4fh/i+Rd9bmTH57j5XfjNreMH5bL5KupOFvBwmx6mbT2BJdPgb8XmlDouX
g/vj1RWz2BIdtN0eLmb+4+lw4qCgZzpHooPaGc+kC188HSR691Ud5kl0UAza
pDD3radD5usLdW+EEx223185s+M5gu/xmfOiwy1Ph5hj3B9trydg8N9I6N2d
9MrTIWnlIrPCBwlw84yDt1rMepbgEGF8fu6tz54O0iv27Vz3MsFh0rNXShL/
PB1krVV6qt8kOJyZybYilMPLIbs4+zXXuwSHZT/Wfd8ojeC/LvzBHmaB4Geq
9ah8/OnlcNJzzdbWRwkO7ssYu/ce83I4WP+Y4c2VBAeW/9uaJNd5OVzccjf9
+lEEX0w5RujsTgT/23WmtSIbEhxcrzA17z3k5dAlqNeZtiLBQWdh4fTNr70c
gj6WX/u6IMFBOO/B6pUi3g6yfb1H5OYmODC1P+W87IHg6/yep5bbheD3V93u
E7zs7bBAc79p66IEh+1ufworBH0cHDUl5tquTXDg1uNx3+bs41DNNuuD+w6g
/nXTHrws83F49clyZz/QvfmhD1/09vs4HFzpeX7HVQT/eM8DkTf3EPzn1y2r
lrxIcDjHuOeJdbOPA3p6AgDRphxC
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnV2c/ZrrXYKD9i/rQ2WW3g4w/paSv5kVvD5wfpXU
Gv5/AT4Okq8/SYg+S3CIyW1+dKDIx4Fvh1ZC9TUEv/2brlf1aQRfmu1zOMPh
BIfX654IVib6OIhvO/hk5p4Eh7yQupbpdj4OwmkTCo23JTh8/Cn+fau0j8M9
HR49zc0JDpcU1aZvfe0N57u0/7KxWo/gJ5koZ5X3eju4Ll5/r2BLgoNP1bHo
VTneDrrngibuAJo3P6H4zEdfb4cTItWNXDsTHPbfn8Wob+Dt8IR/cXEM0P4N
7nl5JyS9HUxu+y/dcSDBYXmw/etEbm+Hi1vupl8/muCQFtIr8/GrlwPHal2f
6jMJDjoLC6dvfu3l0HvzSP+6Kwi+MEfM5Yd3EPyUtLzrXE8SHIzfsj989s3L
YU7Mvt3rXiU4lLzZuT6cx9vBfPGz1QxvExwq0wI/dgkjwjvg8y+L50oIPiw+
ADofwRM=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pfbgiP9oxIdTj3aMm1Htq9Dy99qz4UxiQ5f
Qrn9Y2J8HU7/iz+WHJzoIHLVqGWmna9DQtLHgiafRAfmqbnb/6v4OmhdXTDh
nnuiQ9TXjZlVvL4Oy5OvvnVxTnSof1fw4NU3Hwe7qDNZBvaJDgtFDf2j7/g4
cHx/GBFpnejQE33FoW+3j4PsUx7z1SaJDv8OrHgmVO/jcM752GVpw0SHX2/d
qmS0EPzNxbNYm/Z4w/nL1nCKqUZ6O2yfcT7EAKifq2qjhjObt8PCBrsVglaJ
DkK5te6bD3s5fFBs5V5om+iQcHNS2fG5Xg487sJn9jsCzdtv/5yv3suhf8e9
vEg3oH6Flpmd6V4OQlqrBD97JTokNpzwZgnwcvDySjiSHJTo4Dcjy9Xc2Ase
Pmy+SrqThbwczvtNtDwVmeigf6DiqRmzl0PKJqUnL4DqLz+d87FD2MthbcEl
RlffRIdVRW6WT5W8HCZ6uziqeSY6bEkr3eNt6OWg4WS9T9A10eHD637PTnsv
h6UX8qUrHBIdpu306ecL9nJQNLVbJQgML/tIjruTs7wcZhU7ThE0SHTQK+K1
3jvPy0HUdVXAPfVEh5c/1fr5L3s5VGTL9O1XSnQoktq9PJzD2+H2xL7TC2QT
HX5b+R+Yb+vtwLvUPUtQOtHh3dnX8X8qEPw6K7FD5TsR/NQEf0ZDAx+HY4uT
3/qpJDrwM+ZtXjPDx2He4SL2CjNgeqjJiLz2ARGf3VvmZQdy+jrs4zuTYwB0
/z+pa6VnZH3h/stfz1fhrufrMKl0Ff9noP/X3Tlot8Pe1+Hx5T3CMoGJDkrO
Pz2MQ3wd0NMjANbYGCE=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4mMBv7asLk50cDykUFdg5usA40v4nzp6xtXX
YZs0g9+BpkQHJeefHsYhvg77n55gipqQ6PDj/KIJ/cm+Dsejj0pFzUl0OB/j
c+N1ka/Db22vqJS5iQ7pe5wirxcg+PxfPLLKeL3h/GnCVXInPno5JC16y7Vm
XqJDt6/P5MT7Xg5/X4j+/rsg0WGHlVWvxXUvh6fCO9e6Lk508FGYeebDWS+H
prduBSkrEh3Wu3FzXTrh5cAuc2/z9A2JDu7LGLv3HkPwuRWf/63f4eUgHH/b
Na8Ekw9Tv+n0uVuRNYkOtfdbzx0/6eVgms7gc6Ax0WHLgUXerBe8HFhC3Nf6
tyQ6BOfoi6nc9HJ4U/cqfnpbosOBtgvXsh95OQR/7RW4357ocMbnX+KlLwi+
i+7ZtQ0C3nD+FvWvyl9/+sD5WmZH0xcL+jqwPV9TLwPkn4t+WfxV0dch+9Sr
2OmtiQ5WZV0mttq+cPt5OudYpRn7Osj8t9WxBrpvZZLW3xYLX4fNX01WqtUi
+Kl733pOr0bwp11Y9oK9Ehj+0bOd0sx9Hdz1E1orSjHjG8YHAAMf76o=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4oCuS1trGZMcTj3aMm1Htq/DxQyLNi/mJIdk
p9XiSzIR/EU3l6/UY/GG83UWFk7f/NrLIbv11/LzLEkOu3ksp1rc9nIIucWs
+YQ9yeHlT7V+/steDjb6vKt+cCU5PKnv971z2suhRDW2b45gksOjtRNc7xz3
cqgyilo0RzrJwX0ZY/feYwg+t+Lzv/U7vBx8D1mvN72aiMGHqbe0Fbj6+G4i
3LxrDixp5x8nwu1TfeR1Mu55okPgLAM+lateDo7sNztrXyc6KK91EvG96+XA
f2qnjMPbRId/m5vn3vmM4K+bf9Vkqpg3nH/7hM+VGc984PwPTSsfpbL7Ojje
Ldq94VWiw3H+YK1DYr4OS5if/pj4FMHPP5Wwtf0Rgm+ZXrZ4w71EhyPpuz70
Cfs6MN9SPcxzK9GhN8Z8aQuPr8MFY/ag8zcTHT6FrHiVyu3rsO20i5EXkK+6
R1etgMvXIWNv8sL2G4kO3VvmZQdy+jr4hS5sZALy90qrLI/m8HU4t2BhPdN1
hPvOlllvNL2W6NDxaH5yIKsvPPze3RJYacTi6yD5aVu+9pVEh+CV0gruTL4O
px9fvZdxOdFh58KeVA1GBF+jT0evgM/XAT29AADTQQUn
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        146.52642112112497`, 55.48896844874999}, {148.49523116799998`, 
        55.48896844874999}, {148.49523116799998`, 54.99270331312499}, {
        146.52642112112497`, 54.99270331312499}, {146.52642112112497`, 
        55.48896844874999}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/aaggYOXOdmhK6rwzvQsH4fSo48+3BRIdshd67E+
qsfHwWWTZlCmMCbf3efKb2YNLzifzVdJd7KQl0NF07qJxSLJDn8jPq/UYfFy
0GE3vlwrluyg7fZwMfMfT4e1T2cs9pJIdlA745l04Yunw98NrleXySQ7KAZt
Upj71tPBjz/i5nnlZIft91fO7HiO4Ht85rzocMvTwfHVJG/F50kY/DcSencn
vfJ0cD+rOTHkQxLcPIlym8m135IcIozPz7312dOB4YyryKSfSQ6Tnr1Skvjn
6cAUv/pZ3J8khzMz2VaEcng5BEz/5Prub5LDsh/rvm+URvBfF/5gD7NA8DPV
elQ+/vRyWJdrLJD5KcnBfRlj995jXg7LFmdFn3+S5MDyf1uT5Dovh203Ug7t
uorg/3Z7nLPhJIJ/+3cn+4/9SQ6uV5ia9x7ycsg33frYc0eSg87CwumbX3s5
mIv+N7i5IclBOO/B6pUi3g5Mm0TkmdYmOTC1P+W87IHg6/yep5bbheD3V93u
E7zs7dDq6zYhY1OSw3a3P4UVgj4Oar7zvyvsTXLg1uNx3+bs45CgpeitfQKo
f920By/LfBzOix0ULga6Nz/04Yvefh+HZWcvaM55iuCv2ZCef/4dgn/m94Er
7T+SHM4x7nli3ezjgJ6eAByxFYQ=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHTD9k+u7v0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg4/OOrKv7xNckhJrf50YEiH4fPtzfuinuG4OdIbV0SdxvBZ9Cq2vT4
UpLD63VPBCsTfRz+3PSwrz2T5JAXUtcy3c7H4Uen+BmxY0kOH3+Kf98q7eNw
OGByB8/hJIdLimrTt772hvNd2n/ZWK1H8JNMlLPKe70dtI6bWYYcSXLwqToW
vSrH20Ho083Xs4HmzU8oPvPR19thrQXTnbcnkhz235/FqG/g7XDSWOucPdD+
De55eSckvR0k/1/7P/tCksPyYPvXidzeDttupBzadTXJIS2kV+bjVy+Ht+e2
LIu7k+Sgs7Bw+ubXXg5Ff71fTXyC4P/Qfqx79A2C79n11fDd5yQH47fsD599
83JobHAVm/QryaHkzc714TzeDjLHc9me/ElyqEwL/NgljAjvgM+/LJ4rIfiw
+AAAdJjPwQ==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxueByANoM6NNnbRqmKGbaUq52WMesm/fNw+UJtPM/V0zvFgJ
YZpp4kAtQsJKQ0pSRGUe8JRWRi7LPBU1D4XRmpGCM8JDCe2i9V1N6OK5+MHz
wvs877tHpU1RO3E4HAdWgawcWbk+PMjtCCAQD19ZDHeioE1zEipFBNsYYVAN
l0JAqn9znZiAl7XkECShULN+y1oYThDYoH83epLCeKlp3i+SYDpK40tnU6DX
2q4NHCPojGtt/lxAod/aw5mKIRCJCtaqaiisZD7gNp0gkJqnbal9FGa1+WHJ
CoLxIlu6cZXC/h1Pas3JBG+Z7NGxOLmdC4dLrsf2bHFFhcfFR940pENdu6bY
+b1PNZnluTRSZjBiSSDgv6mP8tLT8L2U2u0VR6BReU/4GWn0aphgGwh2Fuem
z63SkGyW3VRLCZ777GtRbmdgzQ3RGyII7gvVkhUBgzZX/5Y6CYGpvhPVkYy9
n1+n3RIzMhiktbs3aQ8QTHzruzeYx6C6MaPCi/WnK4rvyJQM4r+3Xxg4TFBu
MNILcgYql8jAuSME8dLBF00yBpPc2A6LjECWUCWViRkodB5JuuMEOcvmH2Yf
Bh/8ow0Wtq+f855th5wZnFmQfbSkENgMbnKX9zRMHrN8gZIg9uj65uN6GleX
VV+k5wgqK/Nnas/T2D2y2qBUs36N6VliCI2lrgiHFQ2B+2y078ZvuZ27/ji+
UvRv8dj0uO5ulBxB3T4lHWcJBKF6I2+Owqnb7jk6mmBR9FrIK9m6Z2NpEf+y
mkJYfO/fSXb/YF6MpzWJsue7sSFwbgWF7K8zShc2Pz2aJ4sQU/Ase5lmDiH4
lBUWOsSn8P8//gPm/hyd
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{242.777,
         101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
        84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
        208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
        101.48400000000001`}, {208.89800000000002`, 110.84}, {
        216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
        118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}}, 
        CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{
         0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
         101.01833734875}, {228.42917790875003`, 100.1214467175}, {
         227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
         97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
         100.1214467175}, {221.98906566875002`, 100.1214467175}, {
         221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
         107.2353207}, {227.01602828000003`, 107.2353207}, {
         227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
         101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
         225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
         101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
        94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
        88.67999999999999}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
        172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
      FaceForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 
         0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
         
         "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
        97.30146844875}, {187.73723616800004`, 96.805203313125}, {
        185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
        97.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
        121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {
        282.441, 114.262}, {274.85900000000004`, 121.848}, {
        274.85900000000004`, 131.20299999999997`}, {274.85900000000004`, 
        140.559}, {282.441, 148.14499999999998`}, {291.79699999999997`, 
        148.14499999999998`}, {301.156, 148.14499999999998`}, {
        308.73799999999994`, 140.559}, {308.73799999999994`, 
        131.20299999999997`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{238.125, 113.293}, {245.82000000000002`, 
        117.87899999999999`}, {255.996, 122.754}, {265.42999999999995`, 
        126.45700000000001`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
        274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4nSe4qYHM3McFiZeM3jREu8A459sSPD5VBzv
EHZm7Va3Bkx+dlXEwa6HcXB+gqyWlcrFOIeuOUZfAxpzHHp8fSYnHo1zsFfc
bhbdnOPQfnlLoN6+OIfPS60rUltzHF5OUO/m3x7nwL8wOWt7R46Dr8LMMx82
xzlUXrm0e0Yvgi+2LqFu+yQEf3P7O4dr03McttfmvZm3M85BZnfspO1zchw+
zewsvQO0LztmyVe3BTkO74v3XXA6gFBf/ny3ot4yhPmcAv4HfGbGOexzCkzr
a0Twn29dLmdUhOAnbSxbeTorx2GDGzfXpXUIfhrDwfrwWwg+LHzUHPubv8Qg
+Dw3zyTnA/l/A552/ymJd/hUwOXyKjrHYUbu8rWNZQj+GVudt93lCH76ul2r
V1XFOzisDFxcGZvjwGxSc1G/Lt5B41+USl9CjgPbR/eik43xDneb7qfOSMpx
sDx4ZuPlpniHn7XsEa9Scxxsn08Py+2Id6h5f+lXM9B9LnK/Lawmxzs8VXLy
Sc3PcXgqG7Lg09x4hzlWOgk2JTkObYWVS1xWxTuw5s3eKFuZ43DoYcIp6R3x
DleiHgmtrc5x+HV9w7r9++Id8sqXmBjV5jhM32hXeO9wvMPVt+5PK+uA7n91
aMuLY/EOtimvpx6sR/Bh6ePv3+rgyCMI/pQvRRdcDiD46OkPxgcAKo9Gsg==

        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+ksZaHa2imiVFplVhEVa+8yDyFtarmo7xc9bPEtstb15GQe
6sZsEptxJgojXYzMNY/LebpyTip3zkXdUs7jspTO+v3F1h/vP17bZ5/P5/15
f7ZGxYZc4pmYmJhy2s1pBSf+jMUBKwODwTQ4wG6eosbDdUfEJMN9z9tO16Yp
fh/kFzvqGdYurGnNGKHILCgPOjrMsCq8Qt38nkJgLWCSQQa3dIWrsZNiQJLR
xRtgkJs7x9Y1UrDHyb5TSoZQ24zSqy8p3Pfludm8ZQhqOu9gXkQR6PBmfbSc
YeWMX3xXEsXfhASpuo0hxZzvFRy6zBHdLaZJW5ZZfXlerJok0KvS9k61M2Sc
CMqObCfolc0lK3u4ff1qijc+JbA/5/WN9jJ4GL1k27IIDid1l4n6uX5x2fEd
SQSNszkBNp8Y0ovqesxuEuBi5ET1EEO98uP2Y9EEt1L4RY5fGV4MlT/RhJOl
+1jUp+SIAwmMD/03iMcZCqel1zXeBI8Mg81lXH0cr01oFkSgqRBreTqGoa7c
/JpTBM2pC3Z6NcNnbxetPozgzL3ZPOUHBlHa6xKzKIJ+i52/3FUMIRN5vh0x
BCdj51KVCganRuGEWEjQWTUfq2xlkBy/U1DI+fFOjHSWNDDctXwg76gkKH3W
f0VUy9C8uU8VIydYrfApo1IGMxdbnfUIgadu0Uf5nJsn/O7StLjM8qpF3YI9
XeIG5CcKwih+ajd1Wb5isMqqEORmUiiMu764dzJkvSvbUylbzlPxo612TE5h
8E/2n+rj8iwcPuTUR5f8HRn7I7swSNEijRyv1jBoRaft7UYp1lndmFKPMvD3
x5WcNVD8/4//AL5DSxs=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4i9dGydkseY6LP/IbFdxN94BxhfecSNR7Wm8
w5PQ7Zr1IrkO4kYFiyPfxDu8lW+4J6GU69D8w+U4+5d4h69Ta75J6OU6vNsn
+Xrr73gHzTRGM2X9XIdd76asXv0Lwe/jkjD5fSIOzg+aZcCnsjvOYcKdJc+y
DHIdfLbPPPFhY5yDtvLZa3uMch0er53gemdtnIOwX0Eni2muw1oFh1SLlXEO
G9T/eStb5TrcM/7JvHJZnINp2NT+MKdch1XJJUfmLUXweRSf/62fF+fgOHOS
oi4bJh+m/gFr2zYJvlwH1wazZ8rL4xySF25XrxfOdXjw4cgSp1VxDkZ9/zr4
xHIdNrhxc11aF+cgtXOhdZhErsOzy9GvSjfHOTTqu76ZK5nr8GbbJ/2VexB8
DfVboQ2nEPwElXcTrPbHw/mzta9tEjwd72CimBJ9G2hert2LHVaX4x1msiyy
DBPPdVhy2mLmvevxcPt5rzrKfL4d7+Bl+ZX9l1Cuw+2DHbVN9+IdHuq/aXnK
h+BP/r5ENYwXwT/CFXfkGFeuA5+do8JnYPyWZoonmrNjxjeMDwB3TepO
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk1EYB3A1LBc2XBOtlZIGKUIoiuZszaeIGeIlxwzTes82J8PJk03F
K2nmFG9oc9Ps4m1EpTiYigpSq0wlnQqKoUSZoK1YpXghEtP19umF+vD/8Pty
znme8/eRZ4rT9jk4ODjSOU3HiU58gXKbO4zAV7b58lYoWJLL5PY+BFefL7sl
rRSIOWciMy//b7eoXsPRxxS8iFf/3LuF0I98rtyZgGVW5WvXIbRLsyfXQwiI
9cpweytCtc1YWiplLDyr2NxfzbgkwmM4r41A2P1IkfEhglk5XvnVRMBuWJOx
GhF0NdmTF80E3LU8SKlDcMrnNtZaCPh7iHjGcoSIG6kFQbMEXDoqrH5FjEMV
7MPBWYxXnH8fYmUgqI54uXdMEeBWxL/vTkO41yNUL74hcNfmlS6SIoxES6eP
DRF4pVKH2pIRvksG77x8RuCkdjnLkohwQRbY3F5PoGIw0dT9dx9xuduBDQQq
c3wSRBKEJE1NF/YSSNqa0hiuIjyYZ3nkjxPoEi9VWujz1Yq+63MLBCZa+Ktl
KoTeuODRxR8EMtapjXe59H2OcdHHfxFIea6osZUzLh6p0gp0jL9FBVzR0PuL
ydiypq4RMGsMAYVPEdjC8yc2PxIYUfJvGk0IYZea55om6XlDrB2sfoQ6zodq
ziDjz16S9o0Wxmnrqwc5efT8ni67oi6EaMnOgFssgR49e0akRxgz7n3a8SYg
92s6J0hHqI2N0clG6T4kC64ZnzDOeVQrTOhmrH3Ns2fS7zmlYvdbxyhokNye
EdB9q8/2DN+ZoKCos0qcMIDQELS8oJ+mwOSao/Afov+HW+j9dp6CkOLIA8Nm
BBeJtazTSsG//f0DwMpEMQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{240.761020489125, 124.76413176875}, {240.761020489125, 
        126.51668522}, {241.289786616, 126.51668522}, {241.289786616, 
        124.76413176875}, {243.041090029125, 124.76413176875}, {
        243.041090029125, 124.227865413125}, {241.289786616, 
        124.227865413125}, {241.289786616, 122.476562}, {240.761020489125, 
        122.476562}, {240.761020489125, 124.227865413125}, {239.009717076, 
        124.227865413125}, {239.009717076, 124.76413176875}, {
        240.761020489125, 124.76413176875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPeHOZsE9d/IcztjqvO0uj3eQNBT71fEqz8H2+fSw
3I54hxeysdESbzH5q7bd/eMYFgfnc21vmdrpHecg8+7hLKV3eQ6stm+Dw1zi
HC4Upd3R+ZDnMMf4yQVHhziHwMAza35+zHOYWSZhsMImzmGhTOW90G95DtN3
+vTzWcY5fKrqflT3N88hqeGEN4sZgq/VVZGeoB/n8DT0WMiFA5j8v3O6cjvN
4xxeW8TOYj6FMG/Po/w5OhfyHIy1bvvqAu1bYl4p63g5z+ECc6aAj2Ocw7JT
997zXstzyL377VKWW5zDFyY1/7nX8xxu8pz+JRGA4NecfM+UHYfg715sOdFi
f5xD0M00SYkzwPBILjkyb2mcgxf/vJS6fXkOnAL+B3xmxjlEucw4nbkewZ+/
SawsfjGCX5++V2D5zDyHlb9KDsxbHOcgvPDFmx8T8xxkE9ecktwR53C7wciq
oyvPYcLxx1emnAG6V9ZDY2NbngNHyLPmlc8QfFk+50ll7PFw/jnfxGMntOMd
NHdWzhTvyXN4tPmj+R+veIdTOy4xXJiW59CzvFJJOiXegWVaSMithcD4eW73
fkttvENx0xcZJaB77axTPrN1xTt4WbIYe+9H8ANkZlfUnUDwC9K/3DW7BAy/
iYEf7zbHO6CnJwCaKhaD
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/YVJzX/u9TyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyveYVHV2prl5/McTN1NCxZUxztMd396mPcAgi/Q9mIt71YEf8nUtbsn
rclz+PP8afufoniHBa41HjrL8hz27jI62J0Y7zDnq9fVo/PzHOp7639JBcQ7
pO85NnH3nDyH/IVtp6QsEHzNKwWydyUR/O1arFt+c8Q7nDPKcmKel+ew9uw1
nak/4hy2xfJ+9VqQ53DNQfepxcs4h8Alpk/nLMpzSGM4WB9+K84hd37s9XdL
8xzit2iZqZyPc9ibxcXpvSrPIcpq8pcPx+McolxmnM5cn+ew08qq12JvnMNE
qxfrebflOcgmrjkluSPOQSyz/rPDPgR/znQx85JjCP7brxrWc8/mOSi0l+dv
BupXfVMh73glz+Fg24Vr2SfiHA4YLeSffA0Yns5zylnPIMJbj6tw9ubLCD4s
PgCVgsVC
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUh2fL1JWlubSaF0zRclbWJJUQf1Zg3mGVObH3NVGDbL6pm6EL
00jDGxpYNsnVB8W8F95iFHijmFhp+qFQx8yaloKrsCw1+n9y0IffhwfOgXOe
c9yTmTSVz+PxLLj4cNnEpd2GihI3MWhMHZmTJwkcBo+JBTwGQe+tuyWRBCP9
0vYwGwaHPuONuASCANLPP2DHIEoKT/O4RCBfsP80ImQwHfa2NWYRmBKni9P2
MFzofDV2MJ9Alma0Ubkw1Hp0/NpcTlCpGxVJ3RnqC6bz0x8Q5E42BPP2MyxE
/xA3aQl01xcfVYoZ5AGeyZ6fzTxoOhqSLKIbHHF2tccumsLgPeum4vrvyxvb
CnMofoYoRtT7GISKUI2uhqJvqkQ74MqgDf07G9NCcX68IKB9L8OdN43iFi3F
xMXuaqEjQ6qm6J38JYVmIqXrqj3DuLtXTfcYRXSO9EmYgCFHH/HQykA3/BQc
z/XKMFGsOqHVlc+waBET4bxCIdleVTXA+ersPaLTL1F8jTVkpe1gOP0tscFv
nmKLMkNS5MDQ3P5Wbz9DwfKv9aidGBr8A+v0Hyi+L52QSZwZAi1TlH6jFMoy
xbCa87W+rjojG6JYi8o0qH0ZijNz6081U9xUWXu+9md43HYlT1RF4XbunnEh
iGF4wvdLmZLi+SHPJkEIVz/0cWougaJUlC6oDWXYphJWBAWbmdguJ805mzk9
L76/dIZgzDn2dmIgg6NP+HxUG8HKWohc4sXw2yOuKqrQfM/4Ub/yPwqC90+N
VipufleXXVYvLpON/aIEfIvqZALLSOvUZzsZWrOb6iZlBF2Ly0mVWxmy+yp2
a2IJ/v/Hf9LcI5o=
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
        324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
        137.844}, {333.668, 133.09}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
         "], {{322.62239645999995`, 
         139.61787444875}, {324.47745303749997`, 139.61787444875}, {
         323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
         139.61787444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
        "]]}, 
      Thickness[0.005154639175257732]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 114.809}, {
        261.641, 109.93400000000001`}, {252.207, 106.23}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
        102.85199999999999`}, {251.016, 109.52}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4lVX3jQ21OQ7yFx8ZLiiIdoBxnf5kOO7KT/a
YdYU9a3PkjD5z16mHPK6GwXn3+4xs35yJsrhbMqaLx+S8x3Y90ZMUTwY5dD0
0sDsd2q+A5PzwaB3O6MczPK2lrNm5DukMJj0nN8U5RCUeTczPDvf4UT/0rMb
1kc57Jnjs9uiAMGPLLtVG16K4H/zz3Aoq8p3MHpb9TZua5RDfPP1ieH1+Q65
nNPK5gDtW6ci9/VZU75D1uNTF5n2INR/Cjuh9G4hwvyW+uiDPFOjHBi5T6fq
pSD4WnWKcpdCEPyllR9WZPvmO2hvE+eetArBf5h/tkH8GoIPC59MTs7mKfYI
vv9Ct2R+IL/iwMeePQXRDqaWLc5ddvkOwnc3r3MsQvDd11q88y5G8B/JHl+T
VRbt0Fx4epGkQ75D3eKOS+8rox2yj11R1nPOd2hICCnurI12UPCOTLVwzXfY
YnBz0+S6aAcbt8bwLo98hx1hS8J1W6Id9m/3+aUMdN/+XnarX33RDhqvd3uz
BuU7JPQmLNw0M9rhPtOy+Dth+Q6MD1uXsiyLdvAwE924NzrfwTYw9/TtzdEO
4soxQr5x+Q6l7nvX1++KdthoL2dyKT7fQUjRu2je/mgHiW0Hn0gmAt0fdX7r
ikPRDg06qVMTkxB8WPqoyO0IkTyA4POn1F9k2YPgo6c/GB8AErA0Qg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxw+NLT3IWqNJiZKQ1m4T6/K20e3qqonQ96umViy077kbyTy1
8zAkI6vsmHQ4mahwXOcht8tV85DMVTsq1VTIP42i2fX7y2398f7jvc/22fvz
+rzdLrBTl2x4PJ4Vp72crDkRTS6/ZZghPpkcm/hFsWBu9uCNMvxtyvPcN0dx
yKqsVmdgKE5w1oknKUYv7hRPPWOQv1Kbsl9TKN6OJgq6GVqX3/F79BROcbYv
lZ0MwVcPSlI0FK0xK6GlbQxviu6qfJspri058rtaGQy+CTsMCoqb3wSOax8w
5MRGyAozKYKO/G5Jr2cwp7oLNoRbvClgyDrYxeJPG9cUl88Q7FHw9pc2Mtj1
RFe49RM4yplc0sLlVfcq39cQnPdQT5sfMzxJEmm/3CDIFIWoXNXcvo81soJM
Ap5249Gupwy2DrpBfTKB3Mc0F9bHcABfd1nHEWjFZTW6AQYvccd9RRRZ5ZO7
u+y2SEiAMN1mL46fc2y3VBFEMN4e3ifkeM1Kh9P03NxVZjOp7GeIClBWSU8S
WJ9IccnrYaBtgR/qIwkqQ5IqJRqGpQVDnf4swZaxe4vGdoahmAZhQTxBuT/L
k3C8an1y50UyAvtUKZPUMThp8qvPlRDkC03egiqGxYxbhgIVwY8rxy+73mEI
LJkc89YRiCv6GsxlDNnVnp9GJgiyVGmhklKGP9MLflnLFh+8zX5Ku5Wuev4j
VY5TJIV/Q8WLh3cZCnmdZyKLKBwGlJ+NTQzrDrf7JKot/xSSkY5GHYXfphVh
KZf/+vrZwOlBunqfJsqu232cwibNNBPWyxA9H7t9gutThPHnfPpzhvLajDrn
7xT/9/Eft5A+ng==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYvNg7QlcL/IdlBIF7C1uRjvA+H3qT5OePYh2
UJcz1JT/nu8waWHNEskX0Q4SX/7kxTAVOPxLDzxx/H20g4z+76oYjgKHTD21
N6Xfox3Mpu+d9RDIN41buCb7G4LPWaViuvtIFJx/ltOW/8m2KIfMIP7iVs4C
h+Nqy05uWBvlsL1UOXsdV4FDnOxctzkroxy0uUtdLnEXOGhM8En7sSTK4ef3
3UsT+QocIhezsmYuinKw6W93rxYqcFC93HA0biGC3z7h8z/7WVEOLYk8imeB
/kHnw9Qrn/u/dceHfIcD752ePwaatyzTUF3+W75DdMLFpUzLohxKwyo61v3I
d9DeJs49aVWUQ2yjtPW3X/kOic4Zr03XRzkc+b7vte2ffId0tf8GmTsQ/MXT
noU5HEPw70z+NfHXrmg4X2z2o80Xj0U7lL+8G1X9O9/hxdovO3+di3a4c0ba
8tvPfAd5a9dZ8y5Hw+3vcPGT3Xw92qGXMZ991td8hzDDqXVOt6IdVH6ktrR+
RPCv7ZdT/fYewWe/fP1w2tt8h861voqbgfG7w3BiwvWXmPEN4wMAp2z53w==

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4pMLCv5EBhU4bLm2WvnW/SiHiVPfbvD3LnBo
n/D5n/2sKIfTORHz2yUx+d3b9i2+OT/KgaHna5W/QYGDwV1XESXGaId2308T
/K0LHKQv1J/dqB/t4L3uw+zzDgUOrFG7mhxjEPydqwq+HGtF8H+tVDpsPjva
Ye+GO4vU7AscLK9f7VyxJtph4dYtG64AzeP7XX+WZVe0wxqdU/NrLQocap/L
T/M5Hu1g9v5+j5pJgcPWu/lVH85GOyw1Yfj8WA/BtxE7wpGpheALP9/VdkWt
wOFpu6Zo4sloB+3lT3LUVAochBS9i+btj3bIvOltUqxY4GC/K+f87a3RDo0z
S6WOyhU4pB053Fy/JNph8xq9naYyBQ57L1jPTOiOdniy/3n4MlB47G369b43
2iFtnq9GsXSBw+XP01frrot28Lun7KQI1C/qLiZucTTaoYxX98hWoPlvLu+P
m3Il2oFt881vE4Hu0d1nd2zey2iH6zFvfuzSKXBIL4zyvvM52sHfKd/V1QTB
TzjW6PHOCsEX57ikNQkYfsdvMbxQfh3t0KDGJ8rrWuDQudZXcfPNaAfmGTe3
L/MscNi4fcnVsBPRDqv/rr9wBRi/nI0vui9uQvATehMWbpqJ4D9I+M19sSja
gfGDQ12xW4HD0cPsOy54RDtU6blkFAPjw1GW++FuqWiHy9/b5d6pFjiw742Y
ongwyqFB8PbaZS4IfowR8/wKdwT/lYvX/3agexbelNq27FCUQzZfbcY7rwIH
rsfKlruPRTnc38G4ssKnwIF3wfubIaeiHKpefTNM8QPGT3ObfMflKAfrxTHM
GwMKHJoOf2rJfBTlgJ5+AXWQVZY=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxnUFhiyzJGtZ5lylmKmYRUXqkximouCd3pdE52XaUt+ZVmMu
L2UqrpUJQx3MgtzIQAwvmRcSTY0itFZg6tJYRpuZmkSFUP0/OejD8+GBczjn
+Z0jFBfEZ22ws7Oz5+TDicdJO6dZLBEzCNL6C7WhBDEDFT8S0hmuH6jTREYQ
tPY7P/6exaD2Xy1zTSaYdXyenpHLoBlPkpjFBIq45bguKYO0+bCTPp/gpGOy
iJfPMOn59s2inGBFPZXJZwzb6/t+PasiqB0cX/wpY9i7bCk92EBQHtn7J7aY
IXvgr29uN4F307l218sMX/QBGZ/mbD4kLRSeO+i6Hxl26Jk4Q9G5NFmg4vpd
TB1tpwopniqEo9pChlvmmOaaeop9Ub7B7dz8I48c550MFGzEsNbC7ccP6fSV
dlO08cN8zl5gmNt8x3hoiMJlVHDC4TxDbF1gQ/ErCqvGuacwm2ElJuXu2DRd
57PWWunl95ViSOJw9APHTyIj0TOrFCaxv3cAV+/nFfJCt0Dx5FqKgMfxGk7L
1S+bKSI0OvlWjtd+95nZ1zMUa7tEfW55DB73w3W6dxQDxmpVTgFDRxG7tPyS
ovSecMSNy3MlrzpRMEgRxvOY0HL57T9WtmzUU1Q2Lsi6FAyiPXLFdC1Fwo1A
Y/hVhtPhx63RMgrPi/Kgt2VcfdCSyZBMUWPZPe9WwVBl9VD/Pmbz70vsxYad
Nv/ZkjkUZSLwtapFSiVDXWOShf+AAKRKk1PEUFQvruMrbfc0hgbf7GUE7Z1T
GSpu/0aVcJMym6znG5Nv4SWmEkSUS7c95Ph6mbt02iQC93jxbVcJwzf/JkFq
NMH///gPECMu+g==
        "]]}, 
      Thickness[0.005154639175257732]]}, ImageSize -> {388., 165.}, 
    PlotRange -> {{0., 388.}, {0., 165.}}, AspectRatio -> Automatic]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.825905024147108*^9, 3.825905072463655*^9}, 
   3.825905363382402*^9, 3.825905528383874*^9, 3.82590787412798*^9, 
   3.825908032251772*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "5"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.002577319587628866], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
       388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
       0.33199999999999363`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
       24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
       3.9919999999999995`, 13.508}, {3.9919999999999995`, 
       24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
       45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
       24.836000000000002`}}},
       CurveClosed->{0}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
       21.99788154, 23.851453813124998`}, {18.552508993125002`, 
       23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       111.074, 44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {
       94.133, 27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {
       77.191, 44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {
       94.133, 61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074,
        53.512}, {111.074, 44.156}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
       59.891, 34.656}, {67.65599999999999, 36.809}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
       39.508}, {68.684, 33.461}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
        "], {{57.68489645999999, 
        38.21162444875}, {59.53995303749999, 38.21162444875}, {
        58.612424748749994`, 40.420441815625}, {57.68489645999999, 
        38.21162444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       384.125, 140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
       363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`, 
       129.164}, {343.10200000000003`, 140.49200000000002`}, {
       343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
       363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
       140.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       357.65797799312503`, 140.37615644875}, {361.10335054, 
       140.37615644875}, {361.10335054, 139.507703813125}, {
       357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
       140.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
       71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
       147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
       80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
       156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
       90.35199999999999}, {173.45700000000002`, 80.99600000000001}}},
       CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
       
       "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
       62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
       77.762}, {132.35500000000002`, 70.23}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], FaceForm[RGBColor[0., 0., 0.]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4vMSz1gO/o10kLn4yHDFg0AHGN/lQ47vpvOB
DutmRGf3nsLkP3uZcsjLFsG/3WNm/UQn0EHMMvXVwjORDux7I6YoKgY61Dvl
5W67EOnA5Hww6J1koMML7/IPp65EOqQwmPScFwp0kHc6fiXvdqTDif6lZzfw
Bzp8WrG03PApgq8Tc/BP3nsEP43/buOan5EORm+r3saJBjpYlu1WyWeOcsjl
nFY2B2jf9R0er3u5ohyyHp+6yCSDUP8p7ITSO0aE+S310Qd5vgY41LQuOiNz
FsE/n+1vm7IOwT+a9DZo+vxIB+1t4tyTuALh/If5ZxvEzRB8WPj4Nsmxv2xG
8CU3zTx+rynSoeLAx549FwIdnj4U6bjSGOkgfHfzOsdLCL77Wot33pcR/Eey
x9dkXQt0aAxa7Pa5JdKhbnHHpfc3Ax2C/mz1kOmOdGhICCnuvBvosJt1/2mD
/kiHLQY3N02+B/Tfb74NV6ZGOuwIWxKu+yTQ4ce9pV/Zge7b38tu9etdoMNp
15YZp1ZEOiT0Jizc9DPQwaI04kDFpkgHxoetS1nYghy475glW++JdLANzD19
WzjIYcXWI6pRByMdSt33rq+XCnK4+84jM+VIpIOQonfRPPkghzW3+099PgZ0
f9T5rSuUghyqTlzTbj6J4MPSR0VuR4ikAoLPn1J/kUUGwUdPfzA+AMXUQmE=

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmdIlAEYxy8LL1CjZXhkltvcmEZeKX8hMUf6vq85egxzlJXmzoFY58rR
IeGpoZjouYlI0dTEFSZeWCpliPNsmISWUGSZp9l98qAPvw8/Hnh4xl8/LJa7
upPH4+1QYq5ETYntR+1I3RrCtXjynPXlEBEb4fG8gaB4dNfU2ovDz3jrs64l
BHGkYMDLiYOeI1uelUvIHu6YEdlyaNVrmRTeJjSvT9r3GnF4fFpQzL9FcEk5
FZck4DBtxi+URxHe3itrtNLkEBNmd8P2CkFmFXlMpmBR7pxv/M6fkBFyIbFg
jsW6Yj243YewlWzotKdN5TOOI2ou6Sr3m9gllniweFWvFSr3I/B7A0v09VlU
Jy3zpaHKeTv6aqe2GDg/Sx3tv05ovene/ekrg2S1Up/NOGW/+arEvDkG6Z8t
Sm3TCOp7B14PvmGQ9XJgOjybYIcFY7UhBj9228BVQjju1V5T0cls3yfHpOiB
eyODjX1F5vulBEFIT0JFFQOTqTaRTzFhOWE0dVBZ7/I70M3PJwQ41j5MaGaQ
ofHbcVhECGoTyus7GDxZWzghTSH8WZXVDfYyaNL2XomOIYxcanDLkzGQypc0
pOEEqWXOivs4g+Kg7/PV5wk6XbmVwd8Y5P8dCBQ6EX6lF8vy+Cy8PRvHN+wI
wsK5cQsDFgfLxN79ZgRRpen7sTMsUvs2xdWGhLXFVZs7pHKXIxofutNUbt/S
mKHTwWKp20Fy+CShgNd50X+JRYXCdyiaCJrOTy2jDqn+6UZj7U0GHGaK1Ivk
0YRMrWXhoiW3vV9XAL/H0IFD5uUXE+GZhMCVkKOzyjwZ6X6Rt98nSKTpdYJz
HP7P4z+gsjI1
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4leiyYpXr0Q5KCUK2FtYBjnA+H3qT5OeOQQ5
nFqdF/zvU5TDpIU1SyQ9ghzu2DPsNeSLdviXHnjiuH+Qw2vtn28M1aIdMvXU
3pSGBzkEn2HKcdOIdjCNW7gmOwzB56xSMd2tEgjnn+W05X8iFuigtNPz7FWt
aIfjastObuANdIhwm7W2Uj/aIU52rtsczkAHjTkPhDhNoh00Jvik/WAJdEj0
/zPdzS7aIXIxK2smU6BDzhot+bV+0Q6qlxuOxjEi+O0TPv+z/xXg0Gqk6hx1
LQqDD1N/iJsn1/BZlMOB907PHwPNO+mU7//vQ5RDdMLFpUxsgQ5pMn8FZb9F
OWhvE+eexBXoYFbkXL7mV5RDonPGa1P+QAeW+K4b1n+jHNLV/htkSiD4i6c9
C3NQQ/DvTP418ZdUEJwvNvvR5otqQQ5ZTie2bfsd5fBi7Zedv/SCHEw4XYrX
/IhykLd2nTXPOAhuf4eLn+xm8yCHqUWv+L+8j3IIM5xa52QV5HA4/gbn6ecI
vvp7T+81TxD8LtE9Hb33oxw61/oqbgbG75tLeofybmDGN4wPAGTi3Ew=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4n8dwsqVH6Id0gujvO8EBzkwut0/LPQl2sF4
4VXuS0EI/uU3l0PEFQLh/BkXdpy+KRzoYFafzC77Pdohvm2O1xzuQAc2zTJO
t7/RDt9qJh9vZw90uH6pgzufOcbhy/7jau+YAx3c9mtc2SYQ4/Ap7ITSO8ZA
h+CbSn+2qcQ4qF5uOBqHxG+f8Pmf/a8Ahx8/noq+nB6NwYepv/CuL9F1ZTTc
PO5vZc0yW6Ph9q20YPGy3hPtoOUrwT6JI9DhUZPC6Yoj0Q6TwxS7lvEEOtRx
PPrw93i0A+Otg37vxBH8m+ezZnlpIvj5KWpZPoJBcH7lwZCPmxSDHB7qhejd
PxTt8LRdUzRRM8hhebXFyoU7EHxbTgOl3k0I/kWn6H/3VkU7PDGOrTiuHuSQ
qrHLdvrCaAePdbODnFSCHP7dromWAfKrtUK+blIOcjjF/UNaaEG0g8g9MWEL
IN/gvemvnnnRDu5R57euUApy+CO3cVfT3GiHB7yTLusC+b+2btzWNBvhvp+J
TyVfzox2cPt4fuMKhSB4+FXkdoRIAvkTIu5MuzI12mH1Fd4JyvJBDt+spUr9
p0Q73As4ZjRFDsEXdRcTt1AFug8tvQAALfsFRw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx50SNQ9tRZ2tPFRuebizZNXy8CZtotPv94vZ6st0iUSF5KEn
VyMy4ejsUHexwlyr2XlKqKFcJE8lF7eyq3SauEwTtfKX2/rj9cfrv8/7/f7Y
Cc4yJ1YYGBiwlnBcwnCJSV10oyKPgB3Rklgmo1AXueGdRQ5BhoOo+EAVBQfB
IXXObYI83qzQqoHC71LnbH4NQXFfSLSmncLJ+l5/sYIgVuZmXvmawhlJZJ6y
hWDE/s3glIoC5Mm3dJ0ElkVP5jsnKMgTAptkrwhsZrTpTvMUrornFhdVBFGt
f51jrGjYjFxrtx4n+FrpevwT9O4V4Q37FL0/7zBu6q+mEcSNf6Z7T7BOrXjo
M0jjQnghm9dHkK/hy27M0rCQtM4Juwjca9d8Njdm4JEpnw59SmDqVecca8Vg
V8X6mq0NBB/NCodc7Bl0Z53Tjj0gCBLtkJx3YcDpCRrPkRLo+KF3u/Yyy/0s
1mRyuAcZZJg7qnYXEEQnHAkcO8xgduFlufAOAZfj1S0NZHDsyqkoZTVBR0RM
5cw+BqXK6xNGtQTbNo99GPBgEDcqmeI+JrC95yeVujNIbOO5CdoJFEnxyTNO
DNLmCi15vQSpp7OD2bYMslJzfXgaAtZ45v2VqxiI3jYrxbMEWzalXRz9RqMn
e5g/9Idgv9+eycABGkYePwbXmoSBtXNaXdVAo8JSKOaZhSFr0jbvl0Tvqkss
QVWq3r9oI9sDPGm4bvTPr1sgEJWEaE1X00gf2X5UMEyQVCQQmar1ew55e95s
7qfg7ZtSoFu6vyTXzuTyC2o5X1eahWFwG4WSpOaAuEcEHE29tKyews9Gsa91
OcF3Xik7XE7h/3/8Bz1JN/w=
       "]], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
       138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
       56.516}, {119.85499999999999`, 51.789}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
       110.84400000000001`, 47.38699999999999}, {118.293, 
       54.922000000000004`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pVX3jQy3EhwMF10NDmg1ccBxm97cHNWSrKP
w4wp6lvT9mHyT1w+2TLVzhvO3yyZW3ZC1tvhTMqaLwX7Exy4qjZqOLN5OzS+
NDCrPpjgwNjWtPTOdy8H07yt5a2HExyOMGRIzH/p5RCYeTfz+rEEh15579mJ
j70cds/x2b3jNIIfUXar9voFBP+rf4bDt6sJDom3vt7a+87LIa75+sTrtxIc
bgjpvLVg93ZYqyL3Ne1egsOFY1MXs/5BqH+0doLrneMI81n+b2uSXOflwMB9
OnXdfgRfs05RLmgDgr+k8sOK1ysSHIJz9MVUbiL4++/PYtQ38IbzYeGTwcnZ
LDIbwfdb6JbcPyvB4V3DY8nKVB8HE8sWZy4gX3lXemxzBoLfFVV4Z3oWgn/I
ui/yaoGPQ1Ph6UUzgeb9dBNcer/cxyHr2BXldfMSHP4dWPFMqN7HQd47MnXH
ggSHtMRNqeqNPg7Wbo3hXEsSHHLXeqyP6vFx2Lfd59dioPuqpflLviz0cVB/
vdu7dW2Cwx6pg06p230c7jEti4/ZlODw/yC3N+cFHwd3M9GNttsTHCoW3Zq2
/bWPg5hyjNDZnQkOz/qq4v//8HHYYC9nErQ7wUHBadoTG2ZfB/FtB5/M3JPg
0L1lXnYgp69DvU7q1Id7EXxY+nh3S2ClEQuCL3Pi3yLOP4j0hJ7+YHwAJ5o5
vg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+8c5mHucp6WsenoSYgYYtx7HvP9/X4kpV1s/b4tCunaGd2M
zjxs6clEhupkbVQzzdzK40hb1GrLSGvYmg1F7GpiFNfvL7b+eP/x2j7vzz4P
7z3n1CcyJCKRSCzIW5CZIFV3eZCfN8W7GUNdVw6HFVObV4kPxcop26T0dA7h
4urmKE8Kx09HyhsiOXw8r2CpG4XkXu5LkxeHxs+jOf0uFGd+d2QV2nFwybR8
6+lAoVu+8nVhlUV7+masTEbR7BSQlDbFQrsuDwq1pbiVNo47vSxuz0fIb5hT
bA0+mZPrWETGrbVviCg2luIK3bx3uDOv0aK0j9nmljZr570qBvvvi/xlgt+m
sONAtCUD+zJ1mdGaQp5bHN/5moD3ejGns6Pgv9wtGH5IUJQQ06q3F/oNKOel
OgJTj4yEOgt+j/KGygsEpT6TP0ZdKWjJCGN+nKCHrW6KUlAk1mfHhgSS7ftY
cgrfGjmBMnnI8elBisOD2tlgCcG4IWVgWKgfm33w87oDgXueZNrTneKZJu7o
rIJAnJjvZrGbwpCZ38cEENTHXGowOlIYF6sSKpUETmOPVlN3UdR1s1XSFILq
EHWF0YZCqbKarskmsCnQqI0mHn4au/B+PUFF/OSh/jUe39f3VcnGCL7lcln6
Xzw0rr2tp60YMLUDLbolHn/CkgabIhgUt2pjjQs8lj8snv2r3eFrYc5DV7t3
OINPEgf4swhuqR3xXeEhE1/ubKtnIX3zeCbVUshD0UXVhHHnnzcN+pxkaw5+
9pvxMmH+LdeJ/Pfu3PZ+6udSbbwfBzPt5MKosH/71KvILiWHlIml5Q0PCkX0
+rHAkxz+z+M/U8AdhQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYrNg7QldzokOjocU6grMfB1gfAn/U0fPuPo6
qMkZas4PSnRQcv7pYRzi66D/4uddi4REhx/nF03oT/Z1MI/79tUiJ9HhfIzP
jddFvg7ZetWmzrmJDul7nCKvFyD4/F88ssp4veH8acJVcic+ejlcWiL3rCsv
0aHb12dy4n0vh9zXbtfuFCQ67LCy6rW47uUQKvaqQ6U40cFHYeaZD2e9HD69
L/d2rkh0WO/GzXXphJdDuRx/f1lDooP7MsbuvccQfG7F53/rd3g5NCfyKPq6
YPJh6pXO/d9q4ZPoUHu/9dzxk14OSzMN1ecHJjpsObDIm/WCl0NJWEWHXkii
Q3COvpjKTS+HmEZp67KwRIcDbReuZT/ycjj8fd/rveGJDmd8/iVe+oLgu+ie
Xdsg4A3nb1H/qvz1pw+cr2V2NH2xoK9D2cu7Ub+B5p2Lfln8VdHX4fYZacuy
0EQHq7IuE1ttX7j9PJ1zrNKMfR16GPPZpYDuW5mk9bfFwtdB+UdqC6svgn91
v5xqmTeCz3b5+uFnHsDwj57tlGbu67DdcGJCuCtmfMP4AI8U44k=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4gM9zBNjLiY6nHq0ZdqObF8Hx+zMRM3LiQ7J
TqvFl2Qi+ItuLl+px+IN5+ssLJy++bWXw+127eZ1VxIddvNYTrW47eVw5I4J
y+HriQ4vf6r181/2clhjaNd6/Vaiw5P6ft87p70cnqj3ZVY/THR4tHaC653j
Xg6vTLprq18nOrgvY+zeewzB51Z8/rd+h5fD3iM5XSJLMfkw9SvtHTccWosw
z83Z1HHdZoR9U59UL7HdnugQOMuAT+Wql8NGTq7UmN2JDsprnUR873o51J95
9V1ub6LDv83Nc+98RvDXzb9qMlXMG86/fcLnyoxnPnD+h6aVj1LZfR023l88
rX9XosNx/mCtQ2K+DiJsYlcKtiL4989MnJC2CcFfmbm8rn9dosOR9F0f+oR9
HYrvhM17vTLRoTfGfGkLj6+Dg5mF7jog/1PIilep3L4OaudKeTWBfNU9umoF
XL4ON/ZPqUlbkejQvWVediCnr8O+8EsxD5cnOuyVVlkezeHrYLf4UtTDZQj3
2Vbm9IgA+R2P5icHsvrCw+/dLYGVRiy+Dp1fnntxLUl0CF4preDO5Otg/Yxt
l/viRIedC3tSNRgRfI0+Hb0CPl8H9PQCABJuC3s=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       145.02237524912496`, 55.48896844874999}, {146.99118529599997`, 
       55.48896844874999}, {146.99118529599997`, 54.99270331312499}, {
       145.02237524912496`, 54.99270331312499}, {145.02237524912496`, 
       55.48896844874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHVO88fHrS0kOXVGFd6Zn+Tg8PS58ZseDJIfctR7r
o3p8HLZsidL1eIzJd/e58ptZwwvOZ/NV0p0s5OXwouV+TtCTJIe/EZ9X6rB4
OczhTFkX8yzJQdvt4WLmP54Osi9O1mm+SHJQO+OZdOGLp0Pu5rINrW+SHBSD
NinMfevpsE+wc8u6z0kO2++vnNnxHMH3+Mx50eGWp8PGN4fVGLZj8t9I6N2d
9MrTYfv5qBzjAwjzOipz82KOJTlEGJ+fe+uzp0PBubL3BSeTHCY9e6Uk8c/T
oSjxzkHbM0kOZ2ayrQjl8HI4MFNZ8ezZJIdlP9Z93yiN4L8u/MEeZoHgZ6r1
qHz86eUgV5Dy2v0QMDyWMXbvPeblILZsttm6LUkOLP+3NUmu83JQuz117syl
CH62p4hH/0wE3/vfrkfX+pMcXK8wNe895OVw3/zZPo2OJAedhYXTN7/2clgu
bsCzoyHJQTjvweqVIt4ORVtcfz2oSXJgan/KedkDwdf5PU8ttwvB76+63Sd4
2dvhq395tnsTMDzd/hRWCPo4TPO/cOl/T5IDtx6P+zZnH4cLOkFqXDOA+tdN
e/CyzMfBXvLTu0Cge/NDH77o7fdxELvAyFq9FcGX2TzDa90+BN/m38f1aSeS
HM4x7nli3ezjgJ6eAHrsIys=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQfWCmsuLZs0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg45Amu9rt+NMkhJrf50YEiH4fke4+m2m5D8O/IPKu3XY3gF+is7j20
KMnh9bongpWJPg45dyqlYuYkOeSF1LVMt/NxyOjxWP51apLDx5/i37dK+zgY
Bx9Jfj0pyeGSotr0ra+94XyX9l82VusR/CQT5azyXm+HWSfTRYynJDn4VB2L
XpXj7dD0het41bQkh/kJxWc++no7yFobbz8zI8lh//1ZjPoG3g6WZtEr5YD2
b3DPyzsh6e3Qychxu2pBksPyYPvXidzeDmq3p86duTTJIS2kV+bjVy+H2ItP
G23XJDnoLCycvvm1l8Oj/zVHC7Yg+Bl6IpxL9iD4O3vUeM8eTnIwfsv+8Nk3
L4ePTWUfC04lOZS82bk+nMfboefkvIeHziQ5VKYFfuwSRoR3wOdfFs+VEHxY
fAAAcRvEYw==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk3EUh+c1TWXihdq0gbP8YKhLLfEy+0kz7N37TgkSh4b5/tOJRpeF
rEyWaegsow9LK+xiaWQaBktFyryEtwlJzZTSspkplRnqUjSU9X6a0IffhwfO
gXOecwLYU4ezHXg8nh2XYC72XAprM+avrrII6z43s8+Bwhdl5Eb0CgtnRhyi
96JwKy2lWGNlIcictQuRUHBY7hxNcyYIvt803H+IQnQJv219K8FIvMqfzqLQ
YRlPq+YTNCc2PJrQUNi1MT3R6E0QFKRZrNBTSD82PH9pG0GcecSa2kIhUV3H
l4gIjIVWpWmBQpX3T3VXAMEbJqt/MFFu4/Pd2mKZYZPLy/mnH/jSeNppXmzk
+gNfqI6W5tJ4PXbmnnE7gXCgJt67iUbl2fLKJR8CFes7tMNEIzBP6zrpSeBT
lKscW6BRu2rIkbkTvPLb+TjdhUFePltWu4XgtjhbMidiIPBIKdHwCCZrmnE9
lrH5+XPELTkjg8FAs1SrWGMx9LWluj2fgbX+GrvE+VIqim5I0xm0zX6WVTsR
lPaY6Ck5A5PbCadWV4KDce1ddVIGsb4FOqMHgTSpIk4axqCzDLuJF8HxH+Zf
Zj8GCWL1HSPn6/e455NwRwaD0ycNRjGBtcdN7vqWhsLLeWU9mEAWs7TSVkNj
bk7f7ich0OnU72/m0ND1BVyI2cvVqyZfJu+hkWrI/WSMInAfTfC3LMtt/GzN
vlfRusmDI8bLVfFy3H1OKytDCUQRTSbBGIVevXQ/8SeYCeoTC7Sb93x4sVBY
kE2hPunbx0Zu/lDBAc+/KZRtvysWkWMDKLybcor67kJA9+dLo8IoFJdawrvs
CD5kRkZ0CCn8/4//AGdIJ/s=
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       242.777, 101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
       84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
       208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
       101.48400000000001`}, {208.89800000000002`, 110.84}, {
       216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
       118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
        101.01833734875}, {228.42917790875003`, 100.1214467175}, {
        227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
        97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
        100.1214467175}, {221.98906566875002`, 100.1214467175}, {
        221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
        107.2353207}, {227.01602828000003`, 107.2353207}, {
        227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
        101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
        225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
        101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
       94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
       88.67999999999999}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.2, 0.627451, 0.17254900000000004`], Opacity[1.], 
      Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.2, 0.627451, 0.17254900000000004`], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
       172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
        
        "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
       97.30146844875}, {187.73723616800004`, 96.805203313125}, {
       185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
       97.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
       121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {282.441,
        114.262}, {274.85900000000004`, 121.848}, {274.85900000000004`, 
       131.20299999999997`}, {274.85900000000004`, 140.559}, {282.441, 
       148.14499999999998`}, {291.79699999999997`, 148.14499999999998`}, {
       301.156, 148.14499999999998`}, {308.73799999999994`, 140.559}, {
       308.73799999999994`, 131.20299999999997`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{238.125, 113.293}, {
       245.82000000000002`, 117.87899999999999`}, {255.996, 122.754}, {
       265.42999999999995`, 126.45700000000001`}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
       274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbSlfh3n1ByHM7Y6b7vL4x38bj6cdm1RjoPt8+lh
uR3xDrLHNH6kLsXkr9p2949jWBycz7W9ZWqnd5xD4LS15gXLchxYbd8Gh7nE
ObBKG1VWrchxmGP85IKjQ5xD28/pnu6rchxmlkkYrLCJc7h2xKV68boch+k7
ffr5LOMc1JXD689szXFIajjhzWKG4Gt1VaQn6Mc5SP2b+FG2EpP/d05Xbqd5
nIPCQw3zwCaEeR+7rC2rOnIcjLVu++oC7bt532VXX3eOwwXmTAEfxziH20Wr
eqL7chxy7367lOUW56C5+uPrV/05Djd5Tv+SCEDwa06+Z8qOQ/B3L7acaLE/
zqG90WhbagswPJJLjsxbGudQvz2T8UxZjgOngP8Bn5lxDv1vkjO2pyP4V6Ie
Ca2NRvC38Heu/RKY47DyV8mBeYvjHDw8t3S6eeU4yCauOSW5I85BQPPftatO
OQ4Tjj++MuUM0L1HhY/+s8tx4Ah51rzyGYIvy+c8qYw9Hs4/55t47IR2vENc
oqtZqkuOw6PNH83/eMU7/E+YN1fWP8ehZ3mlknRKvIOlncJH9Shg/Dy3e7+l
Nt5hhdaBnflA99pZp3xm64p3qH94/vyMcgS/9Uia6JkGBH8p/4Gqli5g+E0M
/Hi3Od4BPT0BAHIJFmQ=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbn64+tX/TkOc3oFE37fi3OA8R96fTL+4xEP5x+e
e5Jtf1a8w3WlSsmv7TkOpu6mBQuq4x3OvN+QEF2B4LvqbfGKzkXwb9pWRjxI
yXH48/xp+5+ieIerb92fVsblOOzdZXSwOzHe4eJcsSLhiByH+t76X1IB8Q5z
UibpcYbmOOQvbDslZYHga14pkL0rieBv12Ld8psj3oH5tun9gLAch7Vnr+lM
/RHn8Jr15sQZQPOuOeg+tXgZ59Dmw9j0KirHIY3hYH34rTiHRe6aJTZA++O3
aJmpnI9z+CR0bemMpByHKKvJXz4cj3Pof5OcsT09x2GnlVWvxd44h2OPNvtE
5+U4yCauOSW5I87BW9B7Ql8Zgn/R/tHlg3UIvtK8L9dfteY4KLSX528G6o+a
4rKnryfH4WDbhWvZJ+Icvt7KWfOgDxieznPKWc8gwluPq3D25ssIPiw+AFl2
xrI=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxr3hJK1GCBKa3cygYkkXxZJ4cqBk02olblrvm5oR7jUvUMMU
cyXGcAnDEszyGjkmWkhiWc4U25yu8Eal05aWMk2XiwppKv0/OejD8+EH5/ac
c7anZIrT3F1cXFw57eHkxqnBNirdv8ww7xoXE7BEEXnYLUaxylB4NDf46iKF
MnRGL/zNwHf4dKkmKQIfyLNTbAxeSdqxzhEKq89utW6W4VCJ6eBKL0VaZZIt
aJpBz9uX2dpBsawWy/iTDAn+qicZzyj0givS8AkGke7CVl4NhTmgLKzkA4On
PTrHqKBQ5YlGHEMMRTy/iLgEJ1/se+Oq2ObksctLyiEbwbWB+Hg+l6+KFZUl
vyWgL3o0djM3b3RL3ebHBM1Sbx+FhSFsJaJ9p5qgr6DCVP2Vq5dVlmNQEMQu
XsoMtzKU1LT2e1wnGEgO2TQ8z9A28DEoMp3A69ZMj/AXQ/O4ptacRNb2s66t
6L7yJMHdYr8jWgdD1eLTbLOQYMec5lsvF5/l3i33EBHINBK3XT8Yxo3llS1n
CU7d7jvu+Z3hi1AwMZ1IMJPbpbPPMBQUv6r3SCFI9frjL5liEC9URBlkBBbW
o7WPMwR3yBeUcgJJo+GefZDh0YkbD6s4P8P5IWd0Roa89Xf0hkaC0Pq60uoe
hs4tg0MyPUGF0ddU2MngIfC3bJwk6B9/l25/zfWTzwp0q07WN61aHIF0jV+i
8qYkkaLIPLsg0DNsUGsl5aUU5x1LPMknBvX7hr2N7c57mua6n1v1FPlR4gw+
N79n1efw4EG65u+Y9W976ijF6aYQ/jDnf6LgXGDAFEWtt9B3+SeD34Gseuk8
xf//+A9Tck1q
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4paOhq3dorkOyz8y21XcjXeA8YV33EhUexrv
UBLc5rdAJddB3KhgceSbeIdaWX9mK6Nch+YfLsfZv8Q7tE72lrayy3V4t0/y
9dbf8Q47ky9EudjnOux6N2X16l8Ifh+XhMnvE3FwftAsAz6V3XEOCreKuXsc
ch18ts888WFjnMNuhTm/7zrlOjxeO8H1zto4h8Xe9utUXXMd1io4pFqsjHNw
UD1b4OKV63DP+CfzymVxDkeDU7aUB+U6rEouOTJvKYLPo/j8b/28OIeL0xLd
/MQw+TD1Bcyhty3lch1cG8yeKS+Pc/g8r81ngXKuw4MPR5Y4rYpzONR9dq2+
Wq7DBjdurkvr4hxWbStIKNfIdXh2OfpV6eY4B0FdEcH9mrkOb7Z90l+5B8HX
UL8V2nAKwU9QeTfBan88nD9b+9omwdPxDkfkjBv+AM3LtXuxw+pyvIMmU2Fc
uXquw5LTFjPvXY+H28971VHm8+14h1tmR3Skge67fbCjtulevEOh7u6VbPII
vvLXYq9yWQQ/hEP35XOpXAc+O0eFz8D4ZU1/1hohjhnfMD4ARnDqVw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mlI02EcB3CPEnMxlOVR5thMeiGJQ2mkgX3twBQvbMFQtmfqxkx5yiPv
QNSwUpupeaClK5WyMG0yLQkN50ZeI8TQF6mgtbSWpXbJ6Pj36g/14vvi8+b3
PL9DmHIhQeVoZ2dnzySAiQOTpTwx//AMRYi63XffGzkyFaIrgjGK3cJ3P0va
5FjmOilvKP63a4Tu7t5OOWJi4C3QUOhpCC9lJ0HSy5AIQSeFVpEztRFMsFwr
lgl6KSrf95SWKliHHVVuOVWyLgn1GM1vJzA1cjPMDymG1eNXV/sIarTDFf5d
FPVVOVMnhwk6NWvKS20UDgW8hupJgic892PmBorQ86mFohmC5raznMgq1sbk
BfGZMtYXHSeD/Isp0r189tyZJugo5/+ezqVoehyWtWggEKxar6szKcaiFGbv
IYL4NCRyMiisksGykfsE/Rpdk1VFcTw5sFlbQ+Ch93s1/XcesXnbgXUEXtmf
c9VKCunlqgdUR7C6cavbcI6iZW6XR8E4QWh8b4+VqZ+l7JfNzhMktjrzuooo
dLFBxsWPBLb1AM/vFcx79rFR+38QfHga3MdpZM0dlQ7IOlgXn9ou6npEEZ3x
xZL6iSC2LCuudZCCGxYu2FogkKicG8zPKcSnm2cbp5h+RXqTv5FC4/a60m2Q
9VsfiXbzNmvVxrqLWz7Tv/ucMG2IIkpiG3CNIQivW/iqZvZr6vm1ZOMTbPqp
UmSFFNUx0fXJRuYepJxS8wDrHS1JqdnPWAtH1g7UMv85mM7VW0xy+CbEfZMZ
KGpyPI/YJuTg3JPmZ5so6kQr8zfNcsDlxLXICWY/vCL+izk5DMXcQytmCmeJ
pbzbIse/9/sHix9Emg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{241.265066361125, 124.76413176875}, {241.265066361125, 
       126.51668522}, {241.793832488, 126.51668522}, {241.793832488, 
       124.76413176875}, {243.545135901125, 124.76413176875}, {
       243.545135901125, 124.227865413125}, {241.793832488, 
       124.227865413125}, {241.793832488, 122.476562}, {241.265066361125, 
       122.476562}, {241.265066361125, 124.227865413125}, {239.513762948, 
       124.227865413125}, {239.513762948, 124.76413176875}, {241.265066361125,
        124.76413176875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQrXCryezumzyHM7Y6b7vL4x1W6j2VW/Urz8H2+fSw
3I54hwppnQbLv5j8Vdvu/nEMi4Pzuba3TO30jnNY83rDfud/eQ6stm+Dw1zi
HBIKTBn9GPId5hg/ueDoEOfw0G/2RSmmfIeZZRIGK2ziHAylPJjL2fIdpu/0
6eezjHNoqohiX8Cb75DUcMKbxQzB1+qqSE/Qj3MoDZ5a+fFCHgb/75yu3E7z
OIdqM539Krfy4Ob5PLA76Psgz8FY67avLtA+E1MPp6THeQ4XmDMFfBzjHMxO
rBXRf5bnkHv326UstziHFoavxfue5znc5Dn9SyIAwa85+Z4pOw7B373YcqLF
/jiHR9dM7SzvAMMjueTIvKVxDrd4cjvnn8tz4BTwP+AzM87hlWP6h679CL7+
hqezGjYj+PypPaYnVuY5rPxVcmDe4jiHxfO2C0otynOQTVxzSnJHnEN2HWP8
yll5DhOOP74y5QzQvdLivpem5TlwhDxrXvkMwZflc55Uxh4P55/zTTx2Qjve
Yec2j30Wc/IcHm3+aP7HK94hattC1Y/L8hx6llcqSafEO0yZrFz5e2Oew5zn
du+31MY7MDccdnQGutfOOuUzW1e8wy2zy+E55xH8B5JZc+ffQPAZUg8zRTwC
ht/EwI93m+Md0NMTAGwIDRM=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3cLwtXjf8zyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyvewaiiZuGJ+3kOpu6mBQuq4x3UXbe80LuA4C9o3n5J7yiCbzK55sHm
PXkOf54/bf9TFO9g4Oyd67stz2HvLqOD3YnxDjqfJX89W5/nUN9b/0sqIN7h
+86p2+6syXPIX9h2SsoCwde8UiB7VxLB367FuuU3R7xDnIFlusq6PIe1Z6/p
TP0R5+AWfUcyZ0OewzUH3acWL+McHi5k4dq3Kc8hjeFgffitOIe/c3T+8APt
j9+iZaZyPs7BN+Ombs6uPIcoq8lfPhyPc3jlmP6ha3+ew04rq16LvXEOihbb
r+gdy3OQTVxzSnJHnMOyND+JpHMIvs7Up9FTryH4tZ+/x++7m+eg0F6evxmo
f+tLd5ekJ3kOB9suXMs+EecQYFBgsuUZMDyd55SznkGEtx5X4ezNlxF8WHwA
ACW6y2I=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0sFHAYx0k3RcprixNdJ4rz2puSfI21c52XZHak308XZUm/OGzOiOYl
YaMlrZ3zRyRvnWWXddbSKNNW3mp2icjy0ouXWas01f3ltv74/vHZnmd7ns/z
8KQsMtHIwMDAUBdXXdbpctTYAzmWDMpFVepoEMHdLk6EmzmDSUdBVclxgrin
vOEkWwarrukr0bEEvacqdot2MHDjQ87xzxOszk5smHdiWPR0MZtOI8iLbWku
3sNwur130D2XYO6s2kPhznCHr/qxvozAsbcWMm+Guryx3GQFwUZtupTny/Al
dNmtUUMQI+983ubHkHLQSer0Sc/diz4BUi5dY1HU70fmoRSXdz0MVuj6b6c0
tOZnUhT5By1pfBis0wOVfdUUEe8kH6Y8GDSBf6bCmilmBsLj+l0ZKl83uDVr
KBJoweP9zgyJysKhlBcUHkN7tZU8hmGec7V6kGJMxnubZMeQOS6qNZ6ga37y
/LKcLy1SlNpsGQywYvhqGCay/0nRbUrVUzpf7R3efeMLFPJQVXWxI4NwKa7e
a5biVpq/5B6foelB/7jFJMXf7GOjGheG+n2+NeNaiqvfLHKjBAy+nIQMrwEK
TknQgkbna3U1+2RMD0WZCJzOIwxFqVl1wU0UllkjwvlghvutF+XcCgpVZKKp
mYjh5RvBXGkGhViw/MotXFff8/H9TCyFne1hz84TDJuyrcsP+euZmH2Pn7HX
c7Jc8uz6JMEZO4eWHCHDVteQWXErwbWVzTeiDjD84kdXiPP195QMeJWtpBMk
qdQChW5+h+02xk8ukLX9xCZGhjelBFXCkRLtToYWWWPNaAxB8OeewjYug6yr
fJsynOD/f/wHB1wj6w==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
       324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
       137.844}, {333.668, 133.09}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
        "], {{322.62239645999995`, 
        139.61787444875}, {324.47745303749997`, 139.61787444875}, {
        323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
        139.61787444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 
       114.809}, {261.641, 109.93400000000001`}, {252.207, 106.23}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
       102.85199999999999`}, {251.016, 109.52}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzeH7c+3K8nwH97UW77yLox0mLoyeVtaa77AjbEm4
bku0Q0Lfou+sHZh8VbVXfxmDouD8FrWJ0zzdoxymxKmbC3TmOzSs+Rki5hDl
4PF4dYVUd76D+OIPFxltohxOHhT0fN6T7yDyTMUwwyLKQbJ3X5XzxHwHIc3I
CedMohyyXl+oy5mR73D3/RWfI4YI/tKfLRkK2lEOsce4P+6NxuRX8EzP8zSO
ckheucjsYwrCPJPgrRZS2fkO62Y+93trHuUgs2LfTr28fAfv4lJBHtsoBzlr
lZ7fBfkOL3yYr2g5RTnkFGe/7irKdwipuf77hjeC/93iD7N2FIJvJuw26ceu
KIdTnmu2sqYDw+Nyw9G4hVEOh+ofM+REAsOjPvogz9Qoh0tb7qaHeyH44sox
Qr52CP7360xrp5jkO6hkNR6Mmx/l0C2o1/lMJ99hxoUdp29ujnII/lh+rVQ1
34Hb/MPVkBNA9/b1HpmnmO/QdPhTS+YjBH9Grf9kM+ZoON9zb+7xDvVoh4Wa
+01Z1fMdYpX/Wexxi3Zw0pSYu9cw34FdvE35dny0Qw3brA/HbYDxE+79oaQy
2uH1J8ud/ED37lxV8OVYa7TDoZWe5y2iEPwTPQ9EcpIR/BfXLatUcoHhxxD3
aW59tAN6egIAw7gO+w==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnVOc/bqrKN9B/K9s4u5bUQ4wfsyufyZ7XKLhfDve
a+z1adEOUq8/SUzNynfYsM2xMKE82oF/h1bC7ygEv+ObrtdvfwRfhu1zeIN7
vkN5+KeOPXnRDhLbDj6RdMx3sNCyP+QdG+0gkjahcLNVvsOvP92/b3lHO9zX
4dFbaZ7v8Epg8ulbxgj+EudaubmiCL7RLMGtu1miHdwWr7/3wSLfQcP2sW7o
lygHvXNBEy2s8x0CN1g++/EkyuGkSHVjl22+w8P8sw3i16IcnvIvLr7jkO9w
S9nc/MmpKAfT2/5LLVzzHa6unP91w+Eoh0tb7qaHe+U7mKxy6/uxI8qBc7Wu
z++AfIcZF3acvrk5yqHv5pF+vUgEX4Qj5nJiIoKfmpZ3vSsj32H2t+aC4p1R
DnNj9u3Wy893sPl257r2kSgHi8XPVjcUAsNz84qKo8cR4b2ysnZO8XkEHxYf
AOPfxJE=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EYxeeKJLxUCKFllykl3grCKI3cWRfGVCrSvLxv2VLMmNKrG3Yh
TSNN1BSnEsIU724MqWG6XN5oLkc2nSmzxGmJJqEpSFhmdPl/UujD+XB44OE8
v+cIEtjFpE08Hs+Bkx8nPqd5fWScdYohOZ2E279R5P2+JxFMM/zS5vkc+kph
+XO1f+Y9Q5HMwxgxSXEtYTmN/47h4YB+InuYwt9WWxpvYXi29iGo20ShSbQt
mswMotvH0zIMFEJiken6GEYKK9WBLRRbf0zHjvcymANl+80qir2fnY/5Gxhy
pFGKgiwK6+n+UVU7w99b3iddIzf8RPAgX+S54S+NbS4qmyfoqLRG6ToYHLtj
KwSvCOpzQjXKHi6vvqdhvIZgWZDnJDAytKZKOmceE7iI3SzCfm7fxxpFfhZB
acfUzfEBhi3bjRZTOoGbn3aHwspwBLMH+NcJwsOkppkxBt+I9npVDFnnk3tQ
+UQiJhg+pwwO4/h5SLvkKiFBUqvX7A2O14J86I6Jmz9NG3F4zfGKCW6okp8n
KAs/I2oeZKDPQ6aaogl8T53oUb5h+LlibjRdIWgeZrtXTQyDl5vF+ckEXkdD
tUqOV11A7pJEQaBSiCqUbQzuhkfV8cUEO89qL8S3MHzPLDfnqwnupniWCNUM
IcWTo/5GAruy5O3+eobsap9PVjuBa5NYpqxhWJ1bOXx/bcOL9jhNd+6i6z5I
p85xj6YwNyQuDmkYCngv4qILKWr75I6rLxmcQ9sCUvQb/xQTa7vGSNHraknV
cfkfuCyEzFno+n2GGMcubxtFeYZ2m2KIIXZJus/O9Wl2tMutysZQVpfZ6PGF
4v8+/gN8PUXo
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4uMBv7Zo/8h3UEoUsLe4Ge0A4/epP0169iDa
4Q4vg/oC5gKHSQtrlki+iHZ4UJTCmMtV4PAvPfDE8ffRDk/WJvHmChQ4ZOqp
vSn9Hu3wT1RV9xOQbxq3cE32NwSfs0rFdPeRKDj/LKct/5NtUQ6GF8tYpwkW
OBxXW3Zyw9ooh/ovXX/3CRU4xMnOdZuzMsrhc+eda4+ECxw0Jvik/VgS5XCw
TNmiSKzAIXIxK2vmoigHFr73N7ulChxULzccjVuI4LdP+PzPflaUg0j8bdd3
QP+g82Hqb6amv81hKHA48N7p+WOgebONGdQUgP6NTri4lGlZlAPTqsXX0lkK
HLS3iXNPWhXlUGb/dX03a4FDonPGa9P1UQ6rfrl16LMVOKSr/TfI3IHgL572
LMzhGIJ/Z/Kvib92RcP5YrMfbb54LNqhufia/TmgeS/Wftn561y0g1nq13Xc
QL68teuseZej4fZ3uPjJbr4e7dD3X27aXaYChzDDqXVOt6IdblXNCrnMgOBv
vvdtCTcSf/qFZS/a/+Y7dK71VdwMjF8P/YTWHz8x4xvGBwDu//Hp
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB3CiWUxr5aGU3c6pZTo6yTHG+05yhSxPO79v7KrJzpJvUltP
s5yHbhdjIbIRKQothDrDdBySYp46MnqwSJvW+Yvt6tdfv63+eP/x+uP72Wef
95d/Ji0qycLMzMycjZDNJjZFvA8FKQzFi6kGwcw8g3i72GBFNEVeodEUdJ/B
3ZUeURn/f2vaux8aqhgMWifYKnwpDs6F2LmYE0S+jRcogil2j2aONHsS7BDK
PRZkFJsZbZbkFOdXT+maPofz+hMXnbiCIMfzyGFxKIXf9KS6vpFA6b0neJGd
t3Ujc8RSS5DRIPIqAMXNb7zS8AECU2ooTxxA0TaXdu3nCEFqa3LOmg9nyxL3
iqtenGeTXHYtelAs5rnZnx4iMO4N/+1zgGI7Pyy9sodAJG/Vq9wogrTn38+2
ERzbOdc4uY/iXJ9OlVlLcN29NOyoK0XXqH+5QkPQGBj5vf3vPbqy1lfzCTyc
27QqAcW48V6D8BmBQ4JmQsS+tw91cPTtJwi8UxynZ+f/GO9JLJ4geCeSqGvY
fYTdgfrKZYKq2WjNsDdF8kUm7KORwLF3ajo2gPP+kOUZk5TzfK5fVw17v4EZ
syXBCoHs0eU65wgKdVMEv9VAMOwgOd5xkqK5o3YybpDg0g3Hs4tsv1tuLWnG
Wjgr8hXVLeWcFxQbNmPpBEMX6rdln6Do11m9HJURSJsa1lVsHxJnm0+dTgQV
V1afm4QUVl3yYn4vA1mhFB3hnF2bU0TqSM4tuuaiMnafaoNT++PXDA7lf103
RVFYfxH4deoZ1ImV/uoYCtsHq4aYNwykysS+jDi2H1Uu7/Y4AwuXvpJeOUWW
7le28jODf//vHztSSVc=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE1Acxr1VItOBsVQq00UtamlkkVHply1MxSB1GueAyrwnzeO8baWo
6JrTNJYgXmr2oBuWBGVKeSHRvHRDy4JEJUWTXGYTxW5QnSeFHr6HD/6373eO
tyIjIsnexsbGlms/lx1XQtyfwspLDB7x3aqGQALRSYsuMY2hdK+hJiSYQHVC
HWKvZKjyXSnaFk1g1vuuZmUy1IzIU2YVBGdGY+YGshjSG/1cTEoCB31Pu2su
wwfxu7dfNQRPnIO+71AziKq7fjzTEUQGHityvMKwy7pQeKCWIGTY2xBXwJDc
81ea1kFgdR8IkhQyfDYdSpib3vAB8YEQu9F1P9C/5fHoOYp8Jexu8/6tU233
T6sodL/KLrby+Tdmwxv11RSLw9UjvXz/0QdOn1zMFP4yYVUHv08Q8Eia3kGR
W9HSnZbNMO18c+xgH8WErPiVm4rhvOFwbc5riocidWgJz78cHnNnaIKu8/l9
VyvxWaQon1cOL3F+KZkkbHKFonmmphO83kcS8ML4haLY7uk9V86rPz7NZJ2l
EIo2C8Sc1x7PyY9vJin668rDpTkMXk0yo/E9hTbC6qnJY2jLZrnWlxTBXvoY
Kc+jvlwW5dFL4VSsU7Ty/LYz2mYHE0W4e6TDYAnD7p2aqxMVFNs31SfJrzGc
lR23hGVSWJanB+fKeP2Rb1PmaIoLqaV50nIGncWr6qf/hh/Pt1WY3Tf8/EJi
X+gUwWrqWnullsFQJ18QtBA4ji/t0+QzZFcrDIKCjfccCzxV2ckI1H5Ba7f4
/XXXvR0Lksl6viGN0C4qlkBoM9bUxflKZtuNDXKC+dHnYkkGw5JvvUdsGMH/
//EfCv8qpw==
       "]]}},
    AspectRatio->Automatic,
    ImageSize->{388., 165.},
    PlotRange->{{0., 388.}, {0., 165.}}]}],
  SequenceForm[
   $CellContext`Dia["A", "A", 2, 5], ": ", 
   Graphics[{
     Thickness[0.002577319587628866], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
        388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
        0.33199999999999363`}}}]}, 
      FaceForm[
       RGBColor[1., 1., 1., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
        24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
        3.9919999999999995`, 13.508}, {3.9919999999999995`, 
        24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
        45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
        24.836000000000002`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
        21.99788154, 23.851453813124998`}, {18.552508993125002`, 
        23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{111.074,
         44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {94.133, 
        27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {77.191, 
        44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {94.133, 
        61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074, 
        53.512}, {111.074, 44.156}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
        59.891, 34.656}, {67.65599999999999, 36.809}}}, CurveClosed -> {0}]}, 
      
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
        39.508}, {68.684, 33.461}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
         "], {{57.68489645999999,
          38.21162444875}, {59.53995303749999, 38.21162444875}, {
         58.612424748749994`, 40.420441815625}, {57.68489645999999, 
         38.21162444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{384.125,
         140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
        363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`,
         129.164}, {343.10200000000003`, 140.49200000000002`}, {
        343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
        363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
        140.49200000000002`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        357.65797799312503`, 140.37615644875}, {361.10335054, 
        140.37615644875}, {361.10335054, 139.507703813125}, {
        357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
        140.37615644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
        71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
        147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
        80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
        156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
        90.35199999999999}, {173.45700000000002`, 80.99600000000001}}}, 
        CurveClosed -> {0}], 
       FilledCurve[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
        
        "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
        62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
        77.762}, {132.35500000000002`, 70.23}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4vMSz1gO/o10kLn4yHDFg0AHGN/lQ47vpvOB
DutmRGf3nsLkP3uZcsjLFsG/3WNm/UQn0EHMMvXVwjORDux7I6YoKgY61Dvl
5W67EOnA5Hww6J1koMML7/IPp65EOqQwmPScFwp0kHc6fiXvdqTDif6lZzfw
Bzp8WrG03PApgq8Tc/BP3nsEP43/buOan5EORm+r3saJBjpYlu1WyWeOcsjl
nFY2B2jf9R0er3u5ohyyHp+6yCSDUP8p7ITSO0aE+S310Qd5vgY41LQuOiNz
FsE/n+1vm7IOwT+a9DZo+vxIB+1t4tyTuALh/If5ZxvEzRB8WPj4Nsmxv2xG
8CU3zTx+rynSoeLAx549FwIdnj4U6bjSGOkgfHfzOsdLCL77Wot33pcR/Eey
x9dkXQt0aAxa7Pa5JdKhbnHHpfc3Ax2C/mz1kOmOdGhICCnuvBvosJt1/2mD
/kiHLQY3N02+B/Tfb74NV6ZGOuwIWxKu+yTQ4ce9pV/Zge7b38tu9etdoMNp
15YZp1ZEOiT0Jizc9DPQwaI04kDFpkgHxoetS1nYghy475glW++JdLANzD19
WzjIYcXWI6pRByMdSt33rq+XCnK4+84jM+VIpIOQonfRPPkghzW3+099PgZ0
f9T5rSuUghyqTlzTbj6J4MPSR0VuR4ikAoLPn1J/kUUGwUdPfzA+AMXUQmE=

        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmdIlAEYxy8LL1CjZXhkltvcmEZeKX8hMUf6vq85egxzlJXmzoFY58rR
IeGpoZjouYlI0dTEFSZeWCpliPNsmISWUGSZp9l98qAPvw8/Hnh4xl8/LJa7
upPH4+1QYq5ETYntR+1I3RrCtXjynPXlEBEb4fG8gaB4dNfU2ovDz3jrs64l
BHGkYMDLiYOeI1uelUvIHu6YEdlyaNVrmRTeJjSvT9r3GnF4fFpQzL9FcEk5
FZck4DBtxi+URxHe3itrtNLkEBNmd8P2CkFmFXlMpmBR7pxv/M6fkBFyIbFg
jsW6Yj243YewlWzotKdN5TOOI2ou6Sr3m9gllniweFWvFSr3I/B7A0v09VlU
Jy3zpaHKeTv6aqe2GDg/Sx3tv05ovene/ekrg2S1Up/NOGW/+arEvDkG6Z8t
Sm3TCOp7B14PvmGQ9XJgOjybYIcFY7UhBj9228BVQjju1V5T0cls3yfHpOiB
eyODjX1F5vulBEFIT0JFFQOTqTaRTzFhOWE0dVBZ7/I70M3PJwQ41j5MaGaQ
ofHbcVhECGoTyus7GDxZWzghTSH8WZXVDfYyaNL2XomOIYxcanDLkzGQypc0
pOEEqWXOivs4g+Kg7/PV5wk6XbmVwd8Y5P8dCBQ6EX6lF8vy+Cy8PRvHN+wI
wsK5cQsDFgfLxN79ZgRRpen7sTMsUvs2xdWGhLXFVZs7pHKXIxofutNUbt/S
mKHTwWKp20Fy+CShgNd50X+JRYXCdyiaCJrOTy2jDqn+6UZj7U0GHGaK1Ivk
0YRMrWXhoiW3vV9XAL/H0IFD5uUXE+GZhMCVkKOzyjwZ6X6Rt98nSKTpdYJz
HP7P4z+gsjI1
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4leiyYpXr0Q5KCUK2FtYBjnA+H3qT5OeOQQ5
nFqdF/zvU5TDpIU1SyQ9ghzu2DPsNeSLdviXHnjiuH+Qw2vtn28M1aIdMvXU
3pSGBzkEn2HKcdOIdjCNW7gmOwzB56xSMd2tEgjnn+W05X8iFuigtNPz7FWt
aIfjastObuANdIhwm7W2Uj/aIU52rtsczkAHjTkPhDhNoh00Jvik/WAJdEj0
/zPdzS7aIXIxK2smU6BDzhot+bV+0Q6qlxuOxjEi+O0TPv+z/xXg0Gqk6hx1
LQqDD1N/iJsn1/BZlMOB907PHwPNO+mU7//vQ5RDdMLFpUxsgQ5pMn8FZb9F
OWhvE+eexBXoYFbkXL7mV5RDonPGa1P+QAeW+K4b1n+jHNLV/htkSiD4i6c9
C3NQQ/DvTP418ZdUEJwvNvvR5otqQQ5ZTie2bfsd5fBi7Zedv/SCHEw4XYrX
/IhykLd2nTXPOAhuf4eLn+xm8yCHqUWv+L+8j3IIM5xa52QV5HA4/gbn6ecI
vvp7T+81TxD8LtE9Hb33oxw61/oqbgbG75tLeofybmDGN4wPAGTi3Ew=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4n8dwsqVH6Id0gujvO8EBzkwut0/LPQl2sF4
4VXuS0EI/uU3l0PEFQLh/BkXdpy+KRzoYFafzC77Pdohvm2O1xzuQAc2zTJO
t7/RDt9qJh9vZw90uH6pgzufOcbhy/7jau+YAx3c9mtc2SYQ4/Ap7ITSO8ZA
h+CbSn+2qcQ4qF5uOBqHxG+f8Pmf/a8Ahx8/noq+nB6NwYepv/CuL9F1ZTTc
PO5vZc0yW6Ph9q20YPGy3hPtoOUrwT6JI9DhUZPC6Yoj0Q6TwxS7lvEEOtRx
PPrw93i0A+Otg37vxBH8m+ezZnlpIvj5KWpZPoJBcH7lwZCPmxSDHB7qhejd
PxTt8LRdUzRRM8hhebXFyoU7EHxbTgOl3k0I/kWn6H/3VkU7PDGOrTiuHuSQ
qrHLdvrCaAePdbODnFSCHP7dromWAfKrtUK+blIOcjjF/UNaaEG0g8g9MWEL
IN/gvemvnnnRDu5R57euUApy+CO3cVfT3GiHB7yTLusC+b+2btzWNBvhvp+J
TyVfzox2cPt4fuMKhSB4+FXkdoRIAvkTIu5MuzI12mH1Fd4JyvJBDt+spUr9
p0Q73As4ZjRFDsEXdRcTt1AFug8tvQAALfsFRw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx50SNQ9tRZ2tPFRuebizZNXy8CZtotPv94vZ6st0iUSF5KEn
VyMy4ejsUHexwlyr2XlKqKFcJE8lF7eyq3SauEwTtfKX2/rj9cfrv8/7/f7Y
Cc4yJ1YYGBiwlnBcwnCJSV10oyKPgB3Rklgmo1AXueGdRQ5BhoOo+EAVBQfB
IXXObYI83qzQqoHC71LnbH4NQXFfSLSmncLJ+l5/sYIgVuZmXvmawhlJZJ6y
hWDE/s3glIoC5Mm3dJ0ElkVP5jsnKMgTAptkrwhsZrTpTvMUrornFhdVBFGt
f51jrGjYjFxrtx4n+FrpevwT9O4V4Q37FL0/7zBu6q+mEcSNf6Z7T7BOrXjo
M0jjQnghm9dHkK/hy27M0rCQtM4Juwjca9d8Njdm4JEpnw59SmDqVecca8Vg
V8X6mq0NBB/NCodc7Bl0Z53Tjj0gCBLtkJx3YcDpCRrPkRLo+KF3u/Yyy/0s
1mRyuAcZZJg7qnYXEEQnHAkcO8xgduFlufAOAZfj1S0NZHDsyqkoZTVBR0RM
5cw+BqXK6xNGtQTbNo99GPBgEDcqmeI+JrC95yeVujNIbOO5CdoJFEnxyTNO
DNLmCi15vQSpp7OD2bYMslJzfXgaAtZ45v2VqxiI3jYrxbMEWzalXRz9RqMn
e5g/9Idgv9+eycABGkYePwbXmoSBtXNaXdVAo8JSKOaZhSFr0jbvl0Tvqkss
QVWq3r9oI9sDPGm4bvTPr1sgEJWEaE1X00gf2X5UMEyQVCQQmar1ew55e95s
7qfg7ZtSoFu6vyTXzuTyC2o5X1eahWFwG4WSpOaAuEcEHE29tKyews9Gsa91
OcF3Xik7XE7h/3/8Bz1JN/w=
        "]], 
       JoinedCurve[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
        138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
        56.516}, {119.85499999999999`, 51.789}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
        110.84400000000001`, 47.38699999999999}, {118.293, 
        54.922000000000004`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pVX3jQy3EhwMF10NDmg1ccBxm97cHNWSrKP
w4wp6lvT9mHyT1w+2TLVzhvO3yyZW3ZC1tvhTMqaLwX7Exy4qjZqOLN5OzS+
NDCrPpjgwNjWtPTOdy8H07yt5a2HExyOMGRIzH/p5RCYeTfz+rEEh15579mJ
j70cds/x2b3jNIIfUXar9voFBP+rf4bDt6sJDom3vt7a+87LIa75+sTrtxIc
bgjpvLVg93ZYqyL3Ne1egsOFY1MXs/5BqH+0doLrneMI81n+b2uSXOflwMB9
OnXdfgRfs05RLmgDgr+k8sOK1ysSHIJz9MVUbiL4++/PYtQ38IbzYeGTwcnZ
LDIbwfdb6JbcPyvB4V3DY8nKVB8HE8sWZy4gX3lXemxzBoLfFVV4Z3oWgn/I
ui/yaoGPQ1Ph6UUzgeb9dBNcer/cxyHr2BXldfMSHP4dWPFMqN7HQd47MnXH
ggSHtMRNqeqNPg7Wbo3hXEsSHHLXeqyP6vFx2Lfd59dioPuqpflLviz0cVB/
vdu7dW2Cwx6pg06p230c7jEti4/ZlODw/yC3N+cFHwd3M9GNttsTHCoW3Zq2
/bWPg5hyjNDZnQkOz/qq4v//8HHYYC9nErQ7wUHBadoTG2ZfB/FtB5/M3JPg
0L1lXnYgp69DvU7q1Id7EXxY+nh3S2ClEQuCL3Pi3yLOP4j0hJ7+YHwAJ5o5
vg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+8c5mHucp6WsenoSYgYYtx7HvP9/X4kpV1s/b4tCunaGd2M
zjxs6clEhupkbVQzzdzK40hb1GrLSGvYmg1F7GpiFNfvL7b+eP/x2j7vzz4P
7z3n1CcyJCKRSCzIW5CZIFV3eZCfN8W7GUNdVw6HFVObV4kPxcop26T0dA7h
4urmKE8Kx09HyhsiOXw8r2CpG4XkXu5LkxeHxs+jOf0uFGd+d2QV2nFwybR8
6+lAoVu+8nVhlUV7+masTEbR7BSQlDbFQrsuDwq1pbiVNo47vSxuz0fIb5hT
bA0+mZPrWETGrbVviCg2luIK3bx3uDOv0aK0j9nmljZr570qBvvvi/xlgt+m
sONAtCUD+zJ1mdGaQp5bHN/5moD3ejGns6Pgv9wtGH5IUJQQ06q3F/oNKOel
OgJTj4yEOgt+j/KGygsEpT6TP0ZdKWjJCGN+nKCHrW6KUlAk1mfHhgSS7ftY
cgrfGjmBMnnI8elBisOD2tlgCcG4IWVgWKgfm33w87oDgXueZNrTneKZJu7o
rIJAnJjvZrGbwpCZ38cEENTHXGowOlIYF6sSKpUETmOPVlN3UdR1s1XSFILq
EHWF0YZCqbKarskmsCnQqI0mHn4au/B+PUFF/OSh/jUe39f3VcnGCL7lcln6
Xzw0rr2tp60YMLUDLbolHn/CkgabIhgUt2pjjQs8lj8snv2r3eFrYc5DV7t3
OINPEgf4swhuqR3xXeEhE1/ubKtnIX3zeCbVUshD0UXVhHHnnzcN+pxkaw5+
9pvxMmH+LdeJ/Pfu3PZ+6udSbbwfBzPt5MKosH/71KvILiWHlIml5Q0PCkX0
+rHAkxz+z+M/U8AdhQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYrNg7QldzokOjocU6grMfB1gfAn/U0fPuPo6
qMkZas4PSnRQcv7pYRzi66D/4uddi4REhx/nF03oT/Z1MI/79tUiJ9HhfIzP
jddFvg7ZetWmzrmJDul7nCKvFyD4/F88ssp4veH8acJVcic+ejlcWiL3rCsv
0aHb12dy4n0vh9zXbtfuFCQ67LCy6rW47uUQKvaqQ6U40cFHYeaZD2e9HD69
L/d2rkh0WO/GzXXphJdDuRx/f1lDooP7MsbuvccQfG7F53/rd3g5NCfyKPq6
YPJh6pXO/d9q4ZPoUHu/9dzxk14OSzMN1ecHJjpsObDIm/WCl0NJWEWHXkii
Q3COvpjKTS+HmEZp67KwRIcDbReuZT/ycjj8fd/rveGJDmd8/iVe+oLgu+ie
Xdsg4A3nb1H/qvz1pw+cr2V2NH2xoK9D2cu7Ub+B5p2Lfln8VdHX4fYZacuy
0EQHq7IuE1ttX7j9PJ1zrNKMfR16GPPZpYDuW5mk9bfFwtdB+UdqC6svgn91
v5xqmTeCz3b5+uFnHsDwj57tlGbu67DdcGJCuCtmfMP4AI8U44k=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4gM9zBNjLiY6nHq0ZdqObF8Hx+zMRM3LiQ7J
TqvFl2Qi+ItuLl+px+IN5+ssLJy++bWXw+127eZ1VxIddvNYTrW47eVw5I4J
y+HriQ4vf6r181/2clhjaNd6/Vaiw5P6ft87p70cnqj3ZVY/THR4tHaC653j
Xg6vTLprq18nOrgvY+zeewzB51Z8/rd+h5fD3iM5XSJLMfkw9SvtHTccWosw
z83Z1HHdZoR9U59UL7HdnugQOMuAT+Wql8NGTq7UmN2JDsprnUR873o51J95
9V1ub6LDv83Nc+98RvDXzb9qMlXMG86/fcLnyoxnPnD+h6aVj1LZfR023l88
rX9XosNx/mCtQ2K+DiJsYlcKtiL4989MnJC2CcFfmbm8rn9dosOR9F0f+oR9
HYrvhM17vTLRoTfGfGkLj6+Dg5mF7jog/1PIilep3L4OaudKeTWBfNU9umoF
XL4ON/ZPqUlbkejQvWVediCnr8O+8EsxD5cnOuyVVlkezeHrYLf4UtTDZQj3
2Vbm9IgA+R2P5icHsvrCw+/dLYGVRiy+Dp1fnntxLUl0CF4preDO5Otg/Yxt
l/viRIedC3tSNRgRfI0+Hb0CPl8H9PQCABJuC3s=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        145.02237524912496`, 55.48896844874999}, {146.99118529599997`, 
        55.48896844874999}, {146.99118529599997`, 54.99270331312499}, {
        145.02237524912496`, 54.99270331312499}, {145.02237524912496`, 
        55.48896844874999}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHVO88fHrS0kOXVGFd6Zn+Tg8PS58ZseDJIfctR7r
o3p8HLZsidL1eIzJd/e58ptZwwvOZ/NV0p0s5OXwouV+TtCTJIe/EZ9X6rB4
OczhTFkX8yzJQdvt4WLmP54Osi9O1mm+SHJQO+OZdOGLp0Pu5rINrW+SHBSD
NinMfevpsE+wc8u6z0kO2++vnNnxHMH3+Mx50eGWp8PGN4fVGLZj8t9I6N2d
9MrTYfv5qBzjAwjzOipz82KOJTlEGJ+fe+uzp0PBubL3BSeTHCY9e6Uk8c/T
oSjxzkHbM0kOZ2ayrQjl8HI4MFNZ8ezZJIdlP9Z93yiN4L8u/MEeZoHgZ6r1
qHz86eUgV5Dy2v0QMDyWMXbvPeblILZsttm6LUkOLP+3NUmu83JQuz117syl
CH62p4hH/0wE3/vfrkfX+pMcXK8wNe895OVw3/zZPo2OJAedhYXTN7/2clgu
bsCzoyHJQTjvweqVIt4ORVtcfz2oSXJgan/KedkDwdf5PU8ttwvB76+63Sd4
2dvhq395tnsTMDzd/hRWCPo4TPO/cOl/T5IDtx6P+zZnH4cLOkFqXDOA+tdN
e/CyzMfBXvLTu0Cge/NDH77o7fdxELvAyFq9FcGX2TzDa90+BN/m38f1aSeS
HM4x7nli3ezjgJ6eAHrsIys=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQfWCmsuLZs0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg45Amu9rt+NMkhJrf50YEiH4fke4+m2m5D8O/IPKu3XY3gF+is7j20
KMnh9bongpWJPg45dyqlYuYkOeSF1LVMt/NxyOjxWP51apLDx5/i37dK+zgY
Bx9Jfj0pyeGSotr0ra+94XyX9l82VusR/CQT5azyXm+HWSfTRYynJDn4VB2L
XpXj7dD0het41bQkh/kJxWc++no7yFobbz8zI8lh//1ZjPoG3g6WZtEr5YD2
b3DPyzsh6e3Qychxu2pBksPyYPvXidzeDmq3p86duTTJIS2kV+bjVy+H2ItP
G23XJDnoLCycvvm1l8Oj/zVHC7Yg+Bl6IpxL9iD4O3vUeM8eTnIwfsv+8Nk3
L4ePTWUfC04lOZS82bk+nMfboefkvIeHziQ5VKYFfuwSRoR3wOdfFs+VEHxY
fAAAcRvEYw==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk3EUh+c1TWXihdq0gbP8YKhLLfEy+0kz7N37TgkSh4b5/tOJRpeF
rEyWaegsow9LK+xiaWQaBktFyryEtwlJzZTSspkplRnqUjSU9X6a0IffhwfO
gXOecwLYU4ezHXg8nh2XYC72XAprM+avrrII6z43s8+Bwhdl5Eb0CgtnRhyi
96JwKy2lWGNlIcictQuRUHBY7hxNcyYIvt803H+IQnQJv219K8FIvMqfzqLQ
YRlPq+YTNCc2PJrQUNi1MT3R6E0QFKRZrNBTSD82PH9pG0GcecSa2kIhUV3H
l4gIjIVWpWmBQpX3T3VXAMEbJqt/MFFu4/Pd2mKZYZPLy/mnH/jSeNppXmzk
+gNfqI6W5tJ4PXbmnnE7gXCgJt67iUbl2fLKJR8CFes7tMNEIzBP6zrpSeBT
lKscW6BRu2rIkbkTvPLb+TjdhUFePltWu4XgtjhbMidiIPBIKdHwCCZrmnE9
lrH5+XPELTkjg8FAs1SrWGMx9LWluj2fgbX+GrvE+VIqim5I0xm0zX6WVTsR
lPaY6Ck5A5PbCadWV4KDce1ddVIGsb4FOqMHgTSpIk4axqCzDLuJF8HxH+Zf
Zj8GCWL1HSPn6/e455NwRwaD0ycNRjGBtcdN7vqWhsLLeWU9mEAWs7TSVkNj
bk7f7ich0OnU72/m0ND1BVyI2cvVqyZfJu+hkWrI/WSMInAfTfC3LMtt/GzN
vlfRusmDI8bLVfFy3H1OKytDCUQRTSbBGIVevXQ/8SeYCeoTC7Sb93x4sVBY
kE2hPunbx0Zu/lDBAc+/KZRtvysWkWMDKLybcor67kJA9+dLo8IoFJdawrvs
CD5kRkZ0CCn8/4//AGdIJ/s=
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{242.777,
         101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
        84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
        208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
        101.48400000000001`}, {208.89800000000002`, 110.84}, {
        216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
        118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}}, 
        CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{
         0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
         101.01833734875}, {228.42917790875003`, 100.1214467175}, {
         227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
         97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
         100.1214467175}, {221.98906566875002`, 100.1214467175}, {
         221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
         107.2353207}, {227.01602828000003`, 107.2353207}, {
         227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
         101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
         225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
         101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
        94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
        88.67999999999999}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
        172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
      FaceForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 
         0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
         
         "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
        97.30146844875}, {187.73723616800004`, 96.805203313125}, {
        185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
        97.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
        121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {
        282.441, 114.262}, {274.85900000000004`, 121.848}, {
        274.85900000000004`, 131.20299999999997`}, {274.85900000000004`, 
        140.559}, {282.441, 148.14499999999998`}, {291.79699999999997`, 
        148.14499999999998`}, {301.156, 148.14499999999998`}, {
        308.73799999999994`, 140.559}, {308.73799999999994`, 
        131.20299999999997`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{238.125, 113.293}, {245.82000000000002`, 
        117.87899999999999`}, {255.996, 122.754}, {265.42999999999995`, 
        126.45700000000001`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
        274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbSlfh3n1ByHM7Y6b7vL4x38bj6cdm1RjoPt8+lh
uR3xDrLHNH6kLsXkr9p2949jWBycz7W9ZWqnd5xD4LS15gXLchxYbd8Gh7nE
ObBKG1VWrchxmGP85IKjQ5xD28/pnu6rchxmlkkYrLCJc7h2xKV68boch+k7
ffr5LOMc1JXD689szXFIajjhzWKG4Gt1VaQn6Mc5SP2b+FG2EpP/d05Xbqd5
nIPCQw3zwCaEeR+7rC2rOnIcjLVu++oC7bt532VXX3eOwwXmTAEfxziH20Wr
eqL7chxy7367lOUW56C5+uPrV/05Djd5Tv+SCEDwa06+Z8qOQ/B3L7acaLE/
zqG90WhbagswPJJLjsxbGudQvz2T8UxZjgOngP8Bn5lxDv1vkjO2pyP4V6Ie
Ca2NRvC38Heu/RKY47DyV8mBeYvjHDw8t3S6eeU4yCauOSW5I85BQPPftatO
OQ4Tjj++MuUM0L1HhY/+s8tx4Ah51rzyGYIvy+c8qYw9Hs4/55t47IR2vENc
oqtZqkuOw6PNH83/eMU7/E+YN1fWP8ehZ3mlknRKvIOlncJH9Shg/Dy3e7+l
Nt5hhdaBnflA99pZp3xm64p3qH94/vyMcgS/9Uia6JkGBH8p/4Gqli5g+E0M
/Hi3Od4BPT0BAHIJFmQ=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbn64+tX/TkOc3oFE37fi3OA8R96fTL+4xEP5x+e
e5Jtf1a8w3WlSsmv7TkOpu6mBQuq4x3OvN+QEF2B4LvqbfGKzkXwb9pWRjxI
yXH48/xp+5+ieIerb92fVsblOOzdZXSwOzHe4eJcsSLhiByH+t76X1IB8Q5z
UibpcYbmOOQvbDslZYHga14pkL0rieBv12Ld8psj3oH5tun9gLAch7Vnr+lM
/RHn8Jr15sQZQPOuOeg+tXgZ59Dmw9j0KirHIY3hYH34rTiHRe6aJTZA++O3
aJmpnI9z+CR0bemMpByHKKvJXz4cj3Pof5OcsT09x2GnlVWvxd44h2OPNvtE
5+U4yCauOSW5I87BW9B7Ql8Zgn/R/tHlg3UIvtK8L9dfteY4KLSX528G6o+a
4rKnryfH4WDbhWvZJ+Icvt7KWfOgDxieznPKWc8gwluPq3D25ssIPiw+AFl2
xrI=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxr3hJK1GCBKa3cygYkkXxZJ4cqBk02olblrvm5oR7jUvUMMU
cyXGcAnDEszyGjkmWkhiWc4U25yu8Eal05aWMk2XiwppKv0/OejD8+EH5/ac
c7anZIrT3F1cXFw57eHkxqnBNirdv8ww7xoXE7BEEXnYLUaxylB4NDf46iKF
MnRGL/zNwHf4dKkmKQIfyLNTbAxeSdqxzhEKq89utW6W4VCJ6eBKL0VaZZIt
aJpBz9uX2dpBsawWy/iTDAn+qicZzyj0givS8AkGke7CVl4NhTmgLKzkA4On
PTrHqKBQ5YlGHEMMRTy/iLgEJ1/se+Oq2ObksctLyiEbwbWB+Hg+l6+KFZUl
vyWgL3o0djM3b3RL3ebHBM1Sbx+FhSFsJaJ9p5qgr6DCVP2Vq5dVlmNQEMQu
XsoMtzKU1LT2e1wnGEgO2TQ8z9A28DEoMp3A69ZMj/AXQ/O4ptacRNb2s66t
6L7yJMHdYr8jWgdD1eLTbLOQYMec5lsvF5/l3i33EBHINBK3XT8Yxo3llS1n
CU7d7jvu+Z3hi1AwMZ1IMJPbpbPPMBQUv6r3SCFI9frjL5liEC9URBlkBBbW
o7WPMwR3yBeUcgJJo+GefZDh0YkbD6s4P8P5IWd0Roa89Xf0hkaC0Pq60uoe
hs4tg0MyPUGF0ddU2MngIfC3bJwk6B9/l25/zfWTzwp0q07WN61aHIF0jV+i
8qYkkaLIPLsg0DNsUGsl5aUU5x1LPMknBvX7hr2N7c57mua6n1v1FPlR4gw+
N79n1efw4EG65u+Y9W976ijF6aYQ/jDnf6LgXGDAFEWtt9B3+SeD34Gseuk8
xf//+A9Tck1q
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4paOhq3dorkOyz8y21XcjXeA8YV33EhUexrv
UBLc5rdAJddB3KhgceSbeIdaWX9mK6Nch+YfLsfZv8Q7tE72lrayy3V4t0/y
9dbf8Q47ky9EudjnOux6N2X16l8Ifh+XhMnvE3FwftAsAz6V3XEOCreKuXsc
ch18ts888WFjnMNuhTm/7zrlOjxeO8H1zto4h8Xe9utUXXMd1io4pFqsjHNw
UD1b4OKV63DP+CfzymVxDkeDU7aUB+U6rEouOTJvKYLPo/j8b/28OIeL0xLd
/MQw+TD1Bcyhty3lch1cG8yeKS+Pc/g8r81ngXKuw4MPR5Y4rYpzONR9dq2+
Wq7DBjdurkvr4hxWbStIKNfIdXh2OfpV6eY4B0FdEcH9mrkOb7Z90l+5B8HX
UL8V2nAKwU9QeTfBan88nD9b+9omwdPxDkfkjBv+AM3LtXuxw+pyvIMmU2Fc
uXquw5LTFjPvXY+H28971VHm8+14h1tmR3Skge67fbCjtulevEOh7u6VbPII
vvLXYq9yWQQ/hEP35XOpXAc+O0eFz8D4ZU1/1hohjhnfMD4ARnDqVw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mlI02EcB3CPEnMxlOVR5thMeiGJQ2mkgX3twBQvbMFQtmfqxkx5yiPv
QNSwUpupeaClK5WyMG0yLQkN50ZeI8TQF6mgtbSWpXbJ6Pj36g/14vvi8+b3
PL9DmHIhQeVoZ2dnzySAiQOTpTwx//AMRYi63XffGzkyFaIrgjGK3cJ3P0va
5FjmOilvKP63a4Tu7t5OOWJi4C3QUOhpCC9lJ0HSy5AIQSeFVpEztRFMsFwr
lgl6KSrf95SWKliHHVVuOVWyLgn1GM1vJzA1cjPMDymG1eNXV/sIarTDFf5d
FPVVOVMnhwk6NWvKS20UDgW8hupJgic892PmBorQ86mFohmC5raznMgq1sbk
BfGZMtYXHSeD/Isp0r189tyZJugo5/+ezqVoehyWtWggEKxar6szKcaiFGbv
IYL4NCRyMiisksGykfsE/Rpdk1VFcTw5sFlbQ+Ch93s1/XcesXnbgXUEXtmf
c9VKCunlqgdUR7C6cavbcI6iZW6XR8E4QWh8b4+VqZ+l7JfNzhMktjrzuooo
dLFBxsWPBLb1AM/vFcx79rFR+38QfHga3MdpZM0dlQ7IOlgXn9ou6npEEZ3x
xZL6iSC2LCuudZCCGxYu2FogkKicG8zPKcSnm2cbp5h+RXqTv5FC4/a60m2Q
9VsfiXbzNmvVxrqLWz7Tv/ucMG2IIkpiG3CNIQivW/iqZvZr6vm1ZOMTbPqp
UmSFFNUx0fXJRuYepJxS8wDrHS1JqdnPWAtH1g7UMv85mM7VW0xy+CbEfZMZ
KGpyPI/YJuTg3JPmZ5so6kQr8zfNcsDlxLXICWY/vCL+izk5DMXcQytmCmeJ
pbzbIse/9/sHix9Emg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{241.265066361125, 124.76413176875}, {241.265066361125, 
        126.51668522}, {241.793832488, 126.51668522}, {241.793832488, 
        124.76413176875}, {243.545135901125, 124.76413176875}, {
        243.545135901125, 124.227865413125}, {241.793832488, 
        124.227865413125}, {241.793832488, 122.476562}, {241.265066361125, 
        122.476562}, {241.265066361125, 124.227865413125}, {239.513762948, 
        124.227865413125}, {239.513762948, 124.76413176875}, {
        241.265066361125, 124.76413176875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQrXCryezumzyHM7Y6b7vL4x1W6j2VW/Urz8H2+fSw
3I54hwppnQbLv5j8Vdvu/nEMi4Pzuba3TO30jnNY83rDfud/eQ6stm+Dw1zi
HBIKTBn9GPId5hg/ueDoEOfw0G/2RSmmfIeZZRIGK2ziHAylPJjL2fIdpu/0
6eezjHNoqohiX8Cb75DUcMKbxQzB1+qqSE/Qj3MoDZ5a+fFCHgb/75yu3E7z
OIdqM539Krfy4Ob5PLA76Psgz8FY67avLtA+E1MPp6THeQ4XmDMFfBzjHMxO
rBXRf5bnkHv326UstziHFoavxfue5znc5Dn9SyIAwa85+Z4pOw7B373YcqLF
/jiHR9dM7SzvAMMjueTIvKVxDrd4cjvnn8tz4BTwP+AzM87hlWP6h679CL7+
hqezGjYj+PypPaYnVuY5rPxVcmDe4jiHxfO2C0otynOQTVxzSnJHnEN2HWP8
yll5DhOOP74y5QzQvdLivpem5TlwhDxrXvkMwZflc55Uxh4P55/zTTx2Qjve
Yec2j30Wc/IcHm3+aP7HK94hattC1Y/L8hx6llcqSafEO0yZrFz5e2Oew5zn
du+31MY7MDccdnQGutfOOuUzW1e8wy2zy+E55xH8B5JZc+ffQPAZUg8zRTwC
ht/EwI93m+Md0NMTAGwIDRM=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3cLwtXjf8zyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyvewaiiZuGJ+3kOpu6mBQuq4x3UXbe80LuA4C9o3n5J7yiCbzK55sHm
PXkOf54/bf9TFO9g4Oyd67stz2HvLqOD3YnxDjqfJX89W5/nUN9b/0sqIN7h
+86p2+6syXPIX9h2SsoCwde8UiB7VxLB367FuuU3R7xDnIFlusq6PIe1Z6/p
TP0R5+AWfUcyZ0OewzUH3acWL+McHi5k4dq3Kc8hjeFgffitOIe/c3T+8APt
j9+iZaZyPs7BN+Ombs6uPIcoq8lfPhyPc3jlmP6ha3+ew04rq16LvXEOihbb
r+gdy3OQTVxzSnJHnMOyND+JpHMIvs7Up9FTryH4tZ+/x++7m+eg0F6evxmo
f+tLd5ekJ3kOB9suXMs+EecQYFBgsuUZMDyd55SznkGEtx5X4ezNlxF8WHwA
ACW6y2I=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0sFHAYx0k3RcprixNdJ4rz2puSfI21c52XZHak308XZUm/OGzOiOYl
YaMlrZ3zRyRvnWWXddbSKNNW3mp2icjy0ouXWas01f3ltv74/vHZnmd7ns/z
8KQsMtHIwMDAUBdXXdbpctTYAzmWDMpFVepoEMHdLk6EmzmDSUdBVclxgrin
vOEkWwarrukr0bEEvacqdot2MHDjQ87xzxOszk5smHdiWPR0MZtOI8iLbWku
3sNwur130D2XYO6s2kPhznCHr/qxvozAsbcWMm+Guryx3GQFwUZtupTny/Al
dNmtUUMQI+983ubHkHLQSer0Sc/diz4BUi5dY1HU70fmoRSXdz0MVuj6b6c0
tOZnUhT5By1pfBis0wOVfdUUEe8kH6Y8GDSBf6bCmilmBsLj+l0ZKl83uDVr
KBJoweP9zgyJysKhlBcUHkN7tZU8hmGec7V6kGJMxnubZMeQOS6qNZ6ga37y
/LKcLy1SlNpsGQywYvhqGCay/0nRbUrVUzpf7R3efeMLFPJQVXWxI4NwKa7e
a5biVpq/5B6foelB/7jFJMXf7GOjGheG+n2+NeNaiqvfLHKjBAy+nIQMrwEK
TknQgkbna3U1+2RMD0WZCJzOIwxFqVl1wU0UllkjwvlghvutF+XcCgpVZKKp
mYjh5RvBXGkGhViw/MotXFff8/H9TCyFne1hz84TDJuyrcsP+euZmH2Pn7HX
c7Jc8uz6JMEZO4eWHCHDVteQWXErwbWVzTeiDjD84kdXiPP195QMeJWtpBMk
qdQChW5+h+02xk8ukLX9xCZGhjelBFXCkRLtToYWWWPNaAxB8OeewjYug6yr
fJsynOD/f/wHB1wj6w==
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
        324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
        137.844}, {333.668, 133.09}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
         "], {{322.62239645999995`, 
         139.61787444875}, {324.47745303749997`, 139.61787444875}, {
         323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
         139.61787444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
        "]]}, 
      Thickness[0.005154639175257732]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 114.809}, {
        261.641, 109.93400000000001`}, {252.207, 106.23}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
        102.85199999999999`}, {251.016, 109.52}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzeH7c+3K8nwH97UW77yLox0mLoyeVtaa77AjbEm4
bku0Q0Lfou+sHZh8VbVXfxmDouD8FrWJ0zzdoxymxKmbC3TmOzSs+Rki5hDl
4PF4dYVUd76D+OIPFxltohxOHhT0fN6T7yDyTMUwwyLKQbJ3X5XzxHwHIc3I
CedMohyyXl+oy5mR73D3/RWfI4YI/tKfLRkK2lEOsce4P+6NxuRX8EzP8zSO
ckheucjsYwrCPJPgrRZS2fkO62Y+93trHuUgs2LfTr28fAfv4lJBHtsoBzlr
lZ7fBfkOL3yYr2g5RTnkFGe/7irKdwipuf77hjeC/93iD7N2FIJvJuw26ceu
KIdTnmu2sqYDw+Nyw9G4hVEOh+ofM+REAsOjPvogz9Qoh0tb7qaHeyH44sox
Qr52CP7360xrp5jkO6hkNR6Mmx/l0C2o1/lMJ99hxoUdp29ujnII/lh+rVQ1
34Hb/MPVkBNA9/b1HpmnmO/QdPhTS+YjBH9Grf9kM+ZoON9zb+7xDvVoh4Wa
+01Z1fMdYpX/Wexxi3Zw0pSYu9cw34FdvE35dny0Qw3brA/HbYDxE+79oaQy
2uH1J8ud/ED37lxV8OVYa7TDoZWe5y2iEPwTPQ9EcpIR/BfXLatUcoHhxxD3
aW59tAN6egIAw7gO+w==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnVOc/bqrKN9B/K9s4u5bUQ4wfsyufyZ7XKLhfDve
a+z1adEOUq8/SUzNynfYsM2xMKE82oF/h1bC7ygEv+ObrtdvfwRfhu1zeIN7
vkN5+KeOPXnRDhLbDj6RdMx3sNCyP+QdG+0gkjahcLNVvsOvP92/b3lHO9zX
4dFbaZ7v8Epg8ulbxgj+EudaubmiCL7RLMGtu1miHdwWr7/3wSLfQcP2sW7o
lygHvXNBEy2s8x0CN1g++/EkyuGkSHVjl22+w8P8sw3i16IcnvIvLr7jkO9w
S9nc/MmpKAfT2/5LLVzzHa6unP91w+Eoh0tb7qaHe+U7mKxy6/uxI8qBc7Wu
z++AfIcZF3acvrk5yqHv5pF+vUgEX4Qj5nJiIoKfmpZ3vSsj32H2t+aC4p1R
DnNj9u3Wy893sPl257r2kSgHi8XPVjcUAsNz84qKo8cR4b2ysnZO8XkEHxYf
AOPfxJE=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EYxeeKJLxUCKFllykl3grCKI3cWRfGVCrSvLxv2VLMmNKrG3Yh
TSNN1BSnEsIU724MqWG6XN5oLkc2nSmzxGmJJqEpSFhmdPl/UujD+XB44OE8
v+cIEtjFpE08Hs+Bkx8nPqd5fWScdYohOZ2E279R5P2+JxFMM/zS5vkc+kph
+XO1f+Y9Q5HMwxgxSXEtYTmN/47h4YB+InuYwt9WWxpvYXi29iGo20ShSbQt
mswMotvH0zIMFEJiken6GEYKK9WBLRRbf0zHjvcymANl+80qir2fnY/5Gxhy
pFGKgiwK6+n+UVU7w99b3iddIzf8RPAgX+S54S+NbS4qmyfoqLRG6ToYHLtj
KwSvCOpzQjXKHi6vvqdhvIZgWZDnJDAytKZKOmceE7iI3SzCfm7fxxpFfhZB
acfUzfEBhi3bjRZTOoGbn3aHwspwBLMH+NcJwsOkppkxBt+I9npVDFnnk3tQ
+UQiJhg+pwwO4/h5SLvkKiFBUqvX7A2O14J86I6Jmz9NG3F4zfGKCW6okp8n
KAs/I2oeZKDPQ6aaogl8T53oUb5h+LlibjRdIWgeZrtXTQyDl5vF+ckEXkdD
tUqOV11A7pJEQaBSiCqUbQzuhkfV8cUEO89qL8S3MHzPLDfnqwnupniWCNUM
IcWTo/5GAruy5O3+eobsap9PVjuBa5NYpqxhWJ1bOXx/bcOL9jhNd+6i6z5I
p85xj6YwNyQuDmkYCngv4qILKWr75I6rLxmcQ9sCUvQb/xQTa7vGSNHraknV
cfkfuCyEzFno+n2GGMcubxtFeYZ2m2KIIXZJus/O9Wl2tMutysZQVpfZ6PGF
4v8+/gN8PUXo
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4uMBv7Zo/8h3UEoUsLe4Ge0A4/epP0169iDa
4Q4vg/oC5gKHSQtrlki+iHZ4UJTCmMtV4PAvPfDE8ffRDk/WJvHmChQ4ZOqp
vSn9Hu3wT1RV9xOQbxq3cE32NwSfs0rFdPeRKDj/LKct/5NtUQ6GF8tYpwkW
OBxXW3Zyw9ooh/ovXX/3CRU4xMnOdZuzMsrhc+eda4+ECxw0Jvik/VgS5XCw
TNmiSKzAIXIxK2vmoigHFr73N7ulChxULzccjVuI4LdP+PzPflaUg0j8bdd3
QP+g82Hqb6amv81hKHA48N7p+WOgebONGdQUgP6NTri4lGlZlAPTqsXX0lkK
HLS3iXNPWhXlUGb/dX03a4FDonPGa9P1UQ6rfrl16LMVOKSr/TfI3IHgL572
LMzhGIJ/Z/Kvib92RcP5YrMfbb54LNqhufia/TmgeS/Wftn561y0g1nq13Xc
QL68teuseZej4fZ3uPjJbr4e7dD3X27aXaYChzDDqXVOt6IdblXNCrnMgOBv
vvdtCTcSf/qFZS/a/+Y7dK71VdwMjF8P/YTWHz8x4xvGBwDu//Hp
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB3CiWUxr5aGU3c6pZTo6yTHG+05yhSxPO79v7KrJzpJvUltP
s5yHbhdjIbIRKQothDrDdBySYp46MnqwSJvW+Yvt6tdfv63+eP/x+uP72Wef
95d/Ji0qycLMzMycjZDNJjZFvA8FKQzFi6kGwcw8g3i72GBFNEVeodEUdJ/B
3ZUeURn/f2vaux8aqhgMWifYKnwpDs6F2LmYE0S+jRcogil2j2aONHsS7BDK
PRZkFJsZbZbkFOdXT+maPofz+hMXnbiCIMfzyGFxKIXf9KS6vpFA6b0neJGd
t3Ujc8RSS5DRIPIqAMXNb7zS8AECU2ooTxxA0TaXdu3nCEFqa3LOmg9nyxL3
iqtenGeTXHYtelAs5rnZnx4iMO4N/+1zgGI7Pyy9sodAJG/Vq9wogrTn38+2
ERzbOdc4uY/iXJ9OlVlLcN29NOyoK0XXqH+5QkPQGBj5vf3vPbqy1lfzCTyc
27QqAcW48V6D8BmBQ4JmQsS+tw91cPTtJwi8UxynZ+f/GO9JLJ4geCeSqGvY
fYTdgfrKZYKq2WjNsDdF8kUm7KORwLF3ajo2gPP+kOUZk5TzfK5fVw17v4EZ
syXBCoHs0eU65wgKdVMEv9VAMOwgOd5xkqK5o3YybpDg0g3Hs4tsv1tuLWnG
Wjgr8hXVLeWcFxQbNmPpBEMX6rdln6Do11m9HJURSJsa1lVsHxJnm0+dTgQV
V1afm4QUVl3yYn4vA1mhFB3hnF2bU0TqSM4tuuaiMnafaoNT++PXDA7lf103
RVFYfxH4deoZ1ImV/uoYCtsHq4aYNwykysS+jDi2H1Uu7/Y4AwuXvpJeOUWW
7le28jODf//vHztSSVc=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIE1Acxr1VItOBsVQq00UtamlkkVHply1MxSB1GueAyrwnzeO8baWo
6JrTNJYgXmr2oBuWBGVKeSHRvHRDy4JEJUWTXGYTxW5QnSeFHr6HD/6373eO
tyIjIsnexsbGlms/lx1XQtyfwspLDB7x3aqGQALRSYsuMY2hdK+hJiSYQHVC
HWKvZKjyXSnaFk1g1vuuZmUy1IzIU2YVBGdGY+YGshjSG/1cTEoCB31Pu2su
wwfxu7dfNQRPnIO+71AziKq7fjzTEUQGHityvMKwy7pQeKCWIGTY2xBXwJDc
81ea1kFgdR8IkhQyfDYdSpib3vAB8YEQu9F1P9C/5fHoOYp8Jexu8/6tU233
T6sodL/KLrby+Tdmwxv11RSLw9UjvXz/0QdOn1zMFP4yYVUHv08Q8Eia3kGR
W9HSnZbNMO18c+xgH8WErPiVm4rhvOFwbc5riocidWgJz78cHnNnaIKu8/l9
VyvxWaQon1cOL3F+KZkkbHKFonmmphO83kcS8ML4haLY7uk9V86rPz7NZJ2l
EIo2C8Sc1x7PyY9vJin668rDpTkMXk0yo/E9hTbC6qnJY2jLZrnWlxTBXvoY
Kc+jvlwW5dFL4VSsU7Ty/LYz2mYHE0W4e6TDYAnD7p2aqxMVFNs31SfJrzGc
lR23hGVSWJanB+fKeP2Rb1PmaIoLqaV50nIGncWr6qf/hh/Pt1WY3Tf8/EJi
X+gUwWrqWnullsFQJ18QtBA4ji/t0+QzZFcrDIKCjfccCzxV2ckI1H5Ba7f4
/XXXvR0Lksl6viGN0C4qlkBoM9bUxflKZtuNDXKC+dHnYkkGw5JvvUdsGMH/
//EfCv8qpw==
        "]]}, 
      Thickness[0.005154639175257732]]}, ImageSize -> {388., 165.}, 
    PlotRange -> {{0., 388.}, {0., 165.}}, AspectRatio -> Automatic]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.825905024147108*^9, 3.825905072463655*^9}, 
   3.825905363382402*^9, 3.825905528383874*^9, 3.82590787412798*^9, 
   3.825908032341902*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "6"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.002577319587628866], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
       388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
       0.33199999999999363`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
       24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
       3.9919999999999995`, 13.508}, {3.9919999999999995`, 
       24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
       45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
       24.836000000000002`}}},
       CurveClosed->{0}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
       21.99788154, 23.851453813124998`}, {18.552508993125002`, 
       23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       111.074, 44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {
       94.133, 27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {
       77.191, 44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {
       94.133, 61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074,
        53.512}, {111.074, 44.156}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
       59.891, 34.656}, {67.65599999999999, 36.809}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
       39.508}, {68.684, 33.461}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
        "], {{57.68489645999999, 
        38.21162444875}, {59.53995303749999, 38.21162444875}, {
        58.612424748749994`, 40.420441815625}, {57.68489645999999, 
        38.21162444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       384.125, 140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
       363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`, 
       129.164}, {343.10200000000003`, 140.49200000000002`}, {
       343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
       363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
       140.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       357.65797799312503`, 140.37615644875}, {361.10335054, 
       140.37615644875}, {361.10335054, 139.507703813125}, {
       357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
       140.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
       71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
       147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
       80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
       156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
       90.35199999999999}, {173.45700000000002`, 80.99600000000001}}},
       CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
       
       "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
       62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
       77.762}, {132.35500000000002`, 70.23}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], FaceForm[RGBColor[0., 0., 0.]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4vMSz1gO/o10kLn4yHDFg0AHGN/lQ47vpvOB
DutmRGf3nsLkP3uZcsjLFsG/3WNm/UQn0EHMMvXVwjORDux7I6YoKgY61Dvl
5W67EOnA5Hww6J1koMML7/IPp65EOqQwmPScFwp0kHc6fiXvdqTDif6lZzfw
Bzp8WrG03PApgq8Tc/BP3nsEP43/buOan5EORm+r3saJBjpYlu1WyWeOcsjl
nFY2B2jf9R0er3u5ohyyHp+6yCSDUP8p7ITSO0aE+S310Qd5vgY41LQuOiNz
FsE/n+1vm7IOwT+a9DZo+vxIB+1t4tyTuALh/If5ZxvEzRB8WPj4Nsmxv2xG
8CU3zTx+rynSoeLAx549FwIdnj4U6bjSGOkgfHfzOsdLCL77Wot33pcR/Eey
x9dkXQt0aAxa7Pa5JdKhbnHHpfc3Ax2C/mz1kOmOdGhICCnuvBvosJt1/2mD
/kiHLQY3N02+B/Tfb74NV6ZGOuwIWxKu+yTQ4ce9pV/Zge7b38tu9etdoMNp
15YZp1ZEOiT0Jizc9DPQwaI04kDFpkgHxoetS1nYghy475glW++JdLANzD19
WzjIYcXWI6pRByMdSt33rq+XCnK4+84jM+VIpIOQonfRPPkghzW3+099PgZ0
f9T5rSuUghyqTlzTbj6J4MPSR0VuR4ikAoLPn1J/kUUGwUdPfzA+AMXUQmE=

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmdIlAEYxy8LL1CjZXhkltvcmEZeKX8hMUf6vq85egxzlJXmzoFY58rR
IeGpoZjouYlI0dTEFSZeWCpliPNsmISWUGSZp9l98qAPvw8/Hnh4xl8/LJa7
upPH4+1QYq5ETYntR+1I3RrCtXjynPXlEBEb4fG8gaB4dNfU2ovDz3jrs64l
BHGkYMDLiYOeI1uelUvIHu6YEdlyaNVrmRTeJjSvT9r3GnF4fFpQzL9FcEk5
FZck4DBtxi+URxHe3itrtNLkEBNmd8P2CkFmFXlMpmBR7pxv/M6fkBFyIbFg
jsW6Yj243YewlWzotKdN5TOOI2ou6Sr3m9gllniweFWvFSr3I/B7A0v09VlU
Jy3zpaHKeTv6aqe2GDg/Sx3tv05ovene/ekrg2S1Up/NOGW/+arEvDkG6Z8t
Sm3TCOp7B14PvmGQ9XJgOjybYIcFY7UhBj9228BVQjju1V5T0cls3yfHpOiB
eyODjX1F5vulBEFIT0JFFQOTqTaRTzFhOWE0dVBZ7/I70M3PJwQ41j5MaGaQ
ofHbcVhECGoTyus7GDxZWzghTSH8WZXVDfYyaNL2XomOIYxcanDLkzGQypc0
pOEEqWXOivs4g+Kg7/PV5wk6XbmVwd8Y5P8dCBQ6EX6lF8vy+Cy8PRvHN+wI
wsK5cQsDFgfLxN79ZgRRpen7sTMsUvs2xdWGhLXFVZs7pHKXIxofutNUbt/S
mKHTwWKp20Fy+CShgNd50X+JRYXCdyiaCJrOTy2jDqn+6UZj7U0GHGaK1Ivk
0YRMrWXhoiW3vV9XAL/H0IFD5uUXE+GZhMCVkKOzyjwZ6X6Rt98nSKTpdYJz
HP7P4z+gsjI1
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4leiyYpXr0Q5KCUK2FtYBjnA+H3qT5OeOQQ5
nFqdF/zvU5TDpIU1SyQ9ghzu2DPsNeSLdviXHnjiuH+Qw2vtn28M1aIdMvXU
3pSGBzkEn2HKcdOIdjCNW7gmOwzB56xSMd2tEgjnn+W05X8iFuigtNPz7FWt
aIfjastObuANdIhwm7W2Uj/aIU52rtsczkAHjTkPhDhNoh00Jvik/WAJdEj0
/zPdzS7aIXIxK2smU6BDzhot+bV+0Q6qlxuOxjEi+O0TPv+z/xXg0Gqk6hx1
LQqDD1N/iJsn1/BZlMOB907PHwPNO+mU7//vQ5RDdMLFpUxsgQ5pMn8FZb9F
OWhvE+eexBXoYFbkXL7mV5RDonPGa1P+QAeW+K4b1n+jHNLV/htkSiD4i6c9
C3NQQ/DvTP418ZdUEJwvNvvR5otqQQ5ZTie2bfsd5fBi7Zedv/SCHEw4XYrX
/IhykLd2nTXPOAhuf4eLn+xm8yCHqUWv+L+8j3IIM5xa52QV5HA4/gbn6ecI
vvp7T+81TxD8LtE9Hb33oxw61/oqbgbG75tLeofybmDGN4wPAGTi3Ew=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4n8dwsqVH6Id0gujvO8EBzkwut0/LPQl2sF4
4VXuS0EI/uU3l0PEFQLh/BkXdpy+KRzoYFafzC77Pdohvm2O1xzuQAc2zTJO
t7/RDt9qJh9vZw90uH6pgzufOcbhy/7jau+YAx3c9mtc2SYQ4/Ap7ITSO8ZA
h+CbSn+2qcQ4qF5uOBqHxG+f8Pmf/a8Ahx8/noq+nB6NwYepv/CuL9F1ZTTc
PO5vZc0yW6Ph9q20YPGy3hPtoOUrwT6JI9DhUZPC6Yoj0Q6TwxS7lvEEOtRx
PPrw93i0A+Otg37vxBH8m+ezZnlpIvj5KWpZPoJBcH7lwZCPmxSDHB7qhejd
PxTt8LRdUzRRM8hhebXFyoU7EHxbTgOl3k0I/kWn6H/3VkU7PDGOrTiuHuSQ
qrHLdvrCaAePdbODnFSCHP7dromWAfKrtUK+blIOcjjF/UNaaEG0g8g9MWEL
IN/gvemvnnnRDu5R57euUApy+CO3cVfT3GiHB7yTLusC+b+2btzWNBvhvp+J
TyVfzox2cPt4fuMKhSB4+FXkdoRIAvkTIu5MuzI12mH1Fd4JyvJBDt+spUr9
p0Q73As4ZjRFDsEXdRcTt1AFug8tvQAALfsFRw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx50SNQ9tRZ2tPFRuebizZNXy8CZtotPv94vZ6st0iUSF5KEn
VyMy4ejsUHexwlyr2XlKqKFcJE8lF7eyq3SauEwTtfKX2/rj9cfrv8/7/f7Y
Cc4yJ1YYGBiwlnBcwnCJSV10oyKPgB3Rklgmo1AXueGdRQ5BhoOo+EAVBQfB
IXXObYI83qzQqoHC71LnbH4NQXFfSLSmncLJ+l5/sYIgVuZmXvmawhlJZJ6y
hWDE/s3glIoC5Mm3dJ0ElkVP5jsnKMgTAptkrwhsZrTpTvMUrornFhdVBFGt
f51jrGjYjFxrtx4n+FrpevwT9O4V4Q37FL0/7zBu6q+mEcSNf6Z7T7BOrXjo
M0jjQnghm9dHkK/hy27M0rCQtM4Juwjca9d8Njdm4JEpnw59SmDqVecca8Vg
V8X6mq0NBB/NCodc7Bl0Z53Tjj0gCBLtkJx3YcDpCRrPkRLo+KF3u/Yyy/0s
1mRyuAcZZJg7qnYXEEQnHAkcO8xgduFlufAOAZfj1S0NZHDsyqkoZTVBR0RM
5cw+BqXK6xNGtQTbNo99GPBgEDcqmeI+JrC95yeVujNIbOO5CdoJFEnxyTNO
DNLmCi15vQSpp7OD2bYMslJzfXgaAtZ45v2VqxiI3jYrxbMEWzalXRz9RqMn
e5g/9Idgv9+eycABGkYePwbXmoSBtXNaXdVAo8JSKOaZhSFr0jbvl0Tvqkss
QVWq3r9oI9sDPGm4bvTPr1sgEJWEaE1X00gf2X5UMEyQVCQQmar1ew55e95s
7qfg7ZtSoFu6vyTXzuTyC2o5X1eahWFwG4WSpOaAuEcEHE29tKyews9Gsa91
OcF3Xik7XE7h/3/8Bz1JN/w=
       "]], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
       138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
       56.516}, {119.85499999999999`, 51.789}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
       110.84400000000001`, 47.38699999999999}, {118.293, 
       54.922000000000004`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pVX3jQy3EhwMF10NDmg1ccBxm97cHNWSrKP
w4wp6lvT9mHyT1w+2TLVzhvO3yyZW3ZC1tvhTMqaLwX7Exy4qjZqOLN5OzS+
NDCrPpjgwNjWtPTOdy8H07yt5a2HExyOMGRIzH/p5RCYeTfz+rEEh15579mJ
j70cds/x2b3jNIIfUXar9voFBP+rf4bDt6sJDom3vt7a+87LIa75+sTrtxIc
bgjpvLVg93ZYqyL3Ne1egsOFY1MXs/5BqH+0doLrneMI81n+b2uSXOflwMB9
OnXdfgRfs05RLmgDgr+k8sOK1ysSHIJz9MVUbiL4++/PYtQ38IbzYeGTwcnZ
LDIbwfdb6JbcPyvB4V3DY8nKVB8HE8sWZy4gX3lXemxzBoLfFVV4Z3oWgn/I
ui/yaoGPQ1Ph6UUzgeb9dBNcer/cxyHr2BXldfMSHP4dWPFMqN7HQd47MnXH
ggSHtMRNqeqNPg7Wbo3hXEsSHHLXeqyP6vFx2Lfd59dioPuqpflLviz0cVB/
vdu7dW2Cwx6pg06p230c7jEti4/ZlODw/yC3N+cFHwd3M9GNttsTHCoW3Zq2
/bWPg5hyjNDZnQkOz/qq4v//8HHYYC9nErQ7wUHBadoTG2ZfB/FtB5/M3JPg
0L1lXnYgp69DvU7q1Id7EXxY+nh3S2ClEQuCL3Pi3yLOP4j0hJ7+YHwAJ5o5
vg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+8c5mHucp6WsenoSYgYYtx7HvP9/X4kpV1s/b4tCunaGd2M
zjxs6clEhupkbVQzzdzK40hb1GrLSGvYmg1F7GpiFNfvL7b+eP/x2j7vzz4P
7z3n1CcyJCKRSCzIW5CZIFV3eZCfN8W7GUNdVw6HFVObV4kPxcop26T0dA7h
4urmKE8Kx09HyhsiOXw8r2CpG4XkXu5LkxeHxs+jOf0uFGd+d2QV2nFwybR8
6+lAoVu+8nVhlUV7+masTEbR7BSQlDbFQrsuDwq1pbiVNo47vSxuz0fIb5hT
bA0+mZPrWETGrbVviCg2luIK3bx3uDOv0aK0j9nmljZr570qBvvvi/xlgt+m
sONAtCUD+zJ1mdGaQp5bHN/5moD3ejGns6Pgv9wtGH5IUJQQ06q3F/oNKOel
OgJTj4yEOgt+j/KGygsEpT6TP0ZdKWjJCGN+nKCHrW6KUlAk1mfHhgSS7ftY
cgrfGjmBMnnI8elBisOD2tlgCcG4IWVgWKgfm33w87oDgXueZNrTneKZJu7o
rIJAnJjvZrGbwpCZ38cEENTHXGowOlIYF6sSKpUETmOPVlN3UdR1s1XSFILq
EHWF0YZCqbKarskmsCnQqI0mHn4au/B+PUFF/OSh/jUe39f3VcnGCL7lcln6
Xzw0rr2tp60YMLUDLbolHn/CkgabIhgUt2pjjQs8lj8snv2r3eFrYc5DV7t3
OINPEgf4swhuqR3xXeEhE1/ubKtnIX3zeCbVUshD0UXVhHHnnzcN+pxkaw5+
9pvxMmH+LdeJ/Pfu3PZ+6udSbbwfBzPt5MKosH/71KvILiWHlIml5Q0PCkX0
+rHAkxz+z+M/U8AdhQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYrNg7QldzokOjocU6grMfB1gfAn/U0fPuPo6
qMkZas4PSnRQcv7pYRzi66D/4uddi4REhx/nF03oT/Z1MI/79tUiJ9HhfIzP
jddFvg7ZetWmzrmJDul7nCKvFyD4/F88ssp4veH8acJVcic+ejlcWiL3rCsv
0aHb12dy4n0vh9zXbtfuFCQ67LCy6rW47uUQKvaqQ6U40cFHYeaZD2e9HD69
L/d2rkh0WO/GzXXphJdDuRx/f1lDooP7MsbuvccQfG7F53/rd3g5NCfyKPq6
YPJh6pXO/d9q4ZPoUHu/9dzxk14OSzMN1ecHJjpsObDIm/WCl0NJWEWHXkii
Q3COvpjKTS+HmEZp67KwRIcDbReuZT/ycjj8fd/rveGJDmd8/iVe+oLgu+ie
Xdsg4A3nb1H/qvz1pw+cr2V2NH2xoK9D2cu7Ub+B5p2Lfln8VdHX4fYZacuy
0EQHq7IuE1ttX7j9PJ1zrNKMfR16GPPZpYDuW5mk9bfFwtdB+UdqC6svgn91
v5xqmTeCz3b5+uFnHsDwj57tlGbu67DdcGJCuCtmfMP4AI8U44k=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4gM9zBNjLiY6nHq0ZdqObF8Hx+zMRM3LiQ7J
TqvFl2Qi+ItuLl+px+IN5+ssLJy++bWXw+127eZ1VxIddvNYTrW47eVw5I4J
y+HriQ4vf6r181/2clhjaNd6/Vaiw5P6ft87p70cnqj3ZVY/THR4tHaC653j
Xg6vTLprq18nOrgvY+zeewzB51Z8/rd+h5fD3iM5XSJLMfkw9SvtHTccWosw
z83Z1HHdZoR9U59UL7HdnugQOMuAT+Wql8NGTq7UmN2JDsprnUR873o51J95
9V1ub6LDv83Nc+98RvDXzb9qMlXMG86/fcLnyoxnPnD+h6aVj1LZfR023l88
rX9XosNx/mCtQ2K+DiJsYlcKtiL4989MnJC2CcFfmbm8rn9dosOR9F0f+oR9
HYrvhM17vTLRoTfGfGkLj6+Dg5mF7jog/1PIilep3L4OaudKeTWBfNU9umoF
XL4ON/ZPqUlbkejQvWVediCnr8O+8EsxD5cnOuyVVlkezeHrYLf4UtTDZQj3
2Vbm9IgA+R2P5icHsvrCw+/dLYGVRiy+Dp1fnntxLUl0CF4preDO5Otg/Yxt
l/viRIedC3tSNRgRfI0+Hb0CPl8H9PQCABJuC3s=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       145.02237524912496`, 55.48896844874999}, {146.99118529599997`, 
       55.48896844874999}, {146.99118529599997`, 54.99270331312499}, {
       145.02237524912496`, 54.99270331312499}, {145.02237524912496`, 
       55.48896844874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHVO88fHrS0kOXVGFd6Zn+Tg8PS58ZseDJIfctR7r
o3p8HLZsidL1eIzJd/e58ptZwwvOZ/NV0p0s5OXwouV+TtCTJIe/EZ9X6rB4
OczhTFkX8yzJQdvt4WLmP54Osi9O1mm+SHJQO+OZdOGLp0Pu5rINrW+SHBSD
NinMfevpsE+wc8u6z0kO2++vnNnxHMH3+Mx50eGWp8PGN4fVGLZj8t9I6N2d
9MrTYfv5qBzjAwjzOipz82KOJTlEGJ+fe+uzp0PBubL3BSeTHCY9e6Uk8c/T
oSjxzkHbM0kOZ2ayrQjl8HI4MFNZ8ezZJIdlP9Z93yiN4L8u/MEeZoHgZ6r1
qHz86eUgV5Dy2v0QMDyWMXbvPeblILZsttm6LUkOLP+3NUmu83JQuz117syl
CH62p4hH/0wE3/vfrkfX+pMcXK8wNe895OVw3/zZPo2OJAedhYXTN7/2clgu
bsCzoyHJQTjvweqVIt4ORVtcfz2oSXJgan/KedkDwdf5PU8ttwvB76+63Sd4
2dvhq395tnsTMDzd/hRWCPo4TPO/cOl/T5IDtx6P+zZnH4cLOkFqXDOA+tdN
e/CyzMfBXvLTu0Cge/NDH77o7fdxELvAyFq9FcGX2TzDa90+BN/m38f1aSeS
HM4x7nli3ezjgJ6eAHrsIys=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQfWCmsuLZs0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg45Amu9rt+NMkhJrf50YEiH4fke4+m2m5D8O/IPKu3XY3gF+is7j20
KMnh9bongpWJPg45dyqlYuYkOeSF1LVMt/NxyOjxWP51apLDx5/i37dK+zgY
Bx9Jfj0pyeGSotr0ra+94XyX9l82VusR/CQT5azyXm+HWSfTRYynJDn4VB2L
XpXj7dD0het41bQkh/kJxWc++no7yFobbz8zI8lh//1ZjPoG3g6WZtEr5YD2
b3DPyzsh6e3Qychxu2pBksPyYPvXidzeDmq3p86duTTJIS2kV+bjVy+H2ItP
G23XJDnoLCycvvm1l8Oj/zVHC7Yg+Bl6IpxL9iD4O3vUeM8eTnIwfsv+8Nk3
L4ePTWUfC04lOZS82bk+nMfboefkvIeHziQ5VKYFfuwSRoR3wOdfFs+VEHxY
fAAAcRvEYw==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk3EUh+c1TWXihdq0gbP8YKhLLfEy+0kz7N37TgkSh4b5/tOJRpeF
rEyWaegsow9LK+xiaWQaBktFyryEtwlJzZTSspkplRnqUjSU9X6a0IffhwfO
gXOecwLYU4ezHXg8nh2XYC72XAprM+avrrII6z43s8+Bwhdl5Eb0CgtnRhyi
96JwKy2lWGNlIcictQuRUHBY7hxNcyYIvt803H+IQnQJv219K8FIvMqfzqLQ
YRlPq+YTNCc2PJrQUNi1MT3R6E0QFKRZrNBTSD82PH9pG0GcecSa2kIhUV3H
l4gIjIVWpWmBQpX3T3VXAMEbJqt/MFFu4/Pd2mKZYZPLy/mnH/jSeNppXmzk
+gNfqI6W5tJ4PXbmnnE7gXCgJt67iUbl2fLKJR8CFes7tMNEIzBP6zrpSeBT
lKscW6BRu2rIkbkTvPLb+TjdhUFePltWu4XgtjhbMidiIPBIKdHwCCZrmnE9
lrH5+XPELTkjg8FAs1SrWGMx9LWluj2fgbX+GrvE+VIqim5I0xm0zX6WVTsR
lPaY6Ck5A5PbCadWV4KDce1ddVIGsb4FOqMHgTSpIk4axqCzDLuJF8HxH+Zf
Zj8GCWL1HSPn6/e455NwRwaD0ycNRjGBtcdN7vqWhsLLeWU9mEAWs7TSVkNj
bk7f7ich0OnU72/m0ND1BVyI2cvVqyZfJu+hkWrI/WSMInAfTfC3LMtt/GzN
vlfRusmDI8bLVfFy3H1OKytDCUQRTSbBGIVevXQ/8SeYCeoTC7Sb93x4sVBY
kE2hPunbx0Zu/lDBAc+/KZRtvysWkWMDKLybcor67kJA9+dLo8IoFJdawrvs
CD5kRkZ0CCn8/4//AGdIJ/s=
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       242.777, 101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
       84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
       208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
       101.48400000000001`}, {208.89800000000002`, 110.84}, {
       216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
       118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
        101.01833734875}, {228.42917790875003`, 100.1214467175}, {
        227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
        97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
        100.1214467175}, {221.98906566875002`, 100.1214467175}, {
        221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
        107.2353207}, {227.01602828000003`, 107.2353207}, {
        227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
        101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
        225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
        101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
       94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
       88.67999999999999}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.2, 0.627451, 0.17254900000000004`], Opacity[1.], 
      Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.2, 0.627451, 0.17254900000000004`], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
       172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
        
        "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
       97.30146844875}, {187.73723616800004`, 96.805203313125}, {
       185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
       97.30146844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
       121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {282.441,
        114.262}, {274.85900000000004`, 121.848}, {274.85900000000004`, 
       131.20299999999997`}, {274.85900000000004`, 140.559}, {282.441, 
       148.14499999999998`}, {291.79699999999997`, 148.14499999999998`}, {
       301.156, 148.14499999999998`}, {308.73799999999994`, 140.559}, {
       308.73799999999994`, 131.20299999999997`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{238.125, 113.293}, {
       245.82000000000002`, 117.87899999999999`}, {255.996, 122.754}, {
       265.42999999999995`, 126.45700000000001`}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
       274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
     {Thickness[0.002577319587628866], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4nSe4qYHM3McFiZeM3jREu8A459sSPD5VBzv
EHZm7Va3Bkx+dlXEwa6HcXB+gqyWlcrFOIeuOUZfAxpzHHp8fSYnHo1zsFfc
bhbdnOPQfnlLoN6+OIfPS60rUltzHF5OUO/m3x7nwL8wOWt7R46Dr8LMMx82
xzlUXrm0e0Yvgi+2LqFu+yQEf3P7O4dr03McttfmvZm3M85BZnfspO1zchw+
zewsvQO0LztmyVe3BTkO74v3XXA6gFBf/ny3ot4yhPmcAv4HfGbGOexzCkzr
a0Twn29dLmdUhOAnbSxbeTorx2GDGzfXpXUIfhrDwfrwWwg+LHzUHPubv8Qg
+Dw3zyTnA/l/A552/ymJd/hUwOXyKjrHYUbu8rWNZQj+GVudt93lCH76ul2r
V1XFOzisDFxcGZvjwGxSc1G/Lt5B41+USl9CjgPbR/eik43xDneb7qfOSMpx
sDx4ZuPlpniHn7XsEa9Scxxsn08Py+2Id6h5f+lXM9B9LnK/Lawmxzs8VXLy
Sc3PcXgqG7Lg09x4hzlWOgk2JTkObYWVS1xWxTuw5s3eKFuZ43DoYcIp6R3x
DleiHgmtrc5x+HV9w7r9++Id8sqXmBjV5jhM32hXeO9wvMPVt+5PK+uA7n91
aMuLY/EOtimvpx6sR/Bh6ePv3+rgyCMI/pQvRRdcDiD46OkPxgcAKo9Gsg==

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+ksZaHa2imiVFplVhEVa+8yDyFtarmo7xc9bPEtstb15GQe
6sZsEptxJgojXYzMNY/LebpyTip3zkXdUs7jspTO+v3F1h/vP17bZ5/P5/15
f7ZGxYZc4pmYmJhy2s1pBSf+jMUBKwODwTQ4wG6eosbDdUfEJMN9z9tO16Yp
fh/kFzvqGdYurGnNGKHILCgPOjrMsCq8Qt38nkJgLWCSQQa3dIWrsZNiQJLR
xRtgkJs7x9Y1UrDHyb5TSoZQ24zSqy8p3Pfludm8ZQhqOu9gXkQR6PBmfbSc
YeWMX3xXEsXfhASpuo0hxZzvFRy6zBHdLaZJW5ZZfXlerJok0KvS9k61M2Sc
CMqObCfolc0lK3u4ff1qijc+JbA/5/WN9jJ4GL1k27IIDid1l4n6uX5x2fEd
SQSNszkBNp8Y0ovqesxuEuBi5ET1EEO98uP2Y9EEt1L4RY5fGV4MlT/RhJOl
+1jUp+SIAwmMD/03iMcZCqel1zXeBI8Mg81lXH0cr01oFkSgqRBreTqGoa7c
/JpTBM2pC3Z6NcNnbxetPozgzL3ZPOUHBlHa6xKzKIJ+i52/3FUMIRN5vh0x
BCdj51KVCganRuGEWEjQWTUfq2xlkBy/U1DI+fFOjHSWNDDctXwg76gkKH3W
f0VUy9C8uU8VIydYrfApo1IGMxdbnfUIgadu0Uf5nJsn/O7StLjM8qpF3YI9
XeIG5CcKwih+ajd1Wb5isMqqEORmUiiMu764dzJkvSvbUylbzlPxo612TE5h
8E/2n+rj8iwcPuTUR5f8HRn7I7swSNEijRyv1jBoRaft7UYp1lndmFKPMvD3
x5WcNVD8/4//AL5DSxs=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4i9dGydkseY6LP/IbFdxN94BxhfecSNR7Wm8
w5PQ7Zr1IrkO4kYFiyPfxDu8lW+4J6GU69D8w+U4+5d4h69Ta75J6OU6vNsn
+Xrr73gHzTRGM2X9XIdd76asXv0Lwe/jkjD5fSIOzg+aZcCnsjvOYcKdJc+y
DHIdfLbPPPFhY5yDtvLZa3uMch0er53gemdtnIOwX0Eni2muw1oFh1SLlXEO
G9T/eStb5TrcM/7JvHJZnINp2NT+MKdch1XJJUfmLUXweRSf/62fF+fgOHOS
oi4bJh+m/gFr2zYJvlwH1wazZ8rL4xySF25XrxfOdXjw4cgSp1VxDkZ9/zr4
xHIdNrhxc11aF+cgtXOhdZhErsOzy9GvSjfHOTTqu76ZK5nr8GbbJ/2VexB8
DfVboQ2nEPwElXcTrPbHw/mzta9tEjwd72CimBJ9G2hert2LHVaX4x1msiyy
DBPPdVhy2mLmvevxcPt5rzrKfL4d7+Bl+ZX9l1Cuw+2DHbVN9+IdHuq/aXnK
h+BP/r5ENYwXwT/CFXfkGFeuA5+do8JnYPyWZoonmrNjxjeMDwB3TepO
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk1EYB3A1LBc2XBOtlZIGKUIoiuZszaeIGeIlxwzTes82J8PJk03F
K2nmFG9oc9Ps4m1EpTiYigpSq0wlnQqKoUSZoK1YpXghEtP19umF+vD/8Pty
znme8/eRZ4rT9jk4ODjSOU3HiU58gXKbO4zAV7b58lYoWJLL5PY+BFefL7sl
rRSIOWciMy//b7eoXsPRxxS8iFf/3LuF0I98rtyZgGVW5WvXIbRLsyfXQwiI
9cpweytCtc1YWiplLDyr2NxfzbgkwmM4r41A2P1IkfEhglk5XvnVRMBuWJOx
GhF0NdmTF80E3LU8SKlDcMrnNtZaCPh7iHjGcoSIG6kFQbMEXDoqrH5FjEMV
7MPBWYxXnH8fYmUgqI54uXdMEeBWxL/vTkO41yNUL74hcNfmlS6SIoxES6eP
DRF4pVKH2pIRvksG77x8RuCkdjnLkohwQRbY3F5PoGIw0dT9dx9xuduBDQQq
c3wSRBKEJE1NF/YSSNqa0hiuIjyYZ3nkjxPoEi9VWujz1Yq+63MLBCZa+Ktl
KoTeuODRxR8EMtapjXe59H2OcdHHfxFIea6osZUzLh6p0gp0jL9FBVzR0PuL
ydiypq4RMGsMAYVPEdjC8yc2PxIYUfJvGk0IYZea55om6XlDrB2sfoQ6zodq
ziDjz16S9o0Wxmnrqwc5efT8ni67oi6EaMnOgFssgR49e0akRxgz7n3a8SYg
92s6J0hHqI2N0clG6T4kC64ZnzDOeVQrTOhmrH3Ns2fS7zmlYvdbxyhokNye
EdB9q8/2DN+ZoKCos0qcMIDQELS8oJ+mwOSao/Afov+HW+j9dp6CkOLIA8Nm
BBeJtazTSsG//f0DwMpEMQ==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{240.761020489125, 124.76413176875}, {240.761020489125, 
       126.51668522}, {241.289786616, 126.51668522}, {241.289786616, 
       124.76413176875}, {243.041090029125, 124.76413176875}, {
       243.041090029125, 124.227865413125}, {241.289786616, 
       124.227865413125}, {241.289786616, 122.476562}, {240.761020489125, 
       122.476562}, {240.761020489125, 124.227865413125}, {239.009717076, 
       124.227865413125}, {239.009717076, 124.76413176875}, {240.761020489125,
        124.76413176875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPeHOZsE9d/IcztjqvO0uj3eQNBT71fEqz8H2+fSw
3I54hxeysdESbzH5q7bd/eMYFgfnc21vmdrpHecg8+7hLKV3eQ6stm+Dw1zi
HC4Upd3R+ZDnMMf4yQVHhziHwMAza35+zHOYWSZhsMImzmGhTOW90G95DtN3
+vTzWcY5fKrqflT3N88hqeGEN4sZgq/VVZGeoB/n8DT0WMiFA5j8v3O6cjvN
4xxeW8TOYj6FMG/Po/w5OhfyHIy1bvvqAu1bYl4p63g5z+ECc6aAj2Ocw7JT
997zXstzyL377VKWW5zDFyY1/7nX8xxu8pz+JRGA4NecfM+UHYfg715sOdFi
f5xD0M00SYkzwPBILjkyb2mcgxf/vJS6fXkOnAL+B3xmxjlEucw4nbkewZ+/
SawsfjGCX5++V2D5zDyHlb9KDsxbHOcgvPDFmx8T8xxkE9ecktwR53C7wciq
oyvPYcLxx1emnAG6V9ZDY2NbngNHyLPmlc8QfFk+50ll7PFw/jnfxGMntOMd
NHdWzhTvyXN4tPmj+R+veIdTOy4xXJiW59CzvFJJOiXegWVaSMithcD4eW73
fkttvENx0xcZJaB77axTPrN1xTt4WbIYe+9H8ANkZlfUnUDwC9K/3DW7BAy/
iYEf7zbHO6CnJwCaKhaD
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/YVJzX/u9TyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyveYVHV2prl5/McTN1NCxZUxztMd396mPcAgi/Q9mIt71YEf8nUtbsn
rclz+PP8afufoniHBa41HjrL8hz27jI62J0Y7zDnq9fVo/PzHOp7639JBcQ7
pO85NnH3nDyH/IVtp6QsEHzNKwWydyUR/O1arFt+c8Q7nDPKcmKel+ew9uw1
nak/4hy2xfJ+9VqQ53DNQfepxcs4h8Alpk/nLMpzSGM4WB9+K84hd37s9XdL
8xzit2iZqZyPc9ibxcXpvSrPIcpq8pcPx+McolxmnM5cn+ew08qq12JvnMNE
qxfrebflOcgmrjkluSPOQSyz/rPDPgR/znQx85JjCP7brxrWc8/mOSi0l+dv
BupXfVMh73glz+Fg24Vr2SfiHA4YLeSffA0Yns5zylnPIMJbj6tw9ubLCD4s
PgCVgsVC
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUh2fL1JWlubSaF0zRclbWJJUQf1Zg3mGVObH3NVGDbL6pm6EL
00jDGxpYNsnVB8W8F95iFHijmFhp+qFQx8yaloKrsCw1+n9y0IffhwfOgXOe
c9yTmTSVz+PxLLj4cNnEpd2GihI3MWhMHZmTJwkcBo+JBTwGQe+tuyWRBCP9
0vYwGwaHPuONuASCANLPP2DHIEoKT/O4RCBfsP80ImQwHfa2NWYRmBKni9P2
MFzofDV2MJ9Alma0Ubkw1Hp0/NpcTlCpGxVJ3RnqC6bz0x8Q5E42BPP2MyxE
/xA3aQl01xcfVYoZ5AGeyZ6fzTxoOhqSLKIbHHF2tccumsLgPeum4vrvyxvb
CnMofoYoRtT7GISKUI2uhqJvqkQ74MqgDf07G9NCcX68IKB9L8OdN43iFi3F
xMXuaqEjQ6qm6J38JYVmIqXrqj3DuLtXTfcYRXSO9EmYgCFHH/HQykA3/BQc
z/XKMFGsOqHVlc+waBET4bxCIdleVTXA+ersPaLTL1F8jTVkpe1gOP0tscFv
nmKLMkNS5MDQ3P5Wbz9DwfKv9aidGBr8A+v0Hyi+L52QSZwZAi1TlH6jFMoy
xbCa87W+rjojG6JYi8o0qH0ZijNz6081U9xUWXu+9md43HYlT1RF4XbunnEh
iGF4wvdLmZLi+SHPJkEIVz/0cWougaJUlC6oDWXYphJWBAWbmdguJ805mzk9
L76/dIZgzDn2dmIgg6NP+HxUG8HKWohc4sXw2yOuKqrQfM/4Ub/yPwqC90+N
VipufleXXVYvLpON/aIEfIvqZALLSOvUZzsZWrOb6iZlBF2Ly0mVWxmy+yp2
a2IJ/v/Hf9LcI5o=
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
       324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.002577319587628866], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
       137.844}, {333.668, 133.09}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
        "], {{322.62239645999995`, 
        139.61787444875}, {324.47745303749997`, 139.61787444875}, {
        323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
        139.61787444875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.005154639175257732], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 
       114.809}, {261.641, 109.93400000000001`}, {252.207, 106.23}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.005154639175257732], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
       102.85199999999999`}, {251.016, 109.52}}}]}, 
     {Thickness[0.005154639175257732], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1,
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4lVX3jQ21OQ7yFx8ZLiiIdoBxnf5kOO7KT/a
YdYU9a3PkjD5z16mHPK6GwXn3+4xs35yJsrhbMqaLx+S8x3Y90ZMUTwY5dD0
0sDsd2q+A5PzwaB3O6MczPK2lrNm5DukMJj0nN8U5RCUeTczPDvf4UT/0rMb
1kc57Jnjs9uiAMGPLLtVG16K4H/zz3Aoq8p3MHpb9TZua5RDfPP1ieH1+Q65
nNPK5gDtW6ci9/VZU75D1uNTF5n2INR/Cjuh9G4hwvyW+uiDPFOjHBi5T6fq
pSD4WnWKcpdCEPyllR9WZPvmO2hvE+eetArBf5h/tkH8GoIPC59MTs7mKfYI
vv9Ct2R+IL/iwMeePQXRDqaWLc5ddvkOwnc3r3MsQvDd11q88y5G8B/JHl+T
VRbt0Fx4epGkQ75D3eKOS+8rox2yj11R1nPOd2hICCnurI12UPCOTLVwzXfY
YnBz0+S6aAcbt8bwLo98hx1hS8J1W6Id9m/3+aUMdN/+XnarX33RDhqvd3uz
BuU7JPQmLNw0M9rhPtOy+Dth+Q6MD1uXsiyLdvAwE924NzrfwTYw9/TtzdEO
4soxQr5x+Q6l7nvX1++KdthoL2dyKT7fQUjRu2je/mgHiW0Hn0gmAt0fdX7r
ikPRDg06qVMTkxB8WPqoyO0IkTyA4POn1F9k2YPgo6c/GB8AErA0Qg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxw+NLT3IWqNJiZKQ1m4T6/K20e3qqonQ96umViy077kbyTy1
8zAkI6vsmHQ4mahwXOcht8tV85DMVTsq1VTIP42i2fX7y2398f7jvc/22fvz
+rzdLrBTl2x4PJ4Vp72crDkRTS6/ZZghPpkcm/hFsWBu9uCNMvxtyvPcN0dx
yKqsVmdgKE5w1oknKUYv7hRPPWOQv1Kbsl9TKN6OJgq6GVqX3/F79BROcbYv
lZ0MwVcPSlI0FK0xK6GlbQxviu6qfJspri058rtaGQy+CTsMCoqb3wSOax8w
5MRGyAozKYKO/G5Jr2cwp7oLNoRbvClgyDrYxeJPG9cUl88Q7FHw9pc2Mtj1
RFe49RM4yplc0sLlVfcq39cQnPdQT5sfMzxJEmm/3CDIFIWoXNXcvo81soJM
Ap5249Gupwy2DrpBfTKB3Mc0F9bHcABfd1nHEWjFZTW6AQYvccd9RRRZ5ZO7
u+y2SEiAMN1mL46fc2y3VBFEMN4e3ifkeM1Kh9P03NxVZjOp7GeIClBWSU8S
WJ9IccnrYaBtgR/qIwkqQ5IqJRqGpQVDnf4swZaxe4vGdoahmAZhQTxBuT/L
k3C8an1y50UyAvtUKZPUMThp8qvPlRDkC03egiqGxYxbhgIVwY8rxy+73mEI
LJkc89YRiCv6GsxlDNnVnp9GJgiyVGmhklKGP9MLflnLFh+8zX5Ku5Wuev4j
VY5TJIV/Q8WLh3cZCnmdZyKLKBwGlJ+NTQzrDrf7JKot/xSSkY5GHYXfphVh
KZf/+vrZwOlBunqfJsqu232cwibNNBPWyxA9H7t9gutThPHnfPpzhvLajDrn
7xT/9/Eft5A+ng==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYvNg7QlcL/IdlBIF7C1uRjvA+H3qT5OePYh2
UJcz1JT/nu8waWHNEskX0Q4SX/7kxTAVOPxLDzxx/H20g4z+76oYjgKHTD21
N6Xfox3Mpu+d9RDIN41buCb7G4LPWaViuvtIFJx/ltOW/8m2KIfMIP7iVs4C
h+Nqy05uWBvlsL1UOXsdV4FDnOxctzkroxy0uUtdLnEXOGhM8En7sSTK4ef3
3UsT+QocIhezsmYuinKw6W93rxYqcFC93HA0biGC3z7h8z/7WVEOLYk8imeB
/kHnw9Qrn/u/dceHfIcD752ePwaatyzTUF3+W75DdMLFpUzLohxKwyo61v3I
d9DeJs49aVWUQ2yjtPW3X/kOic4Zr03XRzkc+b7vte2ffId0tf8GmTsQ/MXT
noU5HEPw70z+NfHXrmg4X2z2o80Xj0U7lL+8G1X9O9/hxdovO3+di3a4c0ba
8tvPfAd5a9dZ8y5Hw+3vcPGT3Xw92qGXMZ991td8hzDDqXVOt6IdVH6ktrR+
RPCv7ZdT/fYewWe/fP1w2tt8h861voqbgfG7w3BiwvWXmPEN4wMAp2z53w==

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4pMLCv5EBhU4bLm2WvnW/SiHiVPfbvD3LnBo
n/D5n/2sKIfTORHz2yUx+d3b9i2+OT/KgaHna5W/QYGDwV1XESXGaId2308T
/K0LHKQv1J/dqB/t4L3uw+zzDgUOrFG7mhxjEPydqwq+HGtF8H+tVDpsPjva
Ye+GO4vU7AscLK9f7VyxJtph4dYtG64AzeP7XX+WZVe0wxqdU/NrLQocap/L
T/M5Hu1g9v5+j5pJgcPWu/lVH85GOyw1Yfj8WA/BtxE7wpGpheALP9/VdkWt
wOFpu6Zo4sloB+3lT3LUVAochBS9i+btj3bIvOltUqxY4GC/K+f87a3RDo0z
S6WOyhU4pB053Fy/JNph8xq9naYyBQ57L1jPTOiOdniy/3n4MlB47G369b43
2iFtnq9GsXSBw+XP01frrot28Lun7KQI1C/qLiZucTTaoYxX98hWoPlvLu+P
m3Il2oFt881vE4Hu0d1nd2zey2iH6zFvfuzSKXBIL4zyvvM52sHfKd/V1QTB
TzjW6PHOCsEX57ikNQkYfsdvMbxQfh3t0KDGJ8rrWuDQudZXcfPNaAfmGTe3
L/MscNi4fcnVsBPRDqv/rr9wBRi/nI0vui9uQvATehMWbpqJ4D9I+M19sSja
gfGDQ12xW4HD0cPsOy54RDtU6blkFAPjw1GW++FuqWiHy9/b5d6pFjiw742Y
ongwyqFB8PbaZS4IfowR8/wKdwT/lYvX/3agexbelNq27FCUQzZfbcY7rwIH
rsfKlruPRTnc38G4ssKnwIF3wfubIaeiHKpefTNM8QPGT3ObfMflKAfrxTHM
GwMKHJoOf2rJfBTlgJ5+AXWQVZY=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxnUFhiyzJGtZ5lylmKmYRUXqkximouCd3pdE52XaUt+ZVmMu
L2UqrpUJQx3MgtzIQAwvmRcSTY0itFZg6tJYRpuZmkSFUP0/OejD8+GBczjn
+Z0jFBfEZ22ws7Oz5+TDicdJO6dZLBEzCNL6C7WhBDEDFT8S0hmuH6jTREYQ
tPY7P/6exaD2Xy1zTSaYdXyenpHLoBlPkpjFBIq45bguKYO0+bCTPp/gpGOy
iJfPMOn59s2inGBFPZXJZwzb6/t+PasiqB0cX/wpY9i7bCk92EBQHtn7J7aY
IXvgr29uN4F307l218sMX/QBGZ/mbD4kLRSeO+i6Hxl26Jk4Q9G5NFmg4vpd
TB1tpwopniqEo9pChlvmmOaaeop9Ub7B7dz8I48c550MFGzEsNbC7ccP6fSV
dlO08cN8zl5gmNt8x3hoiMJlVHDC4TxDbF1gQ/ErCqvGuacwm2ElJuXu2DRd
57PWWunl95ViSOJw9APHTyIj0TOrFCaxv3cAV+/nFfJCt0Dx5FqKgMfxGk7L
1S+bKSI0OvlWjtd+95nZ1zMUa7tEfW55DB73w3W6dxQDxmpVTgFDRxG7tPyS
ovSecMSNy3MlrzpRMEgRxvOY0HL57T9WtmzUU1Q2Lsi6FAyiPXLFdC1Fwo1A
Y/hVhtPhx63RMgrPi/Kgt2VcfdCSyZBMUWPZPe9WwVBl9VD/Pmbz70vsxYad
Nv/ZkjkUZSLwtapFSiVDXWOShf+AAKRKk1PEUFQvruMrbfc0hgbf7GUE7Z1T
GSpu/0aVcJMym6znG5Nv4SWmEkSUS7c95Ph6mbt02iQC93jxbVcJwzf/JkFq
NMH///gPECMu+g==
       "]]}},
    AspectRatio->Automatic,
    ImageSize->{388., 165.},
    PlotRange->{{0., 388.}, {0., 165.}}]}],
  SequenceForm[
   $CellContext`Dia["A", "A", 2, 6], ": ", 
   Graphics[{
     Thickness[0.002577319587628866], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 165.}, {
        388.117, 165.}, {388.117, 0.33199999999999363`}, {0., 
        0.33199999999999363`}}}]}, 
      FaceForm[
       RGBColor[1., 1., 1., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
        24.836000000000002`}, {45.02, 13.508}, {35.836, 4.323999999999999}, {
        24.508, 4.323999999999999}, {13.176, 4.323999999999999}, {
        3.9919999999999995`, 13.508}, {3.9919999999999995`, 
        24.836000000000002`}, {3.9919999999999995`, 36.164}, {13.176, 
        45.348}, {24.508, 45.348}, {35.836, 45.348}, {45.02, 36.164}, {45.02, 
        24.836000000000002`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        18.552508993125002`, 24.71990644875}, {21.99788154, 24.71990644875}, {
        21.99788154, 23.851453813124998`}, {18.552508993125002`, 
        23.851453813124998`}, {18.552508993125002`, 24.71990644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2MOGbxWQ3zc5BfcV8+2+51g73
H5r4fOtD8Jkas6seaZvB+d+7hFlMrpk6NFQwsdk1Wzt8u7NtbescU4cbZ6e8
j1ln7eDx4J3Bt3pTBwNl9ZvVN60diuQ/PziUZuowwfUJa5GZjUNu9dcLhyJM
HY6sPbO06JCNw4euGPfrIQj+i72GLAzKpg4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pcMcnpDntu2mDvfPXe8/qGDl4M0pk3J2samD
4G225lRLK4el7bcbDn9C8LcsS9DyzDGD83l++mUGHLGB87MWWO+UNbd14Nt0
079P1MrhXez/1gc5tg4cCfUv75+1hPND9u+MCViM4F9g/Nbfm2vpIOfI6LY2
0dahSt2kebqOpcMbk0tBnJ62Dotep4dZa1o65LtYnpR1tXXw3c+04LOipcM0
jtw5Bx1tHRTCL+7xF7d0kJa4InTN1tbhjFYOG4eApYPTHfZnlVa2Dsfb8r6x
M1nC3fcts2DblW8WDmIl15iu6dvCw29Ws23lK21bB/fcFZaut4Dhy71U3kjV
1kGKtTxs4XkLhxxpnmluigj+nDVZaw762zqgpxcA5Ln5og==
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{111.074,
         44.156}, {111.074, 34.800999999999995`}, {103.488, 27.215}, {94.133, 
        27.215}, {84.777, 27.215}, {77.191, 34.800999999999995`}, {77.191, 
        44.156}, {77.191, 53.512}, {84.777, 61.098000000000006`}, {94.133, 
        61.098000000000006`}, {103.488, 61.098000000000006`}, {111.074, 
        53.512}, {111.074, 44.156}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4vCZijb6veEOhp7Sf+W+eDj0dCoI1EwOd2Db
/EKx+gOCP4OJxfLjPhc4fzL7jb+SU1wcFtvuZDw3I9xh0oaVl5zKXRx+XpLd
M3VxuIP1JleR3xkuDv4ZTWWx68IdLlx0z0mMcXF4vmEj4+yj4Q5n/3ukJIa6
OHw5tVpz9otwh/72mvnZwQg+t+Lzv/VWLg7/A66uNP4UhsGHqT80w0xkqgDC
vIotZ2p9VRH27Uqf7nfYMNwh1aPi/bwcFweryXpP9BzCHfa43Vn7rMrFwT3s
14Nwt3CHV6w2exIXIfiFU/9NULmP4M/dV2qgwe0B5/sI5dzoc/FwYOPRF0my
DXfg+3jWriDew6G1fEZVmTaCH8GfPv2SAoL/Xd7sSaJwuMOyR+fmXYv0cEhc
yZqowhzu0BtjvrTF18Mhe9alUF+mcAe/J1kP+rw9HML8LTOqGcIdko6xnHrg
6eHg/TUn/9LfMAcVPwvW1+4eDmarLjcy/AlzsDC49M7GzcPBxPFKbcOPMLj7
GHZdWbv5a5iDUo3l31cOHvDwe8Kca/HVzsPh6q5F5/rfAcP3xALumdYeDicT
rl199jrM4az/FbfFlgh+6gzmSw8CPBzQ0wsAf38Aqg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{44.273, 30.32}, {51.539, 32.336}, {
        59.891, 34.656}, {67.65599999999999, 36.809}}}, CurveClosed -> {0}]}, 
      
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.812, 40.207}, {77.383, 
        39.508}, {68.684, 33.461}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQrRu85V3aOT8HFY4/bWnqTg4wvoTTud//RZwcXv8o
1HE76YvBh6k/eXHj3quPfR0+LijzjtFwcsifn8cc/d3XIdKx4VSBlpPDyqCu
jhmMfg7fpPh6+/WdHB6zLuO9xu3nMPnLbP91Jk4ODfeNL3wR8HP4z2cr8M0W
wb/y2VdO3gvBX93wPbU60smhOnVO30FOP4e2dov3XAVODjyVf45W/vF1OLdC
yvJRv5NDuLDw295Lvg7F5xeu1Pro5HD3+ua1+sd94PyeGTZCqjN8HD4vvLk+
qNLJIWS7/NTnE30cZEQNMr5lOjnI180OvNvn47BWY8L8dTEI/s3cp/FBgQh+
Qq+YyBJTJ4cTsuHzk5b5wMPD50hwWfkVTD4s/PRTjPv3cmLyYeqLueumJyr5
wMPTJ0vt+V5TH4e43eI8SwydHDqO3lqq5+zjMOfFqUsizk4O3zdW5ZUF+Dis
WPcjtjrUyWFBoNme3+k+Dr/e5v9sbXFy2Mo9+dSJDh+HI7zbHtidB4aX/Hmz
A7G+DgXJk0RVjrk4+Mo1shoWI/iqbLsdbIv8HI5ueb21utHJIdk4j31ds5+D
a0ebwqwoJ4dc9bldIpP8HJgeWkt8c3RyWHZrB3/QHD+HJNP1vtctnBwe9F6Z
0r/Mz0GzafKJmXpODi2bfyx4uM0P7h/09AYAMfQYKg==
         "], {{57.68489645999999,
          38.21162444875}, {59.53995303749999, 38.21162444875}, {
         58.612424748749994`, 40.420441815625}, {57.68489645999999, 
         38.21162444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn8s1HEYx50rXCXWrXK3NrGmjcpKcdxV7+/dN7Idn6+iWshmzLDD+kGh
OCkmdwzVleuHTEnlR36VG6elCbP82O02pOs62rRFhTZHur9o/fH64/XH8zx7
nvfjEp18LJZtZWXFsuBuwdpCWo2PWcNloGerywTvabzwyR+NcmLASvspHXtF
Q+jH6ExrGbjM83J45TR6rSdD6RkCx5bQ5iw5jR/9lcNNHwnittyJW4inMWGb
ejS4j6DQ4dR4wnEalDFEtNhGUOvtFDQqoJEQVj374BmBKlNzaKMTDa19qOxr
McF6Y5GpZFSCq/m+hqc5BLYOey6qr696Z5mcbc1b9cb+GW5Vsxg7xs6YzEqC
reUqt7fRYvRn8PfJHxM4K2OOeG0XYx3rgLajiUC2cOl8wAKFjJuyN77vLP0M
bhPKUQp54eXSh3pLPZV4m9NFodSlR28zRZBUUReY+5yC7yAzaGIzCH8dImkt
olbuw03ieHCTKUhGXmoaNjEQfY760hJFQVahc5xew8Bgkzttl0JhWZigCv5F
0Fq62yc2i4Lyyd5bw0bL/LyItj4FhSm5fYF8iGBpQ1oAR01hXPPpD7+ToHLE
S6GsozAQxPOT1xBI06dHuN0UGgPcjNlXCISls4KDZgr3FT3DjZEE8/yNiiJP
MTx2lvQIAgmyhI+q9DFitHae1rbvJ7CL8O5wvivGZfvDftnuBObvQ5GZulW/
Eb6k/b1ZsuJn5d7L9YUSRNvV+acSgm2uYQ275iToyvtWy1cRuN4jJ08E/ZOn
7lr8YCwNuomhFzsseYraz0nT6ZX9MgfmLnQX0CgmvR9sJgk0S9UigZpGoomT
EsZi4Blj8G+sp/H/P/4FhLQqxQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTP1wYkpXwMcpldH3BI/7uzgZ7d0pp5goEPVOf21
t144O7wWN47xFcPkh+Tu/tnc4gjnC+dxagvnOzoE7bC5nSgR6MBVdWv5mgRH
h90HXePKZAIdLNJPLGyOcHTYVyf4n18h0MH4rUFCQKCjQ6xodtIJjUAHveKZ
crJejg4Ml/qzpMwDHY4wTJzO4YLgh4p8PHfAzNHhaTur/969ARj8n5ait4Xc
HR0++BrfUr4QADdv0sKIe6V3AhzSQrbNjgpwdEj2zn4w71GAw3z2Swozohwd
0grNWi1eBDjc3PV26dUURwemR0ecw18HOGySnPbVsALB/zHpPuu1KQh+mXux
UmGYk8OBPrcbPlcCHEKOv+iwVXZyWPdrS57kzgAHQYV5DTO5nBzOpay0+TAL
wY9wXDbxdhOCL7H687Gs/ACHoK8vG2zlnRyc5Lzq+RICHCwPRUw19nByuHj3
rqRuYICDQv/xlZqFTg5p4pzf6jwDHPhXnGEPXorgW8q0qbx9huDPmX2oZ6K+
s0OuX84N75AAhyPpj/N/5Do7rPOVW74nM8BBwv+zi9kCZwdlDiW/i/VA/edr
72VednZgfJh4PwHo3pqyE8943zg7rPdr5N68C8HfLbJ+muRZBP/3qsTErgcB
DreUFj/afd/ZAT09AQAd/AU/
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfToiHP46wAHC2nlA9+mOjnA+AenPkn/kekM57db
T+atW+vsEHfx8rzs2wEOmX1ZDxzOOzt4ZTvrWuxB8G1eeDJaLEPwU9ivyDhN
DXD4cf40/8+9zg4x6YVmpR0BDtWlqU3is50dgo/zBayoDnD4J/X/i2mFs8PL
ELaTk0sDHO478U419UDwA1c8tNrFjeDnh3JlfH/p5LDD0VdLuSLAIXL22kit
k04O7dMn92+qCXBY0xh1qnCVk8NelSf5YY0BDmcYmv6v63Fy+CplEvKrPcBh
b0ZojkeZk8OUjb3bN00IcNhSovbyYbqTw7mUlTYfZgU4FJeWSBUGOTnYBnqy
WqwIcLA8FDHV2MPJwWNdec+8HQh+EPcyYdaTCP7X46ekw68HODjwvb+XFuzk
kLIl68m8JwEOjbwL117PcHKY5bj7iNPLAIe2dov3XAWI8I4VeWSWXo/gw+ID
AG8yuK4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0s1AEcxz1sTN2Up6lrjNpkNJFNuBvf/93fQ+bhflSXCOexZpykLmyI
Zd2w2nGLMKUxbdc0j3m4xUJqqBUqtCVDtNLkcRfyym29+Lz4bL833+/3Zxsr
DU3Q19HR0d3FYRe9XWRLblOjIPCno2faohkwsXMaZz7BLNXI0UzKoDnaWk8V
TLDLG95RFTOQl2tUqZGE0z2KId96BqtNVSltCYSv0cHcITUDjdK1eSGV0JV4
93HEKIPhBp8OUxnB1S9qyeg3A3cp90tPDuGMbtfW+EEBjEv7bKyKCeOVc+LQ
IAFUYzTPKyVMpPr3+ddqvXA6IafPWLjnZQ1rKbbpQkw6es+alhCcJ4Mj9PuF
MIyUeIluEey/5/NLDVlUKYu5tZmEjIK/r6qdWLzOzzLPvEo4Wh0iPh/Eoq9m
ZsTnMuENf3/dZDwL8W2B8XYUoV4Y6JSczaJl0MpAJSL86FZ6HShn9/rRlS0H
Tj1nYcLZ3AoXED7qV5W5D7LI2ygfeBRCSJTGKdTtLH5lexQtXCTc+9YRIGlg
cXzgHOd4HCHsUo362AMWm5+STEXJhIAraZ7qIhY7XdviggxC2r7BxZibLAz+
SDxFuQSNZr2+KYaF+Y2IRJGSwJlZ9pefYGH9Qf6zrY5AEZ9X3DaEuFBYl77S
SFA+CX9v+VIIhUfvukvn7r28v+NtiRAnzUI6RS8Ih9fsuddCtd7NXewdMdH6
2MqzfItKAdQWli1jKoLjWcW7ilMCcMY3cgvuEJb9VDYVE9o9Gx9KDq32Mhjy
9m01vU7geToYZz1l9vLdNzfQs69mYJcul5ZICOHzobz2IgYFrfFJvDDCbN4R
F76Mwf//+A+oPypZ
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{384.125,
         140.49200000000002`}, {384.125, 129.164}, {374.941, 119.98}, {
        363.613, 119.98}, {352.28499999999997`, 119.98}, {343.10200000000003`,
         129.164}, {343.10200000000003`, 140.49200000000002`}, {
        343.10200000000003`, 151.824}, {352.28499999999997`, 161.008}, {
        363.613, 161.008}, {374.941, 161.008}, {384.125, 151.824}, {384.125, 
        140.49200000000002`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        357.65797799312503`, 140.37615644875}, {361.10335054, 
        140.37615644875}, {361.10335054, 139.507703813125}, {
        357.65797799312503`, 139.507703813125}, {357.65797799312503`, 
        140.37615644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0llIlFEUB/DJyTGXbEzMhRi3XMikRSItlf9ojplEm5pYWveiQ4umKN5P
SyJEncx0CuvBmBaibDNNM1KhcQNFKYcxLUtR0lKxGHTMHFyq76kP6uH/8IPL
4Zx7jjtNP5QiFolEK/j48zHjsxAqVpnWcEj7cb5KEUfwueFMaaWYw+sdRaIT
zgTGgMjGS1XsP8cnF6YqZAQHarKOKPsYWh5Ii1KyCD5kZKRVTjAkLQZ7eWoI
burP5ihmGPI0p9rc2gWXjXUpsycES1Tl1oELBKrJVZ1JBv59a2LVOUsKsi4k
WT3JkLhUlujnQDGTc9/61SjD47vent1uFCIfm1rZIIMu01hY4U3RsO+h35Re
cHNqtpN9t+C+yPCdunYG7bdmqcaD4uew9JqsmcHkW9Zl50LR88TOmNzEsE15
LF9lRzEtH9lT/5LhYJvf2zgzCp0mlwbVMmyUdvUe/U5QM2+fp+X/o2l0MaLC
QNCdbj/+pYYh39Duq7OieDQQob5Rz3A9tnS7SUZRvsylfeTrz+3WTp7cRGE7
N6RN4PspmlfN6kMpki/Lcz16GDrkh1s6Iym0UwNZMYOCYxJCNi+NC3bd22/8
NM1QssGQ7g0KJz8LSZ2JwWHKUze2hZ9HZz6kFXEIUMw6v3CnSE0KLFCv5OBj
c7V42FawKMFfPWYif702ryJq+D2BslUS7LXIUPjsjqusjmDkt6X3V36/ZMRG
8qaYoKMk3Dy4jeGpg4siZRdBdJRF7695wVvl7wIMS4LtbIKci/l+noddbGsM
Jki6F7h/yYyDIsy5LhoE9Z36kGpzDqTJaX1mOMEV8e3TVpYcHI87Gi9EE0zE
3uqXruaw3FHtWhBP8O/9/gGp2EY8
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        173.45700000000002`, 80.99600000000001}, {173.45700000000002`, 
        71.641}, {165.875, 64.05499999999999}, {156.52, 64.05499999999999}, {
        147.16, 64.05499999999999}, {139.578, 71.641}, {139.578, 
        80.99600000000001}, {139.578, 90.35199999999999}, {147.16, 97.938}, {
        156.52, 97.938}, {165.875, 97.938}, {173.45700000000002`, 
        90.35199999999999}, {173.45700000000002`, 80.99600000000001}}}, 
        CurveClosed -> {0}], 
       FilledCurve[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
        
        "], CompressedData["
1:eJxd1Gs0lWkUB3C3lEsXXYzK1JqGRsllkMoq/Rk0usr7vul0Izusakim6Zw6
6mihqNQcjS6Ma45rOaWRMiGFQosaTcalGswYqcZoucWZzrxf9K41H/aH35fn
2c9/7/V85r/PO0BbQ0NDk6/tfGnxZZXxdPQLjiCKdwhUHmYx5uMjAZ5MNIvJ
HuOub95FGK2z7ZohZ/FPhKO/XijBztymrCORhWVKUmGemBDu90CmeZlFu2ti
TLGMkBKyaI8qj4Wh66Og1uOEnqmVNkk3WZTe3lVxLo6wRmugw6CSRUp/Qpjb
JYKhxMc9uJXFyvWjW2SphJZr0ZlDw4KfyLpemM/iPjo3t92u2ZHDnNyEAzpJ
BJd3U8qM13Pwb7Kdd1lOuHc820fLj8O8uADuagzBbbZz39v9HKprE+fIwwlR
AXplnYc5+BZo99YFC+5NS6197ivY4rsQWSNDIJ/Mxu4wDr+81Ksy8CS8MW2x
yyIO4asV+m7OhIMdk+OJ5eDel2UndiCUbz9sZrmcw0BMTr+2JeHBmZk9Kr5/
N6MpSWvMCO/M1lalzeHv2+oqUS4g5E1tdxQ5cTgV4/JHgjXBz1qcZrSBg23W
RHeFHaF4UesO0XYOv95vVvzkSDAxNZxau4fDG3HYBd3lhEMGK6qcJBx+7NXv
K3MlVCmfnmyO5JDckB7T4004163VQ+kcUk2Wmp0PJEybnihrUHJw8XbIVIUL
HstvzKLqkUpFBqH06OKq8Qq+nym+x6yUBHNHXafaOA7GksECuzuESJVeCYn5
fHvPTHh9jxB3PieySCT4ZLDU68ViwaoZM0tqPuVwRXw2pbKc4PV6g7vTBA6j
6kE3w9sE5SymhhlgUT15OLS8kLBUHGsm72ChY2SVoZdDSL8gSm6sZzFtQ410
60XC9NxB/ZUlLKKrFmXW5PL95sWvHcpn8fuJoZY/iwgWDv41t5NYmCq2WZ4o
JWSl1tnUx7I48kPci6FawnCG9g3nYH7/DecvvfaEUPHumTLRQ7DU+GX+OmPB
daJX6sBmBk0HK450VxOCXE7NnJvD4G6HvH/PdYKtfIex9BgDdWe1eVEWoUD1
IPzsPubjvvt8oLJVOxkkT1e3mMQSNHertSM2MbCt07RRSwj5jYmet9YwWNa2
5LQqiJAwV2tzoAcD+wYnSfgmwa4TmzbWewjeez8swcOJUFQZ5Ny+msHCQ9kP
vb4kDE6yN2hiGLyybhvdYkFYIvrQ9Ggbg5K9X2X6f07IWKaSBe4W3OtxzjNa
Iti9bUh7XSSDhpttcgdzwv7WBZ2hJ4Xzrt0ZyO86y0AnuzXgGL/vXVf6Zfbn
GcywntR61IbQp1shabvI5yPBrQ4HwV2rDWcXOgl2vKEvMnfj51NnUVz6PYOY
qAlJJhuFPN/LvynX9RXybGh9LD2zlxBSqFJeCmSQNlz/c8VBwaZ+6t82nxA8
/KzGaHECoTl+xMf+WwZu0p1NjWkEhf+CGyvi+H4v+n4y/grh63HmS8yyGTzW
qAro5udpGfsmMqJa8Lq/ZZe8Xwu2CVvVVaDPYmHnsE7zVUK3b5tP0HwWB5xH
rB8pCBE5Bp2ZK1gUSB/+5ZLM52+V7vWcY/E2/F+T0/H8f1Wo87IvkIVmtzrE
Lorw3kC7uCyUxd1kh4zlUv58leYpAzH78b3//6/H/B/tn6g3
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{105.07, 57.258}, {112.223, 
        62.668000000000006`}, {121.816, 68.637}, {130.797, 73.363}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{129.285, 76.52}, {139.805, 
        77.762}, {132.35500000000002`, 70.23}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4vMSz1gO/o10kLn4yHDFg0AHGN/lQ47vpvOB
DutmRGf3nsLkP3uZcsjLFsG/3WNm/UQn0EHMMvXVwjORDux7I6YoKgY61Dvl
5W67EOnA5Hww6J1koMML7/IPp65EOqQwmPScFwp0kHc6fiXvdqTDif6lZzfw
Bzp8WrG03PApgq8Tc/BP3nsEP43/buOan5EORm+r3saJBjpYlu1WyWeOcsjl
nFY2B2jf9R0er3u5ohyyHp+6yCSDUP8p7ITSO0aE+S310Qd5vgY41LQuOiNz
FsE/n+1vm7IOwT+a9DZo+vxIB+1t4tyTuALh/If5ZxvEzRB8WPj4Nsmxv2xG
8CU3zTx+rynSoeLAx549FwIdnj4U6bjSGOkgfHfzOsdLCL77Wot33pcR/Eey
x9dkXQt0aAxa7Pa5JdKhbnHHpfc3Ax2C/mz1kOmOdGhICCnuvBvosJt1/2mD
/kiHLQY3N02+B/Tfb74NV6ZGOuwIWxKu+yTQ4ce9pV/Zge7b38tu9etdoMNp
15YZp1ZEOiT0Jizc9DPQwaI04kDFpkgHxoetS1nYghy475glW++JdLANzD19
WzjIYcXWI6pRByMdSt33rq+XCnK4+84jM+VIpIOQonfRPPkghzW3+099PgZ0
f9T5rSuUghyqTlzTbj6J4MPSR0VuR4ikAoLPn1J/kUUGwUdPfzA+AMXUQmE=

        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmdIlAEYxy8LL1CjZXhkltvcmEZeKX8hMUf6vq85egxzlJXmzoFY58rR
IeGpoZjouYlI0dTEFSZeWCpliPNsmISWUGSZp9l98qAPvw8/Hnh4xl8/LJa7
upPH4+1QYq5ETYntR+1I3RrCtXjynPXlEBEb4fG8gaB4dNfU2ovDz3jrs64l
BHGkYMDLiYOeI1uelUvIHu6YEdlyaNVrmRTeJjSvT9r3GnF4fFpQzL9FcEk5
FZck4DBtxi+URxHe3itrtNLkEBNmd8P2CkFmFXlMpmBR7pxv/M6fkBFyIbFg
jsW6Yj243YewlWzotKdN5TOOI2ou6Sr3m9gllniweFWvFSr3I/B7A0v09VlU
Jy3zpaHKeTv6aqe2GDg/Sx3tv05ovene/ekrg2S1Up/NOGW/+arEvDkG6Z8t
Sm3TCOp7B14PvmGQ9XJgOjybYIcFY7UhBj9228BVQjju1V5T0cls3yfHpOiB
eyODjX1F5vulBEFIT0JFFQOTqTaRTzFhOWE0dVBZ7/I70M3PJwQ41j5MaGaQ
ofHbcVhECGoTyus7GDxZWzghTSH8WZXVDfYyaNL2XomOIYxcanDLkzGQypc0
pOEEqWXOivs4g+Kg7/PV5wk6XbmVwd8Y5P8dCBQ6EX6lF8vy+Cy8PRvHN+wI
wsK5cQsDFgfLxN79ZgRRpen7sTMsUvs2xdWGhLXFVZs7pHKXIxofutNUbt/S
mKHTwWKp20Fy+CShgNd50X+JRYXCdyiaCJrOTy2jDqn+6UZj7U0GHGaK1Ivk
0YRMrWXhoiW3vV9XAL/H0IFD5uUXE+GZhMCVkKOzyjwZ6X6Rt98nSKTpdYJz
HP7P4z+gsjI1
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4leiyYpXr0Q5KCUK2FtYBjnA+H3qT5OeOQQ5
nFqdF/zvU5TDpIU1SyQ9ghzu2DPsNeSLdviXHnjiuH+Qw2vtn28M1aIdMvXU
3pSGBzkEn2HKcdOIdjCNW7gmOwzB56xSMd2tEgjnn+W05X8iFuigtNPz7FWt
aIfjastObuANdIhwm7W2Uj/aIU52rtsczkAHjTkPhDhNoh00Jvik/WAJdEj0
/zPdzS7aIXIxK2smU6BDzhot+bV+0Q6qlxuOxjEi+O0TPv+z/xXg0Gqk6hx1
LQqDD1N/iJsn1/BZlMOB907PHwPNO+mU7//vQ5RDdMLFpUxsgQ5pMn8FZb9F
OWhvE+eexBXoYFbkXL7mV5RDonPGa1P+QAeW+K4b1n+jHNLV/htkSiD4i6c9
C3NQQ/DvTP418ZdUEJwvNvvR5otqQQ5ZTie2bfsd5fBi7Zedv/SCHEw4XYrX
/IhykLd2nTXPOAhuf4eLn+xm8yCHqUWv+L+8j3IIM5xa52QV5HA4/gbn6ecI
vvp7T+81TxD8LtE9Hb33oxw61/oqbgbG75tLeofybmDGN4wPAGTi3Ew=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4n8dwsqVH6Id0gujvO8EBzkwut0/LPQl2sF4
4VXuS0EI/uU3l0PEFQLh/BkXdpy+KRzoYFafzC77Pdohvm2O1xzuQAc2zTJO
t7/RDt9qJh9vZw90uH6pgzufOcbhy/7jau+YAx3c9mtc2SYQ4/Ap7ITSO8ZA
h+CbSn+2qcQ4qF5uOBqHxG+f8Pmf/a8Ahx8/noq+nB6NwYepv/CuL9F1ZTTc
PO5vZc0yW6Ph9q20YPGy3hPtoOUrwT6JI9DhUZPC6Yoj0Q6TwxS7lvEEOtRx
PPrw93i0A+Otg37vxBH8m+ezZnlpIvj5KWpZPoJBcH7lwZCPmxSDHB7qhejd
PxTt8LRdUzRRM8hhebXFyoU7EHxbTgOl3k0I/kWn6H/3VkU7PDGOrTiuHuSQ
qrHLdvrCaAePdbODnFSCHP7dromWAfKrtUK+blIOcjjF/UNaaEG0g8g9MWEL
IN/gvemvnnnRDu5R57euUApy+CO3cVfT3GiHB7yTLusC+b+2btzWNBvhvp+J
TyVfzox2cPt4fuMKhSB4+FXkdoRIAvkTIu5MuzI12mH1Fd4JyvJBDt+spUr9
p0Q73As4ZjRFDsEXdRcTt1AFug8tvQAALfsFRw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx50SNQ9tRZ2tPFRuebizZNXy8CZtotPv94vZ6st0iUSF5KEn
VyMy4ejsUHexwlyr2XlKqKFcJE8lF7eyq3SauEwTtfKX2/rj9cfrv8/7/f7Y
Cc4yJ1YYGBiwlnBcwnCJSV10oyKPgB3Rklgmo1AXueGdRQ5BhoOo+EAVBQfB
IXXObYI83qzQqoHC71LnbH4NQXFfSLSmncLJ+l5/sYIgVuZmXvmawhlJZJ6y
hWDE/s3glIoC5Mm3dJ0ElkVP5jsnKMgTAptkrwhsZrTpTvMUrornFhdVBFGt
f51jrGjYjFxrtx4n+FrpevwT9O4V4Q37FL0/7zBu6q+mEcSNf6Z7T7BOrXjo
M0jjQnghm9dHkK/hy27M0rCQtM4Juwjca9d8Njdm4JEpnw59SmDqVecca8Vg
V8X6mq0NBB/NCodc7Bl0Z53Tjj0gCBLtkJx3YcDpCRrPkRLo+KF3u/Yyy/0s
1mRyuAcZZJg7qnYXEEQnHAkcO8xgduFlufAOAZfj1S0NZHDsyqkoZTVBR0RM
5cw+BqXK6xNGtQTbNo99GPBgEDcqmeI+JrC95yeVujNIbOO5CdoJFEnxyTNO
DNLmCi15vQSpp7OD2bYMslJzfXgaAtZ45v2VqxiI3jYrxbMEWzalXRz9RqMn
e5g/9Idgv9+eycABGkYePwbXmoSBtXNaXdVAo8JSKOaZhSFr0jbvl0Tvqkss
QVWq3r9oI9sDPGm4bvTPr1sgEJWEaE1X00gf2X5UMEyQVCQQmar1ew55e95s
7qfg7ZtSoFu6vyTXzuTyC2o5X1eahWFwG4WSpOaAuEcEHE29tKyews9Gsa91
OcF3Xik7XE7h/3/8Bz1JN/w=
        "]], 
       JoinedCurve[{{{1, 4, 3}}}, {{{145.58200000000002`, 67.895}, {
        138.42600000000002`, 62.483999999999995`}, {128.83200000000002`, 
        56.516}, {119.85499999999999`, 51.789}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.367, 48.633}, {
        110.84400000000001`, 47.38699999999999}, {118.293, 
        54.922000000000004`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4pVX3jQy3EhwMF10NDmg1ccBxm97cHNWSrKP
w4wp6lvT9mHyT1w+2TLVzhvO3yyZW3ZC1tvhTMqaLwX7Exy4qjZqOLN5OzS+
NDCrPpjgwNjWtPTOdy8H07yt5a2HExyOMGRIzH/p5RCYeTfz+rEEh15579mJ
j70cds/x2b3jNIIfUXar9voFBP+rf4bDt6sJDom3vt7a+87LIa75+sTrtxIc
bgjpvLVg93ZYqyL3Ne1egsOFY1MXs/5BqH+0doLrneMI81n+b2uSXOflwMB9
OnXdfgRfs05RLmgDgr+k8sOK1ysSHIJz9MVUbiL4++/PYtQ38IbzYeGTwcnZ
LDIbwfdb6JbcPyvB4V3DY8nKVB8HE8sWZy4gX3lXemxzBoLfFVV4Z3oWgn/I
ui/yaoGPQ1Ph6UUzgeb9dBNcer/cxyHr2BXldfMSHP4dWPFMqN7HQd47MnXH
ggSHtMRNqeqNPg7Wbo3hXEsSHHLXeqyP6vFx2Lfd59dioPuqpflLviz0cVB/
vdu7dW2Cwx6pg06p230c7jEti4/ZlODw/yC3N+cFHwd3M9GNttsTHCoW3Zq2
/bWPg5hyjNDZnQkOz/qq4v//8HHYYC9nErQ7wUHBadoTG2ZfB/FtB5/M3JPg
0L1lXnYgp69DvU7q1Id7EXxY+nh3S2ClEQuCL3Pi3yLOP4j0hJ7+YHwAJ5o5
vg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+8c5mHucp6WsenoSYgYYtx7HvP9/X4kpV1s/b4tCunaGd2M
zjxs6clEhupkbVQzzdzK40hb1GrLSGvYmg1F7GpiFNfvL7b+eP/x2j7vzz4P
7z3n1CcyJCKRSCzIW5CZIFV3eZCfN8W7GUNdVw6HFVObV4kPxcop26T0dA7h
4urmKE8Kx09HyhsiOXw8r2CpG4XkXu5LkxeHxs+jOf0uFGd+d2QV2nFwybR8
6+lAoVu+8nVhlUV7+masTEbR7BSQlDbFQrsuDwq1pbiVNo47vSxuz0fIb5hT
bA0+mZPrWETGrbVviCg2luIK3bx3uDOv0aK0j9nmljZr570qBvvvi/xlgt+m
sONAtCUD+zJ1mdGaQp5bHN/5moD3ejGns6Pgv9wtGH5IUJQQ06q3F/oNKOel
OgJTj4yEOgt+j/KGygsEpT6TP0ZdKWjJCGN+nKCHrW6KUlAk1mfHhgSS7ftY
cgrfGjmBMnnI8elBisOD2tlgCcG4IWVgWKgfm33w87oDgXueZNrTneKZJu7o
rIJAnJjvZrGbwpCZ38cEENTHXGowOlIYF6sSKpUETmOPVlN3UdR1s1XSFILq
EHWF0YZCqbKarskmsCnQqI0mHn4au/B+PUFF/OSh/jUe39f3VcnGCL7lcln6
Xzw0rr2tp60YMLUDLbolHn/CkgabIhgUt2pjjQs8lj8snv2r3eFrYc5DV7t3
OINPEgf4swhuqR3xXeEhE1/ubKtnIX3zeCbVUshD0UXVhHHnnzcN+pxkaw5+
9pvxMmH+LdeJ/Pfu3PZ+6udSbbwfBzPt5MKosH/71KvILiWHlIml5Q0PCkX0
+rHAkxz+z+M/U8AdhQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYrNg7QldzokOjocU6grMfB1gfAn/U0fPuPo6
qMkZas4PSnRQcv7pYRzi66D/4uddi4REhx/nF03oT/Z1MI/79tUiJ9HhfIzP
jddFvg7ZetWmzrmJDul7nCKvFyD4/F88ssp4veH8acJVcic+ejlcWiL3rCsv
0aHb12dy4n0vh9zXbtfuFCQ67LCy6rW47uUQKvaqQ6U40cFHYeaZD2e9HD69
L/d2rkh0WO/GzXXphJdDuRx/f1lDooP7MsbuvccQfG7F53/rd3g5NCfyKPq6
YPJh6pXO/d9q4ZPoUHu/9dzxk14OSzMN1ecHJjpsObDIm/WCl0NJWEWHXkii
Q3COvpjKTS+HmEZp67KwRIcDbReuZT/ycjj8fd/rveGJDmd8/iVe+oLgu+ie
Xdsg4A3nb1H/qvz1pw+cr2V2NH2xoK9D2cu7Ub+B5p2Lfln8VdHX4fYZacuy
0EQHq7IuE1ttX7j9PJ1zrNKMfR16GPPZpYDuW5mk9bfFwtdB+UdqC6svgn91
v5xqmTeCz3b5+uFnHsDwj57tlGbu67DdcGJCuCtmfMP4AI8U44k=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4gM9zBNjLiY6nHq0ZdqObF8Hx+zMRM3LiQ7J
TqvFl2Qi+ItuLl+px+IN5+ssLJy++bWXw+127eZ1VxIddvNYTrW47eVw5I4J
y+HriQ4vf6r181/2clhjaNd6/Vaiw5P6ft87p70cnqj3ZVY/THR4tHaC653j
Xg6vTLprq18nOrgvY+zeewzB51Z8/rd+h5fD3iM5XSJLMfkw9SvtHTccWosw
z83Z1HHdZoR9U59UL7HdnugQOMuAT+Wql8NGTq7UmN2JDsprnUR873o51J95
9V1ub6LDv83Nc+98RvDXzb9qMlXMG86/fcLnyoxnPnD+h6aVj1LZfR023l88
rX9XosNx/mCtQ2K+DiJsYlcKtiL4989MnJC2CcFfmbm8rn9dosOR9F0f+oR9
HYrvhM17vTLRoTfGfGkLj6+Dg5mF7jog/1PIilep3L4OaudKeTWBfNU9umoF
XL4ON/ZPqUlbkejQvWVediCnr8O+8EsxD5cnOuyVVlkezeHrYLf4UtTDZQj3
2Vbm9IgA+R2P5icHsvrCw+/dLYGVRiy+Dp1fnntxLUl0CF4preDO5Otg/Yxt
l/viRIedC3tSNRgRfI0+Hb0CPl8H9PQCABJuC3s=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        145.02237524912496`, 55.48896844874999}, {146.99118529599997`, 
        55.48896844874999}, {146.99118529599997`, 54.99270331312499}, {
        145.02237524912496`, 54.99270331312499}, {145.02237524912496`, 
        55.48896844874999}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHVO88fHrS0kOXVGFd6Zn+Tg8PS58ZseDJIfctR7r
o3p8HLZsidL1eIzJd/e58ptZwwvOZ/NV0p0s5OXwouV+TtCTJIe/EZ9X6rB4
OczhTFkX8yzJQdvt4WLmP54Osi9O1mm+SHJQO+OZdOGLp0Pu5rINrW+SHBSD
NinMfevpsE+wc8u6z0kO2++vnNnxHMH3+Mx50eGWp8PGN4fVGLZj8t9I6N2d
9MrTYfv5qBzjAwjzOipz82KOJTlEGJ+fe+uzp0PBubL3BSeTHCY9e6Uk8c/T
oSjxzkHbM0kOZ2ayrQjl8HI4MFNZ8ezZJIdlP9Z93yiN4L8u/MEeZoHgZ6r1
qHz86eUgV5Dy2v0QMDyWMXbvPeblILZsttm6LUkOLP+3NUmu83JQuz117syl
CH62p4hH/0wE3/vfrkfX+pMcXK8wNe895OVw3/zZPo2OJAedhYXTN7/2clgu
bsCzoyHJQTjvweqVIt4ORVtcfz2oSXJgan/KedkDwdf5PU8ttwvB76+63Sd4
2dvhq395tnsTMDzd/hRWCPo4TPO/cOl/T5IDtx6P+zZnH4cLOkFqXDOA+tdN
e/CyzMfBXvLTu0Cge/NDH77o7fdxELvAyFq9FcGX2TzDa90+BN/m38f1aSeS
HM4x7nli3ezjgJ6eAHrsIys=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQfWCmsuLZs0kO2r+sD5VZejvA+FtK/mZW8PrA+VVS
a/j/Bfg45Amu9rt+NMkhJrf50YEiH4fke4+m2m5D8O/IPKu3XY3gF+is7j20
KMnh9bongpWJPg45dyqlYuYkOeSF1LVMt/NxyOjxWP51apLDx5/i37dK+zgY
Bx9Jfj0pyeGSotr0ra+94XyX9l82VusR/CQT5azyXm+HWSfTRYynJDn4VB2L
XpXj7dD0het41bQkh/kJxWc++no7yFobbz8zI8lh//1ZjPoG3g6WZtEr5YD2
b3DPyzsh6e3Qychxu2pBksPyYPvXidzeDmq3p86duTTJIS2kV+bjVy+H2ItP
G23XJDnoLCycvvm1l8Oj/zVHC7Yg+Bl6IpxL9iD4O3vUeM8eTnIwfsv+8Nk3
L4ePTWUfC04lOZS82bk+nMfboefkvIeHziQ5VKYFfuwSRoR3wOdfFs+VEHxY
fAAAcRvEYw==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk3EUh+c1TWXihdq0gbP8YKhLLfEy+0kz7N37TgkSh4b5/tOJRpeF
rEyWaegsow9LK+xiaWQaBktFyryEtwlJzZTSspkplRnqUjSU9X6a0IffhwfO
gXOecwLYU4ezHXg8nh2XYC72XAprM+avrrII6z43s8+Bwhdl5Eb0CgtnRhyi
96JwKy2lWGNlIcictQuRUHBY7hxNcyYIvt803H+IQnQJv219K8FIvMqfzqLQ
YRlPq+YTNCc2PJrQUNi1MT3R6E0QFKRZrNBTSD82PH9pG0GcecSa2kIhUV3H
l4gIjIVWpWmBQpX3T3VXAMEbJqt/MFFu4/Pd2mKZYZPLy/mnH/jSeNppXmzk
+gNfqI6W5tJ4PXbmnnE7gXCgJt67iUbl2fLKJR8CFes7tMNEIzBP6zrpSeBT
lKscW6BRu2rIkbkTvPLb+TjdhUFePltWu4XgtjhbMidiIPBIKdHwCCZrmnE9
lrH5+XPELTkjg8FAs1SrWGMx9LWluj2fgbX+GrvE+VIqim5I0xm0zX6WVTsR
lPaY6Ck5A5PbCadWV4KDce1ddVIGsb4FOqMHgTSpIk4axqCzDLuJF8HxH+Zf
Zj8GCWL1HSPn6/e455NwRwaD0ycNRjGBtcdN7vqWhsLLeWU9mEAWs7TSVkNj
bk7f7ich0OnU72/m0ND1BVyI2cvVqyZfJu+hkWrI/WSMInAfTfC3LMtt/GzN
vlfRusmDI8bLVfFy3H1OKytDCUQRTSbBGIVevXQ/8SeYCeoTC7Sb93x4sVBY
kE2hPunbx0Zu/lDBAc+/KZRtvysWkWMDKLybcor67kJA9+dLo8IoFJdawrvs
CD5kRkZ0CCn8/4//AGdIJ/s=
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{242.777,
         101.48400000000001`}, {242.777, 92.12899999999999}, {235.195, 
        84.543}, {225.836, 84.543}, {216.48000000000002`, 84.543}, {
        208.89800000000002`, 92.12899999999999}, {208.89800000000002`, 
        101.48400000000001`}, {208.89800000000002`, 110.84}, {
        216.48000000000002`, 118.426}, {225.836, 118.426}, {235.195, 
        118.426}, {242.777, 110.84}, {242.777, 101.48400000000001`}}}, 
        CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{
         0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{228.42917790875003`, 
         101.01833734875}, {228.42917790875003`, 100.1214467175}, {
         227.01602828000003`, 100.1214467175}, {227.01602828000003`, 
         97.785156}, {225.92225921750003`, 97.785156}, {225.92225921750003`, 
         100.1214467175}, {221.98906566875002`, 100.1214467175}, {
         221.98906566875002`, 101.01833734875}, {226.39914252875002`, 
         107.2353207}, {227.01602828000003`, 107.2353207}, {
         227.01602828000003`, 101.01833734875}, {228.42917790875003`, 
         101.01833734875}}, {{225.92225921750003`, 101.01833734875}, {
         225.92225921750003`, 105.819983533125}, {222.54907542875003`, 
         101.01833734875}, {225.92225921750003`, 101.01833734875}}}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{209.41, 96.62899999999999}, {201.383, 
        94.254}, {191.52700000000002`, 91.34400000000001}, {182.512, 
        88.67999999999999}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{183.41, 85.293}, {
        172.82800000000003`, 85.816}, {181.42600000000002`, 92.008}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
      FaceForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 
         0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1H8w1HkYB3Bnh5TRkiSXHyMTozk3uCSM8Ryz3bGKHD6fwq5kP2H9/pHO
r9PaUKOUFYnKz7q72bsoHLNHm/KjJUq5LtOezLpzwuXsSYbcfe8PPjN3f3zn
O69/vt/neeZ5P5YRCQECTQ0NjUDm+fedZRP/cX8rgbhj97WCyzDIbgdJztVQ
P/8u+/RYPYGyn0w6l/Ix4CJVkPQGAbXJQsvNk9Riu6BZvpB686YAT+4XGN6I
RofLawkMplxPH/XAEBPoVRx5hUAJq+0QyxHDxC4p16GEwJv9Eu8mKwy/eBpp
rxYSmB5Y3pBjiqG+eClXnkNt1SRpVGdR67QKO2u+JNDm7yXQM8NwTbQSK08l
cHqqw5Zl/n+ziCvXLYV6h4GDwjqRQHu7Z7SeBQaTQIHtuVj6vffY3dktmoDo
/rw4ejuG5cqkshoBgW3vzY7K9DGMVXvX+0UQMMjLtyjciIHXpXoqCidwUz/n
cgqLepPz3EjgKlr39cQdt2+8RfD5s7YF++MEolWKJ5rzCIQvlcsipl4nw/0l
7+YQaFg+c8+7RMAxOONP3iyCme7NjqvXCAxsdGdPzKD1efepkmJ8JhGwBz/Z
5y8lsJAl6S1QIuhhiz/8q4mA7GG6p89TBKUrisy8ZgJ3bI1Cs3uoX1YJt1r+
QF2l3e7dWMfUm5BROXaLAO+FVp5HCf1fgW+om0qEoGWo88CRywQ4S8qhn4UI
TtTqFkzlE3ie5q57MRzB0KUWXYdk6vEwI86UgPre70EGkSHMvrDOT+8RINDZ
Wh2qDiCQ4RhhqIpHYFrRv5fjQ+BABbQ2nEQw8Mhca4pDYGe0eViUmHqxqK/6
wUXqyB+r+pIrERyUikdaPiPgbJUpdGpAkMdOmCziEnDX3tIU9T2C4cYWH1M/
Al5TX7+tZPrv6Dobqwgi0BTrLVN1Ibjwt+anch6B/AvqVY/HCNS70nJqDhOw
ijl1jzeCYC7qG+WGYCYPd3ut/3iBIOGsl55bIJ2/TOtuvz3Tz6ILP8pyHEHc
otI1/hCB3uKGR42/UjvMZszypqmF1WXJVQsI6o70+XKYejwSU034H2Dw7JWN
24cRyHoV4rGXjeFEOVi68eg+du8rECuOEjiojuPwjTE8LGxbtI+i+VLqTTwR
8QmcV85Ioz/C6/2UyvPmq5zwev9reV2rX8dGtmLsg8HV5vDyMX8C6YYh3XxE
LUo849tznHq3PucK9ysMwb6TMhEzD+fdHl1cCQa25dVEdSiBNJb1zM46DKV+
e5qtmX3IDQ9MOXMHw6Cmv0tkApNva9tyZxmG2mG7V9aZ1KN92Q8Up6jf5Sah
VuZevO6wlTi3Y9jmInhdU8zsy0Tl4+3NGH5rMzBfLWXmg7hzqbcw+M/kJoxV
EBg365XGSDG0W8zJ5UyeMrI77IK/ZeodMm7ZUke9dh//67X7+A+U62Ph
         
         "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPVn13NPIlDSHoAN5+03PhztM+M/keCAuzaF2zpHq
mwfDHQ6+CBVMiU5zKN+pa7ZsR7iD2pnJ7+9Fpjncuj+/uH1zuEPP+otnIyPS
HGzZhDZmrAt36G7N/t8TnuZg+cCN5/wKBP98U+EbhcUI/u9Nk13jpoc79DqZ
L1ADmh8jY/VoaV+4w1GL9pZTiWkOe2+ukW5vD3d4/KFKfFtGmoP8mqA95xrC
Hbbpfn69ujDNoUVt4jTP2nCH8PBNioa1CP5a/Zj03m4Ev/G/JV/A9DSH4Jrr
v280hjsoTJtcyLEgzSEyPs+Rpzvc4fMlbrd/K9IcjlXyM4VMCXfobzK2Clib
5jDL8+0KsQUI/pIg/8mP1yH4ArkfgrWB4bE8fEI7x+o0B49kB4vz+8Id7FQU
zdSXpTlszPHc/fhQuMPuTaGTexemOWzWFI2pPRbuYNayzz9qZprDlkkiCbUn
wh0StzxYMb0Xwbd9/55xTQ2Cv2VWr+T9vDQHGWO5+xNPhTugxxcAgd/NBg==

         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Xt24bSFqWkOMcr/LPbURDjA+AfZbMTNqxF878cW
OUrJEQ7THs1s+5ye5rCUwXO/mX+Ew39RzhtXctIczhXPL79lH+GwTffz69WF
aQ4/nn3VrzOIcGi7zvruSnmaQ4+CIs8FjQiHT3NvCTbXI/h3Wj1TU1oR/Pjv
Ihz/OtMcvmpq9T/RiXBI3PJgxfTeNIcpB5o/zTGNcNgQqs6jPjHNIe3y1B9H
bSMcjEx673yelOZwJcxsL68ngl8uHH00PhzBf1056fyt7AiHZHe36pQJaQ5x
D07eDG2IcJh8fKY7R3eawyU3xicXpkQ4lC3ibn/ZluZwd7F+tvnSCIdIkbpD
pxrSHDyyWPqfrolwWGB/gjeqAsFntrlSk1eE4Dec4rh1JTfN4X7Cb+6LKyIc
Us4/eN6UlebgcGrhCokFEQ4eV3Z8NQCGX972/kXvpyPC13jD8gaJHgQfFh8A
4jbCqA==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx89FJxdDT65SJEl5rGyxsndr85RZQ76/39XMqN9vIyOPtybM
XJ7XpJXh1nkoxWrpohrSkNuah0xMOBWFKbTLdde1U7+/3NYf7z9e+/z1eb3f
jrFJ4Zc28Hg8Ey6HuPC5hIot46ZFLJgr4jNTrjTm5T4RXrtZ6JukLh77aHjU
id6pbVkUx4u6Q7fQ6DFrvmqzmUXe27bJnI00yiTiqkQBi8f68WOdegoWghva
ET4LZB5PTl+hUGuQpnWtMRgurmx0n6GQUFUdu6Bn0Oce76AcppBb2Ae/VQa5
MZGpRQoK3vM5qqYfDNYynE5aFRl5wneAfyrcyJFjpiU3HSjsPFEU3fWTwcZO
6pajlsB0v65F/ptBcdur+g+jBBFv/Ld5GRi0XA5un+0mSFrsHw0zYTHx8W5q
gYJAfb5SsmDGwsy6u7+3kSB9IG5XngULb3xx5tcQPFoSDaptWBwMba2rLiPr
fvIPlN8OvkZwRB1ymub82cV0pFSnEyjPTS1lcr4WUwYlvdzdemup8D3nK8q3
viZFSrC6bAhpNWchVvhN3yslKPm6qpSbstBplA29FQTmaa7OAh6L/gv3Awtk
BPnjWoWc8yV3y18Ofkhg2P5HJl9hsOPldVl0D4FkIU6cOM9Ak1WhLFARTFqN
3QmbYeBbpho5rCPw9wka9VQxyJa5fBqypZAcZJImn2Cgm9N4ZnsZGfbCz+1n
jXz0SWOuXSkF10B7rWqWQSHvOR31mgKfdbMR/GIg9H/mlvDd2GeAeKj1gY6C
41NpRtdfrk/Lb35zfHr9vxdE0OEkpKGxuyjK28SCLMfsneL2FJCZYd9szaK8
NqtBtIfG/3v8By1LM98=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        185.76842612112503`, 97.30146844875}, {187.73723616800004`, 
        97.30146844875}, {187.73723616800004`, 96.805203313125}, {
        185.76842612112503`, 96.805203313125}, {185.76842612112503`, 
        97.30146844875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/ab+aOfpV+kObmst3nmvjHAovaJeNONHusP2sCXh
ursiHFwO5l1W/43JV1F79ZexIxzOb1GbOM2zNtyhYuJnIaM/6Q71a36GiJWF
O+iIVYTY/Et3EFv84SJjUbjD2i93VTgZMhyEn6kYZuSFO/zd3xWWypLhIKgZ
OeFcVriDn9zcqD7uDIc776/4HElH8Jf8bMlQSAx3cPx5/cz9c+kY/HKe6Xme
meEO7nfyhIRvpMPNk2hrFLG5l+6wduZzv7e54Q4Mt7umBjxMd/AqLhXkKQ53
YMr7kC77JN3huQ/zFa2KcIeAZebH1zxNdwiuuf77RiOC/83iD7P2BATfVNht
0o8P4Q7raiomqt8ChsflhqNx18Mdlm1af6f3TLpDc330QZ7T4Q7bnq90rtyL
4P8O1XiXtxHBv811vmPb8nQH5azGg3FXwx3yXX6lcCxId5h+Ycfpmy/DHcxV
XDZNn5HuwGX+4WrIP6B7D0YuODAl3aHp8KeWTIkIOH96rf9kM0sE32Nv7vGO
2AiH1phuQfVZ6Q4xyv8s9tREOKjFPKm4vyTdgU28Tfn21AiHBMu0My/XA+Mn
3PtDyfoIh/OqbFMNge7dsargy7HdEQ7L7oiujjqL4K/Zv+ZD7zUE/wwXW5jb
A2D4McR9mrs1wgE9PQEA6akgsg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHbDM/Piap+kOYn9lE3cLRDjA+NG7/pnsqULwbXmv
sdfPiXD4J7v/y7a76Q7rtzkWJqyNcPj86pu17DkEP0fzl6rsYQSfwXK/8aJd
6Q5l4Z869iyJcPjzoveA9ZZ0B3Mt+0PekyMcfsyI8b26Nt3h55/u37caIxwO
x9/gPL0q3eGlwOTTtzIR/MXOtXJzvRF8w1mCW3dbRThoXaveJbQm3UHd9rFu
qFaEgxCjfG7UunSHgA2Wz35IRTisdXePXbMh3eFB/tkGcZ4Ih5NO+f7/Nqc7
3FQ2N3/CEOEgySfTGLUj3eHKyvlfN/wMd9j2fKVz5d50B+NVbn0/3oU7vL37
U132SLrD9As7Tt98Ge5QxDMxO+AMgv/DSmN98xUE33Om1eY1t9MdZn1rLih+
H+7Q2N81PeBRuoP1tzvXtX+FO8hc29S+6AkwPDevqDj6Nxwevisqa+cUsyLC
GxYfAJwMzmA=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtIk2EUxzctNDVvhW2S0615ycsUs8hI/TfELjZDmTzvGyHT1B6z0i4q
4l1S0tTUWVnKNLKtFSVmUmRGmSQmVM6iopnUstA0F0YsA+39pNCH/4cfnAPn
/M4Rp2QlpFnzeDw+F38uVlzsbmWrM50pBKqHJ1pyCLLSd10VOlKc9mm4sLuI
wC8t1Yeso6gNnit1qyFQ80cLtooozr9MPGRqJhiq23DAKKE43LbJUdtBsJc3
u5DjS/FW8tow00nQs8pSVh1AsVbdaxnoI/h+5LM6OZhCZJ4sCXhB8Kb4Xo/T
Foq0vsXAjGkCb68FQVs4xTdtyMEvbswSR6iiIFEs88BTm/uvihlsH/51sZrr
dx3rvr3jOoMEU0W0PoSizqRoqxpisL60JdQQSBHWZTfhOMagO7exs8+Pwj7y
bmDmNIOQlYMOUinF+OrG0SALg/m83MBSTwpFQ2hzjjULvTDVjwgozArSPujC
LvmZv1HhK5OwIL3xUpkLRfrx/bHGjSzOdV2xNXC+gnwjn2vELGLmfk7leFD0
qzK0ZiGLFEHpzSYxhVRkHB9xZTEsrpLpvSk8O6I1GnsWcWrliNyf4s6p7Fwz
n8WIrFKu53zlHT2jFP5mwJjLGf02Ct6nimsrjAw+itxbjXIKiUd+wYcnDAos
uqS/Oymio8OnYnUMBIbNYncFVx82O6arYfD1UWG5fh9F5ZRX3Z9jy/yukJ+i
i1vmicnU/j1rGAQ9Vi1mxlDUX0qcdBgnULbHT8jDKE6qUxocupfvaYiKqH2g
JQhLtJRUc/M314hti1rJ0n7P8p2slE0EyT+EY4NeFD6mHk3LWQLnepv3GiHF
TPBlYVIZwf//+A9X8CDc
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        308.73799999999994`, 131.20299999999997`}, {308.73799999999994`, 
        121.848}, {301.156, 114.262}, {291.79699999999997`, 114.262}, {
        282.441, 114.262}, {274.85900000000004`, 121.848}, {
        274.85900000000004`, 131.20299999999997`}, {274.85900000000004`, 
        140.559}, {282.441, 148.14499999999998`}, {291.79699999999997`, 
        148.14499999999998`}, {301.156, 148.14499999999998`}, {
        308.73799999999994`, 140.559}, {308.73799999999994`, 
        131.20299999999997`}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0n0s1HEcB/DLU3JH88wxcp2IztPKeli8W552a8zF3HnYfc/Q1hbbVw+K
Eg6HozwkVlSMf4wYLTaUVRaZi6RpsTN1Hm5zyUStWr//flv98f7jtX322Wef
z8cjNUuSbszhcHYxETExYtJfGOe1kkGxqczqMBMRPPg1KKpPpCi5vfknVCtH
95UGWY7x/x5a3ZjlrclhtflyO96XIiLYpNhTTHCnb8SyPoTic0WAcIkSSO2f
OwVHURiJUka0jaztLg6lHxlmrXYstdh5SxB+KPFcdDhTL4ntOK4lcE+sMskP
pVhSFybr9QSPB7c62o9R+AfyBeXbBMPnU2KtgijijXVK2W+Cy9U7b+a8WV/v
Hu038mBdU1H3cZhPEZbXuzf5B0GfIDXQyoHixkDB66mvBOr11Jo4a4r+7zEF
kSsEXcUBq608ig8S9wmHOYJK7bjRQXOK7oeDUy4vCC6cSHftYvaBbEOY7BWB
qjetZMaMwjz/qdetRYIM17v+xVwKvu7m4f4tgthTY5ZjTP/c9z3L3sYKTBz1
k4uZeXiq3G/V9goIJmucbTwpzkxHPCt1UyDPz8cuLIi1TXOVRn+S9Xzlgdrx
SArrJ4uZOgcFZjOl7Y9iKO5dc5xs3a2A2jYhryuBYmBW55S9Q+DTUibMT6Lo
vF+kav7CumRtX1WrhnUDrzKquZNAaCr9ZCeh4IbUui2oCJpOJ43OMPddzuKY
qgmBUlPX5utMEdhuGe5pQ7CnUkrXo1kblMKZ+bOsNTHlAznMPMHvskeu2hK4
6soMehnFxDSvh+tIQLn7F5qSmf5inksQn0AcabD4KadoMlhshAgI2hrXL3HS
KIoSWtzC/An+/d+/+1M1Zg==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{238.125, 113.293}, {245.82000000000002`, 
        117.87899999999999`}, {255.996, 122.754}, {265.42999999999995`, 
        126.45700000000001`}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{264.258, 129.758}, {
        274.85200000000003`, 129.836}, {266.621, 123.16799999999999`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4nSe4qYHM3McFiZeM3jREu8A459sSPD5VBzv
EHZm7Va3Bkx+dlXEwa6HcXB+gqyWlcrFOIeuOUZfAxpzHHp8fSYnHo1zsFfc
bhbdnOPQfnlLoN6+OIfPS60rUltzHF5OUO/m3x7nwL8wOWt7R46Dr8LMMx82
xzlUXrm0e0Yvgi+2LqFu+yQEf3P7O4dr03McttfmvZm3M85BZnfspO1zchw+
zewsvQO0LztmyVe3BTkO74v3XXA6gFBf/ny3ot4yhPmcAv4HfGbGOexzCkzr
a0Twn29dLmdUhOAnbSxbeTorx2GDGzfXpXUIfhrDwfrwWwg+LHzUHPubv8Qg
+Dw3zyTnA/l/A552/ymJd/hUwOXyKjrHYUbu8rWNZQj+GVudt93lCH76ul2r
V1XFOzisDFxcGZvjwGxSc1G/Lt5B41+USl9CjgPbR/eik43xDneb7qfOSMpx
sDx4ZuPlpniHn7XsEa9Scxxsn08Py+2Id6h5f+lXM9B9LnK/Lawmxzs8VXLy
Sc3PcXgqG7Lg09x4hzlWOgk2JTkObYWVS1xWxTuw5s3eKFuZ43DoYcIp6R3x
DleiHgmtrc5x+HV9w7r9++Id8sqXmBjV5jhM32hXeO9wvMPVt+5PK+uA7n91
aMuLY/EOtimvpx6sR/Bh6ePv3+rgyCMI/pQvRRdcDiD46OkPxgcAKo9Gsg==

        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+ksZaHa2imiVFplVhEVa+8yDyFtarmo7xc9bPEtstb15GQe
6sZsEptxJgojXYzMNY/LebpyTip3zkXdUs7jspTO+v3F1h/vP17bZ5/P5/15
f7ZGxYZc4pmYmJhy2s1pBSf+jMUBKwODwTQ4wG6eosbDdUfEJMN9z9tO16Yp
fh/kFzvqGdYurGnNGKHILCgPOjrMsCq8Qt38nkJgLWCSQQa3dIWrsZNiQJLR
xRtgkJs7x9Y1UrDHyb5TSoZQ24zSqy8p3Pfludm8ZQhqOu9gXkQR6PBmfbSc
YeWMX3xXEsXfhASpuo0hxZzvFRy6zBHdLaZJW5ZZfXlerJok0KvS9k61M2Sc
CMqObCfolc0lK3u4ff1qijc+JbA/5/WN9jJ4GL1k27IIDid1l4n6uX5x2fEd
SQSNszkBNp8Y0ovqesxuEuBi5ET1EEO98uP2Y9EEt1L4RY5fGV4MlT/RhJOl
+1jUp+SIAwmMD/03iMcZCqel1zXeBI8Mg81lXH0cr01oFkSgqRBreTqGoa7c
/JpTBM2pC3Z6NcNnbxetPozgzL3ZPOUHBlHa6xKzKIJ+i52/3FUMIRN5vh0x
BCdj51KVCganRuGEWEjQWTUfq2xlkBy/U1DI+fFOjHSWNDDctXwg76gkKH3W
f0VUy9C8uU8VIydYrfApo1IGMxdbnfUIgadu0Uf5nJsn/O7StLjM8qpF3YI9
XeIG5CcKwih+ajd1Wb5isMqqEORmUiiMu764dzJkvSvbUylbzlPxo612TE5h
8E/2n+rj8iwcPuTUR5f8HRn7I7swSNEijRyv1jBoRaft7UYp1lndmFKPMvD3
x5WcNVD8/4//AL5DSxs=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4i9dGydkseY6LP/IbFdxN94BxhfecSNR7Wm8
w5PQ7Zr1IrkO4kYFiyPfxDu8lW+4J6GU69D8w+U4+5d4h69Ta75J6OU6vNsn
+Xrr73gHzTRGM2X9XIdd76asXv0Lwe/jkjD5fSIOzg+aZcCnsjvOYcKdJc+y
DHIdfLbPPPFhY5yDtvLZa3uMch0er53gemdtnIOwX0Eni2muw1oFh1SLlXEO
G9T/eStb5TrcM/7JvHJZnINp2NT+MKdch1XJJUfmLUXweRSf/62fF+fgOHOS
oi4bJh+m/gFr2zYJvlwH1wazZ8rL4xySF25XrxfOdXjw4cgSp1VxDkZ9/zr4
xHIdNrhxc11aF+cgtXOhdZhErsOzy9GvSjfHOTTqu76ZK5nr8GbbJ/2VexB8
DfVboQ2nEPwElXcTrPbHw/mzta9tEjwd72CimBJ9G2hert2LHVaX4x1msiyy
DBPPdVhy2mLmvevxcPt5rzrKfL4d7+Bl+ZX9l1Cuw+2DHbVN9+IdHuq/aXnK
h+BP/r5ENYwXwT/CFXfkGFeuA5+do8JnYPyWZoonmrNjxjeMDwB3TepO
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0mtIk1EYB3A1LBc2XBOtlZIGKUIoiuZszaeIGeIlxwzTes82J8PJk03F
K2nmFG9oc9Ps4m1EpTiYigpSq0wlnQqKoUSZoK1YpXghEtP19umF+vD/8Pty
znme8/eRZ4rT9jk4ODjSOU3HiU58gXKbO4zAV7b58lYoWJLL5PY+BFefL7sl
rRSIOWciMy//b7eoXsPRxxS8iFf/3LuF0I98rtyZgGVW5WvXIbRLsyfXQwiI
9cpweytCtc1YWiplLDyr2NxfzbgkwmM4r41A2P1IkfEhglk5XvnVRMBuWJOx
GhF0NdmTF80E3LU8SKlDcMrnNtZaCPh7iHjGcoSIG6kFQbMEXDoqrH5FjEMV
7MPBWYxXnH8fYmUgqI54uXdMEeBWxL/vTkO41yNUL74hcNfmlS6SIoxES6eP
DRF4pVKH2pIRvksG77x8RuCkdjnLkohwQRbY3F5PoGIw0dT9dx9xuduBDQQq
c3wSRBKEJE1NF/YSSNqa0hiuIjyYZ3nkjxPoEi9VWujz1Yq+63MLBCZa+Ktl
KoTeuODRxR8EMtapjXe59H2OcdHHfxFIea6osZUzLh6p0gp0jL9FBVzR0PuL
ydiypq4RMGsMAYVPEdjC8yc2PxIYUfJvGk0IYZea55om6XlDrB2sfoQ6zodq
ziDjz16S9o0Wxmnrqwc5efT8ni67oi6EaMnOgFssgR49e0akRxgz7n3a8SYg
92s6J0hHqI2N0clG6T4kC64ZnzDOeVQrTOhmrH3Ns2fS7zmlYvdbxyhokNye
EdB9q8/2DN+ZoKCos0qcMIDQELS8oJ+mwOSao/Afov+HW+j9dp6CkOLIA8Nm
BBeJtazTSsG//f0DwMpEMQ==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{240.761020489125, 124.76413176875}, {240.761020489125, 
        126.51668522}, {241.289786616, 126.51668522}, {241.289786616, 
        124.76413176875}, {243.041090029125, 124.76413176875}, {
        243.041090029125, 124.227865413125}, {241.289786616, 
        124.227865413125}, {241.289786616, 122.476562}, {240.761020489125, 
        122.476562}, {240.761020489125, 124.227865413125}, {239.009717076, 
        124.227865413125}, {239.009717076, 124.76413176875}, {
        240.761020489125, 124.76413176875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPeHOZsE9d/IcztjqvO0uj3eQNBT71fEqz8H2+fSw
3I54hxeysdESbzH5q7bd/eMYFgfnc21vmdrpHecg8+7hLKV3eQ6stm+Dw1zi
HC4Upd3R+ZDnMMf4yQVHhziHwMAza35+zHOYWSZhsMImzmGhTOW90G95DtN3
+vTzWcY5fKrqflT3N88hqeGEN4sZgq/VVZGeoB/n8DT0WMiFA5j8v3O6cjvN
4xxeW8TOYj6FMG/Po/w5OhfyHIy1bvvqAu1bYl4p63g5z+ECc6aAj2Ocw7JT
997zXstzyL377VKWW5zDFyY1/7nX8xxu8pz+JRGA4NecfM+UHYfg715sOdFi
f5xD0M00SYkzwPBILjkyb2mcgxf/vJS6fXkOnAL+B3xmxjlEucw4nbkewZ+/
SawsfjGCX5++V2D5zDyHlb9KDsxbHOcgvPDFmx8T8xxkE9ecktwR53C7wciq
oyvPYcLxx1emnAG6V9ZDY2NbngNHyLPmlc8QfFk+50ll7PFw/jnfxGMntOMd
NHdWzhTvyXN4tPmj+R+veIdTOy4xXJiW59CzvFJJOiXegWVaSMithcD4eW73
fkttvENx0xcZJaB77axTPrN1xTt4WbIYe+9H8ANkZlfUnUDwC9K/3DW7BAy/
iYEf7zbHO6CnJwCaKhaD
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/YVJzX/u9TyHOb2CCb/vxTnA+A+9Phn/8YiH8w/P
Pcm2PyveYVHV2prl5/McTN1NCxZUxztMd396mPcAgi/Q9mIt71YEf8nUtbsn
rclz+PP8afufoniHBa41HjrL8hz27jI62J0Y7zDnq9fVo/PzHOp7639JBcQ7
pO85NnH3nDyH/IVtp6QsEHzNKwWydyUR/O1arFt+c8Q7nDPKcmKel+ew9uw1
nak/4hy2xfJ+9VqQ53DNQfepxcs4h8Alpk/nLMpzSGM4WB9+K84hd37s9XdL
8xzit2iZqZyPc9ibxcXpvSrPIcpq8pcPx+McolxmnM5cn+ew08qq12JvnMNE
qxfrebflOcgmrjkluSPOQSyz/rPDPgR/znQx85JjCP7brxrWc8/mOSi0l+dv
BupXfVMh73glz+Fg24Vr2SfiHA4YLeSffA0Yns5zylnPIMJbj6tw9ubLCD4s
PgCVgsVC
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUh2fL1JWlubSaF0zRclbWJJUQf1Zg3mGVObH3NVGDbL6pm6EL
00jDGxpYNsnVB8W8F95iFHijmFhp+qFQx8yaloKrsCw1+n9y0IffhwfOgXOe
c9yTmTSVz+PxLLj4cNnEpd2GihI3MWhMHZmTJwkcBo+JBTwGQe+tuyWRBCP9
0vYwGwaHPuONuASCANLPP2DHIEoKT/O4RCBfsP80ImQwHfa2NWYRmBKni9P2
MFzofDV2MJ9Alma0Ubkw1Hp0/NpcTlCpGxVJ3RnqC6bz0x8Q5E42BPP2MyxE
/xA3aQl01xcfVYoZ5AGeyZ6fzTxoOhqSLKIbHHF2tccumsLgPeum4vrvyxvb
CnMofoYoRtT7GISKUI2uhqJvqkQ74MqgDf07G9NCcX68IKB9L8OdN43iFi3F
xMXuaqEjQ6qm6J38JYVmIqXrqj3DuLtXTfcYRXSO9EmYgCFHH/HQykA3/BQc
z/XKMFGsOqHVlc+waBET4bxCIdleVTXA+ersPaLTL1F8jTVkpe1gOP0tscFv
nmKLMkNS5MDQ3P5Wbz9DwfKv9aidGBr8A+v0Hyi+L52QSZwZAi1TlH6jFMoy
xbCa87W+rjojG6JYi8o0qH0ZijNz6081U9xUWXu+9md43HYlT1RF4XbunnEh
iGF4wvdLmZLi+SHPJkEIVz/0cWougaJUlC6oDWXYphJWBAWbmdguJ805mzk9
L76/dIZgzDn2dmIgg6NP+HxUG8HKWohc4sXw2yOuKqrQfM/4Ub/yPwqC90+N
VipufleXXVYvLpON/aIEfIvqZALLSOvUZzsZWrOb6iZlBF2Ly0mVWxmy+yp2
a2IJ/v/Hf9LcI5o=
        "]]}, 
      Thickness[0.002577319587628866]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{308.816, 133.406}, {316.051, 134.34}, {
        324.71099999999996`, 135.461}, {332.99199999999996`, 136.531}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.77, 140.031}, {343.137, 
        137.844}, {333.668, 133.09}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.002577319587628866]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQndp17e6ZjBIHTqb9C2+aJTrA+G0TPv+zN0p0kLXv
O6rhgcmHqbe02ra9yrvEwWbFXSFx80SHt5dzE177ljiECSwwmgPkh3oJChr7
lzjsbXN+/Ngi0WHPgS0HqwJKHFT/PpusbZXo8KGabZZcYInDAWf+llobBP9r
zeTj7fYIvvaD2ptxzokO63suG1oA9T9SPLebyTPRQbF/v0W/X4mD8Sq3vh8B
iQ7ZSYv2BnqWONwtzljllZno8Ltq29en6gi+4GT3RSxKJQ61Gd9Wh3gnOrz6
tviTjWKJgzsrz6xa90SHI/nGq24rAO3jerJc2wXBL4v+OT3EEcGPWMzKmgl0
/87Hr4LPKCPCo7Pi1Ls+TUw+LPzacp5tNBfA5MPU5x18b+QjjAhPz7NP9mwX
LXG4/o6VOdMy0WFjxO4rqeIlDuq7NpkctU10sAs7f5ZPssRhlXbd9TinRAeT
U23l/6VLHOp+R9cp+iU6lCUGSUoC3VvYrLvjfEKiw8PHN9l2WJU43JmRwtp5
L9HhpPIGhTRbBP9IgvgK99gSB8O3VW/jfBMdco69PVAaX+IguEixYxkw/N8u
CZ7olFji4PCDr60WaH+I9HfHrqQSh8iz2ZdNrYHxO3HWp4vJJQ5dD1SKlgHj
u0BM3uROKsI/6OkNALRwG0w=
         "], {{322.62239645999995`, 
         139.61787444875}, {324.47745303749997`, 139.61787444875}, {
         323.54992474874996`, 141.826691815625}, {322.62239645999995`, 
         139.61787444875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltI03EUx+cWqKlLKjRDLNGUbEKaK8GFJ7xTqZUr24R1JEORVPQIzfKW
l62Zlxg2sgRBSLKbJehEpGVjaSJOZoiTNW1lZW0WxFIQ6/f2hx6+D9+Xc77f
zzmh+aVnCwQ8Hs+DKYqJz9S9Or3l0hK4eZEHhHaEVb+P7sBOAkO3ZNexRYQ2
YY5Y2UGgrm6+ZLIg5BoeaLxaCRqjpU7FNMKYkrqGNARdKSv3at4ibBqEk0Vq
Aofg7rD1NUKaRKNSNBM89ku1HB1FeLq9c6uikSDC/qxdMIgwXN/vDK4naFgP
G/nUi+Af4ymR1hKMN/iE9LVx/nDBUh1UcP7qkc3kIhlC42LLDXsdgSni4eRA
CoIyKynC3MDyhl2c9RUj7O9Zmdc1EdyvCbHdOYTw/GV0fJ+KzdNnjDjCEMqK
td6/bxGkmq0F/BCE2PANK9wmkH8t3hm6ByEzLiduo53gQsmc2enP8WmSj78z
eiF0DP0oecL4Za3P653bEOSFYmMC46X3WE7geyPUpvlZihgv1+Wp0wu+CL/i
TOWyFoKfoTpXOZsnGTgRk832J76xneHvRrj+Z1EhYPkeuU/1Otj+kYNJkdmM
l/bDqNvI8rknkoPNNQQz4cczZ1ifwRhl1VAVwVhzksMRj/A5OTYo8hrBUlvh
N3EqQkDu92FdJQFf17qmOsf6L6d5ZhPBq1EKVORz3nH+71p1OefzeqYTRR0I
PsvvJ1xsnipdKjrZj7BeZpMKbhKkf7F0Sg3cPa9UooxMCOoAjdrO7i3IWgvW
TnH99lG17cUM65+xsWBg/UsTo3YI5xD2Kvl5UsbXN0g/K1pA+P8f/wHDvTIS

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7adqYZR6psThmdy0b0fnJTpM9s9c5n25xGHeZ+/V
ZssTHX4d5QmffAWTH3o7758CH4LfGn3o1BGORAcRvfNlEldLHJrmfdPUZk10
yCuYOF32WonDOcmiFwrMiQ7r44/8Z75e4uBrzSMRwpjoEH50loTRzRKHMzHL
3Nv/JzjUf1k869idEgdDhyeqTP8QfFHXPcYbfiU4/Eg8GJy/D5Nf53d02xGg
+urLPd84DiPMS9GYVi57rMRBcurbZWJA+25cktqx/HiJw4tGE45lQPdEzvFV
5DtZ4rAtrzrTlC3RocHi44WrQH5uW2otDzeCv+9JeaOpEIJ/9+IcjzlOQP8s
FjQTPlLicNXQKum8aaLDaru10W57SxxYOtQTluknOhhHavHv2Yrgh07IfLJt
PYJ/9NWejbdWlTiE1FolnDdJdJjQfmk+8/IShz6DsKc89okOJeXlbt6LSxxO
PC7M8vJMdLjp2rQ3fiFQv9bngyFhCD5fu6Ln7jQE//kyg+QnFYkOs4Wlvwkt
KXH4ePOHdF1HokP25OOa+StLHI5dtpnIOzXRgaOpI/jLOmD8FM8vv7Uw0cG+
4ob5DKB758tuqmReAfRP8INDa/Yi+HpHV6e6HULw92VFzFAChuf2Eyt+vFuS
6ICengCeTxyi
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WDx8cLVkyUO545xbKgNSnSA8QtUf0rWtSP4j86l
NMfPSHQI/7Ll+a2jJQ6zFktZXFiQ6HDpVgA33z4En68qiKFvB4J/g9G0PWBL
icO/z5+c6+YkOlyLnOMru7HEIT525oOjkxMdrmxkFnm1tsRh/zH7Wt7uRAer
qY6fUtaUOOwIcE7lrUfwRbJ29L3LR/BjpjLdqk1PdMgNmHyKA6j/Wlr2NK/4
RIeHT58s1llX4pC9YFrRnPBEB33On7ND15c4GDc82K8dkOiwh4136r8NJQ76
UaLSk7wSHVJyHq/V2VzioDvXs+qHW6KDcaQW/56tJQ6xsnPd5jgmOviHBDHy
7Sxx6DMIe8pjn+gw8bXsYvW9CP6VppcujgcR/L8bPx27eqTEYcLh3dtvAvVL
rJXaqX6ixCHBOeO1qXuiQ9oFvY0BoPBUPLebyRMRvuKtO87e9EHwYfEBAAFT
xE4=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm0sFHAcx89DD5PHHkxRjqiVq83smELfRWa9YC5XLzTzu4hZ6PJvs4om
eVwL2XGGVquuSR1pMw8zykPLw90LlxsmjTwVTtiNGtf/3W29+L74vvg9fD+/
n4csXZJoJRAILLhOcllyTbTbBYgnGaI29C1L1oQS5WaI7TeGvNhP/T27CYuV
BYL6KQab+LVzPo4Ej9mQetdZBvtGrw9lzoQOUVJ16jzDRmX5zgw3QvbM4I22
nwwNo9Pzzp4Ev5Rodc8iw1CZ/q7lCcJQdXhA4zKDpCutU+xL6Pbyjdi1ymBU
bSpiQEi5rdvUrDE0u+71fSI1e1lmlfv7m2bv/SYrtrCIYOyPag3j9YPNwyN4
SrC4onSIMfB924TaH2rCde8X+clLDBNCk/x1C6Hp2ZELcb8YIuaGFdIuwspc
S4bTAoOf9vyCfx9B+rw0t5PnW3AsHxgbIIhuFVj4TDOcTX+ltRo28+mqDdoX
ME6wDs2+X8H5GQXHve0nCe4hKvk85zU2rkwwjBH+xmlkbTMMLzPVEhc9oUh+
oPvLHINUn2Qo5P2CjVXWOj5fcqgm0qAlmNSmr0LOq8ay6YwLn//xntJex3mZ
tjvqRL2EhxMVB2PWGbpbgiSePM9nJmtP3WDQXfbvsKsnKKjObesPQ2JKxXpv
LSEhciXr0RZDqEy+nFFKGOgpP63bZsgPLu6ryTH7hvw7jRlysxcHv43vvURI
692RKub99ii8mCqQ8EC8PSn8zbDl5BOhOmq+pyjZJTzrMGG1JPpdGN+/5HFx
bpyLOd+xvBzBxf08/9Wp2Gs8/0irTrPkQIg/NTqq4XwDv4fbam0I///jPyHK
THw=
        "]]}, 
      Thickness[0.005154639175257732]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{279.508, 119.391}, {271.816, 114.809}, {
        261.641, 109.93400000000001`}, {252.207, 106.23}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.005154639175257732], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{253.379, 102.93}, {242.785, 
        102.85199999999999`}, {251.016, 109.52}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.005154639175257732]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGItIGYC4lVX3jQ21OQ7yFx8ZLiiIdoBxnf5kOO7KT/a
YdYU9a3PkjD5z16mHPK6GwXn3+4xs35yJsrhbMqaLx+S8x3Y90ZMUTwY5dD0
0sDsd2q+A5PzwaB3O6MczPK2lrNm5DukMJj0nN8U5RCUeTczPDvf4UT/0rMb
1kc57Jnjs9uiAMGPLLtVG16K4H/zz3Aoq8p3MHpb9TZua5RDfPP1ieH1+Q65
nNPK5gDtW6ci9/VZU75D1uNTF5n2INR/Cjuh9G4hwvyW+uiDPFOjHBi5T6fq
pSD4WnWKcpdCEPyllR9WZPvmO2hvE+eetArBf5h/tkH8GoIPC59MTs7mKfYI
vv9Ct2R+IL/iwMeePQXRDqaWLc5ddvkOwnc3r3MsQvDd11q88y5G8B/JHl+T
VRbt0Fx4epGkQ75D3eKOS+8rox2yj11R1nPOd2hICCnurI12UPCOTLVwzXfY
YnBz0+S6aAcbt8bwLo98hx1hS8J1W6Id9m/3+aUMdN/+XnarX33RDhqvd3uz
BuU7JPQmLNw0M9rhPtOy+Dth+Q6MD1uXsiyLdvAwE924NzrfwTYw9/TtzdEO
4soxQr5x+Q6l7nvX1++KdthoL2dyKT7fQUjRu2je/mgHiW0Hn0gmAt0fdX7r
ikPRDg06qVMTkxB8WPqoyO0IkTyA4POn1F9k2YPgo6c/GB8AErA0Qg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxw+NLT3IWqNJiZKQ1m4T6/K20e3qqonQ96umViy077kbyTy1
8zAkI6vsmHQ4mahwXOcht8tV85DMVTsq1VTIP42i2fX7y2398f7jvc/22fvz
+rzdLrBTl2x4PJ4Vp72crDkRTS6/ZZghPpkcm/hFsWBu9uCNMvxtyvPcN0dx
yKqsVmdgKE5w1oknKUYv7hRPPWOQv1Kbsl9TKN6OJgq6GVqX3/F79BROcbYv
lZ0MwVcPSlI0FK0xK6GlbQxviu6qfJspri058rtaGQy+CTsMCoqb3wSOax8w
5MRGyAozKYKO/G5Jr2cwp7oLNoRbvClgyDrYxeJPG9cUl88Q7FHw9pc2Mtj1
RFe49RM4yplc0sLlVfcq39cQnPdQT5sfMzxJEmm/3CDIFIWoXNXcvo81soJM
Ap5249Gupwy2DrpBfTKB3Mc0F9bHcABfd1nHEWjFZTW6AQYvccd9RRRZ5ZO7
u+y2SEiAMN1mL46fc2y3VBFEMN4e3ifkeM1Kh9P03NxVZjOp7GeIClBWSU8S
WJ9IccnrYaBtgR/qIwkqQ5IqJRqGpQVDnf4swZaxe4vGdoahmAZhQTxBuT/L
k3C8an1y50UyAvtUKZPUMThp8qvPlRDkC03egiqGxYxbhgIVwY8rxy+73mEI
LJkc89YRiCv6GsxlDNnVnp9GJgiyVGmhklKGP9MLflnLFh+8zX5Ku5Wuev4j
VY5TJIV/Q8WLh3cZCnmdZyKLKBwGlJ+NTQzrDrf7JKot/xSSkY5GHYXfphVh
KZf/+vrZwOlBunqfJsqu232cwibNNBPWyxA9H7t9gutThPHnfPpzhvLajDrn
7xT/9/Eft5A+ng==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYvNg7QlcL/IdlBIF7C1uRjvA+H3qT5OePYh2
UJcz1JT/nu8waWHNEskX0Q4SX/7kxTAVOPxLDzxx/H20g4z+76oYjgKHTD21
N6Xfox3Mpu+d9RDIN41buCb7G4LPWaViuvtIFJx/ltOW/8m2KIfMIP7iVs4C
h+Nqy05uWBvlsL1UOXsdV4FDnOxctzkroxy0uUtdLnEXOGhM8En7sSTK4ef3
3UsT+QocIhezsmYuinKw6W93rxYqcFC93HA0biGC3z7h8z/7WVEOLYk8imeB
/kHnw9Qrn/u/dceHfIcD752ePwaatyzTUF3+W75DdMLFpUzLohxKwyo61v3I
d9DeJs49aVWUQ2yjtPW3X/kOic4Zr03XRzkc+b7vte2ffId0tf8GmTsQ/MXT
noU5HEPw70z+NfHXrmg4X2z2o80Xj0U7lL+8G1X9O9/hxdovO3+di3a4c0ba
8tvPfAd5a9dZ8y5Hw+3vcPGT3Xw92qGXMZ991td8hzDDqXVOt6IdVH6ktrR+
RPCv7ZdT/fYewWe/fP1w2tt8h861voqbgfG7w3BiwvWXmPEN4wMAp2z53w==

        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJdIGYC4pMLCv5EBhU4bLm2WvnW/SiHiVPfbvD3LnBo
n/D5n/2sKIfTORHz2yUx+d3b9i2+OT/KgaHna5W/QYGDwV1XESXGaId2308T
/K0LHKQv1J/dqB/t4L3uw+zzDgUOrFG7mhxjEPydqwq+HGtF8H+tVDpsPjva
Ye+GO4vU7AscLK9f7VyxJtph4dYtG64AzeP7XX+WZVe0wxqdU/NrLQocap/L
T/M5Hu1g9v5+j5pJgcPWu/lVH85GOyw1Yfj8WA/BtxE7wpGpheALP9/VdkWt
wOFpu6Zo4sloB+3lT3LUVAochBS9i+btj3bIvOltUqxY4GC/K+f87a3RDo0z
S6WOyhU4pB053Fy/JNph8xq9naYyBQ57L1jPTOiOdniy/3n4MlB47G369b43
2iFtnq9GsXSBw+XP01frrot28Lun7KQI1C/qLiZucTTaoYxX98hWoPlvLu+P
m3Il2oFt881vE4Hu0d1nd2zey2iH6zFvfuzSKXBIL4zyvvM52sHfKd/V1QTB
TzjW6PHOCsEX57ikNQkYfsdvMbxQfh3t0KDGJ8rrWuDQudZXcfPNaAfmGTe3
L/MscNi4fcnVsBPRDqv/rr9wBRi/nI0vui9uQvATehMWbpqJ4D9I+M19sSja
gfGDQ12xW4HD0cPsOy54RDtU6blkFAPjw1GW++FuqWiHy9/b5d6pFjiw742Y
ongwyqFB8PbaZS4IfowR8/wKdwT/lYvX/3agexbelNq27FCUQzZfbcY7rwIH
rsfKlruPRTnc38G4ssKnwIF3wfubIaeiHKpefTNM8QPGT3ObfMflKAfrxTHM
GwMKHJoOf2rJfBTlgJ5+AXWQVZY=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmtI02EUxnUFhiyzJGtZ5lylmKmYRUXqkximouCd3pdE52XaUt+ZVmMu
L2UqrpUJQx3MgtzIQAwvmRcSTY0itFZg6tJYRpuZmkSFUP0/OejD8+GBczjn
+Z0jFBfEZ22ws7Oz5+TDicdJO6dZLBEzCNL6C7WhBDEDFT8S0hmuH6jTREYQ
tPY7P/6exaD2Xy1zTSaYdXyenpHLoBlPkpjFBIq45bguKYO0+bCTPp/gpGOy
iJfPMOn59s2inGBFPZXJZwzb6/t+PasiqB0cX/wpY9i7bCk92EBQHtn7J7aY
IXvgr29uN4F307l218sMX/QBGZ/mbD4kLRSeO+i6Hxl26Jk4Q9G5NFmg4vpd
TB1tpwopniqEo9pChlvmmOaaeop9Ub7B7dz8I48c550MFGzEsNbC7ccP6fSV
dlO08cN8zl5gmNt8x3hoiMJlVHDC4TxDbF1gQ/ErCqvGuacwm2ElJuXu2DRd
57PWWunl95ViSOJw9APHTyIj0TOrFCaxv3cAV+/nFfJCt0Dx5FqKgMfxGk7L
1S+bKSI0OvlWjtd+95nZ1zMUa7tEfW55DB73w3W6dxQDxmpVTgFDRxG7tPyS
ovSecMSNy3MlrzpRMEgRxvOY0HL57T9WtmzUU1Q2Lsi6FAyiPXLFdC1Fwo1A
Y/hVhtPhx63RMgrPi/Kgt2VcfdCSyZBMUWPZPe9WwVBl9VD/Pmbz70vsxYad
Nv/ZkjkUZSLwtapFSiVDXWOShf+AAKRKk1PEUFQvruMrbfc0hgbf7GUE7Z1T
GSpu/0aVcJMym6znG5Nv4SWmEkSUS7c95Ph6mbt02iQC93jxbVcJwzf/JkFq
NMH///gPECMu+g==
        "]]}, 
      Thickness[0.005154639175257732]]}, ImageSize -> {388., 165.}, 
    PlotRange -> {{0., 388.}, {0., 165.}}, AspectRatio -> Automatic]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.825905024147108*^9, 3.825905072463655*^9}, 
   3.825905363382402*^9, 3.825905528383874*^9, 3.82590787412798*^9, 
   3.825908032413294*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "7"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.004273504273504274], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 234.}, {
       233.859, 234.}, {233.859, 0.042999999999977945`}, {0., 
       0.042999999999977945`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        65.789}, {45.02, 54.456999999999994`}, {35.836, 45.273}, {24.508, 
       45.273}, {13.176, 45.273}, {3.9919999999999995`, 
       54.456999999999994`}, {3.9919999999999995`, 65.789}, {
       3.9919999999999995`, 77.117}, {13.176, 86.301}, {24.508, 86.301}, {
       35.836, 86.301}, {45.02, 77.117}, {45.02, 65.789}}},
       CurveClosed->{0}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 65.66912544875001}, {21.99788154, 
       65.66912544875001}, {21.99788154, 64.800672813125}, {
       18.552508993125002`, 64.800672813125}, {18.552508993125002`, 
       65.66912544875001}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2YP+8qdH/UaCD+or59t9yrR0+
LZecUvsAwS+b72df2O8P5xcuUWKZleLv0FDBxGbXbO1Q4PvlxiF3f4cbZ6e8
j1ln7SDpP0Gq2tLfwUBZ/Wb1TWuHdXmTih7q+DtMcH3CWmRm47B6zuSsh6r+
DkfWnlladMjGIVfl+NLXygj+y72GLAzc/g4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pYPz00Nf5Wz9He6fu95/UMHKYdZjtS1p3v4O
grfZmlMtrRxOLGo79LAIwfc38py+ZD2Cv083QfpKbiCcPzU8Or+9K9CBb9NN
/z5RK4dvbj1KP6YHOnAk1L+8f9YSzg/ZvzMmYDGCf4HxW39vrqXDof09QdpT
Ax2q1E2ap+tYOmz9cyCUqT/QYdHr9DBrTUuHaQeiitn7Ah189zMt+Kxo6bBg
o3qGQW+gg0L4xT3+4pYOjaUHW017Ah3OaOWwcQhYOnSn9VXFdQc6HG/L+8bO
ZAl337fMgm1Xvlk4NPAcatzaEQgPv8QL0fN3tQc6uOeusHS9ZeFQuulrB09b
oIMUa3nYwvMWDmFl/csEWxH8RVLqORsmBDqgpxcAEIkBBA==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       116.789, 77.15199999999999}, {116.789, 67.79700000000001}, {109.203, 
       60.211}, {99.848, 60.211}, {90.488, 60.211}, {82.906, 
       67.79700000000001}, {82.906, 77.15199999999999}, {82.906, 86.508}, {
       90.488, 94.09400000000001}, {99.848, 94.09400000000001}, {109.203, 
       94.09400000000001}, {116.789, 86.508}, {116.789, 77.15199999999999}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sscerbvf0U4iIjMqj+/M8SB46eOoA1jpMP/
EwyT/m5H8E8U9M21mB8E57sW//h/pjPIQX7tUaY+tkiHo+6JWYnVQQ6lTlp7
QwUjHWZ66HfblgQ5nL7eVy4rE+mQHGGw/UNukEOywj6maONIh6T3BpsLsoIc
Cqx2aEWHRTo4bz51oTQTwQe5kSE2yKH6wMNVn+MjMPgw9XYczqKhdRFw874o
36zjnRwBt8/s+mL/5vkRDusmn6jgLwty2MZk/fTd2giHW5N+hRvXBjkcPsr2
SHxLhENBkdb9DxMQfJNd3Z5B6xH8U37ukiGuIXD+ogqnXPakEIemamtRpdUR
DswZxQoV+SEOjM+XVJvNRPCv1BXPmNSH4Bf3Oz1VbIxwOPegOGB1TojDXQmh
pCcFEQ6HZFcEN6WFODznvB/GC+QvfuhY2J4a4nBpn2umdV6Ew9pLfGkbUkIc
jqdUFkzKjnDom7aieWtyiMMmyQdNBzIjHGa0l1bcA7pnw4YHdQ5pCPfVaD5c
V5wc4dCju7LeNCEEHn65H53mWsWHOARqrT/vHxPh0Hj5TltPbIiD64VH15ZF
AsNzetmSiTEI/jprviyDjBAH9PQCAP/D9kU=
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{45.094, 68.895}, {53.609, 
       70.17999999999999}, {63.605000000000004`, 71.68799999999999}, {
       72.71100000000001, 73.059}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.004273504273504274], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{72.43400000000001, 
       76.559}, {82.84400000000001, 74.59}, {73.477, 69.637}}}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPV0zqtxYOcCB7fE0V+O8IAcYnwEEUoMc3vwo1HFz
9Mfgw9Sfurhx79Vof4dc/Svq64D8gvl5zNH5/g4L/0ek78gPclgV1NUxo9Lf
If/N/BPuRUEOT1iX8V5r9newvflM83pJkEPDfeMLXzr8HUrSzLmqKxH8ezfs
J/bXI/ie80W22rYHOdSkzuk72OjvsF1pa2XrpCAH3so/RytL/B2ijZfJFS4K
cogQFn7b6+XvsO7YyzDRy0EO965vXqtv7wfn986wEVIV8HN4u541SnN6kEPo
dvmpzzn9HJpeGphV9wc5KNTNDrzL5ufg9flB4PUOBP/BVG4jzWYEf4mqCk9Q
aZDDSdnw+UlyfvDw8D0SXFbug8mHhZ9BinH/3kZfDD5MfQl33fTEWb7w8PTN
Unu+d62vw+I9KhxBxUEOnUdvLdXb7evgFFyXzVUT5PBjY1Ve2QlfBw8z0Y22
rUEOCwPN9vy+7+vw8eqFf4fmBDls45586gSDn8O1p8VF8oeCHHjkz5sduOrn
sEbgEc+kvcEOfnKNrIavEXw1tt0Otq/8HcJ28t21nR3kkGKcx77ut7+DuHKM
0Flg+G+f7OfKxRrgUHrejK+6OsghJPcOuyZXgMPSyg8rXpcFOXx0yzrlzh/g
wLEg6dmZwiCHw5E1FwrEA+D+QU9vAPC9BuE=
        "], {{60.62239646, 
        75.62568744875}, {62.4774530375, 75.62568744875}, {61.54992474875, 
        77.834504815625}, {60.62239646, 75.62568744875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmlI03Ecxp0LwVLIBhWS1ywbWlgjkdTsIawZGf36/TxCK6WcpZV3YpgX
LTMyPELF3BTzmFlLNN0LlzablkdNRxNyGl7Tkg4tomJJ9H+l0IvnxYcvfK/n
cTuXRKV8KysrHidPTtacMlt8/2hGCKan40LkPQxPfAsnoo0E6Y5loq9qhgA/
MmbuJVhn2qGza2aI46V5CjsIVvbrJg9WM1gWDPGmFgJRwrxPdjHDD77/dmUd
QddCUIqPjEH4TeScU0VwzNLQ/CWDQe0ZahkpJYAiw+1WHMOMTYs6TUZgGYlJ
PxrMcKhv23JoNkHmgneg3mmNQx+O83kf6CrrDzsU0U4KQaL39+wbBHm7pOUz
dyg+HrCvQjG3r8dwQ1UCRUHe/ejoCgKvybBn9REUPUPqaXkN1+/E43RJMEWf
6rjHqJIgN1f/RhZAMVRivsRvI3jUuuzxYg+Fn4EYzM8JHmh666OEdPU/f8sV
lbabKIJM7Zo2PUHZyEBa1HqKxLqxjUtagthZ0zUZV+c5+4QoOwlGm1sVYkeK
gbdbh+NVBEahZErqRvFTa9OPRoJUqbFRJqJYfp+Uay8nOPK6PVgiplhsslOA
+5ejvGTJNpBiwl2QgiyCUtG9GudTFKMvzYvjCQRJn2sHJKkUFYLBWHkMwdOV
ReOnIorTMaqps+EEv+32zRQrKbQFLk44yc0Lt94b2L/GXUVbZrPm11jl0pH/
zpVBLItw15wnsE7WRW4OY5jTXY2wLyS4qdLu9spf81M7OKG+eJfBPVIkzKnm
/Lz+y7+pkq3eJ34l6J6rZRjcOX+B30pgOHPFVc7l6bLZNjmsm2CDw+3G8XaG
//P4D4yBM+I=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTv1wYkpGwMdDsi4vue2C3bwt1s6U+9soIPhsQ0R
b/2CHd6IG8f4XsLkz5v67d9BmSA4/9/UudM5hYIcgnfY3E68EujwU5ot7BpX
kMOeg65xZTcCHSYI/b10kC3IYX+d4H/+O4EOvaGGRhrMQQ5xotlJJ54EOnTP
SJ3Y9z/QgfFSf5bU50CHsPiHvi1/EHy5zImZD74GOjxrZ/XfW4nJ/1i9OJ/z
H5D2Nb6l3IMwb/LCiHulMwId1Dm/+K9lCnJI8c5+MG9eoMORR41CZ9iDHNIL
zVotlgQ6JO7hv/qKJ8iB+dER5/DlgQ5nXz/+M0MMwS9YwcH6WgXBX98UNHlH
a5DDwT63Gz4TgOHh1HtMLifIYf2vLXmSpYEOf9+lHzoTH+RwPmWlzYcwBD/S
cdnE23YIvuTqz8eytAMd5t7sPSSXFeTgLOdVzycT6CDocPTMzLogh0t370rq
8gY6tCz7c01kMtC94pzf6lgDHf4Y/W/VXIvgC76NnvLtLIJ/SKfqhMenIIc8
v5wb3gKBDtcmcVnVCAY7rPeVW75HNdChoW2SymytYAcVDiW/i9bA+DkW/tHE
JdiB6WHi/QSge42kar+2BQQ7bPBr5N5chuDvEVk/TbITwf+zKjGxaw4w/Aqy
Psd6BTugpycAs2kPrg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfzoiHP48kCHCTlaSdVLgxxg/Kua3GY1/MFw/vaa
Rxz2hsEO8Rcvz8ueHuigqeZXpOAU7OCd7axrUYHg277wZLRIQvBT2a/IOAUG
Onw49q+zxjLYITa90KzUJdBh40zvw9wawQ4hx/kCVpgHOhTnzPgzSyzY4VUI
28nJhoEOyQ3zz8z6FwTny27ulI99gOCv5pTbVn0+yGGno6+Wskmgw8I17/VE
9wc5dEyf3L/JItDhlLzb8x3rgxz2qTzJD7MNdIi6f7Px+oIgh29SJiG/nAMd
gic7WyyZGuQwdWPv9k0+gQ5+kmu+FfQFOZxPWWnzISzQYa1kcP+O5iAHu0BP
VouUQAdBh6NnZtYFOXiuK++ZV4LgB3MvE2ZtRfC/HT8lHT450EEkbUKhcUuQ
Q+qWrCfzFgQ6bE19eeM10PzZjruPOC0FhqfS1srWSYjwVnrZOdd4FoIPiw8A
+9uwPA==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtI03EUnRPyNRXmKxa+IPC5UMRg6txJsrIEt/vDSg1l05wUZWpZqVFL
LTS1mmmT1GmWCvkiH2GUWJlJmQY+KLBaaZaZSRSmaav/lxT6cLicey+Xc8+9
7qpU2m/K4/FMOHhz4HM4Mb95YnRFAe3wQEacJSFMNb3st6iAsazqqoWQ0JHg
wm/i8mb6P5pxN0Khbrnp8HqCrUyVUicmLNyuPNTlTpiygW2yhLBSFtA+401Q
aA0jzVsJQ43h3cIAQgl/YCmPCJJU0eveIIIuYeHMrIqbU9rn5ryD8NZXsMlL
Q2geU3wMjiIoHaVJN26t8TvDu7a8f7fGQwPsuy/ZMUz4yD4IIwhFkb2tJlIG
833KULmUYM5iayLiGarKikTXAwktbk7TQ2kMT89m2Z/kdOc394p9NAyP9ZND
4RsJMaeqR+eKGPbmh9kYRYQnPFlFoI6hc8B5XZOAcOB+Yu35erbqz1GR1vNr
F4NQsPQ7xqiAwZAcWdnDoFnU9ddaERrKdz6L5+rz2ZILM46EkBfHGtpaGDz7
owUeroTq4k+Gyw0Mv16qhXIPQoWdQh9fw8C7Z9yT60fwnco53lbOYPZdGSQP
JnybuBL9qpDBITMuWa4gZMm19X1HGFxHCua6lITKovyca7sZYs7dTP9xkNDT
Hj5rFcJQKnnw0z+T669bfqN2Z/Czi7orzybwYsUXu03XOH2xTlRP0ipPiEl7
ZNnIzXFw6hhLIVhaqD4PZhCsxxdP53J3neOnage3r90zsjWiJIvT+Vy2rVPo
TxCuiC2kXPy3H2Y2mNp7ETzSC1KLnQk19FAfx/1TXmeSOtiWoNbXi1w4n/7/
x7+gvyBX
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       187.27299999999997`, 209.49200000000002`}, {187.27299999999997`, 
       198.164}, {178.09, 188.98000000000002`}, {166.762, 
       188.98000000000002`}, {155.434, 188.98000000000002`}, {146.25, 
       198.164}, {146.25, 209.49200000000002`}, {146.25, 220.824}, {155.434, 
       230.008}, {166.762, 230.008}, {178.09, 230.008}, {187.27299999999997`, 
       220.824}, {187.27299999999997`, 209.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       160.806415993125, 209.37615644875}, {164.25178854, 209.37615644875}, {
       164.25178854, 208.507703813125}, {160.806415993125, 
       208.507703813125}, {160.806415993125, 209.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0m8s1HEcB/BDs5IbKXOc+bMTIlr+1da1vZmOVq0oRsdJfl/z+45p2tkU
1oy7lChZw27T2jy4ElEtbHeh0Bn5s5ZFO39uSS42rnIN6Tab31YP3g9e23uf
J++P9+XceGLD4/GsLAmyxNqSnEUnh9ZSgpwf15skv1gcmzEI+dkEmiMK3qUO
Finj9VdHNcx/TmLKsiVaFoL3ppYKPkFXo6OC7KXwi1uctA8jkK2J94vEFM1O
C8unYwgKVWyPVwbnSoMuU67kbKu8v/toPcVNeFQVRVr63alN19QUYpVCpw8n
SF2vTA18SSFNTxAEBxCoH/qKBrooCjQ+GRtuBMN5K2V1fRTzdtKkmp2cV2NX
D8+ZmW17b1bLZd8ZaI2vHVU9FCQoWLQxy8DsX6nb00mxr/fQl/JPDEIyU0qU
rRTJpoFq/xEGcT2BQ4mPKATqzd6QfgYBjroxaQXFuCzst1jLoHN27URdJQX/
bOhQ+VsGJUtv/IcfU7zzqvU0DjGoSbgTbtZSNND1ybwJBj+jtfNZgxQPkvuK
5UYGilWlaVRPEVVaZdphRdAXeb6r/yvd6gk5e/so09pDOLfbvJqTSwhu+yzl
+k5TqHvd+D6JBM4LomHDCIWzg6DjeCZBqMTk+ryb4tzBol1TOQR+9nfL9c2c
eReDqgy1nJ0K607q8ymiV1wL7KQEZU8bPD3iKSJyvc7csuybPmVvO3iAbu32
jcETZzcJmWThYC1s1Fwg255YbstSyTjXK4tDxwjBs6gbPR2fWUS8KGpopwSS
KNe2U9MsZv60FLpfsdzvFLjnGVjcy4/9+CGfwCXNZaXYyCJGGNM0U0yw0dfs
WWpm8e///gUWnE1V
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       174.29299999999998`, 21.012}, {174.29299999999998`, 11.656}, {
       166.71099999999998`, 4.07}, {157.35200000000003`, 4.07}, {147.996, 
       4.07}, {140.41, 11.656}, {140.41, 21.012}, {140.41, 
       30.371000000000002`}, {147.996, 37.952999999999996`}, {
       157.35200000000003`, 37.952999999999996`}, {166.71099999999998`, 
       37.952999999999996`}, {174.29299999999998`, 30.371000000000002`}, {
       174.29299999999998`, 21.012}}},
       CurveClosed->{0}], FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
       
       "], CompressedData["
1:eJxd1Gs01GkcB3BZbaiTza2LjeyiTjHMDGOGNN8aHJFbkVIu9TCV3KaUNGGT
NGiVyzbYsBpJEVEtkSi2WJw6No7L5LJJKlnJaVG79v+G/zn74vfi8+Y5v+f7
fM+jvz9se+BXCgoKC6jxoUaRGlGQy+cnYQQBW9sza8csMOflb6WGzis52LE0
9tZUDME704ZMLwcOzLfe2nc9ieBxxv2ppDAOwoRaFY5pBB9Or55deJEDw8Wa
Eq9sghPV5UUfyjhwU7U/IM4nKHL6pi64j4MFcX317CICY5XnyaaalvjzvtqR
odsEZgM+WndFljijfcxbr5pA2KCd1veatt1sllgazJ23rDChJaCfi/0itYiC
uwSKzYIp7408FObd0BeUECjr5PqqxPMg9Oz3cJYRqIVMNVa28KCarqnLlBKo
XzKcSvmLB9nx6LHDEtrsQyt/jz5JO9hmJOZoKEGyT6qL7CkP2kVnGosJQcXR
gy2ZaTzUq+upDu0i6E7kO6R48pB4bw1ruSvBl+NvUksmueC5fzcpsyPQtRYW
fQzjQtKdmP1uE5VfupnWmRgu2Ab3I11tqXwc43sD3nPx1K3mpcVWgth78tP2
4CEi9JytnTOBvCJYHBjFw8rzO656uBP4h5s5rCvjwQyjlwp3ErwymdR8N8TD
QGX8uK8PgVbd9g1CDSsMSnUkSSEETlcWF11ItMLLgfLvOacJtrkd/NemwQpn
V5XKLktpz+U355yUiEa7WoLJmQ5NvUwrRHR1/dDWTJDRtWJknbUVvBFe2t5J
sGRi7UjKIJVvlbJy8gsCtveVpZ1BtI1+fb85qpc77zGvgBEjMRfjfJXcgB4C
/k2+1hsDLvhN4bYlfxDUBm0zdO22hGqXKNyvjaBPbphmm2IJh+7C/OuPCOJ9
hcdc+JbwWi4Qf64gcC/o2fBllIPmHwtlhxqpfW84sl7c5sDATdRz9hlB3jOJ
4esjHPiHdK5f20WQGcOo427g4OHeRX3SVwT9yUtbZ6qo/j/Ps3QbpfrUsqcu
SJf22O5TZRwf83mbHLg6+/MhNnT41tGSQYKchSbCUwUsKBUvnlRtJai3Pbl7
VIUFQQkMPR8SVE/ofbR5xJzvu8/0hWndRCYG5Sd6qqh+Liz4R03Bl4mIdDEj
L52g1OWw0SCLieiC8uTLcQQeMcr+WauZiJTeifxWRDuhw809dB/tsuTRjGEP
gg71vOl4UyZCN+s3jTsRdFm3Gu/dwYTJ356fZ7YQ9AZM+7EjmfiXXStTpPoo
GR6fzbpOu1bH2UhrmLamqF/NfBkLGrE7U5/zCRpCrp1vMGHNn/dworMsW8CC
Q5hnoL49gfR2+2zbXhZ2fzrXo+tI0Kij9FJ0gMpnc3VlnCvt9RoJq7Z70j4p
jt/1my9BFkMm/2TPQuu2uOyqw3SeNt7DDwqj6Dw1ChzFjASCyuaJOmEuE0P1
DjX7Umn7r4vqmsqnvTFPsKyjjIA4vfVre8aERNDbebSG6nPS1dZPXGpf/27t
a48J1mhlyC/+woJm86ZACfWexQYVaoq67Hmz780GOpbTftC0OquGYY7Q4iNK
UU1U32JFfjk55qj6OoIRXE8wm884nz5jjgnBlteDlVT+d+K3HNtjAaZd5Arj
mwQqLeqnnuRZwO5WVGh7LsGQ6RL5zGMLKAlL8+U/UfcdX2TMGLCYv+///+s5
/wdvaZmM
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.008547008547008548], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{112.043, 65.24600000000001}, {119.516, 
       57.952999999999996`}, {129.25, 48.449}, {137.777, 40.121}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.008547008547008548], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{140.465, 42.391}, {145.176, 
       32.902}, {135.57399999999998`, 37.382999999999996`}}}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPUPrWdTkTREOPVGFd6Zf83BYdXmVtu65CIf8tR7r
o354OLivtXjnfRmT7+lz5TfzFDc4n8NXSXdynZvDOl+n3ISrEQ7/Iz6v1Clw
cxAP9/5QcjPCQdft4WLmDDcHKRHxiXx3Ixw0zngmXUhwc9i5quDLsacRDspB
mxTmRro5xKRP/SPxJcJh5/2VMzuCEXyvz5wXHdzcHBxluR/ursLkv5PQuzsp
zM3B57FFjlIvwrx3ZnEFJTMjHKKMz8+9Fe/msP9BQdHc+REOU569UpLIcnM4
xGYjbr40wuHcTLYVoSVuDnHlp66GrohwWPFj3feN7Qj+28If7GFLEPxstR6V
j6nuDjIqPlneE4HhsYyxe6+RuwPXhF0MEmURDmz/tzVJSrk7aP1ad+5dOIK/
5dpq5Vv2CH6Jw8+ITJ0IB/crTM179dwd5m32F+SVjXDQW1g4fXO4u4Nu8ePV
2nwRDqJ5D1avbHB3OLSGr6OWLcKBpf0p5+UtCL7e73lqud8Q/IlVt/sE7T0c
Tj4uzPISBIan25/CiloPB67Hypa71SIcePV43Let93Con6v+4LwNUP+6aQ9e
PvJwiC1LL4wHurcw9OGL3t8eDtxP2uZuLEfwxVdt0ZDoQvDDHdI/d8yNcLjA
uOeJ9XsPB/T0BAD8cw4Q
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHVd+6mroiggH3V/Wh8qWujvA+NtK/mZWVHrA+TVS
a/j/7fFw2JV20yBrRoRDXG7zowP3PByWMXjuN6tE8GfU+k82S0bwD8y5uc4h
KMLh7bongpVnPRx2/Ck7Uewa4VAQUtcyfZWHw/oYkUfLLCIcPv8U/7613cPB
9RV39CSjCIcrimrTt4Yj+G7tv2yspBH8FBPlrPKf7g4i14P2KJpGOPhVHYte
dcPd4bHOTMWNlhEOCxOKz3zc6e4gueslY6hdhMPB+7MY9ee4OwRusHz2wyXC
YZN7Xt6JVneHD26TPTf6RjisDLZ/nVju7qD1a925d+ERDhkhvTIfE90dZj7z
m26WGuGgt7Bw+uZwd4clzrVyc0sR/HULVi9lbkPwA2MvrA2dEuFg+pb94bMk
d4cDngVlcxdGOJS92bk+vMLd4du1A2GOyyIcqtMCP3bVI8I76PMvi+d9CD4s
PgCUQsK/
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkl1Ik3EYxTfT1ErL0BVaVtI2CTNXWWqQp8z33ZvK0jD7NynZUNOYH/P7
I53DKNFmKi0V04WQlqscW2llTaPSyq42pxMNCS1oFCUoGFrtykEX5+J38Rx4
zjm7JNkJqWtYLBbbrj12Odkl/tOq+6QgGP1sUPePM2iotTUorxAsJq4XJY8w
2KHS17rmEXDG9le33GfAJFpmTqQSuNyU9f29wWA6InTnipggeUGXUVrCYDyp
ffJdAkHVj5yZbxIGztF1Zs1Jgk4fgUgsZNBS0dc7f5xAJTZDxWfw+pyHTB1K
wBrq/rLZJgR3q+JuUTDB8neqdJvawY/zWl2UgQ7u1rpzuG9oLA41dmsOEmwo
1QVGyWl8aMgRSUHgLbtM6/fRyDCv+ChpAom1sXDYncYdf99bRpHdzxj51dNG
oYutm5o/a7/fWd1SY6LwYJYO4EkIpIqRGOcBCtu5hquuuQSnmjOjD3dQq/m4
xQXsbaqgwA/myM2VBILB4rlD2RTiF8KGveQEY3Ntv65VUpjNbXZ6n0aglVPh
cyoKPfzyqrrzBE/SCgZiblOwemeWSc8QzNvqmZoeCiaBKTQkjqD5aWy9p5HC
6O/s01J7XseI23SThcLLokK+NIggRO5x5MU6GnpfoWbZj8C2xKvfGEmjJD3I
z+hFkO/7vCspn0akYZO6ypVgJUI02HGPRuek0iRxIvj50XZhedbBigjOqyKu
cJXTU0RsQZsQPhPPrNPeBF7sLL3WmcHbLVaPkHD7HsovEkuyo8/rhvZL8QUM
1j6sndDE2vv0sxSM1jCr/+U+8iymWxloy4T+vBSC3qmho/09DERhMl5xFsHu
qCXhgUEG/+/xH/xpJGA=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       102.973621429125, 48.33271844875001}, {104.94243147600001`, 
       48.33271844875001}, {104.94243147600001`, 47.836453313125006`}, {
       102.973621429125, 47.836453313125006`}, {102.973621429125, 
       48.33271844875001}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4omT1r+YURzl4HxIoa5gkacDjC/lf+romY2e
DoUau6UOTYxyUHH+6WF8wNOheY9Py9c1UQ6/zi+a0H/e02HSCtctX49EOVyM
8bnx+p6nwy8Pf2Ou41EOmXucIq/fQfAFv3hklVW6w/kzhKvkTsS6O5w0nTZl
5skoh15fn8mJ3u4O/w89K7E9F+Wwy8qq18LZ3eG8hO6tM5eiHPwUZp75YOnu
wHHGI57rbpTDRjdurksm7g7CmuXPCt5GOXguY+zea4Tg8yo+/1uv4u6gs76Q
S64Ukw9Tn9kRYfK1Jcqh/n7rueOm7g4F+3eLHeqPcth2YJE3q427A+9Mz5sP
pkQ5hOboi6m4ujvcfddvVzAzyuFQ24Vr2X7uDqtvX5v/f3aUwzmff4mXEhB8
N92zaxtqEPxt6l+Vv6Z6wvk6ZkfTF9d6OgjuF6mrmhXlcCH6ZfHXXk+H260T
rAqmRznYlHWZ2E73hNvP1znHKm2+p4PNe7Pr2/uiHFYnaf1tWeLpkHVH5WJf
G4J/LnuaUEEzgm84iSMgsA4Y/tGzndIWezpM9q/uNCrHjG8YHwAlAfKW
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4qWsCa9s+qMdzjzaMm3HdU+HFYe0u69NinZI
dVotvuQqgr/k5vKVegXucL7ewsLpm8PdHe7+Xn/uwdRoh708llMt3N0d1i49
dIFzTrTD659q/fz27g51/lcvGS2KdnhW3+97x9zd4a116eyq9dEOT9ZOcL1j
7O7wKzT/cNXhaAfPZYzde40QfF7F53/rVdwd5pca3V1jhsmHqS/Pvq3B6YEw
b1PRYa8HwQj7ArYGCP6PinYInmXAp+Lo7tD5P2eSTXK0g+paJxFfT3cH1Va9
HQfToh0YtjTPvROP4G+Yf9VkahOCf/eEz5UZQZ5w/qemlY9Siz0dOlYv+Loo
MdrhJH+w1qEmTwe/Hy0FqeEI/pPWmpcBgQh+xf7lRxd5RjscS9/1oa/e04Fn
KRtrtEO0Q3+M+dKWCk+HpREnlR7YRzt8CVnxKrXc06Gww+XxVbtoB/U9umoF
ZZ4O17ObDgbYRjv0bpmXHVjq6bB49t9GN5toh/3SKsujSzwdFhr9q3WzQrhv
wT3Dh2ssoh26Hs1PDiz0hIffh1sCK40KPB3Mr2rEzTCJdghdKa3gnufpMHdH
mo2wcbTD7oU9qRq5CL5Wn45eQRXQfWjpBQA2mQSe
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{114.39796986112502`, 48.572725768750004`}, {
       114.39796986112502`, 50.325279220000006`}, {114.92673598800002`, 
       50.325279220000006`}, {114.92673598800002`, 48.572725768750004`}, {
       116.67803940112502`, 48.572725768750004`}, {116.67803940112502`, 
       48.03645941312501}, {114.92673598800002`, 48.03645941312501}, {
       114.92673598800002`, 46.28515600000001}, {114.39796986112502`, 
       46.28515600000001}, {114.39796986112502`, 48.03645941312501}, {
       112.64666644800002`, 48.03645941312501}, {112.64666644800002`, 
       48.572725768750004`}, {114.39796986112502`, 48.572725768750004`}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdp0yytrpTiHnqjCO9OveTjcvVex+6ptnEP+Wo/1
UT88HKp2sNV9ccLke/pc+c08xQ3O5/BV0p1c5+bwMELgL4drnMP/iM8rdQrc
HLySJBtkPeMcdN0eLmbOcHPwlX+qsN0nzkHjjGfShQQ3hzdb7VryQ+MclIM2
KcyNdHPoL0ruOZgc57Dz/sqZHcEIvtdnzosObm4OJRo3C1JexWLw30no3Z0U
5uZQ/47tz6k/sXDzFJ10GGQ54xyijM/PvRXv5vDptR2TG3+cw5Rnr5Qkstwc
vgpyLb8vEudwbibbitASN4eJTTNS/4nHOaz4se77xnYE/23hD/awJQh+tlqP
ysdUdwd/falfnxmA4bGMsXuvkbuD7eyOCQeexjqw/d/WJCnl7hDLWhs3/TiC
//xh5eam9Qj+cu/jLwTnxDq4X2Fq3qvn7nBxn+zCrT2xDnoLC6dvDnd3SKjb
aH2lNtZBNO/B6pUN7g5ft98RVyuLdWBpf8p5eQuCr/d7nlruNwR/YtXtPkF7
D4c/7+x/fWqIddjp9qewotbDwfbdxxPJ02IdePV43Let93DYtOJrfsUaoP51
0x68fOThMKHRlJED6N7C0Icven97ONi9D9GNeo7ge21t2nHgJ4Lf5W3abMgb
53CBcc8T6/ceDujpCQDSehWa
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQPbFpRuo/8TgH3V/Wh8qWujvA+NtK/mZWVHrA+TVS
a/j/7fFweFu4/IAQR5xDXG7zowP3PBxucov7338RC+ef7pBVvn8Jwf+8fLnd
y4OxDm/XPRGsPOvh8JrdNUJma6xDQUhdy/RVHg6P0h8V+q+Idfj8U/z71nYP
h4qvN19ZLYp1uKKoNn1rOILv1v7LxkoawU8xUc4q/+nu4P5IwefUklgHv6pj
0atuuDuIWaRvjFwZ67AwofjMx53uDj5Ht0/8uzbW4eD9WYz6c9wdWnazly3c
EuuwyT0v70Sru4NyUOLNyL2xDiuD7V8nlrs7xLLWxk0/HuuQEdIr8zHR3eHM
Rxn1+1diHfQWFk7fHO7ucN3Pe53rUwT/4epK0zVfEfyWjHm2/5jjHEzfsj98
luTu8DnEjs1NMM6h7M3O9eEV7g6aj/qevRSNc6hOC/zYVY8I76DPvyye9yH4
sPgAAC8ayJY=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+/UkqyYRl2OOFEppVzXg3O9o3533+Vh65Zl7r4eNk89jPWg
cKilODWUQ+1SmYTQsvKYhSakizoueVi7WCqsedjcao3uL7b+eP3x2j7b5/N5
fz6O4bHHIpaxWCy2EVcjJkZW5KyaTzpDsavl0jdBLIMPJo12n6MpVvrx3HJT
GHizZpykSRS2IWNst3sM1u/v6bZWUmx/UNHdXsMgTRqXLb9NoRNFcX3fM8gU
mOpy1BTPjpSVDI0ykBHOUEMxxRaXi9PKBQYdFr/moyooRPrehUAHMQo97ni3
1VO8S1wI0srE8Ix3NhttpujxC2vvrF7ypJaUy4ftJYuuTLeIK7oiwUmNlWlj
A4VzY5T8ap8E+X/5oYYqCm6HWrR2HcE2QaiQPKaICbfushMRnHDyFzjcp7BR
RAd9khFIUTc1qaJott1UGnyeYMzZxr3kBoWaF+E+kUngEzO9WZpMoVc/RXYp
Wcxn7rh5gKyT4GGlZiM7lkIz8iK/vp/A4u7pHxIFRbC/QuXVQZDMXV2Vk05x
rVXr+7WOoDZy647ubAqJsL65uJwgI8GTbyigOChRCr3UBFkybYJrEUXkT/2k
Pp0gL3ePzGDMa2rQsnx3HEGxzc4MQysF+7X5UTMhQdU5uQXVUjAHZuZqTQm+
uySo1MMUmRln+wq0EjgOqjgDY8b66C8vAwolePWcN2yYoFijO8SdDVvy6t8m
bf6OS97V+zYt74kYvrXjOsUAhYNHhZbjLYY6XlPkWkONfd7wOONL93yUmrjh
wkcGwXpOf4NxfneOj+WfJmZxv5uz9svLKhnUWMlv8bMo/NtPee1VM7AK3Kcc
SaUYDOF7NF1n8P8//gNCPSzm
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       172.621, 134.105}, {172.621, 124.74600000000001`}, {165.035, 
       117.164}, {155.68, 117.164}, {146.324, 117.164}, {138.738, 
       124.74600000000001`}, {138.738, 134.105}, {138.738, 143.461}, {146.324,
        151.047}, {155.68, 151.047}, {165.035, 151.047}, {172.621, 143.461}, {
       172.621, 134.105}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltI03EUB/B5wUv6MDKbW6tlai3UmqmYIOM0vGVKuVRI5vz/PEuQvDFB
jGVa4sbw2lXS4T0HbklqYeVda7XSvKA9VGRkC6dkpOUwQ/o/9Yd6+D584HA4
nHO8M/Kk5x1YLJYdnUA69nRst3QJ7JcIuT9URpOWgmfanNTsboShMDXrYzwF
X0p8e0QO//ucojzblEhBa2Hx6ooUYfQuW23poKB7s5CXfREhfSvCr22KguP9
BSJjJUKxLmuseYNxzaI58yeP/LWz5obbo0ACO636yfdqun40zfgrgoApku0i
ViHIf1enGWIJWFwXUqryEDqbD/rEJRFwyOxqkVEI08q1cm4qAWXv59vrCYyv
fC/NjxIzNuj5DwaDEIZXhtn8FALf5vuITIiwKaw2X0sg0Jjz2Me6DyE4U3bV
OYrAYkPSjMYTQTrmP/kmlEBrotbxujuCP9s8+05AgDgPhenoffR/2oriHiBQ
Zxtws7oilK2OC0+LCUjN3vI4D4SbyVWhRVIChz3UvFkBwkbk0NJSOoH99mcG
50QIGptmPVFJYCKAe0wRjfD8xNmRGBWBkq8xh15QjA0T7EZOEWOJEfzmKxAq
fVfzOgoIBOe2nyprQNi97DOFCgJNfS02nQEhJHqdG5xM4O2cU6y4F0HoXquV
SxjbpQbWYABjj0t3Tsp3EHhd39aX1YygvtckaLRQMMLprLDS981YcHeKH6Sg
9ujeuLojCEZPXrQll4I7ne2L/HrGivoI/VYbY1+RizKInqdbUjoWnk/3kzl/
4NxHiJFwe14VUHBBH96vekj3f+LFXyukYI9gdlfIAIJXOmdt+zIFM+PTy/AU
YdvUJXCspODf//0DbYc/CA==
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{158.195, 151.21099999999998`}, {
       159.406, 159.441}, {160.89100000000002`, 169.562}, {162.285, 179.047}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.004273504273504274], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{158.82800000000003`, 
       179.586}, {163.74599999999998`, 188.969}, {165.754, 178.566}}}]}, 
     {Thickness[0.008547008547008548], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQ3eljvKdyT5KDw8rAxT9/pzjA+HvN2xgSvqc4/Ni6
qNuwGpMPU6+/5lP+1cYkh2L/AhHzPykOM+8nHtzWluTQu93IZA+Qn35mhZJb
Z5LDF91rT5j/pTiY7XzffLU7ySFmSeVU7/8pDnP1J5vI9iY5fH+1sHUuYyqc
r6OidnI5C4Kf1C5wu44j1UEmUDclAKhf8mTCXiW+VAeGMNaif+1JDlmBN/sl
xFIdJv85Vd1cm+QgIv17dZZeqsNW3c+vV1sh+A9iRV1f6iU5bOHvXFsikOow
SfXc00jdJIe6NfNmz+VJdXAVfxsyXQdo38ayld6cCP5app6ZJWwIfr/XDLZO
oPv1/0evqDBChMcFDel7f20x+bDwOykQnOLPjcmHqZ+1KzWtQhARngGX/Kv8
xZIc+KbNYOkEhp/8yz8rV0smOcQlupo9ZUp1sH6iMuevTJLDw0sCN+vYUx1U
z0x+f08pyWHronf1jsKpDqt+aRkLaSc5rNA6sPO9aqpDw39LvoCEJAdhh+9s
KxenOgTUP3Nck4rgu/3cEpC/NMkhYwrv+zqhVIdpRxKbTq9McvDw3NJ5DBj+
Mxp1lVPXJjmUz1/YPhdof3peScuX9UkOE0r+XQllSHUwjd79tHlTksPB9u3F
x/6mOMxLOZIxYxvCP+jpDQAvSx86
        "], {{145.96224046, 169.77803144875}, {
        147.8172970375, 169.77803144875}, {146.88976874875, 
        171.986848815625}, {145.96224046, 169.77803144875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxqezgzqbacOmkrk8pOmooNQieUZRIC6hpRId1P/3/ROVUJBy
N+EKtNKwnIPU2JwkZnRAUURN0240T5nzQHmYVjLTbDozj7j6rhx08Vz8bl6e
9/e+viT9AuXzeDw7LsFc7LmsCiTWFjcGoVWNAdIKiiJFlFkoYrBypm9PvJ5i
5KI0zeDMoNVPTEzFFOkNrSKLA4O3g9PmbDVFxKH0Y3Ieg/455VPdQ4r6xmfq
2g0Cz5cHG9dzKeTVpcKyFYJvdZ8H41QUHvLqzY7fBFdzZYUHlBQhJ0dHxb8I
msrqmxxSKMZLNMq8GYK1YJ1Ph8LGyYLMu4nhNq4YKTj7wIei3axd080RbPaG
d39yoqgeFshViwStXT8NIess/mYpqoXLBAb/GmPNAgsv7dcM6To3L2GsiT/D
QrfrtfsHK8HtrBvJku8sfFXK+iQ+A/Ujq7tsnMUlvTTF4MSgQJRscBlmt/w0
28f2TPWyMFYkGMM5f7llqU0uXSwyd1rux3O+5qsyT0k+smhu11fWbmPgL7gW
s9bPQl/uZtLYMQjsDFpQD7EIK3ZkVJsEt1IzFJIvLOoCIttMqwST2okKvpHF
4XxBjIrz1ZVzfnWK6/eiUxih+kGwvacvZp7bx++p8k/0JMFS6PAU38ri3vvZ
o9JRAo/jG7OxzhSz01cyhMMEEZH7Lc/3UnhviISqAYJlskOcHWhjT2uhRRtm
46JzibLoWIqhtSPqljGCd/PToWnpFG/EslcmM0F2wfUnN3Ns99R6L13W5FP0
sqW7y7j+J5bv7Kt9TLf2i/NynejXUJR3K+uS7BlUmppdpSUUi0H5DXmODE63
RQ1E6yj+/8d/A4tAeg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHdX0LWVVc7KD7DGNH0+TUx0eX4vwLZ+Y7HBt1r01
YTmpDpsOz1/HNgWT39PEyOB4OQXO38MUeubJ2RSHZ5NV3glMTXbY6dqp7X0q
xWGWxEp96enJDqwHWV45nEhxkP7Ox/BiRrJDy6N5kiXHUhyyD+02dJmb7MDM
Yum5/EiKwx6Fc6a5S5IdMp6XqSsdRvB93viZXtif4rD+N8eKfemY/K1fw3c8
Aarfem/+248FCPPaOja9lypPdgiwaVhhBrQv7+7uAv2qZAd5zeOcx4DuKShQ
dP5Tk+zwVpQvO/R0isO+FRmLuuuSHZbo/qjTuYDgf+3mag69juCLVOp77WFP
dZCpX5nDVpzswHPzTPL7XykOIlsfbM9JTXaw1t+VeOxLioPKq1tyEWEIfmZE
5ElfLwTfk5chZapDskO3ytnE9z9THO66aTs8t0h2OHr9xTMdllSHpWqlvWWG
yQ7/u1hysvhSHQoOd1XP1wXqv9h6uEQawXfV2+J1WxvBl/M7nMJil+rwOW7P
G1bjZAeNxm7Zeb6pDlPiREP22SY7/K06P0k3KtXhnPX05Sc8gPEjbVT5Ky3V
wVbDvEAA6N5rR1yqlXNTHUTuu7VZpiH4Uofuns7JR/CteM0NVSuTHd7lW//i
y0p1QE9PAJa2Ewg=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvW9FxqLuumQH1rzZG+eKpzrA+MvPdEvP80HwJcu+
t9THpjrkKHw4P7Us2eGi11rLD6mpDolv1cX/pCH4t7S1Gf9EI/h51h/4GoOT
HUxnt7rOS0x1yHq9b7aUb7LDNBadR08jUh3SZvdqbHFLdviWe6lONyDVwTCJ
8+lK52SH99+vpum6IPjegt4T+EwR/Mk2U2/P1Ul1mHFjzdSPLskOvHz/pmep
pDo0MAd4WLonOyxy1yzZI5PqIO1VYdHtmeyQpV580Fs01cHcdYHWXZ9khzTG
FTKb+FMd2gV8YywDkx1SXO5US/CkOqi8uiUXEZbsMOWIvscetlSH6AdazH9i
kh2OXn/xTIcl1eEB3yE3/VQEP802sispF8HfPju7r7sk2eF4lt/On0D97yfu
LtKvTnaY/urXm1Cg+V03Hic11gLD82TCXiU+RPj66Xif/ymI4MPiAwD8ILaS

        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EYdXNhksMiyRBFpylYXujinCB5NCtSEavZiFqm7/fOC5GSl1LY
KsO1TEIbyyK7iZiXIqfidDpxmmuFa14SvCDdnJqQSZTJKOv75aAf58fhgec5
5zxHkJF7jDo7OTlxWOxkwWVx6cWT8wmNBMpHOXr+GwYzWcWK1XqCHm7q0KyF
wZ1MDUfYQhDrooxNHGfA4fEknjqCgxJdu3aaQWSVOLK7myA8Jmij+iMDPddv
StxHMHelaFE4zyDALVia/ZKAF5Uj919icDJ3ay7MBDcyOcbUFQYHri5ULr0l
CE2uqC7YQKH2D/8hHyX42l+3p9XLwe/5hghGIhz89NHN0oZkiiZLYH62lcD5
jGziLKHos3X4ql6zetPbhnkFFOWlQ3ztIIGHuSr/lZxCUDxQXmMkuHxLVl1Y
RvHQZXWeayDIKRpfPHGTIqvkqUtaJ4FfZ6DFXknh6a1xFmoJLmwTjQTcpev5
/Iq3ekgeUwwaSv+6NbH6G7qCwuoo/rSNfm5h89pybZfMnZ23//Q3iTsIpn1j
xaIaimEvrTJfT1ChsC83sPuiduhdVb1sHsawFHcNRY+m7JlggGCsMT5axN6P
2a3zUbF5CetTmpPKKUzf2/aqxgjsadbjcayfJEHixe5pgk1r5t7QPIov9omo
qQ8ENVuCV2wZFMp3st+rNoISV96yOpVCbHwuVS0QGGa9zT2HHHwulN+qFjr4
udn9GbbtFPf7q6YS3hPEResKTWsM+mtL+wQWgn1dhiOmBcc/iXvz4QefGNRK
gk9ls/pNET5lihlm3Z80xIObM8nAupzQWd9FwE/PHOazfVLcFrXLWwnyrk/y
v1kZ/N/HfzLMNrk=
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.008547008547008548], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{143.566, 121.74600000000001`}, {
       136.395, 114.43400000000001`}, {127.15199999999999`, 105.004}, {
       119.012, 96.703}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.008547008547008548], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.438, 
       94.17599999999999}, {111.938, 89.48400000000001}, {116.438, 
       99.07799999999999}}}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQLbv7ZuTlrhgH657AD6fPxjjop8zTyl0W47DGdG/k
2nsxDmdsdd52r8bkS7IyMzStiYbzK1hXzTi5MNrB+J5pzoK1MQ4l3ULh02ZF
O8x5bvd+y8YYB+4mziuN06Id5i/hmuC3NcaB46it8YtJ0Q521imf2fbFOLBx
FE3y6492ePi943fEmRiHi+fe+rn0IPgzb8zNWtAa7XBs7b/7v4Mw+Tmv1xec
7I12uFisk52UijCv+Hhg/pbCGIdFFQyBuUD7XApTCu+WxzjYB/UJ90yPdnCf
ri9WXhvjcEdb5tqqOdEOj9n3XZnaEOPgEf3hb8QyBP+1uCjb6i0IvtanuCkV
ojEOC7fYZ3ZnAsNj08zj935HO/QrrPsf7gcMj7iSwz3vox3Wdy06q2eA4Fum
z1eSkkDwf154E76SJcZBwnPW4Xs/ox2UXZwFfL9GO/Ssv3g2ki/GYRPz9VXZ
z6Id/oty3riiFOPgbsvUvvdetEPZIu72lzYIfk9MxtRtsQi+7Zy2kxxNMQ5+
JamZXS+jHQKZxK1tFsY49BeLW/z+F+3w++s81ehdMQ4setL3+YH+4DZL+fTl
cozDI7bogvn6MQ5rOzu/uT2IcZhQUjXnoz+CP8dqhXpEEoJ/50LUpxOlQPp+
2RfZWzEO6OkJAARUHjY=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zh935WpDTEO3HfMkq1NYxxg/ICZ4uY28xF8ozfv
OP8fiHGw/35Gf1VBjMOSqVHFDy7GOGhPtNlXFojgy/I5TyqzRvBddc+ubdCK
ccg24+62ORnjYNubdXyzbIyDDmfEkdPbYxxM3rI/fCYQ4/Du9pK/UctiHE5V
/Y+8xBXjcO/96rNRfQj+DKVpCrIFCL5apdZ26/gYh5npbrsTeWMcZGT+6F/1
i3HI2Nuj8FEQaG9/0IsK+xiHeV53GaaKxThc9XvWNN0gxuGag+5TC6D955gC
LFNUYxxKr7d5fATSJzt2fDeQi3FY37XorB5QnUZn/IQK4RgHuXKnaWW2MQ49
6y+ejeSLcdC8UiB71xfBNzacv8Q5DsG/9vbwmqk5MQ79V+cUfQbqd72VXHq3
MsbB4OrXm6uB5lenbwltrAOG56SDVa5KiPCdGzFt3mdNBB8WHwDd5ryY
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUnlI1GEUXI8ya+2UEHU1LY9ULBevWs2hLNksrw6U73sRapJlqOlaWaFY
CWlZCYoZKbret4G4UJkuJkkeUN5Ru3RpeZQdBlba759a6I/hMfB4zMwbm8j4
sGMGIpFIT4CTAH0B2pycJqsIAgtJ2s+DCOstNTfVRPh0tWhzwx5CmVVlVkAg
IU0u7ezxIvS969Zc9iWcqe5/uehEiHzqaO3rTlCOznr6WhP4xK1RY2eCx+HQ
09/XEbIG055rbQldsc3V9UsJVqtqG6UWhPviS7YBcxzySVHckAkh2e+UwniE
o6YqqbxV2Pt6yMcvp17H+83eG3ak6Li8RXJ97W6O82GZlVox4eedxPwSC44Q
2+ggpZmgN2+4PGKeYSZ61lQt6KoIjHwYNc5g32iSv+gg3GtTKYxGGFxyy15I
3QjzM2N9/j0MUoXMJmY7wd76t0NGO0NpS2VmgJwgce4rs7jH/uVzdklNQXcJ
Q12bcaJpOMHEbzDZopBh6IpLV+hegiZ0PNW/lCFW/5recj9CoNmDoi/VDFtV
8ek9noTg3ANau2aGI+WUqnQlTA9oK/xVDOHqLvcEO0KH7JHcSM0Qmh0VpjQn
5K24+7m7l2HXshP2SkOCuKC4+JXgx7tWVuzzjeMjq+s20udY+GFtvviBwzVu
brDWkqPT3zCvQ8ORdAGvg704HE+mPCsd45h6vFK6cFDHPX5tfCNT6LjjjfaM
giaOwuMNI5Jpjouafjb0liOwqkecsIYgkvS6Tq7W/VO2baLVUULI3pE2rN1E
UEwZ+MYIOf/1V++5oU25heAm9pHEeBP29Z6z4cIceHLUTiX0LDM9r+L2TsL/
ffwDDoUmmw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       118.35252742912499`, 113.87178144875001`}, {120.321337476, 
       113.87178144875001`}, {120.321337476, 113.37551631312502`}, {
       118.35252742912499`, 113.37551631312502`}, {118.35252742912499`, 
       113.87178144875001`}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYjHlxc9veMc5iDloOu4wjnWA8ZvY/qWkWcc6
fNuxTpIpK86hrWHqsplOsQ4cvg7Npq1xDp/csk65e8U6iFtabjadG+cQy2v/
7mtgrEP9TScjr/lxDpq2u9a9DkDw/0bYmlvLx8D5B1+ECqYIxjj4HeucfHNh
nMNu1v2nDThiHFqCbxXXLotzCPqz1UOGJcYhZKXCTZ7VcQ4y+akZFf+jHXpj
bOK8tsY5+DbJsb/8E+0wY2fW0w1H4xwkN808fu83gl+dz8N44Eu0w0b7VM44
X0w+TP07CR9j09g4hy3nol8m/412+Oq/XpQpI87B3/7V8iaGGIdJmrY3FHLj
HOSnGvAKscY4JNU3224ojHMIVWp8u5UzxsEg59Q8+5I4h2hWCeOXQgj+9NL/
EQcUEPwLRcJTqkRj4Xyuqt9bAxVjHab5c9TuKopzuNPDu6dKM9YhQazFckN+
nIOwVNwcOb1YuP01yunyxkaxDgfrta59T4tz8BJY13DIJNbhfY7EhXNxCH7w
n07BDdEI/jalP34Tw+IcanvSlI2BfIkHeR1F/pjxDeMDANkl2aY=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYq1pwS9r0uMdogOKfWP8Yh10g+W7xLLjHdQb
3vEG+SL4x0+/CZsuFQPn96y/eDaSL8YhqWfxWYW8eIfg1K0+MmwxDkZm2857
lsQ7vIpec5KdKcaB+cGJi0VV8Q4v5j3QyPsX7VB0JmPWrvZ4h2emD1Xy/kQ7
1D9LOrRrdryD5KaZx+/9RvCr83kYD3yJdlBhU7vzhg+TD1P/5/c5dU8FhHnm
zNs9FXQQ9l11dRGwN453kNMx5BRijnHgm5AwscY63qHd1KpHjT3GYZWo0nZG
+3iHrztuBeQJIfhn1zXPOaWM4Cc72+ec4Y6F83MX5H42kol14LWZ8uWRZbzD
zTQn8YfKsQ6XOyryl+oj+JliBS8maCL4f/1nH3mkGO9wQ6isyl0p1mGi6S/m
2RLxDja9W0IOycU6aL3co6gA5Odz5n43AvK/SVg8EhWPd+DYqy+6QzbWIeZP
6YEJovEO1pYvtmsA+Ro6HxvaROIdrrxZdXUt0D1qhz/WtAkh3Kear/rgjUC8
g9WFF5s1pGPh4ZfjszBsplSsw55UmdgbPPEO8zerTVosGeug5BllHcwd73BJ
/76JCBKfU01fcoc80H1o6QUAZe/pPw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxw+nkIfzkJxDoXm4Ua15bst7N2rpKk6hvr/ffCt68Hge/tDs
arnUSMW0FitDqxNjJKMHKdmu4zA5FVnjzDWjMss/N6rfX27rj/cfr33en+3z
8PY+kytLt+DxeGacxJzMOd38O/7mqzmFXfREoaiWYLmnZaSMR1Fk2Xxf00Dw
tFudoLamKLG3Vd5rJ3A5HqZqElCUt+VcPNtLEDd7/YZ0K0XqZanAT0MwLJOJ
DUIKrdkPXbaOIIwhrUZPCut8nTFGT5DVF9s35k3hPGpe0rJCkDTmPnslgOLU
A7fdCwIGT/JPxzgEUUyXHkpP22fivdEpksY8E79o3PEy/hGDXs+U90auf/Nr
bfs7LYPx0IVcoS+Fsv9cg/VPBg8//mEl2ykCK32/3zZjEaJZnQoWUfA8h3ct
Clh0JIsj7rpS6JaaJ1o9WBQPTiYvO1JI5IdrV/1ZiLPUiWobivkgeePBMHbj
Pr/K6gLbDrD4Ytd1rM6CgsQXHGGOshDwLUMknN9nU7LWi6urY0+4GhwouqNL
muT7WcxlzH3iu1AI13/PJoSzkBYunRS6Ubgo2XqvPSxG57vXnnlQqBLLiuR+
LGRXF7KFPhRZ0oakGncWkxKDUhhMsdpXp7rGY5Gap1BLQym2rVUpiIHBWtyW
8swoikhf2dLQEIOanTXS8mjO72Q149/B4LzjTKtQQlGsiay8VG3iYeKe5l9g
4qkPioHBcAZtTgPi6QiK0qKcxQoLBhMrzwWdfhQX8ourKz6b/qn2SroTNUTQ
pSItRm7+W5lRNutvycZ+r1IC+LoeAj0UVhHOFKL+kXoRl6cqfQbfwZZCb98p
+vaY4P88/gNd+x+y
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       229.82800000000003`, 77.57799999999999}, {229.82800000000003`, 
       68.223}, {222.24599999999998`, 60.637}, {212.88700000000003`, 
       60.637}, {203.531, 60.637}, {195.945, 68.223}, {195.945, 
       77.57799999999999}, {195.945, 86.93400000000001}, {203.531, 94.52}, {
       212.88700000000003`, 94.52}, {222.24599999999998`, 94.52}, {
       229.82800000000003`, 86.93400000000001}, {229.82800000000003`, 
       77.57799999999999}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{215.47995890875004`, 
        77.11208734874998}, {215.47995890875004`, 76.21519671749999}, {
        214.06680928000003`, 76.21519671749999}, {214.06680928000003`, 
        73.87890599999999}, {212.97304021750003`, 73.87890599999999}, {
        212.97304021750003`, 76.21519671749999}, {209.03984666875002`, 
        76.21519671749999}, {209.03984666875002`, 77.11208734874998}, {
        213.44992352875002`, 83.32907069999999}, {214.06680928000003`, 
        83.32907069999999}, {214.06680928000003`, 77.11208734874998}, {
        215.47995890875004`, 77.11208734874998}}, {{212.97304021750003`, 
        77.11208734874998}, {212.97304021750003`, 81.91373353312498}, {
        209.59985642875003`, 77.11208734874998}, {212.97304021750003`, 
        77.11208734874998}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.008547008547008548], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{164.63299999999998`, 36.348}, {
       171.11299999999997`, 44.69500000000001}, {180.691, 54.863}, {189.656, 
       63.074}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.008547008547008548], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{187.434, 65.781}, {197.281, 
       69.68799999999999}, {192.023, 60.492000000000004`}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.008547008547008548], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], FaceForm[RGBColor[0., 0., 0.]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7SVavPZkQopDscTiB9Nvejtczrw6dVpeikNYdtXm
qN/eDovCZL6rFmLyDbjYGFime8L577lCDCc3ejpcU1toZlCU4vBMTHWdTrGn
Q9dq1QqrkhQHERbhFczZng7cXd0e7GUpDvxd1WkXkj0dokMtqpKrUhy4BJ6o
zI3xdFiz2auupzHFYcHc23M7whB8w43WVx08PR3m97V+uOuCyb96Lf7hpEhP
h6WFMmaCfgjzyqT1LaxCUhycPjIsupXk6RBXYLHTLzzFoXqJjLpErqdDAvO8
bumoFIet4RZrQss9HdZZP321KjrFoW/bg98buxD8K/paPGHLEfygJ3s1PmZ4
OfAIqW1VDQCGR4px/15TLwcWj1iGHqcUh7d7XrRJyno5iNSGp5cbI/iRr68K
5qoj+JYLatZskU1x0Jtk0r7X0Mvh7M3lHWxiKQ6i8Ytnb47ycpi68+PVqXwp
Dn+0hTasbPZySAhjP7KPK8XhtYs43+XtCL7ozgtauT8R/AoL3smCTt4Ojz9a
mKoKAMOTRa+sosHboeXjxDl3pVIcvry29d62ydth3znhD89VgfpzTjx5+dTb
QXf35h36QPdGCAu/7f3n7cBSdPhchDOCzxUaJdLjg+BrLdhc6RKW4rBt/9sX
1p+8HdDTEwCzigG9
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvc766atV0SkOIjtyj5Wt8HKA8eca6edV1HjD+ck3
7gr/2+/tELM5R2JrcIqDq/bWZwceejsENiyJl3ZB8E/tW+4pbYngx53LCV9g
kOJwJUdMrPKCt0NUnfUTS60Uh3ChDR3T13o7hOlxFV5WTnG4td3z99YubwfF
r626JxVSHHbfD5+9NQrB13XVcbSSQ/C9P4Xklf/xcujI1rwnoJTiYGrxI37V
bS+HgmlnJkSopDh0yC298HGPlwP33S8Nq9RSHFbMPcOqP9/LQf2GTPEfzRSH
mawLik50eDmULz65JEIvxWGCYOH7xCovB5Ha8PRy4xQHf6H9Ch9TvBy8i5d7
S1ulOIjGL569OcrL4cJCu34/JwQ/7MLVS41eCP5yvRfXVgWmOMistnz6LNXL
4b6KxW6/iBSH2FWvN4dXezlUZSesXhCV4pCk0vy1qwkR3pYbdWyfT0TwYfEB
AKtRu+8=
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcx12K/B8ekJUtqdnxgGwkkzcmfr/7iVDdUmP2tQqXshq76fx5
0E5S9FuJnU60XXLouulunb/5cy1qN8q/7R7UneS6aJkNRf0e0XrwfvDaPn/2
eb8/+7MLUnNsbWxseJz4nHZwCip9J1zSE6ibvjRoZxnoh1cSY94SGD2j0s6N
MnDVzwzbDhBs3CPS+nYGLfy8K36vCKypct0floGo0adG0kUQpzaJxCUMLIHJ
383PCS4qm82WHAblfsdzDUqCWxPZaRkCBoK+DOHaU4Jre+zi7/AZZLXfDBM0
E8xLZi0eiwK4O2NC94jA1FYs2Vu/zbKQMYeKwG2+mxvpc/ANjfUsKt3wmGA5
3BQUd52GOVGrUCkIfvE7BerDNEItm44xbQRU3ZBY70wj2a16NLOTm3fj6jfX
RQrjZcLLa2qu39jVWDlJ4dTPA+6sloA+tp68s49CtcfsoG0/QfhpGRXeTG35
s+SYHsKWU/DwcorI5fzzljxbCCukoBDLTFKuvrvl/Yq0gsKPIwxvjvOLDS6O
mqul8MGzFyMvuf3+in5BE4U8x64e1QuCmdaBpMoOCl8fLvh4dxCUFklY19cU
yIamVcX5FeB19BM7Q8EYqWNVjQRewdHRPS40hC7+KZL7BOMaIesWS0MX+qA6
s4YgY9radqaIhu/Z3aOoIjCvlg3JlTRSRAOXVFKCqap95Pf8Nl9YTRgpChBs
8Qnf8l0hcgEc8o3WxVqC1V65RmnP4HOV1c77CcFmRMP5ycx/8iw0FJwsZsCb
is83tHN5TtuLx24zW/cJRShJaGTwMcrfjdUQ1DUsx2o7GByShXl29xI48QKT
QgcZ/P+PfwErMznk
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYk7Jki3eD1MctBqCmgqW+jjA+Iy8f06e2eLj
8PNxpW/ChxQHbkZtX+PDPg5M65yYfv1NcXjYe2VK/yUfBy4Ve6lfnKkOO6Tq
7rx+6ONg9+VwJAt3qkNAVUns9fsI/o+NVXllNV5wfv3F1UonErwclmalc/nw
pDqUcNdNT/TzcnDY2P9rLl+qw8If2RMt3LwcNO4YrX0qkOpgeu/UhQ82Xg5H
tx7IZxFLdZjBYst3ydzLwetJ+GZzuVQHgxTj/r2mCP6XexJMDepeDmHqoa58
j1Iw+DD1Xyd73Pr5MsUhbe72S8ctvBwq9Ku8E96nOMytu+LPau/l4C5zcM37
jykONlqJUioeXg767inx5l9SHFa6MN3ODvRymLaXXaD+a4rDVi6DtEvJCL7u
638bG+oR/LlP1TS+ZvjA+cJfvmUvbvBx8FyvVr8HaN52SemKrxN8HNZNSok1
/5zioGyyx8J2lg/c/q9u5+zSFvk4xB/frn37XYrDJIUYxtblPg7f9q5bcewV
gr+iNd3T/CWCf3OGwovlz1IcfkicdUtb5uPQ9f1mi8RjzPiG8QGR0+aw
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0l1Ik1EYB/D1dlHLEL9ICYdp0ObUchM/KJXH1Gnve9pyNyqGNu1pYMVm
qdMiNKemMddIEFqJpm0pGSs/0C5SjJRKhEoNE5YvFSFWFObApWnn7oW6+F/8
bs55znP+4cUGLW4XiUTbaGJoGJrTO+QSTzuC+mwzN9jPgufn/kb+BsLqhxCm
VsqCvsNbfCL6f6/LXdyAkoW37ri9fD6CquppdIaHBf5UjIo3IIQWKjpKtBzo
I+Qn+UsIP8qcYvMDwXmBgd9bNgUv+JuuGyIJcFKm1GpCyD3nDs4hBIIU/Q3L
RgRmUNEh1hOIDHOXJJci8Jay2FtXCaTc25lq1SFoqv29vJWA5NCxXeJcwezK
6/hAtWBv66hiWYXwaLr+4LMGArKggM2WNASx6MVS8gUCjireIk1GKFH6dA8X
Ephbi8ufSkAYUD3x2TpCICnM2danQCgq6k0YFxO4nRky20L3sZGU6F30JdDO
fC6XxiJYHLqCAg2B83W2HnM8gh8pVBqvEBjju/r66Pmj+HhcdofAYtSGP9J5
4LDLljJJoLYmfM+wlt7X+cU+skDAyEpdUzrBrVoyJDEIFr37Vo10fxUX42az
XhKYCUB1gRlhLWRadcZJ4L1nvdVqQciOuex6aKbvHe+ZWLYheMeY0O48wY75
FRUeEOyskYV2zXMw53i1T9aIYMxMK79bz8FkxJtVKf0P/VrWpEnGgWkoTyfJ
RPiV+Ck6vYL2YWmzxlonuFmuKVY2CXZq3BE5dB5Zmd54vIqF+x+PeiS0b7/N
1ZWVtSzYEkml8ibC1h+/kd5rLEzYE5rEbQg+z1PT/ewsZO9morrtCF8zgn1n
hln4t79/ARyDOZM=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+XkKU2jDZkwuVbLpJTKbt7Mab+7b7iUi5KYr5VKD1Q3ayyx
SFQk121dbj2Qp5DJQg+ruJ2HJI+niyJcphJKJ3R/na0/3n+8ts8f78/r83GM
PLGbsvT09JZos14bfW1MLp1d2PGMwjqxSL31NINY+Juraym+m+5xy7nAYK1X
TDb7DYW+nbWhyx0G2X09I0bNFJZhqvaGGgbyw+vkxW0UdX/FDqSNAV85FcPt
pMhjKR/2DTOoGpwbD+mlMB8qnE7X5+Gr3+jCRhWFs3SpgdCJh4599Y79gxSV
29wOtofzsEbDSo0doahelqOQVy1yZGJ5iq8jX8cnud7xshQ+PO9rWKFDFGai
WxEXu/kQ1GeUiz5SGKS2+FiuIrANlUllSopAh52tdt4ElYFi28wuivntkrCu
cALX/mbR5DuKB717i/efI/gjOC8OaKFIHrjpPpZJUDh55Aa7gaIxZMD3ahHR
+VFZcoIONBEE5wqvzWn9Pc4fltQoCbIyCuJlWl8+ZmVijoKA2/I7mNtEcSzJ
QPDpKUHEz1SrqLcUrhr1q7slBIrZLInoPQXbsBYcKcGu46Ecix4KUmAxMXCZ
oM34SplI66tb7FO6KY5AqEh7LRqlGE3iBJh4Eahm7I1LflC4zDjNVpsSJLSX
KhTTFKf87vXkdfJhVeKZqdZo551XvAjI5+OLOPmbaI5iOjvOYTJqkcVP3OX+
axa54vpsWm4pDxsk0Uc9pyiMJj502XB5CEoQCiw+U7QO/WLbjDO6e2ZwSlaf
6WCw2XV+LETb36o7fqXmOaPbL64i0LjwEYNDcnsmr5ViS8ptbw8pA/OY5dzY
RoqXdtEedekM/v/Hf/iUQFw=
       "]], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{200.754, 89.566}, {193.324, 
       96.91000000000001}, {183.637, 106.48}, {175.15200000000002`, 114.863}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.008547008547008548], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{172.44899999999998`, 
       112.617}, {167.79299999999998`, 122.133}, {177.36700000000002`, 
       117.59400000000001`}}}]}, 
     {Thickness[0.008547008547008548], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzeH7c+1KqxQHt7UW77x5ox0mLoyeVuaR4rA9bEm4
rly0Q0Lfou+s3ph8FbVXfxnfRML5LWoTp3k+jHSYEqduLuCT4lC/5meI2K1I
B4/Hqyuk/FIcxBZ/uMh4LdLh5EFBz+f+KQ7Cz1QMMy5FOkj27qtyDklxENSM
nHDuXKRD1usLdTnRKQ533l/xOXIawV/ysyVD4WikQ+wx7o975TD55TzT8zzP
Rjokr1xk9lEdYZ5J8FYLKb0Uh7Uzn/u9vRjpILNi3049wxQHr+JSQZ7rkQ5y
1io9v41THJ77MF/RuhPpkFOc/brLNMUhuOb67xtPEfxvFn+Ytb8g+KbCbpN+
hEQ5nPJcs5VVCxgelxuOxllHORyqf8yQI5Pi0FwffZBHP8rh0pa76eG8CL64
coyQLyOC//0609op35MdlLMaD8ZZRjl0C+p1Pnuf7DD9wo7TN32jHII/ll8r
fZHswGX+4WpIUpSDXF/vkXlPkh2aDn9qyaxB8KfX+k82m4vge+zNPd5xMMph
oeZ+U9ZXyQ4xyv8s9jyIcnDSlJi790uyA5t4m/Ltn1EONWyzPhz/n+wgFu79
oUQ42uH1J8ud/ED37lhV8OWYfLTDoZWe5y1kEfwTPQ9EctQQ/BfXLatUDIDh
xxD3aa5ktAN6egIACCgR5g==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnVOc/brLNMVB7K9s4u6SKAcYP3rXP5M99xB8W95r
7PUM0Q5Srz9JTNVNcVi/zbEwQTDagX+HVsJvWQS/45uu128hBF+G7XN4A1eK
Q1n4p449HNEOEtsOPpFkSXEw17I/5P09ykEkbULh5r/JDj//dP++9TTK4b4O
j97KX8kOLwUmn751FsFf7FwrN3c9gm84S3Dr7nlRDm6L19/78DvZQd32sW5o
X5SD3rmgiRb/kh0CNlg++1EX5XBSpLqxiyHF4UH+2QbxgiiHp/yLi+8wpzjc
VDY3f5IS5WB623+pBUeKw5WV879uiI1yuLTlbno4b4qD8Sq3vh9BUQ6cq3V9
fgunOEy/sOP0Td8oh76bR/r1ZBB8EY6Yy4kqCH5qWt71Lu0Uh1nfmguKg6Mc
5sbs261nlOJg/e3Ode24KAeLxc9WN5gAw3PzioqjiYjwXVFZO6c4E8GHxQcA
yaO+vw==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxuc6SCytEFLp5LS0PBRRUjPSZx2UqYSkqN//k7X0r8SUZhse
QrMlzqWl+ekIa0qelV3IKl2Gh8CWg1rOEqOVWaIJGYpeiCIUfVcOunguHl54
D7/3EaerLmduEggEbryCeQl5zVsSGUczRdYNEjdZxUL3p0gmbqNYN+mCjpaz
sP+9MjLzmKJS6TscX8DiavpyrtBAUfrW8vW2kkXIRFON/AFF9/rnk4NyFl0Z
EwvWSgoUnM7NS2QRRexKcznFh8r6zrBoFttWp1OdpRQjYUo/WziL/T+3nwop
ptAqkjQV3iwc50fGjYUUf/MDznoukA3/RfJeKLW4fNKnzfdqywj66h1J5iKK
rYOpBjFL0KKN7OLu8PtahlqdEoJlsU4k1lE8zZH1zwQSeMR42aMq+H7fn2j0
3gQ1fVPXnVUUW3YO260iAq9g0y5NLcVxzB4SCgjiYhXWmUcUh+N7W4zLzAaf
skDuoWyawdglThLL8/NRDKiNTgaZz/xnr/G85tWjhVa+3p370e0NzytZ0tqg
/sWgNu6CtKOGgjyPmGpfYnDk3Jkh7j7F2oqtzbrKoGNMtWdNT2FP64jRuxH4
h0eaOJ5XU2jZosyDwKiRGrgCCu+X5Y3yIILdF00JchXFSnGdTS8luJm9tzpK
SSGp+jYekkYwyVW/88ukKGkM+uHIJ/Bsj1Fy6fy8uZVjJQaXxz7RdH+Py58w
d2p9lghsrRkLo9kUdwUvmOSDLJpeq93XblGIIntCsxNc/4wmjt6uNBavPO05
Zn5/rcfviLksduO+vhT3gQAVi7o80w4NR5GyqDgwyedpdnzAq6GegmsubvMt
ZfF/Hv8B1VE0Kg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       166.016590429125, 106.86396844875}, {167.985400476, 106.86396844875}, {
       167.985400476, 106.367703313125}, {166.016590429125, 
       106.367703313125}, {166.016590429125, 106.86396844875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYlbGeyU60qkOiokC9hbF0Q4wfq/606RnVdEO
X08/5nXUSnWYuLBmiWRTtMO/qWsO3TJPdfibHnjieGe0AxvPylu3nFMdMvTU
3pROjHawuqMr9dQl1cEkbuGa7AkIPkeViunuuCg4/wynLf+TgCiHhUEXT+m4
pTocU1t2coN7lIPNzJ+76jxSHWJl57rNcY5yUDkyJ/eYV6qD+gSftB92UQ4H
52oZPPVPdYhYzMqaaRPl4HbmYLFERKqDyuWGo3HWCH7bhM//7E2iHIL497O+
l8bkw9R/rN4065ZyqsP+907PHwPNKxF/wu2omeoQlXBxKZNDlIMzi3buBe1U
B61t4tyTXKIctPXPyUvopTokOGe8NvWMcpi0tPBCvH6qQ5raf4PMIAR/0bRn
YQ4JCP6tyb8m/gqJhvNFZz/afDEh2sF1+gT7uUDznq/9svNXRrTDqqpzshK6
qQ5y1q6z5uVGw+1vd/GT3VwY7RC9XvHNbo1Uh1DDqXVOJdEOn5ZKZC5XQfCX
5F7klFBG8K82dK3oUEh16Fjrq7gZGL9t951df8pgxjeMDwAxh9sD
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4n6rbaX/VqQ6pBVGed/pjXYQkJRxO70q1cFo
4VXuSz0I/qU3l0PEo6Lg/OkXdpy+6RvlsMr0XnrAmlSHuLY5XnNcoxwmdz1/
kbI+1eFrzeTj7Y5RDtX3P2RWbkp1+Lz/uNo72yiHzVcd/GR3pjp8DDuh9M46
ymHnI9sk2cOpDiqXG47GIfHbJnz+Z28S5dBTJJ+/rQaTD1Nf8fbzlJRWhHmi
H5+rBnQj7EuZpNd5vy/VQdNXgn2SU5RDw/Y9nv8mpTpMClPsWuYW5eBXNffO
gSmpDgy3Dvq9C0Twb5zPmuWVjODnpahl+XhHw/kVB0M+boqOdmjoDas2BJr3
pF1TNDE52uHx5hM7hHoR/HVVLqUcXQh+hXhUsmFbqsNj49iK44nRDk5dnM29
jakO7utmBznFRTvwP3klGADkV2mFfN0UG+3wtVrj06mGVAfhe2LCFkD+8lz3
RA4g3y3q/NYVMdEOvaytjs31qQ73eSdd1gXyeQNb7ZvrEO7jUZcv3Fab6uD6
8fzGFVHR8PArz+0IkQTyIxbN0l9Tneqw6grvBOXIaAeuKTvnvaxKdbgbcMxo
SgSCL+IuJm4RH+2Anl4A4pQDhw==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{177.440938861125, 107.10397576875}, {177.440938861125, 
       108.85652922}, {177.969704988, 108.85652922}, {177.969704988, 
       107.10397576875}, {179.721008401125, 107.10397576875}, {
       179.721008401125, 106.567709413125}, {177.969704988, 
       106.567709413125}, {177.969704988, 104.816406}, {177.440938861125, 
       104.816406}, {177.440938861125, 106.567709413125}, {175.689635448, 
       106.567709413125}, {175.689635448, 107.10397576875}, {177.440938861125,
        107.10397576875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQvTDowdfaT2kObmst3nnzRjtoLXe658WQ7rA9bEm4
rly0w8/Jnfa3mDD5Kmqv/jK+iYTzW9QmTvN8GOmgm8JX/4Q53aF+zc8QsVuR
Dg9fTDrwjjXdQWzxh4uM1yIdko7/mLCbPd1B+JmKYcalSIdNk5YeEudJdxDU
jJxw7lykA/PH7ccchNMd7ry/4nPkNIK/5GdLhsLRSIdvpz9ZTLqWhsEv55me
53k20uHPus66o/fT4OadjZjT8O5pmsPamc/93l6MdNi6dikj88s0B6/iUkGe
65EO2x24r5x/nebw3If5itadSAfWyiDj+LdpDsE113/feIrgf7P4w6z9BcE3
FXab9CMkyiHZf/Lfmw/THFQuNxyNs45yiG495eFwJc2huT76II9+lEP2riPr
tY8i+Bs0nKMUdyL4E+6+/JKxPs1BOavxYJxllIOKuOjFXcvTHKZf2HH6pm+U
w5tvcXJeC9IcuMw/XA1JinLYPrmEp3hOmkPT4U8tmTUI/vRa/8lmcxF8j725
xzsORjlY6S+rvbkwzSFG+Z/FngdRDrf1/j+ZuCbNgU28Tfn2zygHUZ5Giznb
0xzEwr0/lAhHO7T8UGB8ciTNYceqgi/H5KMdotcbiPNeRfATJx2PcbiH4Dfe
VTj04zkw/BjiPs2VjHZAT08Avpgejw==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzVoZZBz/Ns1B7K9s4u6SKAcYP3rXP5M99xB8W95r
7PUM0Q6bP9xMyHya5rB+m2NhgmC0w4q9givOX0XwFf+ITDp/CsHfyn1rfsih
NIey8E8deziiHTbuXqHzbneag7mW/SHv71EOa7PLd7ZvTXP4+af7962nUQ4V
Rp9LazelObwUmHz61lkEf7Fzrdzc9Qi+4SzBrbvnRTncXzFN7ejmNAd128e6
oX1RDscvW97k2ZbmELDB8tmPuiiHJKmkk3E70hwe5J9tEC+IcqgT7dq9AWj/
TWVz8ycpUQ7nHpi95TmQ5nBl5fyvG2KjHLJ3HVmvfTTNwXiVW9+PoCiHRRtE
ppw/neYw/cKO0zd9oxzU76++znQFwV/L6yxtdgfB/5cdKh//OM1h1rfmguLg
KAezpKXMzK/SHKy/3bmuHRflcHHF2c8hb4DhuXlFxdFERPiuqKydU5yJ4MPi
AwAPaMgX
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx++wcRw2ysOah7vJCRdxmyzHW10rTDljdr9vM5345qFRnkIe
/riznk6OHsQcLbG1UVTWSmsdqkkrx9IDE7rZycOpbHqa7i+39cfrj9f2+efz
+nx48rzEDEsWi8U24W/CwsTTqgsbHm4Ubmn9p5o/yOATnu44spVC4au+GjMj
w1RYVT3Hi0IV9L3axSjDwfGl+YXtFFfeJNO5PzJUHo18WetPkd0a6tBhw4A9
xsnxC6KY4I/rlpwZZE86LUeEUmxpeLw+yGPQFvV3wzmMwtNoqAoIYXBequNp
xRQZTzYCsxIYfPzmppRGU8x3BKd/KTO7OC0K/B6zDw5YP3w7y2C1xdFKHEnh
NHWvO5pLYN3Xdpfspqidi289JyQYTezTKEQUoh5bvUM0wfGYrm35wRR2kfcD
cxII9BMzp98FUEzb148JjxDciVU3hggo4tUhjUWUIHWx8jLHm8IYn9L2oohs
9vl1WynYWUPArc2t+2zql3mSiZtUEUgU/YUKUy+hIHJYoyT4PcRN8TP10qZl
dRgrCFy/Nrke2EHh4zk5PVpMUP3jZhMRUni1SzSaPALLzDzx2i6K3sL8YmMG
QQ37Rjcx9So5cTbJnSGwH2gZJHspWDPKW1YgaFgV2VyKpeB7lJZ/2k4Q/Eo7
3HWYQiIJX4izI3jdnqAaSTLNi1amOo0MmtXXlkkKRc2Cd+1Pndnfn2HLO3vN
rjcc08aWMJitL8/xPERRdz3ZwN3HgFOQK13bQ1HQIFdzXc331EWJVY9sGRgE
zosRIRSNF3k2FSxmc7/npY4WSesyuDwTxZT5UfjOPdA0r8gwJOfvl/IoloKa
3FP1Mvz/j/8AcKsjbQ==
       "]]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.008547008547008548], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{205.60899999999998`, 
       62.242000000000004`}, {199.129, 53.895}, {189.547, 
       43.727000000000004`}, {180.586, 35.516}}},
       CurveClosed->{0}]}, 
     {RGBColor[0.2, 0.627451, 0.17254900000000004`], Thickness[
      0.008547008547008548], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{182.805, 32.812}, {
       172.95700000000002`, 28.901999999999997`}, {178.21899999999997`, 
       38.098000000000006`}}}], 
      JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{182.805, 32.812}, {
       172.95700000000002`, 28.901999999999997`}, {178.21899999999997`, 
       38.098000000000006`}}},
       CurveClosed->{1}]}, 
     {Thickness[0.008547008547008548], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1HtMU3cUB3CKQJSqICpjYFxhEaFANtwqkAgc5f7KWCWD8ZBFKNNfRJ6D
zU2FICCviUFsJ1KxGQSwIlhGFQId0AK2IJNheAgEy+qEYgWGo+Mlsi27+wN+
yfbHzc0n+eXec775nWN/MvnTU8ZGRkah9PPvm8rSuLqsYejIlVtIf+JCDlMl
nJsiLjebzfGdxrAz4VTWQi0XWFNBoVtnMfQZ7FI+KSL+3WZc236GeNPg8KUS
Py40a/wHVl5gyJGkLDTu4cKBOtkVtRYDs6ui2ozBBWnG2x8LRzB08SJEJ3UI
bouzTfh9GNqOOe/6cxhB4suYTJaKeHYLoz6kk7h/+1gbQ4khPFr+2HYUQYwm
LoH1IwaDoO6Y2dj/3ausDhA3E0/GlfXkN2L4zL15xFaD4Ll0cP+cjHyv614t
R1yHYYZ6a/tQHwLVoraYUUvnIU/qPqtEUL3aVFl/G4O52sfPUobA0S54cOIW
Bs4zN46+injNxUpWU0q8rzw2NvAyAks3x0XBXQzy3IfVphcRfMDhvZmQYwjW
KZwMGQh6Ug8fmhzDcDTeUa84h6Bxb/r7/EkMGQN3HXrOoo28z+XtHitOQDDq
WHFQNo9hoDnimkUEgqJYg03oMoaoYPuCYj8EkWGeaZOvMQTuiGx740xcvrLZ
7QiTmNVbJfpcR4Fjj77UdxFDVYq3eWYntfG/pfCZtO5KCi44uR5tGcfwpWyu
6t7XFPisnc8L6MVQUiO1deBTIHrlYC5sIq5pyvYLqCUuOKyyUJdjMFYHauJO
U9CfuO14iAiDxmGZ3Z1Ggc7gyZEUYciev5/CK6Kg2LFwU8BlDGzBF8p+CfHw
6ANU0EFcfzDh+tQQBdamfwztLsQQZuKkiddTwIsdn/rtKoYTj8JiBlYpuLnl
3YD0axiSBDkGj60I8uxex7NvYvhIpE576IAgIiLFl1WFYUFrY5zljaA1YyKd
UYbB7bsPv1X4I5B3Wo+fps//7N0ZPB6EwGNSxhTfIPnn8F0fCUowjLjPPzkS
jYATxPN6fB3DN7+kl5+IJQ64sf+Z4gyx4m/+tOclBAkNHJ6kFENMma2HshyB
Ocv5V0EFBm3GdHZiKwKf+bp3xJXkPl4RLmaz6fuYfWvbVWUvAuHzfcsCKZkv
SUxw/wTdj0kqkz+0RPqx9PWa9trM3eh/fV7X619h3vnrPXcuGGd1r6qK6bx1
+qJ2HvFMGfV9YSLxIW2rp0jMhb2S0JYJOo9wK9klkYoLo6nmySF0/QPqC+No
kguRdyru59dgeJHxdMbKxB9Kjis81A10/8zcA8k7/SHeRazNbyeutJ99wO4m
7hjThlnT+6LFK4+dbOEPWuHgS8YTDFn5cRJ3U3/4YUfmHj49P7sSe3TTa1yw
Qa+SfOn9U7vaHjW8xIWL56PaWfQ8PZVLo6UGul6nvIav9MTr+/G/Xt+P/wDe
J27V
        "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQHV1n/WTnimSHbjv+5mxrV4eIiAJ7hcXJDg++7fq9
ScHVodPxMP+R+ckOVwx6C3z4XB3eqTC+s5uX7DC7tvA1H4urQwiH/Zmdc5Id
Ek+Fpl386eIQfO/G3zezkx2i6vbLzHuH4LceFrnr+BjBv6sc2b/ntItD6Owl
89qA5s/7tvSE9y4Xh96JX5q0liU7JBV2W/OtcXFY7flCVGxtsoOa2PWaufNc
HOraEl5xb0t2eMcVYjh5uouD/AZ5hYkHEfzSjpOpb88j+J4Ry3k23E526Nv2
4PfGBS4OL94xFGQ8SXaYWcPXLrHZxWG3dqVL3Ntkh6KNARwrjro4hN9eYLHh
Y7KDdCBPmO5dBF8v+YLW8V8IPvsMoTVhvK4O+Rv+tma8T3Yoa9lUMk/K1YGt
ts+k/VWyg8f0I1XHlVwdmrkPT3z7NNnBVzBmzy9NV4d/d7T9dt1NdvB/HHXk
l66rgyav3/LvFxF8Vo9YBp6DCH7N51/i9puTHeRV8g4pG7k6oMcXAPMxz+M=

        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffjLvSmMq5Id5rPolVVMc3OA8bNOrzTKm4zg17Us
vuOS7OYQZ83eGrwm2cFw/+GmXGs3h+N5ZddMNiY7NC8t+LxFxs2hri3hFfe2
ZIdr3bIpf/66OvgZFL8x2ZPs8P9fscyCd64Ou765Czw+jOAvubct+chJBF89
oIkt7lyyw0XBNqWT31wdNHn9ln+/mOwgYG/50pLDzaFi3RSu9qvJDltSYr92
S7g5/Or5dSv4erJDf/a8Oml9BP/qk+d9+70R/D0bwxZvLXFz0F6wufLIlWSH
JXVHt6+e6+YQrcDulnE+2aHb2+TMwmNuDna/K1o9Tyc7LGCdeCvvuZuDYu7r
A1pHkx3KJ1kpnf7m5pAxw5Rn1x4E//QUx+pz2xB8D+WyGyabkh2W1mvILHrn
5qCj4ffs0bpkh7Sg0lDDu24OArpqXyasTnY4pBPoef8MInx95RpZDbci+LD4
AAAjX8i0
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EY/Sy1NFDIysx02MVC++GYqRnbztz37d00K2deKLWU19bNRFM0
s1H9KE2aouFlGSv9IaZoaObK7GoKMcVl2bqCWwleuoqmw6jvl0I/zo8Dz3l4
znmOX1qmOn0pwzAOPAJ4LOGxqr0gVZJC0XZjVG/8QdA6VxdTdojig4c4NmmE
YMZ+cUCdQDFfTotqnhGUpKw9nbWXYkJt6PrbSBBn7qvuj6KIaLdlFJQTvDw4
Py0iFJrmus/jZwiOxk9lC+QUxUNpsQdSCURTy1OVUoocL2dOBwLliEiqD6MY
1b4bX+lIMCf9+t51O4W1KV+7vlWxwK8JTS4XZItcd2znus2fOFivziQJeP2v
UNs2eQkHU2H6bUZCYQ9ojWpXcvD2bfYok1Eoq3oK+jZwCJWHv2rh+H1nsybc
HDncv+OUp4zk9R87rhdPshD7m72suylUEvsex9cschWXTOp4ipD4WlWokV3I
55vrPmFFFQt7pFF2L5nCU3trLKSIRWmLavINP99VPzBdVM3CcmLOJTiGojwo
X/ylgcUDcly1OpqidlPD46i7LGIlab2MisLS+CS6uIfFoKlyo4al0OZpK9ws
LHYJ09sYPq8tnuEjFd9ZPM88UssEU6wJkkq7N3KAzJzYH0hh7kyscE/kUK+R
V7b4U+y3TDYlXOHgrOsYKvWjsM2e6zE85RB282Q2I6AYLvGh838W+eFZ0psn
USzwaN/zTsIOBX4aLk+Lt1L8fmjobPYhePGoxl0Tzvdhhz55OHfxn6eyBzNj
dARjrlM5Av7+UcuyAlMdWfCXkIFC0k7QnWX2tPL+K/VTEcYeArdBm/eKOApX
h8Bo0VuC//v4D+EYKJM=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4o8+intnlac4aDYENRXsdneA8Rl4/5w8c8rd
4aG4etj6thQHLkZtX+Ob7g6vHr7n8pyS4vCg98qU/hfuDp/C3yh5Lkhx2C5V
d+f1d3cHNY3CpOCFKQ7+VSWx178i+N83VuWVTXKF8+surlY6Uebq0DtPRHj2
ohSHYu666Ykprg4aT22Y3y5JcVjwI3uiRYyrg4DAg60my1McTO6duvAhyNVh
7cvciuA1KQ7TWWz5Lvm6OhhJsO5p25LioJ9i3L/XG8H/fE+CqcHW1cEumskv
tgKTD1N/9/jXRx4NKQ6pc7dfOu7n6pCQrB6yvjXFYU7dFX/WUFcH/YC8rXYd
KQ7WWolSKnGuDuLVghltXSkOK1yYbmenuzrUfdwica47xWELl0HapUoEX+f1
v40NUxH8OU/VNL7WucP5Ql++ZS+e5u5g+PhyOzeQv01SuuLrMneHaccE09o6
UxyUTPZY2G5wh9v/xe2cXdoOdwf33ykmWkD3TVSIYWzd6+5w72P0RtFGBH/C
TpGgtnoE/+CZsx++1QDDX+KsW9oed4ci7fbe9ErM+IbxAS0a5lA=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4uq2n3tzWFMdNi14NmvHB3eHPynxfZbsqQ7e
DHell7xD8Lum31yr1+kK54vEL569ucDVYVqj4oZ9HKkOi09lzbRIcHWov6Zl
eJk71eHi9ojJ/BGuDunaJpue86U6nLE9GHgnwNVhvmLLtG7RVIdT2Yc87/i4
OizVa1zVLZ/qoJ9i3L/XG8H/fE+CqcHW1aFiX9J2lZspGHyY+hRL87uXHqbA
zWO01c7b9zwFbl/AvcKLvq9THCwjkoRUolwdcpgZJuW8T3Hgzi6R8E1ydbA6
9kBF/2OKw7PCrQvvVCD402LZLafORvAPt9XdmJHtDuffcLj9LLXH3SHn5szD
89+lOKw/26J3aLa7w/n/3IyNLxH8Wcfa95Y9Q/BTkueunv8oxWGN6psvfTPc
HfSu+Zz+fTfFoVQqc2XLRHeH3/p6UfuA/FtCt96lTnB3eHg828oSyOetitcq
6Hd3mLyza2XZnRSH4qIL+YF97g6VgSc6P95OcVh6M3R1dK+7w885J9o/3kK4
70dR0k4VIL9gwcX0wC53ePhdm+G01qjT3cHl3d1yqRspDtbpviru7e4O3+7/
eRZ+PcVhYfy+TI02BF/AJ86oYLK7A3p6AQC3chCv
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
       0, 1, 0}}}, {{{172.337401297125, 44.76803876874999}, {172.337401297125,
        46.52059221999999}, {172.866167424, 46.52059221999999}, {
       172.866167424, 44.76803876874999}, {174.617470837125, 
       44.76803876874999}, {174.617470837125, 44.23177241312499}, {
       172.866167424, 44.23177241312499}, {172.866167424, 
       42.48046899999999}, {172.337401297125, 42.48046899999999}, {
       172.337401297125, 44.23177241312499}, {170.586097884, 
       44.23177241312499}, {170.586097884, 44.76803876874999}, {
       172.337401297125, 44.76803876874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4pe8G/bM/Z7qoNkQ1FSw290Bxmfg/XPyzCl3
h5s3toZuYktz4GLU9jW+6e7waFEdl49ImsOD3itT+l+4O7ySqFbyUUhz2C5V
d+f1d3cHuZf/E8MU0xz8q0pir39F8L9vrMorm+QK59ddXK10oszVoTV+sdA8
pTSHYu666Ykprg4Ky04zfVBJc1jwI3uiRYyrA8fFvK3m6mkOJvdOXfgQ5Oqw
dNWf8jCdNIfpLLZ8l3xdHbRuTt7daZLmoJ9i3L/XG8H/fE+CqcHW1cFMZqJv
wo9UDD5M/dWOlkfeDGkOqXO3Xzru5+oQobIteBNrmsOcuiv+rKGuDuqCf7c4
cqQ5WGslSqnEuTrw2yxI7+RKc1jhwnQ7O93VoWyTs8RF7jSHLVwGaZcqEXyd
1/82NkxF8Oc8VdP4WucO5wt9+Za9eJq7g+aSpHY+IH+bpHTF12XuDn3tC1I7
OdMclEz2WNhucIfb/8XtnF3aDncH+z2fjXWB7puoEMPYutfd4dqmVxskGBH8
jqrFgZ3/U+H8nb0xH37+SXX4LnHWLW2Pu0PWG9HerJ+Y8Q3jAwBO5OSX
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0l1Ik1EYB/BpFukgphZaClFJM3OSCjrKj6e59z2K03AXeWHMXL0nYeUU
P5aYKSzT/MJSyvmxpXOiaMyPWQausEZpOFA0zM9pgUiQLRV0Wta56oW6+F/8
bs55znP+J+RKKbOPw+E4kQhInEnkvV2N+00YEhQP4k0jFGw0GFx+GDBsLHo7
F0dSwMQVLF8V/e+dAGN8fywF46UD9XYlBuq2OVDMpWHRzWixl2DwkQXrrqXT
wIx1zdprMKxltbuqh1kne3p+qzqM/nrGXVWujEYQN6Fe1VZhuHxzwStJjsBj
LtRl9z4GJ1OwzrUQAX9U9llSjMFWmXVO8wTBhcTyIa0KQ2K+u2OpDYHPzIey
o7dYxzZJTaeus96KhJ6dKxiM1ntBbxoRnH5Ve0ebjOEgZ2Q1ogyB/qScK5Ri
kIdw9S9yEEy2DkzPSTD00S+5v5MQhI3yj5gRBllqZ9jwcQSa7xqpluxjVxju
sPkhaOxmNsJpDBWGtJQUBoEi0INfF4+BJ5GFZNYiMJf7nTWT881M77B/H4KF
j4U1uWSe6PPGmsh5BHfP6Ovep5P7nq40DNoRZGx2COZVrB/+tIYGlbDeK8rY
ziX7y8kOnUI2BBNDK2MKDYYtbyuNhxBM6wo9dK0YkKDA+ExD3qsIEO+2Y9h+
7eyrz2Dd9mmdZiJYG4r8fVvXaJi8JNEJmzAoqYs5LQ00WMak2ULyH3gbvVNF
0ZCbOmsTpGBYD/8SGFNB+vCoeE9bz7p0anxJpGXd5pC1pJF5+Fk3MhOqKTBU
WrKDSN8c6vy8vMcUVC9bN0UdGPZ+8QY7myl4Kx48cKwbg5slKobXQwH9XN3Z
34Phq9jr0KSVgn/7+we15U3a
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       182.64971581312497`, 44.52803144874999}, {184.61852585999998`, 
       44.52803144874999}, {184.61852585999998`, 44.03176631312499}, {
       182.64971581312497`, 44.03176631312499}, {182.64971581312497`, 
       44.52803144874999}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzadnJvC/Ld2hSGLxg+nv3RymN834cXpKukNodtXm
KEF3h7T8+5HR0zH5+lxsDCxrXeD8d1whhpOnuzjMsk+ZmToj3eGpmOo6nU4X
B78jL27lz0p3EGYRXsHc6OJwfpHfaps56Q58XdVpFypdHOTzft+ZsSDdgVPg
icrcIheHgjO8Dw8uT3eYP/f23I4cBN9go/VVh3gXh+TlHsHC2Zj8K9fiH07K
d3HI7Lo/w60EYZ6VyadZ+VXpDg4fGRbdqnBxUOr8Ld1Sm+5QtURGXaLZxUFF
JvFdQEO6w5ZwizWhvS4ORSErfB80pjv0bXvwe+MCBP+yvhZP2F4EP/DJXo2P
da4OF7ReikeXAcMjxbh/r7erw4kEheSDGekOb/a8aJM0dnW4MVXq1JpIBF+W
ZWbJIl8E/+8Oe/5XzukOupNM2ve6uzpM/JT12tom3UEkfvHszQWuDpGXtlic
Nkl3+K0ttGHlTFcHlfxTal8M0h1euYjzXT6L4IvsvKCVy+8G55db8E4WjHBz
WM71Z3qUGTA8WfTKKqa5OXhwhf4Xckx3+Pza1nvbCTeHpufXgmR9gPpzTjx5
+dvN4ePlMulUoHvDhYXf9oq4O5zoajPsy0Twz+XKlh8sQvDf7Si7U1mT7rBt
/9sX1hzuDujpCQDRVgeP
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQXRSywvdBY7qD8I7cY2X7XB1g/DlG+nkVk9zg/KQb
d4X/XXVzUDijX/2qMt3BRXvrswPf3RxEZ6YfCshC8PuuZ60JiEfwlZ7r77oa
lu5wOUdMrPKZm4Pc9H9u+QHpDmFCGzqmH3ZzkHI/e5nDK93h5nbP31sXuDk8
5fWc8M8t3WHX/fDZWwsQfB1XHUcrEwTf61NIXrmQm4NPyxsHN490BxOLH/Gr
Pro6mKzv/9wLNK9dbumFj5dcHc5/3f74vk+6w/K5Z1j1t7o6vP5w/6oh0P4Z
rAuKTsxzdbDe08PeF5Lu0C9Y+D5xgqvDjalSp9ZEpjv4Ce1X+Fjl6sDfk7Uu
ICHdQSR+8ezNBa4OU3YxfmrOQPClXs4w3V6A4Ge7r7Z8UJ7uIL3a8umzaleH
xba/ZVvq0h1iVr3eHD7R1cGuRZnvWkO6Q6JK89euGYjwttioY/t8OYIPiw8A
7XzAcA==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx3HcrqgMKyqmwqrJYuZizt7H7+67NVyRbk0YTV+mUGH4gxo2
bmsmecjKw5SnkIdDIl3kXES6daeHU5iYbhpTKvzR7y+39cf7j9f2/myfz/v9
ORSTFBLLMTIyMmZ1nJUJK9fwWbuqZop9WU1LXvkMimx6jwU1UfzYec69uIzB
aWtNs6yTwtjelnuii0HXkwCTK88orCKm1coJBnrfu3N7XlD0bZU7Bi4wSGyN
ymscoijlfGr8vMVgqieONzBCsXu+4VeBrQi7DoTuLxmjcKo0M5V6i/Db9ahv
gJqi/ZR7pDpVBDKRWKXWUHSZF4+qRg0cndWWy/DF25wkEqbUVIgRmRHrMMDO
m6ffi85ZFiOlaH1U94bCJG/c3/okgZ+bRa/ZawqJI5mwlxJonDheq68otrwr
IrSpBCGd/GKpguLRx7DH4bcJDrosdnT2UdyaKfXU1xKMjbxvlckplBdmmEIF
2c5HZy0IvThLkBE/2BTdQtFRvVDxdIWgPcqq0Iz1Cy1aywUzBHE1MdcaeykS
sk3Pzk4S5CpX3FXPKdw2loZqBwmW3/6V615SOHP7IJATJAuHpWlKisB6q9WZ
aoI13bpKx+alLfdv8SggyKxc+6LTUixmCyQ7wgiMxmWHLb9SuP45stntSPCg
zvab2zxFsvjhhzK9GD436+qDlli/s6VC0i0G7+oyb1pP8fPODce1TAOX9Xiq
gn0M3Fa0mV8yJIIk8V1e1RwFd1WntQsXIS14MCFtkmJ8ft3FjmPoUyZodkj9
zuA8J547wO6/dyrFZkPDbN93vf0Mr2GYQc592aXNfgrP3AdCvpyBh196lLqL
QmF/md9fxeD/f/wHwzQ7RQ==
       "]]}},
    AspectRatio->Automatic,
    ImageSize->{234., 234.},
    PlotRange->{{0., 234.}, {0., 234.}}]}],
  SequenceForm[
   $CellContext`Dia["A", "A", 2, 7], ": ", 
   Graphics[{
     Thickness[0.004273504273504274], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 234.}, {
        233.859, 234.}, {233.859, 0.042999999999977945`}, {0., 
        0.042999999999977945`}}}]}, 
      FaceForm[
       RGBColor[1., 1., 1., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02, 
        65.789}, {45.02, 54.456999999999994`}, {35.836, 45.273}, {24.508, 
        45.273}, {13.176, 45.273}, {3.9919999999999995`, 
        54.456999999999994`}, {3.9919999999999995`, 65.789}, {
        3.9919999999999995`, 77.117}, {13.176, 86.301}, {24.508, 86.301}, {
        35.836, 86.301}, {45.02, 77.117}, {45.02, 65.789}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        18.552508993125002`, 65.66912544875001}, {21.99788154, 
        65.66912544875001}, {21.99788154, 64.800672813125}, {
        18.552508993125002`, 64.800672813125}, {18.552508993125002`, 
        65.66912544875001}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2YP+8qdH/UaCD+or59t9yrR0+
LZecUvsAwS+b72df2O8P5xcuUWKZleLv0FDBxGbXbO1Q4PvlxiF3f4cbZ6e8
j1ln7SDpP0Gq2tLfwUBZ/Wb1TWuHdXmTih7q+DtMcH3CWmRm47B6zuSsh6r+
DkfWnlladMjGIVfl+NLXygj+y72GLAzc/g4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pYPz00Nf5Wz9He6fu95/UMHKYdZjtS1p3v4O
grfZmlMtrRxOLGo79LAIwfc38py+ZD2Cv083QfpKbiCcPzU8Or+9K9CBb9NN
/z5RK4dvbj1KP6YHOnAk1L+8f9YSzg/ZvzMmYDGCf4HxW39vrqXDof09QdpT
Ax2q1E2ap+tYOmz9cyCUqT/QYdHr9DBrTUuHaQeiitn7Ah189zMt+Kxo6bBg
o3qGQW+gg0L4xT3+4pYOjaUHW017Ah3OaOWwcQhYOnSn9VXFdQc6HG/L+8bO
ZAl337fMgm1Xvlk4NPAcatzaEQgPv8QL0fN3tQc6uOeusHS9ZeFQuulrB09b
oIMUa3nYwvMWDmFl/csEWxH8RVLqORsmBDqgpxcAEIkBBA==
        "]]}, 
      Thickness[0.004273504273504274]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{116.789,
         77.15199999999999}, {116.789, 67.79700000000001}, {109.203, 
        60.211}, {99.848, 60.211}, {90.488, 60.211}, {82.906, 
        67.79700000000001}, {82.906, 77.15199999999999}, {82.906, 86.508}, {
        90.488, 94.09400000000001}, {99.848, 94.09400000000001}, {109.203, 
        94.09400000000001}, {116.789, 86.508}, {116.789, 77.15199999999999}}},
         CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sscerbvf0U4iIjMqj+/M8SB46eOoA1jpMP/
EwyT/m5H8E8U9M21mB8E57sW//h/pjPIQX7tUaY+tkiHo+6JWYnVQQ6lTlp7
QwUjHWZ66HfblgQ5nL7eVy4rE+mQHGGw/UNukEOywj6maONIh6T3BpsLsoIc
Cqx2aEWHRTo4bz51oTQTwQe5kSE2yKH6wMNVn+MjMPgw9XYczqKhdRFw874o
36zjnRwBt8/s+mL/5vkRDusmn6jgLwty2MZk/fTd2giHW5N+hRvXBjkcPsr2
SHxLhENBkdb9DxMQfJNd3Z5B6xH8U37ukiGuIXD+ogqnXPakEIemamtRpdUR
DswZxQoV+SEOjM+XVJvNRPCv1BXPmNSH4Bf3Oz1VbIxwOPegOGB1TojDXQmh
pCcFEQ6HZFcEN6WFODznvB/GC+QvfuhY2J4a4nBpn2umdV6Ew9pLfGkbUkIc
jqdUFkzKjnDom7aieWtyiMMmyQdNBzIjHGa0l1bcA7pnw4YHdQ5pCPfVaD5c
V5wc4dCju7LeNCEEHn65H53mWsWHOARqrT/vHxPh0Hj5TltPbIiD64VH15ZF
AsNzetmSiTEI/jprviyDjBAH9PQCAP/D9kU=
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{45.094, 68.895}, {53.609, 
        70.17999999999999}, {63.605000000000004`, 71.68799999999999}, {
        72.71100000000001, 73.059}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{72.43400000000001, 76.559}, {
        82.84400000000001, 74.59}, {73.477, 69.637}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.004273504273504274]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPV0zqtxYOcCB7fE0V+O8IAcYnwEEUoMc3vwo1HFz
9Mfgw9Sfurhx79Vof4dc/Svq64D8gvl5zNH5/g4L/0ek78gPclgV1NUxo9Lf
If/N/BPuRUEOT1iX8V5r9newvflM83pJkEPDfeMLXzr8HUrSzLmqKxH8ezfs
J/bXI/ie80W22rYHOdSkzuk72OjvsF1pa2XrpCAH3so/RytL/B2ijZfJFS4K
cogQFn7b6+XvsO7YyzDRy0EO965vXqtv7wfn986wEVIV8HN4u541SnN6kEPo
dvmpzzn9HJpeGphV9wc5KNTNDrzL5ufg9flB4PUOBP/BVG4jzWYEf4mqCk9Q
aZDDSdnw+UlyfvDw8D0SXFbug8mHhZ9BinH/3kZfDD5MfQl33fTEWb7w8PTN
Unu+d62vw+I9KhxBxUEOnUdvLdXb7evgFFyXzVUT5PBjY1Ve2QlfBw8z0Y22
rUEOCwPN9vy+7+vw8eqFf4fmBDls45586gSDn8O1p8VF8oeCHHjkz5sduOrn
sEbgEc+kvcEOfnKNrIavEXw1tt0Otq/8HcJ28t21nR3kkGKcx77ut7+DuHKM
0Flg+G+f7OfKxRrgUHrejK+6OsghJPcOuyZXgMPSyg8rXpcFOXx0yzrlzh/g
wLEg6dmZwiCHw5E1FwrEA+D+QU9vAPC9BuE=
         "], {{60.62239646, 
         75.62568744875}, {62.4774530375, 75.62568744875}, {61.54992474875, 
         77.834504815625}, {60.62239646, 75.62568744875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmlI03Ecxp0LwVLIBhWS1ywbWlgjkdTsIawZGf36/TxCK6WcpZV3YpgX
LTMyPELF3BTzmFlLNN0LlzablkdNRxNyGl7Tkg4tomJJ9H+l0IvnxYcvfK/n
cTuXRKV8KysrHidPTtacMlt8/2hGCKan40LkPQxPfAsnoo0E6Y5loq9qhgA/
MmbuJVhn2qGza2aI46V5CjsIVvbrJg9WM1gWDPGmFgJRwrxPdjHDD77/dmUd
QddCUIqPjEH4TeScU0VwzNLQ/CWDQe0ZahkpJYAiw+1WHMOMTYs6TUZgGYlJ
PxrMcKhv23JoNkHmgneg3mmNQx+O83kf6CrrDzsU0U4KQaL39+wbBHm7pOUz
dyg+HrCvQjG3r8dwQ1UCRUHe/ejoCgKvybBn9REUPUPqaXkN1+/E43RJMEWf
6rjHqJIgN1f/RhZAMVRivsRvI3jUuuzxYg+Fn4EYzM8JHmh666OEdPU/f8sV
lbabKIJM7Zo2PUHZyEBa1HqKxLqxjUtagthZ0zUZV+c5+4QoOwlGm1sVYkeK
gbdbh+NVBEahZErqRvFTa9OPRoJUqbFRJqJYfp+Uay8nOPK6PVgiplhsslOA
+5ejvGTJNpBiwl2QgiyCUtG9GudTFKMvzYvjCQRJn2sHJKkUFYLBWHkMwdOV
ReOnIorTMaqps+EEv+32zRQrKbQFLk44yc0Lt94b2L/GXUVbZrPm11jl0pH/
zpVBLItw15wnsE7WRW4OY5jTXY2wLyS4qdLu9spf81M7OKG+eJfBPVIkzKnm
/Lz+y7+pkq3eJ34l6J6rZRjcOX+B30pgOHPFVc7l6bLZNjmsm2CDw+3G8XaG
//P4D4yBM+I=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTv1wYkpGwMdDsi4vue2C3bwt1s6U+9soIPhsQ0R
b/2CHd6IG8f4XsLkz5v67d9BmSA4/9/UudM5hYIcgnfY3E68EujwU5ot7BpX
kMOeg65xZTcCHSYI/b10kC3IYX+d4H/+O4EOvaGGRhrMQQ5xotlJJ54EOnTP
SJ3Y9z/QgfFSf5bU50CHsPiHvi1/EHy5zImZD74GOjxrZ/XfW4nJ/1i9OJ/z
H5D2Nb6l3IMwb/LCiHulMwId1Dm/+K9lCnJI8c5+MG9eoMORR41CZ9iDHNIL
zVotlgQ6JO7hv/qKJ8iB+dER5/DlgQ5nXz/+M0MMwS9YwcH6WgXBX98UNHlH
a5DDwT63Gz4TgOHh1HtMLifIYf2vLXmSpYEOf9+lHzoTH+RwPmWlzYcwBD/S
cdnE23YIvuTqz8eytAMd5t7sPSSXFeTgLOdVzycT6CDocPTMzLogh0t370rq
8gY6tCz7c01kMtC94pzf6lgDHf4Y/W/VXIvgC76NnvLtLIJ/SKfqhMenIIc8
v5wb3gKBDtcmcVnVCAY7rPeVW75HNdChoW2SymytYAcVDiW/i9bA+DkW/tHE
JdiB6WHi/QSge42kar+2BQQ7bPBr5N5chuDvEVk/TbITwf+zKjGxaw4w/Aqy
Psd6BTugpycAs2kPrg==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfzoiHP48kCHCTlaSdVLgxxg/Kua3GY1/MFw/vaa
Rxz2hsEO8Rcvz8ueHuigqeZXpOAU7OCd7axrUYHg277wZLRIQvBT2a/IOAUG
Onw49q+zxjLYITa90KzUJdBh40zvw9wawQ4hx/kCVpgHOhTnzPgzSyzY4VUI
28nJhoEOyQ3zz8z6FwTny27ulI99gOCv5pTbVn0+yGGno6+Wskmgw8I17/VE
9wc5dEyf3L/JItDhlLzb8x3rgxz2qTzJD7MNdIi6f7Px+oIgh29SJiG/nAMd
gic7WyyZGuQwdWPv9k0+gQ5+kmu+FfQFOZxPWWnzISzQYa1kcP+O5iAHu0BP
VouUQAdBh6NnZtYFOXiuK++ZV4LgB3MvE2ZtRfC/HT8lHT450EEkbUKhcUuQ
Q+qWrCfzFgQ6bE19eeM10PzZjruPOC0FhqfS1srWSYjwVnrZOdd4FoIPiw8A
+9uwPA==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtI03EUnRPyNRXmKxa+IPC5UMRg6txJsrIEt/vDSg1l05wUZWpZqVFL
LTS1mmmT1GmWCvkiH2GUWJlJmQY+KLBaaZaZSRSmaav/lxT6cLicey+Xc8+9
7qpU2m/K4/FMOHhz4HM4Mb95YnRFAe3wQEacJSFMNb3st6iAsazqqoWQ0JHg
wm/i8mb6P5pxN0Khbrnp8HqCrUyVUicmLNyuPNTlTpiygW2yhLBSFtA+401Q
aA0jzVsJQ43h3cIAQgl/YCmPCJJU0eveIIIuYeHMrIqbU9rn5ryD8NZXsMlL
Q2geU3wMjiIoHaVJN26t8TvDu7a8f7fGQwPsuy/ZMUz4yD4IIwhFkb2tJlIG
833KULmUYM5iayLiGarKikTXAwktbk7TQ2kMT89m2Z/kdOc394p9NAyP9ZND
4RsJMaeqR+eKGPbmh9kYRYQnPFlFoI6hc8B5XZOAcOB+Yu35erbqz1GR1vNr
F4NQsPQ7xqiAwZAcWdnDoFnU9ddaERrKdz6L5+rz2ZILM46EkBfHGtpaGDz7
owUeroTq4k+Gyw0Mv16qhXIPQoWdQh9fw8C7Z9yT60fwnco53lbOYPZdGSQP
JnybuBL9qpDBITMuWa4gZMm19X1HGFxHCua6lITKovyca7sZYs7dTP9xkNDT
Hj5rFcJQKnnw0z+T669bfqN2Z/Czi7orzybwYsUXu03XOH2xTlRP0ipPiEl7
ZNnIzXFw6hhLIVhaqD4PZhCsxxdP53J3neOnage3r90zsjWiJIvT+Vy2rVPo
TxCuiC2kXPy3H2Y2mNp7ETzSC1KLnQk19FAfx/1TXmeSOtiWoNbXi1w4n/7/
x7+gvyBX
        "]]}, 
      Thickness[0.004273504273504274]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        187.27299999999997`, 209.49200000000002`}, {187.27299999999997`, 
        198.164}, {178.09, 188.98000000000002`}, {166.762, 
        188.98000000000002`}, {155.434, 188.98000000000002`}, {146.25, 
        198.164}, {146.25, 209.49200000000002`}, {146.25, 220.824}, {155.434, 
        230.008}, {166.762, 230.008}, {178.09, 230.008}, {187.27299999999997`,
         220.824}, {187.27299999999997`, 209.49200000000002`}}}, 
        CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        160.806415993125, 209.37615644875}, {164.25178854, 209.37615644875}, {
        164.25178854, 208.507703813125}, {160.806415993125, 
        208.507703813125}, {160.806415993125, 209.37615644875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0m8s1HEcB/BDs5IbKXOc+bMTIlr+1da1vZmOVq0oRsdJfl/z+45p2tkU
1oy7lChZw27T2jy4ElEtbHeh0Bn5s5ZFO39uSS42rnIN6Tab31YP3g9e23uf
J++P9+XceGLD4/GsLAmyxNqSnEUnh9ZSgpwf15skv1gcmzEI+dkEmiMK3qUO
Finj9VdHNcx/TmLKsiVaFoL3ppYKPkFXo6OC7KXwi1uctA8jkK2J94vEFM1O
C8unYwgKVWyPVwbnSoMuU67kbKu8v/toPcVNeFQVRVr63alN19QUYpVCpw8n
SF2vTA18SSFNTxAEBxCoH/qKBrooCjQ+GRtuBMN5K2V1fRTzdtKkmp2cV2NX
D8+ZmW17b1bLZd8ZaI2vHVU9FCQoWLQxy8DsX6nb00mxr/fQl/JPDEIyU0qU
rRTJpoFq/xEGcT2BQ4mPKATqzd6QfgYBjroxaQXFuCzst1jLoHN27URdJQX/
bOhQ+VsGJUtv/IcfU7zzqvU0DjGoSbgTbtZSNND1ybwJBj+jtfNZgxQPkvuK
5UYGilWlaVRPEVVaZdphRdAXeb6r/yvd6gk5e/so09pDOLfbvJqTSwhu+yzl
+k5TqHvd+D6JBM4LomHDCIWzg6DjeCZBqMTk+ryb4tzBol1TOQR+9nfL9c2c
eReDqgy1nJ0K607q8ymiV1wL7KQEZU8bPD3iKSJyvc7csuybPmVvO3iAbu32
jcETZzcJmWThYC1s1Fwg255YbstSyTjXK4tDxwjBs6gbPR2fWUS8KGpopwSS
KNe2U9MsZv60FLpfsdzvFLjnGVjcy4/9+CGfwCXNZaXYyCJGGNM0U0yw0dfs
WWpm8e///gUWnE1V
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[
      0.7529410000000001, 0.7529410000000001, 0.7529410000000001, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        174.29299999999998`, 21.012}, {174.29299999999998`, 11.656}, {
        166.71099999999998`, 4.07}, {157.35200000000003`, 4.07}, {147.996, 
        4.07}, {140.41, 11.656}, {140.41, 21.012}, {140.41, 
        30.371000000000002`}, {147.996, 37.952999999999996`}, {
        157.35200000000003`, 37.952999999999996`}, {166.71099999999998`, 
        37.952999999999996`}, {174.29299999999998`, 30.371000000000002`}, {
        174.29299999999998`, 21.012}}}, CurveClosed -> {0}], 
       FilledCurve[CompressedData["
1:eJxTTMoPymNmYGBgBGIFIAaxQYAJSjNCxZipyIaZSyvzhzobAILyAq8=
        
        "], CompressedData["
1:eJxd1Gs01GkcB3BZbaiTza2LjeyiTjHMDGOGNN8aHJFbkVIu9TCV3KaUNGGT
NGiVyzbYsBpJEVEtkSi2WJw6No7L5LJJKlnJaVG79v+G/zn74vfi8+Y5v+f7
fM+jvz9se+BXCgoKC6jxoUaRGlGQy+cnYQQBW9sza8csMOflb6WGzis52LE0
9tZUDME704ZMLwcOzLfe2nc9ieBxxv2ppDAOwoRaFY5pBB9Or55deJEDw8Wa
Eq9sghPV5UUfyjhwU7U/IM4nKHL6pi64j4MFcX317CICY5XnyaaalvjzvtqR
odsEZgM+WndFljijfcxbr5pA2KCd1veatt1sllgazJ23rDChJaCfi/0itYiC
uwSKzYIp7408FObd0BeUECjr5PqqxPMg9Oz3cJYRqIVMNVa28KCarqnLlBKo
XzKcSvmLB9nx6LHDEtrsQyt/jz5JO9hmJOZoKEGyT6qL7CkP2kVnGosJQcXR
gy2ZaTzUq+upDu0i6E7kO6R48pB4bw1ruSvBl+NvUksmueC5fzcpsyPQtRYW
fQzjQtKdmP1uE5VfupnWmRgu2Ab3I11tqXwc43sD3nPx1K3mpcVWgth78tP2
4CEi9JytnTOBvCJYHBjFw8rzO656uBP4h5s5rCvjwQyjlwp3ErwymdR8N8TD
QGX8uK8PgVbd9g1CDSsMSnUkSSEETlcWF11ItMLLgfLvOacJtrkd/NemwQpn
V5XKLktpz+U355yUiEa7WoLJmQ5NvUwrRHR1/dDWTJDRtWJknbUVvBFe2t5J
sGRi7UjKIJVvlbJy8gsCtveVpZ1BtI1+fb85qpc77zGvgBEjMRfjfJXcgB4C
/k2+1hsDLvhN4bYlfxDUBm0zdO22hGqXKNyvjaBPbphmm2IJh+7C/OuPCOJ9
hcdc+JbwWi4Qf64gcC/o2fBllIPmHwtlhxqpfW84sl7c5sDATdRz9hlB3jOJ
4esjHPiHdK5f20WQGcOo427g4OHeRX3SVwT9yUtbZ6qo/j/Ps3QbpfrUsqcu
SJf22O5TZRwf83mbHLg6+/MhNnT41tGSQYKchSbCUwUsKBUvnlRtJai3Pbl7
VIUFQQkMPR8SVE/ofbR5xJzvu8/0hWndRCYG5Sd6qqh+Liz4R03Bl4mIdDEj
L52g1OWw0SCLieiC8uTLcQQeMcr+WauZiJTeifxWRDuhw809dB/tsuTRjGEP
gg71vOl4UyZCN+s3jTsRdFm3Gu/dwYTJ356fZ7YQ9AZM+7EjmfiXXStTpPoo
GR6fzbpOu1bH2UhrmLamqF/NfBkLGrE7U5/zCRpCrp1vMGHNn/dworMsW8CC
Q5hnoL49gfR2+2zbXhZ2fzrXo+tI0Kij9FJ0gMpnc3VlnCvt9RoJq7Z70j4p
jt/1my9BFkMm/2TPQuu2uOyqw3SeNt7DDwqj6Dw1ChzFjASCyuaJOmEuE0P1
DjX7Umn7r4vqmsqnvTFPsKyjjIA4vfVre8aERNDbebSG6nPS1dZPXGpf/27t
a48J1mhlyC/+woJm86ZACfWexQYVaoq67Hmz780GOpbTftC0OquGYY7Q4iNK
UU1U32JFfjk55qj6OoIRXE8wm884nz5jjgnBlteDlVT+d+K3HNtjAaZd5Arj
mwQqLeqnnuRZwO5WVGh7LsGQ6RL5zGMLKAlL8+U/UfcdX2TMGLCYv+///+s5
/wdvaZmM
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{112.043, 65.24600000000001}, {119.516, 
        57.952999999999996`}, {129.25, 48.449}, {137.777, 40.121}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.008547008547008548], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{140.465, 42.391}, {145.176, 
        32.902}, {135.57399999999998`, 37.382999999999996`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.008547008547008548]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPUPrWdTkTREOPVGFd6Zf83BYdXmVtu65CIf8tR7r
o354OLivtXjnfRmT7+lz5TfzFDc4n8NXSXdynZvDOl+n3ISrEQ7/Iz6v1Clw
cxAP9/5QcjPCQdft4WLmDDcHKRHxiXx3Ixw0zngmXUhwc9i5quDLsacRDspB
mxTmRro5xKRP/SPxJcJh5/2VMzuCEXyvz5wXHdzcHBxluR/ursLkv5PQuzsp
zM3B57FFjlIvwrx3ZnEFJTMjHKKMz8+9Fe/msP9BQdHc+REOU569UpLIcnM4
xGYjbr40wuHcTLYVoSVuDnHlp66GrohwWPFj3feN7Qj+28If7GFLEPxstR6V
j6nuDjIqPlneE4HhsYyxe6+RuwPXhF0MEmURDmz/tzVJSrk7aP1ad+5dOIK/
5dpq5Vv2CH6Jw8+ITJ0IB/crTM179dwd5m32F+SVjXDQW1g4fXO4u4Nu8ePV
2nwRDqJ5D1avbHB3OLSGr6OWLcKBpf0p5+UtCL7e73lqud8Q/IlVt/sE7T0c
Tj4uzPISBIan25/CiloPB67Hypa71SIcePV43Let93Con6v+4LwNUP+6aQ9e
PvJwiC1LL4wHurcw9OGL3t8eDtxP2uZuLEfwxVdt0ZDoQvDDHdI/d8yNcLjA
uOeJ9XsPB/T0BAD8cw4Q
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHVd+6mroiggH3V/Wh8qWujvA+NtK/mZWVHrA+TVS
a/j/7fFw2JV20yBrRoRDXG7zowP3PByWMXjuN6tE8GfU+k82S0bwD8y5uc4h
KMLh7bongpVnPRx2/Ck7Uewa4VAQUtcyfZWHw/oYkUfLLCIcPv8U/7613cPB
9RV39CSjCIcrimrTt4Yj+G7tv2yspBH8FBPlrPKf7g4i14P2KJpGOPhVHYte
dcPd4bHOTMWNlhEOCxOKz3zc6e4gueslY6hdhMPB+7MY9ee4OwRusHz2wyXC
YZN7Xt6JVneHD26TPTf6RjisDLZ/nVju7qD1a925d+ERDhkhvTIfE90dZj7z
m26WGuGgt7Bw+uZwd4clzrVyc0sR/HULVi9lbkPwA2MvrA2dEuFg+pb94bMk
d4cDngVlcxdGOJS92bk+vMLd4du1A2GOyyIcqtMCP3bVI8I76PMvi+d9CD4s
PgCUQsK/
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkl1Ik3EYxTfT1ErL0BVaVtI2CTNXWWqQp8z33ZvK0jD7NynZUNOYH/P7
I53DKNFmKi0V04WQlqscW2llTaPSyq42pxMNCS1oFCUoGFrtykEX5+J38Rx4
zjm7JNkJqWtYLBbbrj12Odkl/tOq+6QgGP1sUPePM2iotTUorxAsJq4XJY8w
2KHS17rmEXDG9le33GfAJFpmTqQSuNyU9f29wWA6InTnipggeUGXUVrCYDyp
ffJdAkHVj5yZbxIGztF1Zs1Jgk4fgUgsZNBS0dc7f5xAJTZDxWfw+pyHTB1K
wBrq/rLZJgR3q+JuUTDB8neqdJvawY/zWl2UgQ7u1rpzuG9oLA41dmsOEmwo
1QVGyWl8aMgRSUHgLbtM6/fRyDCv+ChpAom1sXDYncYdf99bRpHdzxj51dNG
oYutm5o/a7/fWd1SY6LwYJYO4EkIpIqRGOcBCtu5hquuuQSnmjOjD3dQq/m4
xQXsbaqgwA/myM2VBILB4rlD2RTiF8KGveQEY3Ntv65VUpjNbXZ6n0aglVPh
cyoKPfzyqrrzBE/SCgZiblOwemeWSc8QzNvqmZoeCiaBKTQkjqD5aWy9p5HC
6O/s01J7XseI23SThcLLokK+NIggRO5x5MU6GnpfoWbZj8C2xKvfGEmjJD3I
z+hFkO/7vCspn0akYZO6ypVgJUI02HGPRuek0iRxIvj50XZhedbBigjOqyKu
cJXTU0RsQZsQPhPPrNPeBF7sLL3WmcHbLVaPkHD7HsovEkuyo8/rhvZL8QUM
1j6sndDE2vv0sxSM1jCr/+U+8iymWxloy4T+vBSC3qmho/09DERhMl5xFsHu
qCXhgUEG/+/xH/xpJGA=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        102.973621429125, 48.33271844875001}, {104.94243147600001`, 
        48.33271844875001}, {104.94243147600001`, 47.836453313125006`}, {
        102.973621429125, 47.836453313125006`}, {102.973621429125, 
        48.33271844875001}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4omT1r+YURzl4HxIoa5gkacDjC/lf+romY2e
DoUau6UOTYxyUHH+6WF8wNOheY9Py9c1UQ6/zi+a0H/e02HSCtctX49EOVyM
8bnx+p6nwy8Pf2Ou41EOmXucIq/fQfAFv3hklVW6w/kzhKvkTsS6O5w0nTZl
5skoh15fn8mJ3u4O/w89K7E9F+Wwy8qq18LZ3eG8hO6tM5eiHPwUZp75YOnu
wHHGI57rbpTDRjdurksm7g7CmuXPCt5GOXguY+zea4Tg8yo+/1uv4u6gs76Q
S64Ukw9Tn9kRYfK1Jcqh/n7rueOm7g4F+3eLHeqPcth2YJE3q427A+9Mz5sP
pkQ5hOboi6m4ujvcfddvVzAzyuFQ24Vr2X7uDqtvX5v/f3aUwzmff4mXEhB8
N92zaxtqEPxt6l+Vv6Z6wvk6ZkfTF9d6OgjuF6mrmhXlcCH6ZfHXXk+H260T
rAqmRznYlHWZ2E73hNvP1znHKm2+p4PNe7Pr2/uiHFYnaf1tWeLpkHVH5WJf
G4J/LnuaUEEzgm84iSMgsA4Y/tGzndIWezpM9q/uNCrHjG8YHwAlAfKW
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4qWsCa9s+qMdzjzaMm3HdU+HFYe0u69NinZI
dVotvuQqgr/k5vKVegXucL7ewsLpm8PdHe7+Xn/uwdRoh708llMt3N0d1i49
dIFzTrTD659q/fz27g51/lcvGS2KdnhW3+97x9zd4a116eyq9dEOT9ZOcL1j
7O7wKzT/cNXhaAfPZYzde40QfF7F53/rVdwd5pca3V1jhsmHqS/Pvq3B6YEw
b1PRYa8HwQj7ArYGCP6PinYInmXAp+Lo7tD5P2eSTXK0g+paJxFfT3cH1Va9
HQfToh0YtjTPvROP4G+Yf9VkahOCf/eEz5UZQZ5w/qemlY9Siz0dOlYv+Loo
MdrhJH+w1qEmTwe/Hy0FqeEI/pPWmpcBgQh+xf7lRxd5RjscS9/1oa/e04Fn
KRtrtEO0Q3+M+dKWCk+HpREnlR7YRzt8CVnxKrXc06Gww+XxVbtoB/U9umoF
ZZ4O17ObDgbYRjv0bpmXHVjq6bB49t9GN5toh/3SKsujSzwdFhr9q3WzQrhv
wT3Dh2ssoh26Hs1PDiz0hIffh1sCK40KPB3Mr2rEzTCJdghdKa3gnufpMHdH
mo2wcbTD7oU9qRq5CL5Wn45eQRXQfWjpBQA2mQSe
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{114.39796986112502`, 48.572725768750004`}, {
        114.39796986112502`, 50.325279220000006`}, {114.92673598800002`, 
        50.325279220000006`}, {114.92673598800002`, 48.572725768750004`}, {
        116.67803940112502`, 48.572725768750004`}, {116.67803940112502`, 
        48.03645941312501}, {114.92673598800002`, 48.03645941312501}, {
        114.92673598800002`, 46.28515600000001}, {114.39796986112502`, 
        46.28515600000001}, {114.39796986112502`, 48.03645941312501}, {
        112.64666644800002`, 48.03645941312501}, {112.64666644800002`, 
        48.572725768750004`}, {114.39796986112502`, 48.572725768750004`}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdp0yytrpTiHnqjCO9OveTjcvVex+6ptnEP+Wo/1
UT88HKp2sNV9ccLke/pc+c08xQ3O5/BV0p1c5+bwMELgL4drnMP/iM8rdQrc
HLySJBtkPeMcdN0eLmbOcHPwlX+qsN0nzkHjjGfShQQ3hzdb7VryQ+MclIM2
KcyNdHPoL0ruOZgc57Dz/sqZHcEIvtdnzosObm4OJRo3C1JexWLw30no3Z0U
5uZQ/47tz6k/sXDzFJ10GGQ54xyijM/PvRXv5vDptR2TG3+cw5Rnr5Qkstwc
vgpyLb8vEudwbibbitASN4eJTTNS/4nHOaz4se77xnYE/23hD/awJQh+tlqP
ysdUdwd/falfnxmA4bGMsXuvkbuD7eyOCQeexjqw/d/WJCnl7hDLWhs3/TiC
//xh5eam9Qj+cu/jLwTnxDq4X2Fq3qvn7nBxn+zCrT2xDnoLC6dvDnd3SKjb
aH2lNtZBNO/B6pUN7g5ft98RVyuLdWBpf8p5eQuCr/d7nlruNwR/YtXtPkF7
D4c/7+x/fWqIddjp9qewotbDwfbdxxPJ02IdePV43Let93DYtOJrfsUaoP51
0x68fOThMKHRlJED6N7C0Icven97ONi9D9GNeo7ge21t2nHgJ4Lf5W3abMgb
53CBcc8T6/ceDujpCQDSehWa
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQPbFpRuo/8TgH3V/Wh8qWujvA+NtK/mZWVHrA+TVS
a/j/7fFweFu4/IAQR5xDXG7zowP3PBxucov7338RC+ef7pBVvn8Jwf+8fLnd
y4OxDm/XPRGsPOvh8JrdNUJma6xDQUhdy/RVHg6P0h8V+q+Idfj8U/z71nYP
h4qvN19ZLYp1uKKoNn1rOILv1v7LxkoawU8xUc4q/+nu4P5IwefUklgHv6pj
0atuuDuIWaRvjFwZ67AwofjMx53uDj5Ht0/8uzbW4eD9WYz6c9wdWnazly3c
EuuwyT0v70Sru4NyUOLNyL2xDiuD7V8nlrs7xLLWxk0/HuuQEdIr8zHR3eHM
Rxn1+1diHfQWFk7fHO7ucN3Pe53rUwT/4epK0zVfEfyWjHm2/5jjHEzfsj98
luTu8DnEjs1NMM6h7M3O9eEV7g6aj/qevRSNc6hOC/zYVY8I76DPvyye9yH4
sPgAAC8ayJY=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+/UkqyYRl2OOFEppVzXg3O9o3533+Vh65Zl7r4eNk89jPWg
cKilODWUQ+1SmYTQsvKYhSakizoueVi7WCqsedjcao3uL7b+eP3x2j7b5/N5
fz6O4bHHIpaxWCy2EVcjJkZW5KyaTzpDsavl0jdBLIMPJo12n6MpVvrx3HJT
GHizZpykSRS2IWNst3sM1u/v6bZWUmx/UNHdXsMgTRqXLb9NoRNFcX3fM8gU
mOpy1BTPjpSVDI0ykBHOUEMxxRaXi9PKBQYdFr/moyooRPrehUAHMQo97ni3
1VO8S1wI0srE8Ix3NhttpujxC2vvrF7ypJaUy4ftJYuuTLeIK7oiwUmNlWlj
A4VzY5T8ap8E+X/5oYYqCm6HWrR2HcE2QaiQPKaICbfushMRnHDyFzjcp7BR
RAd9khFIUTc1qaJott1UGnyeYMzZxr3kBoWaF+E+kUngEzO9WZpMoVc/RXYp
Wcxn7rh5gKyT4GGlZiM7lkIz8iK/vp/A4u7pHxIFRbC/QuXVQZDMXV2Vk05x
rVXr+7WOoDZy647ubAqJsL65uJwgI8GTbyigOChRCr3UBFkybYJrEUXkT/2k
Pp0gL3ePzGDMa2rQsnx3HEGxzc4MQysF+7X5UTMhQdU5uQXVUjAHZuZqTQm+
uySo1MMUmRln+wq0EjgOqjgDY8b66C8vAwolePWcN2yYoFijO8SdDVvy6t8m
bf6OS97V+zYt74kYvrXjOsUAhYNHhZbjLYY6XlPkWkONfd7wOONL93yUmrjh
wkcGwXpOf4NxfneOj+WfJmZxv5uz9svLKhnUWMlv8bMo/NtPee1VM7AK3Kcc
SaUYDOF7NF1n8P8//gNCPSzm
        "]]}, 
      Thickness[0.004273504273504274]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{172.621,
         134.105}, {172.621, 124.74600000000001`}, {165.035, 117.164}, {
        155.68, 117.164}, {146.324, 117.164}, {138.738, 
        124.74600000000001`}, {138.738, 134.105}, {138.738, 143.461}, {
        146.324, 151.047}, {155.68, 151.047}, {165.035, 151.047}, {172.621, 
        143.461}, {172.621, 134.105}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltI03EUB/B5wUv6MDKbW6tlai3UmqmYIOM0vGVKuVRI5vz/PEuQvDFB
jGVa4sbw2lXS4T0HbklqYeVda7XSvKA9VGRkC6dkpOUwQ/o/9Yd6+D584HA4
nHO8M/Kk5x1YLJYdnUA69nRst3QJ7JcIuT9URpOWgmfanNTsboShMDXrYzwF
X0p8e0QO//ucojzblEhBa2Hx6ooUYfQuW23poKB7s5CXfREhfSvCr22KguP9
BSJjJUKxLmuseYNxzaI58yeP/LWz5obbo0ACO636yfdqun40zfgrgoApku0i
ViHIf1enGWIJWFwXUqryEDqbD/rEJRFwyOxqkVEI08q1cm4qAWXv59vrCYyv
fC/NjxIzNuj5DwaDEIZXhtn8FALf5vuITIiwKaw2X0sg0Jjz2Me6DyE4U3bV
OYrAYkPSjMYTQTrmP/kmlEBrotbxujuCP9s8+05AgDgPhenoffR/2oriHiBQ
Zxtws7oilK2OC0+LCUjN3vI4D4SbyVWhRVIChz3UvFkBwkbk0NJSOoH99mcG
50QIGptmPVFJYCKAe0wRjfD8xNmRGBWBkq8xh15QjA0T7EZOEWOJEfzmKxAq
fVfzOgoIBOe2nyprQNi97DOFCgJNfS02nQEhJHqdG5xM4O2cU6y4F0HoXquV
SxjbpQbWYABjj0t3Tsp3EHhd39aX1YygvtckaLRQMMLprLDS981YcHeKH6Sg
9ujeuLojCEZPXrQll4I7ne2L/HrGivoI/VYbY1+RizKInqdbUjoWnk/3kzl/
4NxHiJFwe14VUHBBH96vekj3f+LFXyukYI9gdlfIAIJXOmdt+zIFM+PTy/AU
YdvUJXCspODf//0DbYc/CA==
        "]]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{158.195, 151.21099999999998`}, {159.406, 
        159.441}, {160.89100000000002`, 169.562}, {162.285, 179.047}}}, 
        CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{158.82800000000003`, 
        179.586}, {163.74599999999998`, 188.969}, {165.754, 178.566}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.004273504273504274]], 
      EdgeForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]], 
      FaceForm[
       RGBColor[0.7921569999999999, 0.698039, 0.839216, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
         1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
         0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
         0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQ3eljvKdyT5KDw8rAxT9/pzjA+HvN2xgSvqc4/Ni6
qNuwGpMPU6+/5lP+1cYkh2L/AhHzPykOM+8nHtzWluTQu93IZA+Qn35mhZJb
Z5LDF91rT5j/pTiY7XzffLU7ySFmSeVU7/8pDnP1J5vI9iY5fH+1sHUuYyqc
r6OidnI5C4Kf1C5wu44j1UEmUDclAKhf8mTCXiW+VAeGMNaif+1JDlmBN/sl
xFIdJv85Vd1cm+QgIv17dZZeqsNW3c+vV1sh+A9iRV1f6iU5bOHvXFsikOow
SfXc00jdJIe6NfNmz+VJdXAVfxsyXQdo38ayld6cCP5app6ZJWwIfr/XDLZO
oPv1/0evqDBChMcFDel7f20x+bDwOykQnOLPjcmHqZ+1KzWtQhARngGX/Kv8
xZIc+KbNYOkEhp/8yz8rV0smOcQlupo9ZUp1sH6iMuevTJLDw0sCN+vYUx1U
z0x+f08pyWHronf1jsKpDqt+aRkLaSc5rNA6sPO9aqpDw39LvoCEJAdhh+9s
KxenOgTUP3Nck4rgu/3cEpC/NMkhYwrv+zqhVIdpRxKbTq9McvDw3NJ5DBj+
Mxp1lVPXJjmUz1/YPhdof3peScuX9UkOE0r+XQllSHUwjd79tHlTksPB9u3F
x/6mOMxLOZIxYxvCP+jpDQAvSx86
         "], {{145.96224046, 169.77803144875}, {
         147.8172970375, 169.77803144875}, {146.88976874875, 
         171.986848815625}, {145.96224046, 169.77803144875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxqezgzqbacOmkrk8pOmooNQieUZRIC6hpRId1P/3/ROVUJBy
N+EKtNKwnIPU2JwkZnRAUURN0240T5nzQHmYVjLTbDozj7j6rhx08Vz8bl6e
9/e+viT9AuXzeDw7LsFc7LmsCiTWFjcGoVWNAdIKiiJFlFkoYrBypm9PvJ5i
5KI0zeDMoNVPTEzFFOkNrSKLA4O3g9PmbDVFxKH0Y3Ieg/455VPdQ4r6xmfq
2g0Cz5cHG9dzKeTVpcKyFYJvdZ8H41QUHvLqzY7fBFdzZYUHlBQhJ0dHxb8I
msrqmxxSKMZLNMq8GYK1YJ1Ph8LGyYLMu4nhNq4YKTj7wIei3axd080RbPaG
d39yoqgeFshViwStXT8NIess/mYpqoXLBAb/GmPNAgsv7dcM6To3L2GsiT/D
QrfrtfsHK8HtrBvJku8sfFXK+iQ+A/Ujq7tsnMUlvTTF4MSgQJRscBlmt/w0
28f2TPWyMFYkGMM5f7llqU0uXSwyd1rux3O+5qsyT0k+smhu11fWbmPgL7gW
s9bPQl/uZtLYMQjsDFpQD7EIK3ZkVJsEt1IzFJIvLOoCIttMqwST2okKvpHF
4XxBjIrz1ZVzfnWK6/eiUxih+kGwvacvZp7bx++p8k/0JMFS6PAU38ri3vvZ
o9JRAo/jG7OxzhSz01cyhMMEEZH7Lc/3UnhviISqAYJlskOcHWhjT2uhRRtm
46JzibLoWIqhtSPqljGCd/PToWnpFG/EslcmM0F2wfUnN3Ns99R6L13W5FP0
sqW7y7j+J5bv7Kt9TLf2i/NynejXUJR3K+uS7BlUmppdpSUUi0H5DXmODE63
RQ1E6yj+/8d/A4tAeg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHdX0LWVVc7KD7DGNH0+TUx0eX4vwLZ+Y7HBt1r01
YTmpDpsOz1/HNgWT39PEyOB4OQXO38MUeubJ2RSHZ5NV3glMTXbY6dqp7X0q
xWGWxEp96enJDqwHWV45nEhxkP7Ox/BiRrJDy6N5kiXHUhyyD+02dJmb7MDM
Yum5/EiKwx6Fc6a5S5IdMp6XqSsdRvB93viZXtif4rD+N8eKfemY/K1fw3c8
Aarfem/+248FCPPaOja9lypPdgiwaVhhBrQv7+7uAv2qZAd5zeOcx4DuKShQ
dP5Tk+zwVpQvO/R0isO+FRmLuuuSHZbo/qjTuYDgf+3mag69juCLVOp77WFP
dZCpX5nDVpzswHPzTPL7XykOIlsfbM9JTXaw1t+VeOxLioPKq1tyEWEIfmZE
5ElfLwTfk5chZapDskO3ytnE9z9THO66aTs8t0h2OHr9xTMdllSHpWqlvWWG
yQ7/u1hysvhSHQoOd1XP1wXqv9h6uEQawXfV2+J1WxvBl/M7nMJil+rwOW7P
G1bjZAeNxm7Zeb6pDlPiREP22SY7/K06P0k3KtXhnPX05Sc8gPEjbVT5Ky3V
wVbDvEAA6N5rR1yqlXNTHUTuu7VZpiH4Uofuns7JR/CteM0NVSuTHd7lW//i
y0p1QE9PAJa2Ewg=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvW9FxqLuumQH1rzZG+eKpzrA+MvPdEvP80HwJcu+
t9THpjrkKHw4P7Us2eGi11rLD6mpDolv1cX/pCH4t7S1Gf9EI/h51h/4GoOT
HUxnt7rOS0x1yHq9b7aUb7LDNBadR08jUh3SZvdqbHFLdviWe6lONyDVwTCJ
8+lK52SH99+vpum6IPjegt4T+EwR/Mk2U2/P1Ul1mHFjzdSPLskOvHz/pmep
pDo0MAd4WLonOyxy1yzZI5PqIO1VYdHtmeyQpV580Fs01cHcdYHWXZ9khzTG
FTKb+FMd2gV8YywDkx1SXO5US/CkOqi8uiUXEZbsMOWIvscetlSH6AdazH9i
kh2OXn/xTIcl1eEB3yE3/VQEP802sispF8HfPju7r7sk2eF4lt/On0D97yfu
LtKvTnaY/urXm1Cg+V03Hic11gLD82TCXiU+RPj66Xif/ymI4MPiAwD8ILaS

         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EYdXNhksMiyRBFpylYXujinCB5NCtSEavZiFqm7/fOC5GSl1LY
KsO1TEIbyyK7iZiXIqfidDpxmmuFa14SvCDdnJqQSZTJKOv75aAf58fhgec5
5zxHkJF7jDo7OTlxWOxkwWVx6cWT8wmNBMpHOXr+GwYzWcWK1XqCHm7q0KyF
wZ1MDUfYQhDrooxNHGfA4fEknjqCgxJdu3aaQWSVOLK7myA8Jmij+iMDPddv
StxHMHelaFE4zyDALVia/ZKAF5Uj919icDJ3ay7MBDcyOcbUFQYHri5ULr0l
CE2uqC7YQKH2D/8hHyX42l+3p9XLwe/5hghGIhz89NHN0oZkiiZLYH62lcD5
jGziLKHos3X4ql6zetPbhnkFFOWlQ3ztIIGHuSr/lZxCUDxQXmMkuHxLVl1Y
RvHQZXWeayDIKRpfPHGTIqvkqUtaJ4FfZ6DFXknh6a1xFmoJLmwTjQTcpev5
/Iq3ekgeUwwaSv+6NbH6G7qCwuoo/rSNfm5h89pybZfMnZ23//Q3iTsIpn1j
xaIaimEvrTJfT1ChsC83sPuiduhdVb1sHsawFHcNRY+m7JlggGCsMT5axN6P
2a3zUbF5CetTmpPKKUzf2/aqxgjsadbjcayfJEHixe5pgk1r5t7QPIov9omo
qQ8ENVuCV2wZFMp3st+rNoISV96yOpVCbHwuVS0QGGa9zT2HHHwulN+qFjr4
udn9GbbtFPf7q6YS3hPEResKTWsM+mtL+wQWgn1dhiOmBcc/iXvz4QefGNRK
gk9ls/pNET5lihlm3Z80xIObM8nAupzQWd9FwE/PHOazfVLcFrXLWwnyrk/y
v1kZ/N/HfzLMNrk=
        "]]}, 
      Thickness[0.008547008547008548]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{143.566, 121.74600000000001`}, {136.395, 
        114.43400000000001`}, {127.15199999999999`, 105.004}, {119.012, 
        96.703}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.008547008547008548], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{121.438, 94.17599999999999}, {
        111.938, 89.48400000000001}, {116.438, 99.07799999999999}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.008547008547008548]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQLbv7ZuTlrhgH657AD6fPxjjop8zTyl0W47DGdG/k
2nsxDmdsdd52r8bkS7IyMzStiYbzK1hXzTi5MNrB+J5pzoK1MQ4l3ULh02ZF
O8x5bvd+y8YYB+4mziuN06Id5i/hmuC3NcaB46it8YtJ0Q521imf2fbFOLBx
FE3y6492ePi943fEmRiHi+fe+rn0IPgzb8zNWtAa7XBs7b/7v4Mw+Tmv1xec
7I12uFisk52UijCv+Hhg/pbCGIdFFQyBuUD7XApTCu+WxzjYB/UJ90yPdnCf
ri9WXhvjcEdb5tqqOdEOj9n3XZnaEOPgEf3hb8QyBP+1uCjb6i0IvtanuCkV
ojEOC7fYZ3ZnAsNj08zj935HO/QrrPsf7gcMj7iSwz3vox3Wdy06q2eA4Fum
z1eSkkDwf154E76SJcZBwnPW4Xs/ox2UXZwFfL9GO/Ssv3g2ki/GYRPz9VXZ
z6Id/oty3riiFOPgbsvUvvdetEPZIu72lzYIfk9MxtRtsQi+7Zy2kxxNMQ5+
JamZXS+jHQKZxK1tFsY49BeLW/z+F+3w++s81ehdMQ4setL3+YH+4DZL+fTl
cozDI7bogvn6MQ5rOzu/uT2IcZhQUjXnoz+CP8dqhXpEEoJ/50LUpxOlQPp+
2RfZWzEO6OkJAARUHjY=
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/Zh935WpDTEO3HfMkq1NYxxg/ICZ4uY28xF8ozfv
OP8fiHGw/35Gf1VBjMOSqVHFDy7GOGhPtNlXFojgy/I5TyqzRvBddc+ubdCK
ccg24+62ORnjYNubdXyzbIyDDmfEkdPbYxxM3rI/fCYQ4/Du9pK/UctiHE5V
/Y+8xBXjcO/96rNRfQj+DKVpCrIFCL5apdZ26/gYh5npbrsTeWMcZGT+6F/1
i3HI2Nuj8FEQaG9/0IsK+xiHeV53GaaKxThc9XvWNN0gxuGag+5TC6D955gC
LFNUYxxKr7d5fATSJzt2fDeQi3FY37XorB5QnUZn/IQK4RgHuXKnaWW2MQ49
6y+ejeSLcdC8UiB71xfBNzacv8Q5DsG/9vbwmqk5MQ79V+cUfQbqd72VXHq3
MsbB4OrXm6uB5lenbwltrAOG56SDVa5KiPCdGzFt3mdNBB8WHwDd5ryY
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUnlI1GEUXI8ya+2UEHU1LY9ULBevWs2hLNksrw6U73sRapJlqOlaWaFY
CWlZCYoZKbret4G4UJkuJkkeUN5Ru3RpeZQdBlba759a6I/hMfB4zMwbm8j4
sGMGIpFIT4CTAH0B2pycJqsIAgtJ2s+DCOstNTfVRPh0tWhzwx5CmVVlVkAg
IU0u7ezxIvS969Zc9iWcqe5/uehEiHzqaO3rTlCOznr6WhP4xK1RY2eCx+HQ
09/XEbIG055rbQldsc3V9UsJVqtqG6UWhPviS7YBcxzySVHckAkh2e+UwniE
o6YqqbxV2Pt6yMcvp17H+83eG3ak6Li8RXJ97W6O82GZlVox4eedxPwSC44Q
2+ggpZmgN2+4PGKeYSZ61lQt6KoIjHwYNc5g32iSv+gg3GtTKYxGGFxyy15I
3QjzM2N9/j0MUoXMJmY7wd76t0NGO0NpS2VmgJwgce4rs7jH/uVzdklNQXcJ
Q12bcaJpOMHEbzDZopBh6IpLV+hegiZ0PNW/lCFW/5recj9CoNmDoi/VDFtV
8ek9noTg3ANau2aGI+WUqnQlTA9oK/xVDOHqLvcEO0KH7JHcSM0Qmh0VpjQn
5K24+7m7l2HXshP2SkOCuKC4+JXgx7tWVuzzjeMjq+s20udY+GFtvviBwzVu
brDWkqPT3zCvQ8ORdAGvg704HE+mPCsd45h6vFK6cFDHPX5tfCNT6LjjjfaM
giaOwuMNI5Jpjouafjb0liOwqkecsIYgkvS6Tq7W/VO2baLVUULI3pE2rN1E
UEwZ+MYIOf/1V++5oU25heAm9pHEeBP29Z6z4cIceHLUTiX0LDM9r+L2TsL/
ffwDDoUmmw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        118.35252742912499`, 113.87178144875001`}, {120.321337476, 
        113.87178144875001`}, {120.321337476, 113.37551631312502`}, {
        118.35252742912499`, 113.37551631312502`}, {118.35252742912499`, 
        113.87178144875001`}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYjHlxc9veMc5iDloOu4wjnWA8ZvY/qWkWcc6
fNuxTpIpK86hrWHqsplOsQ4cvg7Npq1xDp/csk65e8U6iFtabjadG+cQy2v/
7mtgrEP9TScjr/lxDpq2u9a9DkDw/0bYmlvLx8D5B1+ECqYIxjj4HeucfHNh
nMNu1v2nDThiHFqCbxXXLotzCPqz1UOGJcYhZKXCTZ7VcQ4y+akZFf+jHXpj
bOK8tsY5+DbJsb/8E+0wY2fW0w1H4xwkN808fu83gl+dz8N44Eu0w0b7VM44
X0w+TP07CR9j09g4hy3nol8m/412+Oq/XpQpI87B3/7V8iaGGIdJmrY3FHLj
HOSnGvAKscY4JNU3224ojHMIVWp8u5UzxsEg59Q8+5I4h2hWCeOXQgj+9NL/
EQcUEPwLRcJTqkRj4Xyuqt9bAxVjHab5c9TuKopzuNPDu6dKM9YhQazFckN+
nIOwVNwcOb1YuP01yunyxkaxDgfrta59T4tz8BJY13DIJNbhfY7EhXNxCH7w
n07BDdEI/jalP34Tw+IcanvSlI2BfIkHeR1F/pjxDeMDANkl2aY=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYq1pwS9r0uMdogOKfWP8Yh10g+W7xLLjHdQb
3vEG+SL4x0+/CZsuFQPn96y/eDaSL8YhqWfxWYW8eIfg1K0+MmwxDkZm2857
lsQ7vIpec5KdKcaB+cGJi0VV8Q4v5j3QyPsX7VB0JmPWrvZ4h2emD1Xy/kQ7
1D9LOrRrdryD5KaZx+/9RvCr83kYD3yJdlBhU7vzhg+TD1P/5/c5dU8FhHnm
zNs9FXQQ9l11dRGwN453kNMx5BRijnHgm5AwscY63qHd1KpHjT3GYZWo0nZG
+3iHrztuBeQJIfhn1zXPOaWM4Cc72+ec4Y6F83MX5H42kol14LWZ8uWRZbzD
zTQn8YfKsQ6XOyryl+oj+JliBS8maCL4f/1nH3mkGO9wQ6isyl0p1mGi6S/m
2RLxDja9W0IOycU6aL3co6gA5Odz5n43AvK/SVg8EhWPd+DYqy+6QzbWIeZP
6YEJovEO1pYvtmsA+Ro6HxvaROIdrrxZdXUt0D1qhz/WtAkh3Kear/rgjUC8
g9WFF5s1pGPh4ZfjszBsplSsw55UmdgbPPEO8zerTVosGeug5BllHcwd73BJ
/76JCBKfU01fcoc80H1o6QUAZe/pPw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcxw+nkIfzkJxDoXm4Ua15bst7N2rpKk6hvr/ffCt68Hge/tDs
arnUSMW0FitDqxNjJKMHKdmu4zA5FVnjzDWjMss/N6rfX27rj/cfr33en+3z
8PY+kytLt+DxeGacxJzMOd38O/7mqzmFXfREoaiWYLmnZaSMR1Fk2Xxf00Dw
tFudoLamKLG3Vd5rJ3A5HqZqElCUt+VcPNtLEDd7/YZ0K0XqZanAT0MwLJOJ
DUIKrdkPXbaOIIwhrUZPCut8nTFGT5DVF9s35k3hPGpe0rJCkDTmPnslgOLU
A7fdCwIGT/JPxzgEUUyXHkpP22fivdEpksY8E79o3PEy/hGDXs+U90auf/Nr
bfs7LYPx0IVcoS+Fsv9cg/VPBg8//mEl2ykCK32/3zZjEaJZnQoWUfA8h3ct
Clh0JIsj7rpS6JaaJ1o9WBQPTiYvO1JI5IdrV/1ZiLPUiWobivkgeePBMHbj
Pr/K6gLbDrD4Ytd1rM6CgsQXHGGOshDwLUMknN9nU7LWi6urY0+4GhwouqNL
muT7WcxlzH3iu1AI13/PJoSzkBYunRS6Ubgo2XqvPSxG57vXnnlQqBLLiuR+
LGRXF7KFPhRZ0oakGncWkxKDUhhMsdpXp7rGY5Gap1BLQym2rVUpiIHBWtyW
8swoikhf2dLQEIOanTXS8mjO72Q149/B4LzjTKtQQlGsiay8VG3iYeKe5l9g
4qkPioHBcAZtTgPi6QiK0qKcxQoLBhMrzwWdfhQX8ourKz6b/qn2SroTNUTQ
pSItRm7+W5lRNutvycZ+r1IC+LoeAj0UVhHOFKL+kXoRl6cqfQbfwZZCb98p
+vaY4P88/gNd+x+y
        "]]}, 
      Thickness[0.004273504273504274]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
        229.82800000000003`, 77.57799999999999}, {229.82800000000003`, 
        68.223}, {222.24599999999998`, 60.637}, {212.88700000000003`, 
        60.637}, {203.531, 60.637}, {195.945, 68.223}, {195.945, 
        77.57799999999999}, {195.945, 86.93400000000001}, {203.531, 94.52}, {
        212.88700000000003`, 94.52}, {222.24599999999998`, 94.52}, {
        229.82800000000003`, 86.93400000000001}, {229.82800000000003`, 
        77.57799999999999}}}, CurveClosed -> {0}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{
         0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{215.47995890875004`, 
         77.11208734874998}, {215.47995890875004`, 76.21519671749999}, {
         214.06680928000003`, 76.21519671749999}, {214.06680928000003`, 
         73.87890599999999}, {212.97304021750003`, 73.87890599999999}, {
         212.97304021750003`, 76.21519671749999}, {209.03984666875002`, 
         76.21519671749999}, {209.03984666875002`, 77.11208734874998}, {
         213.44992352875002`, 83.32907069999999}, {214.06680928000003`, 
         83.32907069999999}, {214.06680928000003`, 77.11208734874998}, {
         215.47995890875004`, 77.11208734874998}}, {{212.97304021750003`, 
         77.11208734874998}, {212.97304021750003`, 81.91373353312498}, {
         209.59985642875003`, 77.11208734874998}, {212.97304021750003`, 
         77.11208734874998}}}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{164.63299999999998`, 36.348}, {
        171.11299999999997`, 44.69500000000001}, {180.691, 54.863}, {189.656, 
        63.074}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.008547008547008548], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{187.434, 65.781}, {197.281, 
        69.68799999999999}, {192.023, 60.492000000000004`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.008547008547008548]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7SVavPZkQopDscTiB9Nvejtczrw6dVpeikNYdtXm
qN/eDovCZL6rFmLyDbjYGFime8L577lCDCc3ejpcU1toZlCU4vBMTHWdTrGn
Q9dq1QqrkhQHERbhFczZng7cXd0e7GUpDvxd1WkXkj0dokMtqpKrUhy4BJ6o
zI3xdFiz2auupzHFYcHc23M7whB8w43WVx08PR3m97V+uOuCyb96Lf7hpEhP
h6WFMmaCfgjzyqT1LaxCUhycPjIsupXk6RBXYLHTLzzFoXqJjLpErqdDAvO8
bumoFIet4RZrQss9HdZZP321KjrFoW/bg98buxD8K/paPGHLEfygJ3s1PmZ4
OfAIqW1VDQCGR4px/15TLwcWj1iGHqcUh7d7XrRJyno5iNSGp5cbI/iRr68K
5qoj+JYLatZskU1x0Jtk0r7X0Mvh7M3lHWxiKQ6i8Ytnb47ycpi68+PVqXwp
Dn+0hTasbPZySAhjP7KPK8XhtYs43+XtCL7ozgtauT8R/AoL3smCTt4Ojz9a
mKoKAMOTRa+sosHboeXjxDl3pVIcvry29d62ydth3znhD89VgfpzTjx5+dTb
QXf35h36QPdGCAu/7f3n7cBSdPhchDOCzxUaJdLjg+BrLdhc6RKW4rBt/9sX
1p+8HdDTEwCzigG9
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvc766atV0SkOIjtyj5Wt8HKA8eca6edV1HjD+ck3
7gr/2+/tELM5R2JrcIqDq/bWZwceejsENiyJl3ZB8E/tW+4pbYngx53LCV9g
kOJwJUdMrPKCt0NUnfUTS60Uh3ChDR3T13o7hOlxFV5WTnG4td3z99YubwfF
r626JxVSHHbfD5+9NQrB13XVcbSSQ/C9P4Xklf/xcujI1rwnoJTiYGrxI37V
bS+HgmlnJkSopDh0yC298HGPlwP33S8Nq9RSHFbMPcOqP9/LQf2GTPEfzRSH
mawLik50eDmULz65JEIvxWGCYOH7xCovB5Ha8PRy4xQHf6H9Ch9TvBy8i5d7
S1ulOIjGL569OcrL4cJCu34/JwQ/7MLVS41eCP5yvRfXVgWmOMistnz6LNXL
4b6KxW6/iBSH2FWvN4dXezlUZSesXhCV4pCk0vy1qwkR3pYbdWyfT0TwYfEB
AKtRu+8=
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkm8s1HEcx12K/B8ekJUtqdnxgGwkkzcmfr/7iVDdUmP2tQqXshq76fx5
0E5S9FuJnU60XXLouulunb/5cy1qN8q/7R7UneS6aJkNRf0e0XrwfvDaPn/2
eb8/+7MLUnNsbWxseJz4nHZwCip9J1zSE6ibvjRoZxnoh1cSY94SGD2j0s6N
MnDVzwzbDhBs3CPS+nYGLfy8K36vCKypct0floGo0adG0kUQpzaJxCUMLIHJ
383PCS4qm82WHAblfsdzDUqCWxPZaRkCBoK+DOHaU4Jre+zi7/AZZLXfDBM0
E8xLZi0eiwK4O2NC94jA1FYs2Vu/zbKQMYeKwG2+mxvpc/ANjfUsKt3wmGA5
3BQUd52GOVGrUCkIfvE7BerDNEItm44xbQRU3ZBY70wj2a16NLOTm3fj6jfX
RQrjZcLLa2qu39jVWDlJ4dTPA+6sloA+tp68s49CtcfsoG0/QfhpGRXeTG35
s+SYHsKWU/DwcorI5fzzljxbCCukoBDLTFKuvrvl/Yq0gsKPIwxvjvOLDS6O
mqul8MGzFyMvuf3+in5BE4U8x64e1QuCmdaBpMoOCl8fLvh4dxCUFklY19cU
yIamVcX5FeB19BM7Q8EYqWNVjQRewdHRPS40hC7+KZL7BOMaIesWS0MX+qA6
s4YgY9radqaIhu/Z3aOoIjCvlg3JlTRSRAOXVFKCqap95Pf8Nl9YTRgpChBs
8Qnf8l0hcgEc8o3WxVqC1V65RmnP4HOV1c77CcFmRMP5ycx/8iw0FJwsZsCb
is83tHN5TtuLx24zW/cJRShJaGTwMcrfjdUQ1DUsx2o7GByShXl29xI48QKT
QgcZ/P+PfwErMznk
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYk7Jki3eD1MctBqCmgqW+jjA+Iy8f06e2eLj
8PNxpW/ChxQHbkZtX+PDPg5M65yYfv1NcXjYe2VK/yUfBy4Ve6lfnKkOO6Tq
7rx+6ONg9+VwJAt3qkNAVUns9fsI/o+NVXllNV5wfv3F1UonErwclmalc/nw
pDqUcNdNT/TzcnDY2P9rLl+qw8If2RMt3LwcNO4YrX0qkOpgeu/UhQ82Xg5H
tx7IZxFLdZjBYst3ydzLwetJ+GZzuVQHgxTj/r2mCP6XexJMDepeDmHqoa58
j1Iw+DD1Xyd73Pr5MsUhbe72S8ctvBwq9Ku8E96nOMytu+LPau/l4C5zcM37
jykONlqJUioeXg767inx5l9SHFa6MN3ODvRymLaXXaD+a4rDVi6DtEvJCL7u
638bG+oR/LlP1TS+ZvjA+cJfvmUvbvBx8FyvVr8HaN52SemKrxN8HNZNSok1
/5zioGyyx8J2lg/c/q9u5+zSFvk4xB/frn37XYrDJIUYxtblPg7f9q5bcewV
gr+iNd3T/CWCf3OGwovlz1IcfkicdUtb5uPQ9f1mi8RjzPiG8QGR0+aw
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0l1Ik1EYB/D1dlHLEL9ICYdp0ObUchM/KJXH1Gnve9pyNyqGNu1pYMVm
qdMiNKemMddIEFqJpm0pGSs/0C5SjJRKhEoNE5YvFSFWFObApWnn7oW6+F/8
bs55znP+4cUGLW4XiUTbaGJoGJrTO+QSTzuC+mwzN9jPgufn/kb+BsLqhxCm
VsqCvsNbfCL6f6/LXdyAkoW37ri9fD6CquppdIaHBf5UjIo3IIQWKjpKtBzo
I+Qn+UsIP8qcYvMDwXmBgd9bNgUv+JuuGyIJcFKm1GpCyD3nDs4hBIIU/Q3L
RgRmUNEh1hOIDHOXJJci8Jay2FtXCaTc25lq1SFoqv29vJWA5NCxXeJcwezK
6/hAtWBv66hiWYXwaLr+4LMGArKggM2WNASx6MVS8gUCjireIk1GKFH6dA8X
Ephbi8ufSkAYUD3x2TpCICnM2danQCgq6k0YFxO4nRky20L3sZGU6F30JdDO
fC6XxiJYHLqCAg2B83W2HnM8gh8pVBqvEBjju/r66Pmj+HhcdofAYtSGP9J5
4LDLljJJoLYmfM+wlt7X+cU+skDAyEpdUzrBrVoyJDEIFr37Vo10fxUX42az
XhKYCUB1gRlhLWRadcZJ4L1nvdVqQciOuex6aKbvHe+ZWLYheMeY0O48wY75
FRUeEOyskYV2zXMw53i1T9aIYMxMK79bz8FkxJtVKf0P/VrWpEnGgWkoTyfJ
RPiV+Ck6vYL2YWmzxlonuFmuKVY2CXZq3BE5dB5Zmd54vIqF+x+PeiS0b7/N
1ZWVtSzYEkml8ibC1h+/kd5rLEzYE5rEbQg+z1PT/ewsZO9morrtCF8zgn1n
hln4t79/ARyDOZM=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+XkKU2jDZkwuVbLpJTKbt7Mab+7b7iUi5KYr5VKD1Q3ayyx
SFQk121dbj2Qp5DJQg+ruJ2HJI+niyJcphJKJ3R/na0/3n+8ts8f78/r83GM
PLGbsvT09JZos14bfW1MLp1d2PGMwjqxSL31NINY+Juraym+m+5xy7nAYK1X
TDb7DYW+nbWhyx0G2X09I0bNFJZhqvaGGgbyw+vkxW0UdX/FDqSNAV85FcPt
pMhjKR/2DTOoGpwbD+mlMB8qnE7X5+Gr3+jCRhWFs3SpgdCJh4599Y79gxSV
29wOtofzsEbDSo0doahelqOQVy1yZGJ5iq8jX8cnud7xshQ+PO9rWKFDFGai
WxEXu/kQ1GeUiz5SGKS2+FiuIrANlUllSopAh52tdt4ElYFi28wuivntkrCu
cALX/mbR5DuKB717i/efI/gjOC8OaKFIHrjpPpZJUDh55Aa7gaIxZMD3ahHR
+VFZcoIONBEE5wqvzWn9Pc4fltQoCbIyCuJlWl8+ZmVijoKA2/I7mNtEcSzJ
QPDpKUHEz1SrqLcUrhr1q7slBIrZLInoPQXbsBYcKcGu46Ecix4KUmAxMXCZ
oM34SplI66tb7FO6KY5AqEh7LRqlGE3iBJh4Eahm7I1LflC4zDjNVpsSJLSX
KhTTFKf87vXkdfJhVeKZqdZo551XvAjI5+OLOPmbaI5iOjvOYTJqkcVP3OX+
axa54vpsWm4pDxsk0Uc9pyiMJj502XB5CEoQCiw+U7QO/WLbjDO6e2ZwSlaf
6WCw2XV+LETb36o7fqXmOaPbL64i0LjwEYNDcnsmr5ViS8ptbw8pA/OY5dzY
RoqXdtEedekM/v/Hf/iUQFw=
        "]], 
       JoinedCurve[{{{1, 4, 3}}}, {{{200.754, 89.566}, {193.324, 
        96.91000000000001}, {183.637, 106.48}, {175.15200000000002`, 
        114.863}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.008547008547008548], 
      RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.], 
      FaceForm[
       RGBColor[0., 0., 0., 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{172.44899999999998`, 
        112.617}, {167.79299999999998`, 122.133}, {177.36700000000002`, 
        117.59400000000001`}}}]}, 
      EdgeForm[
       CapForm["Butt"]], 
      EdgeForm[
       JoinForm[{"Miter", 10.}]], 
      EdgeForm[
       Thickness[0.008547008547008548]], 
      EdgeForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]], 
      FaceForm[
       RGBColor[0.890196, 0.10196100000000001`, 0.109804, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzeH7c+1KqxQHt7UW77x5ox0mLoyeVuaR4rA9bEm4
rly0Q0Lfou+s3ph8FbVXfxnfRML5LWoTp3k+jHSYEqduLuCT4lC/5meI2K1I
B4/Hqyuk/FIcxBZ/uMh4LdLh5EFBz+f+KQ7Cz1QMMy5FOkj27qtyDklxENSM
nHDuXKRD1usLdTnRKQ533l/xOXIawV/ysyVD4WikQ+wx7o975TD55TzT8zzP
Rjokr1xk9lEdYZ5J8FYLKb0Uh7Uzn/u9vRjpILNi3049wxQHr+JSQZ7rkQ5y
1io9v41THJ77MF/RuhPpkFOc/brLNMUhuOb67xtPEfxvFn+Ytb8g+KbCbpN+
hEQ5nPJcs5VVCxgelxuOxllHORyqf8yQI5Pi0FwffZBHP8rh0pa76eG8CL64
coyQLyOC//0609op35MdlLMaD8ZZRjl0C+p1Pnuf7DD9wo7TN32jHII/ll8r
fZHswGX+4WpIUpSDXF/vkXlPkh2aDn9qyaxB8KfX+k82m4vge+zNPd5xMMph
oeZ+U9ZXyQ4xyv8s9jyIcnDSlJi790uyA5t4m/Ltn1EONWyzPhz/n+wgFu79
oUQ42uH1J8ud/ED37lhV8OWYfLTDoZWe5y1kEfwTPQ9EctQQ/BfXLatUDIDh
xxD3aa5ktAN6egIACCgR5g==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnVOc/brLNMVB7K9s4u6SKAcYP3rXP5M99xB8W95r
7PUM0Q5Srz9JTNVNcVi/zbEwQTDagX+HVsJvWQS/45uu128hBF+G7XN4A1eK
Q1n4p449HNEOEtsOPpFkSXEw17I/5P09ykEkbULh5r/JDj//dP++9TTK4b4O
j97KX8kOLwUmn751FsFf7FwrN3c9gm84S3Dr7nlRDm6L19/78DvZQd32sW5o
X5SD3rmgiRb/kh0CNlg++1EX5XBSpLqxiyHF4UH+2QbxgiiHp/yLi+8wpzjc
VDY3f5IS5WB623+pBUeKw5WV879uiI1yuLTlbno4b4qD8Sq3vh9BUQ6cq3V9
fgunOEy/sOP0Td8oh76bR/r1ZBB8EY6Yy4kqCH5qWt71Lu0Uh1nfmguKg6Mc
5sbs261nlOJg/e3Ode24KAeLxc9WN5gAw3PzioqjiYjwXVFZO6c4E8GHxQcA
yaO+vw==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxuc6SCytEFLp5LS0PBRRUjPSZx2UqYSkqN//k7X0r8SUZhse
QrMlzqWl+ekIa0qelV3IKl2Gh8CWg1rOEqOVWaIJGYpeiCIUfVcOunguHl54
D7/3EaerLmduEggEbryCeQl5zVsSGUczRdYNEjdZxUL3p0gmbqNYN+mCjpaz
sP+9MjLzmKJS6TscX8DiavpyrtBAUfrW8vW2kkXIRFON/AFF9/rnk4NyFl0Z
EwvWSgoUnM7NS2QRRexKcznFh8r6zrBoFttWp1OdpRQjYUo/WziL/T+3nwop
ptAqkjQV3iwc50fGjYUUf/MDznoukA3/RfJeKLW4fNKnzfdqywj66h1J5iKK
rYOpBjFL0KKN7OLu8PtahlqdEoJlsU4k1lE8zZH1zwQSeMR42aMq+H7fn2j0
3gQ1fVPXnVUUW3YO260iAq9g0y5NLcVxzB4SCgjiYhXWmUcUh+N7W4zLzAaf
skDuoWyawdglThLL8/NRDKiNTgaZz/xnr/G85tWjhVa+3p370e0NzytZ0tqg
/sWgNu6CtKOGgjyPmGpfYnDk3Jkh7j7F2oqtzbrKoGNMtWdNT2FP64jRuxH4
h0eaOJ5XU2jZosyDwKiRGrgCCu+X5Y3yIILdF00JchXFSnGdTS8luJm9tzpK
SSGp+jYekkYwyVW/88ukKGkM+uHIJ/Bsj1Fy6fy8uZVjJQaXxz7RdH+Py58w
d2p9lghsrRkLo9kUdwUvmOSDLJpeq93XblGIIntCsxNc/4wmjt6uNBavPO05
Zn5/rcfviLksduO+vhT3gQAVi7o80w4NR5GyqDgwyedpdnzAq6GegmsubvMt
ZfF/Hv8B1VE0Kg==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        166.016590429125, 106.86396844875}, {167.985400476, 
        106.86396844875}, {167.985400476, 106.367703313125}, {
        166.016590429125, 106.367703313125}, {166.016590429125, 
        106.86396844875}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYlbGeyU60qkOiokC9hbF0Q4wfq/606RnVdEO
X08/5nXUSnWYuLBmiWRTtMO/qWsO3TJPdfibHnjieGe0AxvPylu3nFMdMvTU
3pROjHawuqMr9dQl1cEkbuGa7AkIPkeViunuuCg4/wynLf+TgCiHhUEXT+m4
pTocU1t2coN7lIPNzJ+76jxSHWJl57rNcY5yUDkyJ/eYV6qD+gSftB92UQ4H
52oZPPVPdYhYzMqaaRPl4HbmYLFERKqDyuWGo3HWCH7bhM//7E2iHIL497O+
l8bkw9R/rN4065ZyqsP+907PHwPNKxF/wu2omeoQlXBxKZNDlIMzi3buBe1U
B61t4tyTXKIctPXPyUvopTokOGe8NvWMcpi0tPBCvH6qQ5raf4PMIAR/0bRn
YQ4JCP6tyb8m/gqJhvNFZz/afDEh2sF1+gT7uUDznq/9svNXRrTDqqpzshK6
qQ5y1q6z5uVGw+1vd/GT3VwY7RC9XvHNbo1Uh1DDqXVOJdEOn5ZKZC5XQfCX
5F7klFBG8K82dK3oUEh16Fjrq7gZGL9t951df8pgxjeMDwAxh9sD
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4n6rbaX/VqQ6pBVGed/pjXYQkJRxO70q1cFo
4VXuSz0I/qU3l0PEo6Lg/OkXdpy+6RvlsMr0XnrAmlSHuLY5XnNcoxwmdz1/
kbI+1eFrzeTj7Y5RDtX3P2RWbkp1+Lz/uNo72yiHzVcd/GR3pjp8DDuh9M46
ymHnI9sk2cOpDiqXG47GIfHbJnz+Z28S5dBTJJ+/rQaTD1Nf8fbzlJRWhHmi
H5+rBnQj7EuZpNd5vy/VQdNXgn2SU5RDw/Y9nv8mpTpMClPsWuYW5eBXNffO
gSmpDgy3Dvq9C0Twb5zPmuWVjODnpahl+XhHw/kVB0M+boqOdmjoDas2BJr3
pF1TNDE52uHx5hM7hHoR/HVVLqUcXQh+hXhUsmFbqsNj49iK44nRDk5dnM29
jakO7utmBznFRTvwP3klGADkV2mFfN0UG+3wtVrj06mGVAfhe2LCFkD+8lz3
RA4g3y3q/NYVMdEOvaytjs31qQ73eSdd1gXyeQNb7ZvrEO7jUZcv3Fab6uD6
8fzGFVHR8PArz+0IkQTyIxbN0l9Tneqw6grvBOXIaAeuKTvnvaxKdbgbcMxo
SgSCL+IuJm4RH+2Anl4A4pQDhw==
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{177.440938861125, 107.10397576875}, {177.440938861125, 
        108.85652922}, {177.969704988, 108.85652922}, {177.969704988, 
        107.10397576875}, {179.721008401125, 107.10397576875}, {
        179.721008401125, 106.567709413125}, {177.969704988, 
        106.567709413125}, {177.969704988, 104.816406}, {177.440938861125, 
        104.816406}, {177.440938861125, 106.567709413125}, {175.689635448, 
        106.567709413125}, {175.689635448, 107.10397576875}, {
        177.440938861125, 107.10397576875}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQvTDowdfaT2kObmst3nnzRjtoLXe658WQ7rA9bEm4
rly0w8/Jnfa3mDD5Kmqv/jK+iYTzW9QmTvN8GOmgm8JX/4Q53aF+zc8QsVuR
Dg9fTDrwjjXdQWzxh4uM1yIdko7/mLCbPd1B+JmKYcalSIdNk5YeEudJdxDU
jJxw7lykA/PH7ccchNMd7ry/4nPkNIK/5GdLhsLRSIdvpz9ZTLqWhsEv55me
53k20uHPus66o/fT4OadjZjT8O5pmsPamc/93l6MdNi6dikj88s0B6/iUkGe
65EO2x24r5x/nebw3If5itadSAfWyiDj+LdpDsE113/feIrgf7P4w6z9BcE3
FXab9CMkyiHZf/Lfmw/THFQuNxyNs45yiG495eFwJc2huT76II9+lEP2riPr
tY8i+Bs0nKMUdyL4E+6+/JKxPs1BOavxYJxllIOKuOjFXcvTHKZf2HH6pm+U
w5tvcXJeC9IcuMw/XA1JinLYPrmEp3hOmkPT4U8tmTUI/vRa/8lmcxF8j725
xzsORjlY6S+rvbkwzSFG+Z/FngdRDrf1/j+ZuCbNgU28Tfn2zygHUZ5Giznb
0xzEwr0/lAhHO7T8UGB8ciTNYceqgi/H5KMdotcbiPNeRfATJx2PcbiH4Dfe
VTj04zkw/BjiPs2VjHZAT08Avpgejw==
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzVoZZBz/Ns1B7K9s4u6SKAcYP3rXP5M99xB8W95r
7PUM0Q6bP9xMyHya5rB+m2NhgmC0w4q9givOX0XwFf+ITDp/CsHfyn1rfsih
NIey8E8deziiHTbuXqHzbneag7mW/SHv71EOa7PLd7ZvTXP4+af7962nUQ4V
Rp9LazelObwUmHz61lkEf7Fzrdzc9Qi+4SzBrbvnRTncXzFN7ejmNAd128e6
oX1RDscvW97k2ZbmELDB8tmPuiiHJKmkk3E70hwe5J9tEC+IcqgT7dq9AWj/
TWVz8ycpUQ7nHpi95TmQ5nBl5fyvG2KjHLJ3HVmvfTTNwXiVW9+PoCiHRRtE
ppw/neYw/cKO0zd9oxzU76++znQFwV/L6yxtdgfB/5cdKh//OM1h1rfmguLg
KAezpKXMzK/SHKy/3bmuHRflcHHF2c8hb4DhuXlFxdFERPiuqKydU5yJ4MPi
AwAPaMgX
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx++wcRw2ysOah7vJCRdxmyzHW10rTDljdr9vM5345qFRnkIe
/riznk6OHsQcLbG1UVTWSmsdqkkrx9IDE7rZycOpbHqa7i+39cfrj9f2+efz
+nx48rzEDEsWi8U24W/CwsTTqgsbHm4Ubmn9p5o/yOATnu44spVC4au+GjMj
w1RYVT3Hi0IV9L3axSjDwfGl+YXtFFfeJNO5PzJUHo18WetPkd0a6tBhw4A9
xsnxC6KY4I/rlpwZZE86LUeEUmxpeLw+yGPQFvV3wzmMwtNoqAoIYXBequNp
xRQZTzYCsxIYfPzmppRGU8x3BKd/KTO7OC0K/B6zDw5YP3w7y2C1xdFKHEnh
NHWvO5pLYN3Xdpfspqidi289JyQYTezTKEQUoh5bvUM0wfGYrm35wRR2kfcD
cxII9BMzp98FUEzb148JjxDciVU3hggo4tUhjUWUIHWx8jLHm8IYn9L2oohs
9vl1WynYWUPArc2t+2zql3mSiZtUEUgU/YUKUy+hIHJYoyT4PcRN8TP10qZl
dRgrCFy/Nrke2EHh4zk5PVpMUP3jZhMRUni1SzSaPALLzDzx2i6K3sL8YmMG
QQ37Rjcx9So5cTbJnSGwH2gZJHspWDPKW1YgaFgV2VyKpeB7lJZ/2k4Q/Eo7
3HWYQiIJX4izI3jdnqAaSTLNi1amOo0MmtXXlkkKRc2Cd+1Pndnfn2HLO3vN
rjcc08aWMJitL8/xPERRdz3ZwN3HgFOQK13bQ1HQIFdzXc331EWJVY9sGRgE
zosRIRSNF3k2FSxmc7/npY4WSesyuDwTxZT5UfjOPdA0r8gwJOfvl/IoloKa
3FP1Mvz/j/8AcKsjbQ==
        "]]}, 
      Thickness[0.008547008547008548]], 
     Style[{
       JoinedCurve[{{{1, 4, 3}}}, {{{205.60899999999998`, 
        62.242000000000004`}, {199.129, 53.895}, {189.547, 
        43.727000000000004`}, {180.586, 35.516}}}, CurveClosed -> {0}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.008547008547008548], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{182.805, 32.812}, {
        172.95700000000002`, 28.901999999999997`}, {178.21899999999997`, 
        38.098000000000006`}}}], 
       JoinedCurve[{{{0, 2, 0}, {0, 1, 0}}}, {{{182.805, 32.812}, {
        172.95700000000002`, 28.901999999999997`}, {178.21899999999997`, 
        38.098000000000006`}}}, CurveClosed -> {1}]}, 
      CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      Thickness[0.008547008547008548], 
      RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.], 
      FaceForm[
       RGBColor[0.2, 0.627451, 0.17254900000000004`, 1.]]], 
     Style[{
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
         1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 
         0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}}}, {CompressedData["
1:eJxl1HtMU3cUB3CKQJSqICpjYFxhEaFANtwqkAgc5f7KWCWD8ZBFKNNfRJ6D
zU2FICCviUFsJ1KxGQSwIlhGFQId0AK2IJNheAgEy+qEYgWGo+Mlsi27+wN+
yfbHzc0n+eXec775nWN/MvnTU8ZGRkah9PPvm8rSuLqsYejIlVtIf+JCDlMl
nJsiLjebzfGdxrAz4VTWQi0XWFNBoVtnMfQZ7FI+KSL+3WZc236GeNPg8KUS
Py40a/wHVl5gyJGkLDTu4cKBOtkVtRYDs6ui2ozBBWnG2x8LRzB08SJEJ3UI
bouzTfh9GNqOOe/6cxhB4suYTJaKeHYLoz6kk7h/+1gbQ4khPFr+2HYUQYwm
LoH1IwaDoO6Y2dj/3ausDhA3E0/GlfXkN2L4zL15xFaD4Ll0cP+cjHyv614t
R1yHYYZ6a/tQHwLVoraYUUvnIU/qPqtEUL3aVFl/G4O52sfPUobA0S54cOIW
Bs4zN46+injNxUpWU0q8rzw2NvAyAks3x0XBXQzy3IfVphcRfMDhvZmQYwjW
KZwMGQh6Ug8fmhzDcDTeUa84h6Bxb/r7/EkMGQN3HXrOoo28z+XtHitOQDDq
WHFQNo9hoDnimkUEgqJYg03oMoaoYPuCYj8EkWGeaZOvMQTuiGx740xcvrLZ
7QiTmNVbJfpcR4Fjj77UdxFDVYq3eWYntfG/pfCZtO5KCi44uR5tGcfwpWyu
6t7XFPisnc8L6MVQUiO1deBTIHrlYC5sIq5pyvYLqCUuOKyyUJdjMFYHauJO
U9CfuO14iAiDxmGZ3Z1Ggc7gyZEUYciev5/CK6Kg2LFwU8BlDGzBF8p+CfHw
6ANU0EFcfzDh+tQQBdamfwztLsQQZuKkiddTwIsdn/rtKoYTj8JiBlYpuLnl
3YD0axiSBDkGj60I8uxex7NvYvhIpE576IAgIiLFl1WFYUFrY5zljaA1YyKd
UYbB7bsPv1X4I5B3Wo+fps//7N0ZPB6EwGNSxhTfIPnn8F0fCUowjLjPPzkS
jYATxPN6fB3DN7+kl5+IJQ64sf+Z4gyx4m/+tOclBAkNHJ6kFENMma2HshyB
Ocv5V0EFBm3GdHZiKwKf+bp3xJXkPl4RLmaz6fuYfWvbVWUvAuHzfcsCKZkv
SUxw/wTdj0kqkz+0RPqx9PWa9trM3eh/fV7X619h3vnrPXcuGGd1r6qK6bx1
+qJ2HvFMGfV9YSLxIW2rp0jMhb2S0JYJOo9wK9klkYoLo6nmySF0/QPqC+No
kguRdyru59dgeJHxdMbKxB9Kjis81A10/8zcA8k7/SHeRazNbyeutJ99wO4m
7hjThlnT+6LFK4+dbOEPWuHgS8YTDFn5cRJ3U3/4YUfmHj49P7sSe3TTa1yw
Qa+SfOn9U7vaHjW8xIWL56PaWfQ8PZVLo6UGul6nvIav9MTr+/G/Xt+P/wDe
J27V
         "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQHV1n/WTnimSHbjv+5mxrV4eIiAJ7hcXJDg++7fq9
ScHVodPxMP+R+ckOVwx6C3z4XB3eqTC+s5uX7DC7tvA1H4urQwiH/Zmdc5Id
Ek+Fpl386eIQfO/G3zezkx2i6vbLzHuH4LceFrnr+BjBv6sc2b/ntItD6Owl
89qA5s/7tvSE9y4Xh96JX5q0liU7JBV2W/OtcXFY7flCVGxtsoOa2PWaufNc
HOraEl5xb0t2eMcVYjh5uouD/AZ5hYkHEfzSjpOpb88j+J4Ry3k23E526Nv2
4PfGBS4OL94xFGQ8SXaYWcPXLrHZxWG3dqVL3Ntkh6KNARwrjro4hN9eYLHh
Y7KDdCBPmO5dBF8v+YLW8V8IPvsMoTVhvK4O+Rv+tma8T3Yoa9lUMk/K1YGt
ts+k/VWyg8f0I1XHlVwdmrkPT3z7NNnBVzBmzy9NV4d/d7T9dt1NdvB/HHXk
l66rgyav3/LvFxF8Vo9YBp6DCH7N51/i9puTHeRV8g4pG7k6oMcXAPMxz+M=

         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffjLvSmMq5Id5rPolVVMc3OA8bNOrzTKm4zg17Us
vuOS7OYQZ83eGrwm2cFw/+GmXGs3h+N5ZddMNiY7NC8t+LxFxs2hri3hFfe2
ZIdr3bIpf/66OvgZFL8x2ZPs8P9fscyCd64Ou765Czw+jOAvubct+chJBF89
oIkt7lyyw0XBNqWT31wdNHn9ln+/mOwgYG/50pLDzaFi3RSu9qvJDltSYr92
S7g5/Or5dSv4erJDf/a8Oml9BP/qk+d9+70R/D0bwxZvLXFz0F6wufLIlWSH
JXVHt6+e6+YQrcDulnE+2aHb2+TMwmNuDna/K1o9Tyc7LGCdeCvvuZuDYu7r
A1pHkx3KJ1kpnf7m5pAxw5Rn1x4E//QUx+pz2xB8D+WyGyabkh2W1mvILHrn
5qCj4ffs0bpkh7Sg0lDDu24OArpqXyasTnY4pBPoef8MInx95RpZDbci+LD4
AAAjX8i0
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EY/Sy1NFDIysx02MVC++GYqRnbztz37d00K2deKLWU19bNRFM0
s1H9KE2aouFlGSv9IaZoaObK7GoKMcVl2bqCWwleuoqmw6jvl0I/zo8Dz3l4
znmOX1qmOn0pwzAOPAJ4LOGxqr0gVZJC0XZjVG/8QdA6VxdTdojig4c4NmmE
YMZ+cUCdQDFfTotqnhGUpKw9nbWXYkJt6PrbSBBn7qvuj6KIaLdlFJQTvDw4
Py0iFJrmus/jZwiOxk9lC+QUxUNpsQdSCURTy1OVUoocL2dOBwLliEiqD6MY
1b4bX+lIMCf9+t51O4W1KV+7vlWxwK8JTS4XZItcd2znus2fOFivziQJeP2v
UNs2eQkHU2H6bUZCYQ9ojWpXcvD2bfYok1Eoq3oK+jZwCJWHv2rh+H1nsybc
HDncv+OUp4zk9R87rhdPshD7m72suylUEvsex9cschWXTOp4ipD4WlWokV3I
55vrPmFFFQt7pFF2L5nCU3trLKSIRWmLavINP99VPzBdVM3CcmLOJTiGojwo
X/ylgcUDcly1OpqidlPD46i7LGIlab2MisLS+CS6uIfFoKlyo4al0OZpK9ws
LHYJ09sYPq8tnuEjFd9ZPM88UssEU6wJkkq7N3KAzJzYH0hh7kyscE/kUK+R
V7b4U+y3TDYlXOHgrOsYKvWjsM2e6zE85RB282Q2I6AYLvGh838W+eFZ0psn
USzwaN/zTsIOBX4aLk+Lt1L8fmjobPYhePGoxl0Tzvdhhz55OHfxn6eyBzNj
dARjrlM5Av7+UcuyAlMdWfCXkIFC0k7QnWX2tPL+K/VTEcYeArdBm/eKOApX
h8Bo0VuC//v4D+EYKJM=
        "]], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4o8+intnlac4aDYENRXsdneA8Rl4/5w8c8rd
4aG4etj6thQHLkZtX+Ob7g6vHr7n8pyS4vCg98qU/hfuDp/C3yh5Lkhx2C5V
d+f1d3cHNY3CpOCFKQ7+VSWx178i+N83VuWVTXKF8+surlY6Uebq0DtPRHj2
ohSHYu666Ykprg4aT22Y3y5JcVjwI3uiRYyrg4DAg60my1McTO6duvAhyNVh
7cvciuA1KQ7TWWz5Lvm6OhhJsO5p25LioJ9i3L/XG8H/fE+CqcHW1cEumskv
tgKTD1N/9/jXRx4NKQ6pc7dfOu7n6pCQrB6yvjXFYU7dFX/WUFcH/YC8rXYd
KQ7WWolSKnGuDuLVghltXSkOK1yYbmenuzrUfdwica47xWELl0HapUoEX+f1
v40NUxH8OU/VNL7WucP5Ql++ZS+e5u5g+PhyOzeQv01SuuLrMneHaccE09o6
UxyUTPZY2G5wh9v/xe2cXdoOdwf33ykmWkD3TVSIYWzd6+5w72P0RtFGBH/C
TpGgtnoE/+CZsx++1QDDX+KsW9oed4ci7fbe9ErM+IbxAS0a5lA=
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
        0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4uq2n3tzWFMdNi14NmvHB3eHPynxfZbsqQ7e
DHell7xD8Lum31yr1+kK54vEL569ucDVYVqj4oZ9HKkOi09lzbRIcHWov6Zl
eJk71eHi9ojJ/BGuDunaJpue86U6nLE9GHgnwNVhvmLLtG7RVIdT2Yc87/i4
OizVa1zVLZ/qoJ9i3L/XG8H/fE+CqcHW1aFiX9J2lZspGHyY+hRL87uXHqbA
zWO01c7b9zwFbl/AvcKLvq9THCwjkoRUolwdcpgZJuW8T3Hgzi6R8E1ydbA6
9kBF/2OKw7PCrQvvVCD402LZLafORvAPt9XdmJHtDuffcLj9LLXH3SHn5szD
89+lOKw/26J3aLa7w/n/3IyNLxH8Wcfa95Y9Q/BTkueunv8oxWGN6psvfTPc
HfSu+Zz+fTfFoVQqc2XLRHeH3/p6UfuA/FtCt96lTnB3eHg828oSyOetitcq
6Hd3mLyza2XZnRSH4qIL+YF97g6VgSc6P95OcVh6M3R1dK+7w885J9o/3kK4
70dR0k4VIL9gwcX0wC53ePhdm+G01qjT3cHl3d1yqRspDtbpviru7e4O3+7/
eRZ+PcVhYfy+TI02BF/AJ86oYLK7A3p6AQC3chCv
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
        0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
        1, 0}}}, {{{172.337401297125, 44.76803876874999}, {172.337401297125, 
        46.52059221999999}, {172.866167424, 46.52059221999999}, {
        172.866167424, 44.76803876874999}, {174.617470837125, 
        44.76803876874999}, {174.617470837125, 44.23177241312499}, {
        172.866167424, 44.23177241312499}, {172.866167424, 
        42.48046899999999}, {172.337401297125, 42.48046899999999}, {
        172.337401297125, 44.23177241312499}, {170.586097884, 
        44.23177241312499}, {170.586097884, 44.76803876874999}, {
        172.337401297125, 44.76803876874999}}}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
        1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYC4pe8G/bM/Z7qoNkQ1FSw290Bxmfg/XPyzCl3
h5s3toZuYktz4GLU9jW+6e7waFEdl49ImsOD3itT+l+4O7ySqFbyUUhz2C5V
d+f1d3cHuZf/E8MU0xz8q0pir39F8L9vrMorm+QK59ddXK10oszVoTV+sdA8
pTSHYu666Ykprg4Ky04zfVBJc1jwI3uiRYyrA8fFvK3m6mkOJvdOXfgQ5Oqw
dNWf8jCdNIfpLLZ8l3xdHbRuTt7daZLmoJ9i3L/XG8H/fE+CqcHW1cFMZqJv
wo9UDD5M/dWOlkfeDGkOqXO3Xzru5+oQobIteBNrmsOcuiv+rKGuDuqCf7c4
cqQ5WGslSqnEuTrw2yxI7+RKc1jhwnQ7O93VoWyTs8RF7jSHLVwGaZcqEXyd
1/82NkxF8Oc8VdP4WucO5wt9+Za9eJq7g+aSpHY+IH+bpHTF12XuDn3tC1I7
OdMclEz2WNhucIfb/8XtnF3aDncH+z2fjXWB7puoEMPYutfd4dqmVxskGBH8
jqrFgZ3/U+H8nb0xH37+SXX4LnHWLW2Pu0PWG9HerJ+Y8Q3jAwBO5OSX
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0l1Ik1EYB/BpFukgphZaClFJM3OSCjrKj6e59z2K03AXeWHMXL0nYeUU
P5aYKSzT/MJSyvmxpXOiaMyPWQausEZpOFA0zM9pgUiQLRV0Wta56oW6+F/8
bs55znP+J+RKKbOPw+E4kQhInEnkvV2N+00YEhQP4k0jFGw0GFx+GDBsLHo7
F0dSwMQVLF8V/e+dAGN8fywF46UD9XYlBuq2OVDMpWHRzWixl2DwkQXrrqXT
wIx1zdprMKxltbuqh1kne3p+qzqM/nrGXVWujEYQN6Fe1VZhuHxzwStJjsBj
LtRl9z4GJ1OwzrUQAX9U9llSjMFWmXVO8wTBhcTyIa0KQ2K+u2OpDYHPzIey
o7dYxzZJTaeus96KhJ6dKxiM1ntBbxoRnH5Ve0ebjOEgZ2Q1ogyB/qScK5Ri
kIdw9S9yEEy2DkzPSTD00S+5v5MQhI3yj5gRBllqZ9jwcQSa7xqpluxjVxju
sPkhaOxmNsJpDBWGtJQUBoEi0INfF4+BJ5GFZNYiMJf7nTWT881M77B/H4KF
j4U1uWSe6PPGmsh5BHfP6Ovep5P7nq40DNoRZGx2COZVrB/+tIYGlbDeK8rY
ziX7y8kOnUI2BBNDK2MKDYYtbyuNhxBM6wo9dK0YkKDA+ExD3qsIEO+2Y9h+
7eyrz2Dd9mmdZiJYG4r8fVvXaJi8JNEJmzAoqYs5LQ00WMak2ULyH3gbvVNF
0ZCbOmsTpGBYD/8SGFNB+vCoeE9bz7p0anxJpGXd5pC1pJF5+Fk3MhOqKTBU
WrKDSN8c6vy8vMcUVC9bN0UdGPZ+8QY7myl4Kx48cKwbg5slKobXQwH9XN3Z
34Phq9jr0KSVgn/7+we15U3a
        "]], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
        182.64971581312497`, 44.52803144874999}, {184.61852585999998`, 
        44.52803144874999}, {184.61852585999998`, 44.03176631312499}, {
        182.64971581312497`, 44.03176631312499}, {182.64971581312497`, 
        44.52803144874999}}}], 
       FilledCurve[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
         0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
         3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
         2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
         3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQzadnJvC/Ld2hSGLxg+nv3RymN834cXpKukNodtXm
KEF3h7T8+5HR0zH5+lxsDCxrXeD8d1whhpOnuzjMsk+ZmToj3eGpmOo6nU4X
B78jL27lz0p3EGYRXsHc6OJwfpHfaps56Q58XdVpFypdHOTzft+ZsSDdgVPg
icrcIheHgjO8Dw8uT3eYP/f23I4cBN9go/VVh3gXh+TlHsHC2Zj8K9fiH07K
d3HI7Lo/w60EYZ6VyadZ+VXpDg4fGRbdqnBxUOr8Ld1Sm+5QtURGXaLZxUFF
JvFdQEO6w5ZwizWhvS4ORSErfB80pjv0bXvwe+MCBP+yvhZP2F4EP/DJXo2P
da4OF7ReikeXAcMjxbh/r7erw4kEheSDGekOb/a8aJM0dnW4MVXq1JpIBF+W
ZWbJIl8E/+8Oe/5XzukOupNM2ve6uzpM/JT12tom3UEkfvHszQWuDpGXtlic
Nkl3+K0ttGHlTFcHlfxTal8M0h1euYjzXT6L4IvsvKCVy+8G55db8E4WjHBz
WM71Z3qUGTA8WfTKKqa5OXhwhf4Xckx3+Pza1nvbCTeHpufXgmR9gPpzTjx5
+dvN4ePlMulUoHvDhYXf9oq4O5zoajPsy0Twz+XKlh8sQvDf7Si7U1mT7rBt
/9sX1hzuDujpCQDRVgeP
         "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQXRSywvdBY7qD8I7cY2X7XB1g/DlG+nkVk9zg/KQb
d4X/XXVzUDijX/2qMt3BRXvrswPf3RxEZ6YfCshC8PuuZ60JiEfwlZ7r77oa
lu5wOUdMrPKZm4Pc9H9u+QHpDmFCGzqmH3ZzkHI/e5nDK93h5nbP31sXuDk8
5fWc8M8t3WHX/fDZWwsQfB1XHUcrEwTf61NIXrmQm4NPyxsHN490BxOLH/Gr
Pro6mKzv/9wLNK9dbumFj5dcHc5/3f74vk+6w/K5Z1j1t7o6vP5w/6oh0P4Z
rAuKTsxzdbDe08PeF5Lu0C9Y+D5xgqvDjalSp9ZEpjv4Ce1X+Fjl6sDfk7Uu
ICHdQSR+8ezNBa4OU3YxfmrOQPClXs4w3V6A4Ge7r7Z8UJ7uIL3a8umzaleH
xba/ZVvq0h1iVr3eHD7R1cGuRZnvWkO6Q6JK89euGYjwttioY/t8OYIPiw8A
7XzAcA==
         "]}], 
       FilledCurve[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
        1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
        3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx3HcrqgMKyqmwqrJYuZizt7H7+67NVyRbk0YTV+mUGH4gxo2
bmsmecjKw5SnkIdDIl3kXES6daeHU5iYbhpTKvzR7y+39cf7j9f2/myfz/v9
ORSTFBLLMTIyMmZ1nJUJK9fwWbuqZop9WU1LXvkMimx6jwU1UfzYec69uIzB
aWtNs6yTwtjelnuii0HXkwCTK88orCKm1coJBnrfu3N7XlD0bZU7Bi4wSGyN
ymscoijlfGr8vMVgqieONzBCsXu+4VeBrQi7DoTuLxmjcKo0M5V6i/Db9ahv
gJqi/ZR7pDpVBDKRWKXWUHSZF4+qRg0cndWWy/DF25wkEqbUVIgRmRHrMMDO
m6ffi85ZFiOlaH1U94bCJG/c3/okgZ+bRa/ZawqJI5mwlxJonDheq68otrwr
IrSpBCGd/GKpguLRx7DH4bcJDrosdnT2UdyaKfXU1xKMjbxvlckplBdmmEIF
2c5HZy0IvThLkBE/2BTdQtFRvVDxdIWgPcqq0Iz1Cy1aywUzBHE1MdcaeykS
sk3Pzk4S5CpX3FXPKdw2loZqBwmW3/6V615SOHP7IJATJAuHpWlKisB6q9WZ
aoI13bpKx+alLfdv8SggyKxc+6LTUixmCyQ7wgiMxmWHLb9SuP45stntSPCg
zvab2zxFsvjhhzK9GD436+qDlli/s6VC0i0G7+oyb1pP8fPODce1TAOX9Xiq
gn0M3Fa0mV8yJIIk8V1e1RwFd1WntQsXIS14MCFtkmJ8ft3FjmPoUyZodkj9
zuA8J547wO6/dyrFZkPDbN93vf0Mr2GYQc592aXNfgrP3AdCvpyBh196lLqL
QmF/md9fxeD/f/wHwzQ7RQ==
        "]]}, 
      Thickness[0.008547008547008548]]}, ImageSize -> {234., 234.}, 
    PlotRange -> {{0., 234.}, {0., 234.}}, AspectRatio -> Automatic]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.825905024147108*^9, 3.825905072463655*^9}, 
   3.825905363382402*^9, 3.825905528383874*^9, 3.82590787412798*^9, 
   3.8259080324949503`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Dia", "[", 
    RowBox[{"\<\"A\"\>", ",", "\<\"A\"\>", ",", "2", ",", "8"}], "]"}], 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   GraphicsBox[
    {Thickness[0.004273504273504274], 
     {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 234.}, {
       233.859, 234.}, {233.859, 0.042999999999977945`}, {0., 
       0.042999999999977945`}}}]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{45.02,
        65.789}, {45.02, 54.456999999999994`}, {35.836, 45.273}, {24.508, 
       45.273}, {13.176, 45.273}, {3.9919999999999995`, 
       54.456999999999994`}, {3.9919999999999995`, 65.789}, {
       3.9919999999999995`, 77.117}, {13.176, 86.301}, {24.508, 86.301}, {
       35.836, 86.301}, {45.02, 77.117}, {45.02, 65.789}}},
       CurveClosed->{0}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       18.552508993125002`, 65.66912544875001}, {21.99788154, 
       65.66912544875001}, {21.99788154, 64.800672813125}, {
       18.552508993125002`, 64.800672813125}, {18.552508993125002`, 
       65.66912544875001}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sDni98fCrF2YP+8qdH/UaCD+or59t9yrR0+
LZecUvsAwS+b72df2O8P5xcuUWKZleLv0FDBxGbXbO1Q4PvlxiF3f4cbZ6e8
j1ln7SDpP0Gq2tLfwUBZ/Wb1TWuHdXmTih7q+DtMcH3CWmRm47B6zuSsh6r+
DkfWnlladMjGIVfl+NLXygj+y72GLAzc/g4fjxYtu/LCAoMPU///yXf/qCRL
uHnXggO+WW+1hNt3T6HaUvi5pYPz00Nf5Wz9He6fu95/UMHKYdZjtS1p3v4O
grfZmlMtrRxOLGo79LAIwfc38py+ZD2Cv083QfpKbiCcPzU8Or+9K9CBb9NN
/z5RK4dvbj1KP6YHOnAk1L+8f9YSzg/ZvzMmYDGCf4HxW39vrqXDof09QdpT
Ax2q1E2ap+tYOmz9cyCUqT/QYdHr9DBrTUuHaQeiitn7Ah189zMt+Kxo6bBg
o3qGQW+gg0L4xT3+4pYOjaUHW017Ah3OaOWwcQhYOnSn9VXFdQc6HG/L+8bO
ZAl337fMgm1Xvlk4NPAcatzaEQgPv8QL0fN3tQc6uOeusHS9ZeFQuulrB09b
oIMUa3nYwvMWDmFl/csEWxH8RVLqORsmBDqgpxcAEIkBBA==
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       116.789, 77.15199999999999}, {116.789, 67.79700000000001}, {109.203, 
       60.211}, {99.848, 60.211}, {90.488, 60.211}, {82.906, 
       67.79700000000001}, {82.906, 77.15199999999999}, {82.906, 86.508}, {
       90.488, 94.09400000000001}, {99.848, 94.09400000000001}, {109.203, 
       94.09400000000001}, {116.789, 86.508}, {116.789, 77.15199999999999}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYC4sscerbvf0U4iIjMqj+/M8SB46eOoA1jpMP/
EwyT/m5H8E8U9M21mB8E57sW//h/pjPIQX7tUaY+tkiHo+6JWYnVQQ6lTlp7
QwUjHWZ66HfblgQ5nL7eVy4rE+mQHGGw/UNukEOywj6maONIh6T3BpsLsoIc
Cqx2aEWHRTo4bz51oTQTwQe5kSE2yKH6wMNVn+MjMPgw9XYczqKhdRFw874o
36zjnRwBt8/s+mL/5vkRDusmn6jgLwty2MZk/fTd2giHW5N+hRvXBjkcPsr2
SHxLhENBkdb9DxMQfJNd3Z5B6xH8U37ukiGuIXD+ogqnXPakEIemamtRpdUR
DswZxQoV+SEOjM+XVJvNRPCv1BXPmNSH4Bf3Oz1VbIxwOPegOGB1TojDXQmh
pCcFEQ6HZFcEN6WFODznvB/GC+QvfuhY2J4a4nBpn2umdV6Ew9pLfGkbUkIc
jqdUFkzKjnDom7aieWtyiMMmyQdNBzIjHGa0l1bcA7pnw4YHdQ5pCPfVaD5c
V5wc4dCju7LeNCEEHn65H53mWsWHOARqrT/vHxPh0Hj5TltPbIiD64VH15ZF
AsNzetmSiTEI/jprviyDjBAH9PQCAP/D9kU=
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{45.094, 68.895}, {53.609, 
       70.17999999999999}, {63.605000000000004`, 71.68799999999999}, {
       72.71100000000001, 73.059}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.004273504273504274], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{72.43400000000001, 
       76.559}, {82.84400000000001, 74.59}, {73.477, 69.637}}}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQPV0zqtxYOcCB7fE0V+O8IAcYnwEEUoMc3vwo1HFz
9Mfgw9Sfurhx79Vof4dc/Svq64D8gvl5zNH5/g4L/0ek78gPclgV1NUxo9Lf
If/N/BPuRUEOT1iX8V5r9newvflM83pJkEPDfeMLXzr8HUrSzLmqKxH8ezfs
J/bXI/ie80W22rYHOdSkzuk72OjvsF1pa2XrpCAH3so/RytL/B2ijZfJFS4K
cogQFn7b6+XvsO7YyzDRy0EO965vXqtv7wfn986wEVIV8HN4u541SnN6kEPo
dvmpzzn9HJpeGphV9wc5KNTNDrzL5ufg9flB4PUOBP/BVG4jzWYEf4mqCk9Q
aZDDSdnw+UlyfvDw8D0SXFbug8mHhZ9BinH/3kZfDD5MfQl33fTEWb7w8PTN
Unu+d62vw+I9KhxBxUEOnUdvLdXb7evgFFyXzVUT5PBjY1Ve2QlfBw8z0Y22
rUEOCwPN9vy+7+vw8eqFf4fmBDls45586gSDn8O1p8VF8oeCHHjkz5sduOrn
sEbgEc+kvcEOfnKNrIavEXw1tt0Otq/8HcJ28t21nR3kkGKcx77ut7+DuHKM
0Flg+G+f7OfKxRrgUHrejK+6OsghJPcOuyZXgMPSyg8rXpcFOXx0yzrlzh/g
wLEg6dmZwiCHw5E1FwrEA+D+QU9vAPC9BuE=
        "], {{60.62239646, 
        75.62568744875}, {62.4774530375, 75.62568744875}, {61.54992474875, 
        77.834504815625}, {60.62239646, 75.62568744875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmlI03Ecxp0LwVLIBhWS1ywbWlgjkdTsIawZGf36/TxCK6WcpZV3YpgX
LTMyPELF3BTzmFlLNN0LlzablkdNRxNyGl7Tkg4tomJJ9H+l0IvnxYcvfK/n
cTuXRKV8KysrHidPTtacMlt8/2hGCKan40LkPQxPfAsnoo0E6Y5loq9qhgA/
MmbuJVhn2qGza2aI46V5CjsIVvbrJg9WM1gWDPGmFgJRwrxPdjHDD77/dmUd
QddCUIqPjEH4TeScU0VwzNLQ/CWDQe0ZahkpJYAiw+1WHMOMTYs6TUZgGYlJ
PxrMcKhv23JoNkHmgneg3mmNQx+O83kf6CrrDzsU0U4KQaL39+wbBHm7pOUz
dyg+HrCvQjG3r8dwQ1UCRUHe/ejoCgKvybBn9REUPUPqaXkN1+/E43RJMEWf
6rjHqJIgN1f/RhZAMVRivsRvI3jUuuzxYg+Fn4EYzM8JHmh666OEdPU/f8sV
lbabKIJM7Zo2PUHZyEBa1HqKxLqxjUtagthZ0zUZV+c5+4QoOwlGm1sVYkeK
gbdbh+NVBEahZErqRvFTa9OPRoJUqbFRJqJYfp+Uay8nOPK6PVgiplhsslOA
+5ejvGTJNpBiwl2QgiyCUtG9GudTFKMvzYvjCQRJn2sHJKkUFYLBWHkMwdOV
ReOnIorTMaqps+EEv+32zRQrKbQFLk44yc0Lt94b2L/GXUVbZrPm11jl0pH/
zpVBLItw15wnsE7WRW4OY5jTXY2wLyS4qdLu9spf81M7OKG+eJfBPVIkzKnm
/Lz+y7+pkq3eJ34l6J6rZRjcOX+B30pgOHPFVc7l6bLZNjmsm2CDw+3G8XaG
//P4D4yBM+I=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQbTv1wYkpGwMdDsi4vue2C3bwt1s6U+9soIPhsQ0R
b/2CHd6IG8f4XsLkz5v67d9BmSA4/9/UudM5hYIcgnfY3E68EujwU5ot7BpX
kMOeg65xZTcCHSYI/b10kC3IYX+d4H/+O4EOvaGGRhrMQQ5xotlJJ54EOnTP
SJ3Y9z/QgfFSf5bU50CHsPiHvi1/EHy5zImZD74GOjxrZ/XfW4nJ/1i9OJ/z
H5D2Nb6l3IMwb/LCiHulMwId1Dm/+K9lCnJI8c5+MG9eoMORR41CZ9iDHNIL
zVotlgQ6JO7hv/qKJ8iB+dER5/DlgQ5nXz/+M0MMwS9YwcH6WgXBX98UNHlH
a5DDwT63Gz4TgOHh1HtMLifIYf2vLXmSpYEOf9+lHzoTH+RwPmWlzYcwBD/S
cdnE23YIvuTqz8eytAMd5t7sPSSXFeTgLOdVzycT6CDocPTMzLogh0t370rq
8gY6tCz7c01kMtC94pzf6lgDHf4Y/W/VXIvgC76NnvLtLIJ/SKfqhMenIIc8
v5wb3gKBDtcmcVnVCAY7rPeVW75HNdChoW2SymytYAcVDiW/i9bA+DkW/tHE
JdiB6WHi/QSge42kar+2BQQ7bPBr5N5chuDvEVk/TbITwf+zKjGxaw4w/Aqy
Psd6BTugpycAs2kPrg==
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQzfzoiHP48kCHCTlaSdVLgxxg/Kua3GY1/MFw/vaa
Rxz2hsEO8Rcvz8ueHuigqeZXpOAU7OCd7axrUYHg277wZLRIQvBT2a/IOAUG
Onw49q+zxjLYITa90KzUJdBh40zvw9wawQ4hx/kCVpgHOhTnzPgzSyzY4VUI
28nJhoEOyQ3zz8z6FwTny27ulI99gOCv5pTbVn0+yGGno6+Wskmgw8I17/VE
9wc5dEyf3L/JItDhlLzb8x3rgxz2qTzJD7MNdIi6f7Px+oIgh29SJiG/nAMd
gic7WyyZGuQwdWPv9k0+gQ5+kmu+FfQFOZxPWWnzISzQYa1kcP+O5iAHu0BP
VouUQAdBh6NnZtYFOXiuK++ZV4LgB3MvE2ZtRfC/HT8lHT450EEkbUKhcUuQ
Q+qWrCfzFgQ6bE19eeM10PzZjruPOC0FhqfS1srWSYjwVnrZOdd4FoIPiw8A
+9uwPA==
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtI03EUnRPyNRXmKxa+IPC5UMRg6txJsrIEt/vDSg1l05wUZWpZqVFL
LTS1mmmT1GmWCvkiH2GUWJlJmQY+KLBaaZaZSRSmaav/lxT6cLicey+Xc8+9
7qpU2m/K4/FMOHhz4HM4Mb95YnRFAe3wQEacJSFMNb3st6iAsazqqoWQ0JHg
wm/i8mb6P5pxN0Khbrnp8HqCrUyVUicmLNyuPNTlTpiygW2yhLBSFtA+401Q
aA0jzVsJQ43h3cIAQgl/YCmPCJJU0eveIIIuYeHMrIqbU9rn5ryD8NZXsMlL
Q2geU3wMjiIoHaVJN26t8TvDu7a8f7fGQwPsuy/ZMUz4yD4IIwhFkb2tJlIG
833KULmUYM5iayLiGarKikTXAwktbk7TQ2kMT89m2Z/kdOc394p9NAyP9ZND
4RsJMaeqR+eKGPbmh9kYRYQnPFlFoI6hc8B5XZOAcOB+Yu35erbqz1GR1vNr
F4NQsPQ7xqiAwZAcWdnDoFnU9ddaERrKdz6L5+rz2ZILM46EkBfHGtpaGDz7
owUeroTq4k+Gyw0Mv16qhXIPQoWdQh9fw8C7Z9yT60fwnco53lbOYPZdGSQP
JnybuBL9qpDBITMuWa4gZMm19X1HGFxHCua6lITKovyca7sZYs7dTP9xkNDT
Hj5rFcJQKnnw0z+T669bfqN2Z/Czi7orzybwYsUXu03XOH2xTlRP0ipPiEl7
ZNnIzXFw6hhLIVhaqD4PZhCsxxdP53J3neOnage3r90zsjWiJIvT+Vy2rVPo
TxCuiC2kXPy3H2Y2mNp7ETzSC1KLnQk19FAfx/1TXmeSOtiWoNbXi1w4n/7/
x7+gvyBX
       "]]}, 
     {RGBColor[0.7529410000000001, 0.7529410000000001, 0.7529410000000001], 
      Opacity[1.], CapForm["Butt"], JoinForm[{"Miter", 10.}], FaceForm[
      RGBColor[0., 0., 0.]], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       187.27299999999997`, 209.49200000000002`}, {187.27299999999997`, 
       198.164}, {178.09, 188.98000000000002`}, {166.762, 
       188.98000000000002`}, {155.434, 188.98000000000002`}, {146.25, 
       198.164}, {146.25, 209.49200000000002`}, {146.25, 220.824}, {155.434, 
       230.008}, {166.762, 230.008}, {178.09, 230.008}, {187.27299999999997`, 
       220.824}, {187.27299999999997`, 209.49200000000002`}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
       160.806415993125, 209.37615644875}, {164.25178854, 209.37615644875}, {
       164.25178854, 208.507703813125}, {160.806415993125, 
       208.507703813125}, {160.806415993125, 209.37615644875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0m8s1HEcB/BDs5IbKXOc+bMTIlr+1da1vZmOVq0oRsdJfl/z+45p2tkU
1oy7lChZw27T2jy4ElEtbHeh0Bn5s5ZFO39uSS42rnIN6Tab31YP3g9e23uf
J++P9+XceGLD4/GsLAmyxNqSnEUnh9ZSgpwf15skv1gcmzEI+dkEmiMK3qUO
Finj9VdHNcx/TmLKsiVaFoL3ppYKPkFXo6OC7KXwi1uctA8jkK2J94vEFM1O
C8unYwgKVWyPVwbnSoMuU67kbKu8v/toPcVNeFQVRVr63alN19QUYpVCpw8n
SF2vTA18SSFNTxAEBxCoH/qKBrooCjQ+GRtuBMN5K2V1fRTzdtKkmp2cV2NX
D8+ZmW17b1bLZd8ZaI2vHVU9FCQoWLQxy8DsX6nb00mxr/fQl/JPDEIyU0qU
rRTJpoFq/xEGcT2BQ4mPKATqzd6QfgYBjroxaQXFuCzst1jLoHN27URdJQX/
bOhQ+VsGJUtv/IcfU7zzqvU0DjGoSbgTbtZSNND1ybwJBj+jtfNZgxQPkvuK
5UYGilWlaVRPEVVaZdphRdAXeb6r/yvd6gk5e/so09pDOLfbvJqTSwhu+yzl
+k5TqHvd+D6JBM4LomHDCIWzg6DjeCZBqMTk+ryb4tzBol1TOQR+9nfL9c2c
eReDqgy1nJ0K607q8ymiV1wL7KQEZU8bPD3iKSJyvc7csuybPmVvO3iAbu32
jcETZzcJmWThYC1s1Fwg255YbstSyTjXK4tDxwjBs6gbPR2fWUS8KGpopwSS
KNe2U9MsZv60FLpfsdzvFLjnGVjcy4/9+CGfwCXNZaXYyCJGGNM0U0yw0dfs
WWpm8e///gUWnE1V
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       172.621, 134.105}, {172.621, 124.74600000000001`}, {165.035, 
       117.164}, {155.68, 117.164}, {146.324, 117.164}, {138.738, 
       124.74600000000001`}, {138.738, 134.105}, {138.738, 143.461}, {146.324,
        151.047}, {155.68, 151.047}, {165.035, 151.047}, {172.621, 143.461}, {
       172.621, 134.105}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3,
        3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxl0ltI03EUB/B5wUv6MDKbW6tlai3UmqmYIOM0vGVKuVRI5vz/PEuQvDFB
jGVa4sbw2lXS4T0HbklqYeVda7XSvKA9VGRkC6dkpOUwQ/o/9Yd6+D584HA4
nHO8M/Kk5x1YLJYdnUA69nRst3QJ7JcIuT9URpOWgmfanNTsboShMDXrYzwF
X0p8e0QO//ucojzblEhBa2Hx6ooUYfQuW23poKB7s5CXfREhfSvCr22KguP9
BSJjJUKxLmuseYNxzaI58yeP/LWz5obbo0ACO636yfdqun40zfgrgoApku0i
ViHIf1enGWIJWFwXUqryEDqbD/rEJRFwyOxqkVEI08q1cm4qAWXv59vrCYyv
fC/NjxIzNuj5DwaDEIZXhtn8FALf5vuITIiwKaw2X0sg0Jjz2Me6DyE4U3bV
OYrAYkPSjMYTQTrmP/kmlEBrotbxujuCP9s8+05AgDgPhenoffR/2oriHiBQ
Zxtws7oilK2OC0+LCUjN3vI4D4SbyVWhRVIChz3UvFkBwkbk0NJSOoH99mcG
50QIGptmPVFJYCKAe0wRjfD8xNmRGBWBkq8xh15QjA0T7EZOEWOJEfzmKxAq
fVfzOgoIBOe2nyprQNi97DOFCgJNfS02nQEhJHqdG5xM4O2cU6y4F0HoXquV
SxjbpQbWYABjj0t3Tsp3EHhd39aX1YygvtckaLRQMMLprLDS981YcHeKH6Sg
9ujeuLojCEZPXrQll4I7ne2L/HrGivoI/VYbY1+RizKInqdbUjoWnk/3kzl/
4NxHiJFwe14VUHBBH96vekj3f+LFXyukYI9gdlfIAIJXOmdt+zIFM+PTy/AU
YdvUJXCspODf//0DbYc/CA==
       "]]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.008547008547008548], Opacity[1.], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{111.96100000000001`, 89.512}, {119.133,
        96.824}, {128.375, 106.254}, {136.516, 114.55499999999999`}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.890196, 0.10196100000000001`, 0.109804], Opacity[
      1.], Thickness[0.008547008547008548], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.890196, 0.10196100000000001`, 0.109804], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{134.09, 117.082}, {143.59, 
       121.77}, {139.086, 112.17999999999999`}}}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQPV3rWdTk9miH07Y6b7sZox1WXl6lrbs42sHm+fSw
XKFoB7e1Fu+8V2DyV267+8fxQSScz7G9ZWrn1UiHtb5OuQmroh1YbN8Gh52L
dBAL9/5Qsi7aYbbxkwuOpyIdJEXEJ/JtinaYUSZhsOJYpMOOVQVfju2Kdpi2
06ef73CkQ3T61D8SJ6MdEhtOeLMcQPA1uyrSE3ZGOjjIcj/c7Y/J/zOnK7fz
YKSD92OLHKUkhHlvzeIKSvKiHYy0bvvqAu3b96CgaG5JtMN55kwBn9ORDgfZ
bMTNq6Idcu5+u5R1IdIhtvzU1dDaaIcbPKd/SdxC8KtPvmfKfoHg71psOdHC
M8pBWsUnyzsNGB7JJUfm6Uc5cE7YxSDhDQwPAf8DPspRDpq/1p17p4Pgb762
WvmWCIJf7PAzIhMY7it+lRyYpxvlMHezvyDvpygHmcQ1pySdohx0ih+v1n4c
5dB//PGVKWFRDgfX8HXU3o5yYAt51ryyAMGX4XOeVDYRwT/rm3jsxNYohxOP
C7O8nkU5PNz80fzPFaD7Hitb7v4d5dC9vFJJ+l2UQ91c9QfnBYHx89zu/Rb2
aIeYsvTCeKB7ba1TPrMB3cn1pG3uRh8EX2zVFg2JeAQ/zCH9c0cRMPwmBn68
yxvtgJ6eAEEhC3M=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQHVt+6mpobbTD7F7BhN8ZUQ4w/gOvT8Z/LiH4h+ae
ZNv/JcphZ9pNg6zcaAcTd9OCBazRDksZPPeb+SH402v9J5tZIPj759xc56Ae
7fD7+dP2P3+iHLb/KTtRLBXtsGeX0cHu11EO62JEHi3jjXao663/JXUrysHl
FXf0JPZoh7yFbaekDiH4GlcKZO8uRvC3abFu+T0pykH4etAeRa5ohzVnr+lM
bYpyeKQzU3EjX7TDVQfdpxbFUQ4Su14yhgpHO6QyHKwPT4lyCNhg+eyHZLRD
3BYtM5XIKIf3bpM9NypFO0RaTf7yITDKQfPXunPvdKIddlhZ9Vq4RznMeOY3
3cwq2kEmcc0pSacoh8XOtXJzvRD8tQtWL2WORvADYi+sDc2MdpBvL8/fDNS/
37OgbG5ZtMOBtgvXsoOiHL5eOxDmWA0MT+c55axhiPDV5SqcvTkWwYfFBwCx
yrbj
        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkn0s1HEcx+/c2VW61OYprhNxNnRTpoTae5G7npAov9/3Wy23Hpbk4Q8n
RNSSzhpZlyK72GQnFZGmIZpuqFbI46EWjdQmy9borN9fbuuP9x+v7bPPPu/3
++MSmxB5SsDj8ficPDlZcGKX7tWORVPM8MP2SXIICjQzhTksRVbgRdmFNALp
zWcakZLCenF1W34cgTK6/3NIAIWI6IdbjxMYA/w2mnwofDVvfU2RBP1Hy4Y7
PSg6RN4JDQoC4Z78Pp0zxRGn/Mr4AILizManc/YU+1uOOYs8CV6z4njtKgrh
L0VypxWBm8PlSrWA4orIPijsC7vMJ7pe8bP1Zh46/SevJ5XFfNutKt1KCs3B
A0Unw1l0FSaGq2y5exV15evlLM72mWxzJBTbTEFNm5xY6KSOd1rduH2JRckG
KxaV/Frj3GaKG7qGbiGPxaMJhatsO8XzDwNuu38zkLjX54pCKWqMVQ9GJpnl
fFY0Xr2d94mBTG6X3BdFcX/2SdLIOwYR8/6GdQqKBEG7WtjP4GtSsUVXIMVI
p7akbpSB3iMjO9+XYjxYPjo5wWDQ5ly6yovi0rWXFcIfDHq29Pr5uFIc+nk3
1DDPoHsh4bCKy8u9Wf0zj8+iWZ3ioeJTlO5NKy3j/NQ5KnV/ZwnSxLlvDH4s
Us94O7V+I2jZ8LEnLoLFrvq12mwjgUDuNG4dx6J8OKc3doAgQz0tb7lu5o6a
pfHFKjO/QElWzAQLm8GmodFpAnGhPkbrwM3ZD4l91lAUvH/oVR1i7rP7e3v9
VASB5WPNoM6FwrJsbIeMkGV/O6cWmlQqgup0pVTmR2HMjJJKzhOE+cfLUoMp
7LYmVjApBP//4z8fwie7
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
       0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJFIGYCYhGjFxnTO2Icln1ktqtIj3aA8YV23EhUy492
+HL886wDy2IcxIwKFkeWRTuwxbSyfDkY49D0w+U4e120g6hHncmXmzEOb/dJ
vt7aGu1Q+6J9M8edGIed76asXt2C4PdySZj8DoqC8wNnGfCpuEY5+Fw9JzLj
XoyD9/aZJz5YRzk0Jcl/tX4c4/Bo7QTXO+ZRDkE7UqNOP49xWKPgkGphHOXQ
nd14n+NTjMNd45/MKw2iHKadWJ+WzxTrsDK55Mg8fQSfW/H533qNKIf1fqu6
ZLpiMPgw9W/UJ275PDPGwaXB7JmyYZTD57gv0w4siXG4/+HIEieTKIcJFk2R
91fGOKx34+a6ZBHlkNB3Yl/euhiHp5ejX5XaRjnoVfMr/NsQ4/B62yf9lW4I
vrr6rdCGEAQ/QeXdBCvPaDh/lva1TYKh0Q5T4nz/VayPccixe7HDKjbaIU71
5K68NTEOi09bzLyXGA23n+eqo8zn1GiH/X354dsWxzjcOthR25QR7fC2Ojaw
dzaCH8h9flLeDAR/i6HjBf/JMQ68do4Kn4HxK/Z+M6dhD2Z8w/gAt3HwYg==

       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
       0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
       0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIVIGYCYo2lM7Ksl8Q6vGb085JpinbQTkrhvro81mG7
4UkuoUYEP7z2eHC4XxScL5O45pSkU5RDwuwXfvdXxTo8FpvgeccyysHA9XcA
x8ZYhyre9mPHTaMcGN/zBhtuj3WoCNitqmcU5VBwe6105ZFYh7LnuxX1DKIc
ar8ud668EeuwMrnkyDx9BJ9b8fnfeo0oByXR7NjV3ph8mPpfXCIr2WMR5pkK
/Tl1LwNh3+WQzol/82Md1t3lZrtkFuXAM3+pkHVFrIP4c5HOZ1ZRDitU0i0O
VMc6tGZt9dVzQ/BjE+JmdoUj+J+/SGb22EfD+X8DPT588o924Pa+WbqwLNYh
U0JWZGF4tMPF6Xs/JOcg+OmqWzP90xD833EPXBfGxTpkHAkoZw+Lduh3sW+N
DI11OGPXH9gUFO2g8YNx8b2QWIf/u9y/fAqMdviiXpt8JTjWYUYel1AFkB/F
vdvRPyjW4fSrQ1teBEQ7qFmbMbkGxjqkzGu9lAvkq1wy++fij3Cfcl1W4mrf
WIdTjYc3vPCLhoffn7/VwZFA/q6SxHvTPGMd9FMZ+5N9ox0UIubvEfSIdUh6
uNPwig+CP/M6p1hFMNB9aOkFAIFl75M=
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkmss1XEYx0nGmKKInTqNOVOjcjQma+brsrUjhAz//49nbmluCRHHhiwv
HGlmLmkuK0dnZ+bYibJmmcomW3LPCudFjHQZ/8VYROeVs/Xi8+KzPS++z/d5
nJKyI2+YGBkZGetx1XNIj+2RX3v5AYSW9e6cuVEOurLm05O+BPO++/WVMxzC
S6YloeGEY4PLpdFLHFz6tGNHiSBKkKU6CxxqJyJrYm4S1tzPWC3vcnjUuzqj
uE2I6xmeOG/OI314Z66nkNDk3L11+ASPmerx/cQyQnvZQkmGC49OrTxwoJrw
PfS3mzqIh2zDzGKhjpDpLUmSZBv87fpFv6QOg8uidl5az/IoDN40631IaMxS
dd0zYlDK7ROFcsLxO/6tI04MPr0BvoHFhFf+e4thXgypT6TeojxCzUeVW2cQ
Q+JAk7CcRkhprZjMCmfYaN+WtiUQJp1cGl8whoiVqbOhkYR8XXCbWTo76Kf0
cpHLLTmDxrXbcSeQ8MM4LPhUOYPY/tpqQATheZ/HiK6IoerxWpcijnBFiOuQ
5jIMLVm6v08hqDVjOpsMhoYtsZeQSVB6XmrRJTM0f+mVSwoI3qYp+VKeod3G
IV7Q97X7t/g6F8agrbOpFBoIFTlFyiBPhn7BzzpWRVB1ZcpPihg2lay+XksY
mT63WrXPwz32rmiqXz8/9HV+ZYnHBw/TBWGQYFlsW+0zbPB4q82ElWcGT5fH
vlFk8OA9Rz8VaAh2rrJvId481BuapxIFYds5uibE0nDPmHHpgz97HNJod7ZH
n18stjN7vcEd7HfVwsS47ieHdzV+tReSCZ156pa5RQ6O0yLFfBQhd7DaofUz
h///8R9UOjZ5
       "]]}, 
     {RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.], CapForm[
      "Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}}}, {{{158.195, 151.21099999999998`}, {
       159.406, 159.441}, {160.89100000000002`, 169.562}, {162.285, 179.047}}},
       CurveClosed->{0}]}, 
     {EdgeForm[{RGBColor[0.7921569999999999, 0.698039, 0.839216], Opacity[1.],
       Thickness[0.004273504273504274], CapForm["Butt"], 
      JoinForm[{"Miter", 10.}]}], FaceForm[{RGBColor[
      0.7921569999999999, 0.698039, 0.839216], Opacity[1.]}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{158.82800000000003`, 
       179.586}, {163.74599999999998`, 188.969}, {165.754, 178.566}}}]}, 
     {Thickness[0.004273504273504274], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
        0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAGIQ3eljvKdyT5KDw8rAxT9/pzjA+HvN2xgSvqc4/Ni6
qNuwGpMPU6+/5lP+1cYkh2L/AhHzPykOM+8nHtzWluTQu93IZA+Qn35mhZJb
Z5LDF91rT5j/pTiY7XzffLU7ySFmSeVU7/8pDnP1J5vI9iY5fH+1sHUuYyqc
r6OidnI5C4Kf1C5wu44j1UEmUDclAKhf8mTCXiW+VAeGMNaif+1JDlmBN/sl
xFIdJv85Vd1cm+QgIv17dZZeqsNW3c+vV1sh+A9iRV1f6iU5bOHvXFsikOow
SfXc00jdJIe6NfNmz+VJdXAVfxsyXQdo38ayld6cCP5app6ZJWwIfr/XDLZO
oPv1/0evqDBChMcFDel7f20x+bDwOykQnOLPjcmHqZ+1KzWtQhARngGX/Kv8
xZIc+KbNYOkEhp/8yz8rV0smOcQlupo9ZUp1sH6iMuevTJLDw0sCN+vYUx1U
z0x+f08pyWHronf1jsKpDqt+aRkLaSc5rNA6sPO9aqpDw39LvoCEJAdhh+9s
KxenOgTUP3Nck4rgu/3cEpC/NMkhYwrv+zqhVIdpRxKbTq9McvDw3NJ5DBj+
Mxp1lVPXJjmUz1/YPhdof3peScuX9UkOE0r+XQllSHUwjd79tHlTksPB9u3F
x/6mOMxLOZIxYxvCP+jpDQAvSx86
        "], {{145.96224046, 169.77803144875}, {
        147.8172970375, 169.77803144875}, {146.88976874875, 
        171.986848815625}, {145.96224046, 169.77803144875}}}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdkltIk3EYxqezgzqbacOmkrk8pOmooNQieUZRIC6hpRId1P/3/ROVUJBy
N+EKtNKwnIPU2JwkZnRAUURN0240T5nzQHmYVjLTbDozj7j6rhx08Vz8bl6e
9/e+viT9AuXzeDw7LsFc7LmsCiTWFjcGoVWNAdIKiiJFlFkoYrBypm9PvJ5i
5KI0zeDMoNVPTEzFFOkNrSKLA4O3g9PmbDVFxKH0Y3Ieg/455VPdQ4r6xmfq
2g0Cz5cHG9dzKeTVpcKyFYJvdZ8H41QUHvLqzY7fBFdzZYUHlBQhJ0dHxb8I
msrqmxxSKMZLNMq8GYK1YJ1Ph8LGyYLMu4nhNq4YKTj7wIei3axd080RbPaG
d39yoqgeFshViwStXT8NIess/mYpqoXLBAb/GmPNAgsv7dcM6To3L2GsiT/D
QrfrtfsHK8HtrBvJku8sfFXK+iQ+A/Ujq7tsnMUlvTTF4MSgQJRscBlmt/w0
28f2TPWyMFYkGMM5f7llqU0uXSwyd1rux3O+5qsyT0k+smhu11fWbmPgL7gW
s9bPQl/uZtLYMQjsDFpQD7EIK3ZkVJsEt1IzFJIvLOoCIttMqwST2okKvpHF
4XxBjIrz1ZVzfnWK6/eiUxih+kGwvacvZp7bx++p8k/0JMFS6PAU38ri3vvZ
o9JRAo/jG7OxzhSz01cyhMMEEZH7Lc/3UnhviISqAYJlskOcHWhjT2uhRRtm
46JzibLoWIqhtSPqljGCd/PToWnpFG/EslcmM0F2wfUnN3Ns99R6L13W5FP0
sqW7y7j+J5bv7Kt9TLf2i/NynejXUJR3K+uS7BlUmppdpSUUi0H5DXmODE63
RQ1E6yj+/8d/A4tAeg==
       "]], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
        3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
        0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
        3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQA2IQHdX0LWVVc7KD7DGNH0+TUx0eX4vwLZ+Y7HBt1r01
YTmpDpsOz1/HNgWT39PEyOB4OQXO38MUeubJ2RSHZ5NV3glMTXbY6dqp7X0q
xWGWxEp96enJDqwHWV45nEhxkP7Ox/BiRrJDy6N5kiXHUhyyD+02dJmb7MDM
Yum5/EiKwx6Fc6a5S5IdMp6XqSsdRvB93viZXtif4rD+N8eKfemY/K1fw3c8
Aarfem/+248FCPPaOja9lypPdgiwaVhhBrQv7+7uAv2qZAd5zeOcx4DuKShQ
dP5Tk+zwVpQvO/R0isO+FRmLuuuSHZbo/qjTuYDgf+3mag69juCLVOp77WFP
dZCpX5nDVpzswHPzTPL7XykOIlsfbM9JTXaw1t+VeOxLioPKq1tyEWEIfmZE
5ElfLwTfk5chZapDskO3ytnE9z9THO66aTs8t0h2OHr9xTMdllSHpWqlvWWG
yQ7/u1hysvhSHQoOd1XP1wXqv9h6uEQawXfV2+J1WxvBl/M7nMJil+rwOW7P
G1bjZAeNxm7Zeb6pDlPiREP22SY7/K06P0k3KtXhnPX05Sc8gPEjbVT5Ky3V
wVbDvEAA6N5rR1yqlXNTHUTuu7VZpiH4Uofuns7JR/CteM0NVSuTHd7lW//i
y0p1QE9PAJa2Ewg=
        "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvW9FxqLuumQH1rzZG+eKpzrA+MvPdEvP80HwJcu+
t9THpjrkKHw4P7Us2eGi11rLD6mpDolv1cX/pCH4t7S1Gf9EI/h51h/4GoOT
HUxnt7rOS0x1yHq9b7aUb7LDNBadR08jUh3SZvdqbHFLdviWe6lONyDVwTCJ
8+lK52SH99+vpum6IPjegt4T+EwR/Mk2U2/P1Ul1mHFjzdSPLskOvHz/pmep
pDo0MAd4WLonOyxy1yzZI5PqIO1VYdHtmeyQpV580Fs01cHcdYHWXZ9khzTG
FTKb+FMd2gV8YywDkx1SXO5US/CkOqi8uiUXEZbsMOWIvscetlSH6AdazH9i
kh2OXn/xTIcl1eEB3yE3/VQEP802sispF8HfPju7r7sk2eF4lt/On0D97yfu
LtKvTnaY/urXm1Cg+V03Hic11gLD82TCXiU+RPj66Xif/ymI4MPiAwD8ILaS

        "]}], 
      FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
       1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxdUmtIk2EYdXNhksMiyRBFpylYXujinCB5NCtSEavZiFqm7/fOC5GSl1LY
KsO1TEIbyyK7iZiXIqfidDpxmmuFa14SvCDdnJqQSZTJKOv75aAf58fhgec5
5zxHkJF7jDo7OTlxWOxkwWVx6cWT8wmNBMpHOXr+GwYzWcWK1XqCHm7q0KyF
wZ1MDUfYQhDrooxNHGfA4fEknjqCgxJdu3aaQWSVOLK7myA8Jmij+iMDPddv
StxHMHelaFE4zyDALVia/ZKAF5Uj919icDJ3ay7MBDcyOcbUFQYHri5ULr0l
CE2uqC7YQKH2D/8hHyX42l+3p9XLwe/5hghGIhz89NHN0oZkiiZLYH62lcD5
jGziLKHos3X4ql6zetPbhnkFFOWlQ3ztIIGHuSr/lZxCUDxQXmMkuHxLVl1Y
RvHQZXWeayDIKRpfPHGTIqvkqUtaJ4FfZ6DFXknh6a1xFmoJLmwTjQTcpev5
/Iq3ekgeUwwaSv+6NbH6G7qCwuoo/rSNfm5h89pybZfMnZ23//Q3iTsIpn1j
xaIaimEvrTJfT1ChsC83sPuiduhdVb1sHsawFHcNRY+m7JlggGCsMT5axN6P
2a3zUbF5CetTmpPKKUzf2/aqxgjsadbjcayfJEHixe5pgk1r5t7QPIov9omo
qQ8ENVuCV2wZFMp3st+rNoISV96yOpVCbHwuVS0QGGa9zT2HHHwulN+qFjr4
udn9GbbtFPf7q6YS3hPEResKTWsM+mtL+wQWgn1dhiOmBcc/iXvz4QefGNRK
gk9ls/pNET5lihlm3Z80xIObM8nAupzQWd9FwE/PHOazfVLcFrXLWwnyrk/y
v1kZ/N/HfzLMNrk=
       "]]}, 
     {CapForm["Butt"], JoinForm[{"Miter", 10.}], 
      JoinedCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
       229.82800000000003`, 77.57799999999999}, {229.82800000000003`, 
       68.223}, {222.24599999999998`, 60.637}, {212.88700000000003`, 
       60.637}, {203.531, 60.637}, {195.945, 68.223}, {195.945, 
       77.57799999999999}, {195.945, 86.93400000000001}, {203.531, 94.52}, {
       212.88700000000003`, 94.52}, {222.24599999999998`, 94.52}, {
       229.82800000000003`, 86.93400000000001}, {229.82800000000003`, 
       77.57799999999999}}},
       CurveClosed->{0}], 
      FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{215.47995890875004`, 
        77.11208734874998}, {215.47995890875004`, 76.21519671749999}, {
        214.06680928000003`, 76.21519671749999}, {214.06680928000003`, 
        73.87890599999999}, {212.97304021750003`, 73.87890599999999}, {
        212.97304021750003`, 76.21519671749999}, {209.03984666875002`, 
        76.21519671749999}, {209.03984666875002`, 77.11208734874998}, {
        213.44992352875002`, 83.32907069999999}, {214.06680928000003`, 
        83.32907069999999}, {214.06680928000003`, 77.11208734874998}, {
        215.47995890875004`, 77.11208734874998}}, {{212.97304021750003`, 
        77.11208734874998}, {212.97304021750003`, 81.91373353312498}, {
        209.59985642875003`, 77.11208734874998}, {212.97304021750003`, 
        77.11208734874998}}}]}, 
     {RGBColor[0.890196, 0.10196100000000001`, 0.109804], Thickness[
      0.00854700854700