(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     68376,       1696]
NotebookOptionsPosition[     67321,       1670]
NotebookOutlinePosition[     67655,       1685]
CellTagsIndexPosition[     67612,       1682]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.826544729615787*^9, 
  3.826544737556614*^9}},ExpressionUUID->"81067e45-d060-4a2e-8b07-\
4dab22b88a60"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CaseUnion", "[", 
   RowBox[{"ex_", ",", "pat_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{"ex", ",", "pat", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], "//", "Union"}]}], "\n", 
 RowBox[{
  RowBox[{"CaseUnion", "[", "pat_", "]"}], ":=", 
  RowBox[{
   RowBox[{"CaseUnion", "[", 
    RowBox[{"#", ",", "pat"}], "]"}], "&"}]}]}], "Input",ExpressionUUID->\
"93b28cb7-2b88-459a-a71f-eb020f61f21e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Get", "[", "\"\<fullamplitude.m\>\"", "]"}], "//", 
   RowBox[{"CaseUnion", "[", 
    RowBox[{
     RowBox[{"c_", "*", 
      RowBox[{"Coef", "[", "a_", "]"}]}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a"}], "}"}]}], "]"}]}], "//", "TableForm"}]], "Input",\
ExpressionUUID->"1b4a606a-11eb-4d49-a1db-771cee18be25"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SuperscriptBox["gs", "2"], " ", "Na", " ", "SumQf2", " ", "Tf"}], 
     RowBox[{
      FractionBox[
       RowBox[{"16", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "ep"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"2", " ", "ep"}], "+", 
          SuperscriptBox["ep", "2"]}], ")"}], " ", 
        RowBox[{"B", "[", 
         RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0"}], 
         "]"}]}], 
       RowBox[{
        SuperscriptBox["ep", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}]}]], "-", 
      FractionBox[
       RowBox[{"4", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "ep"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", "ep", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["ep", "2"]}]}], ")"}], " ", "sqrq", " ", 
        RowBox[{"B", "[", 
         RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1"}], 
         "]"}]}], 
       RowBox[{"ep", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}]}]]}]},
    {
     RowBox[{
      SuperscriptBox["gs", "2"], " ", "Na", " ", "SumQt2", " ", "Tf"}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "ep"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "mt2"}], "+", 
           RowBox[{"32", " ", "ep", " ", "mt2"}], "-", 
           RowBox[{"40", " ", 
            SuperscriptBox["ep", "2"], " ", "mt2"}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["ep", "3"], " ", "mt2"}], "-", 
           RowBox[{"2", " ", "sqrq"}], "+", 
           RowBox[{"3", " ", "ep", " ", "sqrq"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["ep", "2"], " ", "sqrq"}]}], ")"}], " ", 
         RowBox[{"B", "[", 
          RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0"}], 
          "]"}]}], 
        RowBox[{"ep", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"2", " ", "ep"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "ep"}]}], ")"}], " ", "mt2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "mt2"}], "-", "sqrq"}], ")"}]}]]}], "+", 
      FractionBox[
       RowBox[{"8", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "ep"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           SuperscriptBox["mt2", "2"]}], "-", 
          RowBox[{"20", " ", "ep", " ", 
           SuperscriptBox["mt2", "2"]}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["ep", "2"], " ", 
           SuperscriptBox["mt2", "2"]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["ep", "3"], " ", 
           SuperscriptBox["mt2", "2"]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["ep", "2"], " ", "mt2", " ", "sqrq"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["ep", "3"], " ", "mt2", " ", "sqrq"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["ep", "4"], " ", "mt2", " ", "sqrq"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["sqrq", "2"]}], "-", 
          RowBox[{"5", " ", "ep", " ", 
           SuperscriptBox["sqrq", "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["ep", "2"], " ", 
           SuperscriptBox["sqrq", "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["ep", "3"], " ", 
           SuperscriptBox["sqrq", "2"]}]}], ")"}], " ", 
        RowBox[{"B", "[", 
         RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0"}], 
         "]"}]}], 
       RowBox[{"ep", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}], " ", "mt2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "mt2"}], "-", "sqrq"}], ")"}]}]], "-", 
      FractionBox[
       RowBox[{"4", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           SuperscriptBox["mt2", "2"]}], "-", 
          RowBox[{"4", " ", "ep", " ", "mt2", " ", "sqrq"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["ep", "2"], " ", "mt2", " ", "sqrq"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["ep", "3"], " ", "mt2", " ", "sqrq"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["sqrq", "2"]}], "-", 
          RowBox[{"3", " ", "ep", " ", 
           SuperscriptBox["sqrq", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["ep", "2"], " ", 
           SuperscriptBox["sqrq", "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["ep", "3"], " ", 
           SuperscriptBox["sqrq", "2"]}]}], ")"}], " ", 
        RowBox[{"B", "[", 
         RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1"}], 
         "]"}]}], 
       RowBox[{"ep", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "mt2"}], "-", "sqrq"}], ")"}]}]], "-", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "ep"}], ")"}], " ", 
       RowBox[{"B", "[", 
        RowBox[{"2", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0"}], 
        "]"}]}], "-", 
      FractionBox[
       RowBox[{"8", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "ep"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", "mt2"}], "-", 
          RowBox[{"4", " ", "ep", " ", "mt2"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["ep", "2"], " ", "mt2"}], "-", 
          RowBox[{"2", " ", "sqrq"}], "+", 
          RowBox[{"3", " ", "ep", " ", "sqrq"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["ep", "2"], " ", "sqrq"}]}], ")"}], " ", 
        RowBox[{"B", "[", 
         RowBox[{"2", ",", "1", ",", "0", ",", "1", ",", "2", ",", "0"}], 
         "]"}]}], 
       RowBox[{"ep", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "ep"}]}], ")"}]}]]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.826540347920466*^9, 3.826540382102882*^9, {3.8265404262668343`*^9, 
   3.8265404346174307`*^9}, 3.826540677917974*^9, 3.826544171549074*^9, 
   3.826544661877714*^9, 3.826544763231286*^9, 3.82654485219958*^9, 
   3.8265449150184593`*^9},ExpressionUUID->"3baed5f3-d775-4ec7-9cd9-\
46de3d0a737c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Get", "[", "\"\<fullvalue.m\>\"", "]"}], "//", 
   RowBox[{"CaseUnion", "[", 
    RowBox[{
     RowBox[{"c_", "*", 
      RowBox[{"Coef", "[", 
       RowBox[{"a_", ",", "b_"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"TableForm", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "}"}]}], "]"}]}], "//", 
  "TableForm"}]], "Input",ExpressionUUID->"a84933d7-7e9c-41fe-9265-\
0b6271df9a5c"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SuperscriptBox["gs", "2"], " ", "Na", " ", "SumQf2", " ", "Tf"}], 
     TagBox[
      TagBox[GridBox[{
         {
          InterpretationBox[
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{"3.5089226328992795`*^-6", "+", 
               RowBox[{"1.372021607881635`*^-6", " ", "\[ImaginaryI]"}]}], 
              SuperscriptBox["ep", "4"]]}], "-", 
            FractionBox[
             RowBox[{"1.9394727761579134`*^-6", "-", 
              RowBox[{"0.00002836070513945188`", " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "3"]], "-", 
            FractionBox[
             RowBox[{"0.000234600459528167`", "\[VeryThinSpace]", "-", 
              RowBox[{"0.9998627309440824`", " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "2"]], "-", 
            FractionBox[
             RowBox[{"6.283332243004224`", "\[VeryThinSpace]", "+", 
              RowBox[{"0.7592514711629264`", " ", "\[ImaginaryI]"}]}], "ep"], 
            "+", 
            InterpretationBox[
             SuperscriptBox[
              RowBox[{"O", "[", "ep", "]"}], "0"],
             SeriesData[$CellContext`ep, 0, {}, -4, 0, 1],
             Editable->False]}],
           SeriesData[$CellContext`ep, 0, {
             Complex[-3.5089226328992795`*^-6, -1.372021607881635*^-6], 
             Complex[-1.9394727761579134`*^-6, 0.00002836070513945188], 
             Complex[-0.000234600459528167, 0.9998627309440824], 
             Complex[-6.283332243004224, -0.7592514711629264]}, -4, 0, 1],
           Editable->False]},
         {
          InterpretationBox[
           RowBox[{
            FractionBox[
             RowBox[{
             "0.0006062296541703515034855463470455466666666006504330271692`17.\
958728435441543", "-", 
              RowBox[{
              "0.0002573284814505989973333333333333333333334675860578175876`\
17.440451080525527", " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "4"]], "+", 
            FractionBox[
             RowBox[{
             "0.0021161285366202699539643583038593532655987803089966713006`17.\
242358055320018", "-", 
              RowBox[{
              "0.0024628858692258338797908254466166786405977201524856693334`\
17.251359887218538", " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "3"]], "+", 
            FractionBox[
             RowBox[{
             "0.01774019546429569396281245424067176363`17.072953243236203", 
              "-", 
              RowBox[{
              "0.01961507072317576457246496012252430367`17.095106210742852", 
               " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "2"]], "+", 
            FractionBox[
             RowBox[{
             "0.06140353036975381421657029442489918517`16.90112423132728", 
              "-", 
              RowBox[{
              "0.04838298886062138029666459971872645429`16.783224644678185", 
               " ", "\[ImaginaryI]"}]}], "ep"], "+", 
            InterpretationBox[
             SuperscriptBox[
              RowBox[{"O", "[", "ep", "]"}], "0"],
             SeriesData[$CellContext`ep, 0, {}, -4, 0, 1],
             Editable->False]}],
           SeriesData[$CellContext`ep, 0, {
             Complex[
             0.0006062296541703515034855463470455466666666006504330271692`17.\
958728435441543, \
-0.0002573284814505989973333333333333333333334675860578175876`17.\
440451080525527], 
             Complex[
             0.0021161285366202699539643583038593532655987803089966713006`17.\
242358055320018, \
-0.0024628858692258338797908254466166786405977201524856693334`17.\
251359887218538], 
             Complex[
             0.01774019546429569396281245424067176363`17.072953243236203, \
-0.01961507072317576457246496012252430367`17.095106210742852], 
             Complex[
             0.06140353036975381421657029442489918517`16.90112423132728, \
-0.04838298886062138029666459971872645429`16.783224644678185]}, -4, 0, 1],
           Editable->False]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column],
      Function[BoxForm`e$, 
       TableForm[BoxForm`e$]]]},
    {
     RowBox[{
      SuperscriptBox["gs", "2"], " ", "Na", " ", "SumQt2", " ", "Tf"}], 
     TagBox[
      TagBox[GridBox[{
         {
          InterpretationBox[
           RowBox[{
            FractionBox[
             RowBox[{
             "0.0000231304375850923410352380952380952380952219890028103158`17.\
149844701058967", "+", 
              RowBox[{
              "0.00001153315446086952380952380952380956`11.290745718044244", 
               " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "4"]], "+", 
            FractionBox[
             RowBox[{"0.00014566727415717438`", "\[VeryThinSpace]", "-", 
              RowBox[{"0.000015346522968862075`", " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "3"]], "+", 
            FractionBox[
             RowBox[{"0.0003469830309034864`", "\[VeryThinSpace]", "-", 
              RowBox[{"3.447596262400779`", " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "2"]], "+", 
            FractionBox[
             RowBox[{"0.001755491800539117`", "\[VeryThinSpace]", "+", 
              RowBox[{"8.044898355602752`", " ", "\[ImaginaryI]"}]}], "ep"], 
            "+", 
            RowBox[{"(", 
             RowBox[{"0.002941832921521461`", "\[VeryThinSpace]", "-", 
              RowBox[{"36.164925692699356`", " ", "\[ImaginaryI]"}]}], ")"}], 
            "+", 
            InterpretationBox[
             SuperscriptBox[
              RowBox[{"O", "[", "ep", "]"}], "1"],
             SeriesData[$CellContext`ep, 0, {}, -4, 1, 1],
             Editable->False]}],
           SeriesData[$CellContext`ep, 0, {
             Complex[
             0.0000231304375850923410352380952380952380952219890028103158`17.\
149844701058967, 0.00001153315446086952380952380952380956`11.290745718044244], 
             Complex[0.00014566727415717438`, -0.000015346522968862075`], 
             Complex[0.0003469830309034864, -3.447596262400779], 
             Complex[0.001755491800539117, 8.044898355602752], 
             Complex[0.002941832921521461, -36.164925692699356`]}, -4, 1, 1],
           Editable->False]},
         {
          InterpretationBox[
           RowBox[{
            FractionBox[
             RowBox[{
             "0.00220309423952654381701021907615664762`16.796020649925374", 
              "-", 
              RowBox[{
              "0.0015601344743844366701792142857142857147252618350510997503`\
16.727212603522045", " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "4"]], "-", 
            FractionBox[
             RowBox[{
             "0.08770157246937057582653752564785857746`17.271760704677675", 
              "-", 
              RowBox[{
              "0.06923389654974609210131618486010842562`17.223234442024847", 
               " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "3"]], "-", 
            FractionBox[
             RowBox[{
             "0.37114961883907239720255938048533526971`17.01457059501709", 
              "-", 
              RowBox[{
              "0.40280284166700079603657154391117386273`17.107779640703072", 
               " ", "\[ImaginaryI]"}]}], 
             SuperscriptBox["ep", "2"]], "-", 
            FractionBox[
             RowBox[{
             "1.90183684606364399242817439048246130072`16.943031592403287", 
              "-", 
              RowBox[{
              "1.91304413058027114547345479870243042629`17.03381693183655", 
               " ", "\[ImaginaryI]"}]}], "ep"], "-", 
            RowBox[{"(", 
             RowBox[{
             "5.87857599962421023131235913281404722967`16.75024038541708", 
              "-", 
              RowBox[{
              "6.76999319167156239798528426024548548777`16.938056680032954", 
               " ", "\[ImaginaryI]"}]}], ")"}], "+", 
            InterpretationBox[
             SuperscriptBox[
              RowBox[{"O", "[", "ep", "]"}], "1"],
             SeriesData[$CellContext`ep, 0, {}, -4, 1, 1],
             Editable->False]}],
           SeriesData[$CellContext`ep, 0, {
             Complex[
             0.00220309423952654381701021907615664762`16.796020649925374, \
-0.0015601344743844366701792142857142857147252618350510997503`16.\
727212603522045], 
             
             Complex[-0.08770157246937057582653752564785857746`17.\
271760704677675, 0.06923389654974609210131618486010842562`17.223234442024847], 
             
             Complex[-0.37114961883907239720255938048533526971`17.\
01457059501709, 0.40280284166700079603657154391117386273`17.107779640703072], 
             
             
             Complex[-1.90183684606364399242817439048246130072`16.\
943031592403287, 1.91304413058027114547345479870243042629`17.03381693183655], 
             
             
             Complex[-5.87857599962421023131235913281404722967`16.\
75024038541708, 
              6.76999319167156239798528426024548548777`16.938056680032954]}, \
-4, 1, 1],
           Editable->False]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column],
      Function[BoxForm`e$, 
       TableForm[BoxForm`e$]]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.826539704207793*^9, 3.826539723880755*^9}, {
   3.82653984692345*^9, 3.82653985656503*^9}, {3.826540426123304*^9, 
   3.826540434497909*^9}, 3.826540679743712*^9, 3.826541448798223*^9, 
   3.8265446625706787`*^9, 3.82654485322615*^9, 
   3.82654491516978*^9},ExpressionUUID->"c81487d7-0b52-4dcf-ab0f-\
1d79f7d43dd8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Get", "[", "\"\<valuemap.m\>\"", "]"}], "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
    RowBox[{"TableForm", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "]"}]}]}], "//", "TableForm"}]], "Input",\

 CellChangeTimes->{{3.826540714303192*^9, 3.8265407275725117`*^9}, {
  3.8265408899896793`*^9, 
  3.826540941677697*^9}},ExpressionUUID->"5c16a270-b70e-4ce2-baff-\
a73b144eceeb"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0"}], 
        "]"}], "\[Rule]", 
       TagBox[
        TagBox[GridBox[{
           {
            InterpretationBox[
             RowBox[{
              FractionBox[
               RowBox[{"0.2499996516004417`", "\[VeryThinSpace]", "+", 
                RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], "ep"], "+", 
              RowBox[{"(", 
               RowBox[{"1.3363932736286177`", "\[VeryThinSpace]", "+", 
                RowBox[{"1.5707941377359056`", " ", "\[ImaginaryI]"}]}], 
               ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"0.13210019527346262`", "\[VeryThinSpace]", "+", 
                 RowBox[{"8.396806581476962`", " ", "\[ImaginaryI]"}]}], 
                ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"12.03077733258992`", "\[VeryThinSpace]", "-", 
                 RowBox[{"21.500850870691405`", " ", "\[ImaginaryI]"}]}], 
                ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -1, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               Complex[0.2499996516004417, 0.], 
               Complex[1.3363932736286177`, 1.5707941377359056`], 
               Complex[0.13210019527346262`, 8.396806581476962], 
               Complex[-12.03077733258992, 21.500850870691405`]}, -1, 3, 1],
             Editable->False]},
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                "0.0000244590103421457332500000000000000000000068983514105369`\
17.68946887634298", "+", 
                 RowBox[{
                 "1.1102785399400710400000000000000000000001`17.\
346461941282882*^-18", " ", "\[ImaginaryI]"}]}], "ep"]}], "-", 
              RowBox[{"(", 
               RowBox[{
               "0.0001387579552528786126719509301647369986576992654564217575`\
17.40803555859692", "+", 
                RowBox[{
                "0.000153680494409994358816748565319652514071180703321334101`\
17.487648744701286", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.001665347722174613257019025296430732918589723096855025971`\
17.465237677189126", "+", 
                 RowBox[{
                 "0.0008718419456992580183324921007331096141505715058645454507\
`17.20621542695508", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.0046234241597338619893195439054905125500621537670181899909`\
17.57671178749662", "+", 
                 RowBox[{
                 "0.0053272805044081335833580704259639917873828694716056443147\
`17.64546359447066", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -1, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.\
0000244590103421457332500000000000000000000068983514105369`17.68946887634298, \
-1.1102785399400710400000000000000000000001`17.346461941282882*^-18], 
               
               Complex[-0.\
0001387579552528786126719509301647369986576992654564217575`17.40803555859692, \
-0.000153680494409994358816748565319652514071180703321334101`17.\
487648744701286], 
               
               Complex[-0.\
001665347722174613257019025296430732918589723096855025971`17.465237677189126, \
-0.0008718419456992580183324921007331096141505715058645454507`17.\
20621542695508], 
               
               Complex[-0.\
0046234241597338619893195439054905125500621537670181899909`17.57671178749662, \
-0.0053272805044081335833580704259639917873828694716056443147`17.\
64546359447066]}, -1, 3, 1],
             Editable->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]}]},
     {
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1"}], 
        "]"}], "\[Rule]", 
       TagBox[
        TagBox[GridBox[{
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{"0.999999635417972655`17.30102983732799", "-", 
                 RowBox[{
                 "2.6316919746744597700000000000000000000004092697054362`17.\
721265051758024*^-6", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "4.84555456622678467397299605595412336091`17.720243275100344", 
                "+", 
                RowBox[{
                "6.28316986515472725657300829060713083186`17.099208759943693",
                  " ", "\[ImaginaryI]"}]}], "ep"], "+", 
              RowBox[{"(", 
               RowBox[{
               "3.64432601692864737859963962769270422021`16.64534940163775", 
                "-", 
                RowBox[{
                "30.44546423912263374620443496998057626558`17.\
518422254303605", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "53.19263284330203232150821744634750236458`16.\
954492095973876", "-", 
                 RowBox[{
                 "59.78457079913170524712515689586514761729`17.\
258540620680954", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "152.63072363947719655097069356376775279343`17.\
055173549431924", "-", 
                 RowBox[{
                 "66.42578844059378516244486229280071422309`16.\
827430112606187", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.999999635417972655`17.30102983732799, 
                2.6316919746744597700000000000000000000004092697054362`17.\
721265051758024*^-6], 
               
               Complex[-4.84555456622678467397299605595412336091`17.\
720243275100344, \
-6.28316986515472725657300829060713083186`17.099208759943693], 
               Complex[
               3.64432601692864737859963962769270422021`16.64534940163775, \
-30.44546423912263374620443496998057626558`17.518422254303605], 
               Complex[
               53.19263284330203232150821744634750236458`16.954492095973876, \
-59.78457079913170524712515689586514761729`17.258540620680954], 
               Complex[
               152.63072363947719655097069356376775279343`17.055173549431924, \
-66.42578844059378516244486229280071422309`16.827430112606187]}, -2, 3, 1],
             Editable->False]},
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                "0.0000951603197193663150000000000000000000000730961377210428`\
17.279485888173003", "+", 
                 RowBox[{
                 "0.0004546722406277591864999999999999999999999504878247703765\
`17.958728435441554", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.0017246819482766906971504224884889731622597318120698976926`\
17.502486684934883", "+", 
                RowBox[{
                "0.0018761558380541455902015730364755807516479152583250638615`\
17.53904657626846", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "0.01170362334374749150884323186512554821`17.312053086321292", 
                "+", 
                RowBox[{
                "0.01241081424661580900554403231744682081`17.337533025377216",
                  " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.04657694982193680537357077705633257134`17.579919093965287",
                  "+", 
                 RowBox[{
                 "0.04879983512488991578043967931053408416`17.\
600166404114123", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.13558141281710283714906583852697036027`17.522915662619898",
                  "+", 
                 RowBox[{
                 "0.15384763893581360255652407131727187202`17.\
254257169434933", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.\
0000951603197193663150000000000000000000000730961377210428`17.279485888173003,\
 -0.0004546722406277591864999999999999999999999504878247703765`17.\
958728435441554], 
               
               Complex[-0.\
0017246819482766906971504224884889731622597318120698976926`17.502486684934883,\
 -0.0018761558380541455902015730364755807516479152583250638615`17.\
53904657626846], 
               
               Complex[-0.01170362334374749150884323186512554821`17.\
312053086321292, \
-0.01241081424661580900554403231744682081`17.337533025377216], 
               
               Complex[-0.04657694982193680537357077705633257134`17.\
579919093965287, \
-0.04879983512488991578043967931053408416`17.600166404114123], 
               
               Complex[-0.13558141281710283714906583852697036027`17.\
522915662619898, \
-0.15384763893581360255652407131727187202`17.254257169434933]}, -2, 3, 1],
             Editable->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]}]},
     {
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0"}], 
        "]"}], "\[Rule]", 
       TagBox[
        TagBox[GridBox[{
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               
               FractionBox[
                "7.99999999999924860000000000000000000001`17.204119982655886", 
                SuperscriptBox["ep", "2"]]}], "+", 
              FractionBox[
               RowBox[{"12.325866635221011`", "\[VeryThinSpace]", "+", 
                RowBox[{"0.000028831584743583743`", " ", "\[ImaginaryI]"}]}], 
               "ep"], "-", 
              RowBox[{"(", 
               RowBox[{"26.654766529594802`", "\[VeryThinSpace]", "-", 
                RowBox[{"1.6607910635383552`*^-6", " ", "\[ImaginaryI]"}]}], 
               ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"35.05912247277472`", "\[VeryThinSpace]", "-", 
                 RowBox[{"0.00024289588704594375`", " ", "\[ImaginaryI]"}]}], 
                ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"52.74640373049111`", "\[VeryThinSpace]", "-", 
                 RowBox[{"0.0008930181841557226`", " ", "\[ImaginaryI]"}]}], 
                ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             
             SeriesData[$CellContext`ep, 
              0, {-7.99999999999924860000000000000000000001`17.\
204119982655886, 
               Complex[12.325866635221011`, 0.000028831584743583743`], 
               Complex[-26.654766529594802`, 1.6607910635383552`*^-6], 
               Complex[35.05912247277472, -0.00024289588704594375`], 
               Complex[-52.74640373049111, 0.0008930181841557226]}, -2, 3, 1],
             
             Editable->False]},
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                "1.92228815351048236499999999999999999999975522245061`17.\
58484848518771*^-8", "+", 
                 RowBox[{
                 "1.1102785399400710400000000000000000000001`17.\
346461941282882*^-18", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.02359027722588659709178835563838855551`17.67376267305285", 
                "+", 
                RowBox[{
                "0.0302044067784791601388167485653196525139602542603750342655`\
17.78110030616936", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "0.05599131006577258306870900410694562299`17.783019086706215", 
                "+", 
                RowBox[{
                "0.10052998070395162010271458371972809533`17.268073266369257",
                  " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.18748169591440818032750172688754238625`17.699336960281137",
                  "+", 
                 RowBox[{
                 "0.34639340790484358462159524996204637251`17.\
458527648110323", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.32709872083070727218948325776470921524`17.753960758021734",
                  "+", 
                 RowBox[{
                 "0.74734367206039033776845082401610472335`17.27712017269551",
                   " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-1.92228815351048236499999999999999999999975522245061`\
17.58484848518771*^-8, \
-1.1102785399400710400000000000000000000001`17.346461941282882*^-18], 
               
               Complex[-0.02359027722588659709178835563838855551`17.\
67376267305285, \
-0.0302044067784791601388167485653196525139602542603750342655`17.\
78110030616936], 
               
               Complex[-0.05599131006577258306870900410694562299`17.\
783019086706215, \
-0.10052998070395162010271458371972809533`17.268073266369257], 
               
               Complex[-0.18748169591440818032750172688754238625`17.\
699336960281137, \
-0.34639340790484358462159524996204637251`17.458527648110323], 
               
               Complex[-0.32709872083070727218948325776470921524`17.\
753960758021734, \
-0.74734367206039033776845082401610472335`17.27712017269551]}, -2, 3, 1],
             Editable->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]}]},
     {
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0"}], 
        "]"}], "\[Rule]", 
       TagBox[
        TagBox[GridBox[{
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{"2.000001098186347195`17.602060229796034", "-", 
                 RowBox[{
                 "3.7905112770278259850000000000000000000003942017735514`17.\
879727788697004*^-6", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "+", 
              FractionBox[
               RowBox[{
               "2.90577644895932237132113145177885859857`17.49816198606634", 
                "+", 
                RowBox[{
                "0.0000200491780239874289757032635660991396591250698237425579`\
17.567874239294277", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "6.40239540846327599786146043037805791755`17.232720813183775", 
                "-", 
                RowBox[{
                "0.0000330688785787973656327456366324981769837286138546851786`\
17.64138485983414", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "8.1933167974243682582973584845779891602`16.902146911531926", 
                 "-", 
                 RowBox[{
                 "0.0000506654709003353393621714207699833340140254751388273784\
`16.7979621494269", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "12.44746726537991170325418741897829301609`16.\
680815055694037", "-", 
                 RowBox[{
                 "0.0005568063840609299330796088939003227782702434311345307331\
`16.984404008974963", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-2.000001098186347195`17.602060229796034, 
                3.7905112770278259850000000000000000000003942017735514`17.\
879727788697004*^-6], 
               Complex[
               2.90577644895932237132113145177885859857`17.49816198606634, 
                0.0000200491780239874289757032635660991396591250698237425579`\
17.567874239294277], 
               
               Complex[-6.40239540846327599786146043037805791755`17.\
232720813183775, 
                0.0000330688785787973656327456366324981769837286138546851786`\
17.64138485983414], 
               Complex[
               8.1933167974243682582973584845779891602`16.902146911531926, \
-0.0000506654709003353393621714207699833340140254751388273784`16.\
7979621494269], 
               
               Complex[-12.44746726537991170325418741897829301609`16.\
680815055694037, 
                0.0005568063840609299330796088939003227782702434311345307331`\
16.984404008974963]}, -2, 3, 1],
             Editable->False]},
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                "0.0011644799056076671450000000000000000000004080051635718297`\
17.367161994366366", "+", 
                 RowBox[{
                 "0.0027678581760637740150000000000000000000004138867122509662\
`17.74317382894477", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.02008890824674490975997311875886210081`17.568734002364554", 
                "+", 
                RowBox[{
                "0.01767436290497500223273186372489452261`17.513121435224996",
                  " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "0.05779795463624260364305976131086599242`17.68087049940313", 
                "+", 
                RowBox[{
                "0.05666196518514635075664917151473951894`17.67224966251109", 
                 " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.18514832461668059584651545919044489276`17.671119597627968",
                  "+", 
                 RowBox[{
                 "0.16043218556900497543253821641573976181`17.\
608891311037684", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.37865365118247462568108710105033069612`17.736083568395596",
                  "+", 
                 RowBox[{
                 "0.35862786901569848057406373006494440111`17.\
712485455128462", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.\
0011644799056076671450000000000000000000004080051635718297`17.367161994366366,\
 -0.0027678581760637740150000000000000000000004138867122509662`17.\
74317382894477], 
               
               Complex[-0.02008890824674490975997311875886210081`17.\
568734002364554, \
-0.01767436290497500223273186372489452261`17.513121435224996], 
               
               Complex[-0.05779795463624260364305976131086599242`17.\
68087049940313, -0.05666196518514635075664917151473951894`17.67224966251109], 
               
               
               Complex[-0.18514832461668059584651545919044489276`17.\
671119597627968, \
-0.16043218556900497543253821641573976181`17.608891311037684], 
               
               Complex[-0.37865365118247462568108710105033069612`17.\
736083568395596, \
-0.35862786901569848057406373006494440111`17.712485455128462]}, -2, 3, 1],
             Editable->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]}]},
     {
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1"}], 
        "]"}], "\[Rule]", 
       TagBox[
        TagBox[GridBox[{
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{"1.00000622153588137`17.30103269763428", "+", 
                 RowBox[{
                 "5.4369094807060672499999999999999999999942719730152539`17.\
036382098142038*^-6", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "+", 
              FractionBox[
               RowBox[{
               "0.36506025855411943867066453527190312684`16.597264343589718", 
                "-", 
                RowBox[{
                "1.5929554024927942279259780800465978359058136085464934`16.\
527540538649955*^-6", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "3.71319512593673078421386757088518396045`16.996126092468327", 
                "+", 
                RowBox[{
                "2.367899586874800544681021155429220688018320592198897`15.\
847254447951624*^-6", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.52600014239417982546415024228453621118`15.960268669770672",
                  "+", 
                 RowBox[{
                 "0.0000919537313336936150559203708966268733872226418552334075\
`17.075805961378887", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "10.75268347189585490594744242489694455632`16.68609167083556",
                  "-", 
                 RowBox[{
                 "0.0001964412095590272335785073020503130492456410577895170007\
`16.910459655432394", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-1.00000622153588137`17.30103269763428, \
-5.4369094807060672499999999999999999999942719730152539`17.036382098142038*^-\
6], 
               Complex[
               0.36506025855411943867066453527190312684`16.597264343589718, \
-1.5929554024927942279259780800465978359058136085464934`16.527540538649955*^-\
6], 
               
               Complex[-3.71319512593673078421386757088518396045`16.\
996126092468327, \
-2.367899586874800544681021155429220688018320592198897`15.847254447951624*^-6]\
, 
               
               Complex[-0.52600014239417982546415024228453621118`15.\
960268669770672, \
-0.0000919537313336936150559203708966268733872226418552334075`17.\
075805961378887], 
               
               Complex[-10.75268347189585490594744242489694455632`16.\
68609167083556, 
                0.0001964412095590272335785073020503130492456410577895170007`\
16.910459655432394]}, -2, 3, 1],
             Editable->False]},
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                "0.0015735874569926737250000000000000000000002259013950101813`\
17.497920880843832", "+", 
                 RowBox[{
                 "0.0014712497607898022450000000000000000000003718432828636101\
`17.468716400903627", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.0023575191439973375723432792803716348248972565556450808207`\
17.407355014605596", "+", 
                RowBox[{
                "0.0025175128658504628594243145515617434654788508762619375435`\
17.435871485247898", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "0.0127373011116587504296501432015529811903817657847841292288`\
17.53145573647251", "+", 
                RowBox[{
                "0.0131892744241718881546787813543073460082495486849535967232`\
17.54659922530576", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.02076622073429658254226259330191613493`17.30604463023206", 
                 "+", 
                 RowBox[{
                 "0.02385607903002014688097658950786332709`17.\
366286229036525", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.0714002251279240643720379491983910358`17.439433643989286", 
                 "+", 
                 RowBox[{
                 "0.07727975781553232458033404163900595479`17.\
473799815250626", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.\
0015735874569926737250000000000000000000002259013950101813`17.497920880843832,\
 -0.0014712497607898022450000000000000000000003718432828636101`17.\
468716400903627], 
               
               Complex[-0.\
0023575191439973375723432792803716348248972565556450808207`17.407355014605596,\
 -0.0025175128658504628594243145515617434654788508762619375435`17.\
435871485247898], 
               
               Complex[-0.\
0127373011116587504296501432015529811903817657847841292288`17.53145573647251, \
-0.0131892744241718881546787813543073460082495486849535967232`17.\
54659922530576], 
               
               Complex[-0.02076622073429658254226259330191613493`17.\
30604463023206, -0.02385607903002014688097658950786332709`17.366286229036525], 
               
               Complex[-0.0714002251279240643720379491983910358`17.\
439433643989286, \
-0.07727975781553232458033404163900595479`17.473799815250626]}, -2, 3, 1],
             Editable->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]}]},
     {
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"2", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0"}], 
        "]"}], "\[Rule]", 
       TagBox[
        TagBox[GridBox[{
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{"1.999992148611098085`17.60205828641718", "-", 
                 RowBox[{
                 "9.700865168178344900000000000000000000005504478276819`17.\
287840464054995*^-7", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.66854103690535326133933771497382997632`16.860027857154734", 
                "+", 
                RowBox[{
                "7.29588964473870141946008197530456766621911456614578`17.\
128855923546705*^-6", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "9.24666614113507159681498350574659977965`17.392363498090642", 
                "-", 
                RowBox[{
                "0.0000240347534209356111530579471058157666290727403076796055`\
17.299797700539433", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "6.04653755264438801786437762258147145604`17.020789562496223",
                  "+", 
                 RowBox[{
                 "0.0000952702339860923466007279427893156371766008042214603138\
`17.052192556951148", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "34.75459548489612856649975949861341809866`17.\
195587047267633", "-", 
                 RowBox[{
                 "0.0002390203149014915382115112255706282049510569973581759202\
`17.194941743545616", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-1.999992148611098085`17.60205828641718, 
                9.700865168178344900000000000000000000005504478276819`17.\
287840464054995*^-7], 
               
               Complex[-0.66854103690535326133933771497382997632`16.\
860027857154734, \
-7.29588964473870141946008197530456766621911456614578`17.128855923546705*^-6],
                
               
               Complex[-9.24666614113507159681498350574659977965`17.\
392363498090642, 
                0.0000240347534209356111530579471058157666290727403076796055`\
17.299797700539433], 
               
               Complex[-6.04653755264438801786437762258147145604`17.\
020789562496223, \
-0.0000952702339860923466007279427893156371766008042214603138`17.\
052192556951148], 
               
               Complex[-34.75459548489612856649975949861341809866`17.\
195587047267633, 
                0.0002390203149014915382115112255706282049510569973581759202`\
17.194941743545616]}, -2, 3, 1],
             Editable->False]},
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                "0.0001173794729684494960000000000000000000000487536123763602`\
17.370622150872137", "+", 
                 RowBox[{
                 "0.0017723069135213676799999999999999999999993348287934745335\
`17.549568927270872", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.0029043430584882329841483272452453925563890092517097038321`\
17.728825580720457", "+", 
                RowBox[{
                "0.0040036516723073177895620872679013976610354880865033251314`\
17.637356072283705", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "0.00803942371200365014900517002253177852`17.148957668265982", 
                "+", 
                RowBox[{
                "0.01582230988780644292590037240235791149`17.625648206889785",
                  " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.02742204640113832922000155800005059834`17.34984791079451", 
                 "+", 
                 RowBox[{
                 "0.03056704551399755008906456788344788958`17.\
473940627822277", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.05532615299377644197995671020774140123`17.13364598085119", 
                 "+", 
                 RowBox[{
                 "0.08587643554039305779062160861915313204`17.\
519608072808154", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.\
0001173794729684494960000000000000000000000487536123763602`17.370622150872137,\
 -0.0017723069135213676799999999999999999999993348287934745335`17.\
549568927270872], 
               
               Complex[-0.\
0029043430584882329841483272452453925563890092517097038321`17.728825580720457,\
 -0.0040036516723073177895620872679013976610354880865033251314`17.\
637356072283705], 
               
               Complex[-0.00803942371200365014900517002253177852`17.\
148957668265982, \
-0.01582230988780644292590037240235791149`17.625648206889785], 
               
               Complex[-0.02742204640113832922000155800005059834`17.\
34984791079451, -0.03056704551399755008906456788344788958`17.473940627822277], 
               
               Complex[-0.05532615299377644197995671020774140123`17.\
13364598085119, \
-0.08587643554039305779062160861915313204`17.519608072808154]}, -2, 3, 1],
             Editable->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]}]},
     {
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"2", ",", "1", ",", "0", ",", "1", ",", "2", ",", "0"}], 
        "]"}], "\[Rule]", 
       TagBox[
        TagBox[GridBox[{
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{"0.499998037152774133`17.999998295089217", "-", 
                 RowBox[{
                 "2.425216292039086870000000000000000000000650051011132`17.\
685780472726048*^-7", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.22963920977256397129279822478372375504`17.395945830254448", 
                "+", 
                RowBox[{
                "1.0113434915299067655944495799772137714957220770760393`17.\
270676351093673*^-6", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "2.25384552312101655930958398923297174618`17.77930246726863", 
                "-", 
                RowBox[{
                "0.0000106595568388661669755834869318593188546199580486579547`\
17.27147189950219", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "1.93533724457025397135916073641682902531`17.27544381866987", 
                 "+", 
                 RowBox[{
                 "0.0000203538129582973694247916540307446980335254329817593122\
`17.220393828659518", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "8.28664115577311090991053709541062730191`17.504112595450007",
                  "-", 
                 RowBox[{
                 "0.0000699902856337726068994927748723353791281712360250127493\
`17.23575327338012", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.499998037152774133`17.999998295089217, 
                2.425216292039086870000000000000000000000650051011132`17.\
685780472726048*^-7], 
               
               Complex[-0.22963920977256397129279822478372375504`17.\
395945830254448, \
-1.0113434915299067655944495799772137714957220770760393`17.270676351093673*^-\
6], 
               
               Complex[-2.25384552312101655930958398923297174618`17.\
77930246726863, 
                0.0000106595568388661669755834869318593188546199580486579547`\
17.27147189950219], 
               
               Complex[-1.93533724457025397135916073641682902531`17.\
27544381866987, \
-0.0000203538129582973694247916540307446980335254329817593122`17.\
220393828659518], 
               
               Complex[-8.28664115577311090991053709541062730191`17.\
504112595450007, 
                0.0000699902856337726068994927748723353791281712360250127493`\
17.23575327338012]}, -2, 3, 1],
             Editable->False]},
           {
            InterpretationBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                "0.0000293448682421004511500000000000000000000069511573438397`\
17.768562159544", "+", 
                 RowBox[{
                 "0.0004430767283803419195000000000000000000000168013635111411\
`17.94750893594291", " ", "\[ImaginaryI]"}]}], 
                SuperscriptBox["ep", "2"]]}], "-", 
              FractionBox[
               RowBox[{
               "0.0008297792907221627819486623537934823038030928728394786227`\
17.216335768042978", "+", 
                RowBox[{
                "0.0010409031853145960319677374818768822758651567569029801055`\
17.283188004716493", " ", "\[ImaginaryI]"}]}], "ep"], "-", 
              RowBox[{"(", 
               RowBox[{
               "0.0022529328919056859808537962567557331463118824876584941718`\
17.374558083947587", "+", 
                RowBox[{
                "0.0041359612888412432106372723798309690164627657325510534626`\
17.535534494856623", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.0077630043095103847588337615937242516527592361462461366272`\
17.3140757770155", "+", 
                 RowBox[{
                 "0.00819717618084489762415781242879606289`17.\
317264080521426", " ", "\[ImaginaryI]"}]}], ")"}], " ", "ep"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                "0.01535339472128418630867429348523250236`17.416620541231982",
                  "+", 
                 RowBox[{
                 "0.02272901605747930820784888345014091397`17.\
514422054971956", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
               SuperscriptBox["ep", "2"]}], "+", 
              InterpretationBox[
               SuperscriptBox[
                RowBox[{"O", "[", "ep", "]"}], "3"],
               SeriesData[$CellContext`ep, 0, {}, -2, 3, 1],
               Editable->False]}],
             SeriesData[$CellContext`ep, 0, {
               
               Complex[-0.\
0000293448682421004511500000000000000000000069511573438397`17.768562159544, \
-0.0004430767283803419195000000000000000000000168013635111411`17.\
94750893594291], 
               
               Complex[-0.\
0008297792907221627819486623537934823038030928728394786227`17.216335768042978,\
 -0.0010409031853145960319677374818768822758651567569029801055`17.\
283188004716493], 
               
               Complex[-0.\
0022529328919056859808537962567557331463118824876584941718`17.374558083947587,\
 -0.0041359612888412432106372723798309690164627657325510534626`17.\
535534494856623], 
               
               Complex[-0.\
0077630043095103847588337615937242516527592361462461366272`17.3140757770155, \
-0.00819717618084489762415781242879606289`17.317264080521426], 
               
               Complex[-0.01535339472128418630867429348523250236`17.\
416620541231982, \
-0.02272901605747930820784888345014091397`17.514422054971956]}, -2, 3, 1],
             Editable->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.826540718364365*^9, 3.826540727863182*^9}, 
   3.826540849762087*^9, {3.826540890334494*^9, 3.82654094234272*^9}, 
   3.826541450677878*^9, 3.826544663405892*^9, 3.82654485433195*^9, 
   3.826544915345231*^9},ExpressionUUID->"1b061e12-96a9-4fce-b02f-\
60678fb08443"]
}, Closed]]
},
WindowSize->{1920, 1129},
WindowMargins->{{0, Automatic}, {0, Automatic}},
FrontEndVersion->"11.3 for Linux x86 (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 249, 6, 33, "Input",ExpressionUUID->"81067e45-d060-4a2e-8b07-4dab22b88a60"],
Cell[810, 28, 488, 14, 59, "Input",ExpressionUUID->"93b28cb7-2b88-459a-a71f-eb020f61f21e"],
Cell[CellGroupData[{
Cell[1323, 46, 383, 10, 33, "Input",ExpressionUUID->"1b4a606a-11eb-4d49-a1db-771cee18be25"],
Cell[1709, 58, 8111, 219, 102, "Output",ExpressionUUID->"3baed5f3-d775-4ec7-9cd9-46de3d0a737c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9857, 282, 511, 15, 33, "Input",ExpressionUUID->"a84933d7-7e9c-41fe-9265-0b6271df9a5c"],
Cell[10371, 299, 10869, 257, 152, "Output",ExpressionUUID->"c81487d7-0b52-4dcf-ab0f-1d79f7d43dd8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21277, 561, 492, 14, 33, "Input",ExpressionUUID->"5c16a270-b70e-4ce2-baff-a73b144eceeb"],
Cell[21772, 577, 45533, 1090, 486, "Output",ExpressionUUID->"1b061e12-96a9-4fce-b02f-60678fb08443"]
}, Closed]]
}
]
*)

